//go:build openbsd || darwin || freebsd || netbsd
// +build openbsd darwin freebsd netbsd

package gonix

import (
	"os"
	"syscall"
)

type xWatcher struct {
	file *os.File
	kq   int
}

func newWatcher() (xWatcher, error) {
	kq, err := syscall.Kqueue()
	return xWatcher{kq: kq}, err
}

func (x *xWatcher) watchDirectory(dirname string) error {
	dir, err := os.Open(dirname)
	if err != nil {
		return err
	}
	x.file = dir
	kev := []syscall.Kevent_t{{
		Ident:  uint64(dir.Fd()),
		Filter: syscall.EVFILT_VNODE,
		Flags:  syscall.EV_ADD | syscall.EV_CLEAR,
		Fflags: syscall.NOTE_WRITE,
	}}
	_, err = syscall.Kevent(x.kq, kev, nil, nil)
	return err
}

func (x *xWatcher) watchFile(filename string) error {
	if x.file != nil {
		x.file.Close()
		x.file = nil
	}
	file, err := os.Open(filename)
	if err != nil {
		return err
	}
	x.file = file
	kev := []syscall.Kevent_t{{
		Ident:  uint64(file.Fd()),
		Filter: syscall.EVFILT_VNODE,
		Flags:  syscall.EV_ADD | syscall.EV_CLEAR,
		Fflags: syscall.NOTE_WRITE | syscall.NOTE_DELETE,
	}}
	_, err = syscall.Kevent(x.kq, kev, nil, nil)
	return err
}

func (x *xWatcher) waitForChange() error {
	var kev [1]syscall.Kevent_t
	_, err := syscall.Kevent(x.kq, nil, kev[:], nil)
	return err
}
