package main

import (
	"strings"

	"golang.org/x/crypto/ssh"
)

type User struct {
	ID     int64
	Name   string
	Pubkey string
	Perms  string
	sshKey ssh.PublicKey
}

type sqlrow interface {
	Scan(dest ...interface{}) error
}

func scanuser(row sqlrow, user *User) error {
	err := row.Scan(&user.ID, &user.Name, &user.Pubkey, &user.Perms)
	if err != nil {
		return err
	}
	if user.Pubkey != "" {
		user.sshKey, _, _, _, err = ssh.ParseAuthorizedKey([]byte(user.Pubkey))
		if err != nil {
			elog.Printf("error parsing ssh key: %s", err)
		}
	}
	return nil
}

func getusers() []*User {
	dlog.Printf("get users")
	db := opendatabase()
	var users []*User
	rows, err := db.Query("select userid, name, pubkey, perms from users")
	if err != nil {
		elog.Panicf("error querying users: %s", err)
	}
	defer rows.Close()
	for rows.Next() {
		user := new(User)
		err = scanuser(rows, user)
		if err != nil {
			elog.Printf("error scanning user: %s", err)
			continue
		}
		users = append(users, user)
	}
	return users
}

func getuser(username string) *User {
	db := opendatabase()
	row := db.QueryRow("select userid, name, pubkey, perms from users where name = ?", username)
	user := new(User)
	err := scanuser(row, user)
	if err != nil {
		elog.Printf("error scanning user: %s", err)
		return nil
	}
	return user
}

func canwrite(username string, reponame string) bool {
	u := getuser(username)
	if u == nil {
		return false
	}
	ok := false
	for _, p := range strings.Split(u.Perms, " ") {
		if p == reponame {
			return true
		}
		if p == "*" {
			ok = true
		}
		if p == "-"+reponame {
			ok = false
		}
	}
	return ok
}
