package main

import (
	"strings"
	"sync"
	"time"
)

var busyRepos = make(map[string]time.Time)
var busyMtx sync.Mutex

func toobusy(reponame string, remote string) bool {
	googPrefixes := []string{"74.125.", "172.253."}
	for _, prefix := range googPrefixes {
		if strings.HasPrefix(remote, prefix) {
			busyMtx.Lock()
			defer busyMtx.Unlock()
			next := busyRepos[reponame]
			now := time.Now()
			if now.Before(next) {
				dlog.Printf("goog coming too fast: %s %s next: %s", reponame, remote, next)
				return true
			}
			next = now.Add(time.Hour * 24)
			busyRepos[reponame] = next
			return false
		}
	}
	return false
}

func unbusy(reponame string) {
	busyMtx.Lock()
	defer busyMtx.Unlock()
	delete(busyRepos, reponame)
}
