/* 유니코드 코드표.
   Copyright (C) 2002, 2003, 2004 HRE 개발자 그룹

   This file is part of Hangul Regular Expression Library (aka HRE).

   HRE is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   HRE is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to the Free
   Software Foundation, 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

int unicode_cho[19+1] = {
  0x3131,	/* ㄱ 0 */
  0x3132,	/* ㄲ 1 */
  0x3134,	/* ㄴ 2 */
  0x3137,	/* ㄷ 3 */
  0x3138,	/* ㄸ 4 */
  0x3139,	/* ㄹ 5 */
  0x3141,	/* ㅁ 6 */
  0x3142,	/* ㅂ 7 */
  0x3143,	/* ㅃ 8 */
  0x3145,	/* ㅅ 9 */
  0x3146,	/* ㅆ 0 */
  0x3147,	/* ㅇ 1 */
  0x3148,	/* ㅈ 2 */
  0x3149,	/* ㅉ 3 */
  0x314a,	/* ㅊ 4 */
  0x314b,	/* ㅋ 5 */
  0x314c,	/* ㅌ 6 */
  0x314d,	/* ㅍ 7 */
  0x314e,	/* ㅎ 8 */
  -1
};

int unicode_cho_mapping[30] = {
  0,	/* ㄱ */
  1,	/* ㄲ */
  -1,	/* ㄳ */
  2,	/* ㄴ */
  -1,	/* ㄵ */
  -1,	/* ㄶ */
  3,	/* ㄷ */
  4,	/* ㄸ */
  5,	/* ㄹ */
  -1,	/* ㄺ */
  -1,	/* ㄻ */
  -1,	/* ㄼ */
  -1,	/* ㄽ */
  -1,	/* ㄾ */
  -1,	/* ㄿ */
  -1,	/* ㅀ */
  6,	/* ㅁ */
  7,	/* ㅂ */
  8,	/* ㅃ */
  -1,	/* ㅄ */
  9,	/* ㅅ */
  10,	/* ㅆ */
  11,	/* ㅇ */
  12,	/* ㅈ */
  13,	/* ㅉ */
  14,	/* ㅊ */
  15,	/* ㅋ */
  16,	/* ㅌ */
  17,	/* ㅍ */
  18,	/* ㅎ */
};


int unicode_jung[21+1] = {
  0x314f,	/* ㅏ */
  0x3150,	/* ㅐ*/
  0x3151,	/* ㅑ */
  0x3152,	/* ㅒ */
  0x3153,	/* ㅓ */
  0x3154,	/* ㅔ */
  0x3155,	/* ㅕ */
  0x3156,	/* ㅖ */
  0x3157,	/* ㅗ */
  0x3158,	/* ㅘ */
  0x3159,	/* ㅙ */
  0x315a,	/* ㅚ */
  0x315b,	/* ㅛ */
  0x315c,	/* ㅜ */
  0x315d,	/* ㅝ */
  0x315e,	/* ㅞ */
  0x315f,	/* ㅟ */
  0x3160,	/* ㅠ */
  0x3161,	/* ㅡ */
  0x3162,	/* ㅢ */
  0x3163,	/* ㅣ */
  -1
};

int unicode_jong[28+1] = {
  0x0,
  0x3131,	/* ㄱ  0 */
  0x3132,	/* ㄲ  1 */
  0x3133,	/* ㄳ  2 */
  0x3134,	/* ㄴ  3 */
  0x3135,	/* ㄵ  4 */
  0x3136,	/* ㄶ  5 */
  0x3137,	/* ㄷ  6 */
  0x3139,	/* ㄹ  7 */
  0x313a,	/* ㄺ  8 */
  0x313b,	/* ㄻ  9 */
  0x313c,	/* ㄼ 10 */
  0x313d,	/* ㄽ 11 */
  0x313e,	/* ㄾ 12 */
  0x313f,	/* ㄿ 13 */
  0x3140,	/* ㅀ 14 */
  0x3141,	/* ㅁ 15 */
  0x3142,	/* ㅂ 16 */
  0x3144,	/* ㅄ 17 */
  0x3145,	/* ㅅ 18 */
  0x3146,	/* ㅆ 19 */
  0x3147,	/* ㅇ 10 */
  0x3148,	/* ㅈ 21 */
  0x314a,	/* ㅊ 22 */
  0x314b,	/* ㅋ 23 */
  0x314c,	/* ㅌ 24 */
  0x314d,	/* ㅍ 25 */
  0x314e,	/* ㅎ 26 */
  -1
};

int unicode_jong_mapping[31] = {
  1,	/* ㄱ */
  2,	/* ㄲ */
  3,	/* ㄳ */
  4,	/* ㄴ */
  5,	/* ㄵ */
  6,	/* ㄶ */
  7,	/* ㄷ */
  -1,	/* ㄸ */
  8,	/* ㄹ */
  9,	/* ㄺ */
  10,	/* ㄻ */
  11,	/* ㄼ */
  12,	/* ㄽ */
  13,	/* ㄾ */
  14,	/* ㄿ */
  15,	/* ㅀ */
  16,	/* ㅁ */
  17,	/* ㅂ */
  -1,	/* ㅃ */
  18,	/* ㅄ */
  19,	/* ㅅ */
  20,	/* ㅆ */
  21,	/* ㅇ */
  22,	/* ㅈ */
  -1,	/* ㅉ */
  23,	/* ㅊ */
  24,	/* ㅋ */
  25,	/* ㅌ */
  26,	/* ㅍ */
  27,	/* ㅎ */
};

int unicode[19][21][28] = {
  {
    {
      0xeab080,	/* 가 */
      0xeab081,	/* 각 */
      0xeab082,	/* 갂 */
      0xeab083,	/* 갃 */
      0xeab084,	/* 간 */
      0xeab085,	/* 갅 */
      0xeab086,	/* 갆 */
      0xeab087,	/* 갇 */
      0xeab088,	/* 갈 */
      0xeab089,	/* 갉 */
      0xeab08a,	/* 갊 */
      0xeab08b,	/* 갋 */
      0xeab08c,	/* 갌 */
      0xeab08d,	/* 갍 */
      0xeab08e,	/* 갎 */
      0xeab08f,	/* 갏 */
      0xeab090,	/* 감 */
      0xeab091,	/* 갑 */
      0xeab092,	/* 값 */
      0xeab093,	/* 갓 */
      0xeab094,	/* 갔 */
      0xeab095,	/* 강 */
      0xeab096,	/* 갖 */
      0xeab097,	/* 갗 */
      0xeab098,	/* 갘 */
      0xeab099,	/* 같 */
      0xeab09a,	/* 갚 */
      0xeab09b,	/* 갛 */
    },
    {
      0xeab09c,	/* 개 */
      0xeab09d,	/* 객 */
      0xeab09e,	/* 갞 */
      0xeab09f,	/* 갟 */
      0xeab0a0,	/* 갠 */
      0xeab0a1,	/* 갡 */
      0xeab0a2,	/* 갢 */
      0xeab0a3,	/* 갣 */
      0xeab0a4,	/* 갤 */
      0xeab0a5,	/* 갥 */
      0xeab0a6,	/* 갦 */
      0xeab0a7,	/* 갧 */
      0xeab0a8,	/* 갨 */
      0xeab0a9,	/* 갩 */
      0xeab0aa,	/* 갪 */
      0xeab0ab,	/* 갫 */
      0xeab0ac,	/* 갬 */
      0xeab0ad,	/* 갭 */
      0xeab0ae,	/* 갮 */
      0xeab0af,	/* 갯 */
      0xeab0b0,	/* 갰 */
      0xeab0b1,	/* 갱 */
      0xeab0b2,	/* 갲 */
      0xeab0b3,	/* 갳 */
      0xeab0b4,	/* 갴 */
      0xeab0b5,	/* 갵 */
      0xeab0b6,	/* 갶 */
      0xeab0b7,	/* 갷 */
    },
    {
      0xeab0b8,	/* 갸 */
      0xeab0b9,	/* 갹 */
      0xeab0ba,	/* 갺 */
      0xeab0bb,	/* 갻 */
      0xeab0bc,	/* 갼 */
      0xeab0bd,	/* 갽 */
      0xeab0be,	/* 갾 */
      0xeab0bf,	/* 갿 */
      0xeab180,	/* 걀 */
      0xeab181,	/* 걁 */
      0xeab182,	/* 걂 */
      0xeab183,	/* 걃 */
      0xeab184,	/* 걄 */
      0xeab185,	/* 걅 */
      0xeab186,	/* 걆 */
      0xeab187,	/* 걇 */
      0xeab188,	/* 걈 */
      0xeab189,	/* 걉 */
      0xeab18a,	/* 걊 */
      0xeab18b,	/* 걋 */
      0xeab18c,	/* 걌 */
      0xeab18d,	/* 걍 */
      0xeab18e,	/* 걎 */
      0xeab18f,	/* 걏 */
      0xeab190,	/* 걐 */
      0xeab191,	/* 걑 */
      0xeab192,	/* 걒 */
      0xeab193,	/* 걓 */
    },
    {
      0xeab194,	/* 걔 */
      0xeab195,	/* 걕 */
      0xeab196,	/* 걖 */
      0xeab197,	/* 걗 */
      0xeab198,	/* 걘 */
      0xeab199,	/* 걙 */
      0xeab19a,	/* 걚 */
      0xeab19b,	/* 걛 */
      0xeab19c,	/* 걜 */
      0xeab19d,	/* 걝 */
      0xeab19e,	/* 걞 */
      0xeab19f,	/* 걟 */
      0xeab1a0,	/* 걠 */
      0xeab1a1,	/* 걡 */
      0xeab1a2,	/* 걢 */
      0xeab1a3,	/* 걣 */
      0xeab1a4,	/* 걤 */
      0xeab1a5,	/* 걥 */
      0xeab1a6,	/* 걦 */
      0xeab1a7,	/* 걧 */
      0xeab1a8,	/* 걨 */
      0xeab1a9,	/* 걩 */
      0xeab1aa,	/* 걪 */
      0xeab1ab,	/* 걫 */
      0xeab1ac,	/* 걬 */
      0xeab1ad,	/* 걭 */
      0xeab1ae,	/* 걮 */
      0xeab1af,	/* 걯 */
    },
    {
      0xeab1b0,	/* 거 */
      0xeab1b1,	/* 걱 */
      0xeab1b2,	/* 걲 */
      0xeab1b3,	/* 걳 */
      0xeab1b4,	/* 건 */
      0xeab1b5,	/* 걵 */
      0xeab1b6,	/* 걶 */
      0xeab1b7,	/* 걷 */
      0xeab1b8,	/* 걸 */
      0xeab1b9,	/* 걹 */
      0xeab1ba,	/* 걺 */
      0xeab1bb,	/* 걻 */
      0xeab1bc,	/* 걼 */
      0xeab1bd,	/* 걽 */
      0xeab1be,	/* 걾 */
      0xeab1bf,	/* 걿 */
      0xeab280,	/* 검 */
      0xeab281,	/* 겁 */
      0xeab282,	/* 겂 */
      0xeab283,	/* 것 */
      0xeab284,	/* 겄 */
      0xeab285,	/* 겅 */
      0xeab286,	/* 겆 */
      0xeab287,	/* 겇 */
      0xeab288,	/* 겈 */
      0xeab289,	/* 겉 */
      0xeab28a,	/* 겊 */
      0xeab28b,	/* 겋 */
    },
    {
      0xeab28c,	/* 게 */
      0xeab28d,	/* 겍 */
      0xeab28e,	/* 겎 */
      0xeab28f,	/* 겏 */
      0xeab290,	/* 겐 */
      0xeab291,	/* 겑 */
      0xeab292,	/* 겒 */
      0xeab293,	/* 겓 */
      0xeab294,	/* 겔 */
      0xeab295,	/* 겕 */
      0xeab296,	/* 겖 */
      0xeab297,	/* 겗 */
      0xeab298,	/* 겘 */
      0xeab299,	/* 겙 */
      0xeab29a,	/* 겚 */
      0xeab29b,	/* 겛 */
      0xeab29c,	/* 겜 */
      0xeab29d,	/* 겝 */
      0xeab29e,	/* 겞 */
      0xeab29f,	/* 겟 */
      0xeab2a0,	/* 겠 */
      0xeab2a1,	/* 겡 */
      0xeab2a2,	/* 겢 */
      0xeab2a3,	/* 겣 */
      0xeab2a4,	/* 겤 */
      0xeab2a5,	/* 겥 */
      0xeab2a6,	/* 겦 */
      0xeab2a7,	/* 겧 */
    },
    {
      0xeab2a8,	/* 겨 */
      0xeab2a9,	/* 격 */
      0xeab2aa,	/* 겪 */
      0xeab2ab,	/* 겫 */
      0xeab2ac,	/* 견 */
      0xeab2ad,	/* 겭 */
      0xeab2ae,	/* 겮 */
      0xeab2af,	/* 겯 */
      0xeab2b0,	/* 결 */
      0xeab2b1,	/* 겱 */
      0xeab2b2,	/* 겲 */
      0xeab2b3,	/* 겳 */
      0xeab2b4,	/* 겴 */
      0xeab2b5,	/* 겵 */
      0xeab2b6,	/* 겶 */
      0xeab2b7,	/* 겷 */
      0xeab2b8,	/* 겸 */
      0xeab2b9,	/* 겹 */
      0xeab2ba,	/* 겺 */
      0xeab2bb,	/* 겻 */
      0xeab2bc,	/* 겼 */
      0xeab2bd,	/* 경 */
      0xeab2be,	/* 겾 */
      0xeab2bf,	/* 겿 */
      0xeab380,	/* 곀 */
      0xeab381,	/* 곁 */
      0xeab382,	/* 곂 */
      0xeab383,	/* 곃 */
    },
    {
      0xeab384,	/* 계 */
      0xeab385,	/* 곅 */
      0xeab386,	/* 곆 */
      0xeab387,	/* 곇 */
      0xeab388,	/* 곈 */
      0xeab389,	/* 곉 */
      0xeab38a,	/* 곊 */
      0xeab38b,	/* 곋 */
      0xeab38c,	/* 곌 */
      0xeab38d,	/* 곍 */
      0xeab38e,	/* 곎 */
      0xeab38f,	/* 곏 */
      0xeab390,	/* 곐 */
      0xeab391,	/* 곑 */
      0xeab392,	/* 곒 */
      0xeab393,	/* 곓 */
      0xeab394,	/* 곔 */
      0xeab395,	/* 곕 */
      0xeab396,	/* 곖 */
      0xeab397,	/* 곗 */
      0xeab398,	/* 곘 */
      0xeab399,	/* 곙 */
      0xeab39a,	/* 곚 */
      0xeab39b,	/* 곛 */
      0xeab39c,	/* 곜 */
      0xeab39d,	/* 곝 */
      0xeab39e,	/* 곞 */
      0xeab39f,	/* 곟 */
    },
    {
      0xeab3a0,	/* 고 */
      0xeab3a1,	/* 곡 */
      0xeab3a2,	/* 곢 */
      0xeab3a3,	/* 곣 */
      0xeab3a4,	/* 곤 */
      0xeab3a5,	/* 곥 */
      0xeab3a6,	/* 곦 */
      0xeab3a7,	/* 곧 */
      0xeab3a8,	/* 골 */
      0xeab3a9,	/* 곩 */
      0xeab3aa,	/* 곪 */
      0xeab3ab,	/* 곫 */
      0xeab3ac,	/* 곬 */
      0xeab3ad,	/* 곭 */
      0xeab3ae,	/* 곮 */
      0xeab3af,	/* 곯 */
      0xeab3b0,	/* 곰 */
      0xeab3b1,	/* 곱 */
      0xeab3b2,	/* 곲 */
      0xeab3b3,	/* 곳 */
      0xeab3b4,	/* 곴 */
      0xeab3b5,	/* 공 */
      0xeab3b6,	/* 곶 */
      0xeab3b7,	/* 곷 */
      0xeab3b8,	/* 곸 */
      0xeab3b9,	/* 곹 */
      0xeab3ba,	/* 곺 */
      0xeab3bb,	/* 곻 */
    },
    {
      0xeab3bc,	/* 과 */
      0xeab3bd,	/* 곽 */
      0xeab3be,	/* 곾 */
      0xeab3bf,	/* 곿 */
      0xeab480,	/* 관 */
      0xeab481,	/* 괁 */
      0xeab482,	/* 괂 */
      0xeab483,	/* 괃 */
      0xeab484,	/* 괄 */
      0xeab485,	/* 괅 */
      0xeab486,	/* 괆 */
      0xeab487,	/* 괇 */
      0xeab488,	/* 괈 */
      0xeab489,	/* 괉 */
      0xeab48a,	/* 괊 */
      0xeab48b,	/* 괋 */
      0xeab48c,	/* 괌 */
      0xeab48d,	/* 괍 */
      0xeab48e,	/* 괎 */
      0xeab48f,	/* 괏 */
      0xeab490,	/* 괐 */
      0xeab491,	/* 광 */
      0xeab492,	/* 괒 */
      0xeab493,	/* 괓 */
      0xeab494,	/* 괔 */
      0xeab495,	/* 괕 */
      0xeab496,	/* 괖 */
      0xeab497,	/* 괗 */
    },
    {
      0xeab498,	/* 괘 */
      0xeab499,	/* 괙 */
      0xeab49a,	/* 괚 */
      0xeab49b,	/* 괛 */
      0xeab49c,	/* 괜 */
      0xeab49d,	/* 괝 */
      0xeab49e,	/* 괞 */
      0xeab49f,	/* 괟 */
      0xeab4a0,	/* 괠 */
      0xeab4a1,	/* 괡 */
      0xeab4a2,	/* 괢 */
      0xeab4a3,	/* 괣 */
      0xeab4a4,	/* 괤 */
      0xeab4a5,	/* 괥 */
      0xeab4a6,	/* 괦 */
      0xeab4a7,	/* 괧 */
      0xeab4a8,	/* 괨 */
      0xeab4a9,	/* 괩 */
      0xeab4aa,	/* 괪 */
      0xeab4ab,	/* 괫 */
      0xeab4ac,	/* 괬 */
      0xeab4ad,	/* 괭 */
      0xeab4ae,	/* 괮 */
      0xeab4af,	/* 괯 */
      0xeab4b0,	/* 괰 */
      0xeab4b1,	/* 괱 */
      0xeab4b2,	/* 괲 */
      0xeab4b3,	/* 괳 */
    },
    {
      0xeab4b4,	/* 괴 */
      0xeab4b5,	/* 괵 */
      0xeab4b6,	/* 괶 */
      0xeab4b7,	/* 괷 */
      0xeab4b8,	/* 괸 */
      0xeab4b9,	/* 괹 */
      0xeab4ba,	/* 괺 */
      0xeab4bb,	/* 괻 */
      0xeab4bc,	/* 괼 */
      0xeab4bd,	/* 괽 */
      0xeab4be,	/* 괾 */
      0xeab4bf,	/* 괿 */
      0xeab580,	/* 굀 */
      0xeab581,	/* 굁 */
      0xeab582,	/* 굂 */
      0xeab583,	/* 굃 */
      0xeab584,	/* 굄 */
      0xeab585,	/* 굅 */
      0xeab586,	/* 굆 */
      0xeab587,	/* 굇 */
      0xeab588,	/* 굈 */
      0xeab589,	/* 굉 */
      0xeab58a,	/* 굊 */
      0xeab58b,	/* 굋 */
      0xeab58c,	/* 굌 */
      0xeab58d,	/* 굍 */
      0xeab58e,	/* 굎 */
      0xeab58f,	/* 굏 */
    },
    {
      0xeab590,	/* 교 */
      0xeab591,	/* 굑 */
      0xeab592,	/* 굒 */
      0xeab593,	/* 굓 */
      0xeab594,	/* 굔 */
      0xeab595,	/* 굕 */
      0xeab596,	/* 굖 */
      0xeab597,	/* 굗 */
      0xeab598,	/* 굘 */
      0xeab599,	/* 굙 */
      0xeab59a,	/* 굚 */
      0xeab59b,	/* 굛 */
      0xeab59c,	/* 굜 */
      0xeab59d,	/* 굝 */
      0xeab59e,	/* 굞 */
      0xeab59f,	/* 굟 */
      0xeab5a0,	/* 굠 */
      0xeab5a1,	/* 굡 */
      0xeab5a2,	/* 굢 */
      0xeab5a3,	/* 굣 */
      0xeab5a4,	/* 굤 */
      0xeab5a5,	/* 굥 */
      0xeab5a6,	/* 굦 */
      0xeab5a7,	/* 굧 */
      0xeab5a8,	/* 굨 */
      0xeab5a9,	/* 굩 */
      0xeab5aa,	/* 굪 */
      0xeab5ab,	/* 굫 */
    },
    {
      0xeab5ac,	/* 구 */
      0xeab5ad,	/* 국 */
      0xeab5ae,	/* 굮 */
      0xeab5af,	/* 굯 */
      0xeab5b0,	/* 군 */
      0xeab5b1,	/* 굱 */
      0xeab5b2,	/* 굲 */
      0xeab5b3,	/* 굳 */
      0xeab5b4,	/* 굴 */
      0xeab5b5,	/* 굵 */
      0xeab5b6,	/* 굶 */
      0xeab5b7,	/* 굷 */
      0xeab5b8,	/* 굸 */
      0xeab5b9,	/* 굹 */
      0xeab5ba,	/* 굺 */
      0xeab5bb,	/* 굻 */
      0xeab5bc,	/* 굼 */
      0xeab5bd,	/* 굽 */
      0xeab5be,	/* 굾 */
      0xeab5bf,	/* 굿 */
      0xeab680,	/* 궀 */
      0xeab681,	/* 궁 */
      0xeab682,	/* 궂 */
      0xeab683,	/* 궃 */
      0xeab684,	/* 궄 */
      0xeab685,	/* 궅 */
      0xeab686,	/* 궆 */
      0xeab687,	/* 궇 */
    },
    {
      0xeab688,	/* 궈 */
      0xeab689,	/* 궉 */
      0xeab68a,	/* 궊 */
      0xeab68b,	/* 궋 */
      0xeab68c,	/* 권 */
      0xeab68d,	/* 궍 */
      0xeab68e,	/* 궎 */
      0xeab68f,	/* 궏 */
      0xeab690,	/* 궐 */
      0xeab691,	/* 궑 */
      0xeab692,	/* 궒 */
      0xeab693,	/* 궓 */
      0xeab694,	/* 궔 */
      0xeab695,	/* 궕 */
      0xeab696,	/* 궖 */
      0xeab697,	/* 궗 */
      0xeab698,	/* 궘 */
      0xeab699,	/* 궙 */
      0xeab69a,	/* 궚 */
      0xeab69b,	/* 궛 */
      0xeab69c,	/* 궜 */
      0xeab69d,	/* 궝 */
      0xeab69e,	/* 궞 */
      0xeab69f,	/* 궟 */
      0xeab6a0,	/* 궠 */
      0xeab6a1,	/* 궡 */
      0xeab6a2,	/* 궢 */
      0xeab6a3,	/* 궣 */
    },
    {
      0xeab6a4,	/* 궤 */
      0xeab6a5,	/* 궥 */
      0xeab6a6,	/* 궦 */
      0xeab6a7,	/* 궧 */
      0xeab6a8,	/* 궨 */
      0xeab6a9,	/* 궩 */
      0xeab6aa,	/* 궪 */
      0xeab6ab,	/* 궫 */
      0xeab6ac,	/* 궬 */
      0xeab6ad,	/* 궭 */
      0xeab6ae,	/* 궮 */
      0xeab6af,	/* 궯 */
      0xeab6b0,	/* 궰 */
      0xeab6b1,	/* 궱 */
      0xeab6b2,	/* 궲 */
      0xeab6b3,	/* 궳 */
      0xeab6b4,	/* 궴 */
      0xeab6b5,	/* 궵 */
      0xeab6b6,	/* 궶 */
      0xeab6b7,	/* 궷 */
      0xeab6b8,	/* 궸 */
      0xeab6b9,	/* 궹 */
      0xeab6ba,	/* 궺 */
      0xeab6bb,	/* 궻 */
      0xeab6bc,	/* 궼 */
      0xeab6bd,	/* 궽 */
      0xeab6be,	/* 궾 */
      0xeab6bf,	/* 궿 */
    },
    {
      0xeab780,	/* 귀 */
      0xeab781,	/* 귁 */
      0xeab782,	/* 귂 */
      0xeab783,	/* 귃 */
      0xeab784,	/* 귄 */
      0xeab785,	/* 귅 */
      0xeab786,	/* 귆 */
      0xeab787,	/* 귇 */
      0xeab788,	/* 귈 */
      0xeab789,	/* 귉 */
      0xeab78a,	/* 귊 */
      0xeab78b,	/* 귋 */
      0xeab78c,	/* 귌 */
      0xeab78d,	/* 귍 */
      0xeab78e,	/* 귎 */
      0xeab78f,	/* 귏 */
      0xeab790,	/* 귐 */
      0xeab791,	/* 귑 */
      0xeab792,	/* 귒 */
      0xeab793,	/* 귓 */
      0xeab794,	/* 귔 */
      0xeab795,	/* 귕 */
      0xeab796,	/* 귖 */
      0xeab797,	/* 귗 */
      0xeab798,	/* 귘 */
      0xeab799,	/* 귙 */
      0xeab79a,	/* 귚 */
      0xeab79b,	/* 귛 */
    },
    {
      0xeab79c,	/* 규 */
      0xeab79d,	/* 귝 */
      0xeab79e,	/* 귞 */
      0xeab79f,	/* 귟 */
      0xeab7a0,	/* 균 */
      0xeab7a1,	/* 귡 */
      0xeab7a2,	/* 귢 */
      0xeab7a3,	/* 귣 */
      0xeab7a4,	/* 귤 */
      0xeab7a5,	/* 귥 */
      0xeab7a6,	/* 귦 */
      0xeab7a7,	/* 귧 */
      0xeab7a8,	/* 귨 */
      0xeab7a9,	/* 귩 */
      0xeab7aa,	/* 귪 */
      0xeab7ab,	/* 귫 */
      0xeab7ac,	/* 귬 */
      0xeab7ad,	/* 귭 */
      0xeab7ae,	/* 귮 */
      0xeab7af,	/* 귯 */
      0xeab7b0,	/* 귰 */
      0xeab7b1,	/* 귱 */
      0xeab7b2,	/* 귲 */
      0xeab7b3,	/* 귳 */
      0xeab7b4,	/* 귴 */
      0xeab7b5,	/* 귵 */
      0xeab7b6,	/* 귶 */
      0xeab7b7,	/* 귷 */
    },
    {
      0xeab7b8,	/* 그 */
      0xeab7b9,	/* 극 */
      0xeab7ba,	/* 귺 */
      0xeab7bb,	/* 귻 */
      0xeab7bc,	/* 근 */
      0xeab7bd,	/* 귽 */
      0xeab7be,	/* 귾 */
      0xeab7bf,	/* 귿 */
      0xeab880,	/* 글 */
      0xeab881,	/* 긁 */
      0xeab882,	/* 긂 */
      0xeab883,	/* 긃 */
      0xeab884,	/* 긄 */
      0xeab885,	/* 긅 */
      0xeab886,	/* 긆 */
      0xeab887,	/* 긇 */
      0xeab888,	/* 금 */
      0xeab889,	/* 급 */
      0xeab88a,	/* 긊 */
      0xeab88b,	/* 긋 */
      0xeab88c,	/* 긌 */
      0xeab88d,	/* 긍 */
      0xeab88e,	/* 긎 */
      0xeab88f,	/* 긏 */
      0xeab890,	/* 긐 */
      0xeab891,	/* 긑 */
      0xeab892,	/* 긒 */
      0xeab893,	/* 긓 */
    },
    {
      0xeab894,	/* 긔 */
      0xeab895,	/* 긕 */
      0xeab896,	/* 긖 */
      0xeab897,	/* 긗 */
      0xeab898,	/* 긘 */
      0xeab899,	/* 긙 */
      0xeab89a,	/* 긚 */
      0xeab89b,	/* 긛 */
      0xeab89c,	/* 긜 */
      0xeab89d,	/* 긝 */
      0xeab89e,	/* 긞 */
      0xeab89f,	/* 긟 */
      0xeab8a0,	/* 긠 */
      0xeab8a1,	/* 긡 */
      0xeab8a2,	/* 긢 */
      0xeab8a3,	/* 긣 */
      0xeab8a4,	/* 긤 */
      0xeab8a5,	/* 긥 */
      0xeab8a6,	/* 긦 */
      0xeab8a7,	/* 긧 */
      0xeab8a8,	/* 긨 */
      0xeab8a9,	/* 긩 */
      0xeab8aa,	/* 긪 */
      0xeab8ab,	/* 긫 */
      0xeab8ac,	/* 긬 */
      0xeab8ad,	/* 긭 */
      0xeab8ae,	/* 긮 */
      0xeab8af,	/* 긯 */
    },
    {
      0xeab8b0,	/* 기 */
      0xeab8b1,	/* 긱 */
      0xeab8b2,	/* 긲 */
      0xeab8b3,	/* 긳 */
      0xeab8b4,	/* 긴 */
      0xeab8b5,	/* 긵 */
      0xeab8b6,	/* 긶 */
      0xeab8b7,	/* 긷 */
      0xeab8b8,	/* 길 */
      0xeab8b9,	/* 긹 */
      0xeab8ba,	/* 긺 */
      0xeab8bb,	/* 긻 */
      0xeab8bc,	/* 긼 */
      0xeab8bd,	/* 긽 */
      0xeab8be,	/* 긾 */
      0xeab8bf,	/* 긿 */
      0xeab980,	/* 김 */
      0xeab981,	/* 깁 */
      0xeab982,	/* 깂 */
      0xeab983,	/* 깃 */
      0xeab984,	/* 깄 */
      0xeab985,	/* 깅 */
      0xeab986,	/* 깆 */
      0xeab987,	/* 깇 */
      0xeab988,	/* 깈 */
      0xeab989,	/* 깉 */
      0xeab98a,	/* 깊 */
      0xeab98b,	/* 깋 */
    },
  },
  {
    {
      0xeab98c,	/* 까 */
      0xeab98d,	/* 깍 */
      0xeab98e,	/* 깎 */
      0xeab98f,	/* 깏 */
      0xeab990,	/* 깐 */
      0xeab991,	/* 깑 */
      0xeab992,	/* 깒 */
      0xeab993,	/* 깓 */
      0xeab994,	/* 깔 */
      0xeab995,	/* 깕 */
      0xeab996,	/* 깖 */
      0xeab997,	/* 깗 */
      0xeab998,	/* 깘 */
      0xeab999,	/* 깙 */
      0xeab99a,	/* 깚 */
      0xeab99b,	/* 깛 */
      0xeab99c,	/* 깜 */
      0xeab99d,	/* 깝 */
      0xeab99e,	/* 깞 */
      0xeab99f,	/* 깟 */
      0xeab9a0,	/* 깠 */
      0xeab9a1,	/* 깡 */
      0xeab9a2,	/* 깢 */
      0xeab9a3,	/* 깣 */
      0xeab9a4,	/* 깤 */
      0xeab9a5,	/* 깥 */
      0xeab9a6,	/* 깦 */
      0xeab9a7,	/* 깧 */
    },
    {
      0xeab9a8,	/* 깨 */
      0xeab9a9,	/* 깩 */
      0xeab9aa,	/* 깪 */
      0xeab9ab,	/* 깫 */
      0xeab9ac,	/* 깬 */
      0xeab9ad,	/* 깭 */
      0xeab9ae,	/* 깮 */
      0xeab9af,	/* 깯 */
      0xeab9b0,	/* 깰 */
      0xeab9b1,	/* 깱 */
      0xeab9b2,	/* 깲 */
      0xeab9b3,	/* 깳 */
      0xeab9b4,	/* 깴 */
      0xeab9b5,	/* 깵 */
      0xeab9b6,	/* 깶 */
      0xeab9b7,	/* 깷 */
      0xeab9b8,	/* 깸 */
      0xeab9b9,	/* 깹 */
      0xeab9ba,	/* 깺 */
      0xeab9bb,	/* 깻 */
      0xeab9bc,	/* 깼 */
      0xeab9bd,	/* 깽 */
      0xeab9be,	/* 깾 */
      0xeab9bf,	/* 깿 */
      0xeaba80,	/* 꺀 */
      0xeaba81,	/* 꺁 */
      0xeaba82,	/* 꺂 */
      0xeaba83,	/* 꺃 */
    },
    {
      0xeaba84,	/* 꺄 */
      0xeaba85,	/* 꺅 */
      0xeaba86,	/* 꺆 */
      0xeaba87,	/* 꺇 */
      0xeaba88,	/* 꺈 */
      0xeaba89,	/* 꺉 */
      0xeaba8a,	/* 꺊 */
      0xeaba8b,	/* 꺋 */
      0xeaba8c,	/* 꺌 */
      0xeaba8d,	/* 꺍 */
      0xeaba8e,	/* 꺎 */
      0xeaba8f,	/* 꺏 */
      0xeaba90,	/* 꺐 */
      0xeaba91,	/* 꺑 */
      0xeaba92,	/* 꺒 */
      0xeaba93,	/* 꺓 */
      0xeaba94,	/* 꺔 */
      0xeaba95,	/* 꺕 */
      0xeaba96,	/* 꺖 */
      0xeaba97,	/* 꺗 */
      0xeaba98,	/* 꺘 */
      0xeaba99,	/* 꺙 */
      0xeaba9a,	/* 꺚 */
      0xeaba9b,	/* 꺛 */
      0xeaba9c,	/* 꺜 */
      0xeaba9d,	/* 꺝 */
      0xeaba9e,	/* 꺞 */
      0xeaba9f,	/* 꺟 */
    },
    {
      0xeabaa0,	/* 꺠 */
      0xeabaa1,	/* 꺡 */
      0xeabaa2,	/* 꺢 */
      0xeabaa3,	/* 꺣 */
      0xeabaa4,	/* 꺤 */
      0xeabaa5,	/* 꺥 */
      0xeabaa6,	/* 꺦 */
      0xeabaa7,	/* 꺧 */
      0xeabaa8,	/* 꺨 */
      0xeabaa9,	/* 꺩 */
      0xeabaaa,	/* 꺪 */
      0xeabaab,	/* 꺫 */
      0xeabaac,	/* 꺬 */
      0xeabaad,	/* 꺭 */
      0xeabaae,	/* 꺮 */
      0xeabaaf,	/* 꺯 */
      0xeabab0,	/* 꺰 */
      0xeabab1,	/* 꺱 */
      0xeabab2,	/* 꺲 */
      0xeabab3,	/* 꺳 */
      0xeabab4,	/* 꺴 */
      0xeabab5,	/* 꺵 */
      0xeabab6,	/* 꺶 */
      0xeabab7,	/* 꺷 */
      0xeabab8,	/* 꺸 */
      0xeabab9,	/* 꺹 */
      0xeababa,	/* 꺺 */
      0xeababb,	/* 꺻 */
    },
    {
      0xeababc,	/* 꺼 */
      0xeababd,	/* 꺽 */
      0xeababe,	/* 꺾 */
      0xeababf,	/* 꺿 */
      0xeabb80,	/* 껀 */
      0xeabb81,	/* 껁 */
      0xeabb82,	/* 껂 */
      0xeabb83,	/* 껃 */
      0xeabb84,	/* 껄 */
      0xeabb85,	/* 껅 */
      0xeabb86,	/* 껆 */
      0xeabb87,	/* 껇 */
      0xeabb88,	/* 껈 */
      0xeabb89,	/* 껉 */
      0xeabb8a,	/* 껊 */
      0xeabb8b,	/* 껋 */
      0xeabb8c,	/* 껌 */
      0xeabb8d,	/* 껍 */
      0xeabb8e,	/* 껎 */
      0xeabb8f,	/* 껏 */
      0xeabb90,	/* 껐 */
      0xeabb91,	/* 껑 */
      0xeabb92,	/* 껒 */
      0xeabb93,	/* 껓 */
      0xeabb94,	/* 껔 */
      0xeabb95,	/* 껕 */
      0xeabb96,	/* 껖 */
      0xeabb97,	/* 껗 */
    },
    {
      0xeabb98,	/* 께 */
      0xeabb99,	/* 껙 */
      0xeabb9a,	/* 껚 */
      0xeabb9b,	/* 껛 */
      0xeabb9c,	/* 껜 */
      0xeabb9d,	/* 껝 */
      0xeabb9e,	/* 껞 */
      0xeabb9f,	/* 껟 */
      0xeabba0,	/* 껠 */
      0xeabba1,	/* 껡 */
      0xeabba2,	/* 껢 */
      0xeabba3,	/* 껣 */
      0xeabba4,	/* 껤 */
      0xeabba5,	/* 껥 */
      0xeabba6,	/* 껦 */
      0xeabba7,	/* 껧 */
      0xeabba8,	/* 껨 */
      0xeabba9,	/* 껩 */
      0xeabbaa,	/* 껪 */
      0xeabbab,	/* 껫 */
      0xeabbac,	/* 껬 */
      0xeabbad,	/* 껭 */
      0xeabbae,	/* 껮 */
      0xeabbaf,	/* 껯 */
      0xeabbb0,	/* 껰 */
      0xeabbb1,	/* 껱 */
      0xeabbb2,	/* 껲 */
      0xeabbb3,	/* 껳 */
    },
    {
      0xeabbb4,	/* 껴 */
      0xeabbb5,	/* 껵 */
      0xeabbb6,	/* 껶 */
      0xeabbb7,	/* 껷 */
      0xeabbb8,	/* 껸 */
      0xeabbb9,	/* 껹 */
      0xeabbba,	/* 껺 */
      0xeabbbb,	/* 껻 */
      0xeabbbc,	/* 껼 */
      0xeabbbd,	/* 껽 */
      0xeabbbe,	/* 껾 */
      0xeabbbf,	/* 껿 */
      0xeabc80,	/* 꼀 */
      0xeabc81,	/* 꼁 */
      0xeabc82,	/* 꼂 */
      0xeabc83,	/* 꼃 */
      0xeabc84,	/* 꼄 */
      0xeabc85,	/* 꼅 */
      0xeabc86,	/* 꼆 */
      0xeabc87,	/* 꼇 */
      0xeabc88,	/* 꼈 */
      0xeabc89,	/* 꼉 */
      0xeabc8a,	/* 꼊 */
      0xeabc8b,	/* 꼋 */
      0xeabc8c,	/* 꼌 */
      0xeabc8d,	/* 꼍 */
      0xeabc8e,	/* 꼎 */
      0xeabc8f,	/* 꼏 */
    },
    {
      0xeabc90,	/* 꼐 */
      0xeabc91,	/* 꼑 */
      0xeabc92,	/* 꼒 */
      0xeabc93,	/* 꼓 */
      0xeabc94,	/* 꼔 */
      0xeabc95,	/* 꼕 */
      0xeabc96,	/* 꼖 */
      0xeabc97,	/* 꼗 */
      0xeabc98,	/* 꼘 */
      0xeabc99,	/* 꼙 */
      0xeabc9a,	/* 꼚 */
      0xeabc9b,	/* 꼛 */
      0xeabc9c,	/* 꼜 */
      0xeabc9d,	/* 꼝 */
      0xeabc9e,	/* 꼞 */
      0xeabc9f,	/* 꼟 */
      0xeabca0,	/* 꼠 */
      0xeabca1,	/* 꼡 */
      0xeabca2,	/* 꼢 */
      0xeabca3,	/* 꼣 */
      0xeabca4,	/* 꼤 */
      0xeabca5,	/* 꼥 */
      0xeabca6,	/* 꼦 */
      0xeabca7,	/* 꼧 */
      0xeabca8,	/* 꼨 */
      0xeabca9,	/* 꼩 */
      0xeabcaa,	/* 꼪 */
      0xeabcab,	/* 꼫 */
    },
    {
      0xeabcac,	/* 꼬 */
      0xeabcad,	/* 꼭 */
      0xeabcae,	/* 꼮 */
      0xeabcaf,	/* 꼯 */
      0xeabcb0,	/* 꼰 */
      0xeabcb1,	/* 꼱 */
      0xeabcb2,	/* 꼲 */
      0xeabcb3,	/* 꼳 */
      0xeabcb4,	/* 꼴 */
      0xeabcb5,	/* 꼵 */
      0xeabcb6,	/* 꼶 */
      0xeabcb7,	/* 꼷 */
      0xeabcb8,	/* 꼸 */
      0xeabcb9,	/* 꼹 */
      0xeabcba,	/* 꼺 */
      0xeabcbb,	/* 꼻 */
      0xeabcbc,	/* 꼼 */
      0xeabcbd,	/* 꼽 */
      0xeabcbe,	/* 꼾 */
      0xeabcbf,	/* 꼿 */
      0xeabd80,	/* 꽀 */
      0xeabd81,	/* 꽁 */
      0xeabd82,	/* 꽂 */
      0xeabd83,	/* 꽃 */
      0xeabd84,	/* 꽄 */
      0xeabd85,	/* 꽅 */
      0xeabd86,	/* 꽆 */
      0xeabd87,	/* 꽇 */
    },
    {
      0xeabd88,	/* 꽈 */
      0xeabd89,	/* 꽉 */
      0xeabd8a,	/* 꽊 */
      0xeabd8b,	/* 꽋 */
      0xeabd8c,	/* 꽌 */
      0xeabd8d,	/* 꽍 */
      0xeabd8e,	/* 꽎 */
      0xeabd8f,	/* 꽏 */
      0xeabd90,	/* 꽐 */
      0xeabd91,	/* 꽑 */
      0xeabd92,	/* 꽒 */
      0xeabd93,	/* 꽓 */
      0xeabd94,	/* 꽔 */
      0xeabd95,	/* 꽕 */
      0xeabd96,	/* 꽖 */
      0xeabd97,	/* 꽗 */
      0xeabd98,	/* 꽘 */
      0xeabd99,	/* 꽙 */
      0xeabd9a,	/* 꽚 */
      0xeabd9b,	/* 꽛 */
      0xeabd9c,	/* 꽜 */
      0xeabd9d,	/* 꽝 */
      0xeabd9e,	/* 꽞 */
      0xeabd9f,	/* 꽟 */
      0xeabda0,	/* 꽠 */
      0xeabda1,	/* 꽡 */
      0xeabda2,	/* 꽢 */
      0xeabda3,	/* 꽣 */
    },
    {
      0xeabda4,	/* 꽤 */
      0xeabda5,	/* 꽥 */
      0xeabda6,	/* 꽦 */
      0xeabda7,	/* 꽧 */
      0xeabda8,	/* 꽨 */
      0xeabda9,	/* 꽩 */
      0xeabdaa,	/* 꽪 */
      0xeabdab,	/* 꽫 */
      0xeabdac,	/* 꽬 */
      0xeabdad,	/* 꽭 */
      0xeabdae,	/* 꽮 */
      0xeabdaf,	/* 꽯 */
      0xeabdb0,	/* 꽰 */
      0xeabdb1,	/* 꽱 */
      0xeabdb2,	/* 꽲 */
      0xeabdb3,	/* 꽳 */
      0xeabdb4,	/* 꽴 */
      0xeabdb5,	/* 꽵 */
      0xeabdb6,	/* 꽶 */
      0xeabdb7,	/* 꽷 */
      0xeabdb8,	/* 꽸 */
      0xeabdb9,	/* 꽹 */
      0xeabdba,	/* 꽺 */
      0xeabdbb,	/* 꽻 */
      0xeabdbc,	/* 꽼 */
      0xeabdbd,	/* 꽽 */
      0xeabdbe,	/* 꽾 */
      0xeabdbf,	/* 꽿 */
    },
    {
      0xeabe80,	/* 꾀 */
      0xeabe81,	/* 꾁 */
      0xeabe82,	/* 꾂 */
      0xeabe83,	/* 꾃 */
      0xeabe84,	/* 꾄 */
      0xeabe85,	/* 꾅 */
      0xeabe86,	/* 꾆 */
      0xeabe87,	/* 꾇 */
      0xeabe88,	/* 꾈 */
      0xeabe89,	/* 꾉 */
      0xeabe8a,	/* 꾊 */
      0xeabe8b,	/* 꾋 */
      0xeabe8c,	/* 꾌 */
      0xeabe8d,	/* 꾍 */
      0xeabe8e,	/* 꾎 */
      0xeabe8f,	/* 꾏 */
      0xeabe90,	/* 꾐 */
      0xeabe91,	/* 꾑 */
      0xeabe92,	/* 꾒 */
      0xeabe93,	/* 꾓 */
      0xeabe94,	/* 꾔 */
      0xeabe95,	/* 꾕 */
      0xeabe96,	/* 꾖 */
      0xeabe97,	/* 꾗 */
      0xeabe98,	/* 꾘 */
      0xeabe99,	/* 꾙 */
      0xeabe9a,	/* 꾚 */
      0xeabe9b,	/* 꾛 */
    },
    {
      0xeabe9c,	/* 꾜 */
      0xeabe9d,	/* 꾝 */
      0xeabe9e,	/* 꾞 */
      0xeabe9f,	/* 꾟 */
      0xeabea0,	/* 꾠 */
      0xeabea1,	/* 꾡 */
      0xeabea2,	/* 꾢 */
      0xeabea3,	/* 꾣 */
      0xeabea4,	/* 꾤 */
      0xeabea5,	/* 꾥 */
      0xeabea6,	/* 꾦 */
      0xeabea7,	/* 꾧 */
      0xeabea8,	/* 꾨 */
      0xeabea9,	/* 꾩 */
      0xeabeaa,	/* 꾪 */
      0xeabeab,	/* 꾫 */
      0xeabeac,	/* 꾬 */
      0xeabead,	/* 꾭 */
      0xeabeae,	/* 꾮 */
      0xeabeaf,	/* 꾯 */
      0xeabeb0,	/* 꾰 */
      0xeabeb1,	/* 꾱 */
      0xeabeb2,	/* 꾲 */
      0xeabeb3,	/* 꾳 */
      0xeabeb4,	/* 꾴 */
      0xeabeb5,	/* 꾵 */
      0xeabeb6,	/* 꾶 */
      0xeabeb7,	/* 꾷 */
    },
    {
      0xeabeb8,	/* 꾸 */
      0xeabeb9,	/* 꾹 */
      0xeabeba,	/* 꾺 */
      0xeabebb,	/* 꾻 */
      0xeabebc,	/* 꾼 */
      0xeabebd,	/* 꾽 */
      0xeabebe,	/* 꾾 */
      0xeabebf,	/* 꾿 */
      0xeabf80,	/* 꿀 */
      0xeabf81,	/* 꿁 */
      0xeabf82,	/* 꿂 */
      0xeabf83,	/* 꿃 */
      0xeabf84,	/* 꿄 */
      0xeabf85,	/* 꿅 */
      0xeabf86,	/* 꿆 */
      0xeabf87,	/* 꿇 */
      0xeabf88,	/* 꿈 */
      0xeabf89,	/* 꿉 */
      0xeabf8a,	/* 꿊 */
      0xeabf8b,	/* 꿋 */
      0xeabf8c,	/* 꿌 */
      0xeabf8d,	/* 꿍 */
      0xeabf8e,	/* 꿎 */
      0xeabf8f,	/* 꿏 */
      0xeabf90,	/* 꿐 */
      0xeabf91,	/* 꿑 */
      0xeabf92,	/* 꿒 */
      0xeabf93,	/* 꿓 */
    },
    {
      0xeabf94,	/* 꿔 */
      0xeabf95,	/* 꿕 */
      0xeabf96,	/* 꿖 */
      0xeabf97,	/* 꿗 */
      0xeabf98,	/* 꿘 */
      0xeabf99,	/* 꿙 */
      0xeabf9a,	/* 꿚 */
      0xeabf9b,	/* 꿛 */
      0xeabf9c,	/* 꿜 */
      0xeabf9d,	/* 꿝 */
      0xeabf9e,	/* 꿞 */
      0xeabf9f,	/* 꿟 */
      0xeabfa0,	/* 꿠 */
      0xeabfa1,	/* 꿡 */
      0xeabfa2,	/* 꿢 */
      0xeabfa3,	/* 꿣 */
      0xeabfa4,	/* 꿤 */
      0xeabfa5,	/* 꿥 */
      0xeabfa6,	/* 꿦 */
      0xeabfa7,	/* 꿧 */
      0xeabfa8,	/* 꿨 */
      0xeabfa9,	/* 꿩 */
      0xeabfaa,	/* 꿪 */
      0xeabfab,	/* 꿫 */
      0xeabfac,	/* 꿬 */
      0xeabfad,	/* 꿭 */
      0xeabfae,	/* 꿮 */
      0xeabfaf,	/* 꿯 */
    },
    {
      0xeabfb0,	/* 꿰 */
      0xeabfb1,	/* 꿱 */
      0xeabfb2,	/* 꿲 */
      0xeabfb3,	/* 꿳 */
      0xeabfb4,	/* 꿴 */
      0xeabfb5,	/* 꿵 */
      0xeabfb6,	/* 꿶 */
      0xeabfb7,	/* 꿷 */
      0xeabfb8,	/* 꿸 */
      0xeabfb9,	/* 꿹 */
      0xeabfba,	/* 꿺 */
      0xeabfbb,	/* 꿻 */
      0xeabfbc,	/* 꿼 */
      0xeabfbd,	/* 꿽 */
      0xeabfbe,	/* 꿾 */
      0xeabfbf,	/* 꿿 */
      0xeb8080,	/* 뀀 */
      0xeb8081,	/* 뀁 */
      0xeb8082,	/* 뀂 */
      0xeb8083,	/* 뀃 */
      0xeb8084,	/* 뀄 */
      0xeb8085,	/* 뀅 */
      0xeb8086,	/* 뀆 */
      0xeb8087,	/* 뀇 */
      0xeb8088,	/* 뀈 */
      0xeb8089,	/* 뀉 */
      0xeb808a,	/* 뀊 */
      0xeb808b,	/* 뀋 */
    },
    {
      0xeb808c,	/* 뀌 */
      0xeb808d,	/* 뀍 */
      0xeb808e,	/* 뀎 */
      0xeb808f,	/* 뀏 */
      0xeb8090,	/* 뀐 */
      0xeb8091,	/* 뀑 */
      0xeb8092,	/* 뀒 */
      0xeb8093,	/* 뀓 */
      0xeb8094,	/* 뀔 */
      0xeb8095,	/* 뀕 */
      0xeb8096,	/* 뀖 */
      0xeb8097,	/* 뀗 */
      0xeb8098,	/* 뀘 */
      0xeb8099,	/* 뀙 */
      0xeb809a,	/* 뀚 */
      0xeb809b,	/* 뀛 */
      0xeb809c,	/* 뀜 */
      0xeb809d,	/* 뀝 */
      0xeb809e,	/* 뀞 */
      0xeb809f,	/* 뀟 */
      0xeb80a0,	/* 뀠 */
      0xeb80a1,	/* 뀡 */
      0xeb80a2,	/* 뀢 */
      0xeb80a3,	/* 뀣 */
      0xeb80a4,	/* 뀤 */
      0xeb80a5,	/* 뀥 */
      0xeb80a6,	/* 뀦 */
      0xeb80a7,	/* 뀧 */
    },
    {
      0xeb80a8,	/* 뀨 */
      0xeb80a9,	/* 뀩 */
      0xeb80aa,	/* 뀪 */
      0xeb80ab,	/* 뀫 */
      0xeb80ac,	/* 뀬 */
      0xeb80ad,	/* 뀭 */
      0xeb80ae,	/* 뀮 */
      0xeb80af,	/* 뀯 */
      0xeb80b0,	/* 뀰 */
      0xeb80b1,	/* 뀱 */
      0xeb80b2,	/* 뀲 */
      0xeb80b3,	/* 뀳 */
      0xeb80b4,	/* 뀴 */
      0xeb80b5,	/* 뀵 */
      0xeb80b6,	/* 뀶 */
      0xeb80b7,	/* 뀷 */
      0xeb80b8,	/* 뀸 */
      0xeb80b9,	/* 뀹 */
      0xeb80ba,	/* 뀺 */
      0xeb80bb,	/* 뀻 */
      0xeb80bc,	/* 뀼 */
      0xeb80bd,	/* 뀽 */
      0xeb80be,	/* 뀾 */
      0xeb80bf,	/* 뀿 */
      0xeb8180,	/* 끀 */
      0xeb8181,	/* 끁 */
      0xeb8182,	/* 끂 */
      0xeb8183,	/* 끃 */
    },
    {
      0xeb8184,	/* 끄 */
      0xeb8185,	/* 끅 */
      0xeb8186,	/* 끆 */
      0xeb8187,	/* 끇 */
      0xeb8188,	/* 끈 */
      0xeb8189,	/* 끉 */
      0xeb818a,	/* 끊 */
      0xeb818b,	/* 끋 */
      0xeb818c,	/* 끌 */
      0xeb818d,	/* 끍 */
      0xeb818e,	/* 끎 */
      0xeb818f,	/* 끏 */
      0xeb8190,	/* 끐 */
      0xeb8191,	/* 끑 */
      0xeb8192,	/* 끒 */
      0xeb8193,	/* 끓 */
      0xeb8194,	/* 끔 */
      0xeb8195,	/* 끕 */
      0xeb8196,	/* 끖 */
      0xeb8197,	/* 끗 */
      0xeb8198,	/* 끘 */
      0xeb8199,	/* 끙 */
      0xeb819a,	/* 끚 */
      0xeb819b,	/* 끛 */
      0xeb819c,	/* 끜 */
      0xeb819d,	/* 끝 */
      0xeb819e,	/* 끞 */
      0xeb819f,	/* 끟 */
    },
    {
      0xeb81a0,	/* 끠 */
      0xeb81a1,	/* 끡 */
      0xeb81a2,	/* 끢 */
      0xeb81a3,	/* 끣 */
      0xeb81a4,	/* 끤 */
      0xeb81a5,	/* 끥 */
      0xeb81a6,	/* 끦 */
      0xeb81a7,	/* 끧 */
      0xeb81a8,	/* 끨 */
      0xeb81a9,	/* 끩 */
      0xeb81aa,	/* 끪 */
      0xeb81ab,	/* 끫 */
      0xeb81ac,	/* 끬 */
      0xeb81ad,	/* 끭 */
      0xeb81ae,	/* 끮 */
      0xeb81af,	/* 끯 */
      0xeb81b0,	/* 끰 */
      0xeb81b1,	/* 끱 */
      0xeb81b2,	/* 끲 */
      0xeb81b3,	/* 끳 */
      0xeb81b4,	/* 끴 */
      0xeb81b5,	/* 끵 */
      0xeb81b6,	/* 끶 */
      0xeb81b7,	/* 끷 */
      0xeb81b8,	/* 끸 */
      0xeb81b9,	/* 끹 */
      0xeb81ba,	/* 끺 */
      0xeb81bb,	/* 끻 */
    },
    {
      0xeb81bc,	/* 끼 */
      0xeb81bd,	/* 끽 */
      0xeb81be,	/* 끾 */
      0xeb81bf,	/* 끿 */
      0xeb8280,	/* 낀 */
      0xeb8281,	/* 낁 */
      0xeb8282,	/* 낂 */
      0xeb8283,	/* 낃 */
      0xeb8284,	/* 낄 */
      0xeb8285,	/* 낅 */
      0xeb8286,	/* 낆 */
      0xeb8287,	/* 낇 */
      0xeb8288,	/* 낈 */
      0xeb8289,	/* 낉 */
      0xeb828a,	/* 낊 */
      0xeb828b,	/* 낋 */
      0xeb828c,	/* 낌 */
      0xeb828d,	/* 낍 */
      0xeb828e,	/* 낎 */
      0xeb828f,	/* 낏 */
      0xeb8290,	/* 낐 */
      0xeb8291,	/* 낑 */
      0xeb8292,	/* 낒 */
      0xeb8293,	/* 낓 */
      0xeb8294,	/* 낔 */
      0xeb8295,	/* 낕 */
      0xeb8296,	/* 낖 */
      0xeb8297,	/* 낗 */
    },
  },
  {
    {
      0xeb8298,	/* 나 */
      0xeb8299,	/* 낙 */
      0xeb829a,	/* 낚 */
      0xeb829b,	/* 낛 */
      0xeb829c,	/* 난 */
      0xeb829d,	/* 낝 */
      0xeb829e,	/* 낞 */
      0xeb829f,	/* 낟 */
      0xeb82a0,	/* 날 */
      0xeb82a1,	/* 낡 */
      0xeb82a2,	/* 낢 */
      0xeb82a3,	/* 낣 */
      0xeb82a4,	/* 낤 */
      0xeb82a5,	/* 낥 */
      0xeb82a6,	/* 낦 */
      0xeb82a7,	/* 낧 */
      0xeb82a8,	/* 남 */
      0xeb82a9,	/* 납 */
      0xeb82aa,	/* 낪 */
      0xeb82ab,	/* 낫 */
      0xeb82ac,	/* 났 */
      0xeb82ad,	/* 낭 */
      0xeb82ae,	/* 낮 */
      0xeb82af,	/* 낯 */
      0xeb82b0,	/* 낰 */
      0xeb82b1,	/* 낱 */
      0xeb82b2,	/* 낲 */
      0xeb82b3,	/* 낳 */
    },
    {
      0xeb82b4,	/* 내 */
      0xeb82b5,	/* 낵 */
      0xeb82b6,	/* 낶 */
      0xeb82b7,	/* 낷 */
      0xeb82b8,	/* 낸 */
      0xeb82b9,	/* 낹 */
      0xeb82ba,	/* 낺 */
      0xeb82bb,	/* 낻 */
      0xeb82bc,	/* 낼 */
      0xeb82bd,	/* 낽 */
      0xeb82be,	/* 낾 */
      0xeb82bf,	/* 낿 */
      0xeb8380,	/* 냀 */
      0xeb8381,	/* 냁 */
      0xeb8382,	/* 냂 */
      0xeb8383,	/* 냃 */
      0xeb8384,	/* 냄 */
      0xeb8385,	/* 냅 */
      0xeb8386,	/* 냆 */
      0xeb8387,	/* 냇 */
      0xeb8388,	/* 냈 */
      0xeb8389,	/* 냉 */
      0xeb838a,	/* 냊 */
      0xeb838b,	/* 냋 */
      0xeb838c,	/* 냌 */
      0xeb838d,	/* 냍 */
      0xeb838e,	/* 냎 */
      0xeb838f,	/* 냏 */
    },
    {
      0xeb8390,	/* 냐 */
      0xeb8391,	/* 냑 */
      0xeb8392,	/* 냒 */
      0xeb8393,	/* 냓 */
      0xeb8394,	/* 냔 */
      0xeb8395,	/* 냕 */
      0xeb8396,	/* 냖 */
      0xeb8397,	/* 냗 */
      0xeb8398,	/* 냘 */
      0xeb8399,	/* 냙 */
      0xeb839a,	/* 냚 */
      0xeb839b,	/* 냛 */
      0xeb839c,	/* 냜 */
      0xeb839d,	/* 냝 */
      0xeb839e,	/* 냞 */
      0xeb839f,	/* 냟 */
      0xeb83a0,	/* 냠 */
      0xeb83a1,	/* 냡 */
      0xeb83a2,	/* 냢 */
      0xeb83a3,	/* 냣 */
      0xeb83a4,	/* 냤 */
      0xeb83a5,	/* 냥 */
      0xeb83a6,	/* 냦 */
      0xeb83a7,	/* 냧 */
      0xeb83a8,	/* 냨 */
      0xeb83a9,	/* 냩 */
      0xeb83aa,	/* 냪 */
      0xeb83ab,	/* 냫 */
    },
    {
      0xeb83ac,	/* 냬 */
      0xeb83ad,	/* 냭 */
      0xeb83ae,	/* 냮 */
      0xeb83af,	/* 냯 */
      0xeb83b0,	/* 냰 */
      0xeb83b1,	/* 냱 */
      0xeb83b2,	/* 냲 */
      0xeb83b3,	/* 냳 */
      0xeb83b4,	/* 냴 */
      0xeb83b5,	/* 냵 */
      0xeb83b6,	/* 냶 */
      0xeb83b7,	/* 냷 */
      0xeb83b8,	/* 냸 */
      0xeb83b9,	/* 냹 */
      0xeb83ba,	/* 냺 */
      0xeb83bb,	/* 냻 */
      0xeb83bc,	/* 냼 */
      0xeb83bd,	/* 냽 */
      0xeb83be,	/* 냾 */
      0xeb83bf,	/* 냿 */
      0xeb8480,	/* 넀 */
      0xeb8481,	/* 넁 */
      0xeb8482,	/* 넂 */
      0xeb8483,	/* 넃 */
      0xeb8484,	/* 넄 */
      0xeb8485,	/* 넅 */
      0xeb8486,	/* 넆 */
      0xeb8487,	/* 넇 */
    },
    {
      0xeb8488,	/* 너 */
      0xeb8489,	/* 넉 */
      0xeb848a,	/* 넊 */
      0xeb848b,	/* 넋 */
      0xeb848c,	/* 넌 */
      0xeb848d,	/* 넍 */
      0xeb848e,	/* 넎 */
      0xeb848f,	/* 넏 */
      0xeb8490,	/* 널 */
      0xeb8491,	/* 넑 */
      0xeb8492,	/* 넒 */
      0xeb8493,	/* 넓 */
      0xeb8494,	/* 넔 */
      0xeb8495,	/* 넕 */
      0xeb8496,	/* 넖 */
      0xeb8497,	/* 넗 */
      0xeb8498,	/* 넘 */
      0xeb8499,	/* 넙 */
      0xeb849a,	/* 넚 */
      0xeb849b,	/* 넛 */
      0xeb849c,	/* 넜 */
      0xeb849d,	/* 넝 */
      0xeb849e,	/* 넞 */
      0xeb849f,	/* 넟 */
      0xeb84a0,	/* 넠 */
      0xeb84a1,	/* 넡 */
      0xeb84a2,	/* 넢 */
      0xeb84a3,	/* 넣 */
    },
    {
      0xeb84a4,	/* 네 */
      0xeb84a5,	/* 넥 */
      0xeb84a6,	/* 넦 */
      0xeb84a7,	/* 넧 */
      0xeb84a8,	/* 넨 */
      0xeb84a9,	/* 넩 */
      0xeb84aa,	/* 넪 */
      0xeb84ab,	/* 넫 */
      0xeb84ac,	/* 넬 */
      0xeb84ad,	/* 넭 */
      0xeb84ae,	/* 넮 */
      0xeb84af,	/* 넯 */
      0xeb84b0,	/* 넰 */
      0xeb84b1,	/* 넱 */
      0xeb84b2,	/* 넲 */
      0xeb84b3,	/* 넳 */
      0xeb84b4,	/* 넴 */
      0xeb84b5,	/* 넵 */
      0xeb84b6,	/* 넶 */
      0xeb84b7,	/* 넷 */
      0xeb84b8,	/* 넸 */
      0xeb84b9,	/* 넹 */
      0xeb84ba,	/* 넺 */
      0xeb84bb,	/* 넻 */
      0xeb84bc,	/* 넼 */
      0xeb84bd,	/* 넽 */
      0xeb84be,	/* 넾 */
      0xeb84bf,	/* 넿 */
    },
    {
      0xeb8580,	/* 녀 */
      0xeb8581,	/* 녁 */
      0xeb8582,	/* 녂 */
      0xeb8583,	/* 녃 */
      0xeb8584,	/* 년 */
      0xeb8585,	/* 녅 */
      0xeb8586,	/* 녆 */
      0xeb8587,	/* 녇 */
      0xeb8588,	/* 녈 */
      0xeb8589,	/* 녉 */
      0xeb858a,	/* 녊 */
      0xeb858b,	/* 녋 */
      0xeb858c,	/* 녌 */
      0xeb858d,	/* 녍 */
      0xeb858e,	/* 녎 */
      0xeb858f,	/* 녏 */
      0xeb8590,	/* 념 */
      0xeb8591,	/* 녑 */
      0xeb8592,	/* 녒 */
      0xeb8593,	/* 녓 */
      0xeb8594,	/* 녔 */
      0xeb8595,	/* 녕 */
      0xeb8596,	/* 녖 */
      0xeb8597,	/* 녗 */
      0xeb8598,	/* 녘 */
      0xeb8599,	/* 녙 */
      0xeb859a,	/* 녚 */
      0xeb859b,	/* 녛 */
    },
    {
      0xeb859c,	/* 녜 */
      0xeb859d,	/* 녝 */
      0xeb859e,	/* 녞 */
      0xeb859f,	/* 녟 */
      0xeb85a0,	/* 녠 */
      0xeb85a1,	/* 녡 */
      0xeb85a2,	/* 녢 */
      0xeb85a3,	/* 녣 */
      0xeb85a4,	/* 녤 */
      0xeb85a5,	/* 녥 */
      0xeb85a6,	/* 녦 */
      0xeb85a7,	/* 녧 */
      0xeb85a8,	/* 녨 */
      0xeb85a9,	/* 녩 */
      0xeb85aa,	/* 녪 */
      0xeb85ab,	/* 녫 */
      0xeb85ac,	/* 녬 */
      0xeb85ad,	/* 녭 */
      0xeb85ae,	/* 녮 */
      0xeb85af,	/* 녯 */
      0xeb85b0,	/* 녰 */
      0xeb85b1,	/* 녱 */
      0xeb85b2,	/* 녲 */
      0xeb85b3,	/* 녳 */
      0xeb85b4,	/* 녴 */
      0xeb85b5,	/* 녵 */
      0xeb85b6,	/* 녶 */
      0xeb85b7,	/* 녷 */
    },
    {
      0xeb85b8,	/* 노 */
      0xeb85b9,	/* 녹 */
      0xeb85ba,	/* 녺 */
      0xeb85bb,	/* 녻 */
      0xeb85bc,	/* 논 */
      0xeb85bd,	/* 녽 */
      0xeb85be,	/* 녾 */
      0xeb85bf,	/* 녿 */
      0xeb8680,	/* 놀 */
      0xeb8681,	/* 놁 */
      0xeb8682,	/* 놂 */
      0xeb8683,	/* 놃 */
      0xeb8684,	/* 놄 */
      0xeb8685,	/* 놅 */
      0xeb8686,	/* 놆 */
      0xeb8687,	/* 놇 */
      0xeb8688,	/* 놈 */
      0xeb8689,	/* 놉 */
      0xeb868a,	/* 놊 */
      0xeb868b,	/* 놋 */
      0xeb868c,	/* 놌 */
      0xeb868d,	/* 농 */
      0xeb868e,	/* 놎 */
      0xeb868f,	/* 놏 */
      0xeb8690,	/* 놐 */
      0xeb8691,	/* 놑 */
      0xeb8692,	/* 높 */
      0xeb8693,	/* 놓 */
    },
    {
      0xeb8694,	/* 놔 */
      0xeb8695,	/* 놕 */
      0xeb8696,	/* 놖 */
      0xeb8697,	/* 놗 */
      0xeb8698,	/* 놘 */
      0xeb8699,	/* 놙 */
      0xeb869a,	/* 놚 */
      0xeb869b,	/* 놛 */
      0xeb869c,	/* 놜 */
      0xeb869d,	/* 놝 */
      0xeb869e,	/* 놞 */
      0xeb869f,	/* 놟 */
      0xeb86a0,	/* 놠 */
      0xeb86a1,	/* 놡 */
      0xeb86a2,	/* 놢 */
      0xeb86a3,	/* 놣 */
      0xeb86a4,	/* 놤 */
      0xeb86a5,	/* 놥 */
      0xeb86a6,	/* 놦 */
      0xeb86a7,	/* 놧 */
      0xeb86a8,	/* 놨 */
      0xeb86a9,	/* 놩 */
      0xeb86aa,	/* 놪 */
      0xeb86ab,	/* 놫 */
      0xeb86ac,	/* 놬 */
      0xeb86ad,	/* 놭 */
      0xeb86ae,	/* 놮 */
      0xeb86af,	/* 놯 */
    },
    {
      0xeb86b0,	/* 놰 */
      0xeb86b1,	/* 놱 */
      0xeb86b2,	/* 놲 */
      0xeb86b3,	/* 놳 */
      0xeb86b4,	/* 놴 */
      0xeb86b5,	/* 놵 */
      0xeb86b6,	/* 놶 */
      0xeb86b7,	/* 놷 */
      0xeb86b8,	/* 놸 */
      0xeb86b9,	/* 놹 */
      0xeb86ba,	/* 놺 */
      0xeb86bb,	/* 놻 */
      0xeb86bc,	/* 놼 */
      0xeb86bd,	/* 놽 */
      0xeb86be,	/* 놾 */
      0xeb86bf,	/* 놿 */
      0xeb8780,	/* 뇀 */
      0xeb8781,	/* 뇁 */
      0xeb8782,	/* 뇂 */
      0xeb8783,	/* 뇃 */
      0xeb8784,	/* 뇄 */
      0xeb8785,	/* 뇅 */
      0xeb8786,	/* 뇆 */
      0xeb8787,	/* 뇇 */
      0xeb8788,	/* 뇈 */
      0xeb8789,	/* 뇉 */
      0xeb878a,	/* 뇊 */
      0xeb878b,	/* 뇋 */
    },
    {
      0xeb878c,	/* 뇌 */
      0xeb878d,	/* 뇍 */
      0xeb878e,	/* 뇎 */
      0xeb878f,	/* 뇏 */
      0xeb8790,	/* 뇐 */
      0xeb8791,	/* 뇑 */
      0xeb8792,	/* 뇒 */
      0xeb8793,	/* 뇓 */
      0xeb8794,	/* 뇔 */
      0xeb8795,	/* 뇕 */
      0xeb8796,	/* 뇖 */
      0xeb8797,	/* 뇗 */
      0xeb8798,	/* 뇘 */
      0xeb8799,	/* 뇙 */
      0xeb879a,	/* 뇚 */
      0xeb879b,	/* 뇛 */
      0xeb879c,	/* 뇜 */
      0xeb879d,	/* 뇝 */
      0xeb879e,	/* 뇞 */
      0xeb879f,	/* 뇟 */
      0xeb87a0,	/* 뇠 */
      0xeb87a1,	/* 뇡 */
      0xeb87a2,	/* 뇢 */
      0xeb87a3,	/* 뇣 */
      0xeb87a4,	/* 뇤 */
      0xeb87a5,	/* 뇥 */
      0xeb87a6,	/* 뇦 */
      0xeb87a7,	/* 뇧 */
    },
    {
      0xeb87a8,	/* 뇨 */
      0xeb87a9,	/* 뇩 */
      0xeb87aa,	/* 뇪 */
      0xeb87ab,	/* 뇫 */
      0xeb87ac,	/* 뇬 */
      0xeb87ad,	/* 뇭 */
      0xeb87ae,	/* 뇮 */
      0xeb87af,	/* 뇯 */
      0xeb87b0,	/* 뇰 */
      0xeb87b1,	/* 뇱 */
      0xeb87b2,	/* 뇲 */
      0xeb87b3,	/* 뇳 */
      0xeb87b4,	/* 뇴 */
      0xeb87b5,	/* 뇵 */
      0xeb87b6,	/* 뇶 */
      0xeb87b7,	/* 뇷 */
      0xeb87b8,	/* 뇸 */
      0xeb87b9,	/* 뇹 */
      0xeb87ba,	/* 뇺 */
      0xeb87bb,	/* 뇻 */
      0xeb87bc,	/* 뇼 */
      0xeb87bd,	/* 뇽 */
      0xeb87be,	/* 뇾 */
      0xeb87bf,	/* 뇿 */
      0xeb8880,	/* 눀 */
      0xeb8881,	/* 눁 */
      0xeb8882,	/* 눂 */
      0xeb8883,	/* 눃 */
    },
    {
      0xeb8884,	/* 누 */
      0xeb8885,	/* 눅 */
      0xeb8886,	/* 눆 */
      0xeb8887,	/* 눇 */
      0xeb8888,	/* 눈 */
      0xeb8889,	/* 눉 */
      0xeb888a,	/* 눊 */
      0xeb888b,	/* 눋 */
      0xeb888c,	/* 눌 */
      0xeb888d,	/* 눍 */
      0xeb888e,	/* 눎 */
      0xeb888f,	/* 눏 */
      0xeb8890,	/* 눐 */
      0xeb8891,	/* 눑 */
      0xeb8892,	/* 눒 */
      0xeb8893,	/* 눓 */
      0xeb8894,	/* 눔 */
      0xeb8895,	/* 눕 */
      0xeb8896,	/* 눖 */
      0xeb8897,	/* 눗 */
      0xeb8898,	/* 눘 */
      0xeb8899,	/* 눙 */
      0xeb889a,	/* 눚 */
      0xeb889b,	/* 눛 */
      0xeb889c,	/* 눜 */
      0xeb889d,	/* 눝 */
      0xeb889e,	/* 눞 */
      0xeb889f,	/* 눟 */
    },
    {
      0xeb88a0,	/* 눠 */
      0xeb88a1,	/* 눡 */
      0xeb88a2,	/* 눢 */
      0xeb88a3,	/* 눣 */
      0xeb88a4,	/* 눤 */
      0xeb88a5,	/* 눥 */
      0xeb88a6,	/* 눦 */
      0xeb88a7,	/* 눧 */
      0xeb88a8,	/* 눨 */
      0xeb88a9,	/* 눩 */
      0xeb88aa,	/* 눪 */
      0xeb88ab,	/* 눫 */
      0xeb88ac,	/* 눬 */
      0xeb88ad,	/* 눭 */
      0xeb88ae,	/* 눮 */
      0xeb88af,	/* 눯 */
      0xeb88b0,	/* 눰 */
      0xeb88b1,	/* 눱 */
      0xeb88b2,	/* 눲 */
      0xeb88b3,	/* 눳 */
      0xeb88b4,	/* 눴 */
      0xeb88b5,	/* 눵 */
      0xeb88b6,	/* 눶 */
      0xeb88b7,	/* 눷 */
      0xeb88b8,	/* 눸 */
      0xeb88b9,	/* 눹 */
      0xeb88ba,	/* 눺 */
      0xeb88bb,	/* 눻 */
    },
    {
      0xeb88bc,	/* 눼 */
      0xeb88bd,	/* 눽 */
      0xeb88be,	/* 눾 */
      0xeb88bf,	/* 눿 */
      0xeb8980,	/* 뉀 */
      0xeb8981,	/* 뉁 */
      0xeb8982,	/* 뉂 */
      0xeb8983,	/* 뉃 */
      0xeb8984,	/* 뉄 */
      0xeb8985,	/* 뉅 */
      0xeb8986,	/* 뉆 */
      0xeb8987,	/* 뉇 */
      0xeb8988,	/* 뉈 */
      0xeb8989,	/* 뉉 */
      0xeb898a,	/* 뉊 */
      0xeb898b,	/* 뉋 */
      0xeb898c,	/* 뉌 */
      0xeb898d,	/* 뉍 */
      0xeb898e,	/* 뉎 */
      0xeb898f,	/* 뉏 */
      0xeb8990,	/* 뉐 */
      0xeb8991,	/* 뉑 */
      0xeb8992,	/* 뉒 */
      0xeb8993,	/* 뉓 */
      0xeb8994,	/* 뉔 */
      0xeb8995,	/* 뉕 */
      0xeb8996,	/* 뉖 */
      0xeb8997,	/* 뉗 */
    },
    {
      0xeb8998,	/* 뉘 */
      0xeb8999,	/* 뉙 */
      0xeb899a,	/* 뉚 */
      0xeb899b,	/* 뉛 */
      0xeb899c,	/* 뉜 */
      0xeb899d,	/* 뉝 */
      0xeb899e,	/* 뉞 */
      0xeb899f,	/* 뉟 */
      0xeb89a0,	/* 뉠 */
      0xeb89a1,	/* 뉡 */
      0xeb89a2,	/* 뉢 */
      0xeb89a3,	/* 뉣 */
      0xeb89a4,	/* 뉤 */
      0xeb89a5,	/* 뉥 */
      0xeb89a6,	/* 뉦 */
      0xeb89a7,	/* 뉧 */
      0xeb89a8,	/* 뉨 */
      0xeb89a9,	/* 뉩 */
      0xeb89aa,	/* 뉪 */
      0xeb89ab,	/* 뉫 */
      0xeb89ac,	/* 뉬 */
      0xeb89ad,	/* 뉭 */
      0xeb89ae,	/* 뉮 */
      0xeb89af,	/* 뉯 */
      0xeb89b0,	/* 뉰 */
      0xeb89b1,	/* 뉱 */
      0xeb89b2,	/* 뉲 */
      0xeb89b3,	/* 뉳 */
    },
    {
      0xeb89b4,	/* 뉴 */
      0xeb89b5,	/* 뉵 */
      0xeb89b6,	/* 뉶 */
      0xeb89b7,	/* 뉷 */
      0xeb89b8,	/* 뉸 */
      0xeb89b9,	/* 뉹 */
      0xeb89ba,	/* 뉺 */
      0xeb89bb,	/* 뉻 */
      0xeb89bc,	/* 뉼 */
      0xeb89bd,	/* 뉽 */
      0xeb89be,	/* 뉾 */
      0xeb89bf,	/* 뉿 */
      0xeb8a80,	/* 늀 */
      0xeb8a81,	/* 늁 */
      0xeb8a82,	/* 늂 */
      0xeb8a83,	/* 늃 */
      0xeb8a84,	/* 늄 */
      0xeb8a85,	/* 늅 */
      0xeb8a86,	/* 늆 */
      0xeb8a87,	/* 늇 */
      0xeb8a88,	/* 늈 */
      0xeb8a89,	/* 늉 */
      0xeb8a8a,	/* 늊 */
      0xeb8a8b,	/* 늋 */
      0xeb8a8c,	/* 늌 */
      0xeb8a8d,	/* 늍 */
      0xeb8a8e,	/* 늎 */
      0xeb8a8f,	/* 늏 */
    },
    {
      0xeb8a90,	/* 느 */
      0xeb8a91,	/* 늑 */
      0xeb8a92,	/* 늒 */
      0xeb8a93,	/* 늓 */
      0xeb8a94,	/* 는 */
      0xeb8a95,	/* 늕 */
      0xeb8a96,	/* 늖 */
      0xeb8a97,	/* 늗 */
      0xeb8a98,	/* 늘 */
      0xeb8a99,	/* 늙 */
      0xeb8a9a,	/* 늚 */
      0xeb8a9b,	/* 늛 */
      0xeb8a9c,	/* 늜 */
      0xeb8a9d,	/* 늝 */
      0xeb8a9e,	/* 늞 */
      0xeb8a9f,	/* 늟 */
      0xeb8aa0,	/* 늠 */
      0xeb8aa1,	/* 늡 */
      0xeb8aa2,	/* 늢 */
      0xeb8aa3,	/* 늣 */
      0xeb8aa4,	/* 늤 */
      0xeb8aa5,	/* 능 */
      0xeb8aa6,	/* 늦 */
      0xeb8aa7,	/* 늧 */
      0xeb8aa8,	/* 늨 */
      0xeb8aa9,	/* 늩 */
      0xeb8aaa,	/* 늪 */
      0xeb8aab,	/* 늫 */
    },
    {
      0xeb8aac,	/* 늬 */
      0xeb8aad,	/* 늭 */
      0xeb8aae,	/* 늮 */
      0xeb8aaf,	/* 늯 */
      0xeb8ab0,	/* 늰 */
      0xeb8ab1,	/* 늱 */
      0xeb8ab2,	/* 늲 */
      0xeb8ab3,	/* 늳 */
      0xeb8ab4,	/* 늴 */
      0xeb8ab5,	/* 늵 */
      0xeb8ab6,	/* 늶 */
      0xeb8ab7,	/* 늷 */
      0xeb8ab8,	/* 늸 */
      0xeb8ab9,	/* 늹 */
      0xeb8aba,	/* 늺 */
      0xeb8abb,	/* 늻 */
      0xeb8abc,	/* 늼 */
      0xeb8abd,	/* 늽 */
      0xeb8abe,	/* 늾 */
      0xeb8abf,	/* 늿 */
      0xeb8b80,	/* 닀 */
      0xeb8b81,	/* 닁 */
      0xeb8b82,	/* 닂 */
      0xeb8b83,	/* 닃 */
      0xeb8b84,	/* 닄 */
      0xeb8b85,	/* 닅 */
      0xeb8b86,	/* 닆 */
      0xeb8b87,	/* 닇 */
    },
    {
      0xeb8b88,	/* 니 */
      0xeb8b89,	/* 닉 */
      0xeb8b8a,	/* 닊 */
      0xeb8b8b,	/* 닋 */
      0xeb8b8c,	/* 닌 */
      0xeb8b8d,	/* 닍 */
      0xeb8b8e,	/* 닎 */
      0xeb8b8f,	/* 닏 */
      0xeb8b90,	/* 닐 */
      0xeb8b91,	/* 닑 */
      0xeb8b92,	/* 닒 */
      0xeb8b93,	/* 닓 */
      0xeb8b94,	/* 닔 */
      0xeb8b95,	/* 닕 */
      0xeb8b96,	/* 닖 */
      0xeb8b97,	/* 닗 */
      0xeb8b98,	/* 님 */
      0xeb8b99,	/* 닙 */
      0xeb8b9a,	/* 닚 */
      0xeb8b9b,	/* 닛 */
      0xeb8b9c,	/* 닜 */
      0xeb8b9d,	/* 닝 */
      0xeb8b9e,	/* 닞 */
      0xeb8b9f,	/* 닟 */
      0xeb8ba0,	/* 닠 */
      0xeb8ba1,	/* 닡 */
      0xeb8ba2,	/* 닢 */
      0xeb8ba3,	/* 닣 */
    },
  },
  {
    {
      0xeb8ba4,	/* 다 */
      0xeb8ba5,	/* 닥 */
      0xeb8ba6,	/* 닦 */
      0xeb8ba7,	/* 닧 */
      0xeb8ba8,	/* 단 */
      0xeb8ba9,	/* 닩 */
      0xeb8baa,	/* 닪 */
      0xeb8bab,	/* 닫 */
      0xeb8bac,	/* 달 */
      0xeb8bad,	/* 닭 */
      0xeb8bae,	/* 닮 */
      0xeb8baf,	/* 닯 */
      0xeb8bb0,	/* 닰 */
      0xeb8bb1,	/* 닱 */
      0xeb8bb2,	/* 닲 */
      0xeb8bb3,	/* 닳 */
      0xeb8bb4,	/* 담 */
      0xeb8bb5,	/* 답 */
      0xeb8bb6,	/* 닶 */
      0xeb8bb7,	/* 닷 */
      0xeb8bb8,	/* 닸 */
      0xeb8bb9,	/* 당 */
      0xeb8bba,	/* 닺 */
      0xeb8bbb,	/* 닻 */
      0xeb8bbc,	/* 닼 */
      0xeb8bbd,	/* 닽 */
      0xeb8bbe,	/* 닾 */
      0xeb8bbf,	/* 닿 */
    },
    {
      0xeb8c80,	/* 대 */
      0xeb8c81,	/* 댁 */
      0xeb8c82,	/* 댂 */
      0xeb8c83,	/* 댃 */
      0xeb8c84,	/* 댄 */
      0xeb8c85,	/* 댅 */
      0xeb8c86,	/* 댆 */
      0xeb8c87,	/* 댇 */
      0xeb8c88,	/* 댈 */
      0xeb8c89,	/* 댉 */
      0xeb8c8a,	/* 댊 */
      0xeb8c8b,	/* 댋 */
      0xeb8c8c,	/* 댌 */
      0xeb8c8d,	/* 댍 */
      0xeb8c8e,	/* 댎 */
      0xeb8c8f,	/* 댏 */
      0xeb8c90,	/* 댐 */
      0xeb8c91,	/* 댑 */
      0xeb8c92,	/* 댒 */
      0xeb8c93,	/* 댓 */
      0xeb8c94,	/* 댔 */
      0xeb8c95,	/* 댕 */
      0xeb8c96,	/* 댖 */
      0xeb8c97,	/* 댗 */
      0xeb8c98,	/* 댘 */
      0xeb8c99,	/* 댙 */
      0xeb8c9a,	/* 댚 */
      0xeb8c9b,	/* 댛 */
    },
    {
      0xeb8c9c,	/* 댜 */
      0xeb8c9d,	/* 댝 */
      0xeb8c9e,	/* 댞 */
      0xeb8c9f,	/* 댟 */
      0xeb8ca0,	/* 댠 */
      0xeb8ca1,	/* 댡 */
      0xeb8ca2,	/* 댢 */
      0xeb8ca3,	/* 댣 */
      0xeb8ca4,	/* 댤 */
      0xeb8ca5,	/* 댥 */
      0xeb8ca6,	/* 댦 */
      0xeb8ca7,	/* 댧 */
      0xeb8ca8,	/* 댨 */
      0xeb8ca9,	/* 댩 */
      0xeb8caa,	/* 댪 */
      0xeb8cab,	/* 댫 */
      0xeb8cac,	/* 댬 */
      0xeb8cad,	/* 댭 */
      0xeb8cae,	/* 댮 */
      0xeb8caf,	/* 댯 */
      0xeb8cb0,	/* 댰 */
      0xeb8cb1,	/* 댱 */
      0xeb8cb2,	/* 댲 */
      0xeb8cb3,	/* 댳 */
      0xeb8cb4,	/* 댴 */
      0xeb8cb5,	/* 댵 */
      0xeb8cb6,	/* 댶 */
      0xeb8cb7,	/* 댷 */
    },
    {
      0xeb8cb8,	/* 댸 */
      0xeb8cb9,	/* 댹 */
      0xeb8cba,	/* 댺 */
      0xeb8cbb,	/* 댻 */
      0xeb8cbc,	/* 댼 */
      0xeb8cbd,	/* 댽 */
      0xeb8cbe,	/* 댾 */
      0xeb8cbf,	/* 댿 */
      0xeb8d80,	/* 덀 */
      0xeb8d81,	/* 덁 */
      0xeb8d82,	/* 덂 */
      0xeb8d83,	/* 덃 */
      0xeb8d84,	/* 덄 */
      0xeb8d85,	/* 덅 */
      0xeb8d86,	/* 덆 */
      0xeb8d87,	/* 덇 */
      0xeb8d88,	/* 덈 */
      0xeb8d89,	/* 덉 */
      0xeb8d8a,	/* 덊 */
      0xeb8d8b,	/* 덋 */
      0xeb8d8c,	/* 덌 */
      0xeb8d8d,	/* 덍 */
      0xeb8d8e,	/* 덎 */
      0xeb8d8f,	/* 덏 */
      0xeb8d90,	/* 덐 */
      0xeb8d91,	/* 덑 */
      0xeb8d92,	/* 덒 */
      0xeb8d93,	/* 덓 */
    },
    {
      0xeb8d94,	/* 더 */
      0xeb8d95,	/* 덕 */
      0xeb8d96,	/* 덖 */
      0xeb8d97,	/* 덗 */
      0xeb8d98,	/* 던 */
      0xeb8d99,	/* 덙 */
      0xeb8d9a,	/* 덚 */
      0xeb8d9b,	/* 덛 */
      0xeb8d9c,	/* 덜 */
      0xeb8d9d,	/* 덝 */
      0xeb8d9e,	/* 덞 */
      0xeb8d9f,	/* 덟 */
      0xeb8da0,	/* 덠 */
      0xeb8da1,	/* 덡 */
      0xeb8da2,	/* 덢 */
      0xeb8da3,	/* 덣 */
      0xeb8da4,	/* 덤 */
      0xeb8da5,	/* 덥 */
      0xeb8da6,	/* 덦 */
      0xeb8da7,	/* 덧 */
      0xeb8da8,	/* 덨 */
      0xeb8da9,	/* 덩 */
      0xeb8daa,	/* 덪 */
      0xeb8dab,	/* 덫 */
      0xeb8dac,	/* 덬 */
      0xeb8dad,	/* 덭 */
      0xeb8dae,	/* 덮 */
      0xeb8daf,	/* 덯 */
    },
    {
      0xeb8db0,	/* 데 */
      0xeb8db1,	/* 덱 */
      0xeb8db2,	/* 덲 */
      0xeb8db3,	/* 덳 */
      0xeb8db4,	/* 덴 */
      0xeb8db5,	/* 덵 */
      0xeb8db6,	/* 덶 */
      0xeb8db7,	/* 덷 */
      0xeb8db8,	/* 델 */
      0xeb8db9,	/* 덹 */
      0xeb8dba,	/* 덺 */
      0xeb8dbb,	/* 덻 */
      0xeb8dbc,	/* 덼 */
      0xeb8dbd,	/* 덽 */
      0xeb8dbe,	/* 덾 */
      0xeb8dbf,	/* 덿 */
      0xeb8e80,	/* 뎀 */
      0xeb8e81,	/* 뎁 */
      0xeb8e82,	/* 뎂 */
      0xeb8e83,	/* 뎃 */
      0xeb8e84,	/* 뎄 */
      0xeb8e85,	/* 뎅 */
      0xeb8e86,	/* 뎆 */
      0xeb8e87,	/* 뎇 */
      0xeb8e88,	/* 뎈 */
      0xeb8e89,	/* 뎉 */
      0xeb8e8a,	/* 뎊 */
      0xeb8e8b,	/* 뎋 */
    },
    {
      0xeb8e8c,	/* 뎌 */
      0xeb8e8d,	/* 뎍 */
      0xeb8e8e,	/* 뎎 */
      0xeb8e8f,	/* 뎏 */
      0xeb8e90,	/* 뎐 */
      0xeb8e91,	/* 뎑 */
      0xeb8e92,	/* 뎒 */
      0xeb8e93,	/* 뎓 */
      0xeb8e94,	/* 뎔 */
      0xeb8e95,	/* 뎕 */
      0xeb8e96,	/* 뎖 */
      0xeb8e97,	/* 뎗 */
      0xeb8e98,	/* 뎘 */
      0xeb8e99,	/* 뎙 */
      0xeb8e9a,	/* 뎚 */
      0xeb8e9b,	/* 뎛 */
      0xeb8e9c,	/* 뎜 */
      0xeb8e9d,	/* 뎝 */
      0xeb8e9e,	/* 뎞 */
      0xeb8e9f,	/* 뎟 */
      0xeb8ea0,	/* 뎠 */
      0xeb8ea1,	/* 뎡 */
      0xeb8ea2,	/* 뎢 */
      0xeb8ea3,	/* 뎣 */
      0xeb8ea4,	/* 뎤 */
      0xeb8ea5,	/* 뎥 */
      0xeb8ea6,	/* 뎦 */
      0xeb8ea7,	/* 뎧 */
    },
    {
      0xeb8ea8,	/* 뎨 */
      0xeb8ea9,	/* 뎩 */
      0xeb8eaa,	/* 뎪 */
      0xeb8eab,	/* 뎫 */
      0xeb8eac,	/* 뎬 */
      0xeb8ead,	/* 뎭 */
      0xeb8eae,	/* 뎮 */
      0xeb8eaf,	/* 뎯 */
      0xeb8eb0,	/* 뎰 */
      0xeb8eb1,	/* 뎱 */
      0xeb8eb2,	/* 뎲 */
      0xeb8eb3,	/* 뎳 */
      0xeb8eb4,	/* 뎴 */
      0xeb8eb5,	/* 뎵 */
      0xeb8eb6,	/* 뎶 */
      0xeb8eb7,	/* 뎷 */
      0xeb8eb8,	/* 뎸 */
      0xeb8eb9,	/* 뎹 */
      0xeb8eba,	/* 뎺 */
      0xeb8ebb,	/* 뎻 */
      0xeb8ebc,	/* 뎼 */
      0xeb8ebd,	/* 뎽 */
      0xeb8ebe,	/* 뎾 */
      0xeb8ebf,	/* 뎿 */
      0xeb8f80,	/* 돀 */
      0xeb8f81,	/* 돁 */
      0xeb8f82,	/* 돂 */
      0xeb8f83,	/* 돃 */
    },
    {
      0xeb8f84,	/* 도 */
      0xeb8f85,	/* 독 */
      0xeb8f86,	/* 돆 */
      0xeb8f87,	/* 돇 */
      0xeb8f88,	/* 돈 */
      0xeb8f89,	/* 돉 */
      0xeb8f8a,	/* 돊 */
      0xeb8f8b,	/* 돋 */
      0xeb8f8c,	/* 돌 */
      0xeb8f8d,	/* 돍 */
      0xeb8f8e,	/* 돎 */
      0xeb8f8f,	/* 돏 */
      0xeb8f90,	/* 돐 */
      0xeb8f91,	/* 돑 */
      0xeb8f92,	/* 돒 */
      0xeb8f93,	/* 돓 */
      0xeb8f94,	/* 돔 */
      0xeb8f95,	/* 돕 */
      0xeb8f96,	/* 돖 */
      0xeb8f97,	/* 돗 */
      0xeb8f98,	/* 돘 */
      0xeb8f99,	/* 동 */
      0xeb8f9a,	/* 돚 */
      0xeb8f9b,	/* 돛 */
      0xeb8f9c,	/* 돜 */
      0xeb8f9d,	/* 돝 */
      0xeb8f9e,	/* 돞 */
      0xeb8f9f,	/* 돟 */
    },
    {
      0xeb8fa0,	/* 돠 */
      0xeb8fa1,	/* 돡 */
      0xeb8fa2,	/* 돢 */
      0xeb8fa3,	/* 돣 */
      0xeb8fa4,	/* 돤 */
      0xeb8fa5,	/* 돥 */
      0xeb8fa6,	/* 돦 */
      0xeb8fa7,	/* 돧 */
      0xeb8fa8,	/* 돨 */
      0xeb8fa9,	/* 돩 */
      0xeb8faa,	/* 돪 */
      0xeb8fab,	/* 돫 */
      0xeb8fac,	/* 돬 */
      0xeb8fad,	/* 돭 */
      0xeb8fae,	/* 돮 */
      0xeb8faf,	/* 돯 */
      0xeb8fb0,	/* 돰 */
      0xeb8fb1,	/* 돱 */
      0xeb8fb2,	/* 돲 */
      0xeb8fb3,	/* 돳 */
      0xeb8fb4,	/* 돴 */
      0xeb8fb5,	/* 돵 */
      0xeb8fb6,	/* 돶 */
      0xeb8fb7,	/* 돷 */
      0xeb8fb8,	/* 돸 */
      0xeb8fb9,	/* 돹 */
      0xeb8fba,	/* 돺 */
      0xeb8fbb,	/* 돻 */
    },
    {
      0xeb8fbc,	/* 돼 */
      0xeb8fbd,	/* 돽 */
      0xeb8fbe,	/* 돾 */
      0xeb8fbf,	/* 돿 */
      0xeb9080,	/* 됀 */
      0xeb9081,	/* 됁 */
      0xeb9082,	/* 됂 */
      0xeb9083,	/* 됃 */
      0xeb9084,	/* 됄 */
      0xeb9085,	/* 됅 */
      0xeb9086,	/* 됆 */
      0xeb9087,	/* 됇 */
      0xeb9088,	/* 됈 */
      0xeb9089,	/* 됉 */
      0xeb908a,	/* 됊 */
      0xeb908b,	/* 됋 */
      0xeb908c,	/* 됌 */
      0xeb908d,	/* 됍 */
      0xeb908e,	/* 됎 */
      0xeb908f,	/* 됏 */
      0xeb9090,	/* 됐 */
      0xeb9091,	/* 됑 */
      0xeb9092,	/* 됒 */
      0xeb9093,	/* 됓 */
      0xeb9094,	/* 됔 */
      0xeb9095,	/* 됕 */
      0xeb9096,	/* 됖 */
      0xeb9097,	/* 됗 */
    },
    {
      0xeb9098,	/* 되 */
      0xeb9099,	/* 됙 */
      0xeb909a,	/* 됚 */
      0xeb909b,	/* 됛 */
      0xeb909c,	/* 된 */
      0xeb909d,	/* 됝 */
      0xeb909e,	/* 됞 */
      0xeb909f,	/* 됟 */
      0xeb90a0,	/* 될 */
      0xeb90a1,	/* 됡 */
      0xeb90a2,	/* 됢 */
      0xeb90a3,	/* 됣 */
      0xeb90a4,	/* 됤 */
      0xeb90a5,	/* 됥 */
      0xeb90a6,	/* 됦 */
      0xeb90a7,	/* 됧 */
      0xeb90a8,	/* 됨 */
      0xeb90a9,	/* 됩 */
      0xeb90aa,	/* 됪 */
      0xeb90ab,	/* 됫 */
      0xeb90ac,	/* 됬 */
      0xeb90ad,	/* 됭 */
      0xeb90ae,	/* 됮 */
      0xeb90af,	/* 됯 */
      0xeb90b0,	/* 됰 */
      0xeb90b1,	/* 됱 */
      0xeb90b2,	/* 됲 */
      0xeb90b3,	/* 됳 */
    },
    {
      0xeb90b4,	/* 됴 */
      0xeb90b5,	/* 됵 */
      0xeb90b6,	/* 됶 */
      0xeb90b7,	/* 됷 */
      0xeb90b8,	/* 됸 */
      0xeb90b9,	/* 됹 */
      0xeb90ba,	/* 됺 */
      0xeb90bb,	/* 됻 */
      0xeb90bc,	/* 됼 */
      0xeb90bd,	/* 됽 */
      0xeb90be,	/* 됾 */
      0xeb90bf,	/* 됿 */
      0xeb9180,	/* 둀 */
      0xeb9181,	/* 둁 */
      0xeb9182,	/* 둂 */
      0xeb9183,	/* 둃 */
      0xeb9184,	/* 둄 */
      0xeb9185,	/* 둅 */
      0xeb9186,	/* 둆 */
      0xeb9187,	/* 둇 */
      0xeb9188,	/* 둈 */
      0xeb9189,	/* 둉 */
      0xeb918a,	/* 둊 */
      0xeb918b,	/* 둋 */
      0xeb918c,	/* 둌 */
      0xeb918d,	/* 둍 */
      0xeb918e,	/* 둎 */
      0xeb918f,	/* 둏 */
    },
    {
      0xeb9190,	/* 두 */
      0xeb9191,	/* 둑 */
      0xeb9192,	/* 둒 */
      0xeb9193,	/* 둓 */
      0xeb9194,	/* 둔 */
      0xeb9195,	/* 둕 */
      0xeb9196,	/* 둖 */
      0xeb9197,	/* 둗 */
      0xeb9198,	/* 둘 */
      0xeb9199,	/* 둙 */
      0xeb919a,	/* 둚 */
      0xeb919b,	/* 둛 */
      0xeb919c,	/* 둜 */
      0xeb919d,	/* 둝 */
      0xeb919e,	/* 둞 */
      0xeb919f,	/* 둟 */
      0xeb91a0,	/* 둠 */
      0xeb91a1,	/* 둡 */
      0xeb91a2,	/* 둢 */
      0xeb91a3,	/* 둣 */
      0xeb91a4,	/* 둤 */
      0xeb91a5,	/* 둥 */
      0xeb91a6,	/* 둦 */
      0xeb91a7,	/* 둧 */
      0xeb91a8,	/* 둨 */
      0xeb91a9,	/* 둩 */
      0xeb91aa,	/* 둪 */
      0xeb91ab,	/* 둫 */
    },
    {
      0xeb91ac,	/* 둬 */
      0xeb91ad,	/* 둭 */
      0xeb91ae,	/* 둮 */
      0xeb91af,	/* 둯 */
      0xeb91b0,	/* 둰 */
      0xeb91b1,	/* 둱 */
      0xeb91b2,	/* 둲 */
      0xeb91b3,	/* 둳 */
      0xeb91b4,	/* 둴 */
      0xeb91b5,	/* 둵 */
      0xeb91b6,	/* 둶 */
      0xeb91b7,	/* 둷 */
      0xeb91b8,	/* 둸 */
      0xeb91b9,	/* 둹 */
      0xeb91ba,	/* 둺 */
      0xeb91bb,	/* 둻 */
      0xeb91bc,	/* 둼 */
      0xeb91bd,	/* 둽 */
      0xeb91be,	/* 둾 */
      0xeb91bf,	/* 둿 */
      0xeb9280,	/* 뒀 */
      0xeb9281,	/* 뒁 */
      0xeb9282,	/* 뒂 */
      0xeb9283,	/* 뒃 */
      0xeb9284,	/* 뒄 */
      0xeb9285,	/* 뒅 */
      0xeb9286,	/* 뒆 */
      0xeb9287,	/* 뒇 */
    },
    {
      0xeb9288,	/* 뒈 */
      0xeb9289,	/* 뒉 */
      0xeb928a,	/* 뒊 */
      0xeb928b,	/* 뒋 */
      0xeb928c,	/* 뒌 */
      0xeb928d,	/* 뒍 */
      0xeb928e,	/* 뒎 */
      0xeb928f,	/* 뒏 */
      0xeb9290,	/* 뒐 */
      0xeb9291,	/* 뒑 */
      0xeb9292,	/* 뒒 */
      0xeb9293,	/* 뒓 */
      0xeb9294,	/* 뒔 */
      0xeb9295,	/* 뒕 */
      0xeb9296,	/* 뒖 */
      0xeb9297,	/* 뒗 */
      0xeb9298,	/* 뒘 */
      0xeb9299,	/* 뒙 */
      0xeb929a,	/* 뒚 */
      0xeb929b,	/* 뒛 */
      0xeb929c,	/* 뒜 */
      0xeb929d,	/* 뒝 */
      0xeb929e,	/* 뒞 */
      0xeb929f,	/* 뒟 */
      0xeb92a0,	/* 뒠 */
      0xeb92a1,	/* 뒡 */
      0xeb92a2,	/* 뒢 */
      0xeb92a3,	/* 뒣 */
    },
    {
      0xeb92a4,	/* 뒤 */
      0xeb92a5,	/* 뒥 */
      0xeb92a6,	/* 뒦 */
      0xeb92a7,	/* 뒧 */
      0xeb92a8,	/* 뒨 */
      0xeb92a9,	/* 뒩 */
      0xeb92aa,	/* 뒪 */
      0xeb92ab,	/* 뒫 */
      0xeb92ac,	/* 뒬 */
      0xeb92ad,	/* 뒭 */
      0xeb92ae,	/* 뒮 */
      0xeb92af,	/* 뒯 */
      0xeb92b0,	/* 뒰 */
      0xeb92b1,	/* 뒱 */
      0xeb92b2,	/* 뒲 */
      0xeb92b3,	/* 뒳 */
      0xeb92b4,	/* 뒴 */
      0xeb92b5,	/* 뒵 */
      0xeb92b6,	/* 뒶 */
      0xeb92b7,	/* 뒷 */
      0xeb92b8,	/* 뒸 */
      0xeb92b9,	/* 뒹 */
      0xeb92ba,	/* 뒺 */
      0xeb92bb,	/* 뒻 */
      0xeb92bc,	/* 뒼 */
      0xeb92bd,	/* 뒽 */
      0xeb92be,	/* 뒾 */
      0xeb92bf,	/* 뒿 */
    },
    {
      0xeb9380,	/* 듀 */
      0xeb9381,	/* 듁 */
      0xeb9382,	/* 듂 */
      0xeb9383,	/* 듃 */
      0xeb9384,	/* 듄 */
      0xeb9385,	/* 듅 */
      0xeb9386,	/* 듆 */
      0xeb9387,	/* 듇 */
      0xeb9388,	/* 듈 */
      0xeb9389,	/* 듉 */
      0xeb938a,	/* 듊 */
      0xeb938b,	/* 듋 */
      0xeb938c,	/* 듌 */
      0xeb938d,	/* 듍 */
      0xeb938e,	/* 듎 */
      0xeb938f,	/* 듏 */
      0xeb9390,	/* 듐 */
      0xeb9391,	/* 듑 */
      0xeb9392,	/* 듒 */
      0xeb9393,	/* 듓 */
      0xeb9394,	/* 듔 */
      0xeb9395,	/* 듕 */
      0xeb9396,	/* 듖 */
      0xeb9397,	/* 듗 */
      0xeb9398,	/* 듘 */
      0xeb9399,	/* 듙 */
      0xeb939a,	/* 듚 */
      0xeb939b,	/* 듛 */
    },
    {
      0xeb939c,	/* 드 */
      0xeb939d,	/* 득 */
      0xeb939e,	/* 듞 */
      0xeb939f,	/* 듟 */
      0xeb93a0,	/* 든 */
      0xeb93a1,	/* 듡 */
      0xeb93a2,	/* 듢 */
      0xeb93a3,	/* 듣 */
      0xeb93a4,	/* 들 */
      0xeb93a5,	/* 듥 */
      0xeb93a6,	/* 듦 */
      0xeb93a7,	/* 듧 */
      0xeb93a8,	/* 듨 */
      0xeb93a9,	/* 듩 */
      0xeb93aa,	/* 듪 */
      0xeb93ab,	/* 듫 */
      0xeb93ac,	/* 듬 */
      0xeb93ad,	/* 듭 */
      0xeb93ae,	/* 듮 */
      0xeb93af,	/* 듯 */
      0xeb93b0,	/* 듰 */
      0xeb93b1,	/* 등 */
      0xeb93b2,	/* 듲 */
      0xeb93b3,	/* 듳 */
      0xeb93b4,	/* 듴 */
      0xeb93b5,	/* 듵 */
      0xeb93b6,	/* 듶 */
      0xeb93b7,	/* 듷 */
    },
    {
      0xeb93b8,	/* 듸 */
      0xeb93b9,	/* 듹 */
      0xeb93ba,	/* 듺 */
      0xeb93bb,	/* 듻 */
      0xeb93bc,	/* 듼 */
      0xeb93bd,	/* 듽 */
      0xeb93be,	/* 듾 */
      0xeb93bf,	/* 듿 */
      0xeb9480,	/* 딀 */
      0xeb9481,	/* 딁 */
      0xeb9482,	/* 딂 */
      0xeb9483,	/* 딃 */
      0xeb9484,	/* 딄 */
      0xeb9485,	/* 딅 */
      0xeb9486,	/* 딆 */
      0xeb9487,	/* 딇 */
      0xeb9488,	/* 딈 */
      0xeb9489,	/* 딉 */
      0xeb948a,	/* 딊 */
      0xeb948b,	/* 딋 */
      0xeb948c,	/* 딌 */
      0xeb948d,	/* 딍 */
      0xeb948e,	/* 딎 */
      0xeb948f,	/* 딏 */
      0xeb9490,	/* 딐 */
      0xeb9491,	/* 딑 */
      0xeb9492,	/* 딒 */
      0xeb9493,	/* 딓 */
    },
    {
      0xeb9494,	/* 디 */
      0xeb9495,	/* 딕 */
      0xeb9496,	/* 딖 */
      0xeb9497,	/* 딗 */
      0xeb9498,	/* 딘 */
      0xeb9499,	/* 딙 */
      0xeb949a,	/* 딚 */
      0xeb949b,	/* 딛 */
      0xeb949c,	/* 딜 */
      0xeb949d,	/* 딝 */
      0xeb949e,	/* 딞 */
      0xeb949f,	/* 딟 */
      0xeb94a0,	/* 딠 */
      0xeb94a1,	/* 딡 */
      0xeb94a2,	/* 딢 */
      0xeb94a3,	/* 딣 */
      0xeb94a4,	/* 딤 */
      0xeb94a5,	/* 딥 */
      0xeb94a6,	/* 딦 */
      0xeb94a7,	/* 딧 */
      0xeb94a8,	/* 딨 */
      0xeb94a9,	/* 딩 */
      0xeb94aa,	/* 딪 */
      0xeb94ab,	/* 딫 */
      0xeb94ac,	/* 딬 */
      0xeb94ad,	/* 딭 */
      0xeb94ae,	/* 딮 */
      0xeb94af,	/* 딯 */
    },
  },
  {
    {
      0xeb94b0,	/* 따 */
      0xeb94b1,	/* 딱 */
      0xeb94b2,	/* 딲 */
      0xeb94b3,	/* 딳 */
      0xeb94b4,	/* 딴 */
      0xeb94b5,	/* 딵 */
      0xeb94b6,	/* 딶 */
      0xeb94b7,	/* 딷 */
      0xeb94b8,	/* 딸 */
      0xeb94b9,	/* 딹 */
      0xeb94ba,	/* 딺 */
      0xeb94bb,	/* 딻 */
      0xeb94bc,	/* 딼 */
      0xeb94bd,	/* 딽 */
      0xeb94be,	/* 딾 */
      0xeb94bf,	/* 딿 */
      0xeb9580,	/* 땀 */
      0xeb9581,	/* 땁 */
      0xeb9582,	/* 땂 */
      0xeb9583,	/* 땃 */
      0xeb9584,	/* 땄 */
      0xeb9585,	/* 땅 */
      0xeb9586,	/* 땆 */
      0xeb9587,	/* 땇 */
      0xeb9588,	/* 땈 */
      0xeb9589,	/* 땉 */
      0xeb958a,	/* 땊 */
      0xeb958b,	/* 땋 */
    },
    {
      0xeb958c,	/* 때 */
      0xeb958d,	/* 땍 */
      0xeb958e,	/* 땎 */
      0xeb958f,	/* 땏 */
      0xeb9590,	/* 땐 */
      0xeb9591,	/* 땑 */
      0xeb9592,	/* 땒 */
      0xeb9593,	/* 땓 */
      0xeb9594,	/* 땔 */
      0xeb9595,	/* 땕 */
      0xeb9596,	/* 땖 */
      0xeb9597,	/* 땗 */
      0xeb9598,	/* 땘 */
      0xeb9599,	/* 땙 */
      0xeb959a,	/* 땚 */
      0xeb959b,	/* 땛 */
      0xeb959c,	/* 땜 */
      0xeb959d,	/* 땝 */
      0xeb959e,	/* 땞 */
      0xeb959f,	/* 땟 */
      0xeb95a0,	/* 땠 */
      0xeb95a1,	/* 땡 */
      0xeb95a2,	/* 땢 */
      0xeb95a3,	/* 땣 */
      0xeb95a4,	/* 땤 */
      0xeb95a5,	/* 땥 */
      0xeb95a6,	/* 땦 */
      0xeb95a7,	/* 땧 */
    },
    {
      0xeb95a8,	/* 땨 */
      0xeb95a9,	/* 땩 */
      0xeb95aa,	/* 땪 */
      0xeb95ab,	/* 땫 */
      0xeb95ac,	/* 땬 */
      0xeb95ad,	/* 땭 */
      0xeb95ae,	/* 땮 */
      0xeb95af,	/* 땯 */
      0xeb95b0,	/* 땰 */
      0xeb95b1,	/* 땱 */
      0xeb95b2,	/* 땲 */
      0xeb95b3,	/* 땳 */
      0xeb95b4,	/* 땴 */
      0xeb95b5,	/* 땵 */
      0xeb95b6,	/* 땶 */
      0xeb95b7,	/* 땷 */
      0xeb95b8,	/* 땸 */
      0xeb95b9,	/* 땹 */
      0xeb95ba,	/* 땺 */
      0xeb95bb,	/* 땻 */
      0xeb95bc,	/* 땼 */
      0xeb95bd,	/* 땽 */
      0xeb95be,	/* 땾 */
      0xeb95bf,	/* 땿 */
      0xeb9680,	/* 떀 */
      0xeb9681,	/* 떁 */
      0xeb9682,	/* 떂 */
      0xeb9683,	/* 떃 */
    },
    {
      0xeb9684,	/* 떄 */
      0xeb9685,	/* 떅 */
      0xeb9686,	/* 떆 */
      0xeb9687,	/* 떇 */
      0xeb9688,	/* 떈 */
      0xeb9689,	/* 떉 */
      0xeb968a,	/* 떊 */
      0xeb968b,	/* 떋 */
      0xeb968c,	/* 떌 */
      0xeb968d,	/* 떍 */
      0xeb968e,	/* 떎 */
      0xeb968f,	/* 떏 */
      0xeb9690,	/* 떐 */
      0xeb9691,	/* 떑 */
      0xeb9692,	/* 떒 */
      0xeb9693,	/* 떓 */
      0xeb9694,	/* 떔 */
      0xeb9695,	/* 떕 */
      0xeb9696,	/* 떖 */
      0xeb9697,	/* 떗 */
      0xeb9698,	/* 떘 */
      0xeb9699,	/* 떙 */
      0xeb969a,	/* 떚 */
      0xeb969b,	/* 떛 */
      0xeb969c,	/* 떜 */
      0xeb969d,	/* 떝 */
      0xeb969e,	/* 떞 */
      0xeb969f,	/* 떟 */
    },
    {
      0xeb96a0,	/* 떠 */
      0xeb96a1,	/* 떡 */
      0xeb96a2,	/* 떢 */
      0xeb96a3,	/* 떣 */
      0xeb96a4,	/* 떤 */
      0xeb96a5,	/* 떥 */
      0xeb96a6,	/* 떦 */
      0xeb96a7,	/* 떧 */
      0xeb96a8,	/* 떨 */
      0xeb96a9,	/* 떩 */
      0xeb96aa,	/* 떪 */
      0xeb96ab,	/* 떫 */
      0xeb96ac,	/* 떬 */
      0xeb96ad,	/* 떭 */
      0xeb96ae,	/* 떮 */
      0xeb96af,	/* 떯 */
      0xeb96b0,	/* 떰 */
      0xeb96b1,	/* 떱 */
      0xeb96b2,	/* 떲 */
      0xeb96b3,	/* 떳 */
      0xeb96b4,	/* 떴 */
      0xeb96b5,	/* 떵 */
      0xeb96b6,	/* 떶 */
      0xeb96b7,	/* 떷 */
      0xeb96b8,	/* 떸 */
      0xeb96b9,	/* 떹 */
      0xeb96ba,	/* 떺 */
      0xeb96bb,	/* 떻 */
    },
    {
      0xeb96bc,	/* 떼 */
      0xeb96bd,	/* 떽 */
      0xeb96be,	/* 떾 */
      0xeb96bf,	/* 떿 */
      0xeb9780,	/* 뗀 */
      0xeb9781,	/* 뗁 */
      0xeb9782,	/* 뗂 */
      0xeb9783,	/* 뗃 */
      0xeb9784,	/* 뗄 */
      0xeb9785,	/* 뗅 */
      0xeb9786,	/* 뗆 */
      0xeb9787,	/* 뗇 */
      0xeb9788,	/* 뗈 */
      0xeb9789,	/* 뗉 */
      0xeb978a,	/* 뗊 */
      0xeb978b,	/* 뗋 */
      0xeb978c,	/* 뗌 */
      0xeb978d,	/* 뗍 */
      0xeb978e,	/* 뗎 */
      0xeb978f,	/* 뗏 */
      0xeb9790,	/* 뗐 */
      0xeb9791,	/* 뗑 */
      0xeb9792,	/* 뗒 */
      0xeb9793,	/* 뗓 */
      0xeb9794,	/* 뗔 */
      0xeb9795,	/* 뗕 */
      0xeb9796,	/* 뗖 */
      0xeb9797,	/* 뗗 */
    },
    {
      0xeb9798,	/* 뗘 */
      0xeb9799,	/* 뗙 */
      0xeb979a,	/* 뗚 */
      0xeb979b,	/* 뗛 */
      0xeb979c,	/* 뗜 */
      0xeb979d,	/* 뗝 */
      0xeb979e,	/* 뗞 */
      0xeb979f,	/* 뗟 */
      0xeb97a0,	/* 뗠 */
      0xeb97a1,	/* 뗡 */
      0xeb97a2,	/* 뗢 */
      0xeb97a3,	/* 뗣 */
      0xeb97a4,	/* 뗤 */
      0xeb97a5,	/* 뗥 */
      0xeb97a6,	/* 뗦 */
      0xeb97a7,	/* 뗧 */
      0xeb97a8,	/* 뗨 */
      0xeb97a9,	/* 뗩 */
      0xeb97aa,	/* 뗪 */
      0xeb97ab,	/* 뗫 */
      0xeb97ac,	/* 뗬 */
      0xeb97ad,	/* 뗭 */
      0xeb97ae,	/* 뗮 */
      0xeb97af,	/* 뗯 */
      0xeb97b0,	/* 뗰 */
      0xeb97b1,	/* 뗱 */
      0xeb97b2,	/* 뗲 */
      0xeb97b3,	/* 뗳 */
    },
    {
      0xeb97b4,	/* 뗴 */
      0xeb97b5,	/* 뗵 */
      0xeb97b6,	/* 뗶 */
      0xeb97b7,	/* 뗷 */
      0xeb97b8,	/* 뗸 */
      0xeb97b9,	/* 뗹 */
      0xeb97ba,	/* 뗺 */
      0xeb97bb,	/* 뗻 */
      0xeb97bc,	/* 뗼 */
      0xeb97bd,	/* 뗽 */
      0xeb97be,	/* 뗾 */
      0xeb97bf,	/* 뗿 */
      0xeb9880,	/* 똀 */
      0xeb9881,	/* 똁 */
      0xeb9882,	/* 똂 */
      0xeb9883,	/* 똃 */
      0xeb9884,	/* 똄 */
      0xeb9885,	/* 똅 */
      0xeb9886,	/* 똆 */
      0xeb9887,	/* 똇 */
      0xeb9888,	/* 똈 */
      0xeb9889,	/* 똉 */
      0xeb988a,	/* 똊 */
      0xeb988b,	/* 똋 */
      0xeb988c,	/* 똌 */
      0xeb988d,	/* 똍 */
      0xeb988e,	/* 똎 */
      0xeb988f,	/* 똏 */
    },
    {
      0xeb9890,	/* 또 */
      0xeb9891,	/* 똑 */
      0xeb9892,	/* 똒 */
      0xeb9893,	/* 똓 */
      0xeb9894,	/* 똔 */
      0xeb9895,	/* 똕 */
      0xeb9896,	/* 똖 */
      0xeb9897,	/* 똗 */
      0xeb9898,	/* 똘 */
      0xeb9899,	/* 똙 */
      0xeb989a,	/* 똚 */
      0xeb989b,	/* 똛 */
      0xeb989c,	/* 똜 */
      0xeb989d,	/* 똝 */
      0xeb989e,	/* 똞 */
      0xeb989f,	/* 똟 */
      0xeb98a0,	/* 똠 */
      0xeb98a1,	/* 똡 */
      0xeb98a2,	/* 똢 */
      0xeb98a3,	/* 똣 */
      0xeb98a4,	/* 똤 */
      0xeb98a5,	/* 똥 */
      0xeb98a6,	/* 똦 */
      0xeb98a7,	/* 똧 */
      0xeb98a8,	/* 똨 */
      0xeb98a9,	/* 똩 */
      0xeb98aa,	/* 똪 */
      0xeb98ab,	/* 똫 */
    },
    {
      0xeb98ac,	/* 똬 */
      0xeb98ad,	/* 똭 */
      0xeb98ae,	/* 똮 */
      0xeb98af,	/* 똯 */
      0xeb98b0,	/* 똰 */
      0xeb98b1,	/* 똱 */
      0xeb98b2,	/* 똲 */
      0xeb98b3,	/* 똳 */
      0xeb98b4,	/* 똴 */
      0xeb98b5,	/* 똵 */
      0xeb98b6,	/* 똶 */
      0xeb98b7,	/* 똷 */
      0xeb98b8,	/* 똸 */
      0xeb98b9,	/* 똹 */
      0xeb98ba,	/* 똺 */
      0xeb98bb,	/* 똻 */
      0xeb98bc,	/* 똼 */
      0xeb98bd,	/* 똽 */
      0xeb98be,	/* 똾 */
      0xeb98bf,	/* 똿 */
      0xeb9980,	/* 뙀 */
      0xeb9981,	/* 뙁 */
      0xeb9982,	/* 뙂 */
      0xeb9983,	/* 뙃 */
      0xeb9984,	/* 뙄 */
      0xeb9985,	/* 뙅 */
      0xeb9986,	/* 뙆 */
      0xeb9987,	/* 뙇 */
    },
    {
      0xeb9988,	/* 뙈 */
      0xeb9989,	/* 뙉 */
      0xeb998a,	/* 뙊 */
      0xeb998b,	/* 뙋 */
      0xeb998c,	/* 뙌 */
      0xeb998d,	/* 뙍 */
      0xeb998e,	/* 뙎 */
      0xeb998f,	/* 뙏 */
      0xeb9990,	/* 뙐 */
      0xeb9991,	/* 뙑 */
      0xeb9992,	/* 뙒 */
      0xeb9993,	/* 뙓 */
      0xeb9994,	/* 뙔 */
      0xeb9995,	/* 뙕 */
      0xeb9996,	/* 뙖 */
      0xeb9997,	/* 뙗 */
      0xeb9998,	/* 뙘 */
      0xeb9999,	/* 뙙 */
      0xeb999a,	/* 뙚 */
      0xeb999b,	/* 뙛 */
      0xeb999c,	/* 뙜 */
      0xeb999d,	/* 뙝 */
      0xeb999e,	/* 뙞 */
      0xeb999f,	/* 뙟 */
      0xeb99a0,	/* 뙠 */
      0xeb99a1,	/* 뙡 */
      0xeb99a2,	/* 뙢 */
      0xeb99a3,	/* 뙣 */
    },
    {
      0xeb99a4,	/* 뙤 */
      0xeb99a5,	/* 뙥 */
      0xeb99a6,	/* 뙦 */
      0xeb99a7,	/* 뙧 */
      0xeb99a8,	/* 뙨 */
      0xeb99a9,	/* 뙩 */
      0xeb99aa,	/* 뙪 */
      0xeb99ab,	/* 뙫 */
      0xeb99ac,	/* 뙬 */
      0xeb99ad,	/* 뙭 */
      0xeb99ae,	/* 뙮 */
      0xeb99af,	/* 뙯 */
      0xeb99b0,	/* 뙰 */
      0xeb99b1,	/* 뙱 */
      0xeb99b2,	/* 뙲 */
      0xeb99b3,	/* 뙳 */
      0xeb99b4,	/* 뙴 */
      0xeb99b5,	/* 뙵 */
      0xeb99b6,	/* 뙶 */
      0xeb99b7,	/* 뙷 */
      0xeb99b8,	/* 뙸 */
      0xeb99b9,	/* 뙹 */
      0xeb99ba,	/* 뙺 */
      0xeb99bb,	/* 뙻 */
      0xeb99bc,	/* 뙼 */
      0xeb99bd,	/* 뙽 */
      0xeb99be,	/* 뙾 */
      0xeb99bf,	/* 뙿 */
    },
    {
      0xeb9a80,	/* 뚀 */
      0xeb9a81,	/* 뚁 */
      0xeb9a82,	/* 뚂 */
      0xeb9a83,	/* 뚃 */
      0xeb9a84,	/* 뚄 */
      0xeb9a85,	/* 뚅 */
      0xeb9a86,	/* 뚆 */
      0xeb9a87,	/* 뚇 */
      0xeb9a88,	/* 뚈 */
      0xeb9a89,	/* 뚉 */
      0xeb9a8a,	/* 뚊 */
      0xeb9a8b,	/* 뚋 */
      0xeb9a8c,	/* 뚌 */
      0xeb9a8d,	/* 뚍 */
      0xeb9a8e,	/* 뚎 */
      0xeb9a8f,	/* 뚏 */
      0xeb9a90,	/* 뚐 */
      0xeb9a91,	/* 뚑 */
      0xeb9a92,	/* 뚒 */
      0xeb9a93,	/* 뚓 */
      0xeb9a94,	/* 뚔 */
      0xeb9a95,	/* 뚕 */
      0xeb9a96,	/* 뚖 */
      0xeb9a97,	/* 뚗 */
      0xeb9a98,	/* 뚘 */
      0xeb9a99,	/* 뚙 */
      0xeb9a9a,	/* 뚚 */
      0xeb9a9b,	/* 뚛 */
    },
    {
      0xeb9a9c,	/* 뚜 */
      0xeb9a9d,	/* 뚝 */
      0xeb9a9e,	/* 뚞 */
      0xeb9a9f,	/* 뚟 */
      0xeb9aa0,	/* 뚠 */
      0xeb9aa1,	/* 뚡 */
      0xeb9aa2,	/* 뚢 */
      0xeb9aa3,	/* 뚣 */
      0xeb9aa4,	/* 뚤 */
      0xeb9aa5,	/* 뚥 */
      0xeb9aa6,	/* 뚦 */
      0xeb9aa7,	/* 뚧 */
      0xeb9aa8,	/* 뚨 */
      0xeb9aa9,	/* 뚩 */
      0xeb9aaa,	/* 뚪 */
      0xeb9aab,	/* 뚫 */
      0xeb9aac,	/* 뚬 */
      0xeb9aad,	/* 뚭 */
      0xeb9aae,	/* 뚮 */
      0xeb9aaf,	/* 뚯 */
      0xeb9ab0,	/* 뚰 */
      0xeb9ab1,	/* 뚱 */
      0xeb9ab2,	/* 뚲 */
      0xeb9ab3,	/* 뚳 */
      0xeb9ab4,	/* 뚴 */
      0xeb9ab5,	/* 뚵 */
      0xeb9ab6,	/* 뚶 */
      0xeb9ab7,	/* 뚷 */
    },
    {
      0xeb9ab8,	/* 뚸 */
      0xeb9ab9,	/* 뚹 */
      0xeb9aba,	/* 뚺 */
      0xeb9abb,	/* 뚻 */
      0xeb9abc,	/* 뚼 */
      0xeb9abd,	/* 뚽 */
      0xeb9abe,	/* 뚾 */
      0xeb9abf,	/* 뚿 */
      0xeb9b80,	/* 뛀 */
      0xeb9b81,	/* 뛁 */
      0xeb9b82,	/* 뛂 */
      0xeb9b83,	/* 뛃 */
      0xeb9b84,	/* 뛄 */
      0xeb9b85,	/* 뛅 */
      0xeb9b86,	/* 뛆 */
      0xeb9b87,	/* 뛇 */
      0xeb9b88,	/* 뛈 */
      0xeb9b89,	/* 뛉 */
      0xeb9b8a,	/* 뛊 */
      0xeb9b8b,	/* 뛋 */
      0xeb9b8c,	/* 뛌 */
      0xeb9b8d,	/* 뛍 */
      0xeb9b8e,	/* 뛎 */
      0xeb9b8f,	/* 뛏 */
      0xeb9b90,	/* 뛐 */
      0xeb9b91,	/* 뛑 */
      0xeb9b92,	/* 뛒 */
      0xeb9b93,	/* 뛓 */
    },
    {
      0xeb9b94,	/* 뛔 */
      0xeb9b95,	/* 뛕 */
      0xeb9b96,	/* 뛖 */
      0xeb9b97,	/* 뛗 */
      0xeb9b98,	/* 뛘 */
      0xeb9b99,	/* 뛙 */
      0xeb9b9a,	/* 뛚 */
      0xeb9b9b,	/* 뛛 */
      0xeb9b9c,	/* 뛜 */
      0xeb9b9d,	/* 뛝 */
      0xeb9b9e,	/* 뛞 */
      0xeb9b9f,	/* 뛟 */
      0xeb9ba0,	/* 뛠 */
      0xeb9ba1,	/* 뛡 */
      0xeb9ba2,	/* 뛢 */
      0xeb9ba3,	/* 뛣 */
      0xeb9ba4,	/* 뛤 */
      0xeb9ba5,	/* 뛥 */
      0xeb9ba6,	/* 뛦 */
      0xeb9ba7,	/* 뛧 */
      0xeb9ba8,	/* 뛨 */
      0xeb9ba9,	/* 뛩 */
      0xeb9baa,	/* 뛪 */
      0xeb9bab,	/* 뛫 */
      0xeb9bac,	/* 뛬 */
      0xeb9bad,	/* 뛭 */
      0xeb9bae,	/* 뛮 */
      0xeb9baf,	/* 뛯 */
    },
    {
      0xeb9bb0,	/* 뛰 */
      0xeb9bb1,	/* 뛱 */
      0xeb9bb2,	/* 뛲 */
      0xeb9bb3,	/* 뛳 */
      0xeb9bb4,	/* 뛴 */
      0xeb9bb5,	/* 뛵 */
      0xeb9bb6,	/* 뛶 */
      0xeb9bb7,	/* 뛷 */
      0xeb9bb8,	/* 뛸 */
      0xeb9bb9,	/* 뛹 */
      0xeb9bba,	/* 뛺 */
      0xeb9bbb,	/* 뛻 */
      0xeb9bbc,	/* 뛼 */
      0xeb9bbd,	/* 뛽 */
      0xeb9bbe,	/* 뛾 */
      0xeb9bbf,	/* 뛿 */
      0xeb9c80,	/* 뜀 */
      0xeb9c81,	/* 뜁 */
      0xeb9c82,	/* 뜂 */
      0xeb9c83,	/* 뜃 */
      0xeb9c84,	/* 뜄 */
      0xeb9c85,	/* 뜅 */
      0xeb9c86,	/* 뜆 */
      0xeb9c87,	/* 뜇 */
      0xeb9c88,	/* 뜈 */
      0xeb9c89,	/* 뜉 */
      0xeb9c8a,	/* 뜊 */
      0xeb9c8b,	/* 뜋 */
    },
    {
      0xeb9c8c,	/* 뜌 */
      0xeb9c8d,	/* 뜍 */
      0xeb9c8e,	/* 뜎 */
      0xeb9c8f,	/* 뜏 */
      0xeb9c90,	/* 뜐 */
      0xeb9c91,	/* 뜑 */
      0xeb9c92,	/* 뜒 */
      0xeb9c93,	/* 뜓 */
      0xeb9c94,	/* 뜔 */
      0xeb9c95,	/* 뜕 */
      0xeb9c96,	/* 뜖 */
      0xeb9c97,	/* 뜗 */
      0xeb9c98,	/* 뜘 */
      0xeb9c99,	/* 뜙 */
      0xeb9c9a,	/* 뜚 */
      0xeb9c9b,	/* 뜛 */
      0xeb9c9c,	/* 뜜 */
      0xeb9c9d,	/* 뜝 */
      0xeb9c9e,	/* 뜞 */
      0xeb9c9f,	/* 뜟 */
      0xeb9ca0,	/* 뜠 */
      0xeb9ca1,	/* 뜡 */
      0xeb9ca2,	/* 뜢 */
      0xeb9ca3,	/* 뜣 */
      0xeb9ca4,	/* 뜤 */
      0xeb9ca5,	/* 뜥 */
      0xeb9ca6,	/* 뜦 */
      0xeb9ca7,	/* 뜧 */
    },
    {
      0xeb9ca8,	/* 뜨 */
      0xeb9ca9,	/* 뜩 */
      0xeb9caa,	/* 뜪 */
      0xeb9cab,	/* 뜫 */
      0xeb9cac,	/* 뜬 */
      0xeb9cad,	/* 뜭 */
      0xeb9cae,	/* 뜮 */
      0xeb9caf,	/* 뜯 */
      0xeb9cb0,	/* 뜰 */
      0xeb9cb1,	/* 뜱 */
      0xeb9cb2,	/* 뜲 */
      0xeb9cb3,	/* 뜳 */
      0xeb9cb4,	/* 뜴 */
      0xeb9cb5,	/* 뜵 */
      0xeb9cb6,	/* 뜶 */
      0xeb9cb7,	/* 뜷 */
      0xeb9cb8,	/* 뜸 */
      0xeb9cb9,	/* 뜹 */
      0xeb9cba,	/* 뜺 */
      0xeb9cbb,	/* 뜻 */
      0xeb9cbc,	/* 뜼 */
      0xeb9cbd,	/* 뜽 */
      0xeb9cbe,	/* 뜾 */
      0xeb9cbf,	/* 뜿 */
      0xeb9d80,	/* 띀 */
      0xeb9d81,	/* 띁 */
      0xeb9d82,	/* 띂 */
      0xeb9d83,	/* 띃 */
    },
    {
      0xeb9d84,	/* 띄 */
      0xeb9d85,	/* 띅 */
      0xeb9d86,	/* 띆 */
      0xeb9d87,	/* 띇 */
      0xeb9d88,	/* 띈 */
      0xeb9d89,	/* 띉 */
      0xeb9d8a,	/* 띊 */
      0xeb9d8b,	/* 띋 */
      0xeb9d8c,	/* 띌 */
      0xeb9d8d,	/* 띍 */
      0xeb9d8e,	/* 띎 */
      0xeb9d8f,	/* 띏 */
      0xeb9d90,	/* 띐 */
      0xeb9d91,	/* 띑 */
      0xeb9d92,	/* 띒 */
      0xeb9d93,	/* 띓 */
      0xeb9d94,	/* 띔 */
      0xeb9d95,	/* 띕 */
      0xeb9d96,	/* 띖 */
      0xeb9d97,	/* 띗 */
      0xeb9d98,	/* 띘 */
      0xeb9d99,	/* 띙 */
      0xeb9d9a,	/* 띚 */
      0xeb9d9b,	/* 띛 */
      0xeb9d9c,	/* 띜 */
      0xeb9d9d,	/* 띝 */
      0xeb9d9e,	/* 띞 */
      0xeb9d9f,	/* 띟 */
    },
    {
      0xeb9da0,	/* 띠 */
      0xeb9da1,	/* 띡 */
      0xeb9da2,	/* 띢 */
      0xeb9da3,	/* 띣 */
      0xeb9da4,	/* 띤 */
      0xeb9da5,	/* 띥 */
      0xeb9da6,	/* 띦 */
      0xeb9da7,	/* 띧 */
      0xeb9da8,	/* 띨 */
      0xeb9da9,	/* 띩 */
      0xeb9daa,	/* 띪 */
      0xeb9dab,	/* 띫 */
      0xeb9dac,	/* 띬 */
      0xeb9dad,	/* 띭 */
      0xeb9dae,	/* 띮 */
      0xeb9daf,	/* 띯 */
      0xeb9db0,	/* 띰 */
      0xeb9db1,	/* 띱 */
      0xeb9db2,	/* 띲 */
      0xeb9db3,	/* 띳 */
      0xeb9db4,	/* 띴 */
      0xeb9db5,	/* 띵 */
      0xeb9db6,	/* 띶 */
      0xeb9db7,	/* 띷 */
      0xeb9db8,	/* 띸 */
      0xeb9db9,	/* 띹 */
      0xeb9dba,	/* 띺 */
      0xeb9dbb,	/* 띻 */
    },
  },
  {
    {
      0xeb9dbc,	/* 라 */
      0xeb9dbd,	/* 락 */
      0xeb9dbe,	/* 띾 */
      0xeb9dbf,	/* 띿 */
      0xeb9e80,	/* 란 */
      0xeb9e81,	/* 랁 */
      0xeb9e82,	/* 랂 */
      0xeb9e83,	/* 랃 */
      0xeb9e84,	/* 랄 */
      0xeb9e85,	/* 랅 */
      0xeb9e86,	/* 랆 */
      0xeb9e87,	/* 랇 */
      0xeb9e88,	/* 랈 */
      0xeb9e89,	/* 랉 */
      0xeb9e8a,	/* 랊 */
      0xeb9e8b,	/* 랋 */
      0xeb9e8c,	/* 람 */
      0xeb9e8d,	/* 랍 */
      0xeb9e8e,	/* 랎 */
      0xeb9e8f,	/* 랏 */
      0xeb9e90,	/* 랐 */
      0xeb9e91,	/* 랑 */
      0xeb9e92,	/* 랒 */
      0xeb9e93,	/* 랓 */
      0xeb9e94,	/* 랔 */
      0xeb9e95,	/* 랕 */
      0xeb9e96,	/* 랖 */
      0xeb9e97,	/* 랗 */
    },
    {
      0xeb9e98,	/* 래 */
      0xeb9e99,	/* 랙 */
      0xeb9e9a,	/* 랚 */
      0xeb9e9b,	/* 랛 */
      0xeb9e9c,	/* 랜 */
      0xeb9e9d,	/* 랝 */
      0xeb9e9e,	/* 랞 */
      0xeb9e9f,	/* 랟 */
      0xeb9ea0,	/* 랠 */
      0xeb9ea1,	/* 랡 */
      0xeb9ea2,	/* 랢 */
      0xeb9ea3,	/* 랣 */
      0xeb9ea4,	/* 랤 */
      0xeb9ea5,	/* 랥 */
      0xeb9ea6,	/* 랦 */
      0xeb9ea7,	/* 랧 */
      0xeb9ea8,	/* 램 */
      0xeb9ea9,	/* 랩 */
      0xeb9eaa,	/* 랪 */
      0xeb9eab,	/* 랫 */
      0xeb9eac,	/* 랬 */
      0xeb9ead,	/* 랭 */
      0xeb9eae,	/* 랮 */
      0xeb9eaf,	/* 랯 */
      0xeb9eb0,	/* 랰 */
      0xeb9eb1,	/* 랱 */
      0xeb9eb2,	/* 랲 */
      0xeb9eb3,	/* 랳 */
    },
    {
      0xeb9eb4,	/* 랴 */
      0xeb9eb5,	/* 략 */
      0xeb9eb6,	/* 랶 */
      0xeb9eb7,	/* 랷 */
      0xeb9eb8,	/* 랸 */
      0xeb9eb9,	/* 랹 */
      0xeb9eba,	/* 랺 */
      0xeb9ebb,	/* 랻 */
      0xeb9ebc,	/* 랼 */
      0xeb9ebd,	/* 랽 */
      0xeb9ebe,	/* 랾 */
      0xeb9ebf,	/* 랿 */
      0xeb9f80,	/* 럀 */
      0xeb9f81,	/* 럁 */
      0xeb9f82,	/* 럂 */
      0xeb9f83,	/* 럃 */
      0xeb9f84,	/* 럄 */
      0xeb9f85,	/* 럅 */
      0xeb9f86,	/* 럆 */
      0xeb9f87,	/* 럇 */
      0xeb9f88,	/* 럈 */
      0xeb9f89,	/* 량 */
      0xeb9f8a,	/* 럊 */
      0xeb9f8b,	/* 럋 */
      0xeb9f8c,	/* 럌 */
      0xeb9f8d,	/* 럍 */
      0xeb9f8e,	/* 럎 */
      0xeb9f8f,	/* 럏 */
    },
    {
      0xeb9f90,	/* 럐 */
      0xeb9f91,	/* 럑 */
      0xeb9f92,	/* 럒 */
      0xeb9f93,	/* 럓 */
      0xeb9f94,	/* 럔 */
      0xeb9f95,	/* 럕 */
      0xeb9f96,	/* 럖 */
      0xeb9f97,	/* 럗 */
      0xeb9f98,	/* 럘 */
      0xeb9f99,	/* 럙 */
      0xeb9f9a,	/* 럚 */
      0xeb9f9b,	/* 럛 */
      0xeb9f9c,	/* 럜 */
      0xeb9f9d,	/* 럝 */
      0xeb9f9e,	/* 럞 */
      0xeb9f9f,	/* 럟 */
      0xeb9fa0,	/* 럠 */
      0xeb9fa1,	/* 럡 */
      0xeb9fa2,	/* 럢 */
      0xeb9fa3,	/* 럣 */
      0xeb9fa4,	/* 럤 */
      0xeb9fa5,	/* 럥 */
      0xeb9fa6,	/* 럦 */
      0xeb9fa7,	/* 럧 */
      0xeb9fa8,	/* 럨 */
      0xeb9fa9,	/* 럩 */
      0xeb9faa,	/* 럪 */
      0xeb9fab,	/* 럫 */
    },
    {
      0xeb9fac,	/* 러 */
      0xeb9fad,	/* 럭 */
      0xeb9fae,	/* 럮 */
      0xeb9faf,	/* 럯 */
      0xeb9fb0,	/* 런 */
      0xeb9fb1,	/* 럱 */
      0xeb9fb2,	/* 럲 */
      0xeb9fb3,	/* 럳 */
      0xeb9fb4,	/* 럴 */
      0xeb9fb5,	/* 럵 */
      0xeb9fb6,	/* 럶 */
      0xeb9fb7,	/* 럷 */
      0xeb9fb8,	/* 럸 */
      0xeb9fb9,	/* 럹 */
      0xeb9fba,	/* 럺 */
      0xeb9fbb,	/* 럻 */
      0xeb9fbc,	/* 럼 */
      0xeb9fbd,	/* 럽 */
      0xeb9fbe,	/* 럾 */
      0xeb9fbf,	/* 럿 */
      0xeba080,	/* 렀 */
      0xeba081,	/* 렁 */
      0xeba082,	/* 렂 */
      0xeba083,	/* 렃 */
      0xeba084,	/* 렄 */
      0xeba085,	/* 렅 */
      0xeba086,	/* 렆 */
      0xeba087,	/* 렇 */
    },
    {
      0xeba088,	/* 레 */
      0xeba089,	/* 렉 */
      0xeba08a,	/* 렊 */
      0xeba08b,	/* 렋 */
      0xeba08c,	/* 렌 */
      0xeba08d,	/* 렍 */
      0xeba08e,	/* 렎 */
      0xeba08f,	/* 렏 */
      0xeba090,	/* 렐 */
      0xeba091,	/* 렑 */
      0xeba092,	/* 렒 */
      0xeba093,	/* 렓 */
      0xeba094,	/* 렔 */
      0xeba095,	/* 렕 */
      0xeba096,	/* 렖 */
      0xeba097,	/* 렗 */
      0xeba098,	/* 렘 */
      0xeba099,	/* 렙 */
      0xeba09a,	/* 렚 */
      0xeba09b,	/* 렛 */
      0xeba09c,	/* 렜 */
      0xeba09d,	/* 렝 */
      0xeba09e,	/* 렞 */
      0xeba09f,	/* 렟 */
      0xeba0a0,	/* 렠 */
      0xeba0a1,	/* 렡 */
      0xeba0a2,	/* 렢 */
      0xeba0a3,	/* 렣 */
    },
    {
      0xeba0a4,	/* 려 */
      0xeba0a5,	/* 력 */
      0xeba0a6,	/* 렦 */
      0xeba0a7,	/* 렧 */
      0xeba0a8,	/* 련 */
      0xeba0a9,	/* 렩 */
      0xeba0aa,	/* 렪 */
      0xeba0ab,	/* 렫 */
      0xeba0ac,	/* 렬 */
      0xeba0ad,	/* 렭 */
      0xeba0ae,	/* 렮 */
      0xeba0af,	/* 렯 */
      0xeba0b0,	/* 렰 */
      0xeba0b1,	/* 렱 */
      0xeba0b2,	/* 렲 */
      0xeba0b3,	/* 렳 */
      0xeba0b4,	/* 렴 */
      0xeba0b5,	/* 렵 */
      0xeba0b6,	/* 렶 */
      0xeba0b7,	/* 렷 */
      0xeba0b8,	/* 렸 */
      0xeba0b9,	/* 령 */
      0xeba0ba,	/* 렺 */
      0xeba0bb,	/* 렻 */
      0xeba0bc,	/* 렼 */
      0xeba0bd,	/* 렽 */
      0xeba0be,	/* 렾 */
      0xeba0bf,	/* 렿 */
    },
    {
      0xeba180,	/* 례 */
      0xeba181,	/* 롁 */
      0xeba182,	/* 롂 */
      0xeba183,	/* 롃 */
      0xeba184,	/* 롄 */
      0xeba185,	/* 롅 */
      0xeba186,	/* 롆 */
      0xeba187,	/* 롇 */
      0xeba188,	/* 롈 */
      0xeba189,	/* 롉 */
      0xeba18a,	/* 롊 */
      0xeba18b,	/* 롋 */
      0xeba18c,	/* 롌 */
      0xeba18d,	/* 롍 */
      0xeba18e,	/* 롎 */
      0xeba18f,	/* 롏 */
      0xeba190,	/* 롐 */
      0xeba191,	/* 롑 */
      0xeba192,	/* 롒 */
      0xeba193,	/* 롓 */
      0xeba194,	/* 롔 */
      0xeba195,	/* 롕 */
      0xeba196,	/* 롖 */
      0xeba197,	/* 롗 */
      0xeba198,	/* 롘 */
      0xeba199,	/* 롙 */
      0xeba19a,	/* 롚 */
      0xeba19b,	/* 롛 */
    },
    {
      0xeba19c,	/* 로 */
      0xeba19d,	/* 록 */
      0xeba19e,	/* 롞 */
      0xeba19f,	/* 롟 */
      0xeba1a0,	/* 론 */
      0xeba1a1,	/* 롡 */
      0xeba1a2,	/* 롢 */
      0xeba1a3,	/* 롣 */
      0xeba1a4,	/* 롤 */
      0xeba1a5,	/* 롥 */
      0xeba1a6,	/* 롦 */
      0xeba1a7,	/* 롧 */
      0xeba1a8,	/* 롨 */
      0xeba1a9,	/* 롩 */
      0xeba1aa,	/* 롪 */
      0xeba1ab,	/* 롫 */
      0xeba1ac,	/* 롬 */
      0xeba1ad,	/* 롭 */
      0xeba1ae,	/* 롮 */
      0xeba1af,	/* 롯 */
      0xeba1b0,	/* 롰 */
      0xeba1b1,	/* 롱 */
      0xeba1b2,	/* 롲 */
      0xeba1b3,	/* 롳 */
      0xeba1b4,	/* 롴 */
      0xeba1b5,	/* 롵 */
      0xeba1b6,	/* 롶 */
      0xeba1b7,	/* 롷 */
    },
    {
      0xeba1b8,	/* 롸 */
      0xeba1b9,	/* 롹 */
      0xeba1ba,	/* 롺 */
      0xeba1bb,	/* 롻 */
      0xeba1bc,	/* 롼 */
      0xeba1bd,	/* 롽 */
      0xeba1be,	/* 롾 */
      0xeba1bf,	/* 롿 */
      0xeba280,	/* 뢀 */
      0xeba281,	/* 뢁 */
      0xeba282,	/* 뢂 */
      0xeba283,	/* 뢃 */
      0xeba284,	/* 뢄 */
      0xeba285,	/* 뢅 */
      0xeba286,	/* 뢆 */
      0xeba287,	/* 뢇 */
      0xeba288,	/* 뢈 */
      0xeba289,	/* 뢉 */
      0xeba28a,	/* 뢊 */
      0xeba28b,	/* 뢋 */
      0xeba28c,	/* 뢌 */
      0xeba28d,	/* 뢍 */
      0xeba28e,	/* 뢎 */
      0xeba28f,	/* 뢏 */
      0xeba290,	/* 뢐 */
      0xeba291,	/* 뢑 */
      0xeba292,	/* 뢒 */
      0xeba293,	/* 뢓 */
    },
    {
      0xeba294,	/* 뢔 */
      0xeba295,	/* 뢕 */
      0xeba296,	/* 뢖 */
      0xeba297,	/* 뢗 */
      0xeba298,	/* 뢘 */
      0xeba299,	/* 뢙 */
      0xeba29a,	/* 뢚 */
      0xeba29b,	/* 뢛 */
      0xeba29c,	/* 뢜 */
      0xeba29d,	/* 뢝 */
      0xeba29e,	/* 뢞 */
      0xeba29f,	/* 뢟 */
      0xeba2a0,	/* 뢠 */
      0xeba2a1,	/* 뢡 */
      0xeba2a2,	/* 뢢 */
      0xeba2a3,	/* 뢣 */
      0xeba2a4,	/* 뢤 */
      0xeba2a5,	/* 뢥 */
      0xeba2a6,	/* 뢦 */
      0xeba2a7,	/* 뢧 */
      0xeba2a8,	/* 뢨 */
      0xeba2a9,	/* 뢩 */
      0xeba2aa,	/* 뢪 */
      0xeba2ab,	/* 뢫 */
      0xeba2ac,	/* 뢬 */
      0xeba2ad,	/* 뢭 */
      0xeba2ae,	/* 뢮 */
      0xeba2af,	/* 뢯 */
    },
    {
      0xeba2b0,	/* 뢰 */
      0xeba2b1,	/* 뢱 */
      0xeba2b2,	/* 뢲 */
      0xeba2b3,	/* 뢳 */
      0xeba2b4,	/* 뢴 */
      0xeba2b5,	/* 뢵 */
      0xeba2b6,	/* 뢶 */
      0xeba2b7,	/* 뢷 */
      0xeba2b8,	/* 뢸 */
      0xeba2b9,	/* 뢹 */
      0xeba2ba,	/* 뢺 */
      0xeba2bb,	/* 뢻 */
      0xeba2bc,	/* 뢼 */
      0xeba2bd,	/* 뢽 */
      0xeba2be,	/* 뢾 */
      0xeba2bf,	/* 뢿 */
      0xeba380,	/* 룀 */
      0xeba381,	/* 룁 */
      0xeba382,	/* 룂 */
      0xeba383,	/* 룃 */
      0xeba384,	/* 룄 */
      0xeba385,	/* 룅 */
      0xeba386,	/* 룆 */
      0xeba387,	/* 룇 */
      0xeba388,	/* 룈 */
      0xeba389,	/* 룉 */
      0xeba38a,	/* 룊 */
      0xeba38b,	/* 룋 */
    },
    {
      0xeba38c,	/* 료 */
      0xeba38d,	/* 룍 */
      0xeba38e,	/* 룎 */
      0xeba38f,	/* 룏 */
      0xeba390,	/* 룐 */
      0xeba391,	/* 룑 */
      0xeba392,	/* 룒 */
      0xeba393,	/* 룓 */
      0xeba394,	/* 룔 */
      0xeba395,	/* 룕 */
      0xeba396,	/* 룖 */
      0xeba397,	/* 룗 */
      0xeba398,	/* 룘 */
      0xeba399,	/* 룙 */
      0xeba39a,	/* 룚 */
      0xeba39b,	/* 룛 */
      0xeba39c,	/* 룜 */
      0xeba39d,	/* 룝 */
      0xeba39e,	/* 룞 */
      0xeba39f,	/* 룟 */
      0xeba3a0,	/* 룠 */
      0xeba3a1,	/* 룡 */
      0xeba3a2,	/* 룢 */
      0xeba3a3,	/* 룣 */
      0xeba3a4,	/* 룤 */
      0xeba3a5,	/* 룥 */
      0xeba3a6,	/* 룦 */
      0xeba3a7,	/* 룧 */
    },
    {
      0xeba3a8,	/* 루 */
      0xeba3a9,	/* 룩 */
      0xeba3aa,	/* 룪 */
      0xeba3ab,	/* 룫 */
      0xeba3ac,	/* 룬 */
      0xeba3ad,	/* 룭 */
      0xeba3ae,	/* 룮 */
      0xeba3af,	/* 룯 */
      0xeba3b0,	/* 룰 */
      0xeba3b1,	/* 룱 */
      0xeba3b2,	/* 룲 */
      0xeba3b3,	/* 룳 */
      0xeba3b4,	/* 룴 */
      0xeba3b5,	/* 룵 */
      0xeba3b6,	/* 룶 */
      0xeba3b7,	/* 룷 */
      0xeba3b8,	/* 룸 */
      0xeba3b9,	/* 룹 */
      0xeba3ba,	/* 룺 */
      0xeba3bb,	/* 룻 */
      0xeba3bc,	/* 룼 */
      0xeba3bd,	/* 룽 */
      0xeba3be,	/* 룾 */
      0xeba3bf,	/* 룿 */
      0xeba480,	/* 뤀 */
      0xeba481,	/* 뤁 */
      0xeba482,	/* 뤂 */
      0xeba483,	/* 뤃 */
    },
    {
      0xeba484,	/* 뤄 */
      0xeba485,	/* 뤅 */
      0xeba486,	/* 뤆 */
      0xeba487,	/* 뤇 */
      0xeba488,	/* 뤈 */
      0xeba489,	/* 뤉 */
      0xeba48a,	/* 뤊 */
      0xeba48b,	/* 뤋 */
      0xeba48c,	/* 뤌 */
      0xeba48d,	/* 뤍 */
      0xeba48e,	/* 뤎 */
      0xeba48f,	/* 뤏 */
      0xeba490,	/* 뤐 */
      0xeba491,	/* 뤑 */
      0xeba492,	/* 뤒 */
      0xeba493,	/* 뤓 */
      0xeba494,	/* 뤔 */
      0xeba495,	/* 뤕 */
      0xeba496,	/* 뤖 */
      0xeba497,	/* 뤗 */
      0xeba498,	/* 뤘 */
      0xeba499,	/* 뤙 */
      0xeba49a,	/* 뤚 */
      0xeba49b,	/* 뤛 */
      0xeba49c,	/* 뤜 */
      0xeba49d,	/* 뤝 */
      0xeba49e,	/* 뤞 */
      0xeba49f,	/* 뤟 */
    },
    {
      0xeba4a0,	/* 뤠 */
      0xeba4a1,	/* 뤡 */
      0xeba4a2,	/* 뤢 */
      0xeba4a3,	/* 뤣 */
      0xeba4a4,	/* 뤤 */
      0xeba4a5,	/* 뤥 */
      0xeba4a6,	/* 뤦 */
      0xeba4a7,	/* 뤧 */
      0xeba4a8,	/* 뤨 */
      0xeba4a9,	/* 뤩 */
      0xeba4aa,	/* 뤪 */
      0xeba4ab,	/* 뤫 */
      0xeba4ac,	/* 뤬 */
      0xeba4ad,	/* 뤭 */
      0xeba4ae,	/* 뤮 */
      0xeba4af,	/* 뤯 */
      0xeba4b0,	/* 뤰 */
      0xeba4b1,	/* 뤱 */
      0xeba4b2,	/* 뤲 */
      0xeba4b3,	/* 뤳 */
      0xeba4b4,	/* 뤴 */
      0xeba4b5,	/* 뤵 */
      0xeba4b6,	/* 뤶 */
      0xeba4b7,	/* 뤷 */
      0xeba4b8,	/* 뤸 */
      0xeba4b9,	/* 뤹 */
      0xeba4ba,	/* 뤺 */
      0xeba4bb,	/* 뤻 */
    },
    {
      0xeba4bc,	/* 뤼 */
      0xeba4bd,	/* 뤽 */
      0xeba4be,	/* 뤾 */
      0xeba4bf,	/* 뤿 */
      0xeba580,	/* 륀 */
      0xeba581,	/* 륁 */
      0xeba582,	/* 륂 */
      0xeba583,	/* 륃 */
      0xeba584,	/* 륄 */
      0xeba585,	/* 륅 */
      0xeba586,	/* 륆 */
      0xeba587,	/* 륇 */
      0xeba588,	/* 륈 */
      0xeba589,	/* 륉 */
      0xeba58a,	/* 륊 */
      0xeba58b,	/* 륋 */
      0xeba58c,	/* 륌 */
      0xeba58d,	/* 륍 */
      0xeba58e,	/* 륎 */
      0xeba58f,	/* 륏 */
      0xeba590,	/* 륐 */
      0xeba591,	/* 륑 */
      0xeba592,	/* 륒 */
      0xeba593,	/* 륓 */
      0xeba594,	/* 륔 */
      0xeba595,	/* 륕 */
      0xeba596,	/* 륖 */
      0xeba597,	/* 륗 */
    },
    {
      0xeba598,	/* 류 */
      0xeba599,	/* 륙 */
      0xeba59a,	/* 륚 */
      0xeba59b,	/* 륛 */
      0xeba59c,	/* 륜 */
      0xeba59d,	/* 륝 */
      0xeba59e,	/* 륞 */
      0xeba59f,	/* 륟 */
      0xeba5a0,	/* 률 */
      0xeba5a1,	/* 륡 */
      0xeba5a2,	/* 륢 */
      0xeba5a3,	/* 륣 */
      0xeba5a4,	/* 륤 */
      0xeba5a5,	/* 륥 */
      0xeba5a6,	/* 륦 */
      0xeba5a7,	/* 륧 */
      0xeba5a8,	/* 륨 */
      0xeba5a9,	/* 륩 */
      0xeba5aa,	/* 륪 */
      0xeba5ab,	/* 륫 */
      0xeba5ac,	/* 륬 */
      0xeba5ad,	/* 륭 */
      0xeba5ae,	/* 륮 */
      0xeba5af,	/* 륯 */
      0xeba5b0,	/* 륰 */
      0xeba5b1,	/* 륱 */
      0xeba5b2,	/* 륲 */
      0xeba5b3,	/* 륳 */
    },
    {
      0xeba5b4,	/* 르 */
      0xeba5b5,	/* 륵 */
      0xeba5b6,	/* 륶 */
      0xeba5b7,	/* 륷 */
      0xeba5b8,	/* 른 */
      0xeba5b9,	/* 륹 */
      0xeba5ba,	/* 륺 */
      0xeba5bb,	/* 륻 */
      0xeba5bc,	/* 를 */
      0xeba5bd,	/* 륽 */
      0xeba5be,	/* 륾 */
      0xeba5bf,	/* 륿 */
      0xeba680,	/* 릀 */
      0xeba681,	/* 릁 */
      0xeba682,	/* 릂 */
      0xeba683,	/* 릃 */
      0xeba684,	/* 름 */
      0xeba685,	/* 릅 */
      0xeba686,	/* 릆 */
      0xeba687,	/* 릇 */
      0xeba688,	/* 릈 */
      0xeba689,	/* 릉 */
      0xeba68a,	/* 릊 */
      0xeba68b,	/* 릋 */
      0xeba68c,	/* 릌 */
      0xeba68d,	/* 릍 */
      0xeba68e,	/* 릎 */
      0xeba68f,	/* 릏 */
    },
    {
      0xeba690,	/* 릐 */
      0xeba691,	/* 릑 */
      0xeba692,	/* 릒 */
      0xeba693,	/* 릓 */
      0xeba694,	/* 릔 */
      0xeba695,	/* 릕 */
      0xeba696,	/* 릖 */
      0xeba697,	/* 릗 */
      0xeba698,	/* 릘 */
      0xeba699,	/* 릙 */
      0xeba69a,	/* 릚 */
      0xeba69b,	/* 릛 */
      0xeba69c,	/* 릜 */
      0xeba69d,	/* 릝 */
      0xeba69e,	/* 릞 */
      0xeba69f,	/* 릟 */
      0xeba6a0,	/* 릠 */
      0xeba6a1,	/* 릡 */
      0xeba6a2,	/* 릢 */
      0xeba6a3,	/* 릣 */
      0xeba6a4,	/* 릤 */
      0xeba6a5,	/* 릥 */
      0xeba6a6,	/* 릦 */
      0xeba6a7,	/* 릧 */
      0xeba6a8,	/* 릨 */
      0xeba6a9,	/* 릩 */
      0xeba6aa,	/* 릪 */
      0xeba6ab,	/* 릫 */
    },
    {
      0xeba6ac,	/* 리 */
      0xeba6ad,	/* 릭 */
      0xeba6ae,	/* 릮 */
      0xeba6af,	/* 릯 */
      0xeba6b0,	/* 린 */
      0xeba6b1,	/* 릱 */
      0xeba6b2,	/* 릲 */
      0xeba6b3,	/* 릳 */
      0xeba6b4,	/* 릴 */
      0xeba6b5,	/* 릵 */
      0xeba6b6,	/* 릶 */
      0xeba6b7,	/* 릷 */
      0xeba6b8,	/* 릸 */
      0xeba6b9,	/* 릹 */
      0xeba6ba,	/* 릺 */
      0xeba6bb,	/* 릻 */
      0xeba6bc,	/* 림 */
      0xeba6bd,	/* 립 */
      0xeba6be,	/* 릾 */
      0xeba6bf,	/* 릿 */
      0xeba780,	/* 맀 */
      0xeba781,	/* 링 */
      0xeba782,	/* 맂 */
      0xeba783,	/* 맃 */
      0xeba784,	/* 맄 */
      0xeba785,	/* 맅 */
      0xeba786,	/* 맆 */
      0xeba787,	/* 맇 */
    },
  },
  {
    {
      0xeba788,	/* 마 */
      0xeba789,	/* 막 */
      0xeba78a,	/* 맊 */
      0xeba78b,	/* 맋 */
      0xeba78c,	/* 만 */
      0xeba78d,	/* 맍 */
      0xeba78e,	/* 많 */
      0xeba78f,	/* 맏 */
      0xeba790,	/* 말 */
      0xeba791,	/* 맑 */
      0xeba792,	/* 맒 */
      0xeba793,	/* 맓 */
      0xeba794,	/* 맔 */
      0xeba795,	/* 맕 */
      0xeba796,	/* 맖 */
      0xeba797,	/* 맗 */
      0xeba798,	/* 맘 */
      0xeba799,	/* 맙 */
      0xeba79a,	/* 맚 */
      0xeba79b,	/* 맛 */
      0xeba79c,	/* 맜 */
      0xeba79d,	/* 망 */
      0xeba79e,	/* 맞 */
      0xeba79f,	/* 맟 */
      0xeba7a0,	/* 맠 */
      0xeba7a1,	/* 맡 */
      0xeba7a2,	/* 맢 */
      0xeba7a3,	/* 맣 */
    },
    {
      0xeba7a4,	/* 매 */
      0xeba7a5,	/* 맥 */
      0xeba7a6,	/* 맦 */
      0xeba7a7,	/* 맧 */
      0xeba7a8,	/* 맨 */
      0xeba7a9,	/* 맩 */
      0xeba7aa,	/* 맪 */
      0xeba7ab,	/* 맫 */
      0xeba7ac,	/* 맬 */
      0xeba7ad,	/* 맭 */
      0xeba7ae,	/* 맮 */
      0xeba7af,	/* 맯 */
      0xeba7b0,	/* 맰 */
      0xeba7b1,	/* 맱 */
      0xeba7b2,	/* 맲 */
      0xeba7b3,	/* 맳 */
      0xeba7b4,	/* 맴 */
      0xeba7b5,	/* 맵 */
      0xeba7b6,	/* 맶 */
      0xeba7b7,	/* 맷 */
      0xeba7b8,	/* 맸 */
      0xeba7b9,	/* 맹 */
      0xeba7ba,	/* 맺 */
      0xeba7bb,	/* 맻 */
      0xeba7bc,	/* 맼 */
      0xeba7bd,	/* 맽 */
      0xeba7be,	/* 맾 */
      0xeba7bf,	/* 맿 */
    },
    {
      0xeba880,	/* 먀 */
      0xeba881,	/* 먁 */
      0xeba882,	/* 먂 */
      0xeba883,	/* 먃 */
      0xeba884,	/* 먄 */
      0xeba885,	/* 먅 */
      0xeba886,	/* 먆 */
      0xeba887,	/* 먇 */
      0xeba888,	/* 먈 */
      0xeba889,	/* 먉 */
      0xeba88a,	/* 먊 */
      0xeba88b,	/* 먋 */
      0xeba88c,	/* 먌 */
      0xeba88d,	/* 먍 */
      0xeba88e,	/* 먎 */
      0xeba88f,	/* 먏 */
      0xeba890,	/* 먐 */
      0xeba891,	/* 먑 */
      0xeba892,	/* 먒 */
      0xeba893,	/* 먓 */
      0xeba894,	/* 먔 */
      0xeba895,	/* 먕 */
      0xeba896,	/* 먖 */
      0xeba897,	/* 먗 */
      0xeba898,	/* 먘 */
      0xeba899,	/* 먙 */
      0xeba89a,	/* 먚 */
      0xeba89b,	/* 먛 */
    },
    {
      0xeba89c,	/* 먜 */
      0xeba89d,	/* 먝 */
      0xeba89e,	/* 먞 */
      0xeba89f,	/* 먟 */
      0xeba8a0,	/* 먠 */
      0xeba8a1,	/* 먡 */
      0xeba8a2,	/* 먢 */
      0xeba8a3,	/* 먣 */
      0xeba8a4,	/* 먤 */
      0xeba8a5,	/* 먥 */
      0xeba8a6,	/* 먦 */
      0xeba8a7,	/* 먧 */
      0xeba8a8,	/* 먨 */
      0xeba8a9,	/* 먩 */
      0xeba8aa,	/* 먪 */
      0xeba8ab,	/* 먫 */
      0xeba8ac,	/* 먬 */
      0xeba8ad,	/* 먭 */
      0xeba8ae,	/* 먮 */
      0xeba8af,	/* 먯 */
      0xeba8b0,	/* 먰 */
      0xeba8b1,	/* 먱 */
      0xeba8b2,	/* 먲 */
      0xeba8b3,	/* 먳 */
      0xeba8b4,	/* 먴 */
      0xeba8b5,	/* 먵 */
      0xeba8b6,	/* 먶 */
      0xeba8b7,	/* 먷 */
    },
    {
      0xeba8b8,	/* 머 */
      0xeba8b9,	/* 먹 */
      0xeba8ba,	/* 먺 */
      0xeba8bb,	/* 먻 */
      0xeba8bc,	/* 먼 */
      0xeba8bd,	/* 먽 */
      0xeba8be,	/* 먾 */
      0xeba8bf,	/* 먿 */
      0xeba980,	/* 멀 */
      0xeba981,	/* 멁 */
      0xeba982,	/* 멂 */
      0xeba983,	/* 멃 */
      0xeba984,	/* 멄 */
      0xeba985,	/* 멅 */
      0xeba986,	/* 멆 */
      0xeba987,	/* 멇 */
      0xeba988,	/* 멈 */
      0xeba989,	/* 멉 */
      0xeba98a,	/* 멊 */
      0xeba98b,	/* 멋 */
      0xeba98c,	/* 멌 */
      0xeba98d,	/* 멍 */
      0xeba98e,	/* 멎 */
      0xeba98f,	/* 멏 */
      0xeba990,	/* 멐 */
      0xeba991,	/* 멑 */
      0xeba992,	/* 멒 */
      0xeba993,	/* 멓 */
    },
    {
      0xeba994,	/* 메 */
      0xeba995,	/* 멕 */
      0xeba996,	/* 멖 */
      0xeba997,	/* 멗 */
      0xeba998,	/* 멘 */
      0xeba999,	/* 멙 */
      0xeba99a,	/* 멚 */
      0xeba99b,	/* 멛 */
      0xeba99c,	/* 멜 */
      0xeba99d,	/* 멝 */
      0xeba99e,	/* 멞 */
      0xeba99f,	/* 멟 */
      0xeba9a0,	/* 멠 */
      0xeba9a1,	/* 멡 */
      0xeba9a2,	/* 멢 */
      0xeba9a3,	/* 멣 */
      0xeba9a4,	/* 멤 */
      0xeba9a5,	/* 멥 */
      0xeba9a6,	/* 멦 */
      0xeba9a7,	/* 멧 */
      0xeba9a8,	/* 멨 */
      0xeba9a9,	/* 멩 */
      0xeba9aa,	/* 멪 */
      0xeba9ab,	/* 멫 */
      0xeba9ac,	/* 멬 */
      0xeba9ad,	/* 멭 */
      0xeba9ae,	/* 멮 */
      0xeba9af,	/* 멯 */
    },
    {
      0xeba9b0,	/* 며 */
      0xeba9b1,	/* 멱 */
      0xeba9b2,	/* 멲 */
      0xeba9b3,	/* 멳 */
      0xeba9b4,	/* 면 */
      0xeba9b5,	/* 멵 */
      0xeba9b6,	/* 멶 */
      0xeba9b7,	/* 멷 */
      0xeba9b8,	/* 멸 */
      0xeba9b9,	/* 멹 */
      0xeba9ba,	/* 멺 */
      0xeba9bb,	/* 멻 */
      0xeba9bc,	/* 멼 */
      0xeba9bd,	/* 멽 */
      0xeba9be,	/* 멾 */
      0xeba9bf,	/* 멿 */
      0xebaa80,	/* 몀 */
      0xebaa81,	/* 몁 */
      0xebaa82,	/* 몂 */
      0xebaa83,	/* 몃 */
      0xebaa84,	/* 몄 */
      0xebaa85,	/* 명 */
      0xebaa86,	/* 몆 */
      0xebaa87,	/* 몇 */
      0xebaa88,	/* 몈 */
      0xebaa89,	/* 몉 */
      0xebaa8a,	/* 몊 */
      0xebaa8b,	/* 몋 */
    },
    {
      0xebaa8c,	/* 몌 */
      0xebaa8d,	/* 몍 */
      0xebaa8e,	/* 몎 */
      0xebaa8f,	/* 몏 */
      0xebaa90,	/* 몐 */
      0xebaa91,	/* 몑 */
      0xebaa92,	/* 몒 */
      0xebaa93,	/* 몓 */
      0xebaa94,	/* 몔 */
      0xebaa95,	/* 몕 */
      0xebaa96,	/* 몖 */
      0xebaa97,	/* 몗 */
      0xebaa98,	/* 몘 */
      0xebaa99,	/* 몙 */
      0xebaa9a,	/* 몚 */
      0xebaa9b,	/* 몛 */
      0xebaa9c,	/* 몜 */
      0xebaa9d,	/* 몝 */
      0xebaa9e,	/* 몞 */
      0xebaa9f,	/* 몟 */
      0xebaaa0,	/* 몠 */
      0xebaaa1,	/* 몡 */
      0xebaaa2,	/* 몢 */
      0xebaaa3,	/* 몣 */
      0xebaaa4,	/* 몤 */
      0xebaaa5,	/* 몥 */
      0xebaaa6,	/* 몦 */
      0xebaaa7,	/* 몧 */
    },
    {
      0xebaaa8,	/* 모 */
      0xebaaa9,	/* 목 */
      0xebaaaa,	/* 몪 */
      0xebaaab,	/* 몫 */
      0xebaaac,	/* 몬 */
      0xebaaad,	/* 몭 */
      0xebaaae,	/* 몮 */
      0xebaaaf,	/* 몯 */
      0xebaab0,	/* 몰 */
      0xebaab1,	/* 몱 */
      0xebaab2,	/* 몲 */
      0xebaab3,	/* 몳 */
      0xebaab4,	/* 몴 */
      0xebaab5,	/* 몵 */
      0xebaab6,	/* 몶 */
      0xebaab7,	/* 몷 */
      0xebaab8,	/* 몸 */
      0xebaab9,	/* 몹 */
      0xebaaba,	/* 몺 */
      0xebaabb,	/* 못 */
      0xebaabc,	/* 몼 */
      0xebaabd,	/* 몽 */
      0xebaabe,	/* 몾 */
      0xebaabf,	/* 몿 */
      0xebab80,	/* 뫀 */
      0xebab81,	/* 뫁 */
      0xebab82,	/* 뫂 */
      0xebab83,	/* 뫃 */
    },
    {
      0xebab84,	/* 뫄 */
      0xebab85,	/* 뫅 */
      0xebab86,	/* 뫆 */
      0xebab87,	/* 뫇 */
      0xebab88,	/* 뫈 */
      0xebab89,	/* 뫉 */
      0xebab8a,	/* 뫊 */
      0xebab8b,	/* 뫋 */
      0xebab8c,	/* 뫌 */
      0xebab8d,	/* 뫍 */
      0xebab8e,	/* 뫎 */
      0xebab8f,	/* 뫏 */
      0xebab90,	/* 뫐 */
      0xebab91,	/* 뫑 */
      0xebab92,	/* 뫒 */
      0xebab93,	/* 뫓 */
      0xebab94,	/* 뫔 */
      0xebab95,	/* 뫕 */
      0xebab96,	/* 뫖 */
      0xebab97,	/* 뫗 */
      0xebab98,	/* 뫘 */
      0xebab99,	/* 뫙 */
      0xebab9a,	/* 뫚 */
      0xebab9b,	/* 뫛 */
      0xebab9c,	/* 뫜 */
      0xebab9d,	/* 뫝 */
      0xebab9e,	/* 뫞 */
      0xebab9f,	/* 뫟 */
    },
    {
      0xebaba0,	/* 뫠 */
      0xebaba1,	/* 뫡 */
      0xebaba2,	/* 뫢 */
      0xebaba3,	/* 뫣 */
      0xebaba4,	/* 뫤 */
      0xebaba5,	/* 뫥 */
      0xebaba6,	/* 뫦 */
      0xebaba7,	/* 뫧 */
      0xebaba8,	/* 뫨 */
      0xebaba9,	/* 뫩 */
      0xebabaa,	/* 뫪 */
      0xebabab,	/* 뫫 */
      0xebabac,	/* 뫬 */
      0xebabad,	/* 뫭 */
      0xebabae,	/* 뫮 */
      0xebabaf,	/* 뫯 */
      0xebabb0,	/* 뫰 */
      0xebabb1,	/* 뫱 */
      0xebabb2,	/* 뫲 */
      0xebabb3,	/* 뫳 */
      0xebabb4,	/* 뫴 */
      0xebabb5,	/* 뫵 */
      0xebabb6,	/* 뫶 */
      0xebabb7,	/* 뫷 */
      0xebabb8,	/* 뫸 */
      0xebabb9,	/* 뫹 */
      0xebabba,	/* 뫺 */
      0xebabbb,	/* 뫻 */
    },
    {
      0xebabbc,	/* 뫼 */
      0xebabbd,	/* 뫽 */
      0xebabbe,	/* 뫾 */
      0xebabbf,	/* 뫿 */
      0xebac80,	/* 묀 */
      0xebac81,	/* 묁 */
      0xebac82,	/* 묂 */
      0xebac83,	/* 묃 */
      0xebac84,	/* 묄 */
      0xebac85,	/* 묅 */
      0xebac86,	/* 묆 */
      0xebac87,	/* 묇 */
      0xebac88,	/* 묈 */
      0xebac89,	/* 묉 */
      0xebac8a,	/* 묊 */
      0xebac8b,	/* 묋 */
      0xebac8c,	/* 묌 */
      0xebac8d,	/* 묍 */
      0xebac8e,	/* 묎 */
      0xebac8f,	/* 묏 */
      0xebac90,	/* 묐 */
      0xebac91,	/* 묑 */
      0xebac92,	/* 묒 */
      0xebac93,	/* 묓 */
      0xebac94,	/* 묔 */
      0xebac95,	/* 묕 */
      0xebac96,	/* 묖 */
      0xebac97,	/* 묗 */
    },
    {
      0xebac98,	/* 묘 */
      0xebac99,	/* 묙 */
      0xebac9a,	/* 묚 */
      0xebac9b,	/* 묛 */
      0xebac9c,	/* 묜 */
      0xebac9d,	/* 묝 */
      0xebac9e,	/* 묞 */
      0xebac9f,	/* 묟 */
      0xebaca0,	/* 묠 */
      0xebaca1,	/* 묡 */
      0xebaca2,	/* 묢 */
      0xebaca3,	/* 묣 */
      0xebaca4,	/* 묤 */
      0xebaca5,	/* 묥 */
      0xebaca6,	/* 묦 */
      0xebaca7,	/* 묧 */
      0xebaca8,	/* 묨 */
      0xebaca9,	/* 묩 */
      0xebacaa,	/* 묪 */
      0xebacab,	/* 묫 */
      0xebacac,	/* 묬 */
      0xebacad,	/* 묭 */
      0xebacae,	/* 묮 */
      0xebacaf,	/* 묯 */
      0xebacb0,	/* 묰 */
      0xebacb1,	/* 묱 */
      0xebacb2,	/* 묲 */
      0xebacb3,	/* 묳 */
    },
    {
      0xebacb4,	/* 무 */
      0xebacb5,	/* 묵 */
      0xebacb6,	/* 묶 */
      0xebacb7,	/* 묷 */
      0xebacb8,	/* 문 */
      0xebacb9,	/* 묹 */
      0xebacba,	/* 묺 */
      0xebacbb,	/* 묻 */
      0xebacbc,	/* 물 */
      0xebacbd,	/* 묽 */
      0xebacbe,	/* 묾 */
      0xebacbf,	/* 묿 */
      0xebad80,	/* 뭀 */
      0xebad81,	/* 뭁 */
      0xebad82,	/* 뭂 */
      0xebad83,	/* 뭃 */
      0xebad84,	/* 뭄 */
      0xebad85,	/* 뭅 */
      0xebad86,	/* 뭆 */
      0xebad87,	/* 뭇 */
      0xebad88,	/* 뭈 */
      0xebad89,	/* 뭉 */
      0xebad8a,	/* 뭊 */
      0xebad8b,	/* 뭋 */
      0xebad8c,	/* 뭌 */
      0xebad8d,	/* 뭍 */
      0xebad8e,	/* 뭎 */
      0xebad8f,	/* 뭏 */
    },
    {
      0xebad90,	/* 뭐 */
      0xebad91,	/* 뭑 */
      0xebad92,	/* 뭒 */
      0xebad93,	/* 뭓 */
      0xebad94,	/* 뭔 */
      0xebad95,	/* 뭕 */
      0xebad96,	/* 뭖 */
      0xebad97,	/* 뭗 */
      0xebad98,	/* 뭘 */
      0xebad99,	/* 뭙 */
      0xebad9a,	/* 뭚 */
      0xebad9b,	/* 뭛 */
      0xebad9c,	/* 뭜 */
      0xebad9d,	/* 뭝 */
      0xebad9e,	/* 뭞 */
      0xebad9f,	/* 뭟 */
      0xebada0,	/* 뭠 */
      0xebada1,	/* 뭡 */
      0xebada2,	/* 뭢 */
      0xebada3,	/* 뭣 */
      0xebada4,	/* 뭤 */
      0xebada5,	/* 뭥 */
      0xebada6,	/* 뭦 */
      0xebada7,	/* 뭧 */
      0xebada8,	/* 뭨 */
      0xebada9,	/* 뭩 */
      0xebadaa,	/* 뭪 */
      0xebadab,	/* 뭫 */
    },
    {
      0xebadac,	/* 뭬 */
      0xebadad,	/* 뭭 */
      0xebadae,	/* 뭮 */
      0xebadaf,	/* 뭯 */
      0xebadb0,	/* 뭰 */
      0xebadb1,	/* 뭱 */
      0xebadb2,	/* 뭲 */
      0xebadb3,	/* 뭳 */
      0xebadb4,	/* 뭴 */
      0xebadb5,	/* 뭵 */
      0xebadb6,	/* 뭶 */
      0xebadb7,	/* 뭷 */
      0xebadb8,	/* 뭸 */
      0xebadb9,	/* 뭹 */
      0xebadba,	/* 뭺 */
      0xebadbb,	/* 뭻 */
      0xebadbc,	/* 뭼 */
      0xebadbd,	/* 뭽 */
      0xebadbe,	/* 뭾 */
      0xebadbf,	/* 뭿 */
      0xebae80,	/* 뮀 */
      0xebae81,	/* 뮁 */
      0xebae82,	/* 뮂 */
      0xebae83,	/* 뮃 */
      0xebae84,	/* 뮄 */
      0xebae85,	/* 뮅 */
      0xebae86,	/* 뮆 */
      0xebae87,	/* 뮇 */
    },
    {
      0xebae88,	/* 뮈 */
      0xebae89,	/* 뮉 */
      0xebae8a,	/* 뮊 */
      0xebae8b,	/* 뮋 */
      0xebae8c,	/* 뮌 */
      0xebae8d,	/* 뮍 */
      0xebae8e,	/* 뮎 */
      0xebae8f,	/* 뮏 */
      0xebae90,	/* 뮐 */
      0xebae91,	/* 뮑 */
      0xebae92,	/* 뮒 */
      0xebae93,	/* 뮓 */
      0xebae94,	/* 뮔 */
      0xebae95,	/* 뮕 */
      0xebae96,	/* 뮖 */
      0xebae97,	/* 뮗 */
      0xebae98,	/* 뮘 */
      0xebae99,	/* 뮙 */
      0xebae9a,	/* 뮚 */
      0xebae9b,	/* 뮛 */
      0xebae9c,	/* 뮜 */
      0xebae9d,	/* 뮝 */
      0xebae9e,	/* 뮞 */
      0xebae9f,	/* 뮟 */
      0xebaea0,	/* 뮠 */
      0xebaea1,	/* 뮡 */
      0xebaea2,	/* 뮢 */
      0xebaea3,	/* 뮣 */
    },
    {
      0xebaea4,	/* 뮤 */
      0xebaea5,	/* 뮥 */
      0xebaea6,	/* 뮦 */
      0xebaea7,	/* 뮧 */
      0xebaea8,	/* 뮨 */
      0xebaea9,	/* 뮩 */
      0xebaeaa,	/* 뮪 */
      0xebaeab,	/* 뮫 */
      0xebaeac,	/* 뮬 */
      0xebaead,	/* 뮭 */
      0xebaeae,	/* 뮮 */
      0xebaeaf,	/* 뮯 */
      0xebaeb0,	/* 뮰 */
      0xebaeb1,	/* 뮱 */
      0xebaeb2,	/* 뮲 */
      0xebaeb3,	/* 뮳 */
      0xebaeb4,	/* 뮴 */
      0xebaeb5,	/* 뮵 */
      0xebaeb6,	/* 뮶 */
      0xebaeb7,	/* 뮷 */
      0xebaeb8,	/* 뮸 */
      0xebaeb9,	/* 뮹 */
      0xebaeba,	/* 뮺 */
      0xebaebb,	/* 뮻 */
      0xebaebc,	/* 뮼 */
      0xebaebd,	/* 뮽 */
      0xebaebe,	/* 뮾 */
      0xebaebf,	/* 뮿 */
    },
    {
      0xebaf80,	/* 므 */
      0xebaf81,	/* 믁 */
      0xebaf82,	/* 믂 */
      0xebaf83,	/* 믃 */
      0xebaf84,	/* 믄 */
      0xebaf85,	/* 믅 */
      0xebaf86,	/* 믆 */
      0xebaf87,	/* 믇 */
      0xebaf88,	/* 믈 */
      0xebaf89,	/* 믉 */
      0xebaf8a,	/* 믊 */
      0xebaf8b,	/* 믋 */
      0xebaf8c,	/* 믌 */
      0xebaf8d,	/* 믍 */
      0xebaf8e,	/* 믎 */
      0xebaf8f,	/* 믏 */
      0xebaf90,	/* 믐 */
      0xebaf91,	/* 믑 */
      0xebaf92,	/* 믒 */
      0xebaf93,	/* 믓 */
      0xebaf94,	/* 믔 */
      0xebaf95,	/* 믕 */
      0xebaf96,	/* 믖 */
      0xebaf97,	/* 믗 */
      0xebaf98,	/* 믘 */
      0xebaf99,	/* 믙 */
      0xebaf9a,	/* 믚 */
      0xebaf9b,	/* 믛 */
    },
    {
      0xebaf9c,	/* 믜 */
      0xebaf9d,	/* 믝 */
      0xebaf9e,	/* 믞 */
      0xebaf9f,	/* 믟 */
      0xebafa0,	/* 믠 */
      0xebafa1,	/* 믡 */
      0xebafa2,	/* 믢 */
      0xebafa3,	/* 믣 */
      0xebafa4,	/* 믤 */
      0xebafa5,	/* 믥 */
      0xebafa6,	/* 믦 */
      0xebafa7,	/* 믧 */
      0xebafa8,	/* 믨 */
      0xebafa9,	/* 믩 */
      0xebafaa,	/* 믪 */
      0xebafab,	/* 믫 */
      0xebafac,	/* 믬 */
      0xebafad,	/* 믭 */
      0xebafae,	/* 믮 */
      0xebafaf,	/* 믯 */
      0xebafb0,	/* 믰 */
      0xebafb1,	/* 믱 */
      0xebafb2,	/* 믲 */
      0xebafb3,	/* 믳 */
      0xebafb4,	/* 믴 */
      0xebafb5,	/* 믵 */
      0xebafb6,	/* 믶 */
      0xebafb7,	/* 믷 */
    },
    {
      0xebafb8,	/* 미 */
      0xebafb9,	/* 믹 */
      0xebafba,	/* 믺 */
      0xebafbb,	/* 믻 */
      0xebafbc,	/* 민 */
      0xebafbd,	/* 믽 */
      0xebafbe,	/* 믾 */
      0xebafbf,	/* 믿 */
      0xebb080,	/* 밀 */
      0xebb081,	/* 밁 */
      0xebb082,	/* 밂 */
      0xebb083,	/* 밃 */
      0xebb084,	/* 밄 */
      0xebb085,	/* 밅 */
      0xebb086,	/* 밆 */
      0xebb087,	/* 밇 */
      0xebb088,	/* 밈 */
      0xebb089,	/* 밉 */
      0xebb08a,	/* 밊 */
      0xebb08b,	/* 밋 */
      0xebb08c,	/* 밌 */
      0xebb08d,	/* 밍 */
      0xebb08e,	/* 밎 */
      0xebb08f,	/* 및 */
      0xebb090,	/* 밐 */
      0xebb091,	/* 밑 */
      0xebb092,	/* 밒 */
      0xebb093,	/* 밓 */
    },
  },
  {
    {
      0xebb094,	/* 바 */
      0xebb095,	/* 박 */
      0xebb096,	/* 밖 */
      0xebb097,	/* 밗 */
      0xebb098,	/* 반 */
      0xebb099,	/* 밙 */
      0xebb09a,	/* 밚 */
      0xebb09b,	/* 받 */
      0xebb09c,	/* 발 */
      0xebb09d,	/* 밝 */
      0xebb09e,	/* 밞 */
      0xebb09f,	/* 밟 */
      0xebb0a0,	/* 밠 */
      0xebb0a1,	/* 밡 */
      0xebb0a2,	/* 밢 */
      0xebb0a3,	/* 밣 */
      0xebb0a4,	/* 밤 */
      0xebb0a5,	/* 밥 */
      0xebb0a6,	/* 밦 */
      0xebb0a7,	/* 밧 */
      0xebb0a8,	/* 밨 */
      0xebb0a9,	/* 방 */
      0xebb0aa,	/* 밪 */
      0xebb0ab,	/* 밫 */
      0xebb0ac,	/* 밬 */
      0xebb0ad,	/* 밭 */
      0xebb0ae,	/* 밮 */
      0xebb0af,	/* 밯 */
    },
    {
      0xebb0b0,	/* 배 */
      0xebb0b1,	/* 백 */
      0xebb0b2,	/* 밲 */
      0xebb0b3,	/* 밳 */
      0xebb0b4,	/* 밴 */
      0xebb0b5,	/* 밵 */
      0xebb0b6,	/* 밶 */
      0xebb0b7,	/* 밷 */
      0xebb0b8,	/* 밸 */
      0xebb0b9,	/* 밹 */
      0xebb0ba,	/* 밺 */
      0xebb0bb,	/* 밻 */
      0xebb0bc,	/* 밼 */
      0xebb0bd,	/* 밽 */
      0xebb0be,	/* 밾 */
      0xebb0bf,	/* 밿 */
      0xebb180,	/* 뱀 */
      0xebb181,	/* 뱁 */
      0xebb182,	/* 뱂 */
      0xebb183,	/* 뱃 */
      0xebb184,	/* 뱄 */
      0xebb185,	/* 뱅 */
      0xebb186,	/* 뱆 */
      0xebb187,	/* 뱇 */
      0xebb188,	/* 뱈 */
      0xebb189,	/* 뱉 */
      0xebb18a,	/* 뱊 */
      0xebb18b,	/* 뱋 */
    },
    {
      0xebb18c,	/* 뱌 */
      0xebb18d,	/* 뱍 */
      0xebb18e,	/* 뱎 */
      0xebb18f,	/* 뱏 */
      0xebb190,	/* 뱐 */
      0xebb191,	/* 뱑 */
      0xebb192,	/* 뱒 */
      0xebb193,	/* 뱓 */
      0xebb194,	/* 뱔 */
      0xebb195,	/* 뱕 */
      0xebb196,	/* 뱖 */
      0xebb197,	/* 뱗 */
      0xebb198,	/* 뱘 */
      0xebb199,	/* 뱙 */
      0xebb19a,	/* 뱚 */
      0xebb19b,	/* 뱛 */
      0xebb19c,	/* 뱜 */
      0xebb19d,	/* 뱝 */
      0xebb19e,	/* 뱞 */
      0xebb19f,	/* 뱟 */
      0xebb1a0,	/* 뱠 */
      0xebb1a1,	/* 뱡 */
      0xebb1a2,	/* 뱢 */
      0xebb1a3,	/* 뱣 */
      0xebb1a4,	/* 뱤 */
      0xebb1a5,	/* 뱥 */
      0xebb1a6,	/* 뱦 */
      0xebb1a7,	/* 뱧 */
    },
    {
      0xebb1a8,	/* 뱨 */
      0xebb1a9,	/* 뱩 */
      0xebb1aa,	/* 뱪 */
      0xebb1ab,	/* 뱫 */
      0xebb1ac,	/* 뱬 */
      0xebb1ad,	/* 뱭 */
      0xebb1ae,	/* 뱮 */
      0xebb1af,	/* 뱯 */
      0xebb1b0,	/* 뱰 */
      0xebb1b1,	/* 뱱 */
      0xebb1b2,	/* 뱲 */
      0xebb1b3,	/* 뱳 */
      0xebb1b4,	/* 뱴 */
      0xebb1b5,	/* 뱵 */
      0xebb1b6,	/* 뱶 */
      0xebb1b7,	/* 뱷 */
      0xebb1b8,	/* 뱸 */
      0xebb1b9,	/* 뱹 */
      0xebb1ba,	/* 뱺 */
      0xebb1bb,	/* 뱻 */
      0xebb1bc,	/* 뱼 */
      0xebb1bd,	/* 뱽 */
      0xebb1be,	/* 뱾 */
      0xebb1bf,	/* 뱿 */
      0xebb280,	/* 벀 */
      0xebb281,	/* 벁 */
      0xebb282,	/* 벂 */
      0xebb283,	/* 벃 */
    },
    {
      0xebb284,	/* 버 */
      0xebb285,	/* 벅 */
      0xebb286,	/* 벆 */
      0xebb287,	/* 벇 */
      0xebb288,	/* 번 */
      0xebb289,	/* 벉 */
      0xebb28a,	/* 벊 */
      0xebb28b,	/* 벋 */
      0xebb28c,	/* 벌 */
      0xebb28d,	/* 벍 */
      0xebb28e,	/* 벎 */
      0xebb28f,	/* 벏 */
      0xebb290,	/* 벐 */
      0xebb291,	/* 벑 */
      0xebb292,	/* 벒 */
      0xebb293,	/* 벓 */
      0xebb294,	/* 범 */
      0xebb295,	/* 법 */
      0xebb296,	/* 벖 */
      0xebb297,	/* 벗 */
      0xebb298,	/* 벘 */
      0xebb299,	/* 벙 */
      0xebb29a,	/* 벚 */
      0xebb29b,	/* 벛 */
      0xebb29c,	/* 벜 */
      0xebb29d,	/* 벝 */
      0xebb29e,	/* 벞 */
      0xebb29f,	/* 벟 */
    },
    {
      0xebb2a0,	/* 베 */
      0xebb2a1,	/* 벡 */
      0xebb2a2,	/* 벢 */
      0xebb2a3,	/* 벣 */
      0xebb2a4,	/* 벤 */
      0xebb2a5,	/* 벥 */
      0xebb2a6,	/* 벦 */
      0xebb2a7,	/* 벧 */
      0xebb2a8,	/* 벨 */
      0xebb2a9,	/* 벩 */
      0xebb2aa,	/* 벪 */
      0xebb2ab,	/* 벫 */
      0xebb2ac,	/* 벬 */
      0xebb2ad,	/* 벭 */
      0xebb2ae,	/* 벮 */
      0xebb2af,	/* 벯 */
      0xebb2b0,	/* 벰 */
      0xebb2b1,	/* 벱 */
      0xebb2b2,	/* 벲 */
      0xebb2b3,	/* 벳 */
      0xebb2b4,	/* 벴 */
      0xebb2b5,	/* 벵 */
      0xebb2b6,	/* 벶 */
      0xebb2b7,	/* 벷 */
      0xebb2b8,	/* 벸 */
      0xebb2b9,	/* 벹 */
      0xebb2ba,	/* 벺 */
      0xebb2bb,	/* 벻 */
    },
    {
      0xebb2bc,	/* 벼 */
      0xebb2bd,	/* 벽 */
      0xebb2be,	/* 벾 */
      0xebb2bf,	/* 벿 */
      0xebb380,	/* 변 */
      0xebb381,	/* 볁 */
      0xebb382,	/* 볂 */
      0xebb383,	/* 볃 */
      0xebb384,	/* 별 */
      0xebb385,	/* 볅 */
      0xebb386,	/* 볆 */
      0xebb387,	/* 볇 */
      0xebb388,	/* 볈 */
      0xebb389,	/* 볉 */
      0xebb38a,	/* 볊 */
      0xebb38b,	/* 볋 */
      0xebb38c,	/* 볌 */
      0xebb38d,	/* 볍 */
      0xebb38e,	/* 볎 */
      0xebb38f,	/* 볏 */
      0xebb390,	/* 볐 */
      0xebb391,	/* 병 */
      0xebb392,	/* 볒 */
      0xebb393,	/* 볓 */
      0xebb394,	/* 볔 */
      0xebb395,	/* 볕 */
      0xebb396,	/* 볖 */
      0xebb397,	/* 볗 */
    },
    {
      0xebb398,	/* 볘 */
      0xebb399,	/* 볙 */
      0xebb39a,	/* 볚 */
      0xebb39b,	/* 볛 */
      0xebb39c,	/* 볜 */
      0xebb39d,	/* 볝 */
      0xebb39e,	/* 볞 */
      0xebb39f,	/* 볟 */
      0xebb3a0,	/* 볠 */
      0xebb3a1,	/* 볡 */
      0xebb3a2,	/* 볢 */
      0xebb3a3,	/* 볣 */
      0xebb3a4,	/* 볤 */
      0xebb3a5,	/* 볥 */
      0xebb3a6,	/* 볦 */
      0xebb3a7,	/* 볧 */
      0xebb3a8,	/* 볨 */
      0xebb3a9,	/* 볩 */
      0xebb3aa,	/* 볪 */
      0xebb3ab,	/* 볫 */
      0xebb3ac,	/* 볬 */
      0xebb3ad,	/* 볭 */
      0xebb3ae,	/* 볮 */
      0xebb3af,	/* 볯 */
      0xebb3b0,	/* 볰 */
      0xebb3b1,	/* 볱 */
      0xebb3b2,	/* 볲 */
      0xebb3b3,	/* 볳 */
    },
    {
      0xebb3b4,	/* 보 */
      0xebb3b5,	/* 복 */
      0xebb3b6,	/* 볶 */
      0xebb3b7,	/* 볷 */
      0xebb3b8,	/* 본 */
      0xebb3b9,	/* 볹 */
      0xebb3ba,	/* 볺 */
      0xebb3bb,	/* 볻 */
      0xebb3bc,	/* 볼 */
      0xebb3bd,	/* 볽 */
      0xebb3be,	/* 볾 */
      0xebb3bf,	/* 볿 */
      0xebb480,	/* 봀 */
      0xebb481,	/* 봁 */
      0xebb482,	/* 봂 */
      0xebb483,	/* 봃 */
      0xebb484,	/* 봄 */
      0xebb485,	/* 봅 */
      0xebb486,	/* 봆 */
      0xebb487,	/* 봇 */
      0xebb488,	/* 봈 */
      0xebb489,	/* 봉 */
      0xebb48a,	/* 봊 */
      0xebb48b,	/* 봋 */
      0xebb48c,	/* 봌 */
      0xebb48d,	/* 봍 */
      0xebb48e,	/* 봎 */
      0xebb48f,	/* 봏 */
    },
    {
      0xebb490,	/* 봐 */
      0xebb491,	/* 봑 */
      0xebb492,	/* 봒 */
      0xebb493,	/* 봓 */
      0xebb494,	/* 봔 */
      0xebb495,	/* 봕 */
      0xebb496,	/* 봖 */
      0xebb497,	/* 봗 */
      0xebb498,	/* 봘 */
      0xebb499,	/* 봙 */
      0xebb49a,	/* 봚 */
      0xebb49b,	/* 봛 */
      0xebb49c,	/* 봜 */
      0xebb49d,	/* 봝 */
      0xebb49e,	/* 봞 */
      0xebb49f,	/* 봟 */
      0xebb4a0,	/* 봠 */
      0xebb4a1,	/* 봡 */
      0xebb4a2,	/* 봢 */
      0xebb4a3,	/* 봣 */
      0xebb4a4,	/* 봤 */
      0xebb4a5,	/* 봥 */
      0xebb4a6,	/* 봦 */
      0xebb4a7,	/* 봧 */
      0xebb4a8,	/* 봨 */
      0xebb4a9,	/* 봩 */
      0xebb4aa,	/* 봪 */
      0xebb4ab,	/* 봫 */
    },
    {
      0xebb4ac,	/* 봬 */
      0xebb4ad,	/* 봭 */
      0xebb4ae,	/* 봮 */
      0xebb4af,	/* 봯 */
      0xebb4b0,	/* 봰 */
      0xebb4b1,	/* 봱 */
      0xebb4b2,	/* 봲 */
      0xebb4b3,	/* 봳 */
      0xebb4b4,	/* 봴 */
      0xebb4b5,	/* 봵 */
      0xebb4b6,	/* 봶 */
      0xebb4b7,	/* 봷 */
      0xebb4b8,	/* 봸 */
      0xebb4b9,	/* 봹 */
      0xebb4ba,	/* 봺 */
      0xebb4bb,	/* 봻 */
      0xebb4bc,	/* 봼 */
      0xebb4bd,	/* 봽 */
      0xebb4be,	/* 봾 */
      0xebb4bf,	/* 봿 */
      0xebb580,	/* 뵀 */
      0xebb581,	/* 뵁 */
      0xebb582,	/* 뵂 */
      0xebb583,	/* 뵃 */
      0xebb584,	/* 뵄 */
      0xebb585,	/* 뵅 */
      0xebb586,	/* 뵆 */
      0xebb587,	/* 뵇 */
    },
    {
      0xebb588,	/* 뵈 */
      0xebb589,	/* 뵉 */
      0xebb58a,	/* 뵊 */
      0xebb58b,	/* 뵋 */
      0xebb58c,	/* 뵌 */
      0xebb58d,	/* 뵍 */
      0xebb58e,	/* 뵎 */
      0xebb58f,	/* 뵏 */
      0xebb590,	/* 뵐 */
      0xebb591,	/* 뵑 */
      0xebb592,	/* 뵒 */
      0xebb593,	/* 뵓 */
      0xebb594,	/* 뵔 */
      0xebb595,	/* 뵕 */
      0xebb596,	/* 뵖 */
      0xebb597,	/* 뵗 */
      0xebb598,	/* 뵘 */
      0xebb599,	/* 뵙 */
      0xebb59a,	/* 뵚 */
      0xebb59b,	/* 뵛 */
      0xebb59c,	/* 뵜 */
      0xebb59d,	/* 뵝 */
      0xebb59e,	/* 뵞 */
      0xebb59f,	/* 뵟 */
      0xebb5a0,	/* 뵠 */
      0xebb5a1,	/* 뵡 */
      0xebb5a2,	/* 뵢 */
      0xebb5a3,	/* 뵣 */
    },
    {
      0xebb5a4,	/* 뵤 */
      0xebb5a5,	/* 뵥 */
      0xebb5a6,	/* 뵦 */
      0xebb5a7,	/* 뵧 */
      0xebb5a8,	/* 뵨 */
      0xebb5a9,	/* 뵩 */
      0xebb5aa,	/* 뵪 */
      0xebb5ab,	/* 뵫 */
      0xebb5ac,	/* 뵬 */
      0xebb5ad,	/* 뵭 */
      0xebb5ae,	/* 뵮 */
      0xebb5af,	/* 뵯 */
      0xebb5b0,	/* 뵰 */
      0xebb5b1,	/* 뵱 */
      0xebb5b2,	/* 뵲 */
      0xebb5b3,	/* 뵳 */
      0xebb5b4,	/* 뵴 */
      0xebb5b5,	/* 뵵 */
      0xebb5b6,	/* 뵶 */
      0xebb5b7,	/* 뵷 */
      0xebb5b8,	/* 뵸 */
      0xebb5b9,	/* 뵹 */
      0xebb5ba,	/* 뵺 */
      0xebb5bb,	/* 뵻 */
      0xebb5bc,	/* 뵼 */
      0xebb5bd,	/* 뵽 */
      0xebb5be,	/* 뵾 */
      0xebb5bf,	/* 뵿 */
    },
    {
      0xebb680,	/* 부 */
      0xebb681,	/* 북 */
      0xebb682,	/* 붂 */
      0xebb683,	/* 붃 */
      0xebb684,	/* 분 */
      0xebb685,	/* 붅 */
      0xebb686,	/* 붆 */
      0xebb687,	/* 붇 */
      0xebb688,	/* 불 */
      0xebb689,	/* 붉 */
      0xebb68a,	/* 붊 */
      0xebb68b,	/* 붋 */
      0xebb68c,	/* 붌 */
      0xebb68d,	/* 붍 */
      0xebb68e,	/* 붎 */
      0xebb68f,	/* 붏 */
      0xebb690,	/* 붐 */
      0xebb691,	/* 붑 */
      0xebb692,	/* 붒 */
      0xebb693,	/* 붓 */
      0xebb694,	/* 붔 */
      0xebb695,	/* 붕 */
      0xebb696,	/* 붖 */
      0xebb697,	/* 붗 */
      0xebb698,	/* 붘 */
      0xebb699,	/* 붙 */
      0xebb69a,	/* 붚 */
      0xebb69b,	/* 붛 */
    },
    {
      0xebb69c,	/* 붜 */
      0xebb69d,	/* 붝 */
      0xebb69e,	/* 붞 */
      0xebb69f,	/* 붟 */
      0xebb6a0,	/* 붠 */
      0xebb6a1,	/* 붡 */
      0xebb6a2,	/* 붢 */
      0xebb6a3,	/* 붣 */
      0xebb6a4,	/* 붤 */
      0xebb6a5,	/* 붥 */
      0xebb6a6,	/* 붦 */
      0xebb6a7,	/* 붧 */
      0xebb6a8,	/* 붨 */
      0xebb6a9,	/* 붩 */
      0xebb6aa,	/* 붪 */
      0xebb6ab,	/* 붫 */
      0xebb6ac,	/* 붬 */
      0xebb6ad,	/* 붭 */
      0xebb6ae,	/* 붮 */
      0xebb6af,	/* 붯 */
      0xebb6b0,	/* 붰 */
      0xebb6b1,	/* 붱 */
      0xebb6b2,	/* 붲 */
      0xebb6b3,	/* 붳 */
      0xebb6b4,	/* 붴 */
      0xebb6b5,	/* 붵 */
      0xebb6b6,	/* 붶 */
      0xebb6b7,	/* 붷 */
    },
    {
      0xebb6b8,	/* 붸 */
      0xebb6b9,	/* 붹 */
      0xebb6ba,	/* 붺 */
      0xebb6bb,	/* 붻 */
      0xebb6bc,	/* 붼 */
      0xebb6bd,	/* 붽 */
      0xebb6be,	/* 붾 */
      0xebb6bf,	/* 붿 */
      0xebb780,	/* 뷀 */
      0xebb781,	/* 뷁 */
      0xebb782,	/* 뷂 */
      0xebb783,	/* 뷃 */
      0xebb784,	/* 뷄 */
      0xebb785,	/* 뷅 */
      0xebb786,	/* 뷆 */
      0xebb787,	/* 뷇 */
      0xebb788,	/* 뷈 */
      0xebb789,	/* 뷉 */
      0xebb78a,	/* 뷊 */
      0xebb78b,	/* 뷋 */
      0xebb78c,	/* 뷌 */
      0xebb78d,	/* 뷍 */
      0xebb78e,	/* 뷎 */
      0xebb78f,	/* 뷏 */
      0xebb790,	/* 뷐 */
      0xebb791,	/* 뷑 */
      0xebb792,	/* 뷒 */
      0xebb793,	/* 뷓 */
    },
    {
      0xebb794,	/* 뷔 */
      0xebb795,	/* 뷕 */
      0xebb796,	/* 뷖 */
      0xebb797,	/* 뷗 */
      0xebb798,	/* 뷘 */
      0xebb799,	/* 뷙 */
      0xebb79a,	/* 뷚 */
      0xebb79b,	/* 뷛 */
      0xebb79c,	/* 뷜 */
      0xebb79d,	/* 뷝 */
      0xebb79e,	/* 뷞 */
      0xebb79f,	/* 뷟 */
      0xebb7a0,	/* 뷠 */
      0xebb7a1,	/* 뷡 */
      0xebb7a2,	/* 뷢 */
      0xebb7a3,	/* 뷣 */
      0xebb7a4,	/* 뷤 */
      0xebb7a5,	/* 뷥 */
      0xebb7a6,	/* 뷦 */
      0xebb7a7,	/* 뷧 */
      0xebb7a8,	/* 뷨 */
      0xebb7a9,	/* 뷩 */
      0xebb7aa,	/* 뷪 */
      0xebb7ab,	/* 뷫 */
      0xebb7ac,	/* 뷬 */
      0xebb7ad,	/* 뷭 */
      0xebb7ae,	/* 뷮 */
      0xebb7af,	/* 뷯 */
    },
    {
      0xebb7b0,	/* 뷰 */
      0xebb7b1,	/* 뷱 */
      0xebb7b2,	/* 뷲 */
      0xebb7b3,	/* 뷳 */
      0xebb7b4,	/* 뷴 */
      0xebb7b5,	/* 뷵 */
      0xebb7b6,	/* 뷶 */
      0xebb7b7,	/* 뷷 */
      0xebb7b8,	/* 뷸 */
      0xebb7b9,	/* 뷹 */
      0xebb7ba,	/* 뷺 */
      0xebb7bb,	/* 뷻 */
      0xebb7bc,	/* 뷼 */
      0xebb7bd,	/* 뷽 */
      0xebb7be,	/* 뷾 */
      0xebb7bf,	/* 뷿 */
      0xebb880,	/* 븀 */
      0xebb881,	/* 븁 */
      0xebb882,	/* 븂 */
      0xebb883,	/* 븃 */
      0xebb884,	/* 븄 */
      0xebb885,	/* 븅 */
      0xebb886,	/* 븆 */
      0xebb887,	/* 븇 */
      0xebb888,	/* 븈 */
      0xebb889,	/* 븉 */
      0xebb88a,	/* 븊 */
      0xebb88b,	/* 븋 */
    },
    {
      0xebb88c,	/* 브 */
      0xebb88d,	/* 븍 */
      0xebb88e,	/* 븎 */
      0xebb88f,	/* 븏 */
      0xebb890,	/* 븐 */
      0xebb891,	/* 븑 */
      0xebb892,	/* 븒 */
      0xebb893,	/* 븓 */
      0xebb894,	/* 블 */
      0xebb895,	/* 븕 */
      0xebb896,	/* 븖 */
      0xebb897,	/* 븗 */
      0xebb898,	/* 븘 */
      0xebb899,	/* 븙 */
      0xebb89a,	/* 븚 */
      0xebb89b,	/* 븛 */
      0xebb89c,	/* 븜 */
      0xebb89d,	/* 븝 */
      0xebb89e,	/* 븞 */
      0xebb89f,	/* 븟 */
      0xebb8a0,	/* 븠 */
      0xebb8a1,	/* 븡 */
      0xebb8a2,	/* 븢 */
      0xebb8a3,	/* 븣 */
      0xebb8a4,	/* 븤 */
      0xebb8a5,	/* 븥 */
      0xebb8a6,	/* 븦 */
      0xebb8a7,	/* 븧 */
    },
    {
      0xebb8a8,	/* 븨 */
      0xebb8a9,	/* 븩 */
      0xebb8aa,	/* 븪 */
      0xebb8ab,	/* 븫 */
      0xebb8ac,	/* 븬 */
      0xebb8ad,	/* 븭 */
      0xebb8ae,	/* 븮 */
      0xebb8af,	/* 븯 */
      0xebb8b0,	/* 븰 */
      0xebb8b1,	/* 븱 */
      0xebb8b2,	/* 븲 */
      0xebb8b3,	/* 븳 */
      0xebb8b4,	/* 븴 */
      0xebb8b5,	/* 븵 */
      0xebb8b6,	/* 븶 */
      0xebb8b7,	/* 븷 */
      0xebb8b8,	/* 븸 */
      0xebb8b9,	/* 븹 */
      0xebb8ba,	/* 븺 */
      0xebb8bb,	/* 븻 */
      0xebb8bc,	/* 븼 */
      0xebb8bd,	/* 븽 */
      0xebb8be,	/* 븾 */
      0xebb8bf,	/* 븿 */
      0xebb980,	/* 빀 */
      0xebb981,	/* 빁 */
      0xebb982,	/* 빂 */
      0xebb983,	/* 빃 */
    },
    {
      0xebb984,	/* 비 */
      0xebb985,	/* 빅 */
      0xebb986,	/* 빆 */
      0xebb987,	/* 빇 */
      0xebb988,	/* 빈 */
      0xebb989,	/* 빉 */
      0xebb98a,	/* 빊 */
      0xebb98b,	/* 빋 */
      0xebb98c,	/* 빌 */
      0xebb98d,	/* 빍 */
      0xebb98e,	/* 빎 */
      0xebb98f,	/* 빏 */
      0xebb990,	/* 빐 */
      0xebb991,	/* 빑 */
      0xebb992,	/* 빒 */
      0xebb993,	/* 빓 */
      0xebb994,	/* 빔 */
      0xebb995,	/* 빕 */
      0xebb996,	/* 빖 */
      0xebb997,	/* 빗 */
      0xebb998,	/* 빘 */
      0xebb999,	/* 빙 */
      0xebb99a,	/* 빚 */
      0xebb99b,	/* 빛 */
      0xebb99c,	/* 빜 */
      0xebb99d,	/* 빝 */
      0xebb99e,	/* 빞 */
      0xebb99f,	/* 빟 */
    },
  },
  {
    {
      0xebb9a0,	/* 빠 */
      0xebb9a1,	/* 빡 */
      0xebb9a2,	/* 빢 */
      0xebb9a3,	/* 빣 */
      0xebb9a4,	/* 빤 */
      0xebb9a5,	/* 빥 */
      0xebb9a6,	/* 빦 */
      0xebb9a7,	/* 빧 */
      0xebb9a8,	/* 빨 */
      0xebb9a9,	/* 빩 */
      0xebb9aa,	/* 빪 */
      0xebb9ab,	/* 빫 */
      0xebb9ac,	/* 빬 */
      0xebb9ad,	/* 빭 */
      0xebb9ae,	/* 빮 */
      0xebb9af,	/* 빯 */
      0xebb9b0,	/* 빰 */
      0xebb9b1,	/* 빱 */
      0xebb9b2,	/* 빲 */
      0xebb9b3,	/* 빳 */
      0xebb9b4,	/* 빴 */
      0xebb9b5,	/* 빵 */
      0xebb9b6,	/* 빶 */
      0xebb9b7,	/* 빷 */
      0xebb9b8,	/* 빸 */
      0xebb9b9,	/* 빹 */
      0xebb9ba,	/* 빺 */
      0xebb9bb,	/* 빻 */
    },
    {
      0xebb9bc,	/* 빼 */
      0xebb9bd,	/* 빽 */
      0xebb9be,	/* 빾 */
      0xebb9bf,	/* 빿 */
      0xebba80,	/* 뺀 */
      0xebba81,	/* 뺁 */
      0xebba82,	/* 뺂 */
      0xebba83,	/* 뺃 */
      0xebba84,	/* 뺄 */
      0xebba85,	/* 뺅 */
      0xebba86,	/* 뺆 */
      0xebba87,	/* 뺇 */
      0xebba88,	/* 뺈 */
      0xebba89,	/* 뺉 */
      0xebba8a,	/* 뺊 */
      0xebba8b,	/* 뺋 */
      0xebba8c,	/* 뺌 */
      0xebba8d,	/* 뺍 */
      0xebba8e,	/* 뺎 */
      0xebba8f,	/* 뺏 */
      0xebba90,	/* 뺐 */
      0xebba91,	/* 뺑 */
      0xebba92,	/* 뺒 */
      0xebba93,	/* 뺓 */
      0xebba94,	/* 뺔 */
      0xebba95,	/* 뺕 */
      0xebba96,	/* 뺖 */
      0xebba97,	/* 뺗 */
    },
    {
      0xebba98,	/* 뺘 */
      0xebba99,	/* 뺙 */
      0xebba9a,	/* 뺚 */
      0xebba9b,	/* 뺛 */
      0xebba9c,	/* 뺜 */
      0xebba9d,	/* 뺝 */
      0xebba9e,	/* 뺞 */
      0xebba9f,	/* 뺟 */
      0xebbaa0,	/* 뺠 */
      0xebbaa1,	/* 뺡 */
      0xebbaa2,	/* 뺢 */
      0xebbaa3,	/* 뺣 */
      0xebbaa4,	/* 뺤 */
      0xebbaa5,	/* 뺥 */
      0xebbaa6,	/* 뺦 */
      0xebbaa7,	/* 뺧 */
      0xebbaa8,	/* 뺨 */
      0xebbaa9,	/* 뺩 */
      0xebbaaa,	/* 뺪 */
      0xebbaab,	/* 뺫 */
      0xebbaac,	/* 뺬 */
      0xebbaad,	/* 뺭 */
      0xebbaae,	/* 뺮 */
      0xebbaaf,	/* 뺯 */
      0xebbab0,	/* 뺰 */
      0xebbab1,	/* 뺱 */
      0xebbab2,	/* 뺲 */
      0xebbab3,	/* 뺳 */
    },
    {
      0xebbab4,	/* 뺴 */
      0xebbab5,	/* 뺵 */
      0xebbab6,	/* 뺶 */
      0xebbab7,	/* 뺷 */
      0xebbab8,	/* 뺸 */
      0xebbab9,	/* 뺹 */
      0xebbaba,	/* 뺺 */
      0xebbabb,	/* 뺻 */
      0xebbabc,	/* 뺼 */
      0xebbabd,	/* 뺽 */
      0xebbabe,	/* 뺾 */
      0xebbabf,	/* 뺿 */
      0xebbb80,	/* 뻀 */
      0xebbb81,	/* 뻁 */
      0xebbb82,	/* 뻂 */
      0xebbb83,	/* 뻃 */
      0xebbb84,	/* 뻄 */
      0xebbb85,	/* 뻅 */
      0xebbb86,	/* 뻆 */
      0xebbb87,	/* 뻇 */
      0xebbb88,	/* 뻈 */
      0xebbb89,	/* 뻉 */
      0xebbb8a,	/* 뻊 */
      0xebbb8b,	/* 뻋 */
      0xebbb8c,	/* 뻌 */
      0xebbb8d,	/* 뻍 */
      0xebbb8e,	/* 뻎 */
      0xebbb8f,	/* 뻏 */
    },
    {
      0xebbb90,	/* 뻐 */
      0xebbb91,	/* 뻑 */
      0xebbb92,	/* 뻒 */
      0xebbb93,	/* 뻓 */
      0xebbb94,	/* 뻔 */
      0xebbb95,	/* 뻕 */
      0xebbb96,	/* 뻖 */
      0xebbb97,	/* 뻗 */
      0xebbb98,	/* 뻘 */
      0xebbb99,	/* 뻙 */
      0xebbb9a,	/* 뻚 */
      0xebbb9b,	/* 뻛 */
      0xebbb9c,	/* 뻜 */
      0xebbb9d,	/* 뻝 */
      0xebbb9e,	/* 뻞 */
      0xebbb9f,	/* 뻟 */
      0xebbba0,	/* 뻠 */
      0xebbba1,	/* 뻡 */
      0xebbba2,	/* 뻢 */
      0xebbba3,	/* 뻣 */
      0xebbba4,	/* 뻤 */
      0xebbba5,	/* 뻥 */
      0xebbba6,	/* 뻦 */
      0xebbba7,	/* 뻧 */
      0xebbba8,	/* 뻨 */
      0xebbba9,	/* 뻩 */
      0xebbbaa,	/* 뻪 */
      0xebbbab,	/* 뻫 */
    },
    {
      0xebbbac,	/* 뻬 */
      0xebbbad,	/* 뻭 */
      0xebbbae,	/* 뻮 */
      0xebbbaf,	/* 뻯 */
      0xebbbb0,	/* 뻰 */
      0xebbbb1,	/* 뻱 */
      0xebbbb2,	/* 뻲 */
      0xebbbb3,	/* 뻳 */
      0xebbbb4,	/* 뻴 */
      0xebbbb5,	/* 뻵 */
      0xebbbb6,	/* 뻶 */
      0xebbbb7,	/* 뻷 */
      0xebbbb8,	/* 뻸 */
      0xebbbb9,	/* 뻹 */
      0xebbbba,	/* 뻺 */
      0xebbbbb,	/* 뻻 */
      0xebbbbc,	/* 뻼 */
      0xebbbbd,	/* 뻽 */
      0xebbbbe,	/* 뻾 */
      0xebbbbf,	/* 뻿 */
      0xebbc80,	/* 뼀 */
      0xebbc81,	/* 뼁 */
      0xebbc82,	/* 뼂 */
      0xebbc83,	/* 뼃 */
      0xebbc84,	/* 뼄 */
      0xebbc85,	/* 뼅 */
      0xebbc86,	/* 뼆 */
      0xebbc87,	/* 뼇 */
    },
    {
      0xebbc88,	/* 뼈 */
      0xebbc89,	/* 뼉 */
      0xebbc8a,	/* 뼊 */
      0xebbc8b,	/* 뼋 */
      0xebbc8c,	/* 뼌 */
      0xebbc8d,	/* 뼍 */
      0xebbc8e,	/* 뼎 */
      0xebbc8f,	/* 뼏 */
      0xebbc90,	/* 뼐 */
      0xebbc91,	/* 뼑 */
      0xebbc92,	/* 뼒 */
      0xebbc93,	/* 뼓 */
      0xebbc94,	/* 뼔 */
      0xebbc95,	/* 뼕 */
      0xebbc96,	/* 뼖 */
      0xebbc97,	/* 뼗 */
      0xebbc98,	/* 뼘 */
      0xebbc99,	/* 뼙 */
      0xebbc9a,	/* 뼚 */
      0xebbc9b,	/* 뼛 */
      0xebbc9c,	/* 뼜 */
      0xebbc9d,	/* 뼝 */
      0xebbc9e,	/* 뼞 */
      0xebbc9f,	/* 뼟 */
      0xebbca0,	/* 뼠 */
      0xebbca1,	/* 뼡 */
      0xebbca2,	/* 뼢 */
      0xebbca3,	/* 뼣 */
    },
    {
      0xebbca4,	/* 뼤 */
      0xebbca5,	/* 뼥 */
      0xebbca6,	/* 뼦 */
      0xebbca7,	/* 뼧 */
      0xebbca8,	/* 뼨 */
      0xebbca9,	/* 뼩 */
      0xebbcaa,	/* 뼪 */
      0xebbcab,	/* 뼫 */
      0xebbcac,	/* 뼬 */
      0xebbcad,	/* 뼭 */
      0xebbcae,	/* 뼮 */
      0xebbcaf,	/* 뼯 */
      0xebbcb0,	/* 뼰 */
      0xebbcb1,	/* 뼱 */
      0xebbcb2,	/* 뼲 */
      0xebbcb3,	/* 뼳 */
      0xebbcb4,	/* 뼴 */
      0xebbcb5,	/* 뼵 */
      0xebbcb6,	/* 뼶 */
      0xebbcb7,	/* 뼷 */
      0xebbcb8,	/* 뼸 */
      0xebbcb9,	/* 뼹 */
      0xebbcba,	/* 뼺 */
      0xebbcbb,	/* 뼻 */
      0xebbcbc,	/* 뼼 */
      0xebbcbd,	/* 뼽 */
      0xebbcbe,	/* 뼾 */
      0xebbcbf,	/* 뼿 */
    },
    {
      0xebbd80,	/* 뽀 */
      0xebbd81,	/* 뽁 */
      0xebbd82,	/* 뽂 */
      0xebbd83,	/* 뽃 */
      0xebbd84,	/* 뽄 */
      0xebbd85,	/* 뽅 */
      0xebbd86,	/* 뽆 */
      0xebbd87,	/* 뽇 */
      0xebbd88,	/* 뽈 */
      0xebbd89,	/* 뽉 */
      0xebbd8a,	/* 뽊 */
      0xebbd8b,	/* 뽋 */
      0xebbd8c,	/* 뽌 */
      0xebbd8d,	/* 뽍 */
      0xebbd8e,	/* 뽎 */
      0xebbd8f,	/* 뽏 */
      0xebbd90,	/* 뽐 */
      0xebbd91,	/* 뽑 */
      0xebbd92,	/* 뽒 */
      0xebbd93,	/* 뽓 */
      0xebbd94,	/* 뽔 */
      0xebbd95,	/* 뽕 */
      0xebbd96,	/* 뽖 */
      0xebbd97,	/* 뽗 */
      0xebbd98,	/* 뽘 */
      0xebbd99,	/* 뽙 */
      0xebbd9a,	/* 뽚 */
      0xebbd9b,	/* 뽛 */
    },
    {
      0xebbd9c,	/* 뽜 */
      0xebbd9d,	/* 뽝 */
      0xebbd9e,	/* 뽞 */
      0xebbd9f,	/* 뽟 */
      0xebbda0,	/* 뽠 */
      0xebbda1,	/* 뽡 */
      0xebbda2,	/* 뽢 */
      0xebbda3,	/* 뽣 */
      0xebbda4,	/* 뽤 */
      0xebbda5,	/* 뽥 */
      0xebbda6,	/* 뽦 */
      0xebbda7,	/* 뽧 */
      0xebbda8,	/* 뽨 */
      0xebbda9,	/* 뽩 */
      0xebbdaa,	/* 뽪 */
      0xebbdab,	/* 뽫 */
      0xebbdac,	/* 뽬 */
      0xebbdad,	/* 뽭 */
      0xebbdae,	/* 뽮 */
      0xebbdaf,	/* 뽯 */
      0xebbdb0,	/* 뽰 */
      0xebbdb1,	/* 뽱 */
      0xebbdb2,	/* 뽲 */
      0xebbdb3,	/* 뽳 */
      0xebbdb4,	/* 뽴 */
      0xebbdb5,	/* 뽵 */
      0xebbdb6,	/* 뽶 */
      0xebbdb7,	/* 뽷 */
    },
    {
      0xebbdb8,	/* 뽸 */
      0xebbdb9,	/* 뽹 */
      0xebbdba,	/* 뽺 */
      0xebbdbb,	/* 뽻 */
      0xebbdbc,	/* 뽼 */
      0xebbdbd,	/* 뽽 */
      0xebbdbe,	/* 뽾 */
      0xebbdbf,	/* 뽿 */
      0xebbe80,	/* 뾀 */
      0xebbe81,	/* 뾁 */
      0xebbe82,	/* 뾂 */
      0xebbe83,	/* 뾃 */
      0xebbe84,	/* 뾄 */
      0xebbe85,	/* 뾅 */
      0xebbe86,	/* 뾆 */
      0xebbe87,	/* 뾇 */
      0xebbe88,	/* 뾈 */
      0xebbe89,	/* 뾉 */
      0xebbe8a,	/* 뾊 */
      0xebbe8b,	/* 뾋 */
      0xebbe8c,	/* 뾌 */
      0xebbe8d,	/* 뾍 */
      0xebbe8e,	/* 뾎 */
      0xebbe8f,	/* 뾏 */
      0xebbe90,	/* 뾐 */
      0xebbe91,	/* 뾑 */
      0xebbe92,	/* 뾒 */
      0xebbe93,	/* 뾓 */
    },
    {
      0xebbe94,	/* 뾔 */
      0xebbe95,	/* 뾕 */
      0xebbe96,	/* 뾖 */
      0xebbe97,	/* 뾗 */
      0xebbe98,	/* 뾘 */
      0xebbe99,	/* 뾙 */
      0xebbe9a,	/* 뾚 */
      0xebbe9b,	/* 뾛 */
      0xebbe9c,	/* 뾜 */
      0xebbe9d,	/* 뾝 */
      0xebbe9e,	/* 뾞 */
      0xebbe9f,	/* 뾟 */
      0xebbea0,	/* 뾠 */
      0xebbea1,	/* 뾡 */
      0xebbea2,	/* 뾢 */
      0xebbea3,	/* 뾣 */
      0xebbea4,	/* 뾤 */
      0xebbea5,	/* 뾥 */
      0xebbea6,	/* 뾦 */
      0xebbea7,	/* 뾧 */
      0xebbea8,	/* 뾨 */
      0xebbea9,	/* 뾩 */
      0xebbeaa,	/* 뾪 */
      0xebbeab,	/* 뾫 */
      0xebbeac,	/* 뾬 */
      0xebbead,	/* 뾭 */
      0xebbeae,	/* 뾮 */
      0xebbeaf,	/* 뾯 */
    },
    {
      0xebbeb0,	/* 뾰 */
      0xebbeb1,	/* 뾱 */
      0xebbeb2,	/* 뾲 */
      0xebbeb3,	/* 뾳 */
      0xebbeb4,	/* 뾴 */
      0xebbeb5,	/* 뾵 */
      0xebbeb6,	/* 뾶 */
      0xebbeb7,	/* 뾷 */
      0xebbeb8,	/* 뾸 */
      0xebbeb9,	/* 뾹 */
      0xebbeba,	/* 뾺 */
      0xebbebb,	/* 뾻 */
      0xebbebc,	/* 뾼 */
      0xebbebd,	/* 뾽 */
      0xebbebe,	/* 뾾 */
      0xebbebf,	/* 뾿 */
      0xebbf80,	/* 뿀 */
      0xebbf81,	/* 뿁 */
      0xebbf82,	/* 뿂 */
      0xebbf83,	/* 뿃 */
      0xebbf84,	/* 뿄 */
      0xebbf85,	/* 뿅 */
      0xebbf86,	/* 뿆 */
      0xebbf87,	/* 뿇 */
      0xebbf88,	/* 뿈 */
      0xebbf89,	/* 뿉 */
      0xebbf8a,	/* 뿊 */
      0xebbf8b,	/* 뿋 */
    },
    {
      0xebbf8c,	/* 뿌 */
      0xebbf8d,	/* 뿍 */
      0xebbf8e,	/* 뿎 */
      0xebbf8f,	/* 뿏 */
      0xebbf90,	/* 뿐 */
      0xebbf91,	/* 뿑 */
      0xebbf92,	/* 뿒 */
      0xebbf93,	/* 뿓 */
      0xebbf94,	/* 뿔 */
      0xebbf95,	/* 뿕 */
      0xebbf96,	/* 뿖 */
      0xebbf97,	/* 뿗 */
      0xebbf98,	/* 뿘 */
      0xebbf99,	/* 뿙 */
      0xebbf9a,	/* 뿚 */
      0xebbf9b,	/* 뿛 */
      0xebbf9c,	/* 뿜 */
      0xebbf9d,	/* 뿝 */
      0xebbf9e,	/* 뿞 */
      0xebbf9f,	/* 뿟 */
      0xebbfa0,	/* 뿠 */
      0xebbfa1,	/* 뿡 */
      0xebbfa2,	/* 뿢 */
      0xebbfa3,	/* 뿣 */
      0xebbfa4,	/* 뿤 */
      0xebbfa5,	/* 뿥 */
      0xebbfa6,	/* 뿦 */
      0xebbfa7,	/* 뿧 */
    },
    {
      0xebbfa8,	/* 뿨 */
      0xebbfa9,	/* 뿩 */
      0xebbfaa,	/* 뿪 */
      0xebbfab,	/* 뿫 */
      0xebbfac,	/* 뿬 */
      0xebbfad,	/* 뿭 */
      0xebbfae,	/* 뿮 */
      0xebbfaf,	/* 뿯 */
      0xebbfb0,	/* 뿰 */
      0xebbfb1,	/* 뿱 */
      0xebbfb2,	/* 뿲 */
      0xebbfb3,	/* 뿳 */
      0xebbfb4,	/* 뿴 */
      0xebbfb5,	/* 뿵 */
      0xebbfb6,	/* 뿶 */
      0xebbfb7,	/* 뿷 */
      0xebbfb8,	/* 뿸 */
      0xebbfb9,	/* 뿹 */
      0xebbfba,	/* 뿺 */
      0xebbfbb,	/* 뿻 */
      0xebbfbc,	/* 뿼 */
      0xebbfbd,	/* 뿽 */
      0xebbfbe,	/* 뿾 */
      0xebbfbf,	/* 뿿 */
      0xec8080,	/* 쀀 */
      0xec8081,	/* 쀁 */
      0xec8082,	/* 쀂 */
      0xec8083,	/* 쀃 */
    },
    {
      0xec8084,	/* 쀄 */
      0xec8085,	/* 쀅 */
      0xec8086,	/* 쀆 */
      0xec8087,	/* 쀇 */
      0xec8088,	/* 쀈 */
      0xec8089,	/* 쀉 */
      0xec808a,	/* 쀊 */
      0xec808b,	/* 쀋 */
      0xec808c,	/* 쀌 */
      0xec808d,	/* 쀍 */
      0xec808e,	/* 쀎 */
      0xec808f,	/* 쀏 */
      0xec8090,	/* 쀐 */
      0xec8091,	/* 쀑 */
      0xec8092,	/* 쀒 */
      0xec8093,	/* 쀓 */
      0xec8094,	/* 쀔 */
      0xec8095,	/* 쀕 */
      0xec8096,	/* 쀖 */
      0xec8097,	/* 쀗 */
      0xec8098,	/* 쀘 */
      0xec8099,	/* 쀙 */
      0xec809a,	/* 쀚 */
      0xec809b,	/* 쀛 */
      0xec809c,	/* 쀜 */
      0xec809d,	/* 쀝 */
      0xec809e,	/* 쀞 */
      0xec809f,	/* 쀟 */
    },
    {
      0xec80a0,	/* 쀠 */
      0xec80a1,	/* 쀡 */
      0xec80a2,	/* 쀢 */
      0xec80a3,	/* 쀣 */
      0xec80a4,	/* 쀤 */
      0xec80a5,	/* 쀥 */
      0xec80a6,	/* 쀦 */
      0xec80a7,	/* 쀧 */
      0xec80a8,	/* 쀨 */
      0xec80a9,	/* 쀩 */
      0xec80aa,	/* 쀪 */
      0xec80ab,	/* 쀫 */
      0xec80ac,	/* 쀬 */
      0xec80ad,	/* 쀭 */
      0xec80ae,	/* 쀮 */
      0xec80af,	/* 쀯 */
      0xec80b0,	/* 쀰 */
      0xec80b1,	/* 쀱 */
      0xec80b2,	/* 쀲 */
      0xec80b3,	/* 쀳 */
      0xec80b4,	/* 쀴 */
      0xec80b5,	/* 쀵 */
      0xec80b6,	/* 쀶 */
      0xec80b7,	/* 쀷 */
      0xec80b8,	/* 쀸 */
      0xec80b9,	/* 쀹 */
      0xec80ba,	/* 쀺 */
      0xec80bb,	/* 쀻 */
    },
    {
      0xec80bc,	/* 쀼 */
      0xec80bd,	/* 쀽 */
      0xec80be,	/* 쀾 */
      0xec80bf,	/* 쀿 */
      0xec8180,	/* 쁀 */
      0xec8181,	/* 쁁 */
      0xec8182,	/* 쁂 */
      0xec8183,	/* 쁃 */
      0xec8184,	/* 쁄 */
      0xec8185,	/* 쁅 */
      0xec8186,	/* 쁆 */
      0xec8187,	/* 쁇 */
      0xec8188,	/* 쁈 */
      0xec8189,	/* 쁉 */
      0xec818a,	/* 쁊 */
      0xec818b,	/* 쁋 */
      0xec818c,	/* 쁌 */
      0xec818d,	/* 쁍 */
      0xec818e,	/* 쁎 */
      0xec818f,	/* 쁏 */
      0xec8190,	/* 쁐 */
      0xec8191,	/* 쁑 */
      0xec8192,	/* 쁒 */
      0xec8193,	/* 쁓 */
      0xec8194,	/* 쁔 */
      0xec8195,	/* 쁕 */
      0xec8196,	/* 쁖 */
      0xec8197,	/* 쁗 */
    },
    {
      0xec8198,	/* 쁘 */
      0xec8199,	/* 쁙 */
      0xec819a,	/* 쁚 */
      0xec819b,	/* 쁛 */
      0xec819c,	/* 쁜 */
      0xec819d,	/* 쁝 */
      0xec819e,	/* 쁞 */
      0xec819f,	/* 쁟 */
      0xec81a0,	/* 쁠 */
      0xec81a1,	/* 쁡 */
      0xec81a2,	/* 쁢 */
      0xec81a3,	/* 쁣 */
      0xec81a4,	/* 쁤 */
      0xec81a5,	/* 쁥 */
      0xec81a6,	/* 쁦 */
      0xec81a7,	/* 쁧 */
      0xec81a8,	/* 쁨 */
      0xec81a9,	/* 쁩 */
      0xec81aa,	/* 쁪 */
      0xec81ab,	/* 쁫 */
      0xec81ac,	/* 쁬 */
      0xec81ad,	/* 쁭 */
      0xec81ae,	/* 쁮 */
      0xec81af,	/* 쁯 */
      0xec81b0,	/* 쁰 */
      0xec81b1,	/* 쁱 */
      0xec81b2,	/* 쁲 */
      0xec81b3,	/* 쁳 */
    },
    {
      0xec81b4,	/* 쁴 */
      0xec81b5,	/* 쁵 */
      0xec81b6,	/* 쁶 */
      0xec81b7,	/* 쁷 */
      0xec81b8,	/* 쁸 */
      0xec81b9,	/* 쁹 */
      0xec81ba,	/* 쁺 */
      0xec81bb,	/* 쁻 */
      0xec81bc,	/* 쁼 */
      0xec81bd,	/* 쁽 */
      0xec81be,	/* 쁾 */
      0xec81bf,	/* 쁿 */
      0xec8280,	/* 삀 */
      0xec8281,	/* 삁 */
      0xec8282,	/* 삂 */
      0xec8283,	/* 삃 */
      0xec8284,	/* 삄 */
      0xec8285,	/* 삅 */
      0xec8286,	/* 삆 */
      0xec8287,	/* 삇 */
      0xec8288,	/* 삈 */
      0xec8289,	/* 삉 */
      0xec828a,	/* 삊 */
      0xec828b,	/* 삋 */
      0xec828c,	/* 삌 */
      0xec828d,	/* 삍 */
      0xec828e,	/* 삎 */
      0xec828f,	/* 삏 */
    },
    {
      0xec8290,	/* 삐 */
      0xec8291,	/* 삑 */
      0xec8292,	/* 삒 */
      0xec8293,	/* 삓 */
      0xec8294,	/* 삔 */
      0xec8295,	/* 삕 */
      0xec8296,	/* 삖 */
      0xec8297,	/* 삗 */
      0xec8298,	/* 삘 */
      0xec8299,	/* 삙 */
      0xec829a,	/* 삚 */
      0xec829b,	/* 삛 */
      0xec829c,	/* 삜 */
      0xec829d,	/* 삝 */
      0xec829e,	/* 삞 */
      0xec829f,	/* 삟 */
      0xec82a0,	/* 삠 */
      0xec82a1,	/* 삡 */
      0xec82a2,	/* 삢 */
      0xec82a3,	/* 삣 */
      0xec82a4,	/* 삤 */
      0xec82a5,	/* 삥 */
      0xec82a6,	/* 삦 */
      0xec82a7,	/* 삧 */
      0xec82a8,	/* 삨 */
      0xec82a9,	/* 삩 */
      0xec82aa,	/* 삪 */
      0xec82ab,	/* 삫 */
    },
  },
  {
    {
      0xec82ac,	/* 사 */
      0xec82ad,	/* 삭 */
      0xec82ae,	/* 삮 */
      0xec82af,	/* 삯 */
      0xec82b0,	/* 산 */
      0xec82b1,	/* 삱 */
      0xec82b2,	/* 삲 */
      0xec82b3,	/* 삳 */
      0xec82b4,	/* 살 */
      0xec82b5,	/* 삵 */
      0xec82b6,	/* 삶 */
      0xec82b7,	/* 삷 */
      0xec82b8,	/* 삸 */
      0xec82b9,	/* 삹 */
      0xec82ba,	/* 삺 */
      0xec82bb,	/* 삻 */
      0xec82bc,	/* 삼 */
      0xec82bd,	/* 삽 */
      0xec82be,	/* 삾 */
      0xec82bf,	/* 삿 */
      0xec8380,	/* 샀 */
      0xec8381,	/* 상 */
      0xec8382,	/* 샂 */
      0xec8383,	/* 샃 */
      0xec8384,	/* 샄 */
      0xec8385,	/* 샅 */
      0xec8386,	/* 샆 */
      0xec8387,	/* 샇 */
    },
    {
      0xec8388,	/* 새 */
      0xec8389,	/* 색 */
      0xec838a,	/* 샊 */
      0xec838b,	/* 샋 */
      0xec838c,	/* 샌 */
      0xec838d,	/* 샍 */
      0xec838e,	/* 샎 */
      0xec838f,	/* 샏 */
      0xec8390,	/* 샐 */
      0xec8391,	/* 샑 */
      0xec8392,	/* 샒 */
      0xec8393,	/* 샓 */
      0xec8394,	/* 샔 */
      0xec8395,	/* 샕 */
      0xec8396,	/* 샖 */
      0xec8397,	/* 샗 */
      0xec8398,	/* 샘 */
      0xec8399,	/* 샙 */
      0xec839a,	/* 샚 */
      0xec839b,	/* 샛 */
      0xec839c,	/* 샜 */
      0xec839d,	/* 생 */
      0xec839e,	/* 샞 */
      0xec839f,	/* 샟 */
      0xec83a0,	/* 샠 */
      0xec83a1,	/* 샡 */
      0xec83a2,	/* 샢 */
      0xec83a3,	/* 샣 */
    },
    {
      0xec83a4,	/* 샤 */
      0xec83a5,	/* 샥 */
      0xec83a6,	/* 샦 */
      0xec83a7,	/* 샧 */
      0xec83a8,	/* 샨 */
      0xec83a9,	/* 샩 */
      0xec83aa,	/* 샪 */
      0xec83ab,	/* 샫 */
      0xec83ac,	/* 샬 */
      0xec83ad,	/* 샭 */
      0xec83ae,	/* 샮 */
      0xec83af,	/* 샯 */
      0xec83b0,	/* 샰 */
      0xec83b1,	/* 샱 */
      0xec83b2,	/* 샲 */
      0xec83b3,	/* 샳 */
      0xec83b4,	/* 샴 */
      0xec83b5,	/* 샵 */
      0xec83b6,	/* 샶 */
      0xec83b7,	/* 샷 */
      0xec83b8,	/* 샸 */
      0xec83b9,	/* 샹 */
      0xec83ba,	/* 샺 */
      0xec83bb,	/* 샻 */
      0xec83bc,	/* 샼 */
      0xec83bd,	/* 샽 */
      0xec83be,	/* 샾 */
      0xec83bf,	/* 샿 */
    },
    {
      0xec8480,	/* 섀 */
      0xec8481,	/* 섁 */
      0xec8482,	/* 섂 */
      0xec8483,	/* 섃 */
      0xec8484,	/* 섄 */
      0xec8485,	/* 섅 */
      0xec8486,	/* 섆 */
      0xec8487,	/* 섇 */
      0xec8488,	/* 섈 */
      0xec8489,	/* 섉 */
      0xec848a,	/* 섊 */
      0xec848b,	/* 섋 */
      0xec848c,	/* 섌 */
      0xec848d,	/* 섍 */
      0xec848e,	/* 섎 */
      0xec848f,	/* 섏 */
      0xec8490,	/* 섐 */
      0xec8491,	/* 섑 */
      0xec8492,	/* 섒 */
      0xec8493,	/* 섓 */
      0xec8494,	/* 섔 */
      0xec8495,	/* 섕 */
      0xec8496,	/* 섖 */
      0xec8497,	/* 섗 */
      0xec8498,	/* 섘 */
      0xec8499,	/* 섙 */
      0xec849a,	/* 섚 */
      0xec849b,	/* 섛 */
    },
    {
      0xec849c,	/* 서 */
      0xec849d,	/* 석 */
      0xec849e,	/* 섞 */
      0xec849f,	/* 섟 */
      0xec84a0,	/* 선 */
      0xec84a1,	/* 섡 */
      0xec84a2,	/* 섢 */
      0xec84a3,	/* 섣 */
      0xec84a4,	/* 설 */
      0xec84a5,	/* 섥 */
      0xec84a6,	/* 섦 */
      0xec84a7,	/* 섧 */
      0xec84a8,	/* 섨 */
      0xec84a9,	/* 섩 */
      0xec84aa,	/* 섪 */
      0xec84ab,	/* 섫 */
      0xec84ac,	/* 섬 */
      0xec84ad,	/* 섭 */
      0xec84ae,	/* 섮 */
      0xec84af,	/* 섯 */
      0xec84b0,	/* 섰 */
      0xec84b1,	/* 성 */
      0xec84b2,	/* 섲 */
      0xec84b3,	/* 섳 */
      0xec84b4,	/* 섴 */
      0xec84b5,	/* 섵 */
      0xec84b6,	/* 섶 */
      0xec84b7,	/* 섷 */
    },
    {
      0xec84b8,	/* 세 */
      0xec84b9,	/* 섹 */
      0xec84ba,	/* 섺 */
      0xec84bb,	/* 섻 */
      0xec84bc,	/* 센 */
      0xec84bd,	/* 섽 */
      0xec84be,	/* 섾 */
      0xec84bf,	/* 섿 */
      0xec8580,	/* 셀 */
      0xec8581,	/* 셁 */
      0xec8582,	/* 셂 */
      0xec8583,	/* 셃 */
      0xec8584,	/* 셄 */
      0xec8585,	/* 셅 */
      0xec8586,	/* 셆 */
      0xec8587,	/* 셇 */
      0xec8588,	/* 셈 */
      0xec8589,	/* 셉 */
      0xec858a,	/* 셊 */
      0xec858b,	/* 셋 */
      0xec858c,	/* 셌 */
      0xec858d,	/* 셍 */
      0xec858e,	/* 셎 */
      0xec858f,	/* 셏 */
      0xec8590,	/* 셐 */
      0xec8591,	/* 셑 */
      0xec8592,	/* 셒 */
      0xec8593,	/* 셓 */
    },
    {
      0xec8594,	/* 셔 */
      0xec8595,	/* 셕 */
      0xec8596,	/* 셖 */
      0xec8597,	/* 셗 */
      0xec8598,	/* 션 */
      0xec8599,	/* 셙 */
      0xec859a,	/* 셚 */
      0xec859b,	/* 셛 */
      0xec859c,	/* 셜 */
      0xec859d,	/* 셝 */
      0xec859e,	/* 셞 */
      0xec859f,	/* 셟 */
      0xec85a0,	/* 셠 */
      0xec85a1,	/* 셡 */
      0xec85a2,	/* 셢 */
      0xec85a3,	/* 셣 */
      0xec85a4,	/* 셤 */
      0xec85a5,	/* 셥 */
      0xec85a6,	/* 셦 */
      0xec85a7,	/* 셧 */
      0xec85a8,	/* 셨 */
      0xec85a9,	/* 셩 */
      0xec85aa,	/* 셪 */
      0xec85ab,	/* 셫 */
      0xec85ac,	/* 셬 */
      0xec85ad,	/* 셭 */
      0xec85ae,	/* 셮 */
      0xec85af,	/* 셯 */
    },
    {
      0xec85b0,	/* 셰 */
      0xec85b1,	/* 셱 */
      0xec85b2,	/* 셲 */
      0xec85b3,	/* 셳 */
      0xec85b4,	/* 셴 */
      0xec85b5,	/* 셵 */
      0xec85b6,	/* 셶 */
      0xec85b7,	/* 셷 */
      0xec85b8,	/* 셸 */
      0xec85b9,	/* 셹 */
      0xec85ba,	/* 셺 */
      0xec85bb,	/* 셻 */
      0xec85bc,	/* 셼 */
      0xec85bd,	/* 셽 */
      0xec85be,	/* 셾 */
      0xec85bf,	/* 셿 */
      0xec8680,	/* 솀 */
      0xec8681,	/* 솁 */
      0xec8682,	/* 솂 */
      0xec8683,	/* 솃 */
      0xec8684,	/* 솄 */
      0xec8685,	/* 솅 */
      0xec8686,	/* 솆 */
      0xec8687,	/* 솇 */
      0xec8688,	/* 솈 */
      0xec8689,	/* 솉 */
      0xec868a,	/* 솊 */
      0xec868b,	/* 솋 */
    },
    {
      0xec868c,	/* 소 */
      0xec868d,	/* 속 */
      0xec868e,	/* 솎 */
      0xec868f,	/* 솏 */
      0xec8690,	/* 손 */
      0xec8691,	/* 솑 */
      0xec8692,	/* 솒 */
      0xec8693,	/* 솓 */
      0xec8694,	/* 솔 */
      0xec8695,	/* 솕 */
      0xec8696,	/* 솖 */
      0xec8697,	/* 솗 */
      0xec8698,	/* 솘 */
      0xec8699,	/* 솙 */
      0xec869a,	/* 솚 */
      0xec869b,	/* 솛 */
      0xec869c,	/* 솜 */
      0xec869d,	/* 솝 */
      0xec869e,	/* 솞 */
      0xec869f,	/* 솟 */
      0xec86a0,	/* 솠 */
      0xec86a1,	/* 송 */
      0xec86a2,	/* 솢 */
      0xec86a3,	/* 솣 */
      0xec86a4,	/* 솤 */
      0xec86a5,	/* 솥 */
      0xec86a6,	/* 솦 */
      0xec86a7,	/* 솧 */
    },
    {
      0xec86a8,	/* 솨 */
      0xec86a9,	/* 솩 */
      0xec86aa,	/* 솪 */
      0xec86ab,	/* 솫 */
      0xec86ac,	/* 솬 */
      0xec86ad,	/* 솭 */
      0xec86ae,	/* 솮 */
      0xec86af,	/* 솯 */
      0xec86b0,	/* 솰 */
      0xec86b1,	/* 솱 */
      0xec86b2,	/* 솲 */
      0xec86b3,	/* 솳 */
      0xec86b4,	/* 솴 */
      0xec86b5,	/* 솵 */
      0xec86b6,	/* 솶 */
      0xec86b7,	/* 솷 */
      0xec86b8,	/* 솸 */
      0xec86b9,	/* 솹 */
      0xec86ba,	/* 솺 */
      0xec86bb,	/* 솻 */
      0xec86bc,	/* 솼 */
      0xec86bd,	/* 솽 */
      0xec86be,	/* 솾 */
      0xec86bf,	/* 솿 */
      0xec8780,	/* 쇀 */
      0xec8781,	/* 쇁 */
      0xec8782,	/* 쇂 */
      0xec8783,	/* 쇃 */
    },
    {
      0xec8784,	/* 쇄 */
      0xec8785,	/* 쇅 */
      0xec8786,	/* 쇆 */
      0xec8787,	/* 쇇 */
      0xec8788,	/* 쇈 */
      0xec8789,	/* 쇉 */
      0xec878a,	/* 쇊 */
      0xec878b,	/* 쇋 */
      0xec878c,	/* 쇌 */
      0xec878d,	/* 쇍 */
      0xec878e,	/* 쇎 */
      0xec878f,	/* 쇏 */
      0xec8790,	/* 쇐 */
      0xec8791,	/* 쇑 */
      0xec8792,	/* 쇒 */
      0xec8793,	/* 쇓 */
      0xec8794,	/* 쇔 */
      0xec8795,	/* 쇕 */
      0xec8796,	/* 쇖 */
      0xec8797,	/* 쇗 */
      0xec8798,	/* 쇘 */
      0xec8799,	/* 쇙 */
      0xec879a,	/* 쇚 */
      0xec879b,	/* 쇛 */
      0xec879c,	/* 쇜 */
      0xec879d,	/* 쇝 */
      0xec879e,	/* 쇞 */
      0xec879f,	/* 쇟 */
    },
    {
      0xec87a0,	/* 쇠 */
      0xec87a1,	/* 쇡 */
      0xec87a2,	/* 쇢 */
      0xec87a3,	/* 쇣 */
      0xec87a4,	/* 쇤 */
      0xec87a5,	/* 쇥 */
      0xec87a6,	/* 쇦 */
      0xec87a7,	/* 쇧 */
      0xec87a8,	/* 쇨 */
      0xec87a9,	/* 쇩 */
      0xec87aa,	/* 쇪 */
      0xec87ab,	/* 쇫 */
      0xec87ac,	/* 쇬 */
      0xec87ad,	/* 쇭 */
      0xec87ae,	/* 쇮 */
      0xec87af,	/* 쇯 */
      0xec87b0,	/* 쇰 */
      0xec87b1,	/* 쇱 */
      0xec87b2,	/* 쇲 */
      0xec87b3,	/* 쇳 */
      0xec87b4,	/* 쇴 */
      0xec87b5,	/* 쇵 */
      0xec87b6,	/* 쇶 */
      0xec87b7,	/* 쇷 */
      0xec87b8,	/* 쇸 */
      0xec87b9,	/* 쇹 */
      0xec87ba,	/* 쇺 */
      0xec87bb,	/* 쇻 */
    },
    {
      0xec87bc,	/* 쇼 */
      0xec87bd,	/* 쇽 */
      0xec87be,	/* 쇾 */
      0xec87bf,	/* 쇿 */
      0xec8880,	/* 숀 */
      0xec8881,	/* 숁 */
      0xec8882,	/* 숂 */
      0xec8883,	/* 숃 */
      0xec8884,	/* 숄 */
      0xec8885,	/* 숅 */
      0xec8886,	/* 숆 */
      0xec8887,	/* 숇 */
      0xec8888,	/* 숈 */
      0xec8889,	/* 숉 */
      0xec888a,	/* 숊 */
      0xec888b,	/* 숋 */
      0xec888c,	/* 숌 */
      0xec888d,	/* 숍 */
      0xec888e,	/* 숎 */
      0xec888f,	/* 숏 */
      0xec8890,	/* 숐 */
      0xec8891,	/* 숑 */
      0xec8892,	/* 숒 */
      0xec8893,	/* 숓 */
      0xec8894,	/* 숔 */
      0xec8895,	/* 숕 */
      0xec8896,	/* 숖 */
      0xec8897,	/* 숗 */
    },
    {
      0xec8898,	/* 수 */
      0xec8899,	/* 숙 */
      0xec889a,	/* 숚 */
      0xec889b,	/* 숛 */
      0xec889c,	/* 순 */
      0xec889d,	/* 숝 */
      0xec889e,	/* 숞 */
      0xec889f,	/* 숟 */
      0xec88a0,	/* 술 */
      0xec88a1,	/* 숡 */
      0xec88a2,	/* 숢 */
      0xec88a3,	/* 숣 */
      0xec88a4,	/* 숤 */
      0xec88a5,	/* 숥 */
      0xec88a6,	/* 숦 */
      0xec88a7,	/* 숧 */
      0xec88a8,	/* 숨 */
      0xec88a9,	/* 숩 */
      0xec88aa,	/* 숪 */
      0xec88ab,	/* 숫 */
      0xec88ac,	/* 숬 */
      0xec88ad,	/* 숭 */
      0xec88ae,	/* 숮 */
      0xec88af,	/* 숯 */
      0xec88b0,	/* 숰 */
      0xec88b1,	/* 숱 */
      0xec88b2,	/* 숲 */
      0xec88b3,	/* 숳 */
    },
    {
      0xec88b4,	/* 숴 */
      0xec88b5,	/* 숵 */
      0xec88b6,	/* 숶 */
      0xec88b7,	/* 숷 */
      0xec88b8,	/* 숸 */
      0xec88b9,	/* 숹 */
      0xec88ba,	/* 숺 */
      0xec88bb,	/* 숻 */
      0xec88bc,	/* 숼 */
      0xec88bd,	/* 숽 */
      0xec88be,	/* 숾 */
      0xec88bf,	/* 숿 */
      0xec8980,	/* 쉀 */
      0xec8981,	/* 쉁 */
      0xec8982,	/* 쉂 */
      0xec8983,	/* 쉃 */
      0xec8984,	/* 쉄 */
      0xec8985,	/* 쉅 */
      0xec8986,	/* 쉆 */
      0xec8987,	/* 쉇 */
      0xec8988,	/* 쉈 */
      0xec8989,	/* 쉉 */
      0xec898a,	/* 쉊 */
      0xec898b,	/* 쉋 */
      0xec898c,	/* 쉌 */
      0xec898d,	/* 쉍 */
      0xec898e,	/* 쉎 */
      0xec898f,	/* 쉏 */
    },
    {
      0xec8990,	/* 쉐 */
      0xec8991,	/* 쉑 */
      0xec8992,	/* 쉒 */
      0xec8993,	/* 쉓 */
      0xec8994,	/* 쉔 */
      0xec8995,	/* 쉕 */
      0xec8996,	/* 쉖 */
      0xec8997,	/* 쉗 */
      0xec8998,	/* 쉘 */
      0xec8999,	/* 쉙 */
      0xec899a,	/* 쉚 */
      0xec899b,	/* 쉛 */
      0xec899c,	/* 쉜 */
      0xec899d,	/* 쉝 */
      0xec899e,	/* 쉞 */
      0xec899f,	/* 쉟 */
      0xec89a0,	/* 쉠 */
      0xec89a1,	/* 쉡 */
      0xec89a2,	/* 쉢 */
      0xec89a3,	/* 쉣 */
      0xec89a4,	/* 쉤 */
      0xec89a5,	/* 쉥 */
      0xec89a6,	/* 쉦 */
      0xec89a7,	/* 쉧 */
      0xec89a8,	/* 쉨 */
      0xec89a9,	/* 쉩 */
      0xec89aa,	/* 쉪 */
      0xec89ab,	/* 쉫 */
    },
    {
      0xec89ac,	/* 쉬 */
      0xec89ad,	/* 쉭 */
      0xec89ae,	/* 쉮 */
      0xec89af,	/* 쉯 */
      0xec89b0,	/* 쉰 */
      0xec89b1,	/* 쉱 */
      0xec89b2,	/* 쉲 */
      0xec89b3,	/* 쉳 */
      0xec89b4,	/* 쉴 */
      0xec89b5,	/* 쉵 */
      0xec89b6,	/* 쉶 */
      0xec89b7,	/* 쉷 */
      0xec89b8,	/* 쉸 */
      0xec89b9,	/* 쉹 */
      0xec89ba,	/* 쉺 */
      0xec89bb,	/* 쉻 */
      0xec89bc,	/* 쉼 */
      0xec89bd,	/* 쉽 */
      0xec89be,	/* 쉾 */
      0xec89bf,	/* 쉿 */
      0xec8a80,	/* 슀 */
      0xec8a81,	/* 슁 */
      0xec8a82,	/* 슂 */
      0xec8a83,	/* 슃 */
      0xec8a84,	/* 슄 */
      0xec8a85,	/* 슅 */
      0xec8a86,	/* 슆 */
      0xec8a87,	/* 슇 */
    },
    {
      0xec8a88,	/* 슈 */
      0xec8a89,	/* 슉 */
      0xec8a8a,	/* 슊 */
      0xec8a8b,	/* 슋 */
      0xec8a8c,	/* 슌 */
      0xec8a8d,	/* 슍 */
      0xec8a8e,	/* 슎 */
      0xec8a8f,	/* 슏 */
      0xec8a90,	/* 슐 */
      0xec8a91,	/* 슑 */
      0xec8a92,	/* 슒 */
      0xec8a93,	/* 슓 */
      0xec8a94,	/* 슔 */
      0xec8a95,	/* 슕 */
      0xec8a96,	/* 슖 */
      0xec8a97,	/* 슗 */
      0xec8a98,	/* 슘 */
      0xec8a99,	/* 슙 */
      0xec8a9a,	/* 슚 */
      0xec8a9b,	/* 슛 */
      0xec8a9c,	/* 슜 */
      0xec8a9d,	/* 슝 */
      0xec8a9e,	/* 슞 */
      0xec8a9f,	/* 슟 */
      0xec8aa0,	/* 슠 */
      0xec8aa1,	/* 슡 */
      0xec8aa2,	/* 슢 */
      0xec8aa3,	/* 슣 */
    },
    {
      0xec8aa4,	/* 스 */
      0xec8aa5,	/* 슥 */
      0xec8aa6,	/* 슦 */
      0xec8aa7,	/* 슧 */
      0xec8aa8,	/* 슨 */
      0xec8aa9,	/* 슩 */
      0xec8aaa,	/* 슪 */
      0xec8aab,	/* 슫 */
      0xec8aac,	/* 슬 */
      0xec8aad,	/* 슭 */
      0xec8aae,	/* 슮 */
      0xec8aaf,	/* 슯 */
      0xec8ab0,	/* 슰 */
      0xec8ab1,	/* 슱 */
      0xec8ab2,	/* 슲 */
      0xec8ab3,	/* 슳 */
      0xec8ab4,	/* 슴 */
      0xec8ab5,	/* 습 */
      0xec8ab6,	/* 슶 */
      0xec8ab7,	/* 슷 */
      0xec8ab8,	/* 슸 */
      0xec8ab9,	/* 승 */
      0xec8aba,	/* 슺 */
      0xec8abb,	/* 슻 */
      0xec8abc,	/* 슼 */
      0xec8abd,	/* 슽 */
      0xec8abe,	/* 슾 */
      0xec8abf,	/* 슿 */
    },
    {
      0xec8b80,	/* 싀 */
      0xec8b81,	/* 싁 */
      0xec8b82,	/* 싂 */
      0xec8b83,	/* 싃 */
      0xec8b84,	/* 싄 */
      0xec8b85,	/* 싅 */
      0xec8b86,	/* 싆 */
      0xec8b87,	/* 싇 */
      0xec8b88,	/* 싈 */
      0xec8b89,	/* 싉 */
      0xec8b8a,	/* 싊 */
      0xec8b8b,	/* 싋 */
      0xec8b8c,	/* 싌 */
      0xec8b8d,	/* 싍 */
      0xec8b8e,	/* 싎 */
      0xec8b8f,	/* 싏 */
      0xec8b90,	/* 싐 */
      0xec8b91,	/* 싑 */
      0xec8b92,	/* 싒 */
      0xec8b93,	/* 싓 */
      0xec8b94,	/* 싔 */
      0xec8b95,	/* 싕 */
      0xec8b96,	/* 싖 */
      0xec8b97,	/* 싗 */
      0xec8b98,	/* 싘 */
      0xec8b99,	/* 싙 */
      0xec8b9a,	/* 싚 */
      0xec8b9b,	/* 싛 */
    },
    {
      0xec8b9c,	/* 시 */
      0xec8b9d,	/* 식 */
      0xec8b9e,	/* 싞 */
      0xec8b9f,	/* 싟 */
      0xec8ba0,	/* 신 */
      0xec8ba1,	/* 싡 */
      0xec8ba2,	/* 싢 */
      0xec8ba3,	/* 싣 */
      0xec8ba4,	/* 실 */
      0xec8ba5,	/* 싥 */
      0xec8ba6,	/* 싦 */
      0xec8ba7,	/* 싧 */
      0xec8ba8,	/* 싨 */
      0xec8ba9,	/* 싩 */
      0xec8baa,	/* 싪 */
      0xec8bab,	/* 싫 */
      0xec8bac,	/* 심 */
      0xec8bad,	/* 십 */
      0xec8bae,	/* 싮 */
      0xec8baf,	/* 싯 */
      0xec8bb0,	/* 싰 */
      0xec8bb1,	/* 싱 */
      0xec8bb2,	/* 싲 */
      0xec8bb3,	/* 싳 */
      0xec8bb4,	/* 싴 */
      0xec8bb5,	/* 싵 */
      0xec8bb6,	/* 싶 */
      0xec8bb7,	/* 싷 */
    },
  },
  {
    {
      0xec8bb8,	/* 싸 */
      0xec8bb9,	/* 싹 */
      0xec8bba,	/* 싺 */
      0xec8bbb,	/* 싻 */
      0xec8bbc,	/* 싼 */
      0xec8bbd,	/* 싽 */
      0xec8bbe,	/* 싾 */
      0xec8bbf,	/* 싿 */
      0xec8c80,	/* 쌀 */
      0xec8c81,	/* 쌁 */
      0xec8c82,	/* 쌂 */
      0xec8c83,	/* 쌃 */
      0xec8c84,	/* 쌄 */
      0xec8c85,	/* 쌅 */
      0xec8c86,	/* 쌆 */
      0xec8c87,	/* 쌇 */
      0xec8c88,	/* 쌈 */
      0xec8c89,	/* 쌉 */
      0xec8c8a,	/* 쌊 */
      0xec8c8b,	/* 쌋 */
      0xec8c8c,	/* 쌌 */
      0xec8c8d,	/* 쌍 */
      0xec8c8e,	/* 쌎 */
      0xec8c8f,	/* 쌏 */
      0xec8c90,	/* 쌐 */
      0xec8c91,	/* 쌑 */
      0xec8c92,	/* 쌒 */
      0xec8c93,	/* 쌓 */
    },
    {
      0xec8c94,	/* 쌔 */
      0xec8c95,	/* 쌕 */
      0xec8c96,	/* 쌖 */
      0xec8c97,	/* 쌗 */
      0xec8c98,	/* 쌘 */
      0xec8c99,	/* 쌙 */
      0xec8c9a,	/* 쌚 */
      0xec8c9b,	/* 쌛 */
      0xec8c9c,	/* 쌜 */
      0xec8c9d,	/* 쌝 */
      0xec8c9e,	/* 쌞 */
      0xec8c9f,	/* 쌟 */
      0xec8ca0,	/* 쌠 */
      0xec8ca1,	/* 쌡 */
      0xec8ca2,	/* 쌢 */
      0xec8ca3,	/* 쌣 */
      0xec8ca4,	/* 쌤 */
      0xec8ca5,	/* 쌥 */
      0xec8ca6,	/* 쌦 */
      0xec8ca7,	/* 쌧 */
      0xec8ca8,	/* 쌨 */
      0xec8ca9,	/* 쌩 */
      0xec8caa,	/* 쌪 */
      0xec8cab,	/* 쌫 */
      0xec8cac,	/* 쌬 */
      0xec8cad,	/* 쌭 */
      0xec8cae,	/* 쌮 */
      0xec8caf,	/* 쌯 */
    },
    {
      0xec8cb0,	/* 쌰 */
      0xec8cb1,	/* 쌱 */
      0xec8cb2,	/* 쌲 */
      0xec8cb3,	/* 쌳 */
      0xec8cb4,	/* 쌴 */
      0xec8cb5,	/* 쌵 */
      0xec8cb6,	/* 쌶 */
      0xec8cb7,	/* 쌷 */
      0xec8cb8,	/* 쌸 */
      0xec8cb9,	/* 쌹 */
      0xec8cba,	/* 쌺 */
      0xec8cbb,	/* 쌻 */
      0xec8cbc,	/* 쌼 */
      0xec8cbd,	/* 쌽 */
      0xec8cbe,	/* 쌾 */
      0xec8cbf,	/* 쌿 */
      0xec8d80,	/* 썀 */
      0xec8d81,	/* 썁 */
      0xec8d82,	/* 썂 */
      0xec8d83,	/* 썃 */
      0xec8d84,	/* 썄 */
      0xec8d85,	/* 썅 */
      0xec8d86,	/* 썆 */
      0xec8d87,	/* 썇 */
      0xec8d88,	/* 썈 */
      0xec8d89,	/* 썉 */
      0xec8d8a,	/* 썊 */
      0xec8d8b,	/* 썋 */
    },
    {
      0xec8d8c,	/* 썌 */
      0xec8d8d,	/* 썍 */
      0xec8d8e,	/* 썎 */
      0xec8d8f,	/* 썏 */
      0xec8d90,	/* 썐 */
      0xec8d91,	/* 썑 */
      0xec8d92,	/* 썒 */
      0xec8d93,	/* 썓 */
      0xec8d94,	/* 썔 */
      0xec8d95,	/* 썕 */
      0xec8d96,	/* 썖 */
      0xec8d97,	/* 썗 */
      0xec8d98,	/* 썘 */
      0xec8d99,	/* 썙 */
      0xec8d9a,	/* 썚 */
      0xec8d9b,	/* 썛 */
      0xec8d9c,	/* 썜 */
      0xec8d9d,	/* 썝 */
      0xec8d9e,	/* 썞 */
      0xec8d9f,	/* 썟 */
      0xec8da0,	/* 썠 */
      0xec8da1,	/* 썡 */
      0xec8da2,	/* 썢 */
      0xec8da3,	/* 썣 */
      0xec8da4,	/* 썤 */
      0xec8da5,	/* 썥 */
      0xec8da6,	/* 썦 */
      0xec8da7,	/* 썧 */
    },
    {
      0xec8da8,	/* 써 */
      0xec8da9,	/* 썩 */
      0xec8daa,	/* 썪 */
      0xec8dab,	/* 썫 */
      0xec8dac,	/* 썬 */
      0xec8dad,	/* 썭 */
      0xec8dae,	/* 썮 */
      0xec8daf,	/* 썯 */
      0xec8db0,	/* 썰 */
      0xec8db1,	/* 썱 */
      0xec8db2,	/* 썲 */
      0xec8db3,	/* 썳 */
      0xec8db4,	/* 썴 */
      0xec8db5,	/* 썵 */
      0xec8db6,	/* 썶 */
      0xec8db7,	/* 썷 */
      0xec8db8,	/* 썸 */
      0xec8db9,	/* 썹 */
      0xec8dba,	/* 썺 */
      0xec8dbb,	/* 썻 */
      0xec8dbc,	/* 썼 */
      0xec8dbd,	/* 썽 */
      0xec8dbe,	/* 썾 */
      0xec8dbf,	/* 썿 */
      0xec8e80,	/* 쎀 */
      0xec8e81,	/* 쎁 */
      0xec8e82,	/* 쎂 */
      0xec8e83,	/* 쎃 */
    },
    {
      0xec8e84,	/* 쎄 */
      0xec8e85,	/* 쎅 */
      0xec8e86,	/* 쎆 */
      0xec8e87,	/* 쎇 */
      0xec8e88,	/* 쎈 */
      0xec8e89,	/* 쎉 */
      0xec8e8a,	/* 쎊 */
      0xec8e8b,	/* 쎋 */
      0xec8e8c,	/* 쎌 */
      0xec8e8d,	/* 쎍 */
      0xec8e8e,	/* 쎎 */
      0xec8e8f,	/* 쎏 */
      0xec8e90,	/* 쎐 */
      0xec8e91,	/* 쎑 */
      0xec8e92,	/* 쎒 */
      0xec8e93,	/* 쎓 */
      0xec8e94,	/* 쎔 */
      0xec8e95,	/* 쎕 */
      0xec8e96,	/* 쎖 */
      0xec8e97,	/* 쎗 */
      0xec8e98,	/* 쎘 */
      0xec8e99,	/* 쎙 */
      0xec8e9a,	/* 쎚 */
      0xec8e9b,	/* 쎛 */
      0xec8e9c,	/* 쎜 */
      0xec8e9d,	/* 쎝 */
      0xec8e9e,	/* 쎞 */
      0xec8e9f,	/* 쎟 */
    },
    {
      0xec8ea0,	/* 쎠 */
      0xec8ea1,	/* 쎡 */
      0xec8ea2,	/* 쎢 */
      0xec8ea3,	/* 쎣 */
      0xec8ea4,	/* 쎤 */
      0xec8ea5,	/* 쎥 */
      0xec8ea6,	/* 쎦 */
      0xec8ea7,	/* 쎧 */
      0xec8ea8,	/* 쎨 */
      0xec8ea9,	/* 쎩 */
      0xec8eaa,	/* 쎪 */
      0xec8eab,	/* 쎫 */
      0xec8eac,	/* 쎬 */
      0xec8ead,	/* 쎭 */
      0xec8eae,	/* 쎮 */
      0xec8eaf,	/* 쎯 */
      0xec8eb0,	/* 쎰 */
      0xec8eb1,	/* 쎱 */
      0xec8eb2,	/* 쎲 */
      0xec8eb3,	/* 쎳 */
      0xec8eb4,	/* 쎴 */
      0xec8eb5,	/* 쎵 */
      0xec8eb6,	/* 쎶 */
      0xec8eb7,	/* 쎷 */
      0xec8eb8,	/* 쎸 */
      0xec8eb9,	/* 쎹 */
      0xec8eba,	/* 쎺 */
      0xec8ebb,	/* 쎻 */
    },
    {
      0xec8ebc,	/* 쎼 */
      0xec8ebd,	/* 쎽 */
      0xec8ebe,	/* 쎾 */
      0xec8ebf,	/* 쎿 */
      0xec8f80,	/* 쏀 */
      0xec8f81,	/* 쏁 */
      0xec8f82,	/* 쏂 */
      0xec8f83,	/* 쏃 */
      0xec8f84,	/* 쏄 */
      0xec8f85,	/* 쏅 */
      0xec8f86,	/* 쏆 */
      0xec8f87,	/* 쏇 */
      0xec8f88,	/* 쏈 */
      0xec8f89,	/* 쏉 */
      0xec8f8a,	/* 쏊 */
      0xec8f8b,	/* 쏋 */
      0xec8f8c,	/* 쏌 */
      0xec8f8d,	/* 쏍 */
      0xec8f8e,	/* 쏎 */
      0xec8f8f,	/* 쏏 */
      0xec8f90,	/* 쏐 */
      0xec8f91,	/* 쏑 */
      0xec8f92,	/* 쏒 */
      0xec8f93,	/* 쏓 */
      0xec8f94,	/* 쏔 */
      0xec8f95,	/* 쏕 */
      0xec8f96,	/* 쏖 */
      0xec8f97,	/* 쏗 */
    },
    {
      0xec8f98,	/* 쏘 */
      0xec8f99,	/* 쏙 */
      0xec8f9a,	/* 쏚 */
      0xec8f9b,	/* 쏛 */
      0xec8f9c,	/* 쏜 */
      0xec8f9d,	/* 쏝 */
      0xec8f9e,	/* 쏞 */
      0xec8f9f,	/* 쏟 */
      0xec8fa0,	/* 쏠 */
      0xec8fa1,	/* 쏡 */
      0xec8fa2,	/* 쏢 */
      0xec8fa3,	/* 쏣 */
      0xec8fa4,	/* 쏤 */
      0xec8fa5,	/* 쏥 */
      0xec8fa6,	/* 쏦 */
      0xec8fa7,	/* 쏧 */
      0xec8fa8,	/* 쏨 */
      0xec8fa9,	/* 쏩 */
      0xec8faa,	/* 쏪 */
      0xec8fab,	/* 쏫 */
      0xec8fac,	/* 쏬 */
      0xec8fad,	/* 쏭 */
      0xec8fae,	/* 쏮 */
      0xec8faf,	/* 쏯 */
      0xec8fb0,	/* 쏰 */
      0xec8fb1,	/* 쏱 */
      0xec8fb2,	/* 쏲 */
      0xec8fb3,	/* 쏳 */
    },
    {
      0xec8fb4,	/* 쏴 */
      0xec8fb5,	/* 쏵 */
      0xec8fb6,	/* 쏶 */
      0xec8fb7,	/* 쏷 */
      0xec8fb8,	/* 쏸 */
      0xec8fb9,	/* 쏹 */
      0xec8fba,	/* 쏺 */
      0xec8fbb,	/* 쏻 */
      0xec8fbc,	/* 쏼 */
      0xec8fbd,	/* 쏽 */
      0xec8fbe,	/* 쏾 */
      0xec8fbf,	/* 쏿 */
      0xec9080,	/* 쐀 */
      0xec9081,	/* 쐁 */
      0xec9082,	/* 쐂 */
      0xec9083,	/* 쐃 */
      0xec9084,	/* 쐄 */
      0xec9085,	/* 쐅 */
      0xec9086,	/* 쐆 */
      0xec9087,	/* 쐇 */
      0xec9088,	/* 쐈 */
      0xec9089,	/* 쐉 */
      0xec908a,	/* 쐊 */
      0xec908b,	/* 쐋 */
      0xec908c,	/* 쐌 */
      0xec908d,	/* 쐍 */
      0xec908e,	/* 쐎 */
      0xec908f,	/* 쐏 */
    },
    {
      0xec9090,	/* 쐐 */
      0xec9091,	/* 쐑 */
      0xec9092,	/* 쐒 */
      0xec9093,	/* 쐓 */
      0xec9094,	/* 쐔 */
      0xec9095,	/* 쐕 */
      0xec9096,	/* 쐖 */
      0xec9097,	/* 쐗 */
      0xec9098,	/* 쐘 */
      0xec9099,	/* 쐙 */
      0xec909a,	/* 쐚 */
      0xec909b,	/* 쐛 */
      0xec909c,	/* 쐜 */
      0xec909d,	/* 쐝 */
      0xec909e,	/* 쐞 */
      0xec909f,	/* 쐟 */
      0xec90a0,	/* 쐠 */
      0xec90a1,	/* 쐡 */
      0xec90a2,	/* 쐢 */
      0xec90a3,	/* 쐣 */
      0xec90a4,	/* 쐤 */
      0xec90a5,	/* 쐥 */
      0xec90a6,	/* 쐦 */
      0xec90a7,	/* 쐧 */
      0xec90a8,	/* 쐨 */
      0xec90a9,	/* 쐩 */
      0xec90aa,	/* 쐪 */
      0xec90ab,	/* 쐫 */
    },
    {
      0xec90ac,	/* 쐬 */
      0xec90ad,	/* 쐭 */
      0xec90ae,	/* 쐮 */
      0xec90af,	/* 쐯 */
      0xec90b0,	/* 쐰 */
      0xec90b1,	/* 쐱 */
      0xec90b2,	/* 쐲 */
      0xec90b3,	/* 쐳 */
      0xec90b4,	/* 쐴 */
      0xec90b5,	/* 쐵 */
      0xec90b6,	/* 쐶 */
      0xec90b7,	/* 쐷 */
      0xec90b8,	/* 쐸 */
      0xec90b9,	/* 쐹 */
      0xec90ba,	/* 쐺 */
      0xec90bb,	/* 쐻 */
      0xec90bc,	/* 쐼 */
      0xec90bd,	/* 쐽 */
      0xec90be,	/* 쐾 */
      0xec90bf,	/* 쐿 */
      0xec9180,	/* 쑀 */
      0xec9181,	/* 쑁 */
      0xec9182,	/* 쑂 */
      0xec9183,	/* 쑃 */
      0xec9184,	/* 쑄 */
      0xec9185,	/* 쑅 */
      0xec9186,	/* 쑆 */
      0xec9187,	/* 쑇 */
    },
    {
      0xec9188,	/* 쑈 */
      0xec9189,	/* 쑉 */
      0xec918a,	/* 쑊 */
      0xec918b,	/* 쑋 */
      0xec918c,	/* 쑌 */
      0xec918d,	/* 쑍 */
      0xec918e,	/* 쑎 */
      0xec918f,	/* 쑏 */
      0xec9190,	/* 쑐 */
      0xec9191,	/* 쑑 */
      0xec9192,	/* 쑒 */
      0xec9193,	/* 쑓 */
      0xec9194,	/* 쑔 */
      0xec9195,	/* 쑕 */
      0xec9196,	/* 쑖 */
      0xec9197,	/* 쑗 */
      0xec9198,	/* 쑘 */
      0xec9199,	/* 쑙 */
      0xec919a,	/* 쑚 */
      0xec919b,	/* 쑛 */
      0xec919c,	/* 쑜 */
      0xec919d,	/* 쑝 */
      0xec919e,	/* 쑞 */
      0xec919f,	/* 쑟 */
      0xec91a0,	/* 쑠 */
      0xec91a1,	/* 쑡 */
      0xec91a2,	/* 쑢 */
      0xec91a3,	/* 쑣 */
    },
    {
      0xec91a4,	/* 쑤 */
      0xec91a5,	/* 쑥 */
      0xec91a6,	/* 쑦 */
      0xec91a7,	/* 쑧 */
      0xec91a8,	/* 쑨 */
      0xec91a9,	/* 쑩 */
      0xec91aa,	/* 쑪 */
      0xec91ab,	/* 쑫 */
      0xec91ac,	/* 쑬 */
      0xec91ad,	/* 쑭 */
      0xec91ae,	/* 쑮 */
      0xec91af,	/* 쑯 */
      0xec91b0,	/* 쑰 */
      0xec91b1,	/* 쑱 */
      0xec91b2,	/* 쑲 */
      0xec91b3,	/* 쑳 */
      0xec91b4,	/* 쑴 */
      0xec91b5,	/* 쑵 */
      0xec91b6,	/* 쑶 */
      0xec91b7,	/* 쑷 */
      0xec91b8,	/* 쑸 */
      0xec91b9,	/* 쑹 */
      0xec91ba,	/* 쑺 */
      0xec91bb,	/* 쑻 */
      0xec91bc,	/* 쑼 */
      0xec91bd,	/* 쑽 */
      0xec91be,	/* 쑾 */
      0xec91bf,	/* 쑿 */
    },
    {
      0xec9280,	/* 쒀 */
      0xec9281,	/* 쒁 */
      0xec9282,	/* 쒂 */
      0xec9283,	/* 쒃 */
      0xec9284,	/* 쒄 */
      0xec9285,	/* 쒅 */
      0xec9286,	/* 쒆 */
      0xec9287,	/* 쒇 */
      0xec9288,	/* 쒈 */
      0xec9289,	/* 쒉 */
      0xec928a,	/* 쒊 */
      0xec928b,	/* 쒋 */
      0xec928c,	/* 쒌 */
      0xec928d,	/* 쒍 */
      0xec928e,	/* 쒎 */
      0xec928f,	/* 쒏 */
      0xec9290,	/* 쒐 */
      0xec9291,	/* 쒑 */
      0xec9292,	/* 쒒 */
      0xec9293,	/* 쒓 */
      0xec9294,	/* 쒔 */
      0xec9295,	/* 쒕 */
      0xec9296,	/* 쒖 */
      0xec9297,	/* 쒗 */
      0xec9298,	/* 쒘 */
      0xec9299,	/* 쒙 */
      0xec929a,	/* 쒚 */
      0xec929b,	/* 쒛 */
    },
    {
      0xec929c,	/* 쒜 */
      0xec929d,	/* 쒝 */
      0xec929e,	/* 쒞 */
      0xec929f,	/* 쒟 */
      0xec92a0,	/* 쒠 */
      0xec92a1,	/* 쒡 */
      0xec92a2,	/* 쒢 */
      0xec92a3,	/* 쒣 */
      0xec92a4,	/* 쒤 */
      0xec92a5,	/* 쒥 */
      0xec92a6,	/* 쒦 */
      0xec92a7,	/* 쒧 */
      0xec92a8,	/* 쒨 */
      0xec92a9,	/* 쒩 */
      0xec92aa,	/* 쒪 */
      0xec92ab,	/* 쒫 */
      0xec92ac,	/* 쒬 */
      0xec92ad,	/* 쒭 */
      0xec92ae,	/* 쒮 */
      0xec92af,	/* 쒯 */
      0xec92b0,	/* 쒰 */
      0xec92b1,	/* 쒱 */
      0xec92b2,	/* 쒲 */
      0xec92b3,	/* 쒳 */
      0xec92b4,	/* 쒴 */
      0xec92b5,	/* 쒵 */
      0xec92b6,	/* 쒶 */
      0xec92b7,	/* 쒷 */
    },
    {
      0xec92b8,	/* 쒸 */
      0xec92b9,	/* 쒹 */
      0xec92ba,	/* 쒺 */
      0xec92bb,	/* 쒻 */
      0xec92bc,	/* 쒼 */
      0xec92bd,	/* 쒽 */
      0xec92be,	/* 쒾 */
      0xec92bf,	/* 쒿 */
      0xec9380,	/* 쓀 */
      0xec9381,	/* 쓁 */
      0xec9382,	/* 쓂 */
      0xec9383,	/* 쓃 */
      0xec9384,	/* 쓄 */
      0xec9385,	/* 쓅 */
      0xec9386,	/* 쓆 */
      0xec9387,	/* 쓇 */
      0xec9388,	/* 쓈 */
      0xec9389,	/* 쓉 */
      0xec938a,	/* 쓊 */
      0xec938b,	/* 쓋 */
      0xec938c,	/* 쓌 */
      0xec938d,	/* 쓍 */
      0xec938e,	/* 쓎 */
      0xec938f,	/* 쓏 */
      0xec9390,	/* 쓐 */
      0xec9391,	/* 쓑 */
      0xec9392,	/* 쓒 */
      0xec9393,	/* 쓓 */
    },
    {
      0xec9394,	/* 쓔 */
      0xec9395,	/* 쓕 */
      0xec9396,	/* 쓖 */
      0xec9397,	/* 쓗 */
      0xec9398,	/* 쓘 */
      0xec9399,	/* 쓙 */
      0xec939a,	/* 쓚 */
      0xec939b,	/* 쓛 */
      0xec939c,	/* 쓜 */
      0xec939d,	/* 쓝 */
      0xec939e,	/* 쓞 */
      0xec939f,	/* 쓟 */
      0xec93a0,	/* 쓠 */
      0xec93a1,	/* 쓡 */
      0xec93a2,	/* 쓢 */
      0xec93a3,	/* 쓣 */
      0xec93a4,	/* 쓤 */
      0xec93a5,	/* 쓥 */
      0xec93a6,	/* 쓦 */
      0xec93a7,	/* 쓧 */
      0xec93a8,	/* 쓨 */
      0xec93a9,	/* 쓩 */
      0xec93aa,	/* 쓪 */
      0xec93ab,	/* 쓫 */
      0xec93ac,	/* 쓬 */
      0xec93ad,	/* 쓭 */
      0xec93ae,	/* 쓮 */
      0xec93af,	/* 쓯 */
    },
    {
      0xec93b0,	/* 쓰 */
      0xec93b1,	/* 쓱 */
      0xec93b2,	/* 쓲 */
      0xec93b3,	/* 쓳 */
      0xec93b4,	/* 쓴 */
      0xec93b5,	/* 쓵 */
      0xec93b6,	/* 쓶 */
      0xec93b7,	/* 쓷 */
      0xec93b8,	/* 쓸 */
      0xec93b9,	/* 쓹 */
      0xec93ba,	/* 쓺 */
      0xec93bb,	/* 쓻 */
      0xec93bc,	/* 쓼 */
      0xec93bd,	/* 쓽 */
      0xec93be,	/* 쓾 */
      0xec93bf,	/* 쓿 */
      0xec9480,	/* 씀 */
      0xec9481,	/* 씁 */
      0xec9482,	/* 씂 */
      0xec9483,	/* 씃 */
      0xec9484,	/* 씄 */
      0xec9485,	/* 씅 */
      0xec9486,	/* 씆 */
      0xec9487,	/* 씇 */
      0xec9488,	/* 씈 */
      0xec9489,	/* 씉 */
      0xec948a,	/* 씊 */
      0xec948b,	/* 씋 */
    },
    {
      0xec948c,	/* 씌 */
      0xec948d,	/* 씍 */
      0xec948e,	/* 씎 */
      0xec948f,	/* 씏 */
      0xec9490,	/* 씐 */
      0xec9491,	/* 씑 */
      0xec9492,	/* 씒 */
      0xec9493,	/* 씓 */
      0xec9494,	/* 씔 */
      0xec9495,	/* 씕 */
      0xec9496,	/* 씖 */
      0xec9497,	/* 씗 */
      0xec9498,	/* 씘 */
      0xec9499,	/* 씙 */
      0xec949a,	/* 씚 */
      0xec949b,	/* 씛 */
      0xec949c,	/* 씜 */
      0xec949d,	/* 씝 */
      0xec949e,	/* 씞 */
      0xec949f,	/* 씟 */
      0xec94a0,	/* 씠 */
      0xec94a1,	/* 씡 */
      0xec94a2,	/* 씢 */
      0xec94a3,	/* 씣 */
      0xec94a4,	/* 씤 */
      0xec94a5,	/* 씥 */
      0xec94a6,	/* 씦 */
      0xec94a7,	/* 씧 */
    },
    {
      0xec94a8,	/* 씨 */
      0xec94a9,	/* 씩 */
      0xec94aa,	/* 씪 */
      0xec94ab,	/* 씫 */
      0xec94ac,	/* 씬 */
      0xec94ad,	/* 씭 */
      0xec94ae,	/* 씮 */
      0xec94af,	/* 씯 */
      0xec94b0,	/* 씰 */
      0xec94b1,	/* 씱 */
      0xec94b2,	/* 씲 */
      0xec94b3,	/* 씳 */
      0xec94b4,	/* 씴 */
      0xec94b5,	/* 씵 */
      0xec94b6,	/* 씶 */
      0xec94b7,	/* 씷 */
      0xec94b8,	/* 씸 */
      0xec94b9,	/* 씹 */
      0xec94ba,	/* 씺 */
      0xec94bb,	/* 씻 */
      0xec94bc,	/* 씼 */
      0xec94bd,	/* 씽 */
      0xec94be,	/* 씾 */
      0xec94bf,	/* 씿 */
      0xec9580,	/* 앀 */
      0xec9581,	/* 앁 */
      0xec9582,	/* 앂 */
      0xec9583,	/* 앃 */
    },
  },
  {
    {
      0xec9584,	/* 아 */
      0xec9585,	/* 악 */
      0xec9586,	/* 앆 */
      0xec9587,	/* 앇 */
      0xec9588,	/* 안 */
      0xec9589,	/* 앉 */
      0xec958a,	/* 않 */
      0xec958b,	/* 앋 */
      0xec958c,	/* 알 */
      0xec958d,	/* 앍 */
      0xec958e,	/* 앎 */
      0xec958f,	/* 앏 */
      0xec9590,	/* 앐 */
      0xec9591,	/* 앑 */
      0xec9592,	/* 앒 */
      0xec9593,	/* 앓 */
      0xec9594,	/* 암 */
      0xec9595,	/* 압 */
      0xec9596,	/* 앖 */
      0xec9597,	/* 앗 */
      0xec9598,	/* 았 */
      0xec9599,	/* 앙 */
      0xec959a,	/* 앚 */
      0xec959b,	/* 앛 */
      0xec959c,	/* 앜 */
      0xec959d,	/* 앝 */
      0xec959e,	/* 앞 */
      0xec959f,	/* 앟 */
    },
    {
      0xec95a0,	/* 애 */
      0xec95a1,	/* 액 */
      0xec95a2,	/* 앢 */
      0xec95a3,	/* 앣 */
      0xec95a4,	/* 앤 */
      0xec95a5,	/* 앥 */
      0xec95a6,	/* 앦 */
      0xec95a7,	/* 앧 */
      0xec95a8,	/* 앨 */
      0xec95a9,	/* 앩 */
      0xec95aa,	/* 앪 */
      0xec95ab,	/* 앫 */
      0xec95ac,	/* 앬 */
      0xec95ad,	/* 앭 */
      0xec95ae,	/* 앮 */
      0xec95af,	/* 앯 */
      0xec95b0,	/* 앰 */
      0xec95b1,	/* 앱 */
      0xec95b2,	/* 앲 */
      0xec95b3,	/* 앳 */
      0xec95b4,	/* 앴 */
      0xec95b5,	/* 앵 */
      0xec95b6,	/* 앶 */
      0xec95b7,	/* 앷 */
      0xec95b8,	/* 앸 */
      0xec95b9,	/* 앹 */
      0xec95ba,	/* 앺 */
      0xec95bb,	/* 앻 */
    },
    {
      0xec95bc,	/* 야 */
      0xec95bd,	/* 약 */
      0xec95be,	/* 앾 */
      0xec95bf,	/* 앿 */
      0xec9680,	/* 얀 */
      0xec9681,	/* 얁 */
      0xec9682,	/* 얂 */
      0xec9683,	/* 얃 */
      0xec9684,	/* 얄 */
      0xec9685,	/* 얅 */
      0xec9686,	/* 얆 */
      0xec9687,	/* 얇 */
      0xec9688,	/* 얈 */
      0xec9689,	/* 얉 */
      0xec968a,	/* 얊 */
      0xec968b,	/* 얋 */
      0xec968c,	/* 얌 */
      0xec968d,	/* 얍 */
      0xec968e,	/* 얎 */
      0xec968f,	/* 얏 */
      0xec9690,	/* 얐 */
      0xec9691,	/* 양 */
      0xec9692,	/* 얒 */
      0xec9693,	/* 얓 */
      0xec9694,	/* 얔 */
      0xec9695,	/* 얕 */
      0xec9696,	/* 얖 */
      0xec9697,	/* 얗 */
    },
    {
      0xec9698,	/* 얘 */
      0xec9699,	/* 얙 */
      0xec969a,	/* 얚 */
      0xec969b,	/* 얛 */
      0xec969c,	/* 얜 */
      0xec969d,	/* 얝 */
      0xec969e,	/* 얞 */
      0xec969f,	/* 얟 */
      0xec96a0,	/* 얠 */
      0xec96a1,	/* 얡 */
      0xec96a2,	/* 얢 */
      0xec96a3,	/* 얣 */
      0xec96a4,	/* 얤 */
      0xec96a5,	/* 얥 */
      0xec96a6,	/* 얦 */
      0xec96a7,	/* 얧 */
      0xec96a8,	/* 얨 */
      0xec96a9,	/* 얩 */
      0xec96aa,	/* 얪 */
      0xec96ab,	/* 얫 */
      0xec96ac,	/* 얬 */
      0xec96ad,	/* 얭 */
      0xec96ae,	/* 얮 */
      0xec96af,	/* 얯 */
      0xec96b0,	/* 얰 */
      0xec96b1,	/* 얱 */
      0xec96b2,	/* 얲 */
      0xec96b3,	/* 얳 */
    },
    {
      0xec96b4,	/* 어 */
      0xec96b5,	/* 억 */
      0xec96b6,	/* 얶 */
      0xec96b7,	/* 얷 */
      0xec96b8,	/* 언 */
      0xec96b9,	/* 얹 */
      0xec96ba,	/* 얺 */
      0xec96bb,	/* 얻 */
      0xec96bc,	/* 얼 */
      0xec96bd,	/* 얽 */
      0xec96be,	/* 얾 */
      0xec96bf,	/* 얿 */
      0xec9780,	/* 엀 */
      0xec9781,	/* 엁 */
      0xec9782,	/* 엂 */
      0xec9783,	/* 엃 */
      0xec9784,	/* 엄 */
      0xec9785,	/* 업 */
      0xec9786,	/* 없 */
      0xec9787,	/* 엇 */
      0xec9788,	/* 었 */
      0xec9789,	/* 엉 */
      0xec978a,	/* 엊 */
      0xec978b,	/* 엋 */
      0xec978c,	/* 엌 */
      0xec978d,	/* 엍 */
      0xec978e,	/* 엎 */
      0xec978f,	/* 엏 */
    },
    {
      0xec9790,	/* 에 */
      0xec9791,	/* 엑 */
      0xec9792,	/* 엒 */
      0xec9793,	/* 엓 */
      0xec9794,	/* 엔 */
      0xec9795,	/* 엕 */
      0xec9796,	/* 엖 */
      0xec9797,	/* 엗 */
      0xec9798,	/* 엘 */
      0xec9799,	/* 엙 */
      0xec979a,	/* 엚 */
      0xec979b,	/* 엛 */
      0xec979c,	/* 엜 */
      0xec979d,	/* 엝 */
      0xec979e,	/* 엞 */
      0xec979f,	/* 엟 */
      0xec97a0,	/* 엠 */
      0xec97a1,	/* 엡 */
      0xec97a2,	/* 엢 */
      0xec97a3,	/* 엣 */
      0xec97a4,	/* 엤 */
      0xec97a5,	/* 엥 */
      0xec97a6,	/* 엦 */
      0xec97a7,	/* 엧 */
      0xec97a8,	/* 엨 */
      0xec97a9,	/* 엩 */
      0xec97aa,	/* 엪 */
      0xec97ab,	/* 엫 */
    },
    {
      0xec97ac,	/* 여 */
      0xec97ad,	/* 역 */
      0xec97ae,	/* 엮 */
      0xec97af,	/* 엯 */
      0xec97b0,	/* 연 */
      0xec97b1,	/* 엱 */
      0xec97b2,	/* 엲 */
      0xec97b3,	/* 엳 */
      0xec97b4,	/* 열 */
      0xec97b5,	/* 엵 */
      0xec97b6,	/* 엶 */
      0xec97b7,	/* 엷 */
      0xec97b8,	/* 엸 */
      0xec97b9,	/* 엹 */
      0xec97ba,	/* 엺 */
      0xec97bb,	/* 엻 */
      0xec97bc,	/* 염 */
      0xec97bd,	/* 엽 */
      0xec97be,	/* 엾 */
      0xec97bf,	/* 엿 */
      0xec9880,	/* 였 */
      0xec9881,	/* 영 */
      0xec9882,	/* 옂 */
      0xec9883,	/* 옃 */
      0xec9884,	/* 옄 */
      0xec9885,	/* 옅 */
      0xec9886,	/* 옆 */
      0xec9887,	/* 옇 */
    },
    {
      0xec9888,	/* 예 */
      0xec9889,	/* 옉 */
      0xec988a,	/* 옊 */
      0xec988b,	/* 옋 */
      0xec988c,	/* 옌 */
      0xec988d,	/* 옍 */
      0xec988e,	/* 옎 */
      0xec988f,	/* 옏 */
      0xec9890,	/* 옐 */
      0xec9891,	/* 옑 */
      0xec9892,	/* 옒 */
      0xec9893,	/* 옓 */
      0xec9894,	/* 옔 */
      0xec9895,	/* 옕 */
      0xec9896,	/* 옖 */
      0xec9897,	/* 옗 */
      0xec9898,	/* 옘 */
      0xec9899,	/* 옙 */
      0xec989a,	/* 옚 */
      0xec989b,	/* 옛 */
      0xec989c,	/* 옜 */
      0xec989d,	/* 옝 */
      0xec989e,	/* 옞 */
      0xec989f,	/* 옟 */
      0xec98a0,	/* 옠 */
      0xec98a1,	/* 옡 */
      0xec98a2,	/* 옢 */
      0xec98a3,	/* 옣 */
    },
    {
      0xec98a4,	/* 오 */
      0xec98a5,	/* 옥 */
      0xec98a6,	/* 옦 */
      0xec98a7,	/* 옧 */
      0xec98a8,	/* 온 */
      0xec98a9,	/* 옩 */
      0xec98aa,	/* 옪 */
      0xec98ab,	/* 옫 */
      0xec98ac,	/* 올 */
      0xec98ad,	/* 옭 */
      0xec98ae,	/* 옮 */
      0xec98af,	/* 옯 */
      0xec98b0,	/* 옰 */
      0xec98b1,	/* 옱 */
      0xec98b2,	/* 옲 */
      0xec98b3,	/* 옳 */
      0xec98b4,	/* 옴 */
      0xec98b5,	/* 옵 */
      0xec98b6,	/* 옶 */
      0xec98b7,	/* 옷 */
      0xec98b8,	/* 옸 */
      0xec98b9,	/* 옹 */
      0xec98ba,	/* 옺 */
      0xec98bb,	/* 옻 */
      0xec98bc,	/* 옼 */
      0xec98bd,	/* 옽 */
      0xec98be,	/* 옾 */
      0xec98bf,	/* 옿 */
    },
    {
      0xec9980,	/* 와 */
      0xec9981,	/* 왁 */
      0xec9982,	/* 왂 */
      0xec9983,	/* 왃 */
      0xec9984,	/* 완 */
      0xec9985,	/* 왅 */
      0xec9986,	/* 왆 */
      0xec9987,	/* 왇 */
      0xec9988,	/* 왈 */
      0xec9989,	/* 왉 */
      0xec998a,	/* 왊 */
      0xec998b,	/* 왋 */
      0xec998c,	/* 왌 */
      0xec998d,	/* 왍 */
      0xec998e,	/* 왎 */
      0xec998f,	/* 왏 */
      0xec9990,	/* 왐 */
      0xec9991,	/* 왑 */
      0xec9992,	/* 왒 */
      0xec9993,	/* 왓 */
      0xec9994,	/* 왔 */
      0xec9995,	/* 왕 */
      0xec9996,	/* 왖 */
      0xec9997,	/* 왗 */
      0xec9998,	/* 왘 */
      0xec9999,	/* 왙 */
      0xec999a,	/* 왚 */
      0xec999b,	/* 왛 */
    },
    {
      0xec999c,	/* 왜 */
      0xec999d,	/* 왝 */
      0xec999e,	/* 왞 */
      0xec999f,	/* 왟 */
      0xec99a0,	/* 왠 */
      0xec99a1,	/* 왡 */
      0xec99a2,	/* 왢 */
      0xec99a3,	/* 왣 */
      0xec99a4,	/* 왤 */
      0xec99a5,	/* 왥 */
      0xec99a6,	/* 왦 */
      0xec99a7,	/* 왧 */
      0xec99a8,	/* 왨 */
      0xec99a9,	/* 왩 */
      0xec99aa,	/* 왪 */
      0xec99ab,	/* 왫 */
      0xec99ac,	/* 왬 */
      0xec99ad,	/* 왭 */
      0xec99ae,	/* 왮 */
      0xec99af,	/* 왯 */
      0xec99b0,	/* 왰 */
      0xec99b1,	/* 왱 */
      0xec99b2,	/* 왲 */
      0xec99b3,	/* 왳 */
      0xec99b4,	/* 왴 */
      0xec99b5,	/* 왵 */
      0xec99b6,	/* 왶 */
      0xec99b7,	/* 왷 */
    },
    {
      0xec99b8,	/* 외 */
      0xec99b9,	/* 왹 */
      0xec99ba,	/* 왺 */
      0xec99bb,	/* 왻 */
      0xec99bc,	/* 왼 */
      0xec99bd,	/* 왽 */
      0xec99be,	/* 왾 */
      0xec99bf,	/* 왿 */
      0xec9a80,	/* 욀 */
      0xec9a81,	/* 욁 */
      0xec9a82,	/* 욂 */
      0xec9a83,	/* 욃 */
      0xec9a84,	/* 욄 */
      0xec9a85,	/* 욅 */
      0xec9a86,	/* 욆 */
      0xec9a87,	/* 욇 */
      0xec9a88,	/* 욈 */
      0xec9a89,	/* 욉 */
      0xec9a8a,	/* 욊 */
      0xec9a8b,	/* 욋 */
      0xec9a8c,	/* 욌 */
      0xec9a8d,	/* 욍 */
      0xec9a8e,	/* 욎 */
      0xec9a8f,	/* 욏 */
      0xec9a90,	/* 욐 */
      0xec9a91,	/* 욑 */
      0xec9a92,	/* 욒 */
      0xec9a93,	/* 욓 */
    },
    {
      0xec9a94,	/* 요 */
      0xec9a95,	/* 욕 */
      0xec9a96,	/* 욖 */
      0xec9a97,	/* 욗 */
      0xec9a98,	/* 욘 */
      0xec9a99,	/* 욙 */
      0xec9a9a,	/* 욚 */
      0xec9a9b,	/* 욛 */
      0xec9a9c,	/* 욜 */
      0xec9a9d,	/* 욝 */
      0xec9a9e,	/* 욞 */
      0xec9a9f,	/* 욟 */
      0xec9aa0,	/* 욠 */
      0xec9aa1,	/* 욡 */
      0xec9aa2,	/* 욢 */
      0xec9aa3,	/* 욣 */
      0xec9aa4,	/* 욤 */
      0xec9aa5,	/* 욥 */
      0xec9aa6,	/* 욦 */
      0xec9aa7,	/* 욧 */
      0xec9aa8,	/* 욨 */
      0xec9aa9,	/* 용 */
      0xec9aaa,	/* 욪 */
      0xec9aab,	/* 욫 */
      0xec9aac,	/* 욬 */
      0xec9aad,	/* 욭 */
      0xec9aae,	/* 욮 */
      0xec9aaf,	/* 욯 */
    },
    {
      0xec9ab0,	/* 우 */
      0xec9ab1,	/* 욱 */
      0xec9ab2,	/* 욲 */
      0xec9ab3,	/* 욳 */
      0xec9ab4,	/* 운 */
      0xec9ab5,	/* 욵 */
      0xec9ab6,	/* 욶 */
      0xec9ab7,	/* 욷 */
      0xec9ab8,	/* 울 */
      0xec9ab9,	/* 욹 */
      0xec9aba,	/* 욺 */
      0xec9abb,	/* 욻 */
      0xec9abc,	/* 욼 */
      0xec9abd,	/* 욽 */
      0xec9abe,	/* 욾 */
      0xec9abf,	/* 욿 */
      0xec9b80,	/* 움 */
      0xec9b81,	/* 웁 */
      0xec9b82,	/* 웂 */
      0xec9b83,	/* 웃 */
      0xec9b84,	/* 웄 */
      0xec9b85,	/* 웅 */
      0xec9b86,	/* 웆 */
      0xec9b87,	/* 웇 */
      0xec9b88,	/* 웈 */
      0xec9b89,	/* 웉 */
      0xec9b8a,	/* 웊 */
      0xec9b8b,	/* 웋 */
    },
    {
      0xec9b8c,	/* 워 */
      0xec9b8d,	/* 웍 */
      0xec9b8e,	/* 웎 */
      0xec9b8f,	/* 웏 */
      0xec9b90,	/* 원 */
      0xec9b91,	/* 웑 */
      0xec9b92,	/* 웒 */
      0xec9b93,	/* 웓 */
      0xec9b94,	/* 월 */
      0xec9b95,	/* 웕 */
      0xec9b96,	/* 웖 */
      0xec9b97,	/* 웗 */
      0xec9b98,	/* 웘 */
      0xec9b99,	/* 웙 */
      0xec9b9a,	/* 웚 */
      0xec9b9b,	/* 웛 */
      0xec9b9c,	/* 웜 */
      0xec9b9d,	/* 웝 */
      0xec9b9e,	/* 웞 */
      0xec9b9f,	/* 웟 */
      0xec9ba0,	/* 웠 */
      0xec9ba1,	/* 웡 */
      0xec9ba2,	/* 웢 */
      0xec9ba3,	/* 웣 */
      0xec9ba4,	/* 웤 */
      0xec9ba5,	/* 웥 */
      0xec9ba6,	/* 웦 */
      0xec9ba7,	/* 웧 */
    },
    {
      0xec9ba8,	/* 웨 */
      0xec9ba9,	/* 웩 */
      0xec9baa,	/* 웪 */
      0xec9bab,	/* 웫 */
      0xec9bac,	/* 웬 */
      0xec9bad,	/* 웭 */
      0xec9bae,	/* 웮 */
      0xec9baf,	/* 웯 */
      0xec9bb0,	/* 웰 */
      0xec9bb1,	/* 웱 */
      0xec9bb2,	/* 웲 */
      0xec9bb3,	/* 웳 */
      0xec9bb4,	/* 웴 */
      0xec9bb5,	/* 웵 */
      0xec9bb6,	/* 웶 */
      0xec9bb7,	/* 웷 */
      0xec9bb8,	/* 웸 */
      0xec9bb9,	/* 웹 */
      0xec9bba,	/* 웺 */
      0xec9bbb,	/* 웻 */
      0xec9bbc,	/* 웼 */
      0xec9bbd,	/* 웽 */
      0xec9bbe,	/* 웾 */
      0xec9bbf,	/* 웿 */
      0xec9c80,	/* 윀 */
      0xec9c81,	/* 윁 */
      0xec9c82,	/* 윂 */
      0xec9c83,	/* 윃 */
    },
    {
      0xec9c84,	/* 위 */
      0xec9c85,	/* 윅 */
      0xec9c86,	/* 윆 */
      0xec9c87,	/* 윇 */
      0xec9c88,	/* 윈 */
      0xec9c89,	/* 윉 */
      0xec9c8a,	/* 윊 */
      0xec9c8b,	/* 윋 */
      0xec9c8c,	/* 윌 */
      0xec9c8d,	/* 윍 */
      0xec9c8e,	/* 윎 */
      0xec9c8f,	/* 윏 */
      0xec9c90,	/* 윐 */
      0xec9c91,	/* 윑 */
      0xec9c92,	/* 윒 */
      0xec9c93,	/* 윓 */
      0xec9c94,	/* 윔 */
      0xec9c95,	/* 윕 */
      0xec9c96,	/* 윖 */
      0xec9c97,	/* 윗 */
      0xec9c98,	/* 윘 */
      0xec9c99,	/* 윙 */
      0xec9c9a,	/* 윚 */
      0xec9c9b,	/* 윛 */
      0xec9c9c,	/* 윜 */
      0xec9c9d,	/* 윝 */
      0xec9c9e,	/* 윞 */
      0xec9c9f,	/* 윟 */
    },
    {
      0xec9ca0,	/* 유 */
      0xec9ca1,	/* 육 */
      0xec9ca2,	/* 윢 */
      0xec9ca3,	/* 윣 */
      0xec9ca4,	/* 윤 */
      0xec9ca5,	/* 윥 */
      0xec9ca6,	/* 윦 */
      0xec9ca7,	/* 윧 */
      0xec9ca8,	/* 율 */
      0xec9ca9,	/* 윩 */
      0xec9caa,	/* 윪 */
      0xec9cab,	/* 윫 */
      0xec9cac,	/* 윬 */
      0xec9cad,	/* 윭 */
      0xec9cae,	/* 윮 */
      0xec9caf,	/* 윯 */
      0xec9cb0,	/* 윰 */
      0xec9cb1,	/* 윱 */
      0xec9cb2,	/* 윲 */
      0xec9cb3,	/* 윳 */
      0xec9cb4,	/* 윴 */
      0xec9cb5,	/* 융 */
      0xec9cb6,	/* 윶 */
      0xec9cb7,	/* 윷 */
      0xec9cb8,	/* 윸 */
      0xec9cb9,	/* 윹 */
      0xec9cba,	/* 윺 */
      0xec9cbb,	/* 윻 */
    },
    {
      0xec9cbc,	/* 으 */
      0xec9cbd,	/* 윽 */
      0xec9cbe,	/* 윾 */
      0xec9cbf,	/* 윿 */
      0xec9d80,	/* 은 */
      0xec9d81,	/* 읁 */
      0xec9d82,	/* 읂 */
      0xec9d83,	/* 읃 */
      0xec9d84,	/* 을 */
      0xec9d85,	/* 읅 */
      0xec9d86,	/* 읆 */
      0xec9d87,	/* 읇 */
      0xec9d88,	/* 읈 */
      0xec9d89,	/* 읉 */
      0xec9d8a,	/* 읊 */
      0xec9d8b,	/* 읋 */
      0xec9d8c,	/* 음 */
      0xec9d8d,	/* 읍 */
      0xec9d8e,	/* 읎 */
      0xec9d8f,	/* 읏 */
      0xec9d90,	/* 읐 */
      0xec9d91,	/* 응 */
      0xec9d92,	/* 읒 */
      0xec9d93,	/* 읓 */
      0xec9d94,	/* 읔 */
      0xec9d95,	/* 읕 */
      0xec9d96,	/* 읖 */
      0xec9d97,	/* 읗 */
    },
    {
      0xec9d98,	/* 의 */
      0xec9d99,	/* 읙 */
      0xec9d9a,	/* 읚 */
      0xec9d9b,	/* 읛 */
      0xec9d9c,	/* 읜 */
      0xec9d9d,	/* 읝 */
      0xec9d9e,	/* 읞 */
      0xec9d9f,	/* 읟 */
      0xec9da0,	/* 읠 */
      0xec9da1,	/* 읡 */
      0xec9da2,	/* 읢 */
      0xec9da3,	/* 읣 */
      0xec9da4,	/* 읤 */
      0xec9da5,	/* 읥 */
      0xec9da6,	/* 읦 */
      0xec9da7,	/* 읧 */
      0xec9da8,	/* 읨 */
      0xec9da9,	/* 읩 */
      0xec9daa,	/* 읪 */
      0xec9dab,	/* 읫 */
      0xec9dac,	/* 읬 */
      0xec9dad,	/* 읭 */
      0xec9dae,	/* 읮 */
      0xec9daf,	/* 읯 */
      0xec9db0,	/* 읰 */
      0xec9db1,	/* 읱 */
      0xec9db2,	/* 읲 */
      0xec9db3,	/* 읳 */
    },
    {
      0xec9db4,	/* 이 */
      0xec9db5,	/* 익 */
      0xec9db6,	/* 읶 */
      0xec9db7,	/* 읷 */
      0xec9db8,	/* 인 */
      0xec9db9,	/* 읹 */
      0xec9dba,	/* 읺 */
      0xec9dbb,	/* 읻 */
      0xec9dbc,	/* 일 */
      0xec9dbd,	/* 읽 */
      0xec9dbe,	/* 읾 */
      0xec9dbf,	/* 읿 */
      0xec9e80,	/* 잀 */
      0xec9e81,	/* 잁 */
      0xec9e82,	/* 잂 */
      0xec9e83,	/* 잃 */
      0xec9e84,	/* 임 */
      0xec9e85,	/* 입 */
      0xec9e86,	/* 잆 */
      0xec9e87,	/* 잇 */
      0xec9e88,	/* 있 */
      0xec9e89,	/* 잉 */
      0xec9e8a,	/* 잊 */
      0xec9e8b,	/* 잋 */
      0xec9e8c,	/* 잌 */
      0xec9e8d,	/* 잍 */
      0xec9e8e,	/* 잎 */
      0xec9e8f,	/* 잏 */
    },
  },
  {
    {
      0xec9e90,	/* 자 */
      0xec9e91,	/* 작 */
      0xec9e92,	/* 잒 */
      0xec9e93,	/* 잓 */
      0xec9e94,	/* 잔 */
      0xec9e95,	/* 잕 */
      0xec9e96,	/* 잖 */
      0xec9e97,	/* 잗 */
      0xec9e98,	/* 잘 */
      0xec9e99,	/* 잙 */
      0xec9e9a,	/* 잚 */
      0xec9e9b,	/* 잛 */
      0xec9e9c,	/* 잜 */
      0xec9e9d,	/* 잝 */
      0xec9e9e,	/* 잞 */
      0xec9e9f,	/* 잟 */
      0xec9ea0,	/* 잠 */
      0xec9ea1,	/* 잡 */
      0xec9ea2,	/* 잢 */
      0xec9ea3,	/* 잣 */
      0xec9ea4,	/* 잤 */
      0xec9ea5,	/* 장 */
      0xec9ea6,	/* 잦 */
      0xec9ea7,	/* 잧 */
      0xec9ea8,	/* 잨 */
      0xec9ea9,	/* 잩 */
      0xec9eaa,	/* 잪 */
      0xec9eab,	/* 잫 */
    },
    {
      0xec9eac,	/* 재 */
      0xec9ead,	/* 잭 */
      0xec9eae,	/* 잮 */
      0xec9eaf,	/* 잯 */
      0xec9eb0,	/* 잰 */
      0xec9eb1,	/* 잱 */
      0xec9eb2,	/* 잲 */
      0xec9eb3,	/* 잳 */
      0xec9eb4,	/* 잴 */
      0xec9eb5,	/* 잵 */
      0xec9eb6,	/* 잶 */
      0xec9eb7,	/* 잷 */
      0xec9eb8,	/* 잸 */
      0xec9eb9,	/* 잹 */
      0xec9eba,	/* 잺 */
      0xec9ebb,	/* 잻 */
      0xec9ebc,	/* 잼 */
      0xec9ebd,	/* 잽 */
      0xec9ebe,	/* 잾 */
      0xec9ebf,	/* 잿 */
      0xec9f80,	/* 쟀 */
      0xec9f81,	/* 쟁 */
      0xec9f82,	/* 쟂 */
      0xec9f83,	/* 쟃 */
      0xec9f84,	/* 쟄 */
      0xec9f85,	/* 쟅 */
      0xec9f86,	/* 쟆 */
      0xec9f87,	/* 쟇 */
    },
    {
      0xec9f88,	/* 쟈 */
      0xec9f89,	/* 쟉 */
      0xec9f8a,	/* 쟊 */
      0xec9f8b,	/* 쟋 */
      0xec9f8c,	/* 쟌 */
      0xec9f8d,	/* 쟍 */
      0xec9f8e,	/* 쟎 */
      0xec9f8f,	/* 쟏 */
      0xec9f90,	/* 쟐 */
      0xec9f91,	/* 쟑 */
      0xec9f92,	/* 쟒 */
      0xec9f93,	/* 쟓 */
      0xec9f94,	/* 쟔 */
      0xec9f95,	/* 쟕 */
      0xec9f96,	/* 쟖 */
      0xec9f97,	/* 쟗 */
      0xec9f98,	/* 쟘 */
      0xec9f99,	/* 쟙 */
      0xec9f9a,	/* 쟚 */
      0xec9f9b,	/* 쟛 */
      0xec9f9c,	/* 쟜 */
      0xec9f9d,	/* 쟝 */
      0xec9f9e,	/* 쟞 */
      0xec9f9f,	/* 쟟 */
      0xec9fa0,	/* 쟠 */
      0xec9fa1,	/* 쟡 */
      0xec9fa2,	/* 쟢 */
      0xec9fa3,	/* 쟣 */
    },
    {
      0xec9fa4,	/* 쟤 */
      0xec9fa5,	/* 쟥 */
      0xec9fa6,	/* 쟦 */
      0xec9fa7,	/* 쟧 */
      0xec9fa8,	/* 쟨 */
      0xec9fa9,	/* 쟩 */
      0xec9faa,	/* 쟪 */
      0xec9fab,	/* 쟫 */
      0xec9fac,	/* 쟬 */
      0xec9fad,	/* 쟭 */
      0xec9fae,	/* 쟮 */
      0xec9faf,	/* 쟯 */
      0xec9fb0,	/* 쟰 */
      0xec9fb1,	/* 쟱 */
      0xec9fb2,	/* 쟲 */
      0xec9fb3,	/* 쟳 */
      0xec9fb4,	/* 쟴 */
      0xec9fb5,	/* 쟵 */
      0xec9fb6,	/* 쟶 */
      0xec9fb7,	/* 쟷 */
      0xec9fb8,	/* 쟸 */
      0xec9fb9,	/* 쟹 */
      0xec9fba,	/* 쟺 */
      0xec9fbb,	/* 쟻 */
      0xec9fbc,	/* 쟼 */
      0xec9fbd,	/* 쟽 */
      0xec9fbe,	/* 쟾 */
      0xec9fbf,	/* 쟿 */
    },
    {
      0xeca080,	/* 저 */
      0xeca081,	/* 적 */
      0xeca082,	/* 젂 */
      0xeca083,	/* 젃 */
      0xeca084,	/* 전 */
      0xeca085,	/* 젅 */
      0xeca086,	/* 젆 */
      0xeca087,	/* 젇 */
      0xeca088,	/* 절 */
      0xeca089,	/* 젉 */
      0xeca08a,	/* 젊 */
      0xeca08b,	/* 젋 */
      0xeca08c,	/* 젌 */
      0xeca08d,	/* 젍 */
      0xeca08e,	/* 젎 */
      0xeca08f,	/* 젏 */
      0xeca090,	/* 점 */
      0xeca091,	/* 접 */
      0xeca092,	/* 젒 */
      0xeca093,	/* 젓 */
      0xeca094,	/* 젔 */
      0xeca095,	/* 정 */
      0xeca096,	/* 젖 */
      0xeca097,	/* 젗 */
      0xeca098,	/* 젘 */
      0xeca099,	/* 젙 */
      0xeca09a,	/* 젚 */
      0xeca09b,	/* 젛 */
    },
    {
      0xeca09c,	/* 제 */
      0xeca09d,	/* 젝 */
      0xeca09e,	/* 젞 */
      0xeca09f,	/* 젟 */
      0xeca0a0,	/* 젠 */
      0xeca0a1,	/* 젡 */
      0xeca0a2,	/* 젢 */
      0xeca0a3,	/* 젣 */
      0xeca0a4,	/* 젤 */
      0xeca0a5,	/* 젥 */
      0xeca0a6,	/* 젦 */
      0xeca0a7,	/* 젧 */
      0xeca0a8,	/* 젨 */
      0xeca0a9,	/* 젩 */
      0xeca0aa,	/* 젪 */
      0xeca0ab,	/* 젫 */
      0xeca0ac,	/* 젬 */
      0xeca0ad,	/* 젭 */
      0xeca0ae,	/* 젮 */
      0xeca0af,	/* 젯 */
      0xeca0b0,	/* 젰 */
      0xeca0b1,	/* 젱 */
      0xeca0b2,	/* 젲 */
      0xeca0b3,	/* 젳 */
      0xeca0b4,	/* 젴 */
      0xeca0b5,	/* 젵 */
      0xeca0b6,	/* 젶 */
      0xeca0b7,	/* 젷 */
    },
    {
      0xeca0b8,	/* 져 */
      0xeca0b9,	/* 젹 */
      0xeca0ba,	/* 젺 */
      0xeca0bb,	/* 젻 */
      0xeca0bc,	/* 젼 */
      0xeca0bd,	/* 젽 */
      0xeca0be,	/* 젾 */
      0xeca0bf,	/* 젿 */
      0xeca180,	/* 졀 */
      0xeca181,	/* 졁 */
      0xeca182,	/* 졂 */
      0xeca183,	/* 졃 */
      0xeca184,	/* 졄 */
      0xeca185,	/* 졅 */
      0xeca186,	/* 졆 */
      0xeca187,	/* 졇 */
      0xeca188,	/* 졈 */
      0xeca189,	/* 졉 */
      0xeca18a,	/* 졊 */
      0xeca18b,	/* 졋 */
      0xeca18c,	/* 졌 */
      0xeca18d,	/* 졍 */
      0xeca18e,	/* 졎 */
      0xeca18f,	/* 졏 */
      0xeca190,	/* 졐 */
      0xeca191,	/* 졑 */
      0xeca192,	/* 졒 */
      0xeca193,	/* 졓 */
    },
    {
      0xeca194,	/* 졔 */
      0xeca195,	/* 졕 */
      0xeca196,	/* 졖 */
      0xeca197,	/* 졗 */
      0xeca198,	/* 졘 */
      0xeca199,	/* 졙 */
      0xeca19a,	/* 졚 */
      0xeca19b,	/* 졛 */
      0xeca19c,	/* 졜 */
      0xeca19d,	/* 졝 */
      0xeca19e,	/* 졞 */
      0xeca19f,	/* 졟 */
      0xeca1a0,	/* 졠 */
      0xeca1a1,	/* 졡 */
      0xeca1a2,	/* 졢 */
      0xeca1a3,	/* 졣 */
      0xeca1a4,	/* 졤 */
      0xeca1a5,	/* 졥 */
      0xeca1a6,	/* 졦 */
      0xeca1a7,	/* 졧 */
      0xeca1a8,	/* 졨 */
      0xeca1a9,	/* 졩 */
      0xeca1aa,	/* 졪 */
      0xeca1ab,	/* 졫 */
      0xeca1ac,	/* 졬 */
      0xeca1ad,	/* 졭 */
      0xeca1ae,	/* 졮 */
      0xeca1af,	/* 졯 */
    },
    {
      0xeca1b0,	/* 조 */
      0xeca1b1,	/* 족 */
      0xeca1b2,	/* 졲 */
      0xeca1b3,	/* 졳 */
      0xeca1b4,	/* 존 */
      0xeca1b5,	/* 졵 */
      0xeca1b6,	/* 졶 */
      0xeca1b7,	/* 졷 */
      0xeca1b8,	/* 졸 */
      0xeca1b9,	/* 졹 */
      0xeca1ba,	/* 졺 */
      0xeca1bb,	/* 졻 */
      0xeca1bc,	/* 졼 */
      0xeca1bd,	/* 졽 */
      0xeca1be,	/* 졾 */
      0xeca1bf,	/* 졿 */
      0xeca280,	/* 좀 */
      0xeca281,	/* 좁 */
      0xeca282,	/* 좂 */
      0xeca283,	/* 좃 */
      0xeca284,	/* 좄 */
      0xeca285,	/* 종 */
      0xeca286,	/* 좆 */
      0xeca287,	/* 좇 */
      0xeca288,	/* 좈 */
      0xeca289,	/* 좉 */
      0xeca28a,	/* 좊 */
      0xeca28b,	/* 좋 */
    },
    {
      0xeca28c,	/* 좌 */
      0xeca28d,	/* 좍 */
      0xeca28e,	/* 좎 */
      0xeca28f,	/* 좏 */
      0xeca290,	/* 좐 */
      0xeca291,	/* 좑 */
      0xeca292,	/* 좒 */
      0xeca293,	/* 좓 */
      0xeca294,	/* 좔 */
      0xeca295,	/* 좕 */
      0xeca296,	/* 좖 */
      0xeca297,	/* 좗 */
      0xeca298,	/* 좘 */
      0xeca299,	/* 좙 */
      0xeca29a,	/* 좚 */
      0xeca29b,	/* 좛 */
      0xeca29c,	/* 좜 */
      0xeca29d,	/* 좝 */
      0xeca29e,	/* 좞 */
      0xeca29f,	/* 좟 */
      0xeca2a0,	/* 좠 */
      0xeca2a1,	/* 좡 */
      0xeca2a2,	/* 좢 */
      0xeca2a3,	/* 좣 */
      0xeca2a4,	/* 좤 */
      0xeca2a5,	/* 좥 */
      0xeca2a6,	/* 좦 */
      0xeca2a7,	/* 좧 */
    },
    {
      0xeca2a8,	/* 좨 */
      0xeca2a9,	/* 좩 */
      0xeca2aa,	/* 좪 */
      0xeca2ab,	/* 좫 */
      0xeca2ac,	/* 좬 */
      0xeca2ad,	/* 좭 */
      0xeca2ae,	/* 좮 */
      0xeca2af,	/* 좯 */
      0xeca2b0,	/* 좰 */
      0xeca2b1,	/* 좱 */
      0xeca2b2,	/* 좲 */
      0xeca2b3,	/* 좳 */
      0xeca2b4,	/* 좴 */
      0xeca2b5,	/* 좵 */
      0xeca2b6,	/* 좶 */
      0xeca2b7,	/* 좷 */
      0xeca2b8,	/* 좸 */
      0xeca2b9,	/* 좹 */
      0xeca2ba,	/* 좺 */
      0xeca2bb,	/* 좻 */
      0xeca2bc,	/* 좼 */
      0xeca2bd,	/* 좽 */
      0xeca2be,	/* 좾 */
      0xeca2bf,	/* 좿 */
      0xeca380,	/* 죀 */
      0xeca381,	/* 죁 */
      0xeca382,	/* 죂 */
      0xeca383,	/* 죃 */
    },
    {
      0xeca384,	/* 죄 */
      0xeca385,	/* 죅 */
      0xeca386,	/* 죆 */
      0xeca387,	/* 죇 */
      0xeca388,	/* 죈 */
      0xeca389,	/* 죉 */
      0xeca38a,	/* 죊 */
      0xeca38b,	/* 죋 */
      0xeca38c,	/* 죌 */
      0xeca38d,	/* 죍 */
      0xeca38e,	/* 죎 */
      0xeca38f,	/* 죏 */
      0xeca390,	/* 죐 */
      0xeca391,	/* 죑 */
      0xeca392,	/* 죒 */
      0xeca393,	/* 죓 */
      0xeca394,	/* 죔 */
      0xeca395,	/* 죕 */
      0xeca396,	/* 죖 */
      0xeca397,	/* 죗 */
      0xeca398,	/* 죘 */
      0xeca399,	/* 죙 */
      0xeca39a,	/* 죚 */
      0xeca39b,	/* 죛 */
      0xeca39c,	/* 죜 */
      0xeca39d,	/* 죝 */
      0xeca39e,	/* 죞 */
      0xeca39f,	/* 죟 */
    },
    {
      0xeca3a0,	/* 죠 */
      0xeca3a1,	/* 죡 */
      0xeca3a2,	/* 죢 */
      0xeca3a3,	/* 죣 */
      0xeca3a4,	/* 죤 */
      0xeca3a5,	/* 죥 */
      0xeca3a6,	/* 죦 */
      0xeca3a7,	/* 죧 */
      0xeca3a8,	/* 죨 */
      0xeca3a9,	/* 죩 */
      0xeca3aa,	/* 죪 */
      0xeca3ab,	/* 죫 */
      0xeca3ac,	/* 죬 */
      0xeca3ad,	/* 죭 */
      0xeca3ae,	/* 죮 */
      0xeca3af,	/* 죯 */
      0xeca3b0,	/* 죰 */
      0xeca3b1,	/* 죱 */
      0xeca3b2,	/* 죲 */
      0xeca3b3,	/* 죳 */
      0xeca3b4,	/* 죴 */
      0xeca3b5,	/* 죵 */
      0xeca3b6,	/* 죶 */
      0xeca3b7,	/* 죷 */
      0xeca3b8,	/* 죸 */
      0xeca3b9,	/* 죹 */
      0xeca3ba,	/* 죺 */
      0xeca3bb,	/* 죻 */
    },
    {
      0xeca3bc,	/* 주 */
      0xeca3bd,	/* 죽 */
      0xeca3be,	/* 죾 */
      0xeca3bf,	/* 죿 */
      0xeca480,	/* 준 */
      0xeca481,	/* 줁 */
      0xeca482,	/* 줂 */
      0xeca483,	/* 줃 */
      0xeca484,	/* 줄 */
      0xeca485,	/* 줅 */
      0xeca486,	/* 줆 */
      0xeca487,	/* 줇 */
      0xeca488,	/* 줈 */
      0xeca489,	/* 줉 */
      0xeca48a,	/* 줊 */
      0xeca48b,	/* 줋 */
      0xeca48c,	/* 줌 */
      0xeca48d,	/* 줍 */
      0xeca48e,	/* 줎 */
      0xeca48f,	/* 줏 */
      0xeca490,	/* 줐 */
      0xeca491,	/* 중 */
      0xeca492,	/* 줒 */
      0xeca493,	/* 줓 */
      0xeca494,	/* 줔 */
      0xeca495,	/* 줕 */
      0xeca496,	/* 줖 */
      0xeca497,	/* 줗 */
    },
    {
      0xeca498,	/* 줘 */
      0xeca499,	/* 줙 */
      0xeca49a,	/* 줚 */
      0xeca49b,	/* 줛 */
      0xeca49c,	/* 줜 */
      0xeca49d,	/* 줝 */
      0xeca49e,	/* 줞 */
      0xeca49f,	/* 줟 */
      0xeca4a0,	/* 줠 */
      0xeca4a1,	/* 줡 */
      0xeca4a2,	/* 줢 */
      0xeca4a3,	/* 줣 */
      0xeca4a4,	/* 줤 */
      0xeca4a5,	/* 줥 */
      0xeca4a6,	/* 줦 */
      0xeca4a7,	/* 줧 */
      0xeca4a8,	/* 줨 */
      0xeca4a9,	/* 줩 */
      0xeca4aa,	/* 줪 */
      0xeca4ab,	/* 줫 */
      0xeca4ac,	/* 줬 */
      0xeca4ad,	/* 줭 */
      0xeca4ae,	/* 줮 */
      0xeca4af,	/* 줯 */
      0xeca4b0,	/* 줰 */
      0xeca4b1,	/* 줱 */
      0xeca4b2,	/* 줲 */
      0xeca4b3,	/* 줳 */
    },
    {
      0xeca4b4,	/* 줴 */
      0xeca4b5,	/* 줵 */
      0xeca4b6,	/* 줶 */
      0xeca4b7,	/* 줷 */
      0xeca4b8,	/* 줸 */
      0xeca4b9,	/* 줹 */
      0xeca4ba,	/* 줺 */
      0xeca4bb,	/* 줻 */
      0xeca4bc,	/* 줼 */
      0xeca4bd,	/* 줽 */
      0xeca4be,	/* 줾 */
      0xeca4bf,	/* 줿 */
      0xeca580,	/* 쥀 */
      0xeca581,	/* 쥁 */
      0xeca582,	/* 쥂 */
      0xeca583,	/* 쥃 */
      0xeca584,	/* 쥄 */
      0xeca585,	/* 쥅 */
      0xeca586,	/* 쥆 */
      0xeca587,	/* 쥇 */
      0xeca588,	/* 쥈 */
      0xeca589,	/* 쥉 */
      0xeca58a,	/* 쥊 */
      0xeca58b,	/* 쥋 */
      0xeca58c,	/* 쥌 */
      0xeca58d,	/* 쥍 */
      0xeca58e,	/* 쥎 */
      0xeca58f,	/* 쥏 */
    },
    {
      0xeca590,	/* 쥐 */
      0xeca591,	/* 쥑 */
      0xeca592,	/* 쥒 */
      0xeca593,	/* 쥓 */
      0xeca594,	/* 쥔 */
      0xeca595,	/* 쥕 */
      0xeca596,	/* 쥖 */
      0xeca597,	/* 쥗 */
      0xeca598,	/* 쥘 */
      0xeca599,	/* 쥙 */
      0xeca59a,	/* 쥚 */
      0xeca59b,	/* 쥛 */
      0xeca59c,	/* 쥜 */
      0xeca59d,	/* 쥝 */
      0xeca59e,	/* 쥞 */
      0xeca59f,	/* 쥟 */
      0xeca5a0,	/* 쥠 */
      0xeca5a1,	/* 쥡 */
      0xeca5a2,	/* 쥢 */
      0xeca5a3,	/* 쥣 */
      0xeca5a4,	/* 쥤 */
      0xeca5a5,	/* 쥥 */
      0xeca5a6,	/* 쥦 */
      0xeca5a7,	/* 쥧 */
      0xeca5a8,	/* 쥨 */
      0xeca5a9,	/* 쥩 */
      0xeca5aa,	/* 쥪 */
      0xeca5ab,	/* 쥫 */
    },
    {
      0xeca5ac,	/* 쥬 */
      0xeca5ad,	/* 쥭 */
      0xeca5ae,	/* 쥮 */
      0xeca5af,	/* 쥯 */
      0xeca5b0,	/* 쥰 */
      0xeca5b1,	/* 쥱 */
      0xeca5b2,	/* 쥲 */
      0xeca5b3,	/* 쥳 */
      0xeca5b4,	/* 쥴 */
      0xeca5b5,	/* 쥵 */
      0xeca5b6,	/* 쥶 */
      0xeca5b7,	/* 쥷 */
      0xeca5b8,	/* 쥸 */
      0xeca5b9,	/* 쥹 */
      0xeca5ba,	/* 쥺 */
      0xeca5bb,	/* 쥻 */
      0xeca5bc,	/* 쥼 */
      0xeca5bd,	/* 쥽 */
      0xeca5be,	/* 쥾 */
      0xeca5bf,	/* 쥿 */
      0xeca680,	/* 즀 */
      0xeca681,	/* 즁 */
      0xeca682,	/* 즂 */
      0xeca683,	/* 즃 */
      0xeca684,	/* 즄 */
      0xeca685,	/* 즅 */
      0xeca686,	/* 즆 */
      0xeca687,	/* 즇 */
    },
    {
      0xeca688,	/* 즈 */
      0xeca689,	/* 즉 */
      0xeca68a,	/* 즊 */
      0xeca68b,	/* 즋 */
      0xeca68c,	/* 즌 */
      0xeca68d,	/* 즍 */
      0xeca68e,	/* 즎 */
      0xeca68f,	/* 즏 */
      0xeca690,	/* 즐 */
      0xeca691,	/* 즑 */
      0xeca692,	/* 즒 */
      0xeca693,	/* 즓 */
      0xeca694,	/* 즔 */
      0xeca695,	/* 즕 */
      0xeca696,	/* 즖 */
      0xeca697,	/* 즗 */
      0xeca698,	/* 즘 */
      0xeca699,	/* 즙 */
      0xeca69a,	/* 즚 */
      0xeca69b,	/* 즛 */
      0xeca69c,	/* 즜 */
      0xeca69d,	/* 증 */
      0xeca69e,	/* 즞 */
      0xeca69f,	/* 즟 */
      0xeca6a0,	/* 즠 */
      0xeca6a1,	/* 즡 */
      0xeca6a2,	/* 즢 */
      0xeca6a3,	/* 즣 */
    },
    {
      0xeca6a4,	/* 즤 */
      0xeca6a5,	/* 즥 */
      0xeca6a6,	/* 즦 */
      0xeca6a7,	/* 즧 */
      0xeca6a8,	/* 즨 */
      0xeca6a9,	/* 즩 */
      0xeca6aa,	/* 즪 */
      0xeca6ab,	/* 즫 */
      0xeca6ac,	/* 즬 */
      0xeca6ad,	/* 즭 */
      0xeca6ae,	/* 즮 */
      0xeca6af,	/* 즯 */
      0xeca6b0,	/* 즰 */
      0xeca6b1,	/* 즱 */
      0xeca6b2,	/* 즲 */
      0xeca6b3,	/* 즳 */
      0xeca6b4,	/* 즴 */
      0xeca6b5,	/* 즵 */
      0xeca6b6,	/* 즶 */
      0xeca6b7,	/* 즷 */
      0xeca6b8,	/* 즸 */
      0xeca6b9,	/* 즹 */
      0xeca6ba,	/* 즺 */
      0xeca6bb,	/* 즻 */
      0xeca6bc,	/* 즼 */
      0xeca6bd,	/* 즽 */
      0xeca6be,	/* 즾 */
      0xeca6bf,	/* 즿 */
    },
    {
      0xeca780,	/* 지 */
      0xeca781,	/* 직 */
      0xeca782,	/* 짂 */
      0xeca783,	/* 짃 */
      0xeca784,	/* 진 */
      0xeca785,	/* 짅 */
      0xeca786,	/* 짆 */
      0xeca787,	/* 짇 */
      0xeca788,	/* 질 */
      0xeca789,	/* 짉 */
      0xeca78a,	/* 짊 */
      0xeca78b,	/* 짋 */
      0xeca78c,	/* 짌 */
      0xeca78d,	/* 짍 */
      0xeca78e,	/* 짎 */
      0xeca78f,	/* 짏 */
      0xeca790,	/* 짐 */
      0xeca791,	/* 집 */
      0xeca792,	/* 짒 */
      0xeca793,	/* 짓 */
      0xeca794,	/* 짔 */
      0xeca795,	/* 징 */
      0xeca796,	/* 짖 */
      0xeca797,	/* 짗 */
      0xeca798,	/* 짘 */
      0xeca799,	/* 짙 */
      0xeca79a,	/* 짚 */
      0xeca79b,	/* 짛 */
    },
  },
  {
    {
      0xeca79c,	/* 짜 */
      0xeca79d,	/* 짝 */
      0xeca79e,	/* 짞 */
      0xeca79f,	/* 짟 */
      0xeca7a0,	/* 짠 */
      0xeca7a1,	/* 짡 */
      0xeca7a2,	/* 짢 */
      0xeca7a3,	/* 짣 */
      0xeca7a4,	/* 짤 */
      0xeca7a5,	/* 짥 */
      0xeca7a6,	/* 짦 */
      0xeca7a7,	/* 짧 */
      0xeca7a8,	/* 짨 */
      0xeca7a9,	/* 짩 */
      0xeca7aa,	/* 짪 */
      0xeca7ab,	/* 짫 */
      0xeca7ac,	/* 짬 */
      0xeca7ad,	/* 짭 */
      0xeca7ae,	/* 짮 */
      0xeca7af,	/* 짯 */
      0xeca7b0,	/* 짰 */
      0xeca7b1,	/* 짱 */
      0xeca7b2,	/* 짲 */
      0xeca7b3,	/* 짳 */
      0xeca7b4,	/* 짴 */
      0xeca7b5,	/* 짵 */
      0xeca7b6,	/* 짶 */
      0xeca7b7,	/* 짷 */
    },
    {
      0xeca7b8,	/* 째 */
      0xeca7b9,	/* 짹 */
      0xeca7ba,	/* 짺 */
      0xeca7bb,	/* 짻 */
      0xeca7bc,	/* 짼 */
      0xeca7bd,	/* 짽 */
      0xeca7be,	/* 짾 */
      0xeca7bf,	/* 짿 */
      0xeca880,	/* 쨀 */
      0xeca881,	/* 쨁 */
      0xeca882,	/* 쨂 */
      0xeca883,	/* 쨃 */
      0xeca884,	/* 쨄 */
      0xeca885,	/* 쨅 */
      0xeca886,	/* 쨆 */
      0xeca887,	/* 쨇 */
      0xeca888,	/* 쨈 */
      0xeca889,	/* 쨉 */
      0xeca88a,	/* 쨊 */
      0xeca88b,	/* 쨋 */
      0xeca88c,	/* 쨌 */
      0xeca88d,	/* 쨍 */
      0xeca88e,	/* 쨎 */
      0xeca88f,	/* 쨏 */
      0xeca890,	/* 쨐 */
      0xeca891,	/* 쨑 */
      0xeca892,	/* 쨒 */
      0xeca893,	/* 쨓 */
    },
    {
      0xeca894,	/* 쨔 */
      0xeca895,	/* 쨕 */
      0xeca896,	/* 쨖 */
      0xeca897,	/* 쨗 */
      0xeca898,	/* 쨘 */
      0xeca899,	/* 쨙 */
      0xeca89a,	/* 쨚 */
      0xeca89b,	/* 쨛 */
      0xeca89c,	/* 쨜 */
      0xeca89d,	/* 쨝 */
      0xeca89e,	/* 쨞 */
      0xeca89f,	/* 쨟 */
      0xeca8a0,	/* 쨠 */
      0xeca8a1,	/* 쨡 */
      0xeca8a2,	/* 쨢 */
      0xeca8a3,	/* 쨣 */
      0xeca8a4,	/* 쨤 */
      0xeca8a5,	/* 쨥 */
      0xeca8a6,	/* 쨦 */
      0xeca8a7,	/* 쨧 */
      0xeca8a8,	/* 쨨 */
      0xeca8a9,	/* 쨩 */
      0xeca8aa,	/* 쨪 */
      0xeca8ab,	/* 쨫 */
      0xeca8ac,	/* 쨬 */
      0xeca8ad,	/* 쨭 */
      0xeca8ae,	/* 쨮 */
      0xeca8af,	/* 쨯 */
    },
    {
      0xeca8b0,	/* 쨰 */
      0xeca8b1,	/* 쨱 */
      0xeca8b2,	/* 쨲 */
      0xeca8b3,	/* 쨳 */
      0xeca8b4,	/* 쨴 */
      0xeca8b5,	/* 쨵 */
      0xeca8b6,	/* 쨶 */
      0xeca8b7,	/* 쨷 */
      0xeca8b8,	/* 쨸 */
      0xeca8b9,	/* 쨹 */
      0xeca8ba,	/* 쨺 */
      0xeca8bb,	/* 쨻 */
      0xeca8bc,	/* 쨼 */
      0xeca8bd,	/* 쨽 */
      0xeca8be,	/* 쨾 */
      0xeca8bf,	/* 쨿 */
      0xeca980,	/* 쩀 */
      0xeca981,	/* 쩁 */
      0xeca982,	/* 쩂 */
      0xeca983,	/* 쩃 */
      0xeca984,	/* 쩄 */
      0xeca985,	/* 쩅 */
      0xeca986,	/* 쩆 */
      0xeca987,	/* 쩇 */
      0xeca988,	/* 쩈 */
      0xeca989,	/* 쩉 */
      0xeca98a,	/* 쩊 */
      0xeca98b,	/* 쩋 */
    },
    {
      0xeca98c,	/* 쩌 */
      0xeca98d,	/* 쩍 */
      0xeca98e,	/* 쩎 */
      0xeca98f,	/* 쩏 */
      0xeca990,	/* 쩐 */
      0xeca991,	/* 쩑 */
      0xeca992,	/* 쩒 */
      0xeca993,	/* 쩓 */
      0xeca994,	/* 쩔 */
      0xeca995,	/* 쩕 */
      0xeca996,	/* 쩖 */
      0xeca997,	/* 쩗 */
      0xeca998,	/* 쩘 */
      0xeca999,	/* 쩙 */
      0xeca99a,	/* 쩚 */
      0xeca99b,	/* 쩛 */
      0xeca99c,	/* 쩜 */
      0xeca99d,	/* 쩝 */
      0xeca99e,	/* 쩞 */
      0xeca99f,	/* 쩟 */
      0xeca9a0,	/* 쩠 */
      0xeca9a1,	/* 쩡 */
      0xeca9a2,	/* 쩢 */
      0xeca9a3,	/* 쩣 */
      0xeca9a4,	/* 쩤 */
      0xeca9a5,	/* 쩥 */
      0xeca9a6,	/* 쩦 */
      0xeca9a7,	/* 쩧 */
    },
    {
      0xeca9a8,	/* 쩨 */
      0xeca9a9,	/* 쩩 */
      0xeca9aa,	/* 쩪 */
      0xeca9ab,	/* 쩫 */
      0xeca9ac,	/* 쩬 */
      0xeca9ad,	/* 쩭 */
      0xeca9ae,	/* 쩮 */
      0xeca9af,	/* 쩯 */
      0xeca9b0,	/* 쩰 */
      0xeca9b1,	/* 쩱 */
      0xeca9b2,	/* 쩲 */
      0xeca9b3,	/* 쩳 */
      0xeca9b4,	/* 쩴 */
      0xeca9b5,	/* 쩵 */
      0xeca9b6,	/* 쩶 */
      0xeca9b7,	/* 쩷 */
      0xeca9b8,	/* 쩸 */
      0xeca9b9,	/* 쩹 */
      0xeca9ba,	/* 쩺 */
      0xeca9bb,	/* 쩻 */
      0xeca9bc,	/* 쩼 */
      0xeca9bd,	/* 쩽 */
      0xeca9be,	/* 쩾 */
      0xeca9bf,	/* 쩿 */
      0xecaa80,	/* 쪀 */
      0xecaa81,	/* 쪁 */
      0xecaa82,	/* 쪂 */
      0xecaa83,	/* 쪃 */
    },
    {
      0xecaa84,	/* 쪄 */
      0xecaa85,	/* 쪅 */
      0xecaa86,	/* 쪆 */
      0xecaa87,	/* 쪇 */
      0xecaa88,	/* 쪈 */
      0xecaa89,	/* 쪉 */
      0xecaa8a,	/* 쪊 */
      0xecaa8b,	/* 쪋 */
      0xecaa8c,	/* 쪌 */
      0xecaa8d,	/* 쪍 */
      0xecaa8e,	/* 쪎 */
      0xecaa8f,	/* 쪏 */
      0xecaa90,	/* 쪐 */
      0xecaa91,	/* 쪑 */
      0xecaa92,	/* 쪒 */
      0xecaa93,	/* 쪓 */
      0xecaa94,	/* 쪔 */
      0xecaa95,	/* 쪕 */
      0xecaa96,	/* 쪖 */
      0xecaa97,	/* 쪗 */
      0xecaa98,	/* 쪘 */
      0xecaa99,	/* 쪙 */
      0xecaa9a,	/* 쪚 */
      0xecaa9b,	/* 쪛 */
      0xecaa9c,	/* 쪜 */
      0xecaa9d,	/* 쪝 */
      0xecaa9e,	/* 쪞 */
      0xecaa9f,	/* 쪟 */
    },
    {
      0xecaaa0,	/* 쪠 */
      0xecaaa1,	/* 쪡 */
      0xecaaa2,	/* 쪢 */
      0xecaaa3,	/* 쪣 */
      0xecaaa4,	/* 쪤 */
      0xecaaa5,	/* 쪥 */
      0xecaaa6,	/* 쪦 */
      0xecaaa7,	/* 쪧 */
      0xecaaa8,	/* 쪨 */
      0xecaaa9,	/* 쪩 */
      0xecaaaa,	/* 쪪 */
      0xecaaab,	/* 쪫 */
      0xecaaac,	/* 쪬 */
      0xecaaad,	/* 쪭 */
      0xecaaae,	/* 쪮 */
      0xecaaaf,	/* 쪯 */
      0xecaab0,	/* 쪰 */
      0xecaab1,	/* 쪱 */
      0xecaab2,	/* 쪲 */
      0xecaab3,	/* 쪳 */
      0xecaab4,	/* 쪴 */
      0xecaab5,	/* 쪵 */
      0xecaab6,	/* 쪶 */
      0xecaab7,	/* 쪷 */
      0xecaab8,	/* 쪸 */
      0xecaab9,	/* 쪹 */
      0xecaaba,	/* 쪺 */
      0xecaabb,	/* 쪻 */
    },
    {
      0xecaabc,	/* 쪼 */
      0xecaabd,	/* 쪽 */
      0xecaabe,	/* 쪾 */
      0xecaabf,	/* 쪿 */
      0xecab80,	/* 쫀 */
      0xecab81,	/* 쫁 */
      0xecab82,	/* 쫂 */
      0xecab83,	/* 쫃 */
      0xecab84,	/* 쫄 */
      0xecab85,	/* 쫅 */
      0xecab86,	/* 쫆 */
      0xecab87,	/* 쫇 */
      0xecab88,	/* 쫈 */
      0xecab89,	/* 쫉 */
      0xecab8a,	/* 쫊 */
      0xecab8b,	/* 쫋 */
      0xecab8c,	/* 쫌 */
      0xecab8d,	/* 쫍 */
      0xecab8e,	/* 쫎 */
      0xecab8f,	/* 쫏 */
      0xecab90,	/* 쫐 */
      0xecab91,	/* 쫑 */
      0xecab92,	/* 쫒 */
      0xecab93,	/* 쫓 */
      0xecab94,	/* 쫔 */
      0xecab95,	/* 쫕 */
      0xecab96,	/* 쫖 */
      0xecab97,	/* 쫗 */
    },
    {
      0xecab98,	/* 쫘 */
      0xecab99,	/* 쫙 */
      0xecab9a,	/* 쫚 */
      0xecab9b,	/* 쫛 */
      0xecab9c,	/* 쫜 */
      0xecab9d,	/* 쫝 */
      0xecab9e,	/* 쫞 */
      0xecab9f,	/* 쫟 */
      0xecaba0,	/* 쫠 */
      0xecaba1,	/* 쫡 */
      0xecaba2,	/* 쫢 */
      0xecaba3,	/* 쫣 */
      0xecaba4,	/* 쫤 */
      0xecaba5,	/* 쫥 */
      0xecaba6,	/* 쫦 */
      0xecaba7,	/* 쫧 */
      0xecaba8,	/* 쫨 */
      0xecaba9,	/* 쫩 */
      0xecabaa,	/* 쫪 */
      0xecabab,	/* 쫫 */
      0xecabac,	/* 쫬 */
      0xecabad,	/* 쫭 */
      0xecabae,	/* 쫮 */
      0xecabaf,	/* 쫯 */
      0xecabb0,	/* 쫰 */
      0xecabb1,	/* 쫱 */
      0xecabb2,	/* 쫲 */
      0xecabb3,	/* 쫳 */
    },
    {
      0xecabb4,	/* 쫴 */
      0xecabb5,	/* 쫵 */
      0xecabb6,	/* 쫶 */
      0xecabb7,	/* 쫷 */
      0xecabb8,	/* 쫸 */
      0xecabb9,	/* 쫹 */
      0xecabba,	/* 쫺 */
      0xecabbb,	/* 쫻 */
      0xecabbc,	/* 쫼 */
      0xecabbd,	/* 쫽 */
      0xecabbe,	/* 쫾 */
      0xecabbf,	/* 쫿 */
      0xecac80,	/* 쬀 */
      0xecac81,	/* 쬁 */
      0xecac82,	/* 쬂 */
      0xecac83,	/* 쬃 */
      0xecac84,	/* 쬄 */
      0xecac85,	/* 쬅 */
      0xecac86,	/* 쬆 */
      0xecac87,	/* 쬇 */
      0xecac88,	/* 쬈 */
      0xecac89,	/* 쬉 */
      0xecac8a,	/* 쬊 */
      0xecac8b,	/* 쬋 */
      0xecac8c,	/* 쬌 */
      0xecac8d,	/* 쬍 */
      0xecac8e,	/* 쬎 */
      0xecac8f,	/* 쬏 */
    },
    {
      0xecac90,	/* 쬐 */
      0xecac91,	/* 쬑 */
      0xecac92,	/* 쬒 */
      0xecac93,	/* 쬓 */
      0xecac94,	/* 쬔 */
      0xecac95,	/* 쬕 */
      0xecac96,	/* 쬖 */
      0xecac97,	/* 쬗 */
      0xecac98,	/* 쬘 */
      0xecac99,	/* 쬙 */
      0xecac9a,	/* 쬚 */
      0xecac9b,	/* 쬛 */
      0xecac9c,	/* 쬜 */
      0xecac9d,	/* 쬝 */
      0xecac9e,	/* 쬞 */
      0xecac9f,	/* 쬟 */
      0xecaca0,	/* 쬠 */
      0xecaca1,	/* 쬡 */
      0xecaca2,	/* 쬢 */
      0xecaca3,	/* 쬣 */
      0xecaca4,	/* 쬤 */
      0xecaca5,	/* 쬥 */
      0xecaca6,	/* 쬦 */
      0xecaca7,	/* 쬧 */
      0xecaca8,	/* 쬨 */
      0xecaca9,	/* 쬩 */
      0xecacaa,	/* 쬪 */
      0xecacab,	/* 쬫 */
    },
    {
      0xecacac,	/* 쬬 */
      0xecacad,	/* 쬭 */
      0xecacae,	/* 쬮 */
      0xecacaf,	/* 쬯 */
      0xecacb0,	/* 쬰 */
      0xecacb1,	/* 쬱 */
      0xecacb2,	/* 쬲 */
      0xecacb3,	/* 쬳 */
      0xecacb4,	/* 쬴 */
      0xecacb5,	/* 쬵 */
      0xecacb6,	/* 쬶 */
      0xecacb7,	/* 쬷 */
      0xecacb8,	/* 쬸 */
      0xecacb9,	/* 쬹 */
      0xecacba,	/* 쬺 */
      0xecacbb,	/* 쬻 */
      0xecacbc,	/* 쬼 */
      0xecacbd,	/* 쬽 */
      0xecacbe,	/* 쬾 */
      0xecacbf,	/* 쬿 */
      0xecad80,	/* 쭀 */
      0xecad81,	/* 쭁 */
      0xecad82,	/* 쭂 */
      0xecad83,	/* 쭃 */
      0xecad84,	/* 쭄 */
      0xecad85,	/* 쭅 */
      0xecad86,	/* 쭆 */
      0xecad87,	/* 쭇 */
    },
    {
      0xecad88,	/* 쭈 */
      0xecad89,	/* 쭉 */
      0xecad8a,	/* 쭊 */
      0xecad8b,	/* 쭋 */
      0xecad8c,	/* 쭌 */
      0xecad8d,	/* 쭍 */
      0xecad8e,	/* 쭎 */
      0xecad8f,	/* 쭏 */
      0xecad90,	/* 쭐 */
      0xecad91,	/* 쭑 */
      0xecad92,	/* 쭒 */
      0xecad93,	/* 쭓 */
      0xecad94,	/* 쭔 */
      0xecad95,	/* 쭕 */
      0xecad96,	/* 쭖 */
      0xecad97,	/* 쭗 */
      0xecad98,	/* 쭘 */
      0xecad99,	/* 쭙 */
      0xecad9a,	/* 쭚 */
      0xecad9b,	/* 쭛 */
      0xecad9c,	/* 쭜 */
      0xecad9d,	/* 쭝 */
      0xecad9e,	/* 쭞 */
      0xecad9f,	/* 쭟 */
      0xecada0,	/* 쭠 */
      0xecada1,	/* 쭡 */
      0xecada2,	/* 쭢 */
      0xecada3,	/* 쭣 */
    },
    {
      0xecada4,	/* 쭤 */
      0xecada5,	/* 쭥 */
      0xecada6,	/* 쭦 */
      0xecada7,	/* 쭧 */
      0xecada8,	/* 쭨 */
      0xecada9,	/* 쭩 */
      0xecadaa,	/* 쭪 */
      0xecadab,	/* 쭫 */
      0xecadac,	/* 쭬 */
      0xecadad,	/* 쭭 */
      0xecadae,	/* 쭮 */
      0xecadaf,	/* 쭯 */
      0xecadb0,	/* 쭰 */
      0xecadb1,	/* 쭱 */
      0xecadb2,	/* 쭲 */
      0xecadb3,	/* 쭳 */
      0xecadb4,	/* 쭴 */
      0xecadb5,	/* 쭵 */
      0xecadb6,	/* 쭶 */
      0xecadb7,	/* 쭷 */
      0xecadb8,	/* 쭸 */
      0xecadb9,	/* 쭹 */
      0xecadba,	/* 쭺 */
      0xecadbb,	/* 쭻 */
      0xecadbc,	/* 쭼 */
      0xecadbd,	/* 쭽 */
      0xecadbe,	/* 쭾 */
      0xecadbf,	/* 쭿 */
    },
    {
      0xecae80,	/* 쮀 */
      0xecae81,	/* 쮁 */
      0xecae82,	/* 쮂 */
      0xecae83,	/* 쮃 */
      0xecae84,	/* 쮄 */
      0xecae85,	/* 쮅 */
      0xecae86,	/* 쮆 */
      0xecae87,	/* 쮇 */
      0xecae88,	/* 쮈 */
      0xecae89,	/* 쮉 */
      0xecae8a,	/* 쮊 */
      0xecae8b,	/* 쮋 */
      0xecae8c,	/* 쮌 */
      0xecae8d,	/* 쮍 */
      0xecae8e,	/* 쮎 */
      0xecae8f,	/* 쮏 */
      0xecae90,	/* 쮐 */
      0xecae91,	/* 쮑 */
      0xecae92,	/* 쮒 */
      0xecae93,	/* 쮓 */
      0xecae94,	/* 쮔 */
      0xecae95,	/* 쮕 */
      0xecae96,	/* 쮖 */
      0xecae97,	/* 쮗 */
      0xecae98,	/* 쮘 */
      0xecae99,	/* 쮙 */
      0xecae9a,	/* 쮚 */
      0xecae9b,	/* 쮛 */
    },
    {
      0xecae9c,	/* 쮜 */
      0xecae9d,	/* 쮝 */
      0xecae9e,	/* 쮞 */
      0xecae9f,	/* 쮟 */
      0xecaea0,	/* 쮠 */
      0xecaea1,	/* 쮡 */
      0xecaea2,	/* 쮢 */
      0xecaea3,	/* 쮣 */
      0xecaea4,	/* 쮤 */
      0xecaea5,	/* 쮥 */
      0xecaea6,	/* 쮦 */
      0xecaea7,	/* 쮧 */
      0xecaea8,	/* 쮨 */
      0xecaea9,	/* 쮩 */
      0xecaeaa,	/* 쮪 */
      0xecaeab,	/* 쮫 */
      0xecaeac,	/* 쮬 */
      0xecaead,	/* 쮭 */
      0xecaeae,	/* 쮮 */
      0xecaeaf,	/* 쮯 */
      0xecaeb0,	/* 쮰 */
      0xecaeb1,	/* 쮱 */
      0xecaeb2,	/* 쮲 */
      0xecaeb3,	/* 쮳 */
      0xecaeb4,	/* 쮴 */
      0xecaeb5,	/* 쮵 */
      0xecaeb6,	/* 쮶 */
      0xecaeb7,	/* 쮷 */
    },
    {
      0xecaeb8,	/* 쮸 */
      0xecaeb9,	/* 쮹 */
      0xecaeba,	/* 쮺 */
      0xecaebb,	/* 쮻 */
      0xecaebc,	/* 쮼 */
      0xecaebd,	/* 쮽 */
      0xecaebe,	/* 쮾 */
      0xecaebf,	/* 쮿 */
      0xecaf80,	/* 쯀 */
      0xecaf81,	/* 쯁 */
      0xecaf82,	/* 쯂 */
      0xecaf83,	/* 쯃 */
      0xecaf84,	/* 쯄 */
      0xecaf85,	/* 쯅 */
      0xecaf86,	/* 쯆 */
      0xecaf87,	/* 쯇 */
      0xecaf88,	/* 쯈 */
      0xecaf89,	/* 쯉 */
      0xecaf8a,	/* 쯊 */
      0xecaf8b,	/* 쯋 */
      0xecaf8c,	/* 쯌 */
      0xecaf8d,	/* 쯍 */
      0xecaf8e,	/* 쯎 */
      0xecaf8f,	/* 쯏 */
      0xecaf90,	/* 쯐 */
      0xecaf91,	/* 쯑 */
      0xecaf92,	/* 쯒 */
      0xecaf93,	/* 쯓 */
    },
    {
      0xecaf94,	/* 쯔 */
      0xecaf95,	/* 쯕 */
      0xecaf96,	/* 쯖 */
      0xecaf97,	/* 쯗 */
      0xecaf98,	/* 쯘 */
      0xecaf99,	/* 쯙 */
      0xecaf9a,	/* 쯚 */
      0xecaf9b,	/* 쯛 */
      0xecaf9c,	/* 쯜 */
      0xecaf9d,	/* 쯝 */
      0xecaf9e,	/* 쯞 */
      0xecaf9f,	/* 쯟 */
      0xecafa0,	/* 쯠 */
      0xecafa1,	/* 쯡 */
      0xecafa2,	/* 쯢 */
      0xecafa3,	/* 쯣 */
      0xecafa4,	/* 쯤 */
      0xecafa5,	/* 쯥 */
      0xecafa6,	/* 쯦 */
      0xecafa7,	/* 쯧 */
      0xecafa8,	/* 쯨 */
      0xecafa9,	/* 쯩 */
      0xecafaa,	/* 쯪 */
      0xecafab,	/* 쯫 */
      0xecafac,	/* 쯬 */
      0xecafad,	/* 쯭 */
      0xecafae,	/* 쯮 */
      0xecafaf,	/* 쯯 */
    },
    {
      0xecafb0,	/* 쯰 */
      0xecafb1,	/* 쯱 */
      0xecafb2,	/* 쯲 */
      0xecafb3,	/* 쯳 */
      0xecafb4,	/* 쯴 */
      0xecafb5,	/* 쯵 */
      0xecafb6,	/* 쯶 */
      0xecafb7,	/* 쯷 */
      0xecafb8,	/* 쯸 */
      0xecafb9,	/* 쯹 */
      0xecafba,	/* 쯺 */
      0xecafbb,	/* 쯻 */
      0xecafbc,	/* 쯼 */
      0xecafbd,	/* 쯽 */
      0xecafbe,	/* 쯾 */
      0xecafbf,	/* 쯿 */
      0xecb080,	/* 찀 */
      0xecb081,	/* 찁 */
      0xecb082,	/* 찂 */
      0xecb083,	/* 찃 */
      0xecb084,	/* 찄 */
      0xecb085,	/* 찅 */
      0xecb086,	/* 찆 */
      0xecb087,	/* 찇 */
      0xecb088,	/* 찈 */
      0xecb089,	/* 찉 */
      0xecb08a,	/* 찊 */
      0xecb08b,	/* 찋 */
    },
    {
      0xecb08c,	/* 찌 */
      0xecb08d,	/* 찍 */
      0xecb08e,	/* 찎 */
      0xecb08f,	/* 찏 */
      0xecb090,	/* 찐 */
      0xecb091,	/* 찑 */
      0xecb092,	/* 찒 */
      0xecb093,	/* 찓 */
      0xecb094,	/* 찔 */
      0xecb095,	/* 찕 */
      0xecb096,	/* 찖 */
      0xecb097,	/* 찗 */
      0xecb098,	/* 찘 */
      0xecb099,	/* 찙 */
      0xecb09a,	/* 찚 */
      0xecb09b,	/* 찛 */
      0xecb09c,	/* 찜 */
      0xecb09d,	/* 찝 */
      0xecb09e,	/* 찞 */
      0xecb09f,	/* 찟 */
      0xecb0a0,	/* 찠 */
      0xecb0a1,	/* 찡 */
      0xecb0a2,	/* 찢 */
      0xecb0a3,	/* 찣 */
      0xecb0a4,	/* 찤 */
      0xecb0a5,	/* 찥 */
      0xecb0a6,	/* 찦 */
      0xecb0a7,	/* 찧 */
    },
  },
  {
    {
      0xecb0a8,	/* 차 */
      0xecb0a9,	/* 착 */
      0xecb0aa,	/* 찪 */
      0xecb0ab,	/* 찫 */
      0xecb0ac,	/* 찬 */
      0xecb0ad,	/* 찭 */
      0xecb0ae,	/* 찮 */
      0xecb0af,	/* 찯 */
      0xecb0b0,	/* 찰 */
      0xecb0b1,	/* 찱 */
      0xecb0b2,	/* 찲 */
      0xecb0b3,	/* 찳 */
      0xecb0b4,	/* 찴 */
      0xecb0b5,	/* 찵 */
      0xecb0b6,	/* 찶 */
      0xecb0b7,	/* 찷 */
      0xecb0b8,	/* 참 */
      0xecb0b9,	/* 찹 */
      0xecb0ba,	/* 찺 */
      0xecb0bb,	/* 찻 */
      0xecb0bc,	/* 찼 */
      0xecb0bd,	/* 창 */
      0xecb0be,	/* 찾 */
      0xecb0bf,	/* 찿 */
      0xecb180,	/* 챀 */
      0xecb181,	/* 챁 */
      0xecb182,	/* 챂 */
      0xecb183,	/* 챃 */
    },
    {
      0xecb184,	/* 채 */
      0xecb185,	/* 책 */
      0xecb186,	/* 챆 */
      0xecb187,	/* 챇 */
      0xecb188,	/* 챈 */
      0xecb189,	/* 챉 */
      0xecb18a,	/* 챊 */
      0xecb18b,	/* 챋 */
      0xecb18c,	/* 챌 */
      0xecb18d,	/* 챍 */
      0xecb18e,	/* 챎 */
      0xecb18f,	/* 챏 */
      0xecb190,	/* 챐 */
      0xecb191,	/* 챑 */
      0xecb192,	/* 챒 */
      0xecb193,	/* 챓 */
      0xecb194,	/* 챔 */
      0xecb195,	/* 챕 */
      0xecb196,	/* 챖 */
      0xecb197,	/* 챗 */
      0xecb198,	/* 챘 */
      0xecb199,	/* 챙 */
      0xecb19a,	/* 챚 */
      0xecb19b,	/* 챛 */
      0xecb19c,	/* 챜 */
      0xecb19d,	/* 챝 */
      0xecb19e,	/* 챞 */
      0xecb19f,	/* 챟 */
    },
    {
      0xecb1a0,	/* 챠 */
      0xecb1a1,	/* 챡 */
      0xecb1a2,	/* 챢 */
      0xecb1a3,	/* 챣 */
      0xecb1a4,	/* 챤 */
      0xecb1a5,	/* 챥 */
      0xecb1a6,	/* 챦 */
      0xecb1a7,	/* 챧 */
      0xecb1a8,	/* 챨 */
      0xecb1a9,	/* 챩 */
      0xecb1aa,	/* 챪 */
      0xecb1ab,	/* 챫 */
      0xecb1ac,	/* 챬 */
      0xecb1ad,	/* 챭 */
      0xecb1ae,	/* 챮 */
      0xecb1af,	/* 챯 */
      0xecb1b0,	/* 챰 */
      0xecb1b1,	/* 챱 */
      0xecb1b2,	/* 챲 */
      0xecb1b3,	/* 챳 */
      0xecb1b4,	/* 챴 */
      0xecb1b5,	/* 챵 */
      0xecb1b6,	/* 챶 */
      0xecb1b7,	/* 챷 */
      0xecb1b8,	/* 챸 */
      0xecb1b9,	/* 챹 */
      0xecb1ba,	/* 챺 */
      0xecb1bb,	/* 챻 */
    },
    {
      0xecb1bc,	/* 챼 */
      0xecb1bd,	/* 챽 */
      0xecb1be,	/* 챾 */
      0xecb1bf,	/* 챿 */
      0xecb280,	/* 첀 */
      0xecb281,	/* 첁 */
      0xecb282,	/* 첂 */
      0xecb283,	/* 첃 */
      0xecb284,	/* 첄 */
      0xecb285,	/* 첅 */
      0xecb286,	/* 첆 */
      0xecb287,	/* 첇 */
      0xecb288,	/* 첈 */
      0xecb289,	/* 첉 */
      0xecb28a,	/* 첊 */
      0xecb28b,	/* 첋 */
      0xecb28c,	/* 첌 */
      0xecb28d,	/* 첍 */
      0xecb28e,	/* 첎 */
      0xecb28f,	/* 첏 */
      0xecb290,	/* 첐 */
      0xecb291,	/* 첑 */
      0xecb292,	/* 첒 */
      0xecb293,	/* 첓 */
      0xecb294,	/* 첔 */
      0xecb295,	/* 첕 */
      0xecb296,	/* 첖 */
      0xecb297,	/* 첗 */
    },
    {
      0xecb298,	/* 처 */
      0xecb299,	/* 척 */
      0xecb29a,	/* 첚 */
      0xecb29b,	/* 첛 */
      0xecb29c,	/* 천 */
      0xecb29d,	/* 첝 */
      0xecb29e,	/* 첞 */
      0xecb29f,	/* 첟 */
      0xecb2a0,	/* 철 */
      0xecb2a1,	/* 첡 */
      0xecb2a2,	/* 첢 */
      0xecb2a3,	/* 첣 */
      0xecb2a4,	/* 첤 */
      0xecb2a5,	/* 첥 */
      0xecb2a6,	/* 첦 */
      0xecb2a7,	/* 첧 */
      0xecb2a8,	/* 첨 */
      0xecb2a9,	/* 첩 */
      0xecb2aa,	/* 첪 */
      0xecb2ab,	/* 첫 */
      0xecb2ac,	/* 첬 */
      0xecb2ad,	/* 청 */
      0xecb2ae,	/* 첮 */
      0xecb2af,	/* 첯 */
      0xecb2b0,	/* 첰 */
      0xecb2b1,	/* 첱 */
      0xecb2b2,	/* 첲 */
      0xecb2b3,	/* 첳 */
    },
    {
      0xecb2b4,	/* 체 */
      0xecb2b5,	/* 첵 */
      0xecb2b6,	/* 첶 */
      0xecb2b7,	/* 첷 */
      0xecb2b8,	/* 첸 */
      0xecb2b9,	/* 첹 */
      0xecb2ba,	/* 첺 */
      0xecb2bb,	/* 첻 */
      0xecb2bc,	/* 첼 */
      0xecb2bd,	/* 첽 */
      0xecb2be,	/* 첾 */
      0xecb2bf,	/* 첿 */
      0xecb380,	/* 쳀 */
      0xecb381,	/* 쳁 */
      0xecb382,	/* 쳂 */
      0xecb383,	/* 쳃 */
      0xecb384,	/* 쳄 */
      0xecb385,	/* 쳅 */
      0xecb386,	/* 쳆 */
      0xecb387,	/* 쳇 */
      0xecb388,	/* 쳈 */
      0xecb389,	/* 쳉 */
      0xecb38a,	/* 쳊 */
      0xecb38b,	/* 쳋 */
      0xecb38c,	/* 쳌 */
      0xecb38d,	/* 쳍 */
      0xecb38e,	/* 쳎 */
      0xecb38f,	/* 쳏 */
    },
    {
      0xecb390,	/* 쳐 */
      0xecb391,	/* 쳑 */
      0xecb392,	/* 쳒 */
      0xecb393,	/* 쳓 */
      0xecb394,	/* 쳔 */
      0xecb395,	/* 쳕 */
      0xecb396,	/* 쳖 */
      0xecb397,	/* 쳗 */
      0xecb398,	/* 쳘 */
      0xecb399,	/* 쳙 */
      0xecb39a,	/* 쳚 */
      0xecb39b,	/* 쳛 */
      0xecb39c,	/* 쳜 */
      0xecb39d,	/* 쳝 */
      0xecb39e,	/* 쳞 */
      0xecb39f,	/* 쳟 */
      0xecb3a0,	/* 쳠 */
      0xecb3a1,	/* 쳡 */
      0xecb3a2,	/* 쳢 */
      0xecb3a3,	/* 쳣 */
      0xecb3a4,	/* 쳤 */
      0xecb3a5,	/* 쳥 */
      0xecb3a6,	/* 쳦 */
      0xecb3a7,	/* 쳧 */
      0xecb3a8,	/* 쳨 */
      0xecb3a9,	/* 쳩 */
      0xecb3aa,	/* 쳪 */
      0xecb3ab,	/* 쳫 */
    },
    {
      0xecb3ac,	/* 쳬 */
      0xecb3ad,	/* 쳭 */
      0xecb3ae,	/* 쳮 */
      0xecb3af,	/* 쳯 */
      0xecb3b0,	/* 쳰 */
      0xecb3b1,	/* 쳱 */
      0xecb3b2,	/* 쳲 */
      0xecb3b3,	/* 쳳 */
      0xecb3b4,	/* 쳴 */
      0xecb3b5,	/* 쳵 */
      0xecb3b6,	/* 쳶 */
      0xecb3b7,	/* 쳷 */
      0xecb3b8,	/* 쳸 */
      0xecb3b9,	/* 쳹 */
      0xecb3ba,	/* 쳺 */
      0xecb3bb,	/* 쳻 */
      0xecb3bc,	/* 쳼 */
      0xecb3bd,	/* 쳽 */
      0xecb3be,	/* 쳾 */
      0xecb3bf,	/* 쳿 */
      0xecb480,	/* 촀 */
      0xecb481,	/* 촁 */
      0xecb482,	/* 촂 */
      0xecb483,	/* 촃 */
      0xecb484,	/* 촄 */
      0xecb485,	/* 촅 */
      0xecb486,	/* 촆 */
      0xecb487,	/* 촇 */
    },
    {
      0xecb488,	/* 초 */
      0xecb489,	/* 촉 */
      0xecb48a,	/* 촊 */
      0xecb48b,	/* 촋 */
      0xecb48c,	/* 촌 */
      0xecb48d,	/* 촍 */
      0xecb48e,	/* 촎 */
      0xecb48f,	/* 촏 */
      0xecb490,	/* 촐 */
      0xecb491,	/* 촑 */
      0xecb492,	/* 촒 */
      0xecb493,	/* 촓 */
      0xecb494,	/* 촔 */
      0xecb495,	/* 촕 */
      0xecb496,	/* 촖 */
      0xecb497,	/* 촗 */
      0xecb498,	/* 촘 */
      0xecb499,	/* 촙 */
      0xecb49a,	/* 촚 */
      0xecb49b,	/* 촛 */
      0xecb49c,	/* 촜 */
      0xecb49d,	/* 총 */
      0xecb49e,	/* 촞 */
      0xecb49f,	/* 촟 */
      0xecb4a0,	/* 촠 */
      0xecb4a1,	/* 촡 */
      0xecb4a2,	/* 촢 */
      0xecb4a3,	/* 촣 */
    },
    {
      0xecb4a4,	/* 촤 */
      0xecb4a5,	/* 촥 */
      0xecb4a6,	/* 촦 */
      0xecb4a7,	/* 촧 */
      0xecb4a8,	/* 촨 */
      0xecb4a9,	/* 촩 */
      0xecb4aa,	/* 촪 */
      0xecb4ab,	/* 촫 */
      0xecb4ac,	/* 촬 */
      0xecb4ad,	/* 촭 */
      0xecb4ae,	/* 촮 */
      0xecb4af,	/* 촯 */
      0xecb4b0,	/* 촰 */
      0xecb4b1,	/* 촱 */
      0xecb4b2,	/* 촲 */
      0xecb4b3,	/* 촳 */
      0xecb4b4,	/* 촴 */
      0xecb4b5,	/* 촵 */
      0xecb4b6,	/* 촶 */
      0xecb4b7,	/* 촷 */
      0xecb4b8,	/* 촸 */
      0xecb4b9,	/* 촹 */
      0xecb4ba,	/* 촺 */
      0xecb4bb,	/* 촻 */
      0xecb4bc,	/* 촼 */
      0xecb4bd,	/* 촽 */
      0xecb4be,	/* 촾 */
      0xecb4bf,	/* 촿 */
    },
    {
      0xecb580,	/* 쵀 */
      0xecb581,	/* 쵁 */
      0xecb582,	/* 쵂 */
      0xecb583,	/* 쵃 */
      0xecb584,	/* 쵄 */
      0xecb585,	/* 쵅 */
      0xecb586,	/* 쵆 */
      0xecb587,	/* 쵇 */
      0xecb588,	/* 쵈 */
      0xecb589,	/* 쵉 */
      0xecb58a,	/* 쵊 */
      0xecb58b,	/* 쵋 */
      0xecb58c,	/* 쵌 */
      0xecb58d,	/* 쵍 */
      0xecb58e,	/* 쵎 */
      0xecb58f,	/* 쵏 */
      0xecb590,	/* 쵐 */
      0xecb591,	/* 쵑 */
      0xecb592,	/* 쵒 */
      0xecb593,	/* 쵓 */
      0xecb594,	/* 쵔 */
      0xecb595,	/* 쵕 */
      0xecb596,	/* 쵖 */
      0xecb597,	/* 쵗 */
      0xecb598,	/* 쵘 */
      0xecb599,	/* 쵙 */
      0xecb59a,	/* 쵚 */
      0xecb59b,	/* 쵛 */
    },
    {
      0xecb59c,	/* 최 */
      0xecb59d,	/* 쵝 */
      0xecb59e,	/* 쵞 */
      0xecb59f,	/* 쵟 */
      0xecb5a0,	/* 쵠 */
      0xecb5a1,	/* 쵡 */
      0xecb5a2,	/* 쵢 */
      0xecb5a3,	/* 쵣 */
      0xecb5a4,	/* 쵤 */
      0xecb5a5,	/* 쵥 */
      0xecb5a6,	/* 쵦 */
      0xecb5a7,	/* 쵧 */
      0xecb5a8,	/* 쵨 */
      0xecb5a9,	/* 쵩 */
      0xecb5aa,	/* 쵪 */
      0xecb5ab,	/* 쵫 */
      0xecb5ac,	/* 쵬 */
      0xecb5ad,	/* 쵭 */
      0xecb5ae,	/* 쵮 */
      0xecb5af,	/* 쵯 */
      0xecb5b0,	/* 쵰 */
      0xecb5b1,	/* 쵱 */
      0xecb5b2,	/* 쵲 */
      0xecb5b3,	/* 쵳 */
      0xecb5b4,	/* 쵴 */
      0xecb5b5,	/* 쵵 */
      0xecb5b6,	/* 쵶 */
      0xecb5b7,	/* 쵷 */
    },
    {
      0xecb5b8,	/* 쵸 */
      0xecb5b9,	/* 쵹 */
      0xecb5ba,	/* 쵺 */
      0xecb5bb,	/* 쵻 */
      0xecb5bc,	/* 쵼 */
      0xecb5bd,	/* 쵽 */
      0xecb5be,	/* 쵾 */
      0xecb5bf,	/* 쵿 */
      0xecb680,	/* 춀 */
      0xecb681,	/* 춁 */
      0xecb682,	/* 춂 */
      0xecb683,	/* 춃 */
      0xecb684,	/* 춄 */
      0xecb685,	/* 춅 */
      0xecb686,	/* 춆 */
      0xecb687,	/* 춇 */
      0xecb688,	/* 춈 */
      0xecb689,	/* 춉 */
      0xecb68a,	/* 춊 */
      0xecb68b,	/* 춋 */
      0xecb68c,	/* 춌 */
      0xecb68d,	/* 춍 */
      0xecb68e,	/* 춎 */
      0xecb68f,	/* 춏 */
      0xecb690,	/* 춐 */
      0xecb691,	/* 춑 */
      0xecb692,	/* 춒 */
      0xecb693,	/* 춓 */
    },
    {
      0xecb694,	/* 추 */
      0xecb695,	/* 축 */
      0xecb696,	/* 춖 */
      0xecb697,	/* 춗 */
      0xecb698,	/* 춘 */
      0xecb699,	/* 춙 */
      0xecb69a,	/* 춚 */
      0xecb69b,	/* 춛 */
      0xecb69c,	/* 출 */
      0xecb69d,	/* 춝 */
      0xecb69e,	/* 춞 */
      0xecb69f,	/* 춟 */
      0xecb6a0,	/* 춠 */
      0xecb6a1,	/* 춡 */
      0xecb6a2,	/* 춢 */
      0xecb6a3,	/* 춣 */
      0xecb6a4,	/* 춤 */
      0xecb6a5,	/* 춥 */
      0xecb6a6,	/* 춦 */
      0xecb6a7,	/* 춧 */
      0xecb6a8,	/* 춨 */
      0xecb6a9,	/* 충 */
      0xecb6aa,	/* 춪 */
      0xecb6ab,	/* 춫 */
      0xecb6ac,	/* 춬 */
      0xecb6ad,	/* 춭 */
      0xecb6ae,	/* 춮 */
      0xecb6af,	/* 춯 */
    },
    {
      0xecb6b0,	/* 춰 */
      0xecb6b1,	/* 춱 */
      0xecb6b2,	/* 춲 */
      0xecb6b3,	/* 춳 */
      0xecb6b4,	/* 춴 */
      0xecb6b5,	/* 춵 */
      0xecb6b6,	/* 춶 */
      0xecb6b7,	/* 춷 */
      0xecb6b8,	/* 춸 */
      0xecb6b9,	/* 춹 */
      0xecb6ba,	/* 춺 */
      0xecb6bb,	/* 춻 */
      0xecb6bc,	/* 춼 */
      0xecb6bd,	/* 춽 */
      0xecb6be,	/* 춾 */
      0xecb6bf,	/* 춿 */
      0xecb780,	/* 췀 */
      0xecb781,	/* 췁 */
      0xecb782,	/* 췂 */
      0xecb783,	/* 췃 */
      0xecb784,	/* 췄 */
      0xecb785,	/* 췅 */
      0xecb786,	/* 췆 */
      0xecb787,	/* 췇 */
      0xecb788,	/* 췈 */
      0xecb789,	/* 췉 */
      0xecb78a,	/* 췊 */
      0xecb78b,	/* 췋 */
    },
    {
      0xecb78c,	/* 췌 */
      0xecb78d,	/* 췍 */
      0xecb78e,	/* 췎 */
      0xecb78f,	/* 췏 */
      0xecb790,	/* 췐 */
      0xecb791,	/* 췑 */
      0xecb792,	/* 췒 */
      0xecb793,	/* 췓 */
      0xecb794,	/* 췔 */
      0xecb795,	/* 췕 */
      0xecb796,	/* 췖 */
      0xecb797,	/* 췗 */
      0xecb798,	/* 췘 */
      0xecb799,	/* 췙 */
      0xecb79a,	/* 췚 */
      0xecb79b,	/* 췛 */
      0xecb79c,	/* 췜 */
      0xecb79d,	/* 췝 */
      0xecb79e,	/* 췞 */
      0xecb79f,	/* 췟 */
      0xecb7a0,	/* 췠 */
      0xecb7a1,	/* 췡 */
      0xecb7a2,	/* 췢 */
      0xecb7a3,	/* 췣 */
      0xecb7a4,	/* 췤 */
      0xecb7a5,	/* 췥 */
      0xecb7a6,	/* 췦 */
      0xecb7a7,	/* 췧 */
    },
    {
      0xecb7a8,	/* 취 */
      0xecb7a9,	/* 췩 */
      0xecb7aa,	/* 췪 */
      0xecb7ab,	/* 췫 */
      0xecb7ac,	/* 췬 */
      0xecb7ad,	/* 췭 */
      0xecb7ae,	/* 췮 */
      0xecb7af,	/* 췯 */
      0xecb7b0,	/* 췰 */
      0xecb7b1,	/* 췱 */
      0xecb7b2,	/* 췲 */
      0xecb7b3,	/* 췳 */
      0xecb7b4,	/* 췴 */
      0xecb7b5,	/* 췵 */
      0xecb7b6,	/* 췶 */
      0xecb7b7,	/* 췷 */
      0xecb7b8,	/* 췸 */
      0xecb7b9,	/* 췹 */
      0xecb7ba,	/* 췺 */
      0xecb7bb,	/* 췻 */
      0xecb7bc,	/* 췼 */
      0xecb7bd,	/* 췽 */
      0xecb7be,	/* 췾 */
      0xecb7bf,	/* 췿 */
      0xecb880,	/* 츀 */
      0xecb881,	/* 츁 */
      0xecb882,	/* 츂 */
      0xecb883,	/* 츃 */
    },
    {
      0xecb884,	/* 츄 */
      0xecb885,	/* 츅 */
      0xecb886,	/* 츆 */
      0xecb887,	/* 츇 */
      0xecb888,	/* 츈 */
      0xecb889,	/* 츉 */
      0xecb88a,	/* 츊 */
      0xecb88b,	/* 츋 */
      0xecb88c,	/* 츌 */
      0xecb88d,	/* 츍 */
      0xecb88e,	/* 츎 */
      0xecb88f,	/* 츏 */
      0xecb890,	/* 츐 */
      0xecb891,	/* 츑 */
      0xecb892,	/* 츒 */
      0xecb893,	/* 츓 */
      0xecb894,	/* 츔 */
      0xecb895,	/* 츕 */
      0xecb896,	/* 츖 */
      0xecb897,	/* 츗 */
      0xecb898,	/* 츘 */
      0xecb899,	/* 츙 */
      0xecb89a,	/* 츚 */
      0xecb89b,	/* 츛 */
      0xecb89c,	/* 츜 */
      0xecb89d,	/* 츝 */
      0xecb89e,	/* 츞 */
      0xecb89f,	/* 츟 */
    },
    {
      0xecb8a0,	/* 츠 */
      0xecb8a1,	/* 측 */
      0xecb8a2,	/* 츢 */
      0xecb8a3,	/* 츣 */
      0xecb8a4,	/* 츤 */
      0xecb8a5,	/* 츥 */
      0xecb8a6,	/* 츦 */
      0xecb8a7,	/* 츧 */
      0xecb8a8,	/* 츨 */
      0xecb8a9,	/* 츩 */
      0xecb8aa,	/* 츪 */
      0xecb8ab,	/* 츫 */
      0xecb8ac,	/* 츬 */
      0xecb8ad,	/* 츭 */
      0xecb8ae,	/* 츮 */
      0xecb8af,	/* 츯 */
      0xecb8b0,	/* 츰 */
      0xecb8b1,	/* 츱 */
      0xecb8b2,	/* 츲 */
      0xecb8b3,	/* 츳 */
      0xecb8b4,	/* 츴 */
      0xecb8b5,	/* 층 */
      0xecb8b6,	/* 츶 */
      0xecb8b7,	/* 츷 */
      0xecb8b8,	/* 츸 */
      0xecb8b9,	/* 츹 */
      0xecb8ba,	/* 츺 */
      0xecb8bb,	/* 츻 */
    },
    {
      0xecb8bc,	/* 츼 */
      0xecb8bd,	/* 츽 */
      0xecb8be,	/* 츾 */
      0xecb8bf,	/* 츿 */
      0xecb980,	/* 칀 */
      0xecb981,	/* 칁 */
      0xecb982,	/* 칂 */
      0xecb983,	/* 칃 */
      0xecb984,	/* 칄 */
      0xecb985,	/* 칅 */
      0xecb986,	/* 칆 */
      0xecb987,	/* 칇 */
      0xecb988,	/* 칈 */
      0xecb989,	/* 칉 */
      0xecb98a,	/* 칊 */
      0xecb98b,	/* 칋 */
      0xecb98c,	/* 칌 */
      0xecb98d,	/* 칍 */
      0xecb98e,	/* 칎 */
      0xecb98f,	/* 칏 */
      0xecb990,	/* 칐 */
      0xecb991,	/* 칑 */
      0xecb992,	/* 칒 */
      0xecb993,	/* 칓 */
      0xecb994,	/* 칔 */
      0xecb995,	/* 칕 */
      0xecb996,	/* 칖 */
      0xecb997,	/* 칗 */
    },
    {
      0xecb998,	/* 치 */
      0xecb999,	/* 칙 */
      0xecb99a,	/* 칚 */
      0xecb99b,	/* 칛 */
      0xecb99c,	/* 친 */
      0xecb99d,	/* 칝 */
      0xecb99e,	/* 칞 */
      0xecb99f,	/* 칟 */
      0xecb9a0,	/* 칠 */
      0xecb9a1,	/* 칡 */
      0xecb9a2,	/* 칢 */
      0xecb9a3,	/* 칣 */
      0xecb9a4,	/* 칤 */
      0xecb9a5,	/* 칥 */
      0xecb9a6,	/* 칦 */
      0xecb9a7,	/* 칧 */
      0xecb9a8,	/* 침 */
      0xecb9a9,	/* 칩 */
      0xecb9aa,	/* 칪 */
      0xecb9ab,	/* 칫 */
      0xecb9ac,	/* 칬 */
      0xecb9ad,	/* 칭 */
      0xecb9ae,	/* 칮 */
      0xecb9af,	/* 칯 */
      0xecb9b0,	/* 칰 */
      0xecb9b1,	/* 칱 */
      0xecb9b2,	/* 칲 */
      0xecb9b3,	/* 칳 */
    },
  },
  {
    {
      0xecb9b4,	/* 카 */
      0xecb9b5,	/* 칵 */
      0xecb9b6,	/* 칶 */
      0xecb9b7,	/* 칷 */
      0xecb9b8,	/* 칸 */
      0xecb9b9,	/* 칹 */
      0xecb9ba,	/* 칺 */
      0xecb9bb,	/* 칻 */
      0xecb9bc,	/* 칼 */
      0xecb9bd,	/* 칽 */
      0xecb9be,	/* 칾 */
      0xecb9bf,	/* 칿 */
      0xecba80,	/* 캀 */
      0xecba81,	/* 캁 */
      0xecba82,	/* 캂 */
      0xecba83,	/* 캃 */
      0xecba84,	/* 캄 */
      0xecba85,	/* 캅 */
      0xecba86,	/* 캆 */
      0xecba87,	/* 캇 */
      0xecba88,	/* 캈 */
      0xecba89,	/* 캉 */
      0xecba8a,	/* 캊 */
      0xecba8b,	/* 캋 */
      0xecba8c,	/* 캌 */
      0xecba8d,	/* 캍 */
      0xecba8e,	/* 캎 */
      0xecba8f,	/* 캏 */
    },
    {
      0xecba90,	/* 캐 */
      0xecba91,	/* 캑 */
      0xecba92,	/* 캒 */
      0xecba93,	/* 캓 */
      0xecba94,	/* 캔 */
      0xecba95,	/* 캕 */
      0xecba96,	/* 캖 */
      0xecba97,	/* 캗 */
      0xecba98,	/* 캘 */
      0xecba99,	/* 캙 */
      0xecba9a,	/* 캚 */
      0xecba9b,	/* 캛 */
      0xecba9c,	/* 캜 */
      0xecba9d,	/* 캝 */
      0xecba9e,	/* 캞 */
      0xecba9f,	/* 캟 */
      0xecbaa0,	/* 캠 */
      0xecbaa1,	/* 캡 */
      0xecbaa2,	/* 캢 */
      0xecbaa3,	/* 캣 */
      0xecbaa4,	/* 캤 */
      0xecbaa5,	/* 캥 */
      0xecbaa6,	/* 캦 */
      0xecbaa7,	/* 캧 */
      0xecbaa8,	/* 캨 */
      0xecbaa9,	/* 캩 */
      0xecbaaa,	/* 캪 */
      0xecbaab,	/* 캫 */
    },
    {
      0xecbaac,	/* 캬 */
      0xecbaad,	/* 캭 */
      0xecbaae,	/* 캮 */
      0xecbaaf,	/* 캯 */
      0xecbab0,	/* 캰 */
      0xecbab1,	/* 캱 */
      0xecbab2,	/* 캲 */
      0xecbab3,	/* 캳 */
      0xecbab4,	/* 캴 */
      0xecbab5,	/* 캵 */
      0xecbab6,	/* 캶 */
      0xecbab7,	/* 캷 */
      0xecbab8,	/* 캸 */
      0xecbab9,	/* 캹 */
      0xecbaba,	/* 캺 */
      0xecbabb,	/* 캻 */
      0xecbabc,	/* 캼 */
      0xecbabd,	/* 캽 */
      0xecbabe,	/* 캾 */
      0xecbabf,	/* 캿 */
      0xecbb80,	/* 컀 */
      0xecbb81,	/* 컁 */
      0xecbb82,	/* 컂 */
      0xecbb83,	/* 컃 */
      0xecbb84,	/* 컄 */
      0xecbb85,	/* 컅 */
      0xecbb86,	/* 컆 */
      0xecbb87,	/* 컇 */
    },
    {
      0xecbb88,	/* 컈 */
      0xecbb89,	/* 컉 */
      0xecbb8a,	/* 컊 */
      0xecbb8b,	/* 컋 */
      0xecbb8c,	/* 컌 */
      0xecbb8d,	/* 컍 */
      0xecbb8e,	/* 컎 */
      0xecbb8f,	/* 컏 */
      0xecbb90,	/* 컐 */
      0xecbb91,	/* 컑 */
      0xecbb92,	/* 컒 */
      0xecbb93,	/* 컓 */
      0xecbb94,	/* 컔 */
      0xecbb95,	/* 컕 */
      0xecbb96,	/* 컖 */
      0xecbb97,	/* 컗 */
      0xecbb98,	/* 컘 */
      0xecbb99,	/* 컙 */
      0xecbb9a,	/* 컚 */
      0xecbb9b,	/* 컛 */
      0xecbb9c,	/* 컜 */
      0xecbb9d,	/* 컝 */
      0xecbb9e,	/* 컞 */
      0xecbb9f,	/* 컟 */
      0xecbba0,	/* 컠 */
      0xecbba1,	/* 컡 */
      0xecbba2,	/* 컢 */
      0xecbba3,	/* 컣 */
    },
    {
      0xecbba4,	/* 커 */
      0xecbba5,	/* 컥 */
      0xecbba6,	/* 컦 */
      0xecbba7,	/* 컧 */
      0xecbba8,	/* 컨 */
      0xecbba9,	/* 컩 */
      0xecbbaa,	/* 컪 */
      0xecbbab,	/* 컫 */
      0xecbbac,	/* 컬 */
      0xecbbad,	/* 컭 */
      0xecbbae,	/* 컮 */
      0xecbbaf,	/* 컯 */
      0xecbbb0,	/* 컰 */
      0xecbbb1,	/* 컱 */
      0xecbbb2,	/* 컲 */
      0xecbbb3,	/* 컳 */
      0xecbbb4,	/* 컴 */
      0xecbbb5,	/* 컵 */
      0xecbbb6,	/* 컶 */
      0xecbbb7,	/* 컷 */
      0xecbbb8,	/* 컸 */
      0xecbbb9,	/* 컹 */
      0xecbbba,	/* 컺 */
      0xecbbbb,	/* 컻 */
      0xecbbbc,	/* 컼 */
      0xecbbbd,	/* 컽 */
      0xecbbbe,	/* 컾 */
      0xecbbbf,	/* 컿 */
    },
    {
      0xecbc80,	/* 케 */
      0xecbc81,	/* 켁 */
      0xecbc82,	/* 켂 */
      0xecbc83,	/* 켃 */
      0xecbc84,	/* 켄 */
      0xecbc85,	/* 켅 */
      0xecbc86,	/* 켆 */
      0xecbc87,	/* 켇 */
      0xecbc88,	/* 켈 */
      0xecbc89,	/* 켉 */
      0xecbc8a,	/* 켊 */
      0xecbc8b,	/* 켋 */
      0xecbc8c,	/* 켌 */
      0xecbc8d,	/* 켍 */
      0xecbc8e,	/* 켎 */
      0xecbc8f,	/* 켏 */
      0xecbc90,	/* 켐 */
      0xecbc91,	/* 켑 */
      0xecbc92,	/* 켒 */
      0xecbc93,	/* 켓 */
      0xecbc94,	/* 켔 */
      0xecbc95,	/* 켕 */
      0xecbc96,	/* 켖 */
      0xecbc97,	/* 켗 */
      0xecbc98,	/* 켘 */
      0xecbc99,	/* 켙 */
      0xecbc9a,	/* 켚 */
      0xecbc9b,	/* 켛 */
    },
    {
      0xecbc9c,	/* 켜 */
      0xecbc9d,	/* 켝 */
      0xecbc9e,	/* 켞 */
      0xecbc9f,	/* 켟 */
      0xecbca0,	/* 켠 */
      0xecbca1,	/* 켡 */
      0xecbca2,	/* 켢 */
      0xecbca3,	/* 켣 */
      0xecbca4,	/* 켤 */
      0xecbca5,	/* 켥 */
      0xecbca6,	/* 켦 */
      0xecbca7,	/* 켧 */
      0xecbca8,	/* 켨 */
      0xecbca9,	/* 켩 */
      0xecbcaa,	/* 켪 */
      0xecbcab,	/* 켫 */
      0xecbcac,	/* 켬 */
      0xecbcad,	/* 켭 */
      0xecbcae,	/* 켮 */
      0xecbcaf,	/* 켯 */
      0xecbcb0,	/* 켰 */
      0xecbcb1,	/* 켱 */
      0xecbcb2,	/* 켲 */
      0xecbcb3,	/* 켳 */
      0xecbcb4,	/* 켴 */
      0xecbcb5,	/* 켵 */
      0xecbcb6,	/* 켶 */
      0xecbcb7,	/* 켷 */
    },
    {
      0xecbcb8,	/* 켸 */
      0xecbcb9,	/* 켹 */
      0xecbcba,	/* 켺 */
      0xecbcbb,	/* 켻 */
      0xecbcbc,	/* 켼 */
      0xecbcbd,	/* 켽 */
      0xecbcbe,	/* 켾 */
      0xecbcbf,	/* 켿 */
      0xecbd80,	/* 콀 */
      0xecbd81,	/* 콁 */
      0xecbd82,	/* 콂 */
      0xecbd83,	/* 콃 */
      0xecbd84,	/* 콄 */
      0xecbd85,	/* 콅 */
      0xecbd86,	/* 콆 */
      0xecbd87,	/* 콇 */
      0xecbd88,	/* 콈 */
      0xecbd89,	/* 콉 */
      0xecbd8a,	/* 콊 */
      0xecbd8b,	/* 콋 */
      0xecbd8c,	/* 콌 */
      0xecbd8d,	/* 콍 */
      0xecbd8e,	/* 콎 */
      0xecbd8f,	/* 콏 */
      0xecbd90,	/* 콐 */
      0xecbd91,	/* 콑 */
      0xecbd92,	/* 콒 */
      0xecbd93,	/* 콓 */
    },
    {
      0xecbd94,	/* 코 */
      0xecbd95,	/* 콕 */
      0xecbd96,	/* 콖 */
      0xecbd97,	/* 콗 */
      0xecbd98,	/* 콘 */
      0xecbd99,	/* 콙 */
      0xecbd9a,	/* 콚 */
      0xecbd9b,	/* 콛 */
      0xecbd9c,	/* 콜 */
      0xecbd9d,	/* 콝 */
      0xecbd9e,	/* 콞 */
      0xecbd9f,	/* 콟 */
      0xecbda0,	/* 콠 */
      0xecbda1,	/* 콡 */
      0xecbda2,	/* 콢 */
      0xecbda3,	/* 콣 */
      0xecbda4,	/* 콤 */
      0xecbda5,	/* 콥 */
      0xecbda6,	/* 콦 */
      0xecbda7,	/* 콧 */
      0xecbda8,	/* 콨 */
      0xecbda9,	/* 콩 */
      0xecbdaa,	/* 콪 */
      0xecbdab,	/* 콫 */
      0xecbdac,	/* 콬 */
      0xecbdad,	/* 콭 */
      0xecbdae,	/* 콮 */
      0xecbdaf,	/* 콯 */
    },
    {
      0xecbdb0,	/* 콰 */
      0xecbdb1,	/* 콱 */
      0xecbdb2,	/* 콲 */
      0xecbdb3,	/* 콳 */
      0xecbdb4,	/* 콴 */
      0xecbdb5,	/* 콵 */
      0xecbdb6,	/* 콶 */
      0xecbdb7,	/* 콷 */
      0xecbdb8,	/* 콸 */
      0xecbdb9,	/* 콹 */
      0xecbdba,	/* 콺 */
      0xecbdbb,	/* 콻 */
      0xecbdbc,	/* 콼 */
      0xecbdbd,	/* 콽 */
      0xecbdbe,	/* 콾 */
      0xecbdbf,	/* 콿 */
      0xecbe80,	/* 쾀 */
      0xecbe81,	/* 쾁 */
      0xecbe82,	/* 쾂 */
      0xecbe83,	/* 쾃 */
      0xecbe84,	/* 쾄 */
      0xecbe85,	/* 쾅 */
      0xecbe86,	/* 쾆 */
      0xecbe87,	/* 쾇 */
      0xecbe88,	/* 쾈 */
      0xecbe89,	/* 쾉 */
      0xecbe8a,	/* 쾊 */
      0xecbe8b,	/* 쾋 */
    },
    {
      0xecbe8c,	/* 쾌 */
      0xecbe8d,	/* 쾍 */
      0xecbe8e,	/* 쾎 */
      0xecbe8f,	/* 쾏 */
      0xecbe90,	/* 쾐 */
      0xecbe91,	/* 쾑 */
      0xecbe92,	/* 쾒 */
      0xecbe93,	/* 쾓 */
      0xecbe94,	/* 쾔 */
      0xecbe95,	/* 쾕 */
      0xecbe96,	/* 쾖 */
      0xecbe97,	/* 쾗 */
      0xecbe98,	/* 쾘 */
      0xecbe99,	/* 쾙 */
      0xecbe9a,	/* 쾚 */
      0xecbe9b,	/* 쾛 */
      0xecbe9c,	/* 쾜 */
      0xecbe9d,	/* 쾝 */
      0xecbe9e,	/* 쾞 */
      0xecbe9f,	/* 쾟 */
      0xecbea0,	/* 쾠 */
      0xecbea1,	/* 쾡 */
      0xecbea2,	/* 쾢 */
      0xecbea3,	/* 쾣 */
      0xecbea4,	/* 쾤 */
      0xecbea5,	/* 쾥 */
      0xecbea6,	/* 쾦 */
      0xecbea7,	/* 쾧 */
    },
    {
      0xecbea8,	/* 쾨 */
      0xecbea9,	/* 쾩 */
      0xecbeaa,	/* 쾪 */
      0xecbeab,	/* 쾫 */
      0xecbeac,	/* 쾬 */
      0xecbead,	/* 쾭 */
      0xecbeae,	/* 쾮 */
      0xecbeaf,	/* 쾯 */
      0xecbeb0,	/* 쾰 */
      0xecbeb1,	/* 쾱 */
      0xecbeb2,	/* 쾲 */
      0xecbeb3,	/* 쾳 */
      0xecbeb4,	/* 쾴 */
      0xecbeb5,	/* 쾵 */
      0xecbeb6,	/* 쾶 */
      0xecbeb7,	/* 쾷 */
      0xecbeb8,	/* 쾸 */
      0xecbeb9,	/* 쾹 */
      0xecbeba,	/* 쾺 */
      0xecbebb,	/* 쾻 */
      0xecbebc,	/* 쾼 */
      0xecbebd,	/* 쾽 */
      0xecbebe,	/* 쾾 */
      0xecbebf,	/* 쾿 */
      0xecbf80,	/* 쿀 */
      0xecbf81,	/* 쿁 */
      0xecbf82,	/* 쿂 */
      0xecbf83,	/* 쿃 */
    },
    {
      0xecbf84,	/* 쿄 */
      0xecbf85,	/* 쿅 */
      0xecbf86,	/* 쿆 */
      0xecbf87,	/* 쿇 */
      0xecbf88,	/* 쿈 */
      0xecbf89,	/* 쿉 */
      0xecbf8a,	/* 쿊 */
      0xecbf8b,	/* 쿋 */
      0xecbf8c,	/* 쿌 */
      0xecbf8d,	/* 쿍 */
      0xecbf8e,	/* 쿎 */
      0xecbf8f,	/* 쿏 */
      0xecbf90,	/* 쿐 */
      0xecbf91,	/* 쿑 */
      0xecbf92,	/* 쿒 */
      0xecbf93,	/* 쿓 */
      0xecbf94,	/* 쿔 */
      0xecbf95,	/* 쿕 */
      0xecbf96,	/* 쿖 */
      0xecbf97,	/* 쿗 */
      0xecbf98,	/* 쿘 */
      0xecbf99,	/* 쿙 */
      0xecbf9a,	/* 쿚 */
      0xecbf9b,	/* 쿛 */
      0xecbf9c,	/* 쿜 */
      0xecbf9d,	/* 쿝 */
      0xecbf9e,	/* 쿞 */
      0xecbf9f,	/* 쿟 */
    },
    {
      0xecbfa0,	/* 쿠 */
      0xecbfa1,	/* 쿡 */
      0xecbfa2,	/* 쿢 */
      0xecbfa3,	/* 쿣 */
      0xecbfa4,	/* 쿤 */
      0xecbfa5,	/* 쿥 */
      0xecbfa6,	/* 쿦 */
      0xecbfa7,	/* 쿧 */
      0xecbfa8,	/* 쿨 */
      0xecbfa9,	/* 쿩 */
      0xecbfaa,	/* 쿪 */
      0xecbfab,	/* 쿫 */
      0xecbfac,	/* 쿬 */
      0xecbfad,	/* 쿭 */
      0xecbfae,	/* 쿮 */
      0xecbfaf,	/* 쿯 */
      0xecbfb0,	/* 쿰 */
      0xecbfb1,	/* 쿱 */
      0xecbfb2,	/* 쿲 */
      0xecbfb3,	/* 쿳 */
      0xecbfb4,	/* 쿴 */
      0xecbfb5,	/* 쿵 */
      0xecbfb6,	/* 쿶 */
      0xecbfb7,	/* 쿷 */
      0xecbfb8,	/* 쿸 */
      0xecbfb9,	/* 쿹 */
      0xecbfba,	/* 쿺 */
      0xecbfbb,	/* 쿻 */
    },
    {
      0xecbfbc,	/* 쿼 */
      0xecbfbd,	/* 쿽 */
      0xecbfbe,	/* 쿾 */
      0xecbfbf,	/* 쿿 */
      0xed8080,	/* 퀀 */
      0xed8081,	/* 퀁 */
      0xed8082,	/* 퀂 */
      0xed8083,	/* 퀃 */
      0xed8084,	/* 퀄 */
      0xed8085,	/* 퀅 */
      0xed8086,	/* 퀆 */
      0xed8087,	/* 퀇 */
      0xed8088,	/* 퀈 */
      0xed8089,	/* 퀉 */
      0xed808a,	/* 퀊 */
      0xed808b,	/* 퀋 */
      0xed808c,	/* 퀌 */
      0xed808d,	/* 퀍 */
      0xed808e,	/* 퀎 */
      0xed808f,	/* 퀏 */
      0xed8090,	/* 퀐 */
      0xed8091,	/* 퀑 */
      0xed8092,	/* 퀒 */
      0xed8093,	/* 퀓 */
      0xed8094,	/* 퀔 */
      0xed8095,	/* 퀕 */
      0xed8096,	/* 퀖 */
      0xed8097,	/* 퀗 */
    },
    {
      0xed8098,	/* 퀘 */
      0xed8099,	/* 퀙 */
      0xed809a,	/* 퀚 */
      0xed809b,	/* 퀛 */
      0xed809c,	/* 퀜 */
      0xed809d,	/* 퀝 */
      0xed809e,	/* 퀞 */
      0xed809f,	/* 퀟 */
      0xed80a0,	/* 퀠 */
      0xed80a1,	/* 퀡 */
      0xed80a2,	/* 퀢 */
      0xed80a3,	/* 퀣 */
      0xed80a4,	/* 퀤 */
      0xed80a5,	/* 퀥 */
      0xed80a6,	/* 퀦 */
      0xed80a7,	/* 퀧 */
      0xed80a8,	/* 퀨 */
      0xed80a9,	/* 퀩 */
      0xed80aa,	/* 퀪 */
      0xed80ab,	/* 퀫 */
      0xed80ac,	/* 퀬 */
      0xed80ad,	/* 퀭 */
      0xed80ae,	/* 퀮 */
      0xed80af,	/* 퀯 */
      0xed80b0,	/* 퀰 */
      0xed80b1,	/* 퀱 */
      0xed80b2,	/* 퀲 */
      0xed80b3,	/* 퀳 */
    },
    {
      0xed80b4,	/* 퀴 */
      0xed80b5,	/* 퀵 */
      0xed80b6,	/* 퀶 */
      0xed80b7,	/* 퀷 */
      0xed80b8,	/* 퀸 */
      0xed80b9,	/* 퀹 */
      0xed80ba,	/* 퀺 */
      0xed80bb,	/* 퀻 */
      0xed80bc,	/* 퀼 */
      0xed80bd,	/* 퀽 */
      0xed80be,	/* 퀾 */
      0xed80bf,	/* 퀿 */
      0xed8180,	/* 큀 */
      0xed8181,	/* 큁 */
      0xed8182,	/* 큂 */
      0xed8183,	/* 큃 */
      0xed8184,	/* 큄 */
      0xed8185,	/* 큅 */
      0xed8186,	/* 큆 */
      0xed8187,	/* 큇 */
      0xed8188,	/* 큈 */
      0xed8189,	/* 큉 */
      0xed818a,	/* 큊 */
      0xed818b,	/* 큋 */
      0xed818c,	/* 큌 */
      0xed818d,	/* 큍 */
      0xed818e,	/* 큎 */
      0xed818f,	/* 큏 */
    },
    {
      0xed8190,	/* 큐 */
      0xed8191,	/* 큑 */
      0xed8192,	/* 큒 */
      0xed8193,	/* 큓 */
      0xed8194,	/* 큔 */
      0xed8195,	/* 큕 */
      0xed8196,	/* 큖 */
      0xed8197,	/* 큗 */
      0xed8198,	/* 큘 */
      0xed8199,	/* 큙 */
      0xed819a,	/* 큚 */
      0xed819b,	/* 큛 */
      0xed819c,	/* 큜 */
      0xed819d,	/* 큝 */
      0xed819e,	/* 큞 */
      0xed819f,	/* 큟 */
      0xed81a0,	/* 큠 */
      0xed81a1,	/* 큡 */
      0xed81a2,	/* 큢 */
      0xed81a3,	/* 큣 */
      0xed81a4,	/* 큤 */
      0xed81a5,	/* 큥 */
      0xed81a6,	/* 큦 */
      0xed81a7,	/* 큧 */
      0xed81a8,	/* 큨 */
      0xed81a9,	/* 큩 */
      0xed81aa,	/* 큪 */
      0xed81ab,	/* 큫 */
    },
    {
      0xed81ac,	/* 크 */
      0xed81ad,	/* 큭 */
      0xed81ae,	/* 큮 */
      0xed81af,	/* 큯 */
      0xed81b0,	/* 큰 */
      0xed81b1,	/* 큱 */
      0xed81b2,	/* 큲 */
      0xed81b3,	/* 큳 */
      0xed81b4,	/* 클 */
      0xed81b5,	/* 큵 */
      0xed81b6,	/* 큶 */
      0xed81b7,	/* 큷 */
      0xed81b8,	/* 큸 */
      0xed81b9,	/* 큹 */
      0xed81ba,	/* 큺 */
      0xed81bb,	/* 큻 */
      0xed81bc,	/* 큼 */
      0xed81bd,	/* 큽 */
      0xed81be,	/* 큾 */
      0xed81bf,	/* 큿 */
      0xed8280,	/* 킀 */
      0xed8281,	/* 킁 */
      0xed8282,	/* 킂 */
      0xed8283,	/* 킃 */
      0xed8284,	/* 킄 */
      0xed8285,	/* 킅 */
      0xed8286,	/* 킆 */
      0xed8287,	/* 킇 */
    },
    {
      0xed8288,	/* 킈 */
      0xed8289,	/* 킉 */
      0xed828a,	/* 킊 */
      0xed828b,	/* 킋 */
      0xed828c,	/* 킌 */
      0xed828d,	/* 킍 */
      0xed828e,	/* 킎 */
      0xed828f,	/* 킏 */
      0xed8290,	/* 킐 */
      0xed8291,	/* 킑 */
      0xed8292,	/* 킒 */
      0xed8293,	/* 킓 */
      0xed8294,	/* 킔 */
      0xed8295,	/* 킕 */
      0xed8296,	/* 킖 */
      0xed8297,	/* 킗 */
      0xed8298,	/* 킘 */
      0xed8299,	/* 킙 */
      0xed829a,	/* 킚 */
      0xed829b,	/* 킛 */
      0xed829c,	/* 킜 */
      0xed829d,	/* 킝 */
      0xed829e,	/* 킞 */
      0xed829f,	/* 킟 */
      0xed82a0,	/* 킠 */
      0xed82a1,	/* 킡 */
      0xed82a2,	/* 킢 */
      0xed82a3,	/* 킣 */
    },
    {
      0xed82a4,	/* 키 */
      0xed82a5,	/* 킥 */
      0xed82a6,	/* 킦 */
      0xed82a7,	/* 킧 */
      0xed82a8,	/* 킨 */
      0xed82a9,	/* 킩 */
      0xed82aa,	/* 킪 */
      0xed82ab,	/* 킫 */
      0xed82ac,	/* 킬 */
      0xed82ad,	/* 킭 */
      0xed82ae,	/* 킮 */
      0xed82af,	/* 킯 */
      0xed82b0,	/* 킰 */
      0xed82b1,	/* 킱 */
      0xed82b2,	/* 킲 */
      0xed82b3,	/* 킳 */
      0xed82b4,	/* 킴 */
      0xed82b5,	/* 킵 */
      0xed82b6,	/* 킶 */
      0xed82b7,	/* 킷 */
      0xed82b8,	/* 킸 */
      0xed82b9,	/* 킹 */
      0xed82ba,	/* 킺 */
      0xed82bb,	/* 킻 */
      0xed82bc,	/* 킼 */
      0xed82bd,	/* 킽 */
      0xed82be,	/* 킾 */
      0xed82bf,	/* 킿 */
    },
  },
  {
    {
      0xed8380,	/* 타 */
      0xed8381,	/* 탁 */
      0xed8382,	/* 탂 */
      0xed8383,	/* 탃 */
      0xed8384,	/* 탄 */
      0xed8385,	/* 탅 */
      0xed8386,	/* 탆 */
      0xed8387,	/* 탇 */
      0xed8388,	/* 탈 */
      0xed8389,	/* 탉 */
      0xed838a,	/* 탊 */
      0xed838b,	/* 탋 */
      0xed838c,	/* 탌 */
      0xed838d,	/* 탍 */
      0xed838e,	/* 탎 */
      0xed838f,	/* 탏 */
      0xed8390,	/* 탐 */
      0xed8391,	/* 탑 */
      0xed8392,	/* 탒 */
      0xed8393,	/* 탓 */
      0xed8394,	/* 탔 */
      0xed8395,	/* 탕 */
      0xed8396,	/* 탖 */
      0xed8397,	/* 탗 */
      0xed8398,	/* 탘 */
      0xed8399,	/* 탙 */
      0xed839a,	/* 탚 */
      0xed839b,	/* 탛 */
    },
    {
      0xed839c,	/* 태 */
      0xed839d,	/* 택 */
      0xed839e,	/* 탞 */
      0xed839f,	/* 탟 */
      0xed83a0,	/* 탠 */
      0xed83a1,	/* 탡 */
      0xed83a2,	/* 탢 */
      0xed83a3,	/* 탣 */
      0xed83a4,	/* 탤 */
      0xed83a5,	/* 탥 */
      0xed83a6,	/* 탦 */
      0xed83a7,	/* 탧 */
      0xed83a8,	/* 탨 */
      0xed83a9,	/* 탩 */
      0xed83aa,	/* 탪 */
      0xed83ab,	/* 탫 */
      0xed83ac,	/* 탬 */
      0xed83ad,	/* 탭 */
      0xed83ae,	/* 탮 */
      0xed83af,	/* 탯 */
      0xed83b0,	/* 탰 */
      0xed83b1,	/* 탱 */
      0xed83b2,	/* 탲 */
      0xed83b3,	/* 탳 */
      0xed83b4,	/* 탴 */
      0xed83b5,	/* 탵 */
      0xed83b6,	/* 탶 */
      0xed83b7,	/* 탷 */
    },
    {
      0xed83b8,	/* 탸 */
      0xed83b9,	/* 탹 */
      0xed83ba,	/* 탺 */
      0xed83bb,	/* 탻 */
      0xed83bc,	/* 탼 */
      0xed83bd,	/* 탽 */
      0xed83be,	/* 탾 */
      0xed83bf,	/* 탿 */
      0xed8480,	/* 턀 */
      0xed8481,	/* 턁 */
      0xed8482,	/* 턂 */
      0xed8483,	/* 턃 */
      0xed8484,	/* 턄 */
      0xed8485,	/* 턅 */
      0xed8486,	/* 턆 */
      0xed8487,	/* 턇 */
      0xed8488,	/* 턈 */
      0xed8489,	/* 턉 */
      0xed848a,	/* 턊 */
      0xed848b,	/* 턋 */
      0xed848c,	/* 턌 */
      0xed848d,	/* 턍 */
      0xed848e,	/* 턎 */
      0xed848f,	/* 턏 */
      0xed8490,	/* 턐 */
      0xed8491,	/* 턑 */
      0xed8492,	/* 턒 */
      0xed8493,	/* 턓 */
    },
    {
      0xed8494,	/* 턔 */
      0xed8495,	/* 턕 */
      0xed8496,	/* 턖 */
      0xed8497,	/* 턗 */
      0xed8498,	/* 턘 */
      0xed8499,	/* 턙 */
      0xed849a,	/* 턚 */
      0xed849b,	/* 턛 */
      0xed849c,	/* 턜 */
      0xed849d,	/* 턝 */
      0xed849e,	/* 턞 */
      0xed849f,	/* 턟 */
      0xed84a0,	/* 턠 */
      0xed84a1,	/* 턡 */
      0xed84a2,	/* 턢 */
      0xed84a3,	/* 턣 */
      0xed84a4,	/* 턤 */
      0xed84a5,	/* 턥 */
      0xed84a6,	/* 턦 */
      0xed84a7,	/* 턧 */
      0xed84a8,	/* 턨 */
      0xed84a9,	/* 턩 */
      0xed84aa,	/* 턪 */
      0xed84ab,	/* 턫 */
      0xed84ac,	/* 턬 */
      0xed84ad,	/* 턭 */
      0xed84ae,	/* 턮 */
      0xed84af,	/* 턯 */
    },
    {
      0xed84b0,	/* 터 */
      0xed84b1,	/* 턱 */
      0xed84b2,	/* 턲 */
      0xed84b3,	/* 턳 */
      0xed84b4,	/* 턴 */
      0xed84b5,	/* 턵 */
      0xed84b6,	/* 턶 */
      0xed84b7,	/* 턷 */
      0xed84b8,	/* 털 */
      0xed84b9,	/* 턹 */
      0xed84ba,	/* 턺 */
      0xed84bb,	/* 턻 */
      0xed84bc,	/* 턼 */
      0xed84bd,	/* 턽 */
      0xed84be,	/* 턾 */
      0xed84bf,	/* 턿 */
      0xed8580,	/* 텀 */
      0xed8581,	/* 텁 */
      0xed8582,	/* 텂 */
      0xed8583,	/* 텃 */
      0xed8584,	/* 텄 */
      0xed8585,	/* 텅 */
      0xed8586,	/* 텆 */
      0xed8587,	/* 텇 */
      0xed8588,	/* 텈 */
      0xed8589,	/* 텉 */
      0xed858a,	/* 텊 */
      0xed858b,	/* 텋 */
    },
    {
      0xed858c,	/* 테 */
      0xed858d,	/* 텍 */
      0xed858e,	/* 텎 */
      0xed858f,	/* 텏 */
      0xed8590,	/* 텐 */
      0xed8591,	/* 텑 */
      0xed8592,	/* 텒 */
      0xed8593,	/* 텓 */
      0xed8594,	/* 텔 */
      0xed8595,	/* 텕 */
      0xed8596,	/* 텖 */
      0xed8597,	/* 텗 */
      0xed8598,	/* 텘 */
      0xed8599,	/* 텙 */
      0xed859a,	/* 텚 */
      0xed859b,	/* 텛 */
      0xed859c,	/* 템 */
      0xed859d,	/* 텝 */
      0xed859e,	/* 텞 */
      0xed859f,	/* 텟 */
      0xed85a0,	/* 텠 */
      0xed85a1,	/* 텡 */
      0xed85a2,	/* 텢 */
      0xed85a3,	/* 텣 */
      0xed85a4,	/* 텤 */
      0xed85a5,	/* 텥 */
      0xed85a6,	/* 텦 */
      0xed85a7,	/* 텧 */
    },
    {
      0xed85a8,	/* 텨 */
      0xed85a9,	/* 텩 */
      0xed85aa,	/* 텪 */
      0xed85ab,	/* 텫 */
      0xed85ac,	/* 텬 */
      0xed85ad,	/* 텭 */
      0xed85ae,	/* 텮 */
      0xed85af,	/* 텯 */
      0xed85b0,	/* 텰 */
      0xed85b1,	/* 텱 */
      0xed85b2,	/* 텲 */
      0xed85b3,	/* 텳 */
      0xed85b4,	/* 텴 */
      0xed85b5,	/* 텵 */
      0xed85b6,	/* 텶 */
      0xed85b7,	/* 텷 */
      0xed85b8,	/* 텸 */
      0xed85b9,	/* 텹 */
      0xed85ba,	/* 텺 */
      0xed85bb,	/* 텻 */
      0xed85bc,	/* 텼 */
      0xed85bd,	/* 텽 */
      0xed85be,	/* 텾 */
      0xed85bf,	/* 텿 */
      0xed8680,	/* 톀 */
      0xed8681,	/* 톁 */
      0xed8682,	/* 톂 */
      0xed8683,	/* 톃 */
    },
    {
      0xed8684,	/* 톄 */
      0xed8685,	/* 톅 */
      0xed8686,	/* 톆 */
      0xed8687,	/* 톇 */
      0xed8688,	/* 톈 */
      0xed8689,	/* 톉 */
      0xed868a,	/* 톊 */
      0xed868b,	/* 톋 */
      0xed868c,	/* 톌 */
      0xed868d,	/* 톍 */
      0xed868e,	/* 톎 */
      0xed868f,	/* 톏 */
      0xed8690,	/* 톐 */
      0xed8691,	/* 톑 */
      0xed8692,	/* 톒 */
      0xed8693,	/* 톓 */
      0xed8694,	/* 톔 */
      0xed8695,	/* 톕 */
      0xed8696,	/* 톖 */
      0xed8697,	/* 톗 */
      0xed8698,	/* 톘 */
      0xed8699,	/* 톙 */
      0xed869a,	/* 톚 */
      0xed869b,	/* 톛 */
      0xed869c,	/* 톜 */
      0xed869d,	/* 톝 */
      0xed869e,	/* 톞 */
      0xed869f,	/* 톟 */
    },
    {
      0xed86a0,	/* 토 */
      0xed86a1,	/* 톡 */
      0xed86a2,	/* 톢 */
      0xed86a3,	/* 톣 */
      0xed86a4,	/* 톤 */
      0xed86a5,	/* 톥 */
      0xed86a6,	/* 톦 */
      0xed86a7,	/* 톧 */
      0xed86a8,	/* 톨 */
      0xed86a9,	/* 톩 */
      0xed86aa,	/* 톪 */
      0xed86ab,	/* 톫 */
      0xed86ac,	/* 톬 */
      0xed86ad,	/* 톭 */
      0xed86ae,	/* 톮 */
      0xed86af,	/* 톯 */
      0xed86b0,	/* 톰 */
      0xed86b1,	/* 톱 */
      0xed86b2,	/* 톲 */
      0xed86b3,	/* 톳 */
      0xed86b4,	/* 톴 */
      0xed86b5,	/* 통 */
      0xed86b6,	/* 톶 */
      0xed86b7,	/* 톷 */
      0xed86b8,	/* 톸 */
      0xed86b9,	/* 톹 */
      0xed86ba,	/* 톺 */
      0xed86bb,	/* 톻 */
    },
    {
      0xed86bc,	/* 톼 */
      0xed86bd,	/* 톽 */
      0xed86be,	/* 톾 */
      0xed86bf,	/* 톿 */
      0xed8780,	/* 퇀 */
      0xed8781,	/* 퇁 */
      0xed8782,	/* 퇂 */
      0xed8783,	/* 퇃 */
      0xed8784,	/* 퇄 */
      0xed8785,	/* 퇅 */
      0xed8786,	/* 퇆 */
      0xed8787,	/* 퇇 */
      0xed8788,	/* 퇈 */
      0xed8789,	/* 퇉 */
      0xed878a,	/* 퇊 */
      0xed878b,	/* 퇋 */
      0xed878c,	/* 퇌 */
      0xed878d,	/* 퇍 */
      0xed878e,	/* 퇎 */
      0xed878f,	/* 퇏 */
      0xed8790,	/* 퇐 */
      0xed8791,	/* 퇑 */
      0xed8792,	/* 퇒 */
      0xed8793,	/* 퇓 */
      0xed8794,	/* 퇔 */
      0xed8795,	/* 퇕 */
      0xed8796,	/* 퇖 */
      0xed8797,	/* 퇗 */
    },
    {
      0xed8798,	/* 퇘 */
      0xed8799,	/* 퇙 */
      0xed879a,	/* 퇚 */
      0xed879b,	/* 퇛 */
      0xed879c,	/* 퇜 */
      0xed879d,	/* 퇝 */
      0xed879e,	/* 퇞 */
      0xed879f,	/* 퇟 */
      0xed87a0,	/* 퇠 */
      0xed87a1,	/* 퇡 */
      0xed87a2,	/* 퇢 */
      0xed87a3,	/* 퇣 */
      0xed87a4,	/* 퇤 */
      0xed87a5,	/* 퇥 */
      0xed87a6,	/* 퇦 */
      0xed87a7,	/* 퇧 */
      0xed87a8,	/* 퇨 */
      0xed87a9,	/* 퇩 */
      0xed87aa,	/* 퇪 */
      0xed87ab,	/* 퇫 */
      0xed87ac,	/* 퇬 */
      0xed87ad,	/* 퇭 */
      0xed87ae,	/* 퇮 */
      0xed87af,	/* 퇯 */
      0xed87b0,	/* 퇰 */
      0xed87b1,	/* 퇱 */
      0xed87b2,	/* 퇲 */
      0xed87b3,	/* 퇳 */
    },
    {
      0xed87b4,	/* 퇴 */
      0xed87b5,	/* 퇵 */
      0xed87b6,	/* 퇶 */
      0xed87b7,	/* 퇷 */
      0xed87b8,	/* 퇸 */
      0xed87b9,	/* 퇹 */
      0xed87ba,	/* 퇺 */
      0xed87bb,	/* 퇻 */
      0xed87bc,	/* 퇼 */
      0xed87bd,	/* 퇽 */
      0xed87be,	/* 퇾 */
      0xed87bf,	/* 퇿 */
      0xed8880,	/* 툀 */
      0xed8881,	/* 툁 */
      0xed8882,	/* 툂 */
      0xed8883,	/* 툃 */
      0xed8884,	/* 툄 */
      0xed8885,	/* 툅 */
      0xed8886,	/* 툆 */
      0xed8887,	/* 툇 */
      0xed8888,	/* 툈 */
      0xed8889,	/* 툉 */
      0xed888a,	/* 툊 */
      0xed888b,	/* 툋 */
      0xed888c,	/* 툌 */
      0xed888d,	/* 툍 */
      0xed888e,	/* 툎 */
      0xed888f,	/* 툏 */
    },
    {
      0xed8890,	/* 툐 */
      0xed8891,	/* 툑 */
      0xed8892,	/* 툒 */
      0xed8893,	/* 툓 */
      0xed8894,	/* 툔 */
      0xed8895,	/* 툕 */
      0xed8896,	/* 툖 */
      0xed8897,	/* 툗 */
      0xed8898,	/* 툘 */
      0xed8899,	/* 툙 */
      0xed889a,	/* 툚 */
      0xed889b,	/* 툛 */
      0xed889c,	/* 툜 */
      0xed889d,	/* 툝 */
      0xed889e,	/* 툞 */
      0xed889f,	/* 툟 */
      0xed88a0,	/* 툠 */
      0xed88a1,	/* 툡 */
      0xed88a2,	/* 툢 */
      0xed88a3,	/* 툣 */
      0xed88a4,	/* 툤 */
      0xed88a5,	/* 툥 */
      0xed88a6,	/* 툦 */
      0xed88a7,	/* 툧 */
      0xed88a8,	/* 툨 */
      0xed88a9,	/* 툩 */
      0xed88aa,	/* 툪 */
      0xed88ab,	/* 툫 */
    },
    {
      0xed88ac,	/* 투 */
      0xed88ad,	/* 툭 */
      0xed88ae,	/* 툮 */
      0xed88af,	/* 툯 */
      0xed88b0,	/* 툰 */
      0xed88b1,	/* 툱 */
      0xed88b2,	/* 툲 */
      0xed88b3,	/* 툳 */
      0xed88b4,	/* 툴 */
      0xed88b5,	/* 툵 */
      0xed88b6,	/* 툶 */
      0xed88b7,	/* 툷 */
      0xed88b8,	/* 툸 */
      0xed88b9,	/* 툹 */
      0xed88ba,	/* 툺 */
      0xed88bb,	/* 툻 */
      0xed88bc,	/* 툼 */
      0xed88bd,	/* 툽 */
      0xed88be,	/* 툾 */
      0xed88bf,	/* 툿 */
      0xed8980,	/* 퉀 */
      0xed8981,	/* 퉁 */
      0xed8982,	/* 퉂 */
      0xed8983,	/* 퉃 */
      0xed8984,	/* 퉄 */
      0xed8985,	/* 퉅 */
      0xed8986,	/* 퉆 */
      0xed8987,	/* 퉇 */
    },
    {
      0xed8988,	/* 퉈 */
      0xed8989,	/* 퉉 */
      0xed898a,	/* 퉊 */
      0xed898b,	/* 퉋 */
      0xed898c,	/* 퉌 */
      0xed898d,	/* 퉍 */
      0xed898e,	/* 퉎 */
      0xed898f,	/* 퉏 */
      0xed8990,	/* 퉐 */
      0xed8991,	/* 퉑 */
      0xed8992,	/* 퉒 */
      0xed8993,	/* 퉓 */
      0xed8994,	/* 퉔 */
      0xed8995,	/* 퉕 */
      0xed8996,	/* 퉖 */
      0xed8997,	/* 퉗 */
      0xed8998,	/* 퉘 */
      0xed8999,	/* 퉙 */
      0xed899a,	/* 퉚 */
      0xed899b,	/* 퉛 */
      0xed899c,	/* 퉜 */
      0xed899d,	/* 퉝 */
      0xed899e,	/* 퉞 */
      0xed899f,	/* 퉟 */
      0xed89a0,	/* 퉠 */
      0xed89a1,	/* 퉡 */
      0xed89a2,	/* 퉢 */
      0xed89a3,	/* 퉣 */
    },
    {
      0xed89a4,	/* 퉤 */
      0xed89a5,	/* 퉥 */
      0xed89a6,	/* 퉦 */
      0xed89a7,	/* 퉧 */
      0xed89a8,	/* 퉨 */
      0xed89a9,	/* 퉩 */
      0xed89aa,	/* 퉪 */
      0xed89ab,	/* 퉫 */
      0xed89ac,	/* 퉬 */
      0xed89ad,	/* 퉭 */
      0xed89ae,	/* 퉮 */
      0xed89af,	/* 퉯 */
      0xed89b0,	/* 퉰 */
      0xed89b1,	/* 퉱 */
      0xed89b2,	/* 퉲 */
      0xed89b3,	/* 퉳 */
      0xed89b4,	/* 퉴 */
      0xed89b5,	/* 퉵 */
      0xed89b6,	/* 퉶 */
      0xed89b7,	/* 퉷 */
      0xed89b8,	/* 퉸 */
      0xed89b9,	/* 퉹 */
      0xed89ba,	/* 퉺 */
      0xed89bb,	/* 퉻 */
      0xed89bc,	/* 퉼 */
      0xed89bd,	/* 퉽 */
      0xed89be,	/* 퉾 */
      0xed89bf,	/* 퉿 */
    },
    {
      0xed8a80,	/* 튀 */
      0xed8a81,	/* 튁 */
      0xed8a82,	/* 튂 */
      0xed8a83,	/* 튃 */
      0xed8a84,	/* 튄 */
      0xed8a85,	/* 튅 */
      0xed8a86,	/* 튆 */
      0xed8a87,	/* 튇 */
      0xed8a88,	/* 튈 */
      0xed8a89,	/* 튉 */
      0xed8a8a,	/* 튊 */
      0xed8a8b,	/* 튋 */
      0xed8a8c,	/* 튌 */
      0xed8a8d,	/* 튍 */
      0xed8a8e,	/* 튎 */
      0xed8a8f,	/* 튏 */
      0xed8a90,	/* 튐 */
      0xed8a91,	/* 튑 */
      0xed8a92,	/* 튒 */
      0xed8a93,	/* 튓 */
      0xed8a94,	/* 튔 */
      0xed8a95,	/* 튕 */
      0xed8a96,	/* 튖 */
      0xed8a97,	/* 튗 */
      0xed8a98,	/* 튘 */
      0xed8a99,	/* 튙 */
      0xed8a9a,	/* 튚 */
      0xed8a9b,	/* 튛 */
    },
    {
      0xed8a9c,	/* 튜 */
      0xed8a9d,	/* 튝 */
      0xed8a9e,	/* 튞 */
      0xed8a9f,	/* 튟 */
      0xed8aa0,	/* 튠 */
      0xed8aa1,	/* 튡 */
      0xed8aa2,	/* 튢 */
      0xed8aa3,	/* 튣 */
      0xed8aa4,	/* 튤 */
      0xed8aa5,	/* 튥 */
      0xed8aa6,	/* 튦 */
      0xed8aa7,	/* 튧 */
      0xed8aa8,	/* 튨 */
      0xed8aa9,	/* 튩 */
      0xed8aaa,	/* 튪 */
      0xed8aab,	/* 튫 */
      0xed8aac,	/* 튬 */
      0xed8aad,	/* 튭 */
      0xed8aae,	/* 튮 */
      0xed8aaf,	/* 튯 */
      0xed8ab0,	/* 튰 */
      0xed8ab1,	/* 튱 */
      0xed8ab2,	/* 튲 */
      0xed8ab3,	/* 튳 */
      0xed8ab4,	/* 튴 */
      0xed8ab5,	/* 튵 */
      0xed8ab6,	/* 튶 */
      0xed8ab7,	/* 튷 */
    },
    {
      0xed8ab8,	/* 트 */
      0xed8ab9,	/* 특 */
      0xed8aba,	/* 튺 */
      0xed8abb,	/* 튻 */
      0xed8abc,	/* 튼 */
      0xed8abd,	/* 튽 */
      0xed8abe,	/* 튾 */
      0xed8abf,	/* 튿 */
      0xed8b80,	/* 틀 */
      0xed8b81,	/* 틁 */
      0xed8b82,	/* 틂 */
      0xed8b83,	/* 틃 */
      0xed8b84,	/* 틄 */
      0xed8b85,	/* 틅 */
      0xed8b86,	/* 틆 */
      0xed8b87,	/* 틇 */
      0xed8b88,	/* 틈 */
      0xed8b89,	/* 틉 */
      0xed8b8a,	/* 틊 */
      0xed8b8b,	/* 틋 */
      0xed8b8c,	/* 틌 */
      0xed8b8d,	/* 틍 */
      0xed8b8e,	/* 틎 */
      0xed8b8f,	/* 틏 */
      0xed8b90,	/* 틐 */
      0xed8b91,	/* 틑 */
      0xed8b92,	/* 틒 */
      0xed8b93,	/* 틓 */
    },
    {
      0xed8b94,	/* 틔 */
      0xed8b95,	/* 틕 */
      0xed8b96,	/* 틖 */
      0xed8b97,	/* 틗 */
      0xed8b98,	/* 틘 */
      0xed8b99,	/* 틙 */
      0xed8b9a,	/* 틚 */
      0xed8b9b,	/* 틛 */
      0xed8b9c,	/* 틜 */
      0xed8b9d,	/* 틝 */
      0xed8b9e,	/* 틞 */
      0xed8b9f,	/* 틟 */
      0xed8ba0,	/* 틠 */
      0xed8ba1,	/* 틡 */
      0xed8ba2,	/* 틢 */
      0xed8ba3,	/* 틣 */
      0xed8ba4,	/* 틤 */
      0xed8ba5,	/* 틥 */
      0xed8ba6,	/* 틦 */
      0xed8ba7,	/* 틧 */
      0xed8ba8,	/* 틨 */
      0xed8ba9,	/* 틩 */
      0xed8baa,	/* 틪 */
      0xed8bab,	/* 틫 */
      0xed8bac,	/* 틬 */
      0xed8bad,	/* 틭 */
      0xed8bae,	/* 틮 */
      0xed8baf,	/* 틯 */
    },
    {
      0xed8bb0,	/* 티 */
      0xed8bb1,	/* 틱 */
      0xed8bb2,	/* 틲 */
      0xed8bb3,	/* 틳 */
      0xed8bb4,	/* 틴 */
      0xed8bb5,	/* 틵 */
      0xed8bb6,	/* 틶 */
      0xed8bb7,	/* 틷 */
      0xed8bb8,	/* 틸 */
      0xed8bb9,	/* 틹 */
      0xed8bba,	/* 틺 */
      0xed8bbb,	/* 틻 */
      0xed8bbc,	/* 틼 */
      0xed8bbd,	/* 틽 */
      0xed8bbe,	/* 틾 */
      0xed8bbf,	/* 틿 */
      0xed8c80,	/* 팀 */
      0xed8c81,	/* 팁 */
      0xed8c82,	/* 팂 */
      0xed8c83,	/* 팃 */
      0xed8c84,	/* 팄 */
      0xed8c85,	/* 팅 */
      0xed8c86,	/* 팆 */
      0xed8c87,	/* 팇 */
      0xed8c88,	/* 팈 */
      0xed8c89,	/* 팉 */
      0xed8c8a,	/* 팊 */
      0xed8c8b,	/* 팋 */
    },
  },
  {
    {
      0xed8c8c,	/* 파 */
      0xed8c8d,	/* 팍 */
      0xed8c8e,	/* 팎 */
      0xed8c8f,	/* 팏 */
      0xed8c90,	/* 판 */
      0xed8c91,	/* 팑 */
      0xed8c92,	/* 팒 */
      0xed8c93,	/* 팓 */
      0xed8c94,	/* 팔 */
      0xed8c95,	/* 팕 */
      0xed8c96,	/* 팖 */
      0xed8c97,	/* 팗 */
      0xed8c98,	/* 팘 */
      0xed8c99,	/* 팙 */
      0xed8c9a,	/* 팚 */
      0xed8c9b,	/* 팛 */
      0xed8c9c,	/* 팜 */
      0xed8c9d,	/* 팝 */
      0xed8c9e,	/* 팞 */
      0xed8c9f,	/* 팟 */
      0xed8ca0,	/* 팠 */
      0xed8ca1,	/* 팡 */
      0xed8ca2,	/* 팢 */
      0xed8ca3,	/* 팣 */
      0xed8ca4,	/* 팤 */
      0xed8ca5,	/* 팥 */
      0xed8ca6,	/* 팦 */
      0xed8ca7,	/* 팧 */
    },
    {
      0xed8ca8,	/* 패 */
      0xed8ca9,	/* 팩 */
      0xed8caa,	/* 팪 */
      0xed8cab,	/* 팫 */
      0xed8cac,	/* 팬 */
      0xed8cad,	/* 팭 */
      0xed8cae,	/* 팮 */
      0xed8caf,	/* 팯 */
      0xed8cb0,	/* 팰 */
      0xed8cb1,	/* 팱 */
      0xed8cb2,	/* 팲 */
      0xed8cb3,	/* 팳 */
      0xed8cb4,	/* 팴 */
      0xed8cb5,	/* 팵 */
      0xed8cb6,	/* 팶 */
      0xed8cb7,	/* 팷 */
      0xed8cb8,	/* 팸 */
      0xed8cb9,	/* 팹 */
      0xed8cba,	/* 팺 */
      0xed8cbb,	/* 팻 */
      0xed8cbc,	/* 팼 */
      0xed8cbd,	/* 팽 */
      0xed8cbe,	/* 팾 */
      0xed8cbf,	/* 팿 */
      0xed8d80,	/* 퍀 */
      0xed8d81,	/* 퍁 */
      0xed8d82,	/* 퍂 */
      0xed8d83,	/* 퍃 */
    },
    {
      0xed8d84,	/* 퍄 */
      0xed8d85,	/* 퍅 */
      0xed8d86,	/* 퍆 */
      0xed8d87,	/* 퍇 */
      0xed8d88,	/* 퍈 */
      0xed8d89,	/* 퍉 */
      0xed8d8a,	/* 퍊 */
      0xed8d8b,	/* 퍋 */
      0xed8d8c,	/* 퍌 */
      0xed8d8d,	/* 퍍 */
      0xed8d8e,	/* 퍎 */
      0xed8d8f,	/* 퍏 */
      0xed8d90,	/* 퍐 */
      0xed8d91,	/* 퍑 */
      0xed8d92,	/* 퍒 */
      0xed8d93,	/* 퍓 */
      0xed8d94,	/* 퍔 */
      0xed8d95,	/* 퍕 */
      0xed8d96,	/* 퍖 */
      0xed8d97,	/* 퍗 */
      0xed8d98,	/* 퍘 */
      0xed8d99,	/* 퍙 */
      0xed8d9a,	/* 퍚 */
      0xed8d9b,	/* 퍛 */
      0xed8d9c,	/* 퍜 */
      0xed8d9d,	/* 퍝 */
      0xed8d9e,	/* 퍞 */
      0xed8d9f,	/* 퍟 */
    },
    {
      0xed8da0,	/* 퍠 */
      0xed8da1,	/* 퍡 */
      0xed8da2,	/* 퍢 */
      0xed8da3,	/* 퍣 */
      0xed8da4,	/* 퍤 */
      0xed8da5,	/* 퍥 */
      0xed8da6,	/* 퍦 */
      0xed8da7,	/* 퍧 */
      0xed8da8,	/* 퍨 */
      0xed8da9,	/* 퍩 */
      0xed8daa,	/* 퍪 */
      0xed8dab,	/* 퍫 */
      0xed8dac,	/* 퍬 */
      0xed8dad,	/* 퍭 */
      0xed8dae,	/* 퍮 */
      0xed8daf,	/* 퍯 */
      0xed8db0,	/* 퍰 */
      0xed8db1,	/* 퍱 */
      0xed8db2,	/* 퍲 */
      0xed8db3,	/* 퍳 */
      0xed8db4,	/* 퍴 */
      0xed8db5,	/* 퍵 */
      0xed8db6,	/* 퍶 */
      0xed8db7,	/* 퍷 */
      0xed8db8,	/* 퍸 */
      0xed8db9,	/* 퍹 */
      0xed8dba,	/* 퍺 */
      0xed8dbb,	/* 퍻 */
    },
    {
      0xed8dbc,	/* 퍼 */
      0xed8dbd,	/* 퍽 */
      0xed8dbe,	/* 퍾 */
      0xed8dbf,	/* 퍿 */
      0xed8e80,	/* 펀 */
      0xed8e81,	/* 펁 */
      0xed8e82,	/* 펂 */
      0xed8e83,	/* 펃 */
      0xed8e84,	/* 펄 */
      0xed8e85,	/* 펅 */
      0xed8e86,	/* 펆 */
      0xed8e87,	/* 펇 */
      0xed8e88,	/* 펈 */
      0xed8e89,	/* 펉 */
      0xed8e8a,	/* 펊 */
      0xed8e8b,	/* 펋 */
      0xed8e8c,	/* 펌 */
      0xed8e8d,	/* 펍 */
      0xed8e8e,	/* 펎 */
      0xed8e8f,	/* 펏 */
      0xed8e90,	/* 펐 */
      0xed8e91,	/* 펑 */
      0xed8e92,	/* 펒 */
      0xed8e93,	/* 펓 */
      0xed8e94,	/* 펔 */
      0xed8e95,	/* 펕 */
      0xed8e96,	/* 펖 */
      0xed8e97,	/* 펗 */
    },
    {
      0xed8e98,	/* 페 */
      0xed8e99,	/* 펙 */
      0xed8e9a,	/* 펚 */
      0xed8e9b,	/* 펛 */
      0xed8e9c,	/* 펜 */
      0xed8e9d,	/* 펝 */
      0xed8e9e,	/* 펞 */
      0xed8e9f,	/* 펟 */
      0xed8ea0,	/* 펠 */
      0xed8ea1,	/* 펡 */
      0xed8ea2,	/* 펢 */
      0xed8ea3,	/* 펣 */
      0xed8ea4,	/* 펤 */
      0xed8ea5,	/* 펥 */
      0xed8ea6,	/* 펦 */
      0xed8ea7,	/* 펧 */
      0xed8ea8,	/* 펨 */
      0xed8ea9,	/* 펩 */
      0xed8eaa,	/* 펪 */
      0xed8eab,	/* 펫 */
      0xed8eac,	/* 펬 */
      0xed8ead,	/* 펭 */
      0xed8eae,	/* 펮 */
      0xed8eaf,	/* 펯 */
      0xed8eb0,	/* 펰 */
      0xed8eb1,	/* 펱 */
      0xed8eb2,	/* 펲 */
      0xed8eb3,	/* 펳 */
    },
    {
      0xed8eb4,	/* 펴 */
      0xed8eb5,	/* 펵 */
      0xed8eb6,	/* 펶 */
      0xed8eb7,	/* 펷 */
      0xed8eb8,	/* 편 */
      0xed8eb9,	/* 펹 */
      0xed8eba,	/* 펺 */
      0xed8ebb,	/* 펻 */
      0xed8ebc,	/* 펼 */
      0xed8ebd,	/* 펽 */
      0xed8ebe,	/* 펾 */
      0xed8ebf,	/* 펿 */
      0xed8f80,	/* 폀 */
      0xed8f81,	/* 폁 */
      0xed8f82,	/* 폂 */
      0xed8f83,	/* 폃 */
      0xed8f84,	/* 폄 */
      0xed8f85,	/* 폅 */
      0xed8f86,	/* 폆 */
      0xed8f87,	/* 폇 */
      0xed8f88,	/* 폈 */
      0xed8f89,	/* 평 */
      0xed8f8a,	/* 폊 */
      0xed8f8b,	/* 폋 */
      0xed8f8c,	/* 폌 */
      0xed8f8d,	/* 폍 */
      0xed8f8e,	/* 폎 */
      0xed8f8f,	/* 폏 */
    },
    {
      0xed8f90,	/* 폐 */
      0xed8f91,	/* 폑 */
      0xed8f92,	/* 폒 */
      0xed8f93,	/* 폓 */
      0xed8f94,	/* 폔 */
      0xed8f95,	/* 폕 */
      0xed8f96,	/* 폖 */
      0xed8f97,	/* 폗 */
      0xed8f98,	/* 폘 */
      0xed8f99,	/* 폙 */
      0xed8f9a,	/* 폚 */
      0xed8f9b,	/* 폛 */
      0xed8f9c,	/* 폜 */
      0xed8f9d,	/* 폝 */
      0xed8f9e,	/* 폞 */
      0xed8f9f,	/* 폟 */
      0xed8fa0,	/* 폠 */
      0xed8fa1,	/* 폡 */
      0xed8fa2,	/* 폢 */
      0xed8fa3,	/* 폣 */
      0xed8fa4,	/* 폤 */
      0xed8fa5,	/* 폥 */
      0xed8fa6,	/* 폦 */
      0xed8fa7,	/* 폧 */
      0xed8fa8,	/* 폨 */
      0xed8fa9,	/* 폩 */
      0xed8faa,	/* 폪 */
      0xed8fab,	/* 폫 */
    },
    {
      0xed8fac,	/* 포 */
      0xed8fad,	/* 폭 */
      0xed8fae,	/* 폮 */
      0xed8faf,	/* 폯 */
      0xed8fb0,	/* 폰 */
      0xed8fb1,	/* 폱 */
      0xed8fb2,	/* 폲 */
      0xed8fb3,	/* 폳 */
      0xed8fb4,	/* 폴 */
      0xed8fb5,	/* 폵 */
      0xed8fb6,	/* 폶 */
      0xed8fb7,	/* 폷 */
      0xed8fb8,	/* 폸 */
      0xed8fb9,	/* 폹 */
      0xed8fba,	/* 폺 */
      0xed8fbb,	/* 폻 */
      0xed8fbc,	/* 폼 */
      0xed8fbd,	/* 폽 */
      0xed8fbe,	/* 폾 */
      0xed8fbf,	/* 폿 */
      0xed9080,	/* 퐀 */
      0xed9081,	/* 퐁 */
      0xed9082,	/* 퐂 */
      0xed9083,	/* 퐃 */
      0xed9084,	/* 퐄 */
      0xed9085,	/* 퐅 */
      0xed9086,	/* 퐆 */
      0xed9087,	/* 퐇 */
    },
    {
      0xed9088,	/* 퐈 */
      0xed9089,	/* 퐉 */
      0xed908a,	/* 퐊 */
      0xed908b,	/* 퐋 */
      0xed908c,	/* 퐌 */
      0xed908d,	/* 퐍 */
      0xed908e,	/* 퐎 */
      0xed908f,	/* 퐏 */
      0xed9090,	/* 퐐 */
      0xed9091,	/* 퐑 */
      0xed9092,	/* 퐒 */
      0xed9093,	/* 퐓 */
      0xed9094,	/* 퐔 */
      0xed9095,	/* 퐕 */
      0xed9096,	/* 퐖 */
      0xed9097,	/* 퐗 */
      0xed9098,	/* 퐘 */
      0xed9099,	/* 퐙 */
      0xed909a,	/* 퐚 */
      0xed909b,	/* 퐛 */
      0xed909c,	/* 퐜 */
      0xed909d,	/* 퐝 */
      0xed909e,	/* 퐞 */
      0xed909f,	/* 퐟 */
      0xed90a0,	/* 퐠 */
      0xed90a1,	/* 퐡 */
      0xed90a2,	/* 퐢 */
      0xed90a3,	/* 퐣 */
    },
    {
      0xed90a4,	/* 퐤 */
      0xed90a5,	/* 퐥 */
      0xed90a6,	/* 퐦 */
      0xed90a7,	/* 퐧 */
      0xed90a8,	/* 퐨 */
      0xed90a9,	/* 퐩 */
      0xed90aa,	/* 퐪 */
      0xed90ab,	/* 퐫 */
      0xed90ac,	/* 퐬 */
      0xed90ad,	/* 퐭 */
      0xed90ae,	/* 퐮 */
      0xed90af,	/* 퐯 */
      0xed90b0,	/* 퐰 */
      0xed90b1,	/* 퐱 */
      0xed90b2,	/* 퐲 */
      0xed90b3,	/* 퐳 */
      0xed90b4,	/* 퐴 */
      0xed90b5,	/* 퐵 */
      0xed90b6,	/* 퐶 */
      0xed90b7,	/* 퐷 */
      0xed90b8,	/* 퐸 */
      0xed90b9,	/* 퐹 */
      0xed90ba,	/* 퐺 */
      0xed90bb,	/* 퐻 */
      0xed90bc,	/* 퐼 */
      0xed90bd,	/* 퐽 */
      0xed90be,	/* 퐾 */
      0xed90bf,	/* 퐿 */
    },
    {
      0xed9180,	/* 푀 */
      0xed9181,	/* 푁 */
      0xed9182,	/* 푂 */
      0xed9183,	/* 푃 */
      0xed9184,	/* 푄 */
      0xed9185,	/* 푅 */
      0xed9186,	/* 푆 */
      0xed9187,	/* 푇 */
      0xed9188,	/* 푈 */
      0xed9189,	/* 푉 */
      0xed918a,	/* 푊 */
      0xed918b,	/* 푋 */
      0xed918c,	/* 푌 */
      0xed918d,	/* 푍 */
      0xed918e,	/* 푎 */
      0xed918f,	/* 푏 */
      0xed9190,	/* 푐 */
      0xed9191,	/* 푑 */
      0xed9192,	/* 푒 */
      0xed9193,	/* 푓 */
      0xed9194,	/* 푔 */
      0xed9195,	/* 푕 */
      0xed9196,	/* 푖 */
      0xed9197,	/* 푗 */
      0xed9198,	/* 푘 */
      0xed9199,	/* 푙 */
      0xed919a,	/* 푚 */
      0xed919b,	/* 푛 */
    },
    {
      0xed919c,	/* 표 */
      0xed919d,	/* 푝 */
      0xed919e,	/* 푞 */
      0xed919f,	/* 푟 */
      0xed91a0,	/* 푠 */
      0xed91a1,	/* 푡 */
      0xed91a2,	/* 푢 */
      0xed91a3,	/* 푣 */
      0xed91a4,	/* 푤 */
      0xed91a5,	/* 푥 */
      0xed91a6,	/* 푦 */
      0xed91a7,	/* 푧 */
      0xed91a8,	/* 푨 */
      0xed91a9,	/* 푩 */
      0xed91aa,	/* 푪 */
      0xed91ab,	/* 푫 */
      0xed91ac,	/* 푬 */
      0xed91ad,	/* 푭 */
      0xed91ae,	/* 푮 */
      0xed91af,	/* 푯 */
      0xed91b0,	/* 푰 */
      0xed91b1,	/* 푱 */
      0xed91b2,	/* 푲 */
      0xed91b3,	/* 푳 */
      0xed91b4,	/* 푴 */
      0xed91b5,	/* 푵 */
      0xed91b6,	/* 푶 */
      0xed91b7,	/* 푷 */
    },
    {
      0xed91b8,	/* 푸 */
      0xed91b9,	/* 푹 */
      0xed91ba,	/* 푺 */
      0xed91bb,	/* 푻 */
      0xed91bc,	/* 푼 */
      0xed91bd,	/* 푽 */
      0xed91be,	/* 푾 */
      0xed91bf,	/* 푿 */
      0xed9280,	/* 풀 */
      0xed9281,	/* 풁 */
      0xed9282,	/* 풂 */
      0xed9283,	/* 풃 */
      0xed9284,	/* 풄 */
      0xed9285,	/* 풅 */
      0xed9286,	/* 풆 */
      0xed9287,	/* 풇 */
      0xed9288,	/* 품 */
      0xed9289,	/* 풉 */
      0xed928a,	/* 풊 */
      0xed928b,	/* 풋 */
      0xed928c,	/* 풌 */
      0xed928d,	/* 풍 */
      0xed928e,	/* 풎 */
      0xed928f,	/* 풏 */
      0xed9290,	/* 풐 */
      0xed9291,	/* 풑 */
      0xed9292,	/* 풒 */
      0xed9293,	/* 풓 */
    },
    {
      0xed9294,	/* 풔 */
      0xed9295,	/* 풕 */
      0xed9296,	/* 풖 */
      0xed9297,	/* 풗 */
      0xed9298,	/* 풘 */
      0xed9299,	/* 풙 */
      0xed929a,	/* 풚 */
      0xed929b,	/* 풛 */
      0xed929c,	/* 풜 */
      0xed929d,	/* 풝 */
      0xed929e,	/* 풞 */
      0xed929f,	/* 풟 */
      0xed92a0,	/* 풠 */
      0xed92a1,	/* 풡 */
      0xed92a2,	/* 풢 */
      0xed92a3,	/* 풣 */
      0xed92a4,	/* 풤 */
      0xed92a5,	/* 풥 */
      0xed92a6,	/* 풦 */
      0xed92a7,	/* 풧 */
      0xed92a8,	/* 풨 */
      0xed92a9,	/* 풩 */
      0xed92aa,	/* 풪 */
      0xed92ab,	/* 풫 */
      0xed92ac,	/* 풬 */
      0xed92ad,	/* 풭 */
      0xed92ae,	/* 풮 */
      0xed92af,	/* 풯 */
    },
    {
      0xed92b0,	/* 풰 */
      0xed92b1,	/* 풱 */
      0xed92b2,	/* 풲 */
      0xed92b3,	/* 풳 */
      0xed92b4,	/* 풴 */
      0xed92b5,	/* 풵 */
      0xed92b6,	/* 풶 */
      0xed92b7,	/* 풷 */
      0xed92b8,	/* 풸 */
      0xed92b9,	/* 풹 */
      0xed92ba,	/* 풺 */
      0xed92bb,	/* 풻 */
      0xed92bc,	/* 풼 */
      0xed92bd,	/* 풽 */
      0xed92be,	/* 풾 */
      0xed92bf,	/* 풿 */
      0xed9380,	/* 퓀 */
      0xed9381,	/* 퓁 */
      0xed9382,	/* 퓂 */
      0xed9383,	/* 퓃 */
      0xed9384,	/* 퓄 */
      0xed9385,	/* 퓅 */
      0xed9386,	/* 퓆 */
      0xed9387,	/* 퓇 */
      0xed9388,	/* 퓈 */
      0xed9389,	/* 퓉 */
      0xed938a,	/* 퓊 */
      0xed938b,	/* 퓋 */
    },
    {
      0xed938c,	/* 퓌 */
      0xed938d,	/* 퓍 */
      0xed938e,	/* 퓎 */
      0xed938f,	/* 퓏 */
      0xed9390,	/* 퓐 */
      0xed9391,	/* 퓑 */
      0xed9392,	/* 퓒 */
      0xed9393,	/* 퓓 */
      0xed9394,	/* 퓔 */
      0xed9395,	/* 퓕 */
      0xed9396,	/* 퓖 */
      0xed9397,	/* 퓗 */
      0xed9398,	/* 퓘 */
      0xed9399,	/* 퓙 */
      0xed939a,	/* 퓚 */
      0xed939b,	/* 퓛 */
      0xed939c,	/* 퓜 */
      0xed939d,	/* 퓝 */
      0xed939e,	/* 퓞 */
      0xed939f,	/* 퓟 */
      0xed93a0,	/* 퓠 */
      0xed93a1,	/* 퓡 */
      0xed93a2,	/* 퓢 */
      0xed93a3,	/* 퓣 */
      0xed93a4,	/* 퓤 */
      0xed93a5,	/* 퓥 */
      0xed93a6,	/* 퓦 */
      0xed93a7,	/* 퓧 */
    },
    {
      0xed93a8,	/* 퓨 */
      0xed93a9,	/* 퓩 */
      0xed93aa,	/* 퓪 */
      0xed93ab,	/* 퓫 */
      0xed93ac,	/* 퓬 */
      0xed93ad,	/* 퓭 */
      0xed93ae,	/* 퓮 */
      0xed93af,	/* 퓯 */
      0xed93b0,	/* 퓰 */
      0xed93b1,	/* 퓱 */
      0xed93b2,	/* 퓲 */
      0xed93b3,	/* 퓳 */
      0xed93b4,	/* 퓴 */
      0xed93b5,	/* 퓵 */
      0xed93b6,	/* 퓶 */
      0xed93b7,	/* 퓷 */
      0xed93b8,	/* 퓸 */
      0xed93b9,	/* 퓹 */
      0xed93ba,	/* 퓺 */
      0xed93bb,	/* 퓻 */
      0xed93bc,	/* 퓼 */
      0xed93bd,	/* 퓽 */
      0xed93be,	/* 퓾 */
      0xed93bf,	/* 퓿 */
      0xed9480,	/* 픀 */
      0xed9481,	/* 픁 */
      0xed9482,	/* 픂 */
      0xed9483,	/* 픃 */
    },
    {
      0xed9484,	/* 프 */
      0xed9485,	/* 픅 */
      0xed9486,	/* 픆 */
      0xed9487,	/* 픇 */
      0xed9488,	/* 픈 */
      0xed9489,	/* 픉 */
      0xed948a,	/* 픊 */
      0xed948b,	/* 픋 */
      0xed948c,	/* 플 */
      0xed948d,	/* 픍 */
      0xed948e,	/* 픎 */
      0xed948f,	/* 픏 */
      0xed9490,	/* 픐 */
      0xed9491,	/* 픑 */
      0xed9492,	/* 픒 */
      0xed9493,	/* 픓 */
      0xed9494,	/* 픔 */
      0xed9495,	/* 픕 */
      0xed9496,	/* 픖 */
      0xed9497,	/* 픗 */
      0xed9498,	/* 픘 */
      0xed9499,	/* 픙 */
      0xed949a,	/* 픚 */
      0xed949b,	/* 픛 */
      0xed949c,	/* 픜 */
      0xed949d,	/* 픝 */
      0xed949e,	/* 픞 */
      0xed949f,	/* 픟 */
    },
    {
      0xed94a0,	/* 픠 */
      0xed94a1,	/* 픡 */
      0xed94a2,	/* 픢 */
      0xed94a3,	/* 픣 */
      0xed94a4,	/* 픤 */
      0xed94a5,	/* 픥 */
      0xed94a6,	/* 픦 */
      0xed94a7,	/* 픧 */
      0xed94a8,	/* 픨 */
      0xed94a9,	/* 픩 */
      0xed94aa,	/* 픪 */
      0xed94ab,	/* 픫 */
      0xed94ac,	/* 픬 */
      0xed94ad,	/* 픭 */
      0xed94ae,	/* 픮 */
      0xed94af,	/* 픯 */
      0xed94b0,	/* 픰 */
      0xed94b1,	/* 픱 */
      0xed94b2,	/* 픲 */
      0xed94b3,	/* 픳 */
      0xed94b4,	/* 픴 */
      0xed94b5,	/* 픵 */
      0xed94b6,	/* 픶 */
      0xed94b7,	/* 픷 */
      0xed94b8,	/* 픸 */
      0xed94b9,	/* 픹 */
      0xed94ba,	/* 픺 */
      0xed94bb,	/* 픻 */
    },
    {
      0xed94bc,	/* 피 */
      0xed94bd,	/* 픽 */
      0xed94be,	/* 픾 */
      0xed94bf,	/* 픿 */
      0xed9580,	/* 핀 */
      0xed9581,	/* 핁 */
      0xed9582,	/* 핂 */
      0xed9583,	/* 핃 */
      0xed9584,	/* 필 */
      0xed9585,	/* 핅 */
      0xed9586,	/* 핆 */
      0xed9587,	/* 핇 */
      0xed9588,	/* 핈 */
      0xed9589,	/* 핉 */
      0xed958a,	/* 핊 */
      0xed958b,	/* 핋 */
      0xed958c,	/* 핌 */
      0xed958d,	/* 핍 */
      0xed958e,	/* 핎 */
      0xed958f,	/* 핏 */
      0xed9590,	/* 핐 */
      0xed9591,	/* 핑 */
      0xed9592,	/* 핒 */
      0xed9593,	/* 핓 */
      0xed9594,	/* 핔 */
      0xed9595,	/* 핕 */
      0xed9596,	/* 핖 */
      0xed9597,	/* 핗 */
    },
  },
  {
    {
      0xed9598,	/* 하 */
      0xed9599,	/* 학 */
      0xed959a,	/* 핚 */
      0xed959b,	/* 핛 */
      0xed959c,	/* 한 */
      0xed959d,	/* 핝 */
      0xed959e,	/* 핞 */
      0xed959f,	/* 핟 */
      0xed95a0,	/* 할 */
      0xed95a1,	/* 핡 */
      0xed95a2,	/* 핢 */
      0xed95a3,	/* 핣 */
      0xed95a4,	/* 핤 */
      0xed95a5,	/* 핥 */
      0xed95a6,	/* 핦 */
      0xed95a7,	/* 핧 */
      0xed95a8,	/* 함 */
      0xed95a9,	/* 합 */
      0xed95aa,	/* 핪 */
      0xed95ab,	/* 핫 */
      0xed95ac,	/* 핬 */
      0xed95ad,	/* 항 */
      0xed95ae,	/* 핮 */
      0xed95af,	/* 핯 */
      0xed95b0,	/* 핰 */
      0xed95b1,	/* 핱 */
      0xed95b2,	/* 핲 */
      0xed95b3,	/* 핳 */
    },
    {
      0xed95b4,	/* 해 */
      0xed95b5,	/* 핵 */
      0xed95b6,	/* 핶 */
      0xed95b7,	/* 핷 */
      0xed95b8,	/* 핸 */
      0xed95b9,	/* 핹 */
      0xed95ba,	/* 핺 */
      0xed95bb,	/* 핻 */
      0xed95bc,	/* 핼 */
      0xed95bd,	/* 핽 */
      0xed95be,	/* 핾 */
      0xed95bf,	/* 핿 */
      0xed9680,	/* 햀 */
      0xed9681,	/* 햁 */
      0xed9682,	/* 햂 */
      0xed9683,	/* 햃 */
      0xed9684,	/* 햄 */
      0xed9685,	/* 햅 */
      0xed9686,	/* 햆 */
      0xed9687,	/* 햇 */
      0xed9688,	/* 했 */
      0xed9689,	/* 행 */
      0xed968a,	/* 햊 */
      0xed968b,	/* 햋 */
      0xed968c,	/* 햌 */
      0xed968d,	/* 햍 */
      0xed968e,	/* 햎 */
      0xed968f,	/* 햏 */
    },
    {
      0xed9690,	/* 햐 */
      0xed9691,	/* 햑 */
      0xed9692,	/* 햒 */
      0xed9693,	/* 햓 */
      0xed9694,	/* 햔 */
      0xed9695,	/* 햕 */
      0xed9696,	/* 햖 */
      0xed9697,	/* 햗 */
      0xed9698,	/* 햘 */
      0xed9699,	/* 햙 */
      0xed969a,	/* 햚 */
      0xed969b,	/* 햛 */
      0xed969c,	/* 햜 */
      0xed969d,	/* 햝 */
      0xed969e,	/* 햞 */
      0xed969f,	/* 햟 */
      0xed96a0,	/* 햠 */
      0xed96a1,	/* 햡 */
      0xed96a2,	/* 햢 */
      0xed96a3,	/* 햣 */
      0xed96a4,	/* 햤 */
      0xed96a5,	/* 향 */
      0xed96a6,	/* 햦 */
      0xed96a7,	/* 햧 */
      0xed96a8,	/* 햨 */
      0xed96a9,	/* 햩 */
      0xed96aa,	/* 햪 */
      0xed96ab,	/* 햫 */
    },
    {
      0xed96ac,	/* 햬 */
      0xed96ad,	/* 햭 */
      0xed96ae,	/* 햮 */
      0xed96af,	/* 햯 */
      0xed96b0,	/* 햰 */
      0xed96b1,	/* 햱 */
      0xed96b2,	/* 햲 */
      0xed96b3,	/* 햳 */
      0xed96b4,	/* 햴 */
      0xed96b5,	/* 햵 */
      0xed96b6,	/* 햶 */
      0xed96b7,	/* 햷 */
      0xed96b8,	/* 햸 */
      0xed96b9,	/* 햹 */
      0xed96ba,	/* 햺 */
      0xed96bb,	/* 햻 */
      0xed96bc,	/* 햼 */
      0xed96bd,	/* 햽 */
      0xed96be,	/* 햾 */
      0xed96bf,	/* 햿 */
      0xed9780,	/* 헀 */
      0xed9781,	/* 헁 */
      0xed9782,	/* 헂 */
      0xed9783,	/* 헃 */
      0xed9784,	/* 헄 */
      0xed9785,	/* 헅 */
      0xed9786,	/* 헆 */
      0xed9787,	/* 헇 */
    },
    {
      0xed9788,	/* 허 */
      0xed9789,	/* 헉 */
      0xed978a,	/* 헊 */
      0xed978b,	/* 헋 */
      0xed978c,	/* 헌 */
      0xed978d,	/* 헍 */
      0xed978e,	/* 헎 */
      0xed978f,	/* 헏 */
      0xed9790,	/* 헐 */
      0xed9791,	/* 헑 */
      0xed9792,	/* 헒 */
      0xed9793,	/* 헓 */
      0xed9794,	/* 헔 */
      0xed9795,	/* 헕 */
      0xed9796,	/* 헖 */
      0xed9797,	/* 헗 */
      0xed9798,	/* 험 */
      0xed9799,	/* 헙 */
      0xed979a,	/* 헚 */
      0xed979b,	/* 헛 */
      0xed979c,	/* 헜 */
      0xed979d,	/* 헝 */
      0xed979e,	/* 헞 */
      0xed979f,	/* 헟 */
      0xed97a0,	/* 헠 */
      0xed97a1,	/* 헡 */
      0xed97a2,	/* 헢 */
      0xed97a3,	/* 헣 */
    },
    {
      0xed97a4,	/* 헤 */
      0xed97a5,	/* 헥 */
      0xed97a6,	/* 헦 */
      0xed97a7,	/* 헧 */
      0xed97a8,	/* 헨 */
      0xed97a9,	/* 헩 */
      0xed97aa,	/* 헪 */
      0xed97ab,	/* 헫 */
      0xed97ac,	/* 헬 */
      0xed97ad,	/* 헭 */
      0xed97ae,	/* 헮 */
      0xed97af,	/* 헯 */
      0xed97b0,	/* 헰 */
      0xed97b1,	/* 헱 */
      0xed97b2,	/* 헲 */
      0xed97b3,	/* 헳 */
      0xed97b4,	/* 헴 */
      0xed97b5,	/* 헵 */
      0xed97b6,	/* 헶 */
      0xed97b7,	/* 헷 */
      0xed97b8,	/* 헸 */
      0xed97b9,	/* 헹 */
      0xed97ba,	/* 헺 */
      0xed97bb,	/* 헻 */
      0xed97bc,	/* 헼 */
      0xed97bd,	/* 헽 */
      0xed97be,	/* 헾 */
      0xed97bf,	/* 헿 */
    },
    {
      0xed9880,	/* 혀 */
      0xed9881,	/* 혁 */
      0xed9882,	/* 혂 */
      0xed9883,	/* 혃 */
      0xed9884,	/* 현 */
      0xed9885,	/* 혅 */
      0xed9886,	/* 혆 */
      0xed9887,	/* 혇 */
      0xed9888,	/* 혈 */
      0xed9889,	/* 혉 */
      0xed988a,	/* 혊 */
      0xed988b,	/* 혋 */
      0xed988c,	/* 혌 */
      0xed988d,	/* 혍 */
      0xed988e,	/* 혎 */
      0xed988f,	/* 혏 */
      0xed9890,	/* 혐 */
      0xed9891,	/* 협 */
      0xed9892,	/* 혒 */
      0xed9893,	/* 혓 */
      0xed9894,	/* 혔 */
      0xed9895,	/* 형 */
      0xed9896,	/* 혖 */
      0xed9897,	/* 혗 */
      0xed9898,	/* 혘 */
      0xed9899,	/* 혙 */
      0xed989a,	/* 혚 */
      0xed989b,	/* 혛 */
    },
    {
      0xed989c,	/* 혜 */
      0xed989d,	/* 혝 */
      0xed989e,	/* 혞 */
      0xed989f,	/* 혟 */
      0xed98a0,	/* 혠 */
      0xed98a1,	/* 혡 */
      0xed98a2,	/* 혢 */
      0xed98a3,	/* 혣 */
      0xed98a4,	/* 혤 */
      0xed98a5,	/* 혥 */
      0xed98a6,	/* 혦 */
      0xed98a7,	/* 혧 */
      0xed98a8,	/* 혨 */
      0xed98a9,	/* 혩 */
      0xed98aa,	/* 혪 */
      0xed98ab,	/* 혫 */
      0xed98ac,	/* 혬 */
      0xed98ad,	/* 혭 */
      0xed98ae,	/* 혮 */
      0xed98af,	/* 혯 */
      0xed98b0,	/* 혰 */
      0xed98b1,	/* 혱 */
      0xed98b2,	/* 혲 */
      0xed98b3,	/* 혳 */
      0xed98b4,	/* 혴 */
      0xed98b5,	/* 혵 */
      0xed98b6,	/* 혶 */
      0xed98b7,	/* 혷 */
    },
    {
      0xed98b8,	/* 호 */
      0xed98b9,	/* 혹 */
      0xed98ba,	/* 혺 */
      0xed98bb,	/* 혻 */
      0xed98bc,	/* 혼 */
      0xed98bd,	/* 혽 */
      0xed98be,	/* 혾 */
      0xed98bf,	/* 혿 */
      0xed9980,	/* 홀 */
      0xed9981,	/* 홁 */
      0xed9982,	/* 홂 */
      0xed9983,	/* 홃 */
      0xed9984,	/* 홄 */
      0xed9985,	/* 홅 */
      0xed9986,	/* 홆 */
      0xed9987,	/* 홇 */
      0xed9988,	/* 홈 */
      0xed9989,	/* 홉 */
      0xed998a,	/* 홊 */
      0xed998b,	/* 홋 */
      0xed998c,	/* 홌 */
      0xed998d,	/* 홍 */
      0xed998e,	/* 홎 */
      0xed998f,	/* 홏 */
      0xed9990,	/* 홐 */
      0xed9991,	/* 홑 */
      0xed9992,	/* 홒 */
      0xed9993,	/* 홓 */
    },
    {
      0xed9994,	/* 화 */
      0xed9995,	/* 확 */
      0xed9996,	/* 홖 */
      0xed9997,	/* 홗 */
      0xed9998,	/* 환 */
      0xed9999,	/* 홙 */
      0xed999a,	/* 홚 */
      0xed999b,	/* 홛 */
      0xed999c,	/* 활 */
      0xed999d,	/* 홝 */
      0xed999e,	/* 홞 */
      0xed999f,	/* 홟 */
      0xed99a0,	/* 홠 */
      0xed99a1,	/* 홡 */
      0xed99a2,	/* 홢 */
      0xed99a3,	/* 홣 */
      0xed99a4,	/* 홤 */
      0xed99a5,	/* 홥 */
      0xed99a6,	/* 홦 */
      0xed99a7,	/* 홧 */
      0xed99a8,	/* 홨 */
      0xed99a9,	/* 황 */
      0xed99aa,	/* 홪 */
      0xed99ab,	/* 홫 */
      0xed99ac,	/* 홬 */
      0xed99ad,	/* 홭 */
      0xed99ae,	/* 홮 */
      0xed99af,	/* 홯 */
    },
    {
      0xed99b0,	/* 홰 */
      0xed99b1,	/* 홱 */
      0xed99b2,	/* 홲 */
      0xed99b3,	/* 홳 */
      0xed99b4,	/* 홴 */
      0xed99b5,	/* 홵 */
      0xed99b6,	/* 홶 */
      0xed99b7,	/* 홷 */
      0xed99b8,	/* 홸 */
      0xed99b9,	/* 홹 */
      0xed99ba,	/* 홺 */
      0xed99bb,	/* 홻 */
      0xed99bc,	/* 홼 */
      0xed99bd,	/* 홽 */
      0xed99be,	/* 홾 */
      0xed99bf,	/* 홿 */
      0xed9a80,	/* 횀 */
      0xed9a81,	/* 횁 */
      0xed9a82,	/* 횂 */
      0xed9a83,	/* 횃 */
      0xed9a84,	/* 횄 */
      0xed9a85,	/* 횅 */
      0xed9a86,	/* 횆 */
      0xed9a87,	/* 횇 */
      0xed9a88,	/* 횈 */
      0xed9a89,	/* 횉 */
      0xed9a8a,	/* 횊 */
      0xed9a8b,	/* 횋 */
    },
    {
      0xed9a8c,	/* 회 */
      0xed9a8d,	/* 획 */
      0xed9a8e,	/* 횎 */
      0xed9a8f,	/* 횏 */
      0xed9a90,	/* 횐 */
      0xed9a91,	/* 횑 */
      0xed9a92,	/* 횒 */
      0xed9a93,	/* 횓 */
      0xed9a94,	/* 횔 */
      0xed9a95,	/* 횕 */
      0xed9a96,	/* 횖 */
      0xed9a97,	/* 횗 */
      0xed9a98,	/* 횘 */
      0xed9a99,	/* 횙 */
      0xed9a9a,	/* 횚 */
      0xed9a9b,	/* 횛 */
      0xed9a9c,	/* 횜 */
      0xed9a9d,	/* 횝 */
      0xed9a9e,	/* 횞 */
      0xed9a9f,	/* 횟 */
      0xed9aa0,	/* 횠 */
      0xed9aa1,	/* 횡 */
      0xed9aa2,	/* 횢 */
      0xed9aa3,	/* 횣 */
      0xed9aa4,	/* 횤 */
      0xed9aa5,	/* 횥 */
      0xed9aa6,	/* 횦 */
      0xed9aa7,	/* 횧 */
    },
    {
      0xed9aa8,	/* 효 */
      0xed9aa9,	/* 횩 */
      0xed9aaa,	/* 횪 */
      0xed9aab,	/* 횫 */
      0xed9aac,	/* 횬 */
      0xed9aad,	/* 횭 */
      0xed9aae,	/* 횮 */
      0xed9aaf,	/* 횯 */
      0xed9ab0,	/* 횰 */
      0xed9ab1,	/* 횱 */
      0xed9ab2,	/* 횲 */
      0xed9ab3,	/* 횳 */
      0xed9ab4,	/* 횴 */
      0xed9ab5,	/* 횵 */
      0xed9ab6,	/* 횶 */
      0xed9ab7,	/* 횷 */
      0xed9ab8,	/* 횸 */
      0xed9ab9,	/* 횹 */
      0xed9aba,	/* 횺 */
      0xed9abb,	/* 횻 */
      0xed9abc,	/* 횼 */
      0xed9abd,	/* 횽 */
      0xed9abe,	/* 횾 */
      0xed9abf,	/* 횿 */
      0xed9b80,	/* 훀 */
      0xed9b81,	/* 훁 */
      0xed9b82,	/* 훂 */
      0xed9b83,	/* 훃 */
    },
    {
      0xed9b84,	/* 후 */
      0xed9b85,	/* 훅 */
      0xed9b86,	/* 훆 */
      0xed9b87,	/* 훇 */
      0xed9b88,	/* 훈 */
      0xed9b89,	/* 훉 */
      0xed9b8a,	/* 훊 */
      0xed9b8b,	/* 훋 */
      0xed9b8c,	/* 훌 */
      0xed9b8d,	/* 훍 */
      0xed9b8e,	/* 훎 */
      0xed9b8f,	/* 훏 */
      0xed9b90,	/* 훐 */
      0xed9b91,	/* 훑 */
      0xed9b92,	/* 훒 */
      0xed9b93,	/* 훓 */
      0xed9b94,	/* 훔 */
      0xed9b95,	/* 훕 */
      0xed9b96,	/* 훖 */
      0xed9b97,	/* 훗 */
      0xed9b98,	/* 훘 */
      0xed9b99,	/* 훙 */
      0xed9b9a,	/* 훚 */
      0xed9b9b,	/* 훛 */
      0xed9b9c,	/* 훜 */
      0xed9b9d,	/* 훝 */
      0xed9b9e,	/* 훞 */
      0xed9b9f,	/* 훟 */
    },
    {
      0xed9ba0,	/* 훠 */
      0xed9ba1,	/* 훡 */
      0xed9ba2,	/* 훢 */
      0xed9ba3,	/* 훣 */
      0xed9ba4,	/* 훤 */
      0xed9ba5,	/* 훥 */
      0xed9ba6,	/* 훦 */
      0xed9ba7,	/* 훧 */
      0xed9ba8,	/* 훨 */
      0xed9ba9,	/* 훩 */
      0xed9baa,	/* 훪 */
      0xed9bab,	/* 훫 */
      0xed9bac,	/* 훬 */
      0xed9bad,	/* 훭 */
      0xed9bae,	/* 훮 */
      0xed9baf,	/* 훯 */
      0xed9bb0,	/* 훰 */
      0xed9bb1,	/* 훱 */
      0xed9bb2,	/* 훲 */
      0xed9bb3,	/* 훳 */
      0xed9bb4,	/* 훴 */
      0xed9bb5,	/* 훵 */
      0xed9bb6,	/* 훶 */
      0xed9bb7,	/* 훷 */
      0xed9bb8,	/* 훸 */
      0xed9bb9,	/* 훹 */
      0xed9bba,	/* 훺 */
      0xed9bbb,	/* 훻 */
    },
    {
      0xed9bbc,	/* 훼 */
      0xed9bbd,	/* 훽 */
      0xed9bbe,	/* 훾 */
      0xed9bbf,	/* 훿 */
      0xed9c80,	/* 휀 */
      0xed9c81,	/* 휁 */
      0xed9c82,	/* 휂 */
      0xed9c83,	/* 휃 */
      0xed9c84,	/* 휄 */
      0xed9c85,	/* 휅 */
      0xed9c86,	/* 휆 */
      0xed9c87,	/* 휇 */
      0xed9c88,	/* 휈 */
      0xed9c89,	/* 휉 */
      0xed9c8a,	/* 휊 */
      0xed9c8b,	/* 휋 */
      0xed9c8c,	/* 휌 */
      0xed9c8d,	/* 휍 */
      0xed9c8e,	/* 휎 */
      0xed9c8f,	/* 휏 */
      0xed9c90,	/* 휐 */
      0xed9c91,	/* 휑 */
      0xed9c92,	/* 휒 */
      0xed9c93,	/* 휓 */
      0xed9c94,	/* 휔 */
      0xed9c95,	/* 휕 */
      0xed9c96,	/* 휖 */
      0xed9c97,	/* 휗 */
    },
    {
      0xed9c98,	/* 휘 */
      0xed9c99,	/* 휙 */
      0xed9c9a,	/* 휚 */
      0xed9c9b,	/* 휛 */
      0xed9c9c,	/* 휜 */
      0xed9c9d,	/* 휝 */
      0xed9c9e,	/* 휞 */
      0xed9c9f,	/* 휟 */
      0xed9ca0,	/* 휠 */
      0xed9ca1,	/* 휡 */
      0xed9ca2,	/* 휢 */
      0xed9ca3,	/* 휣 */
      0xed9ca4,	/* 휤 */
      0xed9ca5,	/* 휥 */
      0xed9ca6,	/* 휦 */
      0xed9ca7,	/* 휧 */
      0xed9ca8,	/* 휨 */
      0xed9ca9,	/* 휩 */
      0xed9caa,	/* 휪 */
      0xed9cab,	/* 휫 */
      0xed9cac,	/* 휬 */
      0xed9cad,	/* 휭 */
      0xed9cae,	/* 휮 */
      0xed9caf,	/* 휯 */
      0xed9cb0,	/* 휰 */
      0xed9cb1,	/* 휱 */
      0xed9cb2,	/* 휲 */
      0xed9cb3,	/* 휳 */
    },
    {
      0xed9cb4,	/* 휴 */
      0xed9cb5,	/* 휵 */
      0xed9cb6,	/* 휶 */
      0xed9cb7,	/* 휷 */
      0xed9cb8,	/* 휸 */
      0xed9cb9,	/* 휹 */
      0xed9cba,	/* 휺 */
      0xed9cbb,	/* 휻 */
      0xed9cbc,	/* 휼 */
      0xed9cbd,	/* 휽 */
      0xed9cbe,	/* 휾 */
      0xed9cbf,	/* 휿 */
      0xed9d80,	/* 흀 */
      0xed9d81,	/* 흁 */
      0xed9d82,	/* 흂 */
      0xed9d83,	/* 흃 */
      0xed9d84,	/* 흄 */
      0xed9d85,	/* 흅 */
      0xed9d86,	/* 흆 */
      0xed9d87,	/* 흇 */
      0xed9d88,	/* 흈 */
      0xed9d89,	/* 흉 */
      0xed9d8a,	/* 흊 */
      0xed9d8b,	/* 흋 */
      0xed9d8c,	/* 흌 */
      0xed9d8d,	/* 흍 */
      0xed9d8e,	/* 흎 */
      0xed9d8f,	/* 흏 */
    },
    {
      0xed9d90,	/* 흐 */
      0xed9d91,	/* 흑 */
      0xed9d92,	/* 흒 */
      0xed9d93,	/* 흓 */
      0xed9d94,	/* 흔 */
      0xed9d95,	/* 흕 */
      0xed9d96,	/* 흖 */
      0xed9d97,	/* 흗 */
      0xed9d98,	/* 흘 */
      0xed9d99,	/* 흙 */
      0xed9d9a,	/* 흚 */
      0xed9d9b,	/* 흛 */
      0xed9d9c,	/* 흜 */
      0xed9d9d,	/* 흝 */
      0xed9d9e,	/* 흞 */
      0xed9d9f,	/* 흟 */
      0xed9da0,	/* 흠 */
      0xed9da1,	/* 흡 */
      0xed9da2,	/* 흢 */
      0xed9da3,	/* 흣 */
      0xed9da4,	/* 흤 */
      0xed9da5,	/* 흥 */
      0xed9da6,	/* 흦 */
      0xed9da7,	/* 흧 */
      0xed9da8,	/* 흨 */
      0xed9da9,	/* 흩 */
      0xed9daa,	/* 흪 */
      0xed9dab,	/* 흫 */
    },
    {
      0xed9dac,	/* 희 */
      0xed9dad,	/* 흭 */
      0xed9dae,	/* 흮 */
      0xed9daf,	/* 흯 */
      0xed9db0,	/* 흰 */
      0xed9db1,	/* 흱 */
      0xed9db2,	/* 흲 */
      0xed9db3,	/* 흳 */
      0xed9db4,	/* 흴 */
      0xed9db5,	/* 흵 */
      0xed9db6,	/* 흶 */
      0xed9db7,	/* 흷 */
      0xed9db8,	/* 흸 */
      0xed9db9,	/* 흹 */
      0xed9dba,	/* 흺 */
      0xed9dbb,	/* 흻 */
      0xed9dbc,	/* 흼 */
      0xed9dbd,	/* 흽 */
      0xed9dbe,	/* 흾 */
      0xed9dbf,	/* 흿 */
      0xed9e80,	/* 힀 */
      0xed9e81,	/* 힁 */
      0xed9e82,	/* 힂 */
      0xed9e83,	/* 힃 */
      0xed9e84,	/* 힄 */
      0xed9e85,	/* 힅 */
      0xed9e86,	/* 힆 */
      0xed9e87,	/* 힇 */
    },
    {
      0xed9e88,	/* 히 */
      0xed9e89,	/* 힉 */
      0xed9e8a,	/* 힊 */
      0xed9e8b,	/* 힋 */
      0xed9e8c,	/* 힌 */
      0xed9e8d,	/* 힍 */
      0xed9e8e,	/* 힎 */
      0xed9e8f,	/* 힏 */
      0xed9e90,	/* 힐 */
      0xed9e91,	/* 힑 */
      0xed9e92,	/* 힒 */
      0xed9e93,	/* 힓 */
      0xed9e94,	/* 힔 */
      0xed9e95,	/* 힕 */
      0xed9e96,	/* 힖 */
      0xed9e97,	/* 힗 */
      0xed9e98,	/* 힘 */
      0xed9e99,	/* 힙 */
      0xed9e9a,	/* 힚 */
      0xed9e9b,	/* 힛 */
      0xed9e9c,	/* 힜 */
      0xed9e9d,	/* 힝 */
      0xed9e9e,	/* 힞 */
      0xed9e9f,	/* 힟 */
      0xed9ea0,	/* 힠 */
      0xed9ea1,	/* 힡 */
      0xed9ea2,	/* 힢 */
      0xed9ea3,	/* 힣 */
    },
  },
};
