/* HRE  main ҽ.
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

/* 
   ѱ  ǥ ̺귯

     Ϸ մϴ.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include "hre_core.h"
#include "hlib.h"
#include "mslib.h"
#include "lexical.h"
#include "debug.h"
#include "timevar.h"

/* Ľ ̺ν ڰ Է  ǥ ؼϸ鼭 ν  token  
   ó ϴ 迭̴.
   
   Yacc    ǥ ǥ ְ , ٸ  ̽  ,
   ̷ Ľ ̺      ȿ̶  Ͽ ̷
   ۼϿ.
 
    ڿ ǹ̴ Lexer   ؼ  token  ǹϸ, X  Ǿ ִ
     ó   κ̴.

    迭 ̴ stack_tag  ̿ ݵ ƾ Ѵ.  ̺ 迭 ̸
     ݵ hre_core.h  stack_tag  Ѵ.  

    ̺ hre_change_action () Լ   Ȳ ´ ˸´  ϴµ
   ȴ.    tag    Ѵٸ Ʒ .

     RULE    :   tag   ,  tag ε,  ֻ tag 
                 ִ.
     PAR     : Ÿ `('  `)' ̿   ִ ǥĿ  action ̺
               Ѵ.
     LPAR    :   ʴ tag ̴.
     OPT     : Ÿ `['  `]' ̿   ִ ǥĿ  action ̺
               Ѵ.
     OR      : `(abc|d)'   ǥĿ Ǵ |   ǥ ̴̺.
     BAR     : Ÿ `['  `]' ̿  `[a-z]'   ǥĿ Ǵ
               action ̴̺.
     CORON   :   ʴ tag ̴.
     COMMA   :   ʴ tag ̴.
     AND     : `ab'    ǥ  , a  b ̿ &  ٰ
               Ǵµ, ̿  ǥ  action ̴̺.
     SSAC    :   ʴ tag ̴.
     HAN     : Ÿ `['  `]' ̿  ѱ  ǥ `<'  `>' ̿
                 ִ   ̴.
     HAN_COMMA
             : ѱ  ǥ `<'  `>' ̿ ʼ, ߼,  ϴ ȣ
	       `,' ڸ ϴµ,  `,' ڸ  , ó  
	       action ̴̺.
     HAN_OR  : ѱ  ǥ `<'  `>'  ʼ, ߼,  Ÿ ǥ
               ⺻ OR_X   Ǵµ, ̷ OR  ó  ̴.
     HAN_BAR : ѱ  ǥ `<'  `>'  ʼ, ߼,  Ÿ ǥ
               `[<-,,>]'  ʼ, ߼,   Ÿ  ִµ, ̸
	       óϱ  action ̴̺.

   Ʒ  ڵ ǹ̸ ˱ ؼ hre_change_action () Լ 캸 ٶ.  */
const char *hre_action[15] = {
/* 0         1         2
   012345678901234567890123
   .()+*|&a[]^$\/-.{}:,?<>1 */
  "E&A+*|X&&AeJLXA&&XXX?AA1",  /* 0 RULE:          -> ǥ $ */
  "ZX)+*|X&&AeALXA&&XXX?AAX",  /* 1 PAR:   ǥ  -> '(' ǥ $ ')'      */
  "ZXXXXXXKXXXXXXXXX}XPXXX&",  /* 2 LPAR:  ǥ  -> '{' ǥ $ '}'      */
  "ZFFFFFXOA]FFXX-FXXXXFOFX",  /* 3 OPT:   ǥ  -> '[' ǥ $ ']'      */
  "ZFFFFFXOA]XFXX-FXXXXFOFX",  /* 4 ROPT:  ǥ  -> '[^' ǥ $ ']'      */
  "v&v+*|X&&vXAXX-&XXXX?vAX",  /* 5 OR:    ǥ  -> ǥ '|' ǥ $    */
  "XFFFFXXwFwXXXXkAXXXXFwwX",  /* 6 BAR:   ǥ  -> ǥ '-' ǥ $    */
  "XXXXXXXXXXXXXXXXXXXXXXXX",  /* 7 CORON: ǥ  -> ǥ ':' ǥ $    */
  "XXXXXXXXXXXXXXXXXXXXXXXX",  /* 8 COMMA: ǥ  -> ǥ ',' ǥ $    */
  "c&c+*cX&&cXJLXA&&,XA?AA2",  /* 9 AND:   ǥ  -> ǥ & ǥ $      */
  "XXXXXXXXXXXXXXXXXXXXXXXX",  /*10 SSAC:  ǥ  -> ^ ǥ $            */
  "XHHHHHHnXDXHXXBHXXXhHX>X",  /*11 HAN:   ǥ  -> '<' ǥ '>'        */
  "CHHHHHHnXCXHXXBHXXXhHXCX",  /*12 HAN_COMMA */
  "XHHHHHHnXHXHXXBHXXXvHHvX",  /*13 HAN_OR */
  "XHHHHHHwXHXHXXHHXXXwHHwX"   /*14 HAN_BAR */
};

/* Լ ڰ   , Լ ̸ ڿ ٴ´.  */
#define ATTRIBUTE_UNUSED

/*  ޼ ѷִ ƾ.  */
void
hre_error (char *fmt, ...)
{
  va_list ap;
  
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
}

/*  ޼ ѷִ ƾ.  */
void
hre_warning (char *fmt, ...)
{
  va_list ap;
  
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
}

/* ϳ token  ؼ , ׿ ´  TOKEN  ϰ Ǹ,
   ؼ lexical token number  ȯϰ ȴ.  */
int
hre_lexer1 (p, token)
     struct hre_tree *p;
     struct hre_token *token;
{
  char *str, ch;
  struct hre_options * opt = TREE_OPTIONS (p);

  str = TOKEN_NAME (token);
  ch = str[0];

  /*  token   ѱ type   ؼ ʾұ , ⼭ ʱȭ Ѵ.  */
  TOKEN_HAN_TYPE (token) = 0;

  /* ѱ ƴϰ,  +  + ȣ , SWITCH  ؼ ó ϰ ȴ.  */     
  switch (ch) 
    {
    case 0x0:
      TOKEN_TYPE (token) = END_T;
      return END_T;
    case '[':
      /*  [ ~ ] ǥ ̹Ƿ Ÿڴ ״
	 ϳ ڷ ν ǰ մϴ. */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = LEFT_BRAC_T;
	  TOKEN_LEN (token) = 1;
	  
	  return LEFT_BRAC_T;
	}
    case ']':
      /* Ʒ κ ڵ尡 goto THIS_IDENTIFIER  پ ְ Ǿ ڵ尡 ణ
	 ,  ڵ   ,  merging  ̴.  
	 RE  ⺻Ʋ  ۾.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = RIGHT_BRAC_T;
	  TOKEN_LEN (token) = 1;
	  
	  return RIGHT_BRAC_T;
	}
    case '|':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = OR_T;
	  TOKEN_LEN (token) = 1;
	  
	  return OR_T;
	}
    case '*':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = STAR_T;
	  TOKEN_LEN (token) = 1;
	  
	  return STAR_T;
	}
    case '+':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = PLUS_T;
	  TOKEN_LEN (token) = 1;
	  
	  return PLUS_T;
	}
    case '?':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = ASK_T;
	  TOKEN_LEN (token) = 1;
	  
	  return ASK_T;
	}
    case '(':
      /* ( token  , BRE  , \(  νؾ , ERE  ,
	 (  νĵǾ ϴ  ִ.  ̿   ־  ̴.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	{
	  if (HRE_OPTIONS_MODE (opt) == HRE_MODE_ERE)
	    goto THIS_IDENTIFIER;
	  else
	    TOKEN_BACKSLASH (token) = 0;
	}
      TOKEN_TYPE (token) = LEFT_PAR_T;
      TOKEN_LEN (token) = 1;
      
      return LEFT_PAR_T;
    case ')':
      /* \(  (  еǾ Ѵ.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	TOKEN_BACKSLASH (token) = 0;
      TOKEN_TYPE (token) = RIGHT_PAR_T;
      TOKEN_LEN (token) = 1;

      return RIGHT_PAR_T;
    case '<':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = LEFT_HAN_T;
	  TOKEN_LEN (token) = 1;
	  
	  return LEFT_HAN_T;
	}
    case '>':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = RIGHT_HAN_T;
	  TOKEN_LEN (token) = 1;
	  
	  return RIGHT_HAN_T;
	}
    case ',':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = COMMA_T;
	  TOKEN_LEN (token) = 1;
	  
	  return COMMA_T;
	}
    case '-':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = BAR_T;
	  TOKEN_LEN (token) = 1;
	  
	  return BAR_T;
	}
    case '.':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = DOT_T;
	  TOKEN_LEN (token) = 1;
	  
	  return DOT_T;
	}
    case '$':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = DOLAR_T;
	  TOKEN_LEN (token) = 1;
	  
	  return DOLAR_T;
	}
    case '^':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_TYPE (token) = SSAC_T;
	  TOKEN_LEN (token) = 1;
	  
	  return SSAC_T;
	}
    case '\\':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	goto THIS_IDENTIFIER;
      else
	{
	  TOKEN_BACKSLASH (token) = 1;
	  TOKEN_TYPE (token) = REVERSE_SLASH_T;
	  TOKEN_LEN (token) = 1;
	  
	  return REVERSE_SLASH_T;
	}
    case '{':
      /* ( token   \{  {  еǾ Ѵ.  ̴ BRE  ERE 
	 ̿ е ̴.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	TOKEN_BACKSLASH (token) = 0;
      TOKEN_TYPE (token) = LEFT_LPAR_T;
      TOKEN_LEN (token) = 1;
      
      return LEFT_LPAR_T;
    case '}':
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	TOKEN_BACKSLASH (token) = 0;
      TOKEN_TYPE (token) = RIGHT_LPAR_T;
      TOKEN_LEN (token) = 1;
      
      return RIGHT_LPAR_T;
    case '0': case '1': case '2': case '3': case '4': 
    case '5': case '6': case '7': case '8': case '9':
      /*  \1 ~ \9  , backreference  ؾ Ѵ.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	TOKEN_BACKSLASH (token) = 0;
	  
      TOKEN_TYPE (token) = RNUMBER_T;
      TOKEN_LEN (token) = 1;
      
      return RNUMBER_T;
    case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
    case 'g': case 'h': case 'i': case 'j': case 'k': case 'l':
    case 'm': case 'n': case 'o': case 'p': case 'q': case 'r':
    case 's': case 't': case 'u': case 'v': case 'w': case 'x':
    case 'y': case 'z':
    case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
    case 'G': case 'H': case 'I': case 'J': case 'K': case 'L':
    case 'M': case 'N': case 'O': case 'P': case 'Q': case 'R':
    case 'S': case 'T': case 'U': case 'V': case 'W': case 'X':
    case 'Y': case 'Z': case ' ':
    THIS_IDENTIFIER:
      if (TREE_TOKENS (TOKEN_PARENT (token))
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	TOKEN_BACKSLASH (token) = 0;

      TOKEN_TYPE (token) = IDENTIFIER_T;
      TOKEN_LEN (token) = 1;

      return IDENTIFIER_T;
    }

  if (TREE_TOKENS (TOKEN_PARENT (token))
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
    TOKEN_BACKSLASH (token) = 0;
  
  /* ڿ +  + ȣ ,   ó ǰ Ǹ, ش token 
     ȯǰ Ǵµ, ⿡ ߴٴ  ó ( ó ϴ) 
     ̰ų, ѱ ̴.

     ѱ , ڵ Ȥ ϼ,    , ̰ ѱ
     ƴ ȮϿ ؼ θ ǴѴ.  ( ߿  ѱ Byte
      ̴.)  */
  TOKEN_LEN (token) = hre_ishangeul (str);
  if (TOKEN_LEN (token) > 1)
    {
      /* ѱۿ  TYPE   ش.  */
      if (TOKEN_LEN (token) == 2)
	TOKEN_HAN_TYPE (token) = HTMASK_EUC_KR;
      else if (TOKEN_LEN (token) == 3)
	TOKEN_HAN_TYPE (token) = HTMASK_UTF_8;

      TOKEN_TYPE (token) = IDENTIFIER_T;
      return IDENTIFIER_T;
    }
  else
    {
      /*  ǿ  ʰ, ѱ ƴ   IDENTIFIER  νϵ
	 Ѵ.  */
      TOKEN_TYPE (token) = IDENTIFIER_T;
      TOKEN_LEN (token) = 1;

      return IDENTIFIER_T;
    }
}

/* HRE_TOKEN  Ʈ Ѵ.  */
void
update_hre_token (t)
     struct hre_token *t;
{
  TOKEN_TYPE (t) = -1;
  if (TOKEN_LEN (t))
    TOKEN_NAME (t) = TOKEN_NAME (t) + TOKEN_LEN (t);
  TOKEN_INDEX (t) = TOKEN_INDEX (TREE_TOKENS (TOKEN_PARENT (t)));
  TOKEN_LEN (t) = 0;
  TOKEN_NEXT (t) = NULL;

  TOKEN_BACKSLASH (t) = TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (t)));;
}

/* HRE_TREE  TOKENS   ؼ token  Ѵ.  */
void
insert_hre_token (token)
     struct hre_token *token;
{
  struct hre_token *t = (struct hre_token *) malloc (sizeof (struct hre_token) + 1);

  TOKEN_TYPE (t) = TOKEN_TYPE (token);
  TOKEN_NAME (t) = TOKEN_NAME (token);
  TOKEN_LEN (t) = TOKEN_LEN (token);
  TOKEN_HAN_TYPE (t) = TOKEN_HAN_TYPE (token);
  TOKEN_PARENT (t) = TOKEN_PARENT (token);
  TOKEN_NEXT (t) = TOKEN_NEXT (token);

  TOKEN_BACKSLASH (t) = TOKEN_BACKSLASH (token);

  if (TOKEN_PARENT (token) && TREE_TOKENS (TOKEN_PARENT (token)) != NULL) 
    {
      TOKEN_NEXT (t) = TREE_TOKENS (TOKEN_PARENT (token));
      TOKEN_INDEX (t) = TOKEN_INDEX (TREE_TOKENS (TOKEN_PARENT (token))) + 1;
    }
  TREE_TOKENS (TOKEN_PARENT (token)) = t;

}

/*  ǥ lexer. */
int
hre_lexer (p, token)
     struct hre_tree *p;
     struct hre_token *token;
{
  int tok;
  
  /* Token  ̹ տ ؼ   .  */
  if (TOKEN_NAME (token) && TOKEN_LEN (token))
    {
      /* Lexer  óϱ ռ,  token  ؾ  ʿ伺 ִµ,
	 ߿   ִ debugging ۾  ǵ ϱ ؼ 
	 ̴.  */
      insert_hre_token (token);
      update_hre_token (token);
    }

  tok = hre_lexer1 (p, token);

  return tok;
}

/* ڿ S   hash    ȯѴ.  hash  ̿ϴ 
   ߺǴ ڸ ִ ̰, DAG  ϱ ؼ̴.  */
unsigned char
hre_strhash(s)
     char *s;
{
  int h;
  char * t;

  for (h = 0, t = s; *t != '\0'; t++)
    h = ( h << 1 ) ^ *t;

  return (h & 0xff);
}

/* ش ǥ Hash    ̿  ġ  ϴµ, Ǵ
   ڵ̴.  0 ~ EXP_MAX   ȯϰ ȴ.  */
int
hre_dup (int a, int b)
{
  long l, s;

  s = a + b;
  if (s < EXP_MAX)
    l = s*(s + 1)/2 + a;
  else
    {
      s = 2*(EXP_MAX - 1) - s;
      a = EXP_MAX - 1 - a;
      l = s*(s + 1)/2 + a;
      l = EXP_MAX*EXP_MAX - 1 - l;
    }

  return (int)(l/EXP_MAX);
}

/* TOKEN  ش ڿ  , ׿ ´ ڿ Ѵ.  */
char *
hre_copystr (token)
     struct hre_token * token;
{
  char * ret = (char *) malloc (TOKEN_LEN (token) + 1);

  strncpy (ret, TOKEN_NAME (token), TOKEN_LEN (token));
  ret[TOKEN_LEN (token)] = '\0';

  return ret;
}

/* ɺ ̺  ɺ , ˻ؼ ɺ ̺  ʴ´ٸ ߰ϰ
   ȴ.  ߺǴ IDENTIFIER  ν DAG  ϰ ȴ.  */
struct symbol *
hre_lookup (info, token)
     struct hre_tree * info;
     struct hre_token * token;
{
  char *s = hre_copystr (token);
  struct symbol * sym;
  unsigned char h;
  
  h = hre_strhash (s);

  for (sym = TREE_HASHTAB_N (info, h); sym != 0; sym = SYM_NEXT (sym))
    {
      if ( strcmp(SYM_NAME (sym), s) == 0)
	{
	  free (s);
	  return sym;
	}
    }
  
  sym = (struct symbol *) malloc (sizeof (*sym));
  SYM_NAME (sym) = xstrdup (s);
  SYM_HASH (sym) = h;
  SYM_LENGTH (sym) = TOKEN_LEN (token);
  SYM_NEXT (sym) = TREE_HASHTAB_N (info, h);
  TREE_HASHTAB_N (info, h) = sym;
  SYM_TAIL (sym) = NULL;
  if (TREE_FIRST_B (info) == 0)
    TREE_FIRST_B (info) = sym;
  else
    SYM_TAIL (TREE_LAST_B (info)) = sym;

  TREE_LAST_B (info) = sym;
  free (s);
  return sym;
}

/* Parser   ؼ    Ǵ hre_tree ü Ҵϰ
   ʱȭѴ.  ʱȭǰ Ҵ ü ͸ ȯѴ.  */
struct hre_tree *
init_hre_tree (options)
     struct hre_options *options;
{
  int i;
  struct hre_tree * info = (struct hre_tree *) malloc (sizeof (struct hre_tree) + 1);

  TREE_OPTIONS (info) = options;

  /* HRE_TREE  ʱȭ.  */
  TREE_SP (info) = TREE_STACK (info);

  TREE_FIRST_B (info) = NULL;
  TREE_LAST_B (info) = NULL;

  TREE_TOKENS (info) = NULL;

  TREE_EQU_TAB (info) = NULL;
  TREE_EQUS (info) = 0;
  TREE_T_EQUS (info) = 0;
  TREE_EQU_MAX (info) = 0;

  TREE_X_STACK(info) = 0;
  TREE_X_S(info) = 0;
  TREE_X_MAX(info) = 0;

  TREE_HTMASK (info) = 0;
  TREE_IS_SSAC (info) = 0;

  TREE_LPAR_IDENT (info) = 0;
  TREE_LPAR_EXCEPTION (info) = 0;

  for (i=0; i<9; i++)
    TREE_PAR_STACK_N(info, i) = -1;
  TREE_PAR_STACK_POS (info) = 0;

  for (i=0; i<EXP_MAX; i++)
    TREE_EXP_HASH_N (info, i) = 0;

  /* Խ ؼ ߰ų, Խ search  ã   ,
     ̰ ǰ ȴ.  */
  TREE_ERRNO (info) = 0;
  TREE_RE_FAILED (info) = 0;

  return info;
}

/*  ÿ TAG  ϰ ȴ.
   hre_action  stack_tag   踦 .  */
void
hre_push (info, tag, q)
     struct hre_tree *info;
     stack_tag tag;
     int q;
{
  if (TREE_SP (info) >= TREE_STACK (info) + STACK_MAX)
    {
      hre_error ("ǥ  ִ ũ⸦ Ѵ±.");
      abort ();
    }

  STACK_TAG (TREE_SP (info)) = tag;
  STACK_Q (TREE_SP (info)) = q;
  TREE_SP (info)++;
}

/*  NODE   ǥ ۼѴ.  ۼ ǥ INFO  equation ü 
   equ_tab  Q ° ׸  ȴ.  */
int
hre_make_exp (struct hre_tree *info, int q, exp_tag tag, ...)
{
  va_list ap;
  struct symbol *sym;
  struct exp *hp, *e;
  unsigned char args;
  int h, q0, q1;

  va_start(ap, tag);
  switch (tag)
    {
    case SYM_X:
      sym = va_arg (ap, struct symbol *);
      h = 0x100 + SYM_HASH (sym);
      args = 0;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if ( sym == EXP_BODY_LEAF (hp))
	    {
	      if ( q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    case AND_X:
      /* ѱ  ǥĿ   ϴ ǥ, AND_X  OR_X  
	  ū  ϰ ȴ.   ,   ǥ ʿ 
	 ѱ ,        2 Ʈ 3 Ʈ 
	   ֱ ̴.   AND_X  OR_X  Hash   ϴĿ ,
	 ӵ  ū  ģ.  */
      q0 = va_arg (ap, int);
      q1 = va_arg (ap, int);
      h = 0x40 + hre_dup (EQU_HASH (TREE_EQU_TAB_N(info, q0)), 
			  EQU_HASH (TREE_EQU_TAB_N(info, q1))) / 2;
      args = 2;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if (q0 == EXP_BODY_ARG_N (hp, 0) && q1 == EXP_BODY_ARG_N (hp, 1))
	    {
	      if (q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    case OR_X:
      q0 = va_arg (ap, int);
      q1 = va_arg (ap, int);
      h = 0x40 + hre_dup (EQU_HASH (TREE_EQU_TAB_N(info, q0)), 
			  EQU_HASH (TREE_EQU_TAB_N(info, q1))) / 2;
      args = 2;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if (q0 == EXP_BODY_ARG_N (hp, 0) && q1 == EXP_BODY_ARG_N (hp, 1))
	    {
	      if (q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    case HAN_X:
      q0 = va_arg (ap, int);
      q1 = va_arg (ap, int);
      h = 0x20 + hre_dup (EQU_HASH (TREE_EQU_TAB_N(info, q0)), 
			  EQU_HASH (TREE_EQU_TAB_N(info, q1))) / 0x10;
      args = 2;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if (q0 == EXP_BODY_ARG_N (hp, 0) && q1 == EXP_BODY_ARG_N (hp, 1))
	    {
	      if (q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    case BAR_X: case RANGE_X:
      q0 = va_arg (ap, int);
      q1 = va_arg (ap, int);
      h = 0x20 + hre_dup (EQU_HASH (TREE_EQU_TAB_N(info, q0)), 
			  EQU_HASH (TREE_EQU_TAB_N(info, q1))) / 0x10;
      args = 2;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if (q0 == EXP_BODY_ARG_N (hp, 0) && q1 == EXP_BODY_ARG_N (hp, 1))
	    {
	      if (q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    case ZERO_X: case ONE_X:
      /* ZERO_X -> ؽ  : 0x0 */
      /* ONE_X -> ؽ  : 0x1 */
      h = (tag == ZERO_X) ? 0 : 1;
      args = 0;
      hp = TREE_EXP_HASH_N (info, h);
      if (hp != 0)
	{
	  if (q != -1 && q != EXP_CLASS (hp))
	    EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	  return EXP_CLASS (hp);
	}
      break;
    case STAR_X: case PLUS_X: case REVERSE_X: 
    case OPT_X: case ASK_X:
      /* κ ǥ øǴ 찡   ,  Hash 
	 ϰ ȴ.  */
      q0 = va_arg (ap, int);
      /* ؽ  : 0x0c + (0x0 ~ 0x14) */
      if (tag == STAR_X || tag == REVERSE_X || tag == ASK_X)
	h = 0x0c + EQU_HASH (TREE_EQU_TAB_N(info, q0))*0x14 / EXP_MAX;
      else if (tag == PLUS_X || tag == OPT_X)
	h = 0x02 + EQU_HASH (TREE_EQU_TAB_N(info, q0))*0x0a / EXP_MAX;
      args = 1;
      for (hp = TREE_EXP_HASH_N (info, h); hp != 0; hp = EXP_TAIL (hp))
	{
	  if (q0 == EXP_BODY_ARG_N (hp, 0))
	    {
	      if (q != -1 && q != EXP_CLASS (hp))
		EQU_VALUE (TREE_EQU_TAB_N (info, q)) = hp;
	      return EXP_CLASS (hp);
	    }
	}
      break;
    default:
      hre_error ("ǵ  ǥ 䱸Ͽϴ.");
      abort ();
    }
  va_end (ap);

  e = (struct exp *) malloc (sizeof (*e));
  EXP_TAG (e) = tag;
  EXP_ARGS (e) = args;

  if (tag == SYM_X)
    EXP_BODY_LEAF (e) = sym;
  else
    {
      EXP_BODY_ARG (e) = (int *) (args > 0 ? malloc (args*sizeof (int)) : 0 );
      if (args > 0) EXP_BODY_ARG_N(e, 0) = q0;
      if (args > 1) EXP_BODY_ARG_N(e, 1) = q1;
    }

  EXP_HASH (e) = h;
  EXP_TAIL (e) = TREE_EXP_HASH_N (info, h);
  TREE_EXP_HASH_N (info, h) = e;

  if (q == -1)
    {
      if (TREE_EQUS (info) == TREE_EQU_MAX (info))
        {
          TREE_EQU_MAX (info) += EQU_EXTEND;
          TREE_EQU_TAB (info) =
	    (struct equation *) realloc (TREE_EQU_TAB (info),
					 sizeof (*TREE_EQU_TAB (info)) * TREE_EQU_MAX (info));
        } 
      EQU_HASH (TREE_EQU_TAB_N (info, TREE_EQUS (info))) = h;
      EQU_STACK (TREE_EQU_TAB_N (info, TREE_EQUS (info))) = 0;
      q = TREE_EQUS (info)++;
    }
  EQU_VALUE (TREE_EQU_TAB_N (info, q)) = e;
  EQU_INDEX (TREE_EQU_TAB_N (info, q)) = 100;
  
  EXP_CLASS (e) = q;

  /* TODO ,  Ҵ ǥİ EXP_BODY_ARG    Ȳ ,
     ϴ 찡 ߻ϱ , ӽ Ʒ  ū TREE_EXP_FREE 
       ʿ  ν memory leak  ϰ ִ.  ̿ 
      ڵ尡 ۼǾ  ̴.  */
  TREE_EXP_FREE_N (info, TREE_T_EQUS (info)) = e;
  
  /* ѱ  ǥĿ  ѱ   , κ ǥ 2 
     ѱ 찡 κε,    ũ  , EXP_FREE_MAX 
       ÷ ν Ʒ  ޼   ִ.    ̿ 
     Ѱ谡 ߻ ʵ ڵǾ  ̴.  */
  if (TREE_T_EQUS (info)++ >= EXP_FREE_MAX)
    {
      hre_error (" ؼϰ ϴ Խ struct exp   EXP_FREE_MAX  ʰҷ մϴ.\nhre.h ϳ EXP_FREE_MAX   ÷ ּž մϴ.\n");
      abort ();
    }

  return q;
}

/* hre.h Ͽ Ǿ ִ hre_action ̺    token
    TYPE   ö     ̵  ã´.  */
void
hre_change_action (info, token, rhs)
     struct hre_tree *info;
     struct hre_token *token;
     int *rhs;
{
  int last_token = TOKEN_TYPE (token);
  char ch = hre_action[TOP][TOKEN_TYPE (token)];
  struct hre_options *opt = TREE_OPTIONS (info);

  if (TREE_ERRNO (info))
    {
      *rhs = -1;
      return;
    }

  switch (ch)
    {
    case 'k':
      /* Խ ǥ {,}   ߸ Ǿ 츦 óѴ.  */
      TREE_ERRNO (info) = REG_ERANGE;
      TREE_LAST_RHS (info) = -1;
      *rhs = -1;
      break;
    case 'K':
      /* Խ ǥ {,}   ߸ Ǿ 츦 óѴ.  */
      TREE_ERRNO (info) = REG_BADBR;
      TREE_LAST_RHS (info) = -1;
      *rhs = -1;
      break;
    case 'Z':
      /*      Ϳ ؼ  ޼ Ѹ Ѵ.  */
      if (TOP == PAR)
	{
	  TREE_ERRNO (info) = REG_EPAREN;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	}
      else if (TOP == OPT)
	{
	  TREE_ERRNO (info) = REG_EBRACK;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	}
      else if (TOP == LPAR)
	{
	  TREE_ERRNO (info) = REG_EBRACE;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	}
      else
	{
	  hre_warning (": ¦  \n");
	  abort ();
	}
      break;
    case 'H':
      /*      Ϳ ؼ  ޼ Ѹ Ѵ.  */
      hre_warning (": ѱ  ǥĳ ͼ ȵǴ Դϴ.\n");
      abort ();
      break;
    case 'D':
      /* ڰ ߸  ǥ,   `([ab)'    ]  Ͽ , 
       ̿       ޼    ȴ.  */
      hre_warning (":  ġ  ʴ ڰ մϴ.\n");
      (void) POP ();
      hre_change_action (info, token, rhs);
      break;
    case '&':
      /*  ǥ `ab'     ,  a  b ̿ 
	 ƹ ڵ , ̸  ֱ  ȣ ʿѵ, ̷ ڸ  ,
	 ǹ ϱ , ̰ ȴ.   ǹ̷ Ѵٸ, a ڸ
	 ó  ̰  ̰, b  ؼ , AND_X   ̴.  */
      hre_push (info, AND, *rhs);
      hre_process_expression (info, token, rhs);
      break;
    case 'O':
      /*  Ͱ , ̰ OR_X   ʿ䰡  , ̰ ȴ.
	 ̰ Ÿ `['  `]' ̿ ϴ ab  , ǹ̻ OR  Ÿ
	  ̰ Ǵ ̴.  */
      hre_push (info, OR, *rhs);
      hre_process_expression (info, token, rhs);
      break;
    case ',':
      if (TREE_LPAR_IDENT (info))
	{
	  TREE_LPAR_IDENT (info) = 0;

	  hre_push (info, AND, *rhs);
	  TOKEN_TYPE (token) = IDENTIFIER_T;
	  hre_process_expression (info, token, rhs);
	}
      else
	{
	  *rhs = hre_make_exp (info, -1, AND_X, POP (), *rhs);
	  hre_change_action (info, token, rhs);
	}
      break;
    case 'c':
      /* տ AND stack tag  push  , ٸ operation  ϸ鼭, AND_X node 
	  ʿ䰡  , ̰ ȴ.   , `(abc|d)'  óѴٰ  ,
	 abc  ó  , | token  ,  bc  AND_X    ʿ䰡 ִµ,
	 ̷ 쿡 ȴ.  */
      *rhs = hre_make_exp (info, -1, AND_X, POP (), *rhs);
      hre_change_action (info, token, rhs);
      break;
    case 'E':
      /*  ǥ  ؼ Ǿ ,  ̰ ȣǾ TREE_LAST_RHS
	  ؼ *rhs ȣ ϰ ȴ.  */
      (void) POP ();
      TREE_LAST_RHS (info) = *rhs;
      break;
    case '|':
      /* `(abc|d)    OR   ʿ䰡  , ̰ ȴ.  */
      hre_push (info, OR, *rhs);
      last_token = hre_lexer (info, token);
      if (last_token == OR_T || last_token == END_T || last_token == RIGHT_PAR_T)
	{
	  TREE_ERRNO (info) = REG_EMPTY;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      else if (last_token == STAR_T || last_token == PLUS_T || last_token == ASK_T
	       || last_token == LEFT_LPAR_T)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      hre_process_expression (info, token, rhs);
      break;
    case 'v':
      /*  `O' Ȥ `|'  ؼ, OR stack tag  ö󰬾, ̸   
	 OR_X node   ʿ伺  , ̰ ȣǰ ȴ.  */
      *rhs = hre_make_exp (info, -1, OR_X, POP (), *rhs);
      hre_change_action (info, token, rhs);
      break;
    case '>':
    case ')':
    case ']':
    case '}':
      last_token = hre_lexer (info, token);

      /* `( ~ )' Ȥ `[ ~ ]' Ȥ `< ~ >'      ,  stack tag 
	  ؼ Ǵ κ̴.  */
      if (TOP == ROPT)
	*rhs = hre_make_exp (info, -1, REVERSE_X, *rhs);
      else if (TOP == OPT)
	*rhs = hre_make_exp (info, -1, OPT_X, *rhs);
      else if (TOP == PAR && TREE_PAR_STACK_POS (info) < 9)
	{
	  TREE_PAR_STACK_N (info, TREE_PAR_STACK_POS (info)) = *rhs;
	  TREE_PAR_STACK_POS (info)++;
	}
      else if (TOP == LPAR)
	{
	  if (last_token == LEFT_LPAR_T || last_token == STAR_T || last_token == PLUS_T
	      || last_token == ASK_T)
	    {
	      TREE_ERRNO (info) = REG_BADRPT;
	      TREE_LAST_RHS (info) = -1;
	      *rhs = -1;
	      break;
	    }
	  *rhs = hre_make_exp (info, -1, RANGE_X, POP (), *rhs);
	}
      (void) POP ();
      hre_change_action (info, token, rhs);
      break;
    case '*':
      /* Խ `a*'   ǥ   ʿ伺  ,  STAR_X node  
	 ϱ ؼ ̰ ȣȴ.  STAR_X node  , ڸ Ѱ  
	 ٸ stack tag  push  ʿ伺  ٷ STAR_X    ִ.  */
      *rhs = hre_make_exp (info, -1, STAR_X, *rhs);
      last_token = hre_lexer (info, token);
      if (last_token == STAR_T || last_token == PLUS_T || last_token == ASK_T)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      else if (last_token == LEFT_LPAR_T)
	TREE_LPAR_EXCEPTION (info) = 1;

      hre_change_action (info, token, rhs);
      break;
    case '+':
      /*  `*'  ϰ ó, ԽĿ ǹ̴  ̰ ִ.  
	  DFA ̺    ̰ ǰ ȴ.  */
      *rhs = hre_make_exp (info, -1, PLUS_X, *rhs);
      last_token = hre_lexer (info, token);
      if (last_token == STAR_T || last_token == PLUS_T || last_token == ASK_T)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      else if (last_token == LEFT_LPAR_T)
	TREE_LPAR_EXCEPTION (info) = 1;

      hre_change_action (info, token, rhs);
      break;
    case '?':
      /*  `*'  ϰ ó, ԽĿ ǹ̴  ̰ ִ.  
	  DFA ̺    ̰ ǰ ȴ.  */
      *rhs = hre_make_exp (info, -1, ASK_X, *rhs);
      last_token = hre_lexer (info, token);
      if (last_token == STAR_T || last_token == PLUS_T || last_token == ASK_T)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      else if (last_token == LEFT_LPAR_T)
	TREE_LPAR_EXCEPTION (info) = 1;

      hre_change_action (info, token, rhs);
      break;
    case 'B':
      /* `[<-,,>]'   ǥĿ, ʼ, ߼,  شϴ κп `-' Ȥ
	 `-'  ǥ  , ̸ óϱ  ̴.  */
      hre_push (info, HAN_BAR, *rhs);
      last_token = hre_lexer (info, token);
      hre_process_expression (info, token, rhs);
      break;
    case 'C':
      /* ѱ  ǥ ΰ HAN_X  ǰ α׷ֵǾ ,  HAN_COMMA
	 stack tag  ǰ ȴ.  */
      *rhs = hre_make_exp (info, -1, HAN_X, POP (), *rhs);
      hre_change_action (info, token, rhs);
      break;
    case 'h':
      /* ѱ  ǥĿ `,' token   , ȴ.*/
      hre_push (info, HAN_COMMA, *rhs);
      last_token = hre_lexer (info, token);
      hre_process_expression (info, token, rhs);
      break;
    case 'n':
      /* `[<-,,>]'   ǥĿ `' ̿  OR  ʿϱ 
	 , HAN_OR stack tag  push ϰ ȴ.  */
      hre_push (info, HAN_OR, *rhs);
      hre_process_expression (info, token, rhs);
      break;
    case '-':
      /* `[<-,,>a-z]'   ǥĿ `-'  `-'    Ǵ
	 ൿ̴.  */
      hre_push (info, BAR, *rhs);
      last_token = hre_lexer (info, token);
      if (last_token == RIGHT_BRAC_T)
	{
	  struct hre_token t;

	  (void) POP ();

	  hre_push (info, OR, *rhs);

	  TOKEN_NAME (&t) = "-";
	  TOKEN_TYPE (&t) = IDENTIFIER_T;
	  TOKEN_LEN (&t) = 1;
	  
	  *rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t));
	  hre_change_action (info, token, rhs);
	}
      else
	hre_process_expression (info, token, rhs);
      break;
    case 'w':
      /* `[<-,,>]'   ǥĿ BAR_X   ʿ䰡   ̰ ȴ.  */
      *rhs = hre_make_exp (info, -1, BAR_X, POP (), *rhs);
      hre_change_action (info, token, rhs);
      break;
    case 'A':
      /*   token  IDENTIFIER  ؼ ʿ䰡  , ̸ Ѵ.   
	 `123)123'   Խ ִٰ  , token `)'  ǹ̰  ̱ ,
	 ̸ IDENTIFIER   ʿ䰡 ִ.  */
      hre_push (info, AND, *rhs);
      TOKEN_TYPE (token) = IDENTIFIER_T;
      hre_process_expression (info, token, rhs);
      break;
    case 'F':
      /*   token  IDENTIFIER  ؼ ʿ䰡  , ̸ Ѵ.   
	 `[123)123]'   Խ ִٰ  , token `)'  ǹ̰  ̱ ,
	 ̸ IDENTIFIER   ʿ䰡 ִ.  */
      hre_push (info, OR, *rhs);
      TOKEN_TYPE (token) = IDENTIFIER_T;
      hre_process_expression (info, token, rhs);
      break;
    case 'J':
      hre_push (info, AND, *rhs);
      TOKEN_TYPE (token) = DOLAR_T;
      hre_process_expression (info, token, rhs);
      break;
    case 'L':
      /* \    ó κ̴.  */
      last_token = hre_lexer (info, token);
      if (last_token == END_T)
	{
	  TREE_ERRNO (info) = REG_EESCAPE;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      hre_change_action (info, token, rhs);
      break;
    case '1':
      /* \1 ~ \9   backreference  óϱ  ڵ̴.  backreferencing 
	  ǥ Ծó 1  9    , ̿   HRE 
	 ׻ TREE_PAR_STACK_N (info)  ǰ ȴ.  */
      if (TREE_TOKENS (TOKEN_PARENT (token)) 
	  && TOKEN_BACKSLASH (TREE_TOKENS (TOKEN_PARENT (token))) == 1)
	{
	  hre_push (info, AND, TREE_PAR_STACK_N (info, atoi (TOKEN_NAME (token) - 1)));
	  last_token = hre_lexer (info, token);
	  hre_change_action (info, token, rhs);
	}
      else
	{
	  hre_push (info, AND, *rhs);
	  TOKEN_TYPE (token) = IDENTIFIER_T;
	  hre_process_expression (info, token, rhs);
	}
      break;
    case '2':
      {
	int pos = atoi (TOKEN_NAME (token));
	
	if (pos < 1 || pos > TREE_PAR_STACK_POS (info))
	  {
	    hre_push (info, AND, *rhs);
	    TOKEN_TYPE (token) = IDENTIFIER_T;
	    hre_process_expression (info, token, rhs);
	  }
	else
	  {
	    hre_push (info, AND, *rhs);
	    *rhs = TREE_PAR_STACK_N (info, pos - 1);
	    last_token = hre_lexer (info, token);
	    hre_change_action (info, token, rhs);
	  }
      }
      break;
    case 'P':
      /* a{3}   ǥ ݵ Ʒ   .

	   E2   -> E0 [Range] E1
	       E0   -> a
	       E1   -> 3
	 
	 a{3,}   ǥ ݵ Ʒ   .

 	   E4   -> E0 [Range] E3
	       E0   -> a
	       E3   -> E1 & E2
	           E1   -> 3
		   E2   -> [one]

	 a{3,5}   ǥ ݵ Ʒ   .

 	   E4   -> E0 [Range] E3
	       E0   -> a
	       E3   -> E1 & E2
	           E1   -> 3
		   E2   -> 5

	 ̿  ǥ  , hre_process_expression () Լ ؼ RANGE_X
	 ǥ   ȯǰ ȴ.  */
      last_token = hre_lexer (info, token);
      if (last_token == RIGHT_LPAR_T)
	{
	  hre_push (info, AND, *rhs);
	  *rhs = hre_make_exp (info, -1, ONE_X);
	}
      hre_change_action (info, token, rhs);
      break;
    case 'e':
      /* ERE  "^" BRE  Ͱ ٸ ؼǾ Ѵ.  */
      if (HRE_OPTIONS_MODE (opt) == HRE_MODE_ERE)
	TREE_RE_FAILED (info) = 1;
      break;
    default:
      hre_error ("ó ٶ, TOP = %d, LAST_TOKEN = %d\n", TOP, TOKEN_TYPE (token));
      abort ();
    }
}

/* hre_parser () Լ ̷ ߽ Լ̸鼭, Recursive ó ǵ Ǿ ִ.
    Լ κ token  token  ῡ  ǥ ׷ ó ʿ䰡 
    ȣǰ ȴ.  */
void
hre_process_expression (info, token, rhs)
     struct hre_tree *info;
     struct hre_token *token;
     int *rhs;
{
  int last_token = TOKEN_TYPE (token);
  char ch = hre_action[TOP][TOKEN_TYPE (token)];
  struct hre_options *opt = TREE_OPTIONS (info);

  if (TREE_ERRNO (info))
    {
      *rhs = -1;
      return;
    }

  /*   Ȳ  ־ Ѵ.  */
  switch (ch)
    {
    case 'A': case 'F':
      /*   token  IDENTIFIER  ؼ ʿ䰡  , ̸ Ѵ.   
	 `)123'   Խ ִٰ  , token `)'  ǹ̰  ̱ ,
	 ̸ IDENTIFIER   ʿ䰡 ִ.  */
      TOKEN_TYPE (token) = IDENTIFIER_T;
      hre_process_expression (info, token, rhs);
	  return;
    case 'H':
      /*      Ϳ ؼ  ޼ Ѹ Ѵ.  */
      hre_warning (": ѱ  ǥĳ ͼ ȵǴ Դϴ.\n");
      abort ();
      break;
    }

  switch (last_token)
    {
    case LEFT_PAR_T:
      hre_push (info, PAR, -1);
      last_token = hre_lexer (info, token);
      if (last_token == LEFT_LPAR_T || last_token == STAR_T || last_token == PLUS_T
	  || last_token == ASK_T)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      hre_process_expression (info, token, rhs);
      break;
    case LEFT_LPAR_T:
      last_token = hre_lexer (info, token);
      if (*rhs == -1 || TREE_LPAR_EXCEPTION (info))
	{
	  if (last_token == RNUMBER_T)
	    {
	      TREE_ERRNO (info) = REG_BADRPT;
	      TREE_LAST_RHS (info) = -1;
	      *rhs = -1;
	    }
	  else if (last_token != IDENTIFIER_T && TREE_LPAR_EXCEPTION (info) )
	    {
	      TREE_ERRNO (info) = REG_BADRPT;
	      TREE_LAST_RHS (info) = -1;
	      *rhs = -1;
	    }
	  else
	    {
	      struct hre_token t;
	      
	      TREE_LPAR_EXCEPTION (info) = 0;

	      /*   Ǵ κ  IDENTIFIER  ؼǾ Ѵ.  */
	      TREE_LPAR_IDENT (info) = 1;
	      
	      TOKEN_NAME (&t) = "{";
	      TOKEN_TYPE (&t) = IDENTIFIER_T;
	      TOKEN_LEN (&t) = 1;
	      
	      *rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t));
	      hre_change_action (info, token, rhs);
	    }
	}
      else
	{
	  TREE_LPAR_EXCEPTION (info) = 0;

	  if (last_token == IDENTIFIER_T || last_token == COMMA_T)
	    {
	      struct hre_token t;
	      
	      /*   Ǵ κ  IDENTIFIER  ؼǾ Ѵ.  */
	      TREE_LPAR_IDENT (info) = 1;
	      
	      TOKEN_NAME (&t) = "{";
	      TOKEN_TYPE (&t) = IDENTIFIER_T;
	      TOKEN_LEN (&t) = 1;

	      *rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t));
	      hre_change_action (info, token, rhs);
	    }
	  else
	    {
	      TREE_LPAR_IDENT (info) = 0;

	      hre_push (info, LPAR, *rhs);
	      hre_process_expression (info, token, rhs);
	    }
	}
      break;
    case LEFT_BRAC_T:
      last_token = hre_lexer (info, token);
      if (last_token == SSAC_T)
	{
	  hre_push (info, ROPT, -1);
	  last_token = hre_lexer (info, token);
	  if (last_token == RIGHT_BRAC_T || last_token == LEFT_BRAC_T)
	    TOKEN_TYPE (token) = IDENTIFIER_T;
	}
      else if (last_token == RIGHT_BRAC_T || last_token == LEFT_BRAC_T)
	{
	  hre_push (info, OPT, -1);
	  TOKEN_TYPE (token) = IDENTIFIER_T;
	}
      else
	hre_push (info, OPT, -1);
      hre_process_expression (info, token, rhs);
      break;
    case LEFT_HAN_T:
      hre_push (info, HAN, -1);
      last_token = hre_lexer (info, token);
      hre_process_expression (info, token, rhs);
      break;
    case RIGHT_PAR_T:
    case RIGHT_BRAC_T:
      /*   κп ϰ ȴٸ, Խ ab()d Ȥ ab[]d  
	 opener  closer   پ ִ Ȳ  ̴.    Ȳ
	   , ̴.  */
      (void) POP ();
      last_token = hre_lexer (info, token);
      hre_process_expression (info, token, rhs);
      break;
    case RIGHT_HAN_T:
      if (TOP == HAN || TOP == HAN_COMMA)
	{
	  *rhs = hre_make_exp (info, -1, ZERO_X);
	  hre_change_action (info, token, rhs);
	}
      break;
    case COMMA_T:
      if (TOP == HAN || TOP == HAN_COMMA)
	{
	  *rhs = hre_make_exp (info, -1, ZERO_X);
	  hre_push (info, HAN_COMMA, *rhs);
	  last_token = hre_lexer (info, token);
	  hre_process_expression (info, token, rhs);
	}
      else
	{
	  /*   ѱ  ǥĿ  ƴ , IDENTIFIER  νĵǰ
	     ȴ.  ߿ ٸ 뵵  쿡  ڵ带  ־ Ѵ.  */
	  TOKEN_TYPE (token) = IDENTIFIER_T;
	  hre_process_expression (info, token, rhs);
	}
      break;
    case BAR_T:
      /* hre_process_expression () Լ BAR_T  óѴٴ  ̱ 
	 '-' ڸ IDENTIFIER  ȯѴ.  */
      TOKEN_TYPE (token) = IDENTIFIER_T;
      hre_process_expression (info, token, rhs);
      break;
    case PLUS_T:
    case STAR_T:
    case ASK_T:
      /*    ǥ '*' Ȥ '+'  ,   óؾ Ѵ.  */
      if (*rhs == -1)
	{
	  TREE_ERRNO (info) = REG_BADRPT;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      fprintf (stderr, "üũ 䱸");
      break;
    case OR_T:
      /* hre_process_expression () Լ BAR_T  óѴٴ  ̱ 
	 '-' ڸ IDENTIFIER  ȯѴ.  */
      if (*rhs == -1)
	{
	  TREE_ERRNO (info) = REG_EMPTY;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
    case RNUMBER_T:
      TOKEN_TYPE (token) = IDENTIFIER_T;
      hre_process_expression (info, token, rhs);
      break;
    case SSAC_T:
      {
	/* Խ ^ token   츦 óѴ.  */
	struct hre_token t;
	
	if (TOKEN_INDEX (token) == -1 
	    || (TOKEN_INDEX (token) == 0 && TOP == PAR))
	  {
	    TREE_IS_SSAC (info) = 1;

	    last_token = hre_lexer (info, token);
	    if (last_token == LEFT_LPAR_T || last_token == STAR_T || last_token == PLUS_T
		|| last_token == ASK_T)
	      {
		TREE_ERRNO (info) = REG_BADRPT;
		TREE_LAST_RHS (info) = -1;
		*rhs = -1;
		break;
	      }
	    hre_process_expression (info, token, rhs);
	  }
	else
	  {
	    TOKEN_NAME (&t) = "^";
	    TOKEN_TYPE (&t) = IDENTIFIER_T;
	    TOKEN_LEN (&t) = 1;
	    *rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t));
	    hre_change_action (info, token, rhs);
	  }
      }
      break;
    case DOLAR_T:
      {
	/* Խ $   츦 óϴµ, ̰ hre_search () Լ  
	   Ǿ  ó  ִ.  */
	struct hre_token t;

	last_token = hre_lexer (info, token);

	if (last_token != 0 && HRE_OPTIONS_MODE (opt) == HRE_MODE_ERE)
	  TREE_RE_FAILED (info) = 1;

	TOKEN_NAME (&t) = (last_token == 0) ? "\n" : "$";
	TOKEN_TYPE (&t) = IDENTIFIER_T;
	TOKEN_LEN (&t) = 1;
	*rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t));
	hre_change_action (info, token, rhs);
      }
      break;
    case DOT_T:
      {
	char tmp1[2], tmp2[2];
	struct hre_token t1, t2;

	tmp1[0] = (char) 0x1;
	tmp1[1] = '\0';
	TOKEN_NAME (&t1) = tmp1;
	TOKEN_TYPE (&t1) = IDENTIFIER_T;
	TOKEN_LEN (&t1) = 1;

	tmp2[0] = (char) 0xfe;
	tmp2[1] = '\0';
	TOKEN_NAME (&t2) = tmp2;
	TOKEN_TYPE (&t2) = IDENTIFIER_T;
	TOKEN_LEN (&t2) = 1;

	*rhs = hre_make_exp (info, -1, BAR_X,
			     hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t1)),
			     hre_make_exp (info, -1, SYM_X, hre_lookup (info, &t2)));
	last_token = hre_lexer (info, token);
	hre_change_action (info, token, rhs);
      }
      break;
    case REVERSE_SLASH_T:
      /* \    ó κ̴.  */
      last_token = hre_lexer (info, token);
      hre_process_expression (info, token, rhs);
      break;
    case IDENTIFIER_T:
      *rhs = hre_make_exp (info, -1, SYM_X, hre_lookup (info, token));
      last_token = hre_lexer (info, token);
      if (TOP == LPAR && last_token == RNUMBER_T)
	{
	  TREE_ERRNO (info) = REG_BADBR;
	  TREE_LAST_RHS (info) = -1;
	  *rhs = -1;
	  break;
	}
      hre_change_action (info, token, rhs);
      break;
    default:
      {
	/* ⿡  ,  ̴.  */
	if (TOP == PAR)
	  {
	    TREE_ERRNO (info) = REG_EPAREN;
	    TREE_LAST_RHS (info) = -1;
	    *rhs = -1;
	  }
	if (!TREE_ERRNO (info))
	  {
	    hre_error ("EXP 󺧿 ߸  ǥԴϴ.\n");
	    abort ();
	  }
      }
    }
}

/* struct hre_token  T  ʱȭϴµ,  Է  ǥ EXP  ڷ
    , װ ȴٴ  ٸ. */
void
init_hre_token_once (t, info, exp)
     struct hre_token *t;
     struct hre_tree * info;
     char *exp;
{
  TOKEN_TYPE (t) = -1;
  TOKEN_NAME (t) = exp;
  TOKEN_INDEX (t) = -1;
  TOKEN_PARENT (t) = info;
  TOKEN_LEN (t) = 0;
  TOKEN_NEXT (t) = NULL;

  TOKEN_BACKSLASH (t) = 0;
}

/* ڰ Է  ǥ ؼϿ,  TREE  ۼϿ
   ȯѴ.   TREE  ؼ  ǥ   Եǰ ȴ.  */
struct hre_tree *
hre_parser (exp, options)
     char *exp;
     struct hre_options *options;
{
  struct symbol * ident;
  struct hre_tree * info;
  /* ͸  ʰ ̷   lexer  ȣ  
     hre_token    Ҵ ִ  ٶ   Ƽ
     ϳ token  ؼ Ϸ  ü 縦   ų ǵ
     Ͽ.  */
  struct hre_token t, *t2;
  int rhs = -1;
  int last_token;

  timevar_push (TV_PARSER);

  /* ü Ҵϰ ʱȭѴ.  */
  info = init_hre_tree (options);
  /* Token   Ǵ  ʱȭѴ.  */
  init_hre_token_once (&t, info, exp);

  last_token = hre_lexer (info, &t);
  if (last_token == IDENTIFIER_T || last_token == RNUMBER_T)
    {
      ident = hre_lookup (info, &t);
      last_token = hre_lexer (info, &t);
      hre_push (info, RULE, -1);
      rhs = hre_make_exp (info, -1, SYM_X, ident);
      hre_change_action (info, &t, &rhs);
    }
  else
    {
      hre_push (info, RULE, -1);
      hre_process_expression (info, &t, &rhs);
    }

  /*  ڰ Է  token  ؼϿ.   hre_search () Լ
         ϱ   Ʒ Ѵ.  */
  t2 = TREE_TOKENS (info);
  while (t2)
    {
      /* ڰ Է ѱ  Ѵ.  */
      TREE_HTMASK (info) |= TOKEN_HAN_TYPE (t2);
      t2 = t2->next;
    }

  timevar_pop (TV_PARSER);

  return info;
}

/* ϼ ڿ (2 Ʈ  ѱ)  WORD (int)  ȯѴ.  ksc5601code.c 
    ˰, Ȯϼ   ڵ尡 int  Ǿ ִٴ    ִ.  */
int
hre_str2word (strWord)
     char *strWord;
{
  char strChar[2];
  int wordvalue;
  unsigned char temp;

  strncpy (strChar, strWord, 2);
  temp = strChar[0];
  strChar[0] = strChar[1];
  strChar[1] = temp;
  
  memcpy (&wordvalue, strChar, 2);

  return wordvalue & 0xffff;
}

/* ڰ Է  ǥ , hre_parser ()  ؼ ǥ ϰ Ǵµ,
   ⼭ HAN_X ǥ Ѵ.  */
int
hre_validate_han_x (p, rhs)
     struct hre_tree *p;
     int rhs;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, rhs));

  if (v)
    {
      int args = EXP_ARGS (v);
      
      if (EXP_TAG (v) == BAR_X)
	{
	  int arg0 = EXP_BODY_ARG_N (v, 0);
	  int arg1 = EXP_BODY_ARG_N (v, 1);
	  int arg0_len = SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
	  char *arg0_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
	  char *arg1_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))));
	  int arg0_int, arg1_int;
	  
	  arg0_int = hre_str2word (arg0_str);
	  arg1_int = hre_str2word (arg1_str);
	  
	  /* ѱ Է     */
	  if (arg0_len == 2 && arg0_int > arg1_int)
	    {
	      hre_error ("ѱ BAR_X  ù°  ġ ι° ں ̴.%s%s\n", arg0_str, arg1_str);
	      TREE_LAST_RHS (p) = -1;
	      return 0;
	    }
	}
      if (args == 0
	  && EXP_TAG (v) != ZERO_X
	  && EXP_TAG (v) != ONE_X)
	{
	  int length = SYM_LENGTH (EXP_BODY_LEAF (v));

	  /* ڰ ڸ Է  */
	  if (length < 2)
	    {
	      hre_error ("HAN_X  ѱ ƴ ڰ ִ  մϴ.\n");
	      TREE_LAST_RHS (p) = -1;
	      return 0;
	    }
	}
      else if (args == 1)
	return hre_validate_han_x (p, EXP_BODY_ARG_N (v, 0));
      else if (args == 2)
	{
	  if (!hre_validate_han_x (p, EXP_BODY_ARG_N (v, 0)))
	    return 0;
	  return hre_validate_han_x (p, EXP_BODY_ARG_N (v, 1));
	}
    }
  return 1;
}

/*    ǽѴ.  */
int
hre_validate_syntax (p, last_rhs)
     struct hre_tree *p;
     int last_rhs;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args = EXP_ARGS (v);
      int tag = EXP_TAG (v);
      
      if (tag == HAN_X)
	return hre_validate_han_x (p, last_rhs);
      else if (tag == BAR_X)
	{
	  int arg0 = EXP_BODY_ARG_N (v, 0);
	  int arg1 = EXP_BODY_ARG_N (v, 1);
	  int arg0_len = SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
	  int arg1_len = SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))));
	  char *arg0_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
	  char *arg1_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))));

	  /* Ἲ ˻  */
	  if (EXP_ARGS (v) != 2)
	    {
	      hre_error ("BAR_X  ڰ ΰ ƴϴ.\n");
	      TREE_LAST_RHS (p) = -1;
	      return 0;
	    }
	  if (arg0_len != arg1_len)
	    {
	      hre_error ("BAR_X   ڰ  ũⰡ ٸ ڵ̴.\n");
	      TREE_LAST_RHS (p) = -1;
	      return 0;
	    }
	  if (arg0_len == 1 && ((int) arg0_str[0] & 0xff) > ((int) arg1_str[0] & 0xff))
	    {
	      /* hre_error ("BAR_X  ù°  ġ ι° ں ̴.\n"); */
	      TREE_ERRNO (p) = REG_ERANGE;
	      TREE_LAST_RHS (p) = -1;
	      return 0;
	    }
	}

      if (args == 1 )
	return hre_validate_syntax (p, EXP_BODY_ARG_N (v, 0));
      else if (args == 2 )
	{
	  if (!hre_validate_syntax (p, EXP_BODY_ARG_N (v, 0)))
	    return 0;
	  return hre_validate_syntax (p, EXP_BODY_ARG_N (v, 1));
	}
    }

  return 1;
}
 
/* BAR_X  OR_X  ȯѴ.  , [a-c] ڵ带 (a|b|c) ڵ ȯϴ ̴.  ̴
    hre_form_states () Լ óǱ ؼ̴.  */
void
hre_process_syntax_bar_x (p, last_rhs)
     struct hre_tree *p;
     int last_rhs;
{
  int arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);
  int arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 1);
  int arg0_len = SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
  char *arg0_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
  char *arg1_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))));
  int i;

  /*  */
  if (arg0_len == 1)
    {
      int fst = ((int) arg0_str[0] & 0xff);
      int snd = ((int) arg1_str[0] & 0xff);
      int length = snd - fst + 1;
      int ident[length];
      int ort[length-1];

      /* ڰ ׻  ڸ  ϴ  ƴϴ. [&-0]  
	    ִ.  */
      for (i=0; i<length; i++)
	{
	  char str[2];
	  struct hre_token token, *t = &token;

	  str[0] = (char) fst + i;
	  str[1] = '\0';

	  TOKEN_TYPE (t) = IDENTIFIER_T;
	  TOKEN_NAME (t) = str;
	  TOKEN_LEN (t)  = 1;
	  ident[i] = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));
	}
      for (i=0; i<length-1; i++)
	{
	  if (i == 0)
	    ort[i] = hre_make_exp (p, -1, OR_X, ident[i], ident[i+1]);
	  else
	    ort[i] = hre_make_exp (p, -1, OR_X, ident[i+1], ort[i-1]);
	}
      hre_make_exp (p, last_rhs, OR_X, ort[i-1], hre_make_exp (p, -1, ZERO_X));
    }
}

/* ѱ BAR_X  OR_X  ȯѴ.  TYPE   óϰ ϴ  ʼ  0, ߼ 
   1,   2  .  IS_UNICODE   ѱ BAR_X  ϴ  ڵ
   , 1  ǰ ȴ.  ̴ ߿ ѱ mapping  ǰ  ,  ڵ带 
   ϴµ ȴ.  */
void
hre_process_syntax_han_bar_x2 (p, last_rhs, parent, arg, type, is_unicode)
     struct hre_tree *p;
     int last_rhs;
     int parent;
     int arg;
     int type;
     int *is_unicode;
{
  int arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);
  int arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 1);
  int arg0_len = SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
  char *arg0_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg0))));
  char *arg1_str = SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))));
  int i, fst=0, snd=0, length=0;

  /* Ȯ ϼ   ƾ.   ̰ 2   ϼ ϸ,
     ׷  , ڵ Ѵ.  */
  if (arg0_len == 2)
    {
      int arg0_int, arg1_int, *ch;

      arg0_int = hre_str2word (arg0_str);
      arg1_int = hre_str2word (arg1_str);

      /*  Ѵ.   ʼ, ߼,   ޶  ִ.  */
      ch = (type == 0) ? ksc5601_cho : (type == 1) ? ksc5601_jung : ksc5601_jong;
      while (ch[fst] != -1)
	{
	  if (arg0_int == ch[fst])
	    break;
	  fst++;
	}
      while (ch[snd] != -1)
	{
	  if (arg1_int == ch[snd])
	    break;
	  snd++;
	}
      length = snd - fst + 1;
      if (length < 0)
	{
	  hre_error ("  ̻մϴ.\n");
	  TREE_LAST_RHS (p) = -1;
	  return;
	}
      
      /* Ʒʹ   OR_X node  Ѵ.  */
      {
	int ident[length];
	int ort[length-1];
	int z;
	/*  1   ܼ ġȯ ش.  */
	if (length == 1)
	  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, parent)), arg) = arg0;
	else
	  {
	    for (i=0; i<length; i++)
	      {
		char str[3];
		struct hre_token token, *t = &token;
		
		str[0] = ch[fst+i] >> 8;
		str[1] = ch[fst+i] & 0xff;
		str[2] = '\0';
		
		TOKEN_TYPE (t) = IDENTIFIER_T;
		TOKEN_NAME (t) = str;
		TOKEN_LEN (t)  = 2;
		ident[i] = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));
	      }
	    for (i=0; i<length-1; i++)
	      {
		if (i == 0)
		  ort[i] = hre_make_exp (p, -1, OR_X, ident[i], ident[i+1]);
		else
		  ort[i] = hre_make_exp (p, -1, OR_X, ort[i-1], ident[i+1]);
	      }
	    z = hre_make_exp (p, -1, OR_X, ort[i-1], hre_make_exp (p, -1, ZERO_X));
	    EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, parent)), arg) = z;
	  }
      }
    }
  else if (arg0_len == 3)
    {
      int arg0_ucs2, arg1_ucs2, *us;

      UTF8toUCS2 (arg0_str, &arg0_ucs2);
      UTF8toUCS2 (arg1_str, &arg1_ucs2);

      /*  Ѵ.   ʼ, ߼,   ޶  ִ.  */
      us = (type == 0) ? unicode_cho : (type == 1) ? unicode_jung : unicode_jong;
      while (us[fst] != -1)
	{
	  if (arg0_ucs2 == us[fst])
	    break;
	  fst++;
	}
      while (us[snd] != -1)
	{
	  if (arg1_ucs2 == us[snd])
	    break;
	  snd++;
	}
      length = snd - fst + 1;
      if (length < 0)
	{
	  hre_error ("  ̻մϴ.\n");
	  TREE_LAST_RHS (p) = -1;
	  return;
	}
      /* Ʒʹ   OR_X node  Ѵ.  */
      {
	int ident[length];
	int ort[length-1];
	int z;
	/*  1   ܼ ġȯ ش.  */
	if (length == 1)
	  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, parent)), arg) = arg0;
	else
	  {
	    for (i=0; i<length; i++)
	      {
		char str[4];
		struct hre_token token, *t = &token;
		
		UCS2toUTF8 (&us[fst+i], 1, str);
		
		TOKEN_TYPE (t) = IDENTIFIER_T;
		TOKEN_NAME (t) = str;
		TOKEN_LEN (t)  = 3;
		ident[i] = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));
	      }
	    for (i=0; i<length-1; i++)
	      {
		if (i == 0)
		  ort[i] = hre_make_exp (p, -1, OR_X, ident[i], ident[i+1]);
		else
		  ort[i] = hre_make_exp (p, -1, OR_X, ort[i-1], ident[i+1]);
	      }
	    z = hre_make_exp (p, -1, OR_X, ort[i-1], hre_make_exp (p, -1, ZERO_X));
	    EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, parent)), arg) = z;
	  }
      }
    }
  else
    {
      hre_error ("߸ ڿ.\n");
      abort ();
    }
}

/* ѱ  ǥĿ ѱ  BAR_X  ǰ Ǵµ,  ѱ  OR_X 
   ȯϰ ȴ.  ARG   0 ̸, ʼ, 1 ̸ ߼, 2 ̸  ǹϸ, IS_UNICODE
    ѱ BAR_X  ڵ Ǿ  , 1  ȴ.  */
void
hre_process_syntax_han_bar_x (p, last_rhs, parent, arg, type, is_unicode)
     struct hre_tree *p;
     int last_rhs;
     int parent;
     int arg;
     int type;
     int *is_unicode;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args = EXP_ARGS (v);
      int tag = EXP_TAG (v);

      if (tag == BAR_X)
	hre_process_syntax_han_bar_x2 (p, last_rhs, parent, arg, type, is_unicode);
      
      if (args == 0 && EXP_TAG (v) != ZERO_X && EXP_TAG (v) != ONE_X)
	{
	  int length = SYM_LENGTH (EXP_BODY_LEAF (v));

	  if (length > 2)
	    *is_unicode = 1;
	}
      else if (args == 1 )
	hre_process_syntax_han_bar_x (p, EXP_BODY_ARG_N (v, 0), last_rhs, 0, type, is_unicode);
      else if (args == 2 )
	{
	  hre_process_syntax_han_bar_x (p, EXP_BODY_ARG_N (v, 0), last_rhs, 0, type, is_unicode);
	  hre_process_syntax_han_bar_x (p, EXP_BODY_ARG_N (v, 1), last_rhs, 1, type, is_unicode);
	}
    } 

}

/* տ ѱ BAR_X  ѱ OR_X  ȯϰ Ǵµ, ̸   ʼ, ߼, 
    map  ׸ ȴ.  ̷ ϴ  ڰ Է [ ~ ] ǥĿ 
   龦 , ȿ óϱ ؼ, ̿  character map  ׸ ʿ䰡
   ִµ, ѱۿ  character map  ׸   ۾̴.  */
void
hre_process_explorer_han_x (p, rhs, map, type, max)
     struct hre_tree *p;
     int rhs, *map, type, max;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, rhs));

  if (v)
    {
      int args = EXP_ARGS (v);
      
      if (args == 0 && EXP_TAG (v) != ZERO_X && EXP_TAG (v) != ONE_X)
	{
	  int length = SYM_LENGTH (EXP_BODY_LEAF (v));
	  char *str = SYM_NAME (EXP_BODY_LEAF (v));

	  /* TODO Ȯ ϼ , hre_str2word () Լ ̿Ͽ, 2 Ʈ 
	     int    ִµ, ̴ Solaris   ýۿ endian 
	     ̷ ,  ߻ų  ִ    ִ.  */

	  /* Ȯ ϼ  */
	  if (length == 2)
	    {
	      int k, w = hre_str2word (str);

	      if (type == 0)
		{
		  /* ʼ */
		  k = ksc5601_cho_mapping[w - 0xa4a1];
		  if (k != -1)
		    map[k] = 1;
		}
	      else if (type == 1)
		/* ߼ */
		map[w - 0xa4bf] = 1;
	      else if (type == 2)
		{
		  /*  */
		  k = ksc5601_jong_mapping[w - 0xa4a1];
		  if (k != -1)
		    map[k] = 1;
		}
	    }
	  else if (length == 3)
	    {
	      /* ڵ */
	      int str_ucs2, k;
	      UTF8toUCS2 (str, &str_ucs2);
	      if (type == 0)
		{
		  k = unicode_cho_mapping[str_ucs2 - 0x3131];
		  if (k != -1)
		    map[k] = 1;
		}
	      else if (type == 1)
		map[str_ucs2 - 0x314f] = 1;
	      else if (type == 2)
		{
		  k = unicode_jong_mapping[str_ucs2 - 0x3131];
		  if (k != -1)
		    map[k] = 1;
		}
	    }
	}
      else if (args == 1 )
	hre_process_explorer_han_x (p, EXP_BODY_ARG_N (v, 0), map, type, max);
      else if (args == 2 )
	{
	  hre_process_explorer_han_x (p, EXP_BODY_ARG_N (v, 0), map, type, max);
	  hre_process_explorer_han_x (p, EXP_BODY_ARG_N (v, 1), map, type, max);
	}
    }
}

/* Integer  ѱ ڵ带 ̿Ͽ  ǥ Ѵ.  Ʒ    
   ǥ   hre_apply_multi_form () Լ ߻  ִ load 
   ִ ̱ ؼ ̴.  NUM  interger  ȯ ѱ ڵ尡  ִ.  
   ix86  UTF-8  , 3 Ʈ ϱ , int  4 Ʈ ̻ 
   ó ϴ.   UTF-16  , 4 Ʈ̱  ̿   ؾ 
    ̴.  */
int
hre_make_han_symx (p, num)
     struct hre_tree *p;
     int num;
{
  char s1[2], s2[2], s3[2];
  int a, b, c;
  int len = (num & 0xff0000) ? 3 : 2;
  struct hre_token token, *t = &token;

  if (len == 2)
    {
      /* Ȯ ϼ */
      s1[0] = num >> 8;
      s1[1] = '\0';
      TOKEN_TYPE (t) = IDENTIFIER_T;
      TOKEN_NAME (t) = s1;
      TOKEN_LEN (t)  = 1;
      a = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));

      s2[0] = num & 0xff;
      s2[1] = '\0';
      TOKEN_TYPE (t) = IDENTIFIER_T;
      TOKEN_NAME (t) = s2;
      TOKEN_LEN (t)  = 1;
      b = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));
      
      return hre_make_exp (p, -1, AND_X, a, b);
    }
  else if (len == 3)
    {
      /* UTF-8  ڵ */
      s1[0] = num >> 16;
      s1[1] = '\0';
      TOKEN_TYPE (t) = IDENTIFIER_T;
      TOKEN_NAME (t) = s1;
      TOKEN_LEN (t)  = 1;
      a = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));

      s2[0] = num >> 8 & 0xff;
      s2[1] = '\0';
      TOKEN_TYPE (t) = IDENTIFIER_T;
      TOKEN_NAME (t) = s2;
      TOKEN_LEN (t)  = 1;
      b = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));

      s3[0] = num & 0xff;
      s3[1] = '\0';
      TOKEN_TYPE (t) = IDENTIFIER_T;
      TOKEN_NAME (t) = s3;
      TOKEN_LEN (t)  = 1;
      c = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));

      return hre_make_exp (p, -1, AND_X, a, hre_make_exp (p, -1, AND_X, b, c));
    }

  else
    hre_error ("hre_make_han_symx: %d %x ERROR", len, num);

  return -1;
}

/* ʼ, ߼,  node  ϴ ڸ ؼ,   ڸ س Ѵ. */
void
hre_psyntax_han_x2 (p, last_rhs, cho, jung, jong, hangul)
     struct hre_tree *p;
     int last_rhs, cho, jung, jong;
     int hangul[19][21][28];
{
  register int i, j, k;

  /* ѱ      ,  ϱ   Ͽµ,
       CHO, JUNG, JONG node   ش ڵ鿡   ׸
     ̴.  ̰  , ksc5601code.c  ksc5601code 迭 Ѵ.  */
  int map_cho[19], map_jung[21], map_jong[28];

  /* ʱȭ */
  for (i=0; i < 19; i++)
    map_cho[i] = 0;
  for (i=0; i < 21; i++)
    map_jung[i] = 0;
  for (i=0; i < 28; i++)
    map_jong[i] = 0;

  /*    map  ׸.   ܰ谡    HAN_X   ʼ, ߼, 
     tag  OR_X  ȯǾٰ Ѵ.

     ѱ ü ڸ :
                                */
  hre_process_explorer_han_x (p, cho, map_cho, 0, 19);
  hre_process_explorer_han_x (p, jung, map_jung, 1, 21);
  hre_process_explorer_han_x (p, jong, map_jong, 2, 28);

#if 0
  /*  ۼ map  Ѵ.  */
  for (i=0;i<19;i++)
    fprintf (stderr, "%2d",map_cho[i]);
  fprintf (stderr, "\n");
  for (i=0;i<21;i++)
    fprintf (stderr, "%2d",map_jung[i]);
  fprintf (stderr, "\n");
  for (i=0;i<28;i++)
    fprintf (stderr, "%2d",map_jong[i]);
  fprintf (stderr, "\n");
#endif

  /* [<,,>] İ [<,,>]  ؼ óѴ.  ˰ 
     ʿ  ϴ.  켱 ش ڵ鿡  ̸ Ѵ.  */
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jong))) == ZERO_X)
    {
      for (i = 0; i < 19; i++)
	if (map_cho[i])
	  for (j = 0; j < 21; j++)
	    if (map_jung[j])
	      hangul[i][j][0] = 1;
    }
  else
    {
      for (i = 0; i < 19; i++)
	if (map_cho[i])
	  for (j = 0; j < 21; j++)
	    if (map_jung[j])
	      for (k = 0; k < 28; k++)
		if (map_jong[k])
		  hangul[i][j][k] = 1;
    }
}

/* ѱ , ʼ+߼+(if any)   ڰ ,  ʼ, ,  
   ڵ  иǾ ִ.   ڰ ѱ  ǥĿ ̷ ڸ  
    , ϼ ѱ ڵʹ и ó  Ѵ.  JAMO  map  迭  */
void
hre_psyntax_only_jamo (p, last_rhs, jamo)
     struct hre_tree *p;
     int last_rhs, *jamo;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args = EXP_ARGS (v);

      if (args == 0 && EXP_TAG (v) != ZERO_X && EXP_TAG (v) != ONE_X)
	{
	  int length = SYM_LENGTH (EXP_BODY_LEAF (v));
	  char *str = SYM_NAME (EXP_BODY_LEAF (v));

	  if (length == 2)
	    {
	      int a = hre_str2word (str);
	      jamo[a - 0xa4a1] = 1;
	    }
	  else if (length == 3)
	    {
	      int ucs2;
	      
	      UTF8toUCS2 (str, &ucs2);
	      jamo[ucs2 - 0x3131] = 1;
	    }
	  else
	    {
	      fprintf (stderr, "ó ٶ\n");
	      abort ();
	    }
	}
      else if (args == 1 )
	hre_psyntax_only_jamo (p, EXP_BODY_ARG_N (v, 0), jamo);
      else if (args == 2 )
	{
	  hre_psyntax_only_jamo (p, EXP_BODY_ARG_N (v, 0), jamo);
	  hre_psyntax_only_jamo (p, EXP_BODY_ARG_N (v, 1), jamo);
	}
    }
}

/* HAN_X  OR_X  ȯѴ.  ``ǥ''  ù°  HAN_X  ݵ Ʒ 
   ̿ Ѵ. 

    E4   -> E0 [ѱ] E3
        E0   -> ʼ
        E3   -> E1 [ѱ] E2
             E1   -> ߼
             E2   -> 

   ̰ ѱ ʼ, ߼,    ׻    Ǿ ϴµ,
     ó ù° HAN_X  ι° ڴ ݵ HAN_X  Ѵٴ ̴.

   ⼭   ִ ѱڵ ݵ ȯ Ȥ Ȯϼ, ڵ忩 ϴµ, ֳϸ
    , κ  (windows )  ϴ Ȯϼ   ִ
     ʱ ̴.

   ʼ:                    
   ߼:                      
   :                           */
void
hre_psyntax_han_x (p, last_rhs, hangul, hangul_jamo, is_unicode)
     struct hre_tree *p;
     int last_rhs;
     int hangul[19][21][28];
     int hangul_jamo[51];
     int *is_unicode;
{
  int arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);
  int arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 1);
  int cho, jung, jong;

  /* ù°  TAG  HAN_X  ƴ , 츮 óϸ ȵǴ node ̴.  */
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, arg1))) != HAN_X)
    return;

  cho = arg0;
  jung = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 0);
  jong = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 1);

  /*  <,,>   Է°   ̸ ؾ Ѵ.  */
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, cho))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) == ZERO_X)
  {
    (void) hre_make_exp (p, last_rhs, ZERO_X);
	return;
  }

  /* 켱 ʼ, ߼,  ϴ BAR_X  OR_X  ȯ ϴµ,  ѱ ,
     ܼ for  ذ   Ѱ谡 ִ.  ׸ ϼ, ڵ带 
       ־ Ѵ.  */
  hre_process_syntax_han_bar_x (p, cho, last_rhs, 0, 0, is_unicode);
  hre_process_syntax_han_bar_x (p, jung, arg1, 0, 1, is_unicode);
  hre_process_syntax_han_bar_x (p, jong, arg1, 1, 2, is_unicode);

  /*  hre_process_syntax_han_bar_x () Լ ó ؼ, cho, jung, jong
      شϴ    ִ.  ̸ ٽ Ʈ  Ѵ.  */
  arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);
  cho = arg0;
  arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 1);
  jung = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 0);
  jong = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 1);
  
  /*    ˵ .  */
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, cho))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) != ZERO_X)
    {
      hre_error ("[<,,->]    ǥ   ϴ.\n");
      abort ();
    }
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, cho))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) != ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jong))) != ZERO_X)
    {
      hre_error ("[<,,>]    ǥ   ϴ.\n");
      abort ();
    }

  /*  ʼ, ߼,   node  BAR_X   OR_X  ȯ Ͽ.
     Ʒʹ ʼ, ߼,      ڵ  .  

     ѱ  ǥĿ Խ  Ʒ  · Ÿ.

       [<ʼ,߼,>]

     [ ~ ] Ÿڳ ѱ ǥ ݵ '<'  '>' ̿ ; ϸ, 'ʼ' 
     '߼', ''     ǥ   ִ.

       1) -
       2) -
       3) -
       4) -

      ʼ, ߼,    ǥ   ִ.   ݵ ','  
     ׻ ٿ־ Ѵ.  ̷  ؼ ǥ  ִ     
       ְڴ.

       [<-,,>]

            ʼ  ~   .  
	   ) , , 

       [<,-,>]

           ʼ  Ȥ ,  ̰, ߼  ~    ִ .
	   ) , , , , 

       [<,,->]

           ʼ  ̰, ߼ ,   ~   ڵ.
	   ) ,  

       [<,-,>]

            ߼  ~   
	   ) , , , ,  

       [<,-,->]

           ʼ ''   
	   ) , ,  

       [<-,,->]

           ߼ ''   
	   ) , ,  

       [<-,-,>]

            ''   

       [<,,->]

           !!! ̷ ǥ   .  ѱ ڵ忡   ѱ ڵ
	   ü  ʴ´. !!!

       [<,,>]

           !!! ̷ ǥ    .  ѱ ڵ忡 ʼ  ѱ ڵ
	    ʴ´. !!!

       [<,,>]

           !!! ̷ ǥ    .  ѱ ڵ忡 ߼  ѱ ڵ
	    ʴ´. !!!

	   
     ⺻ 'ʼ'  '߼', '' κ  , ش ڰ  ѱ
     ˻ϰ Ѵ.  */

  /* [<-,,>] Ȥ [<,-,>]   ʼ Ȥ ߼ ϴ ܼ  
     óѴ.  */
  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, cho))) != ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) == ZERO_X
      && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jong))) == ZERO_X)
    {
      hre_make_exp (p, last_rhs, OR_X, cho, hre_make_exp (p, -1, ZERO_X));

      hre_psyntax_only_jamo (p, cho, hangul_jamo);
    }
  else if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, cho))) == ZERO_X
	   && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jung))) != ZERO_X
	   && EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (p, jong))) == ZERO_X)
    {
      hre_make_exp (p, last_rhs, OR_X, jung, hre_make_exp (p, -1, ZERO_X));

      hre_psyntax_only_jamo (p, jung, hangul_jamo);
    }
  else
    /*   ٸ  óѴ.   ܼ  ƴϴ.  */
    hre_psyntax_han_x2 (p, last_rhs, cho, jung, jong, hangul);

  /* ⼭ ѱ ǥ ZERO_X  ٲ   ڰ Է
     ѱ +  map   ׷ȱ ,  ̻ [ ~ ] ǥ ʿ
     ʱ ̴.  */
  hre_make_exp (p, last_rhs, ZERO_X);
}

/* ڰ Է ϳ [ ~ ] ǥĿ ؼ óѴ.  */
void
hre_psyntax_opt_x (p, last_rhs, ascii, hangul, hangul_jamo, is_unicode)
     struct hre_tree *p;
     int last_rhs;
     int *ascii, hangul[19][21][28], *hangul_jamo, *is_unicode;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args;
      int tag = EXP_TAG (v);

      if (tag == HAN_X)/* Ȯ ϼ */
	hre_psyntax_han_x (p, last_rhs, hangul, hangul_jamo, is_unicode);
      else if (tag == BAR_X)
	hre_process_syntax_bar_x (p, last_rhs);
      
      /*  REVERSE_X   ִ  HAN_X , BAR_X   Ǿ
	 Ѵ.   ׿   ASCII  HANGUL 迭    ̴.  */
      v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));
      args = EXP_ARGS (v);

      if (args == 0 && EXP_TAG (v) != ZERO_X && EXP_TAG (v) != ONE_X)
	{
	  int length = SYM_LENGTH (EXP_BODY_LEAF (v));
	  char *str = SYM_NAME (EXP_BODY_LEAF (v));

	  if (length == 1)
	    ascii[((int) str[0])] = 1;
	  else if (length == 2)
	    {
	      /* (ϼ) ѱ , ̸ и óؾ Ѵ.  */
	      int a = hre_str2word (str);
	      if (a > 0xa4a0 && a < 0xa4d4)
		  /* -, -    ڸ̴.  */
		  hangul_jamo[a - 0xa4a1] = 1;
	      else
		{
		  int *b = ksc5601code_splited[a - 0x8141];
		  if (b[0] == -1 || b[1] == -1 || b[1] == -1)
		    {
		      fprintf (stderr, "ѱ ڵ Ȯ ٶ\n");
		      abort ();
		    }

		  hangul[(b[0])][(b[1])][(b[2])] = 1;
		}
	    }
	  else
	    {
	      int ucs2;
	      
	      UTF8toUCS2 (str, &ucs2);
	      
	      if (ucs2 > 0x3130 && ucs2 < 0x3164)
		hangul_jamo[ucs2 - 0x3131] = 1;
	      else
		{
		  int i, j, k;

		  i = (ucs2 - 0xac00) / (21 * 28);
		  j = (ucs2 - 0xac00) % (21 * 28) / 28;
		  k = (ucs2 - 0xac00) % 28;

		  hangul[i][j][k] = 1;
		}
	      *is_unicode = 1;
	    }
	}
      else if (args == 1 )
	hre_psyntax_opt_x (p, EXP_BODY_ARG_N (v, 0), ascii, hangul, hangul_jamo, is_unicode);
      else if (args == 2 )
	{
	  hre_psyntax_opt_x (p, EXP_BODY_ARG_N (v, 0), ascii, hangul, hangul_jamo, is_unicode);
	  hre_psyntax_opt_x (p, EXP_BODY_ARG_N (v, 1), ascii, hangul, hangul_jamo, is_unicode);
	}
    } 
}

/* IS_REVERSE  "[^a-z]"   ǥ , 1 ̴.  */
void
hre_process_syntax_opt_x (p, last_rhs, is_reverse)
     struct hre_tree *p;
     int last_rhs, is_reverse;
{
  register int i, j, k;
  int total_length = 0, ascii_length = 0;
  int hangul_length = 0, hangul_jamo_length = 0;
  int map_ascii[0x80];
  int map_hangul[19][21][28];
  int map_hangul_jamo[51];
  int is_unicode = 0;

  /* ̺ ʱȭ */
  for (i=0; i<0x80; i++)
    map_ascii[i] = 0;
  for (i=0; i<19; i++)
    for (j=0; j<21; j++)
      for (k=0; k<28; k++)
	map_hangul[i][j][k] = 0;
  for (i=0; i<51; i++)
    map_hangul_jamo[i] = 0;

  /*  Լ map  ϼؾ Ѵ.  */
  hre_psyntax_opt_x (p, last_rhs, map_ascii, map_hangul, map_hangul_jamo, &is_unicode);

  /*  ̿  ̿ Ѵٸ ̸ óѴ.  ˰  ʿϴ.  */
  if (is_reverse)
    {
      for (i=0; i<0x80; i++)
	if (map_ascii[i])
	  {
	    ascii_length++;
	    break;
	  }
      for (i=0; i<19; i++)
	{
	  for (j=0; j<21; j++)
	    {
	      for (k=0; k<28; k++)
		{
		  if (map_hangul[i][j][k])
		    {
		      hangul_length++;
		      break;
		    }
		}
	      if (hangul_length)
		break;
	    }
	  if (hangul_length)
	    break;
	}
      for (i=0; i<51; i++)
	if (map_hangul_jamo[i])
	  {
	    hangul_jamo_length++;
	    break;
	  }
      
      if (ascii_length)
	{
	  for (i=0; i<0x80; i++)
	    {
	      if (map_ascii[i])
		map_ascii[i] = 0;
	      else
		map_ascii[i] = 1;
	    }
	}
      if (hangul_length)
	{
	  for (i=0; i<19; i++)
	    for (j=0; j<21; j++)
	      for (k=0; k<28; k++)
		{
		  if (map_hangul[i][j][k])
		    map_hangul[i][j][k] = 0;
		  else
		    map_hangul[i][j][k] = 1;
		}
	}
      if (hangul_jamo_length)
	{
	  for (i=0; i<51; i++)
	    {
	      if (map_hangul_jamo[i]) 
		map_hangul_jamo[i] = 0;      
	    }
	}
    }

  ascii_length = 0;
  hangul_length = 0;
  hangul_jamo_length = 0;

  /*   Ѵ.  */
  for (i=0; i<0x80; i++)
    if (map_ascii[i])
      {
	total_length++;
	ascii_length++;
      }
  for (i=0; i<19; i++)
    for (j=0; j<21; j++)
      for (k=0; k<28; k++)
	if (map_hangul[i][j][k])
	  {
	    total_length++;
	    hangul_length++;
	  }
  for (i=0; i<51; i++)
    if (map_hangul_jamo[i])
      {
	total_length++;
	hangul_jamo_length++;
      }
  
  /*   ϷǾ  ̸  ǥ ϼѴ.  */
#if 0
  fprintf (stderr, "Length = %d, ASCII = %d, HANGUL = %d, Hangul Jamo = %d\n", 
	   total_length, ascii_length, hangul_length, hangul_jamo_length);
#endif
  if (total_length == 0)
    {
      hre_make_exp (p, last_rhs, ZERO_X);
      return;
    }

  {
    int ident[total_length], pos = 0;
    int ort[total_length-1];
    
    /* ASCII   ǥ ۼ */
    if (ascii_length)
      {
	for (i=0; i<0x80; i++)
	  if (map_ascii[i])
	    {
	      char str[2];
	      struct hre_token token, *t = &token;
	      
	      str[0] = (char) i;
	      str[1] = '\0';
	      TOKEN_TYPE (t) = IDENTIFIER_T;
	      TOKEN_NAME (t) = str;
	      TOKEN_LEN (t)  = 1;
	      ident[pos++] = hre_make_exp (p, -1, SYM_X, hre_lookup (p, t));
	    }
      }
    /* ѱۿ  ǥ ۼ */
    if (hangul_length)
      {
	for (i=0; i<19; i++)
	  for (j=0; j<21; j++)
	    for (k=0; k<28; k++)
	      if (map_hangul[i][j][k])
		{
		  if (is_unicode)
		    ident[pos++] = hre_make_han_symx (p, unicode[i][j][k]);
		  else
		    ident[pos++] = hre_make_han_symx (p, ksc5601code[i][j][k]);
		}
      }
    /* ѱ ڸ  ǥ ۼ */
    if (hangul_jamo_length)
      {
	for (i=0; i<51; i++)
	  if (map_hangul_jamo[i])
	    {
	      if (is_unicode)
		{
		  int num = 0, ucs2 = 0x3131 + i;
		  char str[4];

		  UCS2toUTF8 (&ucs2, 1, str);
		  num += ((int) str[0]);
		  num <<= 8;
		  num += ((int) str[1]);
		  num <<= 8;
		  num += ((int) str[2]);

		  ident[pos++] = hre_make_han_symx (p, num);
		}
	      else
		ident[pos++] = hre_make_han_symx (p, 0xa4a1 + i);
	    }
      }
    if (total_length == 1)
      hre_make_exp (p, last_rhs, OR_X, ident[0], hre_make_exp (p, -1, ZERO_X));
    else
      {
	for (i = 0; i < total_length-1; i++)
	  {
	    if (i == 0)
	      ort[i] = hre_make_exp (p, -1, OR_X, ident[i], ident[i+1]);
	    else
	      ort[i] = hre_make_exp (p, -1, OR_X, ident[i+1], ort[i-1]);
	  }
	hre_make_exp (p, last_rhs, OR_X, ort[i-1], hre_make_exp (p, -1, ZERO_X));
      }
  }
}

/* "ab?d"   ԽĿ ?  óѴ.  */
void
hre_process_syntax_ask_x (p, last_rhs, parent)
     struct hre_tree *p;
     int last_rhs, parent;
{
  int c_arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);

  hre_make_exp (p, last_rhs, OR_X, hre_make_exp (p, -1, ONE_X), c_arg0);
}

/* a{3, 4}   ǥ óѴ.  */
void
hre_process_syntax_range_x (p, last_rhs)
     struct hre_tree *p;
     int last_rhs;
{
  int i, j;
  int arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 0);
  int arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs)), 1);
  int r_arg0, r_arg1;
  struct exp *v1 = EQU_VALUE (TREE_EQU_TAB_N (p, arg1));
  struct exp *r_v0, *r_v1;
  
  /* a{3}    츦 óؾ Ѵ.  */
  if (EXP_TAG (v1) != AND_X && EXP_TAG (v1) != ONE_X)
    {
      if (EXP_TAG (v1) == SYM_X)
	{
	  int rnum = atoi (SYM_NAME (EXP_BODY_LEAF (v1)));

	  if (rnum < 0 || rnum > 9)
	    fprintf (stderr, "a{3}   0 ~ 9 ̿ Ѵ.\n");
	
	  if (rnum == 0)
	    hre_make_exp (p, last_rhs, ZERO_X);
	  else if (rnum == 1)
	    hre_make_exp (p, last_rhs, OR_X, arg0, hre_make_exp (p, -1, ZERO_X));
	  else
	    {
	      int andt[rnum -1];

	      for (i = 0; i < rnum - 1; i++)
		{
		  if (i == 0)
		    andt[i] = hre_make_exp (p, -1, AND_X, arg0, arg0);
		  else
		    andt[i] = hre_make_exp (p, -1, AND_X, arg0, andt[i-1]);
		}
	      hre_make_exp (p, last_rhs, OR_X, andt[i-1], hre_make_exp (p, -1, ZERO_X));
	    }
	  return;
	}
      else
	{
	  fprintf (stderr, "߸ a{4} ̴.\n");
	  abort ();
	}
    }

  r_arg0 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 0);
  r_arg1 = EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (p, arg1)), 1);
  r_v0 = EQU_VALUE (TREE_EQU_TAB_N (p, r_arg0));
  r_v1 = EQU_VALUE (TREE_EQU_TAB_N (p, r_arg1));
  
  /* a{3,}    óѴ.  */
  if (EXP_TAG (r_v0) == SYM_X && EXP_TAG (r_v1) == ONE_X)
    {
      int rnum = atoi (SYM_NAME (EXP_BODY_LEAF (r_v0)));

      if (rnum < 0 || rnum > 9)
	fprintf (stderr, "a{3,}   0 ~ 9 ̿ Ѵ.\n");
      
      if (rnum == 0)
	hre_make_exp (p, last_rhs, STAR_X, arg0);
      else if (rnum == 1)
	hre_make_exp (p, last_rhs, PLUS_X, arg0);
      else
	{
	  int andt[rnum-1];
	  
	  for (i = 0; i < rnum-2; i++)
	    {
	      if (i == 0)
		andt[i] = hre_make_exp (p, -1, AND_X, arg0, arg0);
	      else
		andt[i] = hre_make_exp (p, -1, AND_X, andt[i-1], arg0);
	    }
	  andt[i] = hre_make_exp (p, -1, PLUS_X, arg0);
	  if (rnum == 2)
	    hre_make_exp (p, last_rhs, AND_X, arg0, andt[i]);
	  else
	    hre_make_exp (p, last_rhs, AND_X, andt[i-1], andt[i]);
	}
      return;
    }
  
  /* a{3,5}    óѴ.  */
  if (EXP_TAG (r_v0) == SYM_X && EXP_TAG (r_v1) == SYM_X)
    {
      int rnum0 = atoi (SYM_NAME (EXP_BODY_LEAF (r_v0)));
      int rnum1 = atoi (SYM_NAME (EXP_BODY_LEAF (r_v1)));
      int anum = rnum1 - rnum0;
      int andt[rnum1];
      if ((rnum0 < 0 || rnum0 > 9) || (rnum1 < 0 || rnum1 > 9))
	fprintf (stderr, "a{3,4}   0 ~ 9 ̿ Ѵ.\n");
      if (rnum0 > rnum1)
	{
	  TREE_ERRNO (p) = REG_BADBR;
	  return;
	}

      for (i=0; i<rnum0 - 1; i++)
	{
	  if (i == 0)
	    andt[i] = hre_make_exp (p, -1, AND_X, arg0, arg0);
	  else
	    andt[i] = hre_make_exp (p, -1, AND_X, andt[i-1], arg0);
	}
      if ((rnum0 == 1 && rnum1 == 1))
	andt[i++] = hre_make_exp (p, -1, OR_X, arg0, hre_make_exp (p, -1, ZERO_X));
      else if (rnum0 == 1)
	andt[i++] = hre_make_exp (p, -1, OR_X, arg0, hre_make_exp (p, -1, ZERO_X));
   
      /*  պκ  Ѵ.  */
      if (anum == 0)
	{
	  if (rnum0 == 0 && rnum1 == 0)
	    hre_make_exp (p, last_rhs, ONE_X);
	  else
	    hre_make_exp (p, last_rhs, OR_X, andt[i-1], hre_make_exp (p, -1, ZERO_X));
	}
      else if (anum == 1)
	{
	  if (rnum0 > 0)
	    {
	      hre_make_exp (p, last_rhs, AND_X,
			    andt[i-1],
			    hre_make_exp (p, -1, ASK_X, arg0));
	    }
	  else
	    {
	      hre_make_exp (p, last_rhs, OR_X,
			    hre_make_exp (p, -1, ASK_X, arg0),
			    hre_make_exp (p, -1, ZERO_X));
	    }
	}
      else
	{
	  int askt[anum-1];
	  for (j = 0; j < anum - 1; j++)
	    {
	      if (j == 0)
		askt[j] = hre_make_exp (p, -1, ASK_X, arg0);
	      else
		askt[j] = hre_make_exp (p, -1, AND_X, 
					askt[j-1], 
					hre_make_exp (p, -1, ASK_X, arg0));
	    }
	  if (rnum0 == 0)
	    hre_make_exp (p, last_rhs, AND_X, askt[j-1], hre_make_exp (p, -1, ASK_X, arg0));
	  else
	    hre_make_exp (p, last_rhs, AND_X, 
			  andt[i-1],
			  hre_make_exp (p, -1, AND_X, 
					askt[j-1], 
					hre_make_exp (p, -1, ASK_X, arg0)));
	}
    }
}

/* Խ ``ǥ'' ϴ node , hre_form_states () Լ ϱ 
   Ư ó ־ ϴ κ ϴµ,  OPT_X, REVERSE_X, BAR_X, RANGE_X
   ASK_X  ؼ    ϸ, ̸  ȯ   ,
   µ    ߻ų  ִ.  */
void
hre_process_syntax (p, last_rhs, parent)
     struct hre_tree *p;
     int last_rhs;
     int parent;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args;
      int tag = EXP_TAG (v);

      if (tag == OPT_X)
	hre_process_syntax_opt_x (p, last_rhs, 0);
      else if (tag == REVERSE_X)
	hre_process_syntax_opt_x (p, last_rhs, 1);
      else if (tag == BAR_X)
	hre_process_syntax_bar_x (p, last_rhs);
      else if (tag == RANGE_X)
	hre_process_syntax_range_x (p, last_rhs);
      else if (tag == ASK_X)
	hre_process_syntax_ask_x (p, last_rhs, parent);

      /*  HAN_X  BAR_X  óϸ鼭 last_rhs node   ȭ  
	 ֱ  ⿡ óѴ.  */
      v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));
      args = EXP_ARGS (v);

      if (args == 1 )
	  hre_process_syntax (p, EXP_BODY_ARG_N (v, 0), last_rhs);
      else if (args == 2 )
	{
	  hre_process_syntax (p, EXP_BODY_ARG_N (v, 0), last_rhs);
	  hre_process_syntax (p, EXP_BODY_ARG_N (v, 1), last_rhs);
	}
    } 

}

/* Ƽ Ʈ  ó ؾ ϴµ, ƼƮ ó ϴ  Ʒ .
   ϼ  `Ȳ'  ,  ``ǥ'' ϳ ǥ Ÿ ִµ,

     E0 -> Ȳ

   ̸ ΰ CONCATENATION  ϴ ̴.  `Ȳ'  2 Ʈ (0xc8b2) ̹Ƿ
   Ʒ  ǥ Ѵ.

     E0 -> E1 & E2
         E1 -> 0xc8
	 E2 -> 0xb2
   
     ν, Ÿ  [ ... ]  Ǿ ִ ̺  
   DFA µ   ִ.    ̴ 2 Ʈ ̻  شȴ.  */
void
hre_apply_multi_form (p, last_rhs)
     struct hre_tree *p;
     int last_rhs;
{
  struct exp *v = EQU_VALUE (TREE_EQU_TAB_N (p, last_rhs));

  if (v)
    {
      int args = EXP_ARGS (v);
      if (args == 0 && EXP_TAG (v) == SYM_X && EXP_TAG (v) != ZERO_X
	  && EXP_TAG (v) != ONE_X)
	{
	  int i, length, num = 0;
	  char *str;

	  length = SYM_LENGTH (EXP_BODY_LEAF (v));
	  str = SYM_NAME (EXP_BODY_LEAF (v));

	  for (i=0; i<length-1; i++)
	    {
	      num += ((int) str[i] & 0xff);
	      num <<= 8;
	    }
	  num += ((int) str[i] & 0xff);

	  /* IDENTIFIER ̰ 1  ũٴ  ѱ Ȥ Ƽ Ʈ ڶ ̴.  */
	  if (length == 2 || length == 3)
	    hre_make_exp (p, last_rhs, OR_X, 
			  hre_make_han_symx (p, num), 
			  hre_make_exp (p, -1, ZERO_X));
	  else if (length > 3)
	    hre_error (": IDENTIFIER  ̰ %d Դϴ.\n", length);
	}
      else if (args == 1 )
	  hre_apply_multi_form (p, EXP_BODY_ARG_N (v, 0));
      else if (args == 2 )
	{
	  hre_apply_multi_form (p, EXP_BODY_ARG_N (v, 0));
	  hre_apply_multi_form (p, EXP_BODY_ARG_N (v, 1));
	}
    } 
}

/* ϳ ¸ Ѵ.  ⼭ ``'' DFA  ϳ ̺ ϴ
    ϸ, S_LIST  S_LIST_SIZE  hre_parser ()   ¿ 
   õǴ expression  ġ (ȮϰԴ ȣ) ȣ 迭  
   ִ.  */
int
hre_add_state (p, s_list_size, s_list)
     struct hre_tree * p;
     int s_list_size, *s_list;
{
  int d, i, *m;
  struct state * dp;

  for (d = 0; d < TREE_STATE_S (p); d++)
    {
      dp = &TREE_STATE_TAB_N (p, d);
      if (s_list_size != STATE_S_LIST_SIZE_P (dp))
        continue;
      for (i = 0; i < s_list_size; i++)
        {
          if (s_list[i] != STATE_S_LIST_P_N (dp, i))
            break;
	}
      if (i >= s_list_size)
	return d;
    }
  if ((TREE_STATE_S (p) & 0xff) == 0)
    TREE_STATE_TAB (p) = 
      (struct state *) realloc (TREE_STATE_TAB (p),
				sizeof (*TREE_STATE_TAB (p)) * (TREE_STATE_S (p) + 0x100));

  /* struct item  realloc  free    Ƿ ⿡
     Ӱ ҴϿ ֵ Ѵ.  */
  m = (int *) malloc ((s_list_size+1) * sizeof (int));
  for (i = 0; i < s_list_size; i++) 
    m[i] = s_list[i];

  STATE_CLASS (TREE_STATE_TAB_N (p, TREE_STATE_S (p))) = TREE_STATE_S (p);
  STATE_S_LIST_SIZE (TREE_STATE_TAB_N (p, TREE_STATE_S (p))) = s_list_size;
  STATE_S_LIST (TREE_STATE_TAB_N (p, TREE_STATE_S (p))) = m;

  return TREE_STATE_S (p)++;
}

/*  ʿ */
void
hre_pushq (p, q)
     struct hre_tree *p;
     int q;
{
  if (EQU_STACK (TREE_EQU_TAB_N (p, q)))
    return;

  if (TREE_X_S (p) == TREE_X_MAX (p))
    {
      TREE_X_MAX (p) += X_EXTEND;
      TREE_X_STACK (p) = 
	(int *) realloc (TREE_X_STACK (p), sizeof (int) * TREE_X_MAX (p));
    }

  TREE_X_STACK_N (p, TREE_X_S (p)++) = q;
  EQU_STACK (TREE_EQU_TAB_N (p, q)) = 1;
}

/*  ʿ */
void
hre_popq (p)
     struct hre_tree *p;
{
  int q = TREE_X_STACK_N (p, --TREE_X_S (p));

  EQU_STACK (TREE_EQU_TAB_N (p, q)) = 0;
}

void
hre_add_buf (p, lhs, q)
     struct hre_tree *p;
     struct symbol * lhs;
     int q;
{
  int diff, i=0, j, s, t;
  struct item * ip;
  char * name;

  if (lhs == NULL)
    goto TO_DOT;

  name = SYM_NAME (lhs);
  for (i = 0; i < TREE_ITEM_S (p); i++)
    {
      diff = strcmp (SYM_NAME (ITEM_LHS (TREE_ITEM_BUF_N (p, i))), name);
      if (diff == 0)
        goto FOUND;
      if (diff > 0)
        break;
    }

TO_DOT:
  if (TREE_ITEM_S (p) >= TREE_ITEM_MAX (p))
    {
      TREE_ITEM_MAX (p) += 8;
      TREE_ITEM_BUF (p) = 
	(struct item *) realloc (TREE_ITEM_BUF (p), 
			  sizeof *TREE_ITEM_BUF (p) * TREE_ITEM_MAX (p));
    }

  for (j = TREE_ITEM_S (p)++; j > i; j--)
    TREE_ITEM_BUF_N (p, j) = TREE_ITEM_BUF_N (p, j - 1);
  
  ITEM_LHS (TREE_ITEM_BUF_N (p, i))  = lhs;
  ITEM_SIZE (TREE_ITEM_BUF_N (p, i)) = 0;
  ITEM_RHS (TREE_ITEM_BUF_N (p, i))  = 0;
  ITEM_INDEX (TREE_ITEM_BUF_N (p, i)) = 100;

FOUND:
  ip = &TREE_ITEM_BUF_N (p, i);
  for (s = 0; s < ITEM_SIZE_P (ip); s++)
    {
      if (ITEM_RHS_P_N (ip, s) == q)
        return;
      if (ITEM_RHS_P_N (ip, s) > q)
        break;
    }

  if ((ITEM_SIZE_P (ip) & 7) == 0)
    ITEM_RHS_P (ip) =
      (int *) realloc (ITEM_RHS_P (ip),
			sizeof *ITEM_RHS_P (ip) * (ITEM_SIZE_P (ip) + 8));
  for (t = ITEM_SIZE_P (ip)++; t > s; t--)
    ITEM_RHS_P_N (ip, t) = ITEM_RHS_P_N (ip, t - 1);
  ITEM_RHS_P_N (ip, s) = q;
}

/* hre_parser () Լ ؼ  ``ǥ''   DFA ̺ 
   ϱ   ǥĿ  ``µ''  Ѵ.  */
void
hre_form_state (p)
     struct hre_tree *p;
{
  int i, s, s1, x;
  struct state * sp;

  timevar_push (TV_FORM_STATE);

  /* µ   Ǵ   ʱȭ ǽѴ.  */
  TREE_ITEM_BUF (p) = 0;
  TREE_ITEM_MAX (p) = 0;
  TREE_STATE_TAB (p) = 0;
  TREE_STATE_S (p) = 0;

  /*   level  ִ ǥĿ  ¸ 켱 Ѵ.   ϵ
       Ʒ  ƾ   ؼϰ Ǵ ̴.  */
  hre_add_state (p, 1, &TREE_LAST_RHS (p));
  for (s = 0; s < TREE_STATE_S (p); s++)
    {
      /*  ¿  ͸ 켱 ´.  */
      sp = & TREE_STATE_TAB_N (p, s);

      for (TREE_X_S (p) = 0, s1 = 0; s1 < STATE_S_LIST_SIZE_P (sp); s1++)
        hre_pushq (p, STATE_S_LIST_P_N (sp, s1));

      for (STATE_ACCEPT (sp) = 0, TREE_ITEM_S (p) = 0, x = 0; x < TREE_X_S (p); x++)
        {
	  int qx = TREE_X_STACK_N (p, x);
	  int q1, q2;
          struct exp * e;
	  
	EVALUATE:
	  e = EQU_VALUE (TREE_EQU_TAB_N (p, qx));
	  switch (EXP_TAG (e))
	    {
	    case ZERO_X:
	      break;
	    case ONE_X: 
	      /* Accept ̺  ʿ伺   */
	      STATE_ACCEPT (sp) = 1;
	      break;
	    case SYM_X:
	      /* ڿ ѱ ٸ , ٸ  ִٸ,   1 Ʈ̱ ,
		 Ƽ Ʈ  ߻Ǵ DFA   Ű  ʿ䰡 , 
		 Ƽ Ʈ , ڿ ٸ  ־ Ѵ.  */
	      hre_add_buf (p, EXP_BODY_LEAF (e), hre_make_exp (p, -1, ONE_X));
	      break;
	    case OR_X:
	      hre_pushq (p, EXP_BODY_ARG_N (e, 0));
	      hre_pushq (p, EXP_BODY_ARG_N (e, 1));
	      break;
	    case STAR_X:
	      q1 = EXP_BODY_ARG_N (e, 0);
	      hre_make_exp (p, qx, OR_X, 
			    hre_make_exp (p, -1, ONE_X), 
			    hre_make_exp (p, -1, PLUS_X, q1));
	      goto EVALUATE;
	    case PLUS_X:
	      q1 = EXP_BODY_ARG_N (e, 0);
	      hre_make_exp (p, qx, AND_X, q1, hre_make_exp (p, -1, STAR_X, q1));
	      goto EVALUATE;
	    case AND_X:
	      {
		int a, b;
		struct exp * e1;

		q1 = EXP_BODY_ARG_N (e, 0);
		q2 = EXP_BODY_ARG_N (e, 1);
		e1 = EQU_VALUE (TREE_EQU_TAB_N (p, q1));
		switch (EXP_TAG (e1))
		  {
		  case SYM_X:
		    hre_add_buf (p, EXP_BODY_LEAF (e1), q2);
		    break;
		  case PLUS_X:
		    a = EXP_BODY_ARG_N (e1, 0);
		    hre_make_exp (p, qx, AND_X, a, hre_make_exp (p, -1, OR_X, q2, qx));
		    goto EVALUATE;
		  case AND_X:
		    a = EXP_BODY_ARG_N (e1, 0);
		    b = EXP_BODY_ARG_N (e1, 1);
		    hre_make_exp (p, qx, AND_X, a, hre_make_exp (p, -1, AND_X, b, q2));
		    goto EVALUATE;
		  case OR_X:
		    a = EXP_BODY_ARG_N (e1, 0);
		    b = EXP_BODY_ARG_N (e1, 1);
		    hre_make_exp (p, qx, OR_X, 
				  hre_make_exp (p, -1, AND_X, a, q2), 
				  hre_make_exp (p, -1, AND_X, b, q2));
		    goto EVALUATE;
		  case ZERO_X:
		    hre_make_exp (p, qx, ZERO_X);
		    break;
		  case ONE_X:
		    EQU_VALUE (TREE_EQU_TAB_N (p, qx)) = EQU_VALUE (TREE_EQU_TAB_N (p, q2));
		    goto EVALUATE;
		    break;
		  case STAR_X:
		    a = EXP_BODY_ARG_N (e1, 0);
		    hre_make_exp (p, qx, OR_X, q2, hre_make_exp (p, -1, AND_X, a, qx));
		    goto EVALUATE;
		    break;
		  default:
		    hre_error ("FORM :  %d  óؾ Ѵ.", EXP_TAG (e1));
		    abort ();
		  }

		break;
	      }
	    default:
	      hre_error ("FORM : %d  óؾ Ѵ.", EXP_TAG (e));
	      abort ();
	    }
	}

      while (TREE_X_S (p) > 0)
	hre_popq (p);

      STATE_SHIFTS (sp) = TREE_ITEM_S (p);
      STATE_SH_LIST (sp) = (void *) malloc (sizeof (*STATE_SH_LIST (sp)) * TREE_ITEM_S (p));

      /*  ؼ   ¿   ϰ Ǵµ, LHS   ¿
	 Է°   ִ ڵ鿡    ְ, RHS  ش ڰ
	   ̵ؾ ϴ DFA ̺ ȣ  ִ.  */
      for (i = 0; i < TREE_ITEM_S (p); i++)
	{
	  STATE_SH_LIST_N_LHS (sp, i) = ITEM_LHS (TREE_ITEM_BUF_N (p, i));
	  STATE_SH_LIST_N_RHS (sp, i) = 
	    hre_add_state (p,
			  ITEM_SIZE (TREE_ITEM_BUF_N (p, i)),
			  ITEM_RHS (TREE_ITEM_BUF_N (p, i)));

	  /* hre_add_buf  Ҵ rhs   ITEM  ⿡ free ϴµ,
	     ӿ  ִ  hre_add_state   ҴǾ  ȴ.  */
	  free (ITEM_RHS (TREE_ITEM_BUF_N (p, i)));
	}
    }

#if 0
  /* ڰ Է Խ  µ     ؼ ̸
     1  Ѵ.  */
  debug_state (p, sp);
#endif

  timevar_pop (TV_FORM_STATE);
}

/*  ʿ */
void 
hre_add_equiv (p, L, R)
     struct hre_tree *p;
     int L;
     int R;
{
  int e;
  struct state * sL, * sR;

  L = STATE_CLASS (TREE_STATE_TAB_N (p, L));
  R = STATE_CLASS (TREE_STATE_TAB_N (p, R));

  if (L == R)
    return;
  if (L > R)
    L ^= R, R ^= L, L ^= R;

  sL = &TREE_STATE_TAB_N (p, L);
  sR = &TREE_STATE_TAB_N (p, R);

  for (e = 0; e < TREE_EQUIV_S (p); e++)
    {
      if (sL == EQUIV_L (TREE_EQUIV_TAB_N (p, e)) 
	  && sR == EQUIV_R (TREE_EQUIV_TAB_N (p, e)))
        return;
    }

  if (TREE_EQUIV_S (p) >= TREE_EQUIV_MAX (p))
    {
      TREE_EQUIV_MAX (p) += 8;
      TREE_EQUIV_TAB (p) = 
	(struct equiv *) realloc (TREE_EQUIV_TAB (p), 
			  sizeof *TREE_EQUIV_TAB (p) * TREE_EQUIV_MAX (p));
    }

  EQUIV_L (TREE_EQUIV_TAB_N (p, TREE_EQUIV_S (p))) = sL;
  EQUIV_R (TREE_EQUIV_TAB_N (p, TREE_EQUIV_S (p))) = sR;
  
  TREE_EQUIV_S (p)++;
}

/*  ʿ */
void 
hre_merge_states (p)
     struct hre_tree *p;
{
  int classes, s, s1, e, sh;
  struct state * sp, * sp1, * qL, * qR;

  timevar_push (TV_MERGE_STATES);

  TREE_EQUIV_TAB (p) = 0;
  TREE_EQUIV_MAX (p) = 0;
  
  for (s = 0; s < TREE_STATE_S (p); s++)
    {
      sp = &TREE_STATE_TAB_N (p, s);
      if (STATE_CLASS_P (sp) != s)
	continue;
      for (s1 = 0; s1 < s; s1++)
        {
          sp1 = &TREE_STATE_TAB_N (p, s1);
          if (STATE_CLASS_P (sp1) != s1)
	    continue;
          TREE_EQUIV_S (p) = 0, hre_add_equiv(p, s, s1);
          for (e = 0; e < TREE_EQUIV_S (p); e++) {
            qL = EQUIV_L (TREE_EQUIV_TAB_N (p, e));
	    qR = EQUIV_R (TREE_EQUIV_TAB_N (p, e));
            if (STATE_ACCEPT (qL) != STATE_ACCEPT (qR) 
		|| STATE_SHIFTS (qL) != STATE_SHIFTS (qR))
              goto NOT_EQUAL;
            for (sh = 0; sh < STATE_SHIFTS (qL); sh++)
              if (STATE_SH_LIST_N_LHS (qL, sh) != STATE_SH_LIST_N_LHS (qR, sh))
                goto NOT_EQUAL;
            for (sh = 0; sh < STATE_SHIFTS (qL); sh++)
              hre_add_equiv (p, STATE_SH_LIST_N_RHS (qL, sh), STATE_SH_LIST_N_RHS (qR, sh));
          }
NOT_EQUAL: continue;
        }
      if (s1 < s)
	{
          for (e = 0; e < TREE_EQUIV_S (p); e++)
	    {
              struct state * qL = EQUIV_L (TREE_EQUIV_TAB_N (p, e));
	      struct state * qR = EQUIV_R (TREE_EQUIV_TAB_N (p, e));
              STATE_CLASS_P (qR) = STATE_CLASS_P (qL);
            }
	}
    }

  for (classes = 0, s = 0; s < TREE_STATE_S (p); s++) 
    {
      sp = &TREE_STATE_TAB_N (p, s);
      STATE_CLASS_P (sp) = 
	(STATE_CLASS_P (sp) == s) ? classes++ 
	: STATE_CLASS (TREE_STATE_TAB_N (p, STATE_CLASS_P (sp)));
    }
  
  timevar_pop (TV_MERGE_STATES);
}

/* տ ϼ DFA µ   DFA ̺ ϰ ȴ.  */
void
hre_write_states (p, ret)
     struct hre_tree *p;
     struct hdfa *ret;
{
  int i, s, sh, classes;
  struct state *sp;

  HDFA_INDEX (ret) = TREE_STATE_S (p);

  /* տ ȹ   DFA ̺   켱 ҴѴ.  */
  HDFA_TABLE (ret) = (int **) malloc (sizeof (int *) * TREE_STATE_S (p));
  for (s = classes = 0; s < TREE_STATE_S (p); s++)
    {
      int *ip;

      sp = &TREE_STATE_TAB_N (p, s);

      if (STATE_CLASS_P (sp) != classes)
	continue;

      classes++;

      /* µ   ҴѴ.  */
      HDFA_TABLE_N (ret, s) = (int *) malloc (sizeof (int) * 256);
      ip = HDFA_TABLE_N (ret, s);

      if (STATE_ACCEPT (sp))
	{
	  /*   ° accept  , 켱 ش ̺ -2  ä 
	     Ѵ.  ̺ -2  accept ǹ̸  -1  и ǹѴ.
	     0  ū  ش ¸ Ѵ.  */
	  for (i = 0; i<256; i++)
	    ip[i] = -2;
	}
      else
	  for (i = 0; i<256; i++)
	    ip[i] = -1;

      for (sh=0; sh < STATE_SHIFTS (sp); sh++)
	{
	  int lhs = ((int) SYM_NAME (STATE_SH_LIST_N_LHS (sp, sh))[0]) & 0xff;
	  int rhs = STATE_SH_LIST_N_RHS (sp, sh);
	  ip[lhs] = rhs;
	}
    }
}

/*  ܰ迡  DFA ̺  Ͽ,   ʿ  Խ
   ˻ϴµ, ʿ  Ѵ.  */
void
hre_finalize (p, ret)
     struct hre_tree *p;
     struct hdfa *ret;
{
  /* ڰ Է  ǥ ѱ type mask  Ѵ.  */
  HDFA_HTMASK (ret) = TREE_HTMASK (p);

  HDFA_IS_SSAC (ret) = TREE_IS_SSAC (p);

  HDFA_RE_FAILED (ret) = TREE_RE_FAILED (p);
}

/* DFA ̺  ؼ ݱ ȰϿ  ޸𸮸  Ѵ.  */
void
hre_front_free (p)
     struct hre_tree *p;
{
  int i;
  struct hre_token *n, *t = TREE_TOKENS (p);
  struct symbol *st, *s = TREE_FIRST_B (p);
  struct state *sp;

  /* ū  free */
  while (t)
    {
      n = t->next;
      free (t);
      t = n;
    }
  /* ɺ  free */
  while (s)
    {
      st = s->tail;
      free (s->name);
      free (s);
      s = st;
    }
  /* state  free */
  for (i=0; i<TREE_STATE_S (p); i++)
    {
      sp = & TREE_STATE_TAB_N (p, i);
      free (STATE_S_LIST_P (sp));
      free (STATE_SH_LIST (sp));
    }

  /* exp ü  free */
  for (i=0; i<TREE_T_EQUS (p); i++) 
    {
      struct exp *e = TREE_EXP_FREE_N (p, i);
      if (EXP_TAG (e) != SYM_X && EXP_ARGS (e) > 0)
	free (EXP_BODY_ARG (e));
      free (TREE_EXP_FREE_N (p, i));
    }

  /*  malloc  ؼ Ҵ ޸𸮸 free Ͽ, Ʒ
     realloc  ؼ Ҵ ޸𸮸 free Ѵ.  */
  free (TREE_EQU_TAB (p));
  free (TREE_STATE_TAB (p));
  free (TREE_X_STACK (p));
  free (TREE_EQUIV_TAB (p));
  free (TREE_ITEM_BUF (p));

  /* hre_tree ü free */
  free (p);
}

/*  ǥ óϱ  ʱȭ ʿ   ɿ  ʱȭ 
   Ѵ.  */
void
hre_init (void)
{
  /*  ƹϵ  ʴ´.  */
}

/* hre_t  ϳ Ҵϰ,  ʱȭѴ.  */
hre_t 
init_hre_t (void)
{
  hre_t ret = (hre_t) malloc (sizeof (struct hdfa) + 1);

  HDFA_RE (ret) = NULL;
  HDFA_TABLE (ret) = NULL;
  HDFA_INDEX (ret) = 0;
  HDFA_HTMASK (ret) = 0;
  HDFA_IS_SSAC (ret) = 0;
  HDFA_RE_FAILED (ret) = 0;
  HDFA_ERRNO (ret) = 0;

  return ret;
}

/* ڰ Է  ǥ ؼϿ, DFA ̺ Ͽ
   ȯѴ.  */
hre_t
hre_compile (exp, option)
     char * exp;
     struct hre_options *option;
{
  struct hre_tree *parsed;
  hre_t ret = init_hre_t ();

  HDFA_RE (ret) = exp;

  init_timevar ();
  timevar_push (TV_TOTAL);

  /*  ǥ óϱ  ʱȭ ʿ  óѴ.  */
  hre_init ();

  /* ``ǥ''  Ѵ.  */
  parsed = hre_parser (exp, option);
  if (TREE_LAST_RHS (parsed) == -1)
    {
      /* fprintf (stderr, "Խ м \n"); */
      HDFA_ERRNO (ret) = TREE_ERRNO (parsed);
      return ret;
    }

  timevar_push (TV_VALIDATE);
  /*  ``ǥ'' Ʒ ؼϱ  ش   ϴ ǴѴ.  */
  if (!hre_validate_syntax (parsed, TREE_LAST_RHS (parsed)))
    {
      /* fprintf (stderr, "߸  մϴ.\n"); */
      if (TREE_ERRNO (parsed))
	{
	  HDFA_ERRNO (ret) = TREE_ERRNO (parsed);
	  return ret;
	}
      return NULL;
    }
  timevar_pop (TV_VALIDATE);

#if 0
  debug_equation (parsed, TREE_LAST_RHS (parsed), 0);
#endif

  /* տ  ǥ ߿, ߰ ó  ϴ  ϴµ,  
     [a-z]   ǥ  ̴.  ̿  ǥ   κп & Ȥ | 
     ȯǰ ȴ.  */
  timevar_push (TV_PSYNTAX);
  hre_process_syntax (parsed, TREE_LAST_RHS (parsed), -1);
  if (TREE_ERRNO (parsed))
    {
      HDFA_ERRNO (ret) = TREE_ERRNO (parsed);
      return ret;
    }
  timevar_pop (TV_PSYNTAX);

  /*   ``ǥ''  , ѱ۰  ƼƮ ó ؼ
      ǥĿ   ؾ Ѵ.  */
  timevar_push (TV_APPLY_FORM);
  hre_apply_multi_form (parsed, TREE_LAST_RHS (parsed));
  timevar_pop (TV_APPLY_FORM);

  /*   ``ǥ''  , ``µ'' Ѵ.  */
  hre_form_state (parsed);  

  /* ``µ'' merging  ̷  ִ  ģ.  */
  hre_merge_states (parsed);

  /* ``µ''  DFA ̺ RET  Ѵ.  */
  hre_write_states (parsed, ret);

  /* Ÿ DFA ̺ ߰Ǿ    Ѵ.  */
  hre_finalize (parsed, ret);

  /* DFA ̺ ϸ鼭 Ͽ  ޸𸮸 Ѵ.  */
  hre_front_free (parsed);

  timevar_pop (TV_TOTAL);
  timevar_print (stderr);

  return ret;
}

/* hre_compile () Լ   DFA ̺  ڰ 
   ڿ ش  ã´.  ã , ش  ߰ߵ  
   ġ ȯѴ.  ã   -1  ȯѴ.  */
int
hre_search (dfa, str)
     hre_t dfa;
     const char *str;
{
  register int c, i = 0, s = 0;
  int **t = dfa->table;
  int z, sn = 0;
  int include_euc_kr = (HDFA_HTMASK (dfa) & HTMASK_EUC_KR);
  int include_utf_8 = (HDFA_HTMASK (dfa) & HTMASK_UTF_8);
  
  if (HDFA_RE_FAILED (dfa))
    {
      fprintf (stderr, "Search Failed ");
      return -1;
    }

  /* ^ Ÿ ó κ.  */
  if (HDFA_IS_SSAC (dfa))
    {
      c = ((int) str[i]) & 0xff;
      if (t[s][c] == -1)
	return -1;
    }

  while ((c = (((int) str[i]) & 0xff)))
    {
      /*   ߰ ´ٰ, Ĺݺο Ʋ , ٽ  ƿͼ ãƾ
	 ϹǷ ⼭ ƿ ġ Ѵ.  ڵ ѱ۰ ڴ 1  
	 ʿ , Ȯ ϼ  ̸  ־ Ѵ.  2  ϱ ʰ
	 1  ϴ  ؿ 1  ϱ ̴.  */
      if (s == 0)
	{
	  if (include_euc_kr && !include_utf_8 && c > 0x80)
	    z = i + 1;
	  else
	    z = i;
	}

      s = t[s][c];

      if (s == -2)
	break;
      else if (s == -1)
	{
	  /* Ȯ ϼ ѱ ʼ ã  ߻Ǵ  ذϱ  
	     ڵ尡 ԵǾ. ڼ   ؼ Ͽ.  츮 
	     ʼ `-'  ڵ ã´ٰ  . Ȯ ϼ  
	     Ϲ ϼ , ʼ ڵ 0xa4a1 ~ 0xa4be   
	     ϰ  ̴.

	        ǥ : [<-,,>]
	       Է ڿ : ѱ Խ    Ʋ. ƴҲ.

	       ԷѴٰ ߴٸ, 츮  Է ڿ 
	     '' ġ ã Ŷ   ̴.  ʹ ޸, 
	     ã ġ 8 °  ȴ. , "ѱ Խ"  ""  
	     "" ̿ ִ ڰ match ȴٴ  ´. ֱ׷? ""  
	     ڵ 0xc1a4 ̰, "" ڵ 0xb1d4 ̴. , ""  
	     Ʈ 0xa4  "" ù Ʈ 0xb1   0xa4b1 ̶ "" 
	     ڵ尪 ġϱ ̴. ٸ ɼ  ſ  Ѵ.  

	     ٸ 0x7f ̻ ڵ  1 Ʈ  ˻ ,
	        ִ.

	     ڵ ѱ , UTF-8  , ùƮ  1110xxxx
	      ۵Ǳ ,  Ʈ ø  .  */
	  if (include_euc_kr && !include_utf_8)
	    {
	      if (c > 0x80 && !sn)
		i++;
	      sn = 0;
	    }

	  if (!(((int) str[i+1]) & 0xff))
	    break;
	  
	  /* տ  return ġ ⼭ Ѵ.  */
	  i = z + 1;
	  s = 0;

	  continue;
	}
      else if (c > 0x80)
	sn = 1;

      i++;
    }

  /*   κп  ġǾ   accept ó κ
      ó  ⿡ ó ־ Ѵ.  */
  if (!c && s != -1)
    {
      /* $ token ó  ߰  routine ̴.  */
      if (HDFA_INDEX (dfa) > s+1 && t[s][0xa] >= 0)
	{
	  if (t[(t[s][0xa])][c] == -2)
	    return i;
	}
      else if(t[s][c] == -2)
	return i;
    }
  else if (s == -2)
    return i;
  
  return -1;
}


/* DFA ̺ Ҵ  ޸𸮸 Ѵ.  */
void
hre_free (dfa)
     hre_t dfa;
{
  int i;

  if (!dfa)
    return;

  for (i=0; i < HDFA_INDEX (dfa); i++)
    free (HDFA_TABLE_N (dfa, i));

  if (HDFA_TABLE (dfa))
    free (HDFA_TABLE (dfa));
  free (dfa);
}
