/*
 * Changes for use with CM11A copyright 1996, 1997 Daniel B. Suthers,
 * Pleasanton Ca, 94588 USA
 * E-mail dbs@tanj.com
 */
/*
 * Copyright 1986 by Larry Campbell, 73 Concord Street, Maynard MA 01754 USA
 * (maynard!campbell).  You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 * John Chmielewski (tesla!jlc until 9/1/86, then rogue!jlc) assisted
 * by doing the System V port and adding some nice features.  Thanks!
 * 
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <limits.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include <time.h>
#include "x10.h"
#include "version.h"
#include <syslog.h>
#ifdef USESIGINT
# include <signal.h>
#endif

#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern int tty;
extern int sptty;
extern char x10_tty[];
extern int usage();
extern int start_relay(),setup_sp_tty(), xread(), unit2int();
extern char *make_lock_name();
extern void error(), quit();
extern int lock_for_write();
extern int munlock();
extern char spoolfile[PATH_MAX];
extern char monfile[PATH_MAX];
extern char writelock[PATH_MAX];

int x10_housecode;
int verbose;
int i_am_relay = 0;	/* flag to differentiate the relay process */
int port_locked = 0;	/* flag to show that the tty port is locked */
int use_helper = 0;	/* flag that nidicates we executea helper prog */

void sigtimer(), err();
char hc2char();
void init();
int check4poll();
void exec_helper();

char
 syncmsg[SYNCN], flag;

char latitude[20];
char longitude[20];
char macroxref[49];		/* file name to store macro cross reference */

struct hstruct			/* table to map housecodes into letters */
 housetab[] =
{
    {HC_A, 'a'},
    {HC_B, 'b'},
    {HC_C, 'c'},
    {HC_D, 'd'},
    {HC_E, 'e'},
    {HC_F, 'f'},
    {HC_G, 'g'},
    {HC_H, 'h'},
    {HC_I, 'i'},
    {HC_J, 'j'},
    {HC_K, 'k'},
    {HC_L, 'l'},
    {HC_M, 'm'},
    {HC_N, 'n'},
    {HC_O, 'o'},
    {HC_P, 'p'}
};

char *wdays[] =
{"Sunday", "Monday", "Tuesday", "Wednesday",
 "Thursday", "Friday", "Saturday", "<day not set>"};

/* Table for mapping units (1-16) or house codes (a-p) to 4 bit nibbles.
 * element 0 equates to unit 1 or code a
 */
unsigned char cm11map[]=
{  06, 016, 02, 012, 01, 011, 05, 015,
   07, 017, 03, 013, 0, 010, 04, 014
};

/* Table for mapping an x10 format bitmap to a unit number.  It's
 * the reverse of the one above.
 * Note that the unit numbers are 1-16, but the array is 0-15.
 */
unsigned char map2cm11[]=
{
    13, 5, 3, 11, 15, 7, 1, 9, 14, 6, 4, 12, 16, 8, 2, 10
};

int timeout = TIMEOUT, Irev, Iminutes, Iseconds, Ihours, Idays, Ijday;
int Istatdim, Istatmon, Iaddmon;
int newformat;  /* for the output format */
unsigned char Ihcode;

extern int
 c_data(), c_date(), c_delete(), c_diagnostic(), c_dump(), c_fdump(),
 c_finfo(), c_fload(), c_info(), c_monitor(), c_reset(), c_schedule(),
 c_setclock(), c_turn(), c_dbs(), c_stop(), c_erase(), c_preset();

extern int c_load_macro(), c_qerase(), c_list();

int c_help(), c_version();

struct cmdentry {
    char *cmd_name;
    int (*cmd_routine) ();
    int lock_needed;
} cmdtab[] = {
    {"address", c_turn,1},
    {"bright", c_turn,1} ,
    {"date", c_date,1} ,
    {"dim", c_turn,1} ,
    {"erase", c_erase,1},
    {"function", c_turn,1},
    {"help", c_help,0},
    {"info", c_info,1},
    {"list", c_list,0},	/* hidden feature , special treatment*/
    {"macro", c_load_macro,1},
    {"monitor", c_monitor,0},
    {"preset", c_preset,1},
    {"reset", c_reset,1},
    {"relay", c_version,0},
    {"setclock", c_setclock,1},
    {"status", c_turn,1},
    {"stop", c_stop,0},
    {"turn", c_turn,1},
    {"upload", c_load_macro,1},
    {"version", c_version,0},
    {"hail", c_turn,1},  /* hidden feature */
    {"qerase", c_qerase,1},  /* hidden feature */
    {"", NULL , 0}
};

char *argptr;

int main(argc, argv)
int argc;
char *argv[];
{
    register int i, a;
    int (*rtn) ();
    struct cmdentry *c;
    struct stat statb;
    char RCSID[]= "@(#) $Id: x10.c,v 1.27 2003/03/17 01:40:32 dbs Exp dbs $\n";
    void read_config();


    display(RCSID);

    rtn = NULL;
    /* verbose = 1; */		/* for the error message */

    verbose = 0;		/* default */
    for( a = argc-1; a > 0; a--)
    {
	if( argc > 1)
	{
	    if (strcmp(argv[1], "-v") == 0 )
	    {
		verbose = 1;
		for (i = 1; i < argc; i++ )
		{
		    argv[i] = argv[i+1];
		}
		argc --;
	    }

	    else if (strcmp(argv[1], "helper") == 0 )
	    {
		use_helper = 1;
		for (i = 1; i < argc; i++ )
		{
		    argv[i] = argv[i+1];
		}
		argc --;
	    }

	    else if ( strcmp(argv[1], "list") == 0 )
	    {
		c_list();
		return(0);
	    } 

	}
    }



    if( verbose )
	printf( "Version:%4s\n", VERSION );


    if (argc < 2)
	usage(E_NOCMD);
    for (c = cmdtab; c->cmd_routine != NULL; c++) {
	if (strcmp(argv[1], c->cmd_name) == 0) {
	    rtn = c->cmd_routine;
	    break;
	}
    }
    if (rtn == NULL)
	usage(E_INVCN);

    if( stat(SPOOLDIR, &statb) != 0 )
    {
    	fprintf( stderr, "Please build the %s directory with permissions 1777\n", SPOOLDIR);
	exit(3);
    }
    if(  (statb.st_mode & S_IRWXO) != S_IRWXO )
    {
    	fprintf( stderr, "Please change the %s directory's permissions to 1777\n", SPOOLDIR);
	exit(3);
    }

    read_config();	/* scan in the configuration file. */

    if( x10_tty[0] == (char)NULL )
        error ("Fatal error. TTY must be assigned.");


    /* I use alarm(2) to interrupt the read(2) */
#ifdef USESIGINT
    siginterrupt(SIGALRM,1);    /* make reads interruptable */
#endif

    /* The spoolfile name and monitor file name are always needed. */

    /* set up the spool file name */
    spoolfile[0] = '\0';
    strcat(spoolfile, SPOOLDIR);
    if( spoolfile[strlen(spoolfile) - 1] != '/' )
        strcat(spoolfile, "/");
    if( stat(spoolfile, &statb) < 0 )
    {
        char tmpbuf[sizeof(spoolfile) + 100];
        sprintf(tmpbuf, "The directory %s does not exist or is not writable.",
               spoolfile);
        error(tmpbuf);
    }
    strcat(spoolfile, "heyu.out");
    /* append the tty device name to the spoolfile */
    if ( strrchr(x10_tty, '/') != NULL )
         strcat (spoolfile, (strrchr(x10_tty, '/') +1));

    /* append the device name to the monitor lock file */
    strcpy( monfile, "heyu.mon");
    if ( strrchr(x10_tty, '/') != NULL )
         strcat (monfile, (strrchr(x10_tty, '/') +1));

    /* append the device name to the monitor lock file */
    strcpy( writelock, "heyu.write");
    if ( strrchr(x10_tty, '/') != NULL )
         strcat (writelock, (strrchr(x10_tty, '/') +1));


    /* certain commands are one shot... They do not start relays , write or
     * read.
     */

    if( ( strcmp("stop", c->cmd_name) == 0 ) || 
        (strcmp("version", c->cmd_name) == 0) ||
        (strcmp("help", c->cmd_name) == 0) )
    {
        (*rtn)();		/* exits */
	return(0);
    }

    if (c->lock_needed == 1 )
    {
        if( lock_for_write() < 0 )
            error("Program exiting.\n");
	port_locked = 1;
    }

    argptr = argv[0];

    /* Future: A command line of 'relay' directs this copy to start the relay 
     * process.  If that's the case, don't check for relay.
     */
    if( strcmp("relay", c->cmd_name) != 0 )
    {
	start_relay(x10_tty, 1);


	if( ! i_am_relay )
	{
	    setup_sp_tty();
	}
    }
    else
    {
        start_relay(x10_tty, 0);
        return(0);
    }


#ifdef MINIEXCH
    mxconnect(MINIXPORT);
#endif

    init(c->cmd_name);

    (*rtn) (argc, argv);
    if( port_locked == 1 )
        munlock(make_lock_name(writelock));

    return 0;
}

/*
 * Convert X10-style day of week (bit map, bit 0=monday, 6=sunday)
 * to UNIX localtime(3) style day of week (integer, 0=sunday)
 */
/* DBS  NOTE:  This is valid for CP290, not for CM11A.
 * The CM11A uses unix style.
 */


int dowX2U(b)
register char b;
{
    register int n;

    for (n = 1; (!(b & 1)) && n < 8; n++, b = b >> 1)
    	;
    if (n == 7)
	n = 0;
    if (n == 8)
	n = 7;
    return (n);
}

int dowU2X(d)
int d;
{
    if (d == 0)
	d = 7;
    return (1 << (d - 1));
}

void init(cmd_name)
char * cmd_name;
{

    timeout = TIMEOUT;
    if( strcmp(cmd_name, "monitor") == 0 )
    {
	check4poll(1,2);
    }
    else
	check4poll(0,0);

    /* Now check the status of the interface. */
    /* if( get_status() < 1)
        error("could not get the interface status");
    */
}


/* 
 * chksum is used to check the CM11A's acknowledgment to the
 * data we send it.  It's a simple addition of all bytes.
 */
int chksum(buf, size)
unsigned char *buf;
int size;
{
    register int i, sum;

    for (i = 0, sum = 0; i < size ; i++)
	sum += buf[i];
    return (sum & 0xFF);
}

char hc2char(code)
unsigned code;
{
    register int i;

    for (i = 0; i < 16; i++)
	if (housetab[i].h_code == code)
	    return i + 'a';
    return ('?');
}

int char2hc(hletter)
int hletter;
{
    if (isupper(hletter))
	hletter = tolower(hletter);
    if (! ('a' <= hletter && hletter <= 'p') )
	error("invalid house code");

    return (housetab[hletter - 'a'].h_code);

}

/*
 * Parse string of comma-separated unit numbers and return bitmap
 * (big-endian) of units specified.  '*' means "all units".
 */

unsigned int  getunits(p)
register char *p;
{

#define DIGBUFN 80		/* maximum line length */

    unsigned int bitmsk, n, unit, lastunit, range;
    char digbuf[DIGBUFN];

    bitmsk = 0;
    lastunit = 0;
    range = 0;
    while (*p) {
	if (*p == '*') {
	    bitmsk = 0xFFFF;
	    break;
	}
	for (n = 0; n < DIGBUFN && isdigit((int)*p); n++, p++)
	    digbuf[n] = *p;
	digbuf[n] = '\0';
	if ((unit = atoi(digbuf)) < 1 || unit > 16)
	    error("bad unit code, must be between 1 and 16");

	bitmsk |= (0x01 << (unit-1)) ;
	if( range == 1)
	{
	    for( n = lastunit; n <= unit; n++)
		bitmsk |= (0x01 << (n-1)) ;
	}

	if (*p)
	{
	    if (*p == '-')
	    {
		lastunit = unit;
		range = 1;
		p++;
	    }
	    else
	    {
		if (*p == ',')
		{
		    lastunit = 0;
		    range=0;
		    p++;
		}
		else
		{
		    error("bad unit separator, use comma or dash please");
		}
	    }
	}
    }
    return (bitmsk);
}

int dimstate(p, level)
register char *p, *level;
{
    unsigned levelnum;
    unsigned dim;

    if(verbose)
        printf("In dimstate(), state  %s, level %s\n", p, level);

    dim = -1;
    if (strcmp(p, "alloff") == 0)
	return (0);
    if (strcmp(p, "lightson") == 0)
	return (1);
    if (strcmp(p, "on") == 0)
	return (2);
    if (strcmp(p, "off") == 0)
	return (3);
    if ( (strcmp(p, "dim") == 0) || (strcmp(p, "down") == 0) )
	dim = 4;
    if ( (strcmp(p, "bright") == 0) ||  (strcmp(p, "up") == 0) )
	dim = 5;
    if (strcmp(p, "lightsoff") == 0)
	return(6);
    if (dim == -1)
	error("bad state keyword");
    if (sscanf(level, "%d", &levelnum) == 0)
	error("dim value must be numeric");
    if (levelnum > 23)
	error("dim value out of range, must be between 0 and 23");
    timeout = DTIMEOUT;
    return ((levelnum << 3) | dim);
}

struct nstruct dtab[] =
{
    {"monday", 0x01},
    {"tuesday", 0x02},
    {"wednesday", 0x04},
    {"thursday", 0x08},
    {"friday", 0x10},
    {"saturday", 0x20},
    {"sunday", 0x40},
    {"everyday", 0x7f},
    {"weekdays", 0x1f},
    {"weekends", 0x60},
    {"", 0x00 }
};

int day2bits(p)
char *p;
{
    int n, mask, length;

    if (strcasecmp(p,"Today") == 0)
    	return (Idays);
    length = strlen(p);
    mask = 0;
    for (n = 0; dtab[n].n_name[0] != 0; n++) {
	if (strncasecmp(dtab[n].n_name, p, length) == 0) {
	    if (mask != 0)
		error("ambiguous day abbreviation");
	    mask = dtab[n].n_code;
	}
    }
    if (mask == 0)
	error("bad day keyword");
    return (mask);
}


void read_config()
{

	char line[256];
	char alias[50];
	char housecode[50];
	char opt[50];
	char unit[UNIT_LEN];
	char *configfile;
	char * home;
	struct stat file_buf;
	static FILE *f = NULL;
	int i = 0;
	int syntax = 0;
	int n;
	int tmpi;	/* This variable is reused. Use it only in
	                 * small sections.
	                 */
	extern char *getenv();
			/* Put options that are valid but not parsed 
			 * in the "options" array.  
			 * The idea is to allow auxilliary programs to
			 * share the configuration and still report
			 * mis-spellings and such.
			 */
	char options[][20] = {
	"SCHEDULE_FILE" } ;



#define OLD 0		/* old syntax or new? */
#define NEW 1

	if (f) return;	/* been here before. Keep going */
	x10_tty[0] = (char)NULL;

	configfile = getenv("X10CONFIG");
	if (configfile == NULL)
	{
	    home=getenv("HOME");
	    if( home == NULL )
	    {
	        home = ".";
	    }
		(void) strcat(strcpy(line, home), ALIASFILE);
		configfile = line;
	}

	if( stat(configfile,&file_buf) != 0 )
	        configfile = "/etc/x10.conf";

	if( verbose )
		printf( "Using the config file %s\n", configfile);
	f = fopen(configfile,"r");
	if (!f) {
		err("couldn't open configfile %s: is $X10CONFIG set?\n See the  x10config man page.",
			configfile);
		exit(1);
	}

	/* check to see if we are using the syntax
	 *    alias porch A 1
	 *    and
	 *    option newformat
	 */
	while(fgets(line, 255, f))
	{
	    line[254] = (char)NULL;
	    for( tmpi = 0; tmpi < strlen(line); tmpi++)
	    {
	        line[tmpi] = toupper(line[tmpi]);
	    }
	    if( strncmp(line, "ALIAS", 5) == 0 )
	    {
	        syntax = NEW;
	        break;
	    }
	}
	rewind(f);
	clearerr(f);

	for (;;)
	{
		line [0] = '\0';

		fgets(line, 255, f);

		if ((line[0] == '\0') || (line[0] == 0x0a) )
		{
		    if( feof(f)  != 0 )		/* end of file */
		    {
			break;
		    }
		    else
		    {
			continue;		/* blank line */
		    }

		}
		if (i >= MODULES)
		{
		    err("out of table space for config", NULL);
		    break;
		}

		if( syntax == OLD )
		{
		    n = sscanf(line, "%49s %49s %49s", alias, housecode, unit);
		    if (!n || alias[0] == '#')
			    continue;
		}
		else
		{
		    n = sscanf(line, "%49s %49s %49s %49s", opt, alias
		                   , housecode, unit);
		    if (!n || opt[0] == '#')
			    continue;
		    opt[sizeof(opt) -1] = (char)NULL;
		    for( tmpi = 0; tmpi < strlen(opt); tmpi++)
		    {
			opt[tmpi] = toupper(opt[tmpi]);
		    }
		    n--; /* make the numbering match the switch statement.*/

		}


		switch(n)
		{
		    case 3:
		    case 2:
			if (strcmp(alias, "TTY") == 0)
			{
				/* special case */
				strcpy(x10_tty, housecode);
				break;
			}
			if (strcmp(alias, "LATITUDE") == 0)
			{
				/* another special case */
				strncpy(latitude, housecode, 
						sizeof(latitude));
				latitude[sizeof(latitude) - 1] = (char) NULL;
				continue;
			}
			if (strcmp(alias, "LONGITUDE") == 0)
			{
				/* another special case */
				strncpy(longitude, housecode, 
						sizeof(longitude));
				longitude[sizeof(longitude) - 1] = (char) NULL;
				continue;
			}
			if (strcmp(alias, "MACROXREF") == 0)
			{
				/* another special case */
				strncpy(macroxref, housecode, 
						sizeof(macroxref));
				macroxref[sizeof(macroxref) - 1] = (char) NULL;
				continue;
			}
			if (strcmp(alias, "HOUSECODE") == 0)
			{
				/* another special case */
				x10_housecode = char2hc(housecode[0]);
				continue;
			}


			/* check for options that may not be parsed in the
			 * case statement
			 */
			if ( syntax == NEW )
			{
			    int optcnt;
			    int maxcnt;
			    maxcnt = sizeof(options) / sizeof(options[0]);
			    for( optcnt = 0; optcnt < maxcnt; optcnt++)
			    {
				if( strcmp( options[optcnt], alias) == 0 )
				    break;
			    }
			    if ( optcnt != maxcnt )	/* must have matched*/
			        continue;
			}

			/* aliases start here */
			if( syntax == NEW && strcmp(opt, "ALIAS") != 0 )
			{
			    err ("unknown config item, alias %s", alias);

			}
			housecode[1] = '\0';
			if (isupper((int) housecode[0]))
				housecode[0] = tolower(housecode[0]);
			if (housecode[0] < 'a' || housecode[0] > 'p')
			{
				err("bad housecode in config, alias %s",
					alias);
				continue;
			}

			x10_modules[i].hc = housecode[0];
			strncpy(x10_modules[i].un,unit,UNIT_LEN);
			strncpy(x10_modules[i].name, alias, NAME_LEN);

			++i;
			break;

		    case 1:
			if (strcmp(alias, "NEWFORMAT") == 0)
			{
				/* another special case */
				newformat = 1;
				continue;
			}
			else
			    err("warning: short field in line in config:\n	%s",line);
			break;
		    default:
			err("warning: too many fields in line in config:\n	%s",line);
			break;
		}

	}

	/* add the alias for 'all'  */
	x10_modules[i].hc = hc2char(x10_housecode);
	strcpy(x10_modules[i].un,"*");
	strcpy(x10_modules[i].name, "all");

	fclose (f);
	if( x10_tty[0] == (char)NULL )
	{
	    err( "No TTY assigned in the config file.\n");
	}

}



struct x10_mod *
xmod_lookup(name)
char *name;
{
	int i = 0;
	struct x10_mod *xm;

	xm = x10_modules;
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		if (strcmp(name, xm->name) == 0)
			return xm;
		i++;
		xm++;
	}
	if (!i) {
		err("no config at all", NULL);
	}
	return NULL;
}

char *
xmod_name(hl,unit)
char hl;
char *unit;
{
	int i = 0;
	int hli;
	struct x10_mod *xm;

	hli = hl;
	xm = x10_modules;
	if (isupper(hli))
		hl = (char) tolower(hli);
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		if ((hl == xm->hc) && (strcmp(unit,xm->un) == 0) )
			return (xm->name);
		i++;
		xm++;
	}
	return ("no alias");
}


void parse_unit(name,hcp,unitp)
char *name;
int *hcp;
char **unitp;
{
    struct x10_mod *x;
    int hletter;

    if (isalpha((int)name[0]) && (isdigit((int)name[1]) || name[1] == '*')) {
	hletter = name[0];
	if (isupper(hletter))
	    hletter = tolower(hletter);
	*unitp = &name[1];
    } else {
	x = xmod_lookup(name);
	if (!x) {
		err("bad alias %s",name);
		quit();
	}
	hletter = x->hc;
	*unitp = x->un;
    }
    *hcp = char2hc(hletter);

}


void err(m,s)
char *m, *s;
{
	fprintf(stderr, "HEYU: ");
	fprintf(stderr, m, s);
	fprintf(stderr, "\n");
}

#ifdef DEBUG
/* dump config is a debugging tool used to see if the 10_mod link list is ok */
dump_config()
{
	int i = 0;
	struct x10_mod *xm = x10_modules;
	extern char x10_tty[];
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		printf("%d: name: %s, housecode is %c, unit %s\n",
			i, xm->name, xm->hc, xm->un);
		i++;
		xm++;
	}
	if (!i)
		err("no config at all", NULL);

	if (x10_tty[0])
		printf("tty is %s\n", x10_tty);
}
#endif


/* 
 *  The CM11A sends data back to the computer whenever it sees a command
 *  come in over the AC buss.  This should (theoretically) allow the compuer
 *  to track the status of all modules.  Upon startup, this program should
 *  check for a poll before anything else.
 *
 *  Check for a poll (0x5a) from the CM11A, If we get one within a
 *  second, we should send 0xc3 to tell it that we are ready to read
 *  it's output.
 *
 *  If the showdata flag is set, we print.  Otherwise we just eat the output.
 */
int check4poll(showdata, timeout)
int showdata;
int timeout;
{
    int n, i;
    int to_read;
    char hc;
    char *nl;
    int unit ;
    static int lastunit = 0;
    int macro_report;
    char *func;
    int funcbits;
    static int wasflag = 0;
    unsigned char buf[128];
    char statstr[80];
    extern char *funcmap[];
    extern char *b2s();
    time_t timestore;
    struct tm *tp;
    off_t f_offset;
    char comm[PATH_MAX+81];	/* command to execute. Path + 80 (the macro) */
    extern char *storedmacro();

    unit = -1;
    hc = '\0';
    func =  "" ;

    /* In case we need to spawn a child, as in heyuhelper. */
    signal(SIGCHLD, SIG_IGN);

    if( showdata )
    {
	timestore = 0;
	time(&timestore);
	tp = localtime(&timestore);
	if( newformat == 1 )
	{
	    sprintf(statstr, "%d/%d at %02d:%02d:%02d ",
	    tp->tm_mon + 1, tp->tm_mday, tp->tm_hour, tp->tm_min, tp->tm_sec);
	}
	else
	{
	    sprintf(statstr, "%s at %02d:%02d:%02d ",
	    wdays[tp->tm_wday], tp->tm_hour, tp->tm_min, tp->tm_sec);
	}

    }
    if( timeout == 0 )		/* only do a read if there is data */
    {
	if( sptty < 0 )
	    return(0);
        f_offset = lseek(sptty, 0, SEEK_CUR);
	if( f_offset == lseek(sptty, 0, SEEK_END) )
	    return(0);
	lseek(sptty, f_offset, SEEK_SET);
	timeout = 1;
    }
    n = xread(sptty, buf, 1, timeout);
    if( n != 0 )
    {
	/* Three 0xff bytes in a row indicate that I sent a transmission to
	 * the CM11, I.E a command.  The byte following the 3 0xFF bytes
	 * indicates how long the sent command was.  We need to suck these
	 * off the stack if we are monitoring.
	 */
	while( buf[0] == 0xff ) /* CM11A may be responding to a transmission  */
	{
	    if( ++wasflag >= 3)
	    {
		wasflag = 0;
		n = xread(sptty, buf, 1, timeout);	/* length of xmit */
		if( n != 1 )
		     return(0);
		n = buf[0];
		if( showdata )
		    printf("%s %s ...", statstr,
		    (n < 127)? "Transmitted data" : "Response to transmision");
		if( n > 127)
		    n -= 127;
		n = xread(sptty, buf, n, timeout); /* read entire transmision */
		for( i = 0; i < n; i++)
		    printf( "%02x%s", buf[i], i == (n-1) ? "" : " ");
		
	        printf("\n");
	        fflush(stdout);
	        return(0);
	    }
	    else
		n = xread(sptty, buf, 1, timeout);
	    if( n != 1 )
	        return(0);
	}   /* end of while */

	/* print out the saved 0xff from the buffer */
	if( (buf[0] != 0xff) && (wasflag > 0))
	{
	    n = buf[0];
	    for(i = 0; i < wasflag;i++)
		buf[i] = 0xff;
	    buf[i] = n;
	    wasflag = 0;
	}
	    
	macro_report = 0;
        if( buf[0] == 0x5a ) /* CM11A has polling info for me */
	{
	    /* The xread is executed a second time on failure because the
	       dim commands may be tieing up the CM11.
	    */
	    n = xread(sptty, buf, 1, 2);  /* get the buffer size */
/*	    if( verbose && !i_am_relay ) 
		printf( "Incoming buffer is  %d bytes long\n", n);
*/
	    if ( n == 0)
		n = xread(sptty, buf, 1, 2);  /* get the buffer size */
	    /* Greater than 0 means we have a byte count */
	    if ( n > 0 ) 
	    {
	        to_read = buf[0];	/* number of bytes to read */
		if( to_read == 0x5a)	/* Darn.  Another polling indicator */
		{
		    timeout = 2;
		    return(check4poll(showdata, timeout));
		}
		else if (to_read == 0x5b) /* Macro report coming in */
		{
		    to_read = 2;
		    macro_report = 1;
		}
		if( to_read > sizeof(buf) )
		{
		    if( verbose )
			fprintf(stderr, "Polling read size exceeds buffer");
		    return(-1);
		}
		n = xread(sptty, buf, to_read , timeout);
		if ( n != to_read )
		{
		    printf( "Poll only got %d of %d bytes\n",
		            n, to_read);
		    fflush(stdout);
		    return(0);
		}
                if( showdata > 0 && (verbose != 0) )
		    printf( "I received a poll %d bytes long.\n", n);


		if( macro_report == 1 ) /* CM11A is reporting a macro execution.*/
		{
		    if( showdata ) 
		    {
			if( newformat == 1 )
			{
			    if( macroxref[0] == (char) NULL)
			    {
			        printf( "%s Triggered macro  : at eeprom address %d\n",
				    statstr, ((buf[0] & 0x07) << 8) + buf[1] );
			    }
			    else
			    {
			        printf("%s Triggered macro  : %s, address %d\n",
				    statstr, 
				    storedmacro(((buf[0] & 0x07) << 8) + buf[1] ),
				    ((buf[0] & 0x07) << 8) + buf[1] );

				/* execute any external commands.  We don't know
				   which X10 signal, but we do know the name of 
				   the macro
				*/

				exec_helper(storedmacro(((buf[0] & 0x07) << 8) + buf[1] ));
			    }
			}
			else
			    printf( "%s executed macro   : macro executed at eeprom address %d\n",
				statstr, ((buf[0] & 0x07) << 8) + buf[1] );
		    }
		}
		else
		{
		    for ( i = 1; i < to_read; i++)
		    {

			if( strcmp( func, "Dim") == 0)
			{
			    if( showdata )
				printf( "dimmed by %%%02.0f\n",
					(float)buf[i]/(float)210 * 100);
			    func = "";
			}
			else if( strcmp( func, "Bright") == 0 )
			{
			    if( showdata )
				printf( "brightened by  %%%02.0f\n",
					(float)buf[i]/(float)210 * 100 );
			    func = "";
			}
			else if( (buf[0] & (0x01 << (i-1))) != 0)   /* a function */
			{
			    hc = hc2char( ((buf[i] & 0xF0) >> 4) );
			    funcbits = buf[i] & 0x0F;
			    func = funcmap[ buf[i] & 0x0F];
			    /* continue the line if function is dim or bright */
			    if( funcbits == DIM || funcbits == BRIGHT )
				    nl = ", ";
			    else
				nl = "\n";
			    if( funcbits == PRESET1 || funcbits == PRESET2)
			    {
			        func="preset";
			        hc -= 97;
			        if( funcbits == PRESET2 )
			           hc += 16;
			    }
				
			    if( showdata )
			    {
				if( funcbits == PRESET1 || funcbits == PRESET2 )
				{
				    printf("%s function  %6s : preset %d%s",
					    statstr, func, hc, nl);
				}
				else
				{
				    char tmp[10];
				    sprintf(tmp, "%d", lastunit);
				    printf("%s function  %6s : housecode %c unit %d (%s)%s",
					statstr, func, hc, lastunit, xmod_name(hc,tmp), nl);
				    /* execute the external command,
				       providing the housecode, the
				       device and On, Off, Dim or Bright
				     */
				    sprintf(comm, "%c%d%s", hc,lastunit, func);
				    exec_helper(comm);
				}
			    }
			}
			else		/* an address */
			{
			    hc = hc2char( ((buf[i] & 0xF0) >> 4) );
			    unit = unit2int( buf[i] & 0x0F) ;
			    lastunit=unit;
			    if( showdata )
			    {
			        char tmp[10];
			        sprintf(tmp, "%d", unit);
				printf( "%s address unit %3d : housecode %c (%s)\n",
					 statstr, unit, hc, xmod_name(hc,tmp));
			    }
			}
		    }
		    fflush(stdout);
		}
	    }
	    else
	    {
		if (verbose)
		    sprintf( statstr, "Bytes received = %d,", n);
		printf( "%s The interface didn't answer a getinfo response.\n",
			statstr);
	    }
	}
        else if( (buf[0] == 0xa5) )
	{				/* CM11A is asking for time update */
	    printf( "Module experienced a power failure. %s",
	            "It requested a time update.\n");
	}
	else if( buf[0] == 0x5b) 	/* Timer report */
	{
		to_read = 2;
		n = xread(sptty, buf, to_read, timeout);
		if(showdata)
		{
		    /* format changed with version 1.28c */
		    if( newformat == 1)
		    {
			if( macroxref[0] == (char) NULL)
			{
			    printf("%s Timer executed   : macro at eeprom address %d\n",
				statstr, (((buf[0] & 0x07)<<8) + buf[1])); 
			}
			else
			{
			    printf( "%s Timer executed   : %s, address %d\n",
				statstr, 
			        storedmacro(((buf[0] & 0x07) << 8) + buf[1] ),
			        ((buf[0] & 0x07) << 8) + buf[1] );
			    /* execute any external commands.  We don't know
			       which X10 signal, but we do know the name of 
			       the macro
			    */
			     exec_helper(storedmacro(((buf[0] & 0x07) << 8) + buf[1] ));
			}
		    }
		    else
		    printf("%s executed macro at EEPROM address %d\n",
				statstr, (((buf[0] & 0x07)<<8) + buf[1])); 
		    /*   TEST CODE
		    fprintf(stderr, "( EEPROM byte 0 = %d, Byte 1 = %d)\n",
				 (buf[0] & 0x07), (buf[1])); 
		    */
		}
	}
	else
	    printf( 
	        "%s Poll received unknown value (%d bytes), leading byte = %0x\n",
		statstr, n, buf[0]);
        fflush(stdout);
    }
    return(0);
}

/* Takes the bits in CM11A format (as used in the reply to a status) 
 * and returns a day string.
 * The b parameter is for bitmap */
char *bits2day(b)
int b;
{
   
   switch(b)
   {
       case 1:
	   return("Sun");
       case 2:
	   return("Mon");
       case 4:
	   return("Tue");
       case 8:
	   return("Wed");
       case 16:
	   return("Thu");
       case 32:
	   return("Fri");
       case 64:
	   return("Sat");
    }
    return("Error");
}

int c_version()
{
    printf( "Version:%4s\n", VERSION );
    return(0);
}

int c_help()
{
    usage(NULL);
    return(0);
}

void display(RCCS)
char *RCCS;
{

    /* This is not used much so far */
    if( verbose > 1)
        printf( "%s\n", RCCS);
}

/* take the simple bitmap produced by getunits() and turn it into the
 * cm11 style, where bit 0 represents unit 13, bit 1 represents unit 5, etc
 */
unsigned int cm11bitmap(bits)
unsigned int bits;
{
    unsigned int cm11bits;
    int x;

    cm11bits=0;
    for(x=0; x < 16; x++)
    {
        if( ( bits & (1 << x ) ) != 0 )
            cm11bits |= (1 << (cm11map[x]) );
    }


return(cm11bits);
}

/* List the variables as built into the program at compile time */
int c_list()
{
    	if( verbose )
    	{
            printf( "Version:%4s\n", VERSION );
	    printf( "The SPOOLDIR is %s\n", SPOOLDIR);
	    printf( "The LOCKDIR is %s\n", LOCKDIR);
	}
	else
	{
	    printf( "Version=%s\n", VERSION );
	    printf( "SPOOLDIR=%s\n", SPOOLDIR);
	    printf( "LOCKDIR=%s\n", LOCKDIR);
	}

return(0);
}

void exec_helper(arg_string)
char *arg_string;
{
    char *helpername;		/*  Name of the helper program  */
    char comm[PATH_MAX+81];	/* command to execute. Path + 80 (the macro) */

    if(use_helper == 1)
    {

	if( (helpername = getenv("X10HELPER")) == NULL)
	{
	    helpername=HELPER;
	}

	if( access(helpername, X_OK) == 0 )
	{
	    sprintf (comm, "%s %s &", helpername, arg_string);
	    system (comm);
	    /* Note: we will not test for success or failure here. We
	       don't know exactly what to do if a helper should fail,
	     */
	}
	else
	{
	    if (verbose)
		printf( "%s was not executable\n", helpername);
	}
    }
}
