/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include "x10.h"
#include <signal.h>
#include <string.h>
#include <limits.h>


extern int verbose;
extern char monfile[PATH_MAX];


/* This function looks up the currently running relay process...
 * .... and kills it <grin>
 */
int c_stop(argc, argv)
int argc;
char *argv[];
{
    unsigned long pid;
    FILE * pidfile;
    char buf[80];
    char procname[80];
    extern unsigned long lockpid();
    extern char *make_lock_name();
    extern void quit();

    pid = lockpid(make_lock_name(monfile));
    procname[0] = 0;
    buf[0] = 0;
    pidfile = (FILE *) NULL;

    if( pid == 0 )
    {
	if( verbose )
	    printf("stop.c: pid not available for file %s\n", monfile);
	return(1);
    }
    if( pid < 0 )
        return(-1);
    
/* Now this is really linux dependent.  It relies on having the 
 * /proc filesystem in order to verify that the process is really
 * the right one.
 */
#ifdef __linux__
    sprintf(procname, "/proc/%ld/cmdline", pid);
    if( (pidfile = fopen( procname,"r")) == NULL )
    {
	if( verbose )
	    printf("proc file not openable for %ld\n", pid);
        quit(0);
    }
    buf[0] = '\0';
    fgets(buf,79,  pidfile);
    {
	buf[79] = '\0';
        if( strstr(buf, "heyu_relay") == NULL )
	{
	    if( verbose )
		printf("proc file for %ld did not contain \"heyu_relay\"\n", pid);
	    quit(0);
	}
    }
#endif

    if( verbose )
        printf("killing %ld\n", pid);
    if (kill(pid, SIGTERM) != 0)
    {
        fprintf(stderr, "I could not kill %ld\n", pid);
    }

    quit();
    return(0);
} 
