/*
	This utility is a front-end to the sunset routines in sunset.c
	It takes 0 to 2 arguments.
	With no arguments, it will return the dusk and dawn times for today
	ARG 1 = the time (in seconds from Jan 1, 1970) that you want to use
	ARG 2 = The number of minutes you'd like the times shifted.

	Author, Daniel Suthers
	Jan, 2001
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
extern double lat_d, lat_m, long_d, long_m;
char latitude[100], longitude[100];

int main(argc, argv)
int argc;
char **argv;
{

	int rtn = 0;
	int smm;
	int sunrise(), sunset();
	long offset;
	long time_to_set;

        lat_d = lat_m = long_d = long_m = 0;

	if( argc >= 2 )
	{
	    time_to_set=atol(argv[1]);
	}
	else
	{
	    time_to_set=0;
	}
	offset = 0;
	if( argc == 3 )
	{
	    offset=atol(argv[2]);
	}

	if( getenv("LATITUDE") == NULL || getenv("LONGITUDE")== NULL )
	{
	    fprintf(stderr, "The LATITUDE and LONGITUDE environment variables are not set.\n");
	    exit(-1);
	}

	strcpy(latitude, getenv("LATITUDE"));
	strcpy(longitude, getenv("LONGITUDE"));
	
	sunrise(&smm, time_to_set);
	smm += offset;
	printf("DAWN=%02d:%02d\n", smm / 60, smm % 60);
	sunset(&smm, time_to_set);
	smm += offset;
	printf("DUSK=%02d:%02d\n", smm / 60, smm % 60);

return(rtn);
}
