#!/usr/bin/ruby
# encoding: ISO-8859-1
# ^ Magic comment line
puts <<SLARTIBARTFAST
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML><HEAD><TITLE>Location list</TITLE>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
</HEAD><body bgcolor=white>
SLARTIBARTFAST
timestamp = Time.now.strftime("%Y-%m-%d %l:%M %p %Z")
print "<p>Location list generated #{timestamp}</p>\n"
puts "<table>"
puts "<tr><th>Station ID</th><th>Name</th><th>Type</th><th>Latitude</th><th>Longitude</th></tr>"
dump = `psql -c "COPY (SELECT STATION_ID, LAT, LNG, DATUM, NAME FROM DATA_SETS ORDER BY NAME ASC) TO STDOUT;" harmbase2`
dump.each_line do |line|
  sid, lat, lng, datum, name = line.split(' ', 5)
  kind = (datum == "\\N" ? "Sub" : "Ref")
  name.chomp!
  lat = lat.to_f
  lng = lng.to_f
  lat = sprintf("%0.4f %s", lat.abs, (lat < 0 ? "S" : "N"))
  lng = sprintf("%0.4f %s", lng.abs, (lng < 0 ? "W" : "E"))
  puts "<tr><td>#{sid}</td><td>#{name}</td><td>#{kind}</td><td>#{lat}</td><td>#{lng}</td></tr>"
end
puts "</table>"
puts "</BODY></HTML>"
