#include "config.h"

struct mserv_cmd_key Mserv_Cmd_Key[] = {
   { 200, (Function) mserv_key_connect },
   { 201, (Function) NULL },
   { 202, (Function) mserv_key_connected },
   { 222, (Function) mserv_key_update_status},
   { 225, (Function) mserv_key_on_queue},
   { 227, (Function) mserv_key_on_album},
   { 228, (Function) mserv_key_on_track},
   { 247, (Function) mserv_key_on_queue_add },
   { 254, (Function) mserv_key_on_queue_remove },
   { 404, (Function) mserv_key_on_no_queue },
   { 619, (Function) NULL },
   { 622, (Function) mserv_key_next_song },
   { 0, NULL },
};

void mserv_connect(void)
{
   struct sockaddr_in sin;
   struct hostent *hent;
   char buf[MAX_INPUT_BUFFER];
   
   if (Session.connected)
      return;

   sin.sin_family = PF_INET;
   sin.sin_port = htons(atoi(Session.Pref.port));

   if ((hent = gethostbyname(Session.Pref.host)) == NULL)
   {
      printf("No such host.%s\n", Session.Pref.host);
      return;
   }
   
   sin.sin_addr = *(struct in_addr *)hent->h_addr_list[0];
   
   if ((Session.socket = socket(AF_INET, SOCK_STREAM, 0)) == -1)
   {
      strcat(buf, strerror(errno));
      printf("Can't make Socket: (%d): %s\n", errno, buf);
      return;
   }

   if (connect(Session.socket, &sin, sizeof(sin)) == -1)
   {
      strcat(buf, strerror(errno));
      printf("Can't make Connection: (%d): %s\n", errno, buf);
      return;
   }

   fcntl(Session.socket, F_SETFL, O_NONBLOCK);

   Session.socket_tag = gdk_input_add(Session.socket, GDK_INPUT_READ,
				      (GdkInputFunction) check_mserv, NULL);

   Session.connected = 1;
}

void check_mserv(void)
{
   int len = 0, totallen = 0, key, func, i, delim;
   char buf[64];
   char *loc, *loc2, *datap;
   char *data = NULL;
   char *output = NULL;
   static char *residual = NULL;
   
   if (Session.socket <= 0)
      return; 

   if (residual)
   {
      totallen = strlen(residual);
      output = malloc(totallen);
      memcpy(output, residual, totallen);
      free(residual);
   }
   
   /* Assemble as much as is ready on the socket. */
   while ((len = read(Session.socket, buf, sizeof(buf))) > 0)
   {
      output = realloc(output, totallen + len);
      memcpy(output + totallen, buf, len);
      totallen += len;
   }
   
   if (!output)
      return;   

   output = realloc(output, totallen + 1);
   output[totallen] = '\0';
   
   loc = output;
   
   while (loc && *loc)
   {
      /* find what type, and the delim sizeof */
      if (*loc == '=')
      {
         loc++;
         loc2 = strstr(loc, "\r\n");
         delim = sizeof(char) * 2;
      }
      else
      {
         loc2 = strstr(loc, "\r\n.\r\n");
         delim = sizeof(char) * 5;
      }
      if (!loc2)	 
         break;

      len = loc2 - loc;
      data = malloc(len + 1);
      memcpy(data, loc, len);
      data[len] = '\0';
      
      datap = data;
      

      for(i = 0; isdigit(*data); i++, data++)
         buf[i] = *data;
 
      buf[i] = '\0';
      key = atoi(buf);
      while(isspace(*data))
         data++;

      /* Just print key/data, useful in debuging only */
#if DEBUG
      printf("Key: %d Data:\n%s\n", key, data);
#endif
      /* Go through and try to hit a function related to the key. */
      func = FALSE;
      for(i = 0; Mserv_Cmd_Key[i].key > 0; i++)
      {
         if (Mserv_Cmd_Key[i].key == key)
         {
            if (Mserv_Cmd_Key[i].func)
               Mserv_Cmd_Key[i].func(data);
            func = TRUE;
            break;
         }
      }
      /* Isn't one, print it all ugly like so they at least have something. */

      if (!func)
         print_outputText(data);

      free(datap);		/* Just free this up. */

      loc = loc2 + delim;
   }

   if (!loc2)
   {
      /* Rare case, waiting for another read() full of data. */
      residual = malloc(strlen(loc) + 1);
      memcpy(residual, loc, strlen(loc) + 1);
      free(output);
   }
   else
   {
      free(output);
      residual = NULL;
   }
}

int send_mserv(char *buf)
{
   if (Session.socket <= 0)
      return FALSE;

   write(Session.socket, buf, strlen(buf));
   return TRUE;
}

int send_mserv_timer(char *buf)
{
   if (Session.socket <= 0)
      return FALSE;
   write(Session.socket, buf, strlen(buf));
   return FALSE;
}

void mserv_key_connect(char *data)
{
   char buf[STANDARD_BUFFER];
   
   print_statusbar(Session.StatusBar, "Connecting . . .");
   sprintf(buf, "USER %s\nPASS %s rtcomputer\n",
           Session.Pref.login,
           Session.Pref.password);
   send_mserv(buf);
}

void mserv_disconnect(void)
{
   if (Session.socket > 0)
   {
      close(Session.socket);
      Session.socket = 0;
      Session.connected = 0;
      gtk_timeout_remove(Session.QueueWin.timer_tag);
      gtk_input_remove(Session.socket_tag);
      print_statusbar(Session.StatusBar, "Disconnected.");
   }
}

void mserv_key_connected(char *data)
{
   Session.connected = TRUE;
   send_mserv("status\nqueue\nalbums\n");
   print_statusbar(Session.StatusBar, "Connected!");
#if 0
   Session.QueueWin.timer_tag = gtk_timeout_add(1000, (GtkFunction) send_mserv,
						"queue\n");
#endif
}

void mserv_key_next_song(char *data)
{
   send_mserv("status\nqueue\n");   
}

void mserv_key_update_status(char *data)
{
   char *token;

   if (!Session.StatusWin.window)
      return;
   
   /* Skip to the actual first token. */
   token = strtok(data, "\n");

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Tracks_Included), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Tracks_Excluded), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Album_Number), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Track_Number), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Artist), token);
   
   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Song), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Last_Played),
		      ctime((const time_t *)token));
   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Length), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Random), token);

   token = strtok(NULL, "\t");
   gtk_entry_set_text(GTK_ENTRY(Session.StatusWin.Random_Factor), token);

}

/* Wrappers to send Commands. */
void mserv_cmd_next(void)
{   
   send_mserv("next\n");
}

void mserv_cmd_stop(void)
{
   send_mserv("stop\n");
}
void mserv_cmd_pause(void)
{
   send_mserv("pause\n");
}
void mserv_cmd_play(void)
{
   send_mserv("play\n");
}	
