#define MAX_INPUT_BUFFER 	1024
#define STANDARD_BUFFER		1024
#define MINI_BUFFER		64
#if DEBUG
#define MAX_DEBUG_BUF		1024
#endif

extern struct session Session;

int key_history_init(void);
#if DEBUG
void key_history_display(void);
#endif
void key_history_add(void);
void key_history_next(void);
void key_history_prev(void);
void key_history_clear(void);

typedef int (*Function)();

struct key_history {
      char history[1024];
      struct key_history *next;
      struct key_history *prev;      
};

struct pref
{
      char login[256];
      char password[256];
      char host[256];
      char port[256];
};

struct setup
{
      GtkWidget *entry_login;
      GtkWidget *entry_password;
      GtkWidget *entry_host;
      GtkWidget *entry_port;
};

struct status_win 
{
      GtkWidget *window;
      GtkWidget *Song;
      GtkWidget *Artist;
      GtkWidget *Album_Number;
      GtkWidget *Track_Number;
      GtkWidget *Random;
      GtkWidget *Random_Factor;
      GtkWidget *Last_Played;
      GtkWidget *Tracks_Included;
      GtkWidget *Tracks_Excluded;      
      GtkWidget *Length;
};

struct queue_win
{
      GtkWidget *window;
      GtkWidget *clist;
      int timer_tag;
};

struct album_win
{
      GtkWidget *window;		
      GtkWidget *a_clist, *t_clist;
      gboolean 	a_clist_select_all;
      gboolean	t_clist_select_all;
};

struct console_win
{
      GtkWidget *window;
      GtkWidget *outputText;
      GtkWidget *inputEntry;
};

struct session
{
      GtkWidget *StatusBar;
      
      struct setup Setup;
      struct pref Pref;      
      struct status_win StatusWin;
      struct album_win AlbumWin;
      struct queue_win QueueWin;
      struct console_win ConsoleWin;
      struct key_history *KH;
      struct key_history *KH_loc;
      
      album **albums;
      int albums_count;

      char key_buffer[MAX_INPUT_BUFFER];
      int socket;
      int socket_tag;
      int connected;
};

