#include "config.h"

void album_init_window(void)
{
   GtkWidget *hbox;
   GtkWidget *vbox;
   GtkWidget *hbuttonbox;
   GtkWidget *button;
   GtkWidget *swin;
   GtkWidget *pane;
   int i;
   
   gchar *a_titles[] = { "Artist", "Albums", "#"};
   gchar *t_titles[] = { "Track", "Name", "Author", "Rating", "Length", "#" };
#if DEBUG
   printf("Initializing Album Window\n");
#endif
   /* Start the basic window */
      
   Session.AlbumWin.window = gtk_scrolled_window_new(NULL, NULL);
   hbox = gtk_hbox_new(FALSE, 0);
   
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Session.AlbumWin.window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Session.AlbumWin.window), hbox);
   
   /* Null some stuff. */
   Session.AlbumWin.a_clist_select_all = FALSE;
   Session.AlbumWin.t_clist_select_all = FALSE;
   
   /* The pane for the album/track clists */
   pane = gtk_hpaned_new();
   gtk_box_pack_start_defaults(GTK_BOX(hbox), pane);

   /* left pane */
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_paned_add1(GTK_PANED(pane), vbox);   
   swin = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin), 
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   Session.AlbumWin.a_clist = gtk_clist_new_with_titles(3, a_titles);
   gtk_clist_set_selection_mode(GTK_CLIST(Session.AlbumWin.a_clist),
				GTK_SELECTION_MULTIPLE);

   for (i = 0; i < sizeof(a_titles) / sizeof(char *); i++)
      gtk_clist_set_column_auto_resize(GTK_CLIST(Session.AlbumWin.a_clist),
				       i, TRUE);
   
   gtk_clist_set_column_visibility(GTK_CLIST(Session.AlbumWin.a_clist), 
				   2, FALSE);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin),
					 Session.AlbumWin.a_clist);
   gtk_box_pack_start(GTK_BOX(vbox), swin, TRUE, TRUE, 0);
   hbuttonbox = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, FALSE, 0);
   
   BUTTONBOX_APPEND(button, hbuttonbox, "Select All", "clicked", 
		    album_button_select_all, 
		    Session.AlbumWin.a_clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Unselect All", "clicked", 
		    album_button_unselect_all, 
		    Session.AlbumWin.a_clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Queue Selected", "clicked", 
		    album_button_queue_selected, 
		    Session.AlbumWin.a_clist);
   /* Just signals. */
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.a_clist), "select-row",
		      GTK_SIGNAL_FUNC(album_on_select_set_row_data), NULL); 
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.a_clist), "unselect-row",
		      GTK_SIGNAL_FUNC(album_on_unselect_set_row_data), NULL); 
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.a_clist), "select-row",
		      GTK_SIGNAL_FUNC(album_on_select_album), NULL); 
   
   /* right pane */
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_paned_add2(GTK_PANED(pane), vbox);   
   swin = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin), 
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   Session.AlbumWin.t_clist = gtk_clist_new_with_titles(6, t_titles);
   gtk_clist_set_selection_mode(GTK_CLIST(Session.AlbumWin.t_clist),
				GTK_SELECTION_MULTIPLE);
   
   for (i = 0; i < sizeof(t_titles) / sizeof(char *); i++)
      gtk_clist_set_column_auto_resize(GTK_CLIST(Session.AlbumWin.t_clist),
				       i, TRUE);
   gtk_clist_set_column_visibility(GTK_CLIST(Session.AlbumWin.t_clist), 
				   5, FALSE);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin),
					 Session.AlbumWin.t_clist);
   gtk_paned_set_position(GTK_PANED(pane), 350);

   gtk_box_pack_start(GTK_BOX(vbox), swin, TRUE, TRUE, 0);
   hbuttonbox = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, FALSE, 0);
   
   BUTTONBOX_APPEND(button, hbuttonbox, "Select All", "clicked", 
		    album_button_select_all, 
		    Session.AlbumWin.t_clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Unselect All", "clicked", 
		    album_button_unselect_all, 
		    Session.AlbumWin.t_clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Queue Selected", "clicked", 
		    album_button_queue_selected,
		    Session.AlbumWin.t_clist);
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.t_clist), "select-row",
		      GTK_SIGNAL_FUNC(album_on_select_set_row_data), NULL); 
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.t_clist), "unselect-row",
		      GTK_SIGNAL_FUNC(album_on_unselect_set_row_data), NULL);
#if ALBUM_ON_SELECT_TRACK
   gtk_signal_connect(GTK_OBJECT(Session.AlbumWin.t_clist), "select-row",
		      GTK_SIGNAL_FUNC(album_on_select_track), NULL);
#endif
   
   /* Show Everything */
   gtk_widget_show_all(Session.AlbumWin.window);
   album_display_albumlist();
}

void mserv_key_on_album(char *data)
{
   int i;
   char *p, *line, *word;
   
   if (!Session.albums)
   {
      for (p = data; p && *p; p++)
	 if (*p == '\n')
	    Session.albums_count++;
      
      Session.albums = (album **)calloc(Session.albums_count, sizeof(album *));

      p = data;
      strsep(&p, "\n");
   
      for (i = 0; i < Session.albums_count ; i++)
      {
	 album *a;
	 
	 a = malloc(sizeof (album));
	 
	 line = strsep(&p, "\n");
	 
	 word = strsep(&line, "\t");
	 a->index = malloc(strlen(word) + 1);	 
	 strcpy(a->index, word);

	 word = strsep(&line, "\t");
	 a->name = malloc(strlen(word) + 1);
	 strcpy(a->name, word);

	 word = strsep(&line, "\r");	 
	 a->location = malloc(strlen(word) + 1);
	 strcpy(a->location, word);
	 a->list = NULL;
	 
	 Session.albums[i] = a;
      }
   }
   
   album_display_albumlist();
}

void mserv_key_on_track(char *data)
{
   char *word, *line;
   int index;   
   track *tr, *prev;
   
   line = strsep(&data, "\n"); /* Strip the first useless line. */
   line = strsep(&data, "\n"); /* Strip the second useless line. */

   word = strsep(&line, "\t");
   index = atoi(word);
   
   /* Do the track list. */

   if (!Session.albums[index]->list)
   {
      tr = Session.albums[index]->list = malloc(sizeof(track));
       
      while (data && *data)
      {
	 line = strsep(&data, "\n");
      
	 strsep(&line, "\t");
      
	 word = strsep(&line, "\t");      
	 tr->index = malloc(strlen(word) + 1);
	 strcpy(tr->index, word);
      
	 word = strsep(&line, "\t");
	 tr->artist = malloc(strlen(word) + 1);
	 strcpy(tr->artist, word);

	 word = strsep(&line, "\t");
	 tr->name = malloc(strlen(word) + 1);
	 strcpy(tr->name, word);

	 word = strsep(&line, "\t");
	 tr->rating = malloc(strlen(word) + 1);
	 strcpy(tr->rating, word);
	 
	 word = strsep(&line, "\r");
	 tr->length = malloc(strlen(word) + 1);
	 strcpy(tr->length, word);

	 prev = tr;
	 tr = tr->next = malloc(sizeof(track));
      }   
      free(prev->next);
      prev->next = NULL;
   }
   album_display_tracklist(index);
}

void album_display_albumlist(void)
{
   int i;
   
   if (Session.AlbumWin.window)
   {
      gtk_clist_freeze(GTK_CLIST(Session.AlbumWin.a_clist));
      gtk_clist_clear(GTK_CLIST(Session.AlbumWin.a_clist));
      for (i = 0; i < Session.albums_count; i++)
      {
	 char *temp[] = 
	 {
	    Session.albums[i]->name,
	    Session.albums[i]->location, 
	    Session.albums[i]->index
	 };
	 
	 gtk_clist_append(GTK_CLIST(Session.AlbumWin.a_clist), temp);
	 gtk_clist_set_row_data(GTK_CLIST(Session.AlbumWin.a_clist),
				i, (gpointer)1);
      }
      gtk_clist_thaw(GTK_CLIST(Session.AlbumWin.a_clist));
   }
   else
   {
      print_outputText("Album List:");
   }
   
}

void album_display_tracklist(int album)
{
   track *temp;
   char buf[MINI_BUFFER];
   int i = 0;   

   if (Session.AlbumWin.window)
   {
      gtk_clist_freeze(GTK_CLIST(Session.AlbumWin.t_clist));
      gtk_clist_clear(GTK_CLIST(Session.AlbumWin.t_clist));
      
      sprintf(buf, "%d", album);

      for(temp = Session.albums[album]->list; temp->next; temp = temp->next)
      { 
	 char *temp2[] =
	 {
	    temp->index, 
	    temp->name, 
	    temp->artist, 
	    temp->rating, 
	    temp->length, 
	    buf
	 };
	 
	 gtk_clist_append(GTK_CLIST(Session.AlbumWin.t_clist), temp2);
	 gtk_clist_set_row_data(GTK_CLIST(Session.AlbumWin.t_clist), i++,
				(gpointer)1);

      }      
      gtk_clist_thaw(GTK_CLIST(Session.AlbumWin.t_clist));
   }
   else
      print_outputText("Track List");
   
}

#if ALBUM_ON_SELECT_TRACK	/*  Not needed anymore. */

void album_on_select_track(GtkCList *clist,
			   gint row,
			   gint column,
			   GdkEventButton *event,
			   gpointer data)
{
   char buf2[MINI_BUFFER];
   char *a;
   char *t;

   if (Session.AlbumWin.t_clist_select_all)
      return;
   
   
   gtk_clist_get_text(GTK_CLIST(Session.AlbumWin.t_clist), row, 5, &a);
   gtk_clist_get_text(GTK_CLIST(Session.AlbumWin.t_clist), row, 0, &t);

   sprintf(buf2, "queue %s %s\n", a, t);
   puts(buf2);
   send_mserv(buf2);
}
#endif

void album_on_select_set_row_data(GtkCList *clist,
				  gint row,
				  gint column,
				  GdkEventButton *event,
				  gpointer data)
{
   gtk_clist_set_row_data(clist, row, (gpointer)2);
}
void album_on_unselect_set_row_data(GtkCList *clist,
				    gint row,
				    gint column,
				    GdkEventButton *event,
				    gpointer data)
{
   gtk_clist_set_row_data(clist, row, (gpointer)1);
}

void album_on_select_album(GtkCList *clist,
			   gint row,
			   gint column,
			   GdkEventButton *event,
			   gpointer data)
{
   char *buf;
   char buf2[STANDARD_BUFFER];

   if (Session.AlbumWin.a_clist_select_all)
      return;
   
   gtk_clist_get_text(GTK_CLIST(Session.AlbumWin.a_clist), row, 2, &buf);

   if (Session.albums[atoi(buf-1)]->list)
      album_display_tracklist(atoi(buf));
   else
   {      
      sprintf(buf2, "tracks %s\n", buf);
      send_mserv(buf2);
   }
}

void album_button_select_all(GtkButton *button, gpointer data)
{
   gboolean *t;
   
   if (data == Session.AlbumWin.a_clist)
      t = &Session.AlbumWin.a_clist_select_all;
   else
      t = &Session.AlbumWin.t_clist_select_all;
   
   *t = TRUE;
   gtk_clist_select_all(GTK_CLIST(data));
   *t = FALSE;
}

void album_button_unselect_all(GtkButton *button, gpointer data)
{
   gtk_clist_unselect_all(GTK_CLIST(data));
}
void album_button_queue_selected(GtkButton *button, gpointer data)
{
   int row = 0;
   int gp;

   while (1)
   {
      char buf2[STANDARD_BUFFER];
      gp = (int)gtk_clist_get_row_data(GTK_CLIST(data), row);

      if (gp == 0)
	 break;
      else if (gp == 1)
      {
	 row++;
	 continue;
      }
      
	 
      if (data == Session.AlbumWin.a_clist) /* Album type struct. */
      {
	 char *buf;
      
	 gtk_clist_get_text(GTK_CLIST(data), row, 2, &buf);
	 sprintf(buf2, "queue %s\n", buf);
      }
      else
      {
	 char *a, *t;
	 
	 gtk_clist_get_text(GTK_CLIST(data), row, 5, &a);
	 gtk_clist_get_text(GTK_CLIST(data), row, 0, &t);
	 
	 sprintf(buf2, "queue %s %s\n", a, t);
      }

      send_mserv(buf2);
      
      gtk_clist_unselect_row(GTK_CLIST(data), row, 0);
      row++;
   }
}


void album_on_destroy(GtkWidget *widget, gpointer data)
{
   Session.AlbumWin.window = NULL;
}

