; GTK DBF Editor - a simple editor for DBF files
; Copyright (C) 2001-2012 Steffen Macke <sdteffen@sdteffen.de>
;  
; gtkdbfeditor.nsi : Nullsoft Installation System (NSIS) script
; Copyright (C) 2000-2004 Herman Bloggs, Steffen Macke
; Copyright (C) 2005-2012 Steffen Macke
;  
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

; NOTE: this .NSI script is designed for NSIS v2.0

;--------------------------------
;Global Variables
Var name

;--------------------------------
;Configuration

;The name var is set in .onInit
Name $name

; Uninstall only the installed files and folders
!define UninstLog "uninstall.log"
Var UninstLog

; Where the GTK+ binares are installed. Set in .onInit 
Var GTKBIN

; Add file macro
!macro File FilePath FileName
 !define FileID ${__LINE__}
 ;IfFileExists "$OUTDIR\${FileName}" NoExtract_${FileID}
 File "${FilePath}${FileName}"
 NoExtract_${FileID}:
 FileWrite $UninstLog "$OUTDIR\${FileName}$\r$\n"
 !undef FileID
!macroend
!define File "!insertmacro File"
 
; Set output path macro
!macro SetOutPath Path
 SetOutPath "${Path}"
 FileWrite $UninstLog "${PATH}$\r$\n"
!macroend
!define SetOutPath "!insertmacro SetOutPath"
 
Section -openlogfile
 SetOutPath "$INSTDIR"
 
 IfFileExists "$INSTDIR\${UninstLog}" +3
 FileOpen $UninstLog "$INSTDIR\${UninstLog}" w
 Goto +4
  SetFileAttributes "$INSTDIR\${UninstLog}" NORMAL
  FileOpen $UninstLog "$INSTDIR\${UninstLog}" a
  FileSeek $UninstLog 0 END
SectionEnd

OutFile "gtkdbfeditor-setup-${GTKDBFEDITOR_VERSION}.exe"
SetCompressor LZMA
;DirShow show
ShowInstDetails show
ShowUninstDetails show
SetDateSave on

; $name and $INSTDIR are set in .onInit function..

!include "MUI.nsh"

;--------------------------------
;Defines

!define DIA_REG_KEY				"SOFTWARE\GtkDbfEditor"
!define DIA_UNINSTALL_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GtkDbfEditor"
!define HKLM_APP_PATHS_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gtkdbfeditor.exe"
!define HKLM_CMD_PATHS_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gtkdbfeditor.exe"
!define DIA_STARTUP_RUN_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
!define DIA_UNINST_EXE				"gtkdbfeditor-${GTKDBFEDITOR_VERSION}-uninstall.exe"

XPStyle On
  
VIAddVersionKey "ProductName" "GTK DBF Editor"
VIAddVersionKey "CompanyName" "Steffen Macke"
VIAddVersionKey "LegalCopyright" "(c) 2001-2012  Steffen Macke"
VIAddVersionKey "FileDescription" "GTK DBF Editor Installer"
VIAddVersionKey "FileVersion" "1.0.4.0"
VIProductVersion "1.0.4.0"

;--------------------------------
;Modern UI Configuration

  !define MUI_ICON				"gtkdbfeditor-install.ico"
  !define MUI_UNICON				"gtkdbfeditor-uninstall.ico"
  !define MUI_WELCOMEFINISHPAGE_BITMAP 		"gtkdbfeditor-intro.bmp"
  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP		"gtkdbfeditor-header.bmp"
  !define MUI_HEADERIMAGE_UNBITMAP		"gtkdbfeditor-header.bmp"

  ; Alter License section
  !define MUI_LICENSEPAGE_BUTTON		$(DIA_LICENSE_BUTTON)
  !define MUI_LICENSEPAGE_TEXT_BOTTOM		$(DIA_LICENSE_BOTTOM_TEXT)

  !define MUI_COMPONENTSPAGE_SMALLDESC
  !define MUI_ABORTWARNING

  ;Finish Page config
  !define MUI_FINISHPAGE_RUN			"$INSTDIR\bin\gtkdbfeditor.exe"
  !define MUI_FINISHPAGE_RUN_NOTCHECKED
  !define MUI_FINISHPAGE_LINK			$(DIA_FINISH_VISIT_WEB_SITE)
  !define MUI_FINISHPAGE_LINK_LOCATION          "http://sdteffen.de/gtkdbfeditor"

;--------------------------------
;Pages
  
  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE			"..\..\COPYING"
  !insertmacro MUI_PAGE_COMPONENTS

  ; Dia install dir page
  !insertmacro MUI_PAGE_DIRECTORY

  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages
 
  ;; English goes first because its the default. The rest are
  ;; in alphabetical order (at least the strings actually displayed
  ;; will be).

  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "German"
;--------------------------------
;Translations

  !define DIA_DEFAULT_LANGFILE "locale\english.nsh"

  !include "langmacros.nsh"
  
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "ENGLISH" "locale\english.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "GERMAN" "locale\german.nsh"
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Start Install Sections ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
;--------------------------------
;Dia Install Section

Section $(DIA_SECTION_TITLE) SecDia
  SetOverwrite On
  SectionIn 1 RO

  ; Check install rights..
  Call CheckUserInstallRights
  Pop $R0

  StrCmp $R0 "NONE" dia_none
  StrCmp $R0 "HKLM" dia_hklm dia_hkcu
   
  dia_hklm:
    WriteRegStr HKLM "${HKLM_APP_PATHS_KEY}" "" "$INSTDIR\bin\gtkdbfeditor.exe"
    WriteRegStr HKLM "${HKLM_APP_PATHS_KEY}" "Path" "$R1\bin;$GTKBIN"
    WriteRegStr HKLM "${HKLM_CMD_PATHS_KEY}" "" "$INSTDIR\bin\gtkdbfeditor.exe"
    WriteRegStr HKLM "${HKLM_CMD_PATHS_KEY}" "Path" "$R1\bin;$GTKBIN"
    WriteRegStr HKLM ${DIA_REG_KEY} "" "$INSTDIR"
    WriteRegStr HKLM ${DIA_REG_KEY} "Version" "${GTKDBFEDITOR_VERSION}"
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "DisplayName" $(DIA_UNINSTALL_DESC)
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${DIA_UNINST_EXE}"
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "DisplayIcon" "$INSTDIR\${DIA_UNINST_EXE}"
    ; Sets scope of the desktop and Start Menu entries for all users.
    SetShellVarContext "all"
    Goto dia_install_files

  dia_hkcu:
    WriteRegStr HKCU ${DIA_REG_KEY} "" "$INSTDIR"
    WriteRegStr HKCU ${DIA_REG_KEY} "Version" "${GTKDBFEDITOR_VERSION}"
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "DisplayName" $(DIA_UNINSTALL_DESC)
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${DIA_UNINST_EXE}"
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "DisplayIcon" "$INSTDIR\${DIA_UNINST_EXE}"

    Goto dia_install_files

  dia_none:

  dia_install_files:

; Required by GPL  
${SetOutPath} "$INSTDIR"
${File} "..\..\" "COPYING"   

; find mingw -printf "%y %p\n" | sed 's/\//\\/g' | sed 's/d mingw\(.*\)/\${SetOutPath} "\$INSTDIR\1"/' | sed 's/f \(.*\\\)\(.*\)/\${File} "\1" "\2"/'

${SetOutPath} "$INSTDIR"
${SetOutPath} "$INSTDIR\lib"
${SetOutPath} "$INSTDIR\lib\libglade"
${SetOutPath} "$INSTDIR\lib\libglade\2.0"
${SetOutPath} "$INSTDIR\lib\gtk-2.0"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\modules"
${File} "mingw\lib\gtk-2.0\modules\" "libgail.dll"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
${File} "mingw\lib\gtk-2.0\2.10.0\engines\" "libwimp.dll"
${File} "mingw\lib\gtk-2.0\2.10.0\engines\" "libpixmap.dll"
${SetOutPath} "$INSTDIR\bin"
${File} "mingw\bin\" "libpng15-15.dll"
${File} "mingw\bin\" "libgdk_pixbuf-2.0-0.dll"
${File} "mingw\bin\" "gspawn-win32-helper-console.exe"
${File} "mingw\bin\" "libatk-1.0-0.dll"
${File} "mingw\bin\" "libglade-2.0-0.dll"
${File} "mingw\bin\" "libjasper-1.dll"
${File} "mingw\bin\" "libxml2-2.dll"
${File} "mingw\bin\" "libpixman-1-0.dll"
${File} "mingw\bin\" "libjpeg-8.dll"
${File} "mingw\bin\" "gspawn-win32-helper.exe"
${File} "mingw\bin\" "libintl-8.dll"
${File} "mingw\bin\" "libgailutil-18.dll"
${File} "mingw\bin\" "libfreetype-6.dll"
${File} "mingw\bin\" "libgdk-win32-2.0-0.dll"
${File} "mingw\bin\" "libpangocairo-1.0-0.dll"
${File} "mingw\bin\" "libgobject-2.0-0.dll"
${File} "mingw\bin\" "libpango-1.0-0.dll"
${File} "mingw\bin\" "libgio-2.0-0.dll"
${File} "mingw\bin\" "libgtk-win32-2.0-0.dll"
${File} "mingw\bin\" "libtiff-5.dll"
${File} "mingw\bin\" "libfontconfig-1.dll"
${File} "mingw\bin\" "libgthread-2.0-0.dll"
${File} "mingw\bin\" "zlib1.dll"
${File} "mingw\bin\" "libpangoft2-1.0-0.dll"
${File} "mingw\bin\" "gtkdbfeditor.exe"
${File} "mingw\bin\" "libgmodule-2.0-0.dll"
${File} "mingw\bin\" "libffi-5.dll"
${File} "mingw\bin\" "libglib-2.0-0.dll"
${File} "mingw\bin\" "libpangowin32-1.0-0.dll"
${File} "mingw\bin\" "libcairo-2.dll"
${SetOutPath} "$INSTDIR\etc"
${SetOutPath} "$INSTDIR\etc\fonts"
${SetOutPath} "$INSTDIR\etc\fonts\conf.d"
${File} "mingw\etc\fonts\conf.d\" "README"
${SetOutPath} "$INSTDIR\etc\fonts\conf.avail"
${File} "mingw\etc\fonts\conf.avail\" "90-synthetic.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-sub-pixel-vrgb.conf"
${File} "mingw\etc\fonts\conf.avail\" "51-local.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-autohint.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-sub-pixel-bgr.conf"
${File} "mingw\etc\fonts\conf.avail\" "65-nonlatin.conf"
${File} "mingw\etc\fonts\conf.avail\" "70-yes-bitmaps.conf"
${File} "mingw\etc\fonts\conf.avail\" "69-unifont.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-sub-pixel-rgb.conf"
${File} "mingw\etc\fonts\conf.avail\" "40-nonlatin.conf"
${File} "mingw\etc\fonts\conf.avail\" "20-unhint-small-vera.conf"
${File} "mingw\etc\fonts\conf.avail\" "65-fonts-persian.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-unhinted.conf"
${File} "mingw\etc\fonts\conf.avail\" "30-urw-aliases.conf"
${File} "mingw\etc\fonts\conf.avail\" "45-latin.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-no-sub-pixel.conf"
${File} "mingw\etc\fonts\conf.avail\" "50-user.conf"
${File} "mingw\etc\fonts\conf.avail\" "60-latin.conf"
${File} "mingw\etc\fonts\conf.avail\" "30-metric-aliases.conf"
${File} "mingw\etc\fonts\conf.avail\" "70-no-bitmaps.conf"
${File} "mingw\etc\fonts\conf.avail\" "80-delicious.conf"
${File} "mingw\etc\fonts\conf.avail\" "65-khmer.conf"
${File} "mingw\etc\fonts\conf.avail\" "49-sansserif.conf"
${File} "mingw\etc\fonts\conf.avail\" "10-sub-pixel-vbgr.conf"
${File} "mingw\etc\fonts\conf.avail\" "20-fix-globaladvance.conf"
${File} "mingw\etc\fonts\conf.avail\" "25-unhint-nonlatin.conf"
${File} "mingw\etc\fonts\" "fonts.dtd"
${File} "mingw\etc\fonts\" "fonts.conf"
${SetOutPath} "$INSTDIR\etc\gtk-2.0"
${File} "mingw\etc\gtk-2.0\" "im-multipress.conf"
${File} "mingw\etc\gtk-2.0\" "gtkrc"
${SetOutPath} "$INSTDIR\share"
${SetOutPath} "$INSTDIR\share\gtkdbfeditor"
${File} "mingw\share\gtkdbfeditor\" "gtkdbfeditor.glade"
${SetOutPath} "$INSTDIR\share\locale"
${SetOutPath} "$INSTDIR\share\locale\is"
${SetOutPath} "$INSTDIR\share\locale\is\LC_MESSAGES"
${File} "mingw\share\locale\is\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\is\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\is\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\is\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\is\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ca"
${SetOutPath} "$INSTDIR\share\locale\ca\LC_MESSAGES"
${File} "mingw\share\locale\ca\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ca\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ca\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ca\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ca\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\da"
${SetOutPath} "$INSTDIR\share\locale\da\LC_MESSAGES"
${File} "mingw\share\locale\da\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\da\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\da\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\da\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\da\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\si"
${SetOutPath} "$INSTDIR\share\locale\si\LC_MESSAGES"
${File} "mingw\share\locale\si\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\si\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\si\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\si\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\si\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\uz@cyrillic"
${SetOutPath} "$INSTDIR\share\locale\uz@cyrillic\LC_MESSAGES"
${File} "mingw\share\locale\uz@cyrillic\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\uz@cyrillic\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\uz@cyrillic\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_TW"
${SetOutPath} "$INSTDIR\share\locale\zh_TW\LC_MESSAGES"
${File} "mingw\share\locale\zh_TW\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\zh_TW\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\zh_TW\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\zh_TW\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\zh_TW\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\et"
${SetOutPath} "$INSTDIR\share\locale\et\LC_MESSAGES"
${File} "mingw\share\locale\et\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\et\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\et\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\et\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\et\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\bn"
${SetOutPath} "$INSTDIR\share\locale\bn\LC_MESSAGES"
${File} "mingw\share\locale\bn\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\bn\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\bn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\bn\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\bn\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\tt"
${SetOutPath} "$INSTDIR\share\locale\tt\LC_MESSAGES"
${File} "mingw\share\locale\tt\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\tt\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\tt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\tt\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\tt\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mai"
${SetOutPath} "$INSTDIR\share\locale\mai\LC_MESSAGES"
${File} "mingw\share\locale\mai\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\mai\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\mai\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\mai\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\mai\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\cy"
${SetOutPath} "$INSTDIR\share\locale\cy\LC_MESSAGES"
${File} "mingw\share\locale\cy\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\cy\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\cy\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\cy\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\cy\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sv"
${SetOutPath} "$INSTDIR\share\locale\sv\LC_MESSAGES"
${File} "mingw\share\locale\sv\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sv\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sv\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sv\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sv\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\de"
${SetOutPath} "$INSTDIR\share\locale\de\LC_MESSAGES"
${File} "mingw\share\locale\de\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\de\LC_MESSAGES\" "gtkdbfeditor.mo"
${File} "mingw\share\locale\de\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\de\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\de\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\de\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\gl"
${SetOutPath} "$INSTDIR\share\locale\gl\LC_MESSAGES"
${File} "mingw\share\locale\gl\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\gl\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\gl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\gl\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\gl\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\pl"
${SetOutPath} "$INSTDIR\share\locale\pl\LC_MESSAGES"
${File} "mingw\share\locale\pl\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\pl\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\pl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\pl\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\pl\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\en"
${SetOutPath} "$INSTDIR\share\locale\en\LC_MESSAGES"
${File} "mingw\share\locale\en\LC_MESSAGES\" "gtkdbfeditor.mo"
${SetOutPath} "$INSTDIR\share\locale\cs"
${SetOutPath} "$INSTDIR\share\locale\cs\LC_MESSAGES"
${File} "mingw\share\locale\cs\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\cs\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\cs\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\cs\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\cs\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\hy"
${SetOutPath} "$INSTDIR\share\locale\hy\LC_MESSAGES"
${File} "mingw\share\locale\hy\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\hy\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\hy\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\hy\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\hy\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ps"
${SetOutPath} "$INSTDIR\share\locale\ps\LC_MESSAGES"
${File} "mingw\share\locale\ps\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ps\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ps\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ps\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ps\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\bs"
${SetOutPath} "$INSTDIR\share\locale\bs\LC_MESSAGES"
${File} "mingw\share\locale\bs\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\bs\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\bs\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\bs\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\bs\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sl"
${SetOutPath} "$INSTDIR\share\locale\sl\LC_MESSAGES"
${File} "mingw\share\locale\sl\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sl\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sl\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sl\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\li"
${SetOutPath} "$INSTDIR\share\locale\li\LC_MESSAGES"
${File} "mingw\share\locale\li\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\li\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\li\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\li\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mk"
${SetOutPath} "$INSTDIR\share\locale\mk\LC_MESSAGES"
${File} "mingw\share\locale\mk\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\mk\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\mk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\mk\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\mk\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\tr"
${SetOutPath} "$INSTDIR\share\locale\tr\LC_MESSAGES"
${File} "mingw\share\locale\tr\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\tr\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\tr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\tr\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\tr\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ar"
${SetOutPath} "$INSTDIR\share\locale\ar\LC_MESSAGES"
${File} "mingw\share\locale\ar\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ar\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ar\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ar\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ar\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ko"
${SetOutPath} "$INSTDIR\share\locale\ko\LC_MESSAGES"
${File} "mingw\share\locale\ko\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ko\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ko\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ko\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ko\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\pt_BR"
${SetOutPath} "$INSTDIR\share\locale\pt_BR\LC_MESSAGES"
${File} "mingw\share\locale\pt_BR\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\pt_BR\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\pt_BR\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\pt_BR\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\pt_BR\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\hr"
${SetOutPath} "$INSTDIR\share\locale\hr\LC_MESSAGES"
${File} "mingw\share\locale\hr\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\hr\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\hr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\hr\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\hr\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\es"
${SetOutPath} "$INSTDIR\share\locale\es\LC_MESSAGES"
${File} "mingw\share\locale\es\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\es\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\es\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\es\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\es\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\my"
${SetOutPath} "$INSTDIR\share\locale\my\LC_MESSAGES"
${File} "mingw\share\locale\my\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\my\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\my\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mg"
${SetOutPath} "$INSTDIR\share\locale\mg\LC_MESSAGES"
${File} "mingw\share\locale\mg\LC_MESSAGES\" "glib20.mo"
${SetOutPath} "$INSTDIR\share\locale\ca@valencia"
${SetOutPath} "$INSTDIR\share\locale\ca@valencia\LC_MESSAGES"
${File} "mingw\share\locale\ca@valencia\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ca@valencia\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ca@valencia\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ca@valencia\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ca@valencia\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sk"
${SetOutPath} "$INSTDIR\share\locale\sk\LC_MESSAGES"
${File} "mingw\share\locale\sk\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sk\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sk\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sk\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\zu"
${SetOutPath} "$INSTDIR\share\locale\zu\LC_MESSAGES"
${File} "mingw\share\locale\zu\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\nl"
${SetOutPath} "$INSTDIR\share\locale\nl\LC_MESSAGES"
${File} "mingw\share\locale\nl\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\nl\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\nl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\nl\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\nl\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\en@shaw"
${SetOutPath} "$INSTDIR\share\locale\en@shaw\LC_MESSAGES"
${File} "mingw\share\locale\en@shaw\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\en@shaw\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\en@shaw\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\hi"
${SetOutPath} "$INSTDIR\share\locale\hi\LC_MESSAGES"
${File} "mingw\share\locale\hi\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\hi\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\hi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\hi\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\hi\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\eu"
${SetOutPath} "$INSTDIR\share\locale\eu\LC_MESSAGES"
${File} "mingw\share\locale\eu\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\eu\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\eu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\eu\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\eu\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sr@latin"
${SetOutPath} "$INSTDIR\share\locale\sr@latin\LC_MESSAGES"
${File} "mingw\share\locale\sr@latin\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sr@latin\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sr@latin\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sr@latin\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sr@latin\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\en_CA"
${SetOutPath} "$INSTDIR\share\locale\en_CA\LC_MESSAGES"
${File} "mingw\share\locale\en_CA\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\en_CA\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\en_CA\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\en_CA\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\en_CA\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\lv"
${SetOutPath} "$INSTDIR\share\locale\lv\LC_MESSAGES"
${File} "mingw\share\locale\lv\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\lv\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\lv\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\lv\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\lv\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\vi"
${SetOutPath} "$INSTDIR\share\locale\vi\LC_MESSAGES"
${File} "mingw\share\locale\vi\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\vi\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\vi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\vi\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\vi\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\gu"
${SetOutPath} "$INSTDIR\share\locale\gu\LC_MESSAGES"
${File} "mingw\share\locale\gu\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\gu\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\gu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\gu\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\gu\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\io"
${SetOutPath} "$INSTDIR\share\locale\io\LC_MESSAGES"
${File} "mingw\share\locale\io\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\io\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\io\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ml"
${SetOutPath} "$INSTDIR\share\locale\ml\LC_MESSAGES"
${File} "mingw\share\locale\ml\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ml\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ml\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ml\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ml\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\eo"
${SetOutPath} "$INSTDIR\share\locale\eo\LC_MESSAGES"
${File} "mingw\share\locale\eo\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\eo\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\eo\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\eo\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\eo\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\it"
${SetOutPath} "$INSTDIR\share\locale\it\LC_MESSAGES"
${File} "mingw\share\locale\it\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\it\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\it\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\it\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\it\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\uz"
${SetOutPath} "$INSTDIR\share\locale\uz\LC_MESSAGES"
${File} "mingw\share\locale\uz\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\uz\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\uz\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\bg"
${SetOutPath} "$INSTDIR\share\locale\bg\LC_MESSAGES"
${File} "mingw\share\locale\bg\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\bg\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\bg\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\bg\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\bg\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ja"
${SetOutPath} "$INSTDIR\share\locale\ja\LC_MESSAGES"
${File} "mingw\share\locale\ja\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ja\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ja\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ja\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ja\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\rw"
${SetOutPath} "$INSTDIR\share\locale\rw\LC_MESSAGES"
${File} "mingw\share\locale\rw\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\rw\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\rw\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\rw\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ms"
${SetOutPath} "$INSTDIR\share\locale\ms\LC_MESSAGES"
${File} "mingw\share\locale\ms\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ms\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ms\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ms\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ms\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_CN"
${SetOutPath} "$INSTDIR\share\locale\zh_CN\LC_MESSAGES"
${File} "mingw\share\locale\zh_CN\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\zh_CN\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\zh_CN\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\zh_CN\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\zh_CN\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\kn"
${SetOutPath} "$INSTDIR\share\locale\kn\LC_MESSAGES"
${File} "mingw\share\locale\kn\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\kn\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\kn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\kn\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\kn\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\oc"
${SetOutPath} "$INSTDIR\share\locale\oc\LC_MESSAGES"
${File} "mingw\share\locale\oc\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\oc\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\oc\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\oc\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\oc\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ka"
${SetOutPath} "$INSTDIR\share\locale\ka\LC_MESSAGES"
${File} "mingw\share\locale\ka\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ka\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ka\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ka\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ka\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\xh"
${SetOutPath} "$INSTDIR\share\locale\xh\LC_MESSAGES"
${File} "mingw\share\locale\xh\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\xh\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\xh\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\xh\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\xh\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\pt"
${SetOutPath} "$INSTDIR\share\locale\pt\LC_MESSAGES"
${File} "mingw\share\locale\pt\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\pt\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\pt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\pt\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\pt\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\wa"
${SetOutPath} "$INSTDIR\share\locale\wa\LC_MESSAGES"
${File} "mingw\share\locale\wa\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\wa\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\wa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\wa\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\wa\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ur"
${SetOutPath} "$INSTDIR\share\locale\ur\LC_MESSAGES"
${File} "mingw\share\locale\ur\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ur\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\fa"
${SetOutPath} "$INSTDIR\share\locale\fa\LC_MESSAGES"
${File} "mingw\share\locale\fa\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\fa\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\fa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\fa\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\fa\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\am"
${SetOutPath} "$INSTDIR\share\locale\am\LC_MESSAGES"
${File} "mingw\share\locale\am\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\am\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\am\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\am\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\be@latin"
${SetOutPath} "$INSTDIR\share\locale\be@latin\LC_MESSAGES"
${File} "mingw\share\locale\be@latin\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\be@latin\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\be@latin\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\be@latin\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\be@latin\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\te"
${SetOutPath} "$INSTDIR\share\locale\te\LC_MESSAGES"
${File} "mingw\share\locale\te\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\te\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\te\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\te\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\te\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_HK"
${SetOutPath} "$INSTDIR\share\locale\zh_HK\LC_MESSAGES"
${File} "mingw\share\locale\zh_HK\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\zh_HK\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\zh_HK\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\zh_HK\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\zh_HK\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\af"
${SetOutPath} "$INSTDIR\share\locale\af\LC_MESSAGES"
${File} "mingw\share\locale\af\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\af\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\af\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\af\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\af\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\as"
${SetOutPath} "$INSTDIR\share\locale\as\LC_MESSAGES"
${File} "mingw\share\locale\as\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\as\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\as\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\as\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\as\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\pa"
${SetOutPath} "$INSTDIR\share\locale\pa\LC_MESSAGES"
${File} "mingw\share\locale\pa\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\pa\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\pa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\pa\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\pa\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\be"
${SetOutPath} "$INSTDIR\share\locale\be\LC_MESSAGES"
${File} "mingw\share\locale\be\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\be\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\be\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\be\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\be\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sq"
${SetOutPath} "$INSTDIR\share\locale\sq\LC_MESSAGES"
${File} "mingw\share\locale\sq\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sq\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sq\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sq\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sq\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ug"
${SetOutPath} "$INSTDIR\share\locale\ug\LC_MESSAGES"
${File} "mingw\share\locale\ug\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ug\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ug\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ug\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ug\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ta"
${SetOutPath} "$INSTDIR\share\locale\ta\LC_MESSAGES"
${File} "mingw\share\locale\ta\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ta\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ta\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ta\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ta\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\az_IR"
${SetOutPath} "$INSTDIR\share\locale\az_IR\LC_MESSAGES"
${File} "mingw\share\locale\az_IR\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\az_IR\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\or"
${SetOutPath} "$INSTDIR\share\locale\or\LC_MESSAGES"
${File} "mingw\share\locale\or\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\or\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\or\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\or\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\or\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mr"
${SetOutPath} "$INSTDIR\share\locale\mr\LC_MESSAGES"
${File} "mingw\share\locale\mr\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\mr\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\mr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\mr\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\mr\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sr@ije"
${SetOutPath} "$INSTDIR\share\locale\sr@ije\LC_MESSAGES"
${File} "mingw\share\locale\sr@ije\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sr@ije\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sr@ije\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sr@ije\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sr@ije\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\br"
${SetOutPath} "$INSTDIR\share\locale\br\LC_MESSAGES"
${File} "mingw\share\locale\br\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\br\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\br\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ne"
${SetOutPath} "$INSTDIR\share\locale\ne\LC_MESSAGES"
${File} "mingw\share\locale\ne\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ne\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ne\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ne\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ne\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mn"
${SetOutPath} "$INSTDIR\share\locale\mn\LC_MESSAGES"
${File} "mingw\share\locale\mn\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\mn\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\mn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\mn\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\mn\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\tk"
${SetOutPath} "$INSTDIR\share\locale\tk\LC_MESSAGES"
${File} "mingw\share\locale\tk\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\tk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\tk\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\tk\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\th"
${SetOutPath} "$INSTDIR\share\locale\th\LC_MESSAGES"
${File} "mingw\share\locale\th\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\th\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\th\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\th\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\th\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ia"
${SetOutPath} "$INSTDIR\share\locale\ia\LC_MESSAGES"
${File} "mingw\share\locale\ia\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ia\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ia\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ru"
${SetOutPath} "$INSTDIR\share\locale\ru\LC_MESSAGES"
${File} "mingw\share\locale\ru\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ru\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ru\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ru\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ru\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\nb"
${SetOutPath} "$INSTDIR\share\locale\nb\LC_MESSAGES"
${File} "mingw\share\locale\nb\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\nb\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\nb\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\nb\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\nb\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\tl"
${SetOutPath} "$INSTDIR\share\locale\tl\LC_MESSAGES"
${File} "mingw\share\locale\tl\LC_MESSAGES\" "glib20.mo"
${SetOutPath} "$INSTDIR\share\locale\nds"
${SetOutPath} "$INSTDIR\share\locale\nds\LC_MESSAGES"
${File} "mingw\share\locale\nds\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\nds\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\nds\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\nds\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\nn"
${SetOutPath} "$INSTDIR\share\locale\nn\LC_MESSAGES"
${File} "mingw\share\locale\nn\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\nn\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\nn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\nn\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\nn\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\el"
${SetOutPath} "$INSTDIR\share\locale\el\LC_MESSAGES"
${File} "mingw\share\locale\el\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\el\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\el\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\el\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\el\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\uk"
${SetOutPath} "$INSTDIR\share\locale\uk\LC_MESSAGES"
${File} "mingw\share\locale\uk\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\uk\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\uk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\uk\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\uk\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\lt"
${SetOutPath} "$INSTDIR\share\locale\lt\LC_MESSAGES"
${File} "mingw\share\locale\lt\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\lt\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\lt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\lt\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\lt\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\sr"
${SetOutPath} "$INSTDIR\share\locale\sr\LC_MESSAGES"
${File} "mingw\share\locale\sr\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\sr\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\sr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\sr\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\sr\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\dz"
${SetOutPath} "$INSTDIR\share\locale\dz\LC_MESSAGES"
${File} "mingw\share\locale\dz\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\dz\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\dz\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\dz\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\dz\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\hu"
${SetOutPath} "$INSTDIR\share\locale\hu\LC_MESSAGES"
${File} "mingw\share\locale\hu\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\hu\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\hu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\hu\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\hu\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\mi"
${SetOutPath} "$INSTDIR\share\locale\mi\LC_MESSAGES"
${File} "mingw\share\locale\mi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\mi\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\mi\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\en_GB"
${SetOutPath} "$INSTDIR\share\locale\en_GB\LC_MESSAGES"
${File} "mingw\share\locale\en_GB\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\en_GB\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\en_GB\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\en_GB\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\en_GB\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ang"
${SetOutPath} "$INSTDIR\share\locale\ang\LC_MESSAGES"
${File} "mingw\share\locale\ang\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ang\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ang\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\fr"
${SetOutPath} "$INSTDIR\share\locale\fr\LC_MESSAGES"
${File} "mingw\share\locale\fr\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\fr\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\fr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\fr\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\fr\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\he"
${SetOutPath} "$INSTDIR\share\locale\he\LC_MESSAGES"
${File} "mingw\share\locale\he\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\he\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\he\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\he\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\he\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\crh"
${SetOutPath} "$INSTDIR\share\locale\crh\LC_MESSAGES"
${File} "mingw\share\locale\crh\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\crh\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\crh\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ga"
${SetOutPath} "$INSTDIR\share\locale\ga\LC_MESSAGES"
${File} "mingw\share\locale\ga\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ga\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ga\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ga\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ga\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\az"
${SetOutPath} "$INSTDIR\share\locale\az\LC_MESSAGES"
${File} "mingw\share\locale\az\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\az\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\az\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\az\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\az\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\bn_IN"
${SetOutPath} "$INSTDIR\share\locale\bn_IN\LC_MESSAGES"
${File} "mingw\share\locale\bn_IN\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\bn_IN\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\bn_IN\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\bn_IN\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\bn_IN\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\kk"
${SetOutPath} "$INSTDIR\share\locale\kk\LC_MESSAGES"
${File} "mingw\share\locale\kk\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\kk\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\kk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\kk\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ku"
${SetOutPath} "$INSTDIR\share\locale\ku\LC_MESSAGES"
${File} "mingw\share\locale\ku\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ku\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ku\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ku\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ku\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\id"
${SetOutPath} "$INSTDIR\share\locale\id\LC_MESSAGES"
${File} "mingw\share\locale\id\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\id\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\id\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\id\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\id\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\yi"
${SetOutPath} "$INSTDIR\share\locale\yi\LC_MESSAGES"
${File} "mingw\share\locale\yi\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\yi\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\yi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\yi\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\yi\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ast"
${SetOutPath} "$INSTDIR\share\locale\ast\LC_MESSAGES"
${File} "mingw\share\locale\ast\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ast\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ast\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ast\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ast\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\ro"
${SetOutPath} "$INSTDIR\share\locale\ro\LC_MESSAGES"
${File} "mingw\share\locale\ro\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\ro\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\ro\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\ro\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\ro\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\nso"
${SetOutPath} "$INSTDIR\share\locale\nso\LC_MESSAGES"
${File} "mingw\share\locale\nso\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\nso\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\nso\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\locale\fi"
${SetOutPath} "$INSTDIR\share\locale\fi\LC_MESSAGES"
${File} "mingw\share\locale\fi\LC_MESSAGES\" "glib20.mo"
${File} "mingw\share\locale\fi\LC_MESSAGES\" "atk10.mo"
${File} "mingw\share\locale\fi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "mingw\share\locale\fi\LC_MESSAGES\" "gtk20.mo"
${File} "mingw\share\locale\fi\LC_MESSAGES\" "gdk-pixbuf.mo"
${SetOutPath} "$INSTDIR\share\themes"
${SetOutPath} "$INSTDIR\share\themes\MS-Windows"
${SetOutPath} "$INSTDIR\share\themes\MS-Windows\gtk-2.0"
${File} "mingw\share\themes\MS-Windows\gtk-2.0\" "gtkrc"

    SetShellVarContext all
    
    CreateDirectory "$SMPROGRAMS\GTK DBF Editor"
    ReadRegStr $0 HKU ".DEFAULT\Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders" "My Documents"
    SetOutPath "$0"
    CreateShortCut "$SMPROGRAMS\GTK DBF Editor\GTK DBF Editor.lnk" "$INSTDIR\bin\gtkdbfeditor.exe"
    CreateShortCut "$DESKTOP\GTK DBF Editor.lnk" "$INSTDIR\bin\gtkdbfeditor.exe"
    SetOutPath "$INSTDIR"

    ; write out uninstaller
    SetOverwrite on
    WriteUninstaller "$INSTDIR\${DIA_UNINST_EXE}"
    SetOverwrite off
    CreateShortCut "$SMPROGRAMS\GTK DBF Editor\Uninstall.lnk" "$INSTDIR\${DIA_UNINST_EXE}"
    
  done:
SectionEnd ; end of default Dia section
  
Section $(TRANSLATIONS_SECTION_TITLE) SecTranslations
  SetOverwrite On
  
  !ifdef DIA_INCLUDE_GTK
	${SetOutPath} "$INSTDIR\lib\locale\de"
	${SetOutPath} "$INSTDIR\lib\locale\de\LC_MESSAGES"
	${File} "..\..\..\lib\locale\de\LC_MESSAGES\" "atk10.mo"
	${SetOutPath} "$INSTDIR\share\locale\de"
	${SetOutPath} "$INSTDIR\share\locale\de\LC_MESSAGES"
	${File} "..\..\..\share\locale\de\LC_MESSAGES\" "glib20.mo"
	${File} "..\..\..\share\locale\de\LC_MESSAGES\" "gtk20-properties.mo"
	${File} "..\..\..\share\locale\de\LC_MESSAGES\" "gtk20.mo"
	${File} "..\..\..\share\locale\de\LC_MESSAGES\" "gtkdbfeditor.mo"
  !endif
  
SectionEnd

Section -closelogfile
 FileClose $UninstLog
 SetFileAttributes "$INSTDIR\${UninstLog}" READONLY|SYSTEM|HIDDEN
SectionEnd

;--------------------------------
;Uninstaller Section

Section Uninstall
  
  Call un.CheckUserInstallRights
  Pop $R0
  StrCmp $R0 "NONE" no_rights
  StrCmp $R0 "HKCU" try_hkcu try_hklm

  try_hkcu:
    ReadRegStr $R0 HKCU ${DIA_REG_KEY} ""
    StrCmp $R0 $INSTDIR 0 cant_uninstall
      ; HKCU install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKCU ${DIA_REG_KEY}
      DeleteRegKey HKCU "${DIA_UNINSTALL_KEY}"
      Goto cont_uninstall

  try_hklm:
    ReadRegStr $R0 HKLM ${DIA_REG_KEY} ""
    StrCmp $R0 $INSTDIR 0 try_hkcu
      ; HKLM install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKLM ${DIA_REG_KEY}
      DeleteRegKey HKLM "${DIA_UNINSTALL_KEY}"
      DeleteRegKey HKLM "${HKLM_APP_PATHS_KEY}"
      DeleteRegKey HKLM "${HKLM_CMD_PATHS_KEY}"
      ; Sets start menu and desktop scope to all users..
      SetShellVarContext "all"

  cont_uninstall:
    
    ; The WinPrefs plugin may have left this behind..
    DeleteRegValue HKCU "${DIA_STARTUP_RUN_KEY}" "Gtkdbfeditor"
    DeleteRegValue HKLM "${DIA_STARTUP_RUN_KEY}" "Gtkdbfeditor"
    ; Remove Language preference info
    DeleteRegKey HKCU ${DIA_REG_KEY} ;${MUI_LANGDLL_REGISTRY_ROOT} ${MUI_LANGDLL_REGISTRY_KEY}
    
    ; Can't uninstall if uninstall.log is missing!
 IfFileExists "$INSTDIR\${UninstLog}" +3
  MessageBox MB_OK|MB_ICONSTOP "${UninstLog} not found!"
  Goto no_uninstlog
 
 Push $R0
 SetFileAttributes "$INSTDIR\${UninstLog}" NORMAL
 FileOpen $UninstLog "$INSTDIR\${UninstLog}" r
 
 LoopRead:
  ClearErrors
   FileRead $UninstLog $R0
   IfErrors LoopDone
 
   Push $R0
    Call un.TrimNewLines
   Pop $R0
   IfFileExists "$R0\*.*" 0 +3
    RMDir $R0  #is dir
   Goto LoopRead
    Delete $R0 #is file
 
    Goto LoopRead
   LoopDone:
   FileClose $UninstLog
   Delete "$INSTDIR\${UninstLog}"
   Pop $R0
    Delete "$INSTDIR\${DIA_UNINST_EXE}"
    
    no_uninstlog:
    ; Shortcuts..
    Delete "$SMPROGRAMS\GTK DBF Editor\GTK DBF Editor.lnk"
    Delete "$SMPROGRAMS\GTK DBF Editor\Uninstall.lnk"
    RMDir "$SMPROGRAMS\GTK DBF Editor"
    Delete "$DESKTOP\GTK DBF Editor.lnk"
    
    IfSilent done
    MessageBox MB_YESNO|MB_ICONEXCLAMATION $(un.DIA_UNINSTALLATION_WARNING) IDNO done
    skip_warning:
    RMDir /r "$INSTDIR"
    
    Goto done

  cant_uninstall:
    IfSilent skip_mb
    MessageBox MB_OK $(un.DIA_UNINSTALL_ERROR_1) IDOK
    skip_mb:
    Quit

  no_rights:
    IfSilent skip_mb1
    MessageBox MB_OK $(un.DIA_UNINSTALL_ERROR_2) IDOK
    skip_mb1:
    Quit

  done:
SectionEnd ; end of uninstall section

;--------------------------------
;Descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecDia} \
	$(DIA_SECTION_DESCRIPTION)
!insertmacro MUI_DESCRIPTION_TEXT ${SecTranslations} \
  	$(TRANSLATIONS_SECTION_DESCRIPTION)	
!insertmacro MUI_DESCRIPTION_TEXT ${SecPython} \
        $(PYTHON_SECTION_DESCRIPTION)     

!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Functions

Function CheckUserInstallRights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1

	StrCmp $1 "Admin" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "Power" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "User" 0 +3
		StrCpy $1 "HKCU"
		Goto done
	StrCmp $1 "Guest" 0 +3
		StrCpy $1 "NONE"
		Goto done
	; Unknown error
	StrCpy $1 "NONE"
        Goto done

	Win9x:
		StrCpy $1 "HKLM"

	done:
        Push $1
FunctionEnd

Function un.CheckUserInstallRights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1

	StrCmp $1 "Admin" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "Power" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "User" 0 +3
		StrCpy $1 "HKCU"
		Goto done
	StrCmp $1 "Guest" 0 +3
		StrCpy $1 "NONE"
		Goto done
	; Unknown error
	StrCpy $1 "NONE"
        Goto done

	Win9x:
		StrCpy $1 "HKLM"

	done:
        Push $1
FunctionEnd

;
; Usage:
;   Push $0 ; Path string
;   Call VerifyDir
;   Pop $0 ; 0 - Bad path  1 - Good path
;
Function VerifyDir
  Pop $0
  Loop:
    IfFileExists $0 dir_exists
    StrCpy $1 $0 ; save last
    Push $0
    Call GetParent
    Pop $0
    StrLen $2 $0
    ; IfFileExists "C:" on xp returns true and on win2k returns false
    ; So we're done in such a case..
    StrCmp $2 "2" loop_done
    Goto Loop

  loop_done:
    StrCpy $1 "$0\diaFooB"
    ; Check if we can create dir on this drive..
    ClearErrors
    CreateDirectory $1
    IfErrors DirBad DirGood

  dir_exists:
    ClearErrors
    FileOpen $1 "$0\diafoo.bar" w
    IfErrors PathBad PathGood

    DirGood:
      RMDir $1
      Goto PathGood1

    DirBad:
      RMDir $1
      Goto PathBad1

    PathBad:
      FileClose $1
      Delete "$0\diafoo.bar"
      PathBad1:
      StrCpy $0 "0"
      Push $0
      Return

    PathGood:
      FileClose $1
      Delete "$0\diafoo.bar"
      PathGood1:
      StrCpy $0 "1"
      Push $0
FunctionEnd

Function .onVerifyInstDir
  Push $INSTDIR
  Call VerifyDir
  Pop $0
  StrCmp $0 "0" 0 dir_good
    Abort
  dir_good:
FunctionEnd

; GetParent
; input, top of stack  (e.g. C:\Program Files\Poop)
; output, top of stack (replaces, with e.g. C:\Program Files)
; modifies no other variables.
;
; Usage:
;   Push "C:\Program Files\Directory\Whatever"
;   Call GetParent
;   Pop $R0
;   ; at this point $R0 will equal "C:\Program Files\Directory"
Function GetParent
   Exch $0 ; old $0 is on top of stack
   Push $1
   Push $2
   StrCpy $1 -1
   loop:
     StrCpy $2 $0 1 $1
     StrCmp $2 "" exit
     StrCmp $2 "\" exit
     IntOp $1 $1 - 1
   Goto loop
   exit:
     StrCpy $0 $0 $1
     Pop $2
     Pop $1
     Exch $0 ; put $0 on top of stack, restore $0 to original value
FunctionEnd

!define SECTION_ENABLE   0xFFFFFFEF
Function .onInit
  StrCpy $name "GTK DBF ${GTKDBFEDITOR_VERSION}"
  !insertmacro MUI_LANGDLL_DISPLAY
  ClearErrors
  
  ; If install path was set on the command, use it.
  StrCmp $INSTDIR "" 0 instdir_done

  Call CheckUserInstallRights
  Pop $0

  StrCmp $0 "HKLM" 0 user_dir
    StrCpy $INSTDIR "$PROGRAMFILES\GTK DBF Editor"
    Goto instdir_done
  user_dir:
    StrCpy $2 "$SMPROGRAMS"
    Push $2
    Call GetParent
    Call GetParent
    Pop $2
    StrCpy $INSTDIR "$2\GTK DBF Editor"

  instdir_done:
FunctionEnd

Function un.TrimNewlines
   Exch $R0
   Push $R1
   Push $R2
   StrCpy $R1 0
 
 loop:
   IntOp $R1 $R1 - 1
   StrCpy $R2 $R0 1 $R1
   StrCmp $R2 "$\r" loop
   StrCmp $R2 "$\n" loop
   IntOp $R1 $R1 + 1
   IntCmp $R1 0 no_trim_needed
   StrCpy $R0 $R0 $R1
 
 no_trim_needed:
   Pop $R2
   Pop $R1
   Exch $R0
 FunctionEnd

; GetParameterValue
; Chris Morgan<cmorgan@alum.wpi.edu> 5/10/2004
; -Updated 4/7/2005 to add support for retrieving a command line switch
;  and additional documentation
;
; Searches the command line input, retrieved using GetParameters, for the
; value of an option given the option name.  If no option is found the
; default value is placed on the top of the stack upon function return.
;
; This function can also be used to detect the existence of just a
; command line switch like /OUTPUT  Pass the default and "OUTPUT"
; on the stack like normal.  An empty return string "" will indicate
; that the switch was found, the default value indicates that
; neither a parameter or switch was found.
;
; Inputs - Top of stack is default if parameter isn't found,
;  second in stack is parameter to search for, ex. "OUTPUT"
; Outputs - Top of the stack contains the value of this parameter
;  So if the command line contained /OUTPUT=somedirectory, "somedirectory"
;  will be on the top of the stack when this function returns
;
; Register usage
;$R0 - default return value if the parameter isn't found
;$R1 - input parameter, for example OUTPUT from the above example
;$R2 - the length of the search, this is the search parameter+2
;      as we have '/OUTPUT='
;$R3 - the command line string
;$R4 - result from StrStr calls
;$R5 - search for ' ' or '"'
 
Function GetParameterValue
  Exch $R0  ; get the top of the stack(default parameter) into R0
  Exch      ; exchange the top of the stack(default) with
            ; the second in the stack(parameter to search for)
  Exch $R1  ; get the top of the stack(search parameter) into $R1
 
  ;Preserve on the stack the registers used in this function
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  Strlen $R2 $R1+2    ; store the length of the search string into R2
 
  Call GetParameters  ; get the command line parameters
  Pop $R3             ; store the command line string in R3
 
  # search for quoted search string
  StrCpy $R5 '"'      ; later on we want to search for a open quote
  Push $R3            ; push the 'search in' string onto the stack
  Push '"/$R1='       ; push the 'search for'
  Call StrStr         ; search for the quoted parameter value
  Pop $R4
  StrCpy $R4 $R4 "" 1   ; skip over open quote character, "" means no maxlen
  StrCmp $R4 "" "" next ; if we didn't find an empty string go to next
 
  # search for non-quoted search string
  StrCpy $R5 ' '      ; later on we want to search for a space since we
                      ; didn't start with an open quote '"' we shouldn't
                      ; look for a close quote '"'
  Push $R3            ; push the command line back on the stack for searching
  Push '/$R1='        ; search for the non-quoted search string
  Call StrStr
  Pop $R4
 
  ; $R4 now contains the parameter string starting at the search string,
  ; if it was found
next:
  StrCmp $R4 "" check_for_switch ; if we didn't find anything then look for
                                 ; usage as a command line switch
  # copy the value after /$R1= by using StrCpy with an offset of $R2,
  # the length of '/OUTPUT='
  StrCpy $R0 $R4 "" $R2  ; copy commandline text beyond parameter into $R0
  # search for the next parameter so we can trim this extra text off
  Push $R0
  Push $R5            ; search for either the first space ' ', or the first
                      ; quote '"'
                      ; if we found '"/output' then we want to find the
                      ; ending ", as in '"/output=somevalue"'
                      ; if we found '/output' then we want to find the first
                      ; space after '/output=somevalue'
  Call StrStr         ; search for the next parameter
  Pop $R4
  StrCmp $R4 "" done  ; if 'somevalue' is missing, we are done
  StrLen $R4 $R4      ; get the length of 'somevalue' so we can copy this
                      ; text into our output buffer
  StrCpy $R0 $R0 -$R4 ; using the length of the string beyond the value,
                      ; copy only the value into $R0
  goto done           ; if we are in the parameter retrieval path skip over
                      ; the check for a command line switch
 
; See if the parameter was specified as a command line switch, like '/output'
check_for_switch:
  Push $R3            ; push the command line back on the stack for searching
  Push '/$R1'         ; search for the non-quoted search string
  Call StrStr
  Pop $R4
  StrCmp $R4 "" done  ; if we didn't find anything then use the default
  StrCpy $R0 ""       ; otherwise copy in an empty string since we found the
                      ; parameter, just didn't find a value
 
done:
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0 ; put the value in $R0 at the top of the stack
FunctionEnd

 ; GetParameters
 ; input, none
 ; output, top of stack (replaces, with e.g. whatever)
 ; modifies no other variables.
 
Function GetParameters
 
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
    StrCpy $R1 '"'
    Goto loop
  StrCpy $R1 " "
  
  loop:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 get
    StrCmp $R2 $R3 get
    Goto loop
  
  get:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 " " get
    StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
 
FunctionEnd

!define StrStr "!insertmacro StrStr"
 
!macro StrStr ResultVar String SubString
  Push `${String}`
  Push `${SubString}`
  Call StrStr
  Pop `${ResultVar}`
!macroend
 
Function StrStr
/*After this point:
  ------------------------------------------
  $R0 = SubString (input)
  $R1 = String (input)
  $R2 = SubStringLen (temp)
  $R3 = StrLen (temp)
  $R4 = StartCharPos (temp)
  $R5 = TempStr (temp)*/
 
  ;Get input from user
  Exch $R0
  Exch
  Exch $R1
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  ;Get "String" and "SubString" length
  StrLen $R2 $R0
  StrLen $R3 $R1
  ;Start "StartCharPos" counter
  StrCpy $R4 0
 
  ;Loop until "SubString" is found or "String" reaches its end
  loop:
    ;Remove everything before and after the searched part ("TempStr")
    StrCpy $R5 $R1 $R2 $R4
 
    ;Compare "TempStr" with "SubString"
    StrCmp $R5 $R0 done
    ;If not "SubString", this could be "String"'s end
    IntCmp $R4 $R3 done 0 done
    ;If not, continue the loop
    IntOp $R4 $R4 + 1
    Goto loop
  done:
 
/*After this point:
  ------------------------------------------
  $R0 = ResultVar (output)*/
 
  ;Remove part before "SubString" on "String" (if there has one)
  StrCpy $R0 $R1 `` $R4
 
  ;Return output to user
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd
