struct WIINFO {

  /*
   * widget Internal data.
   */
  int qua_dot[X_SIZE - 2];
  int mode;			/* 0=graph, 1=antenna */

  /*
   * configuration values.
   */
  int selected_tx_rate;		/* -t         */
  char desired_SSID[32];	/* -n         */
  char station_name[32];	/* -s         */
  int create_IBSS;		/* -c: 0 or 1 */
  char SSID_for_IBSS[32];	/* -q         */
  int port_type;		/* -p: 1 or 3 */
  int ap_density;		/* -a         */
  unsigned char MAC_addr[6];	/* -m         */
  int use_wep;			/* -e: 0 or 1 */
  char tx_enc_keys[4][32];	/* -k         */
  int rts_thresh;		/* -r         */
  int IBSS_channel;		/* -f         */
  int power_mgmt;		/* -P: 0 or 1 */
  int max_sleep;		/* -S         */
  int tx_enc_index;		/* -T: 14   */

  /*
   * presented values.
   */
  char serial_num[32];
  char current_SSID[32];
  unsigned char current_BSSID[6];
  int channel_list;
  int current_channel;
  int promisc_mode;		/* Not Yet */
  int actual_tx_rate;

};

int get_qua (char *ifname);
int get_actual_txrate (char *ifname);
int get_wi_info (char *ifname, struct wi_req * wreq);
void set_wi_info (char *ifname, struct wi_req * wreq);
