/*
 * Gladeκmain.cեǤ. ԽɬפǤ.
 * GladeϤΥե񤭤ޤ.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#ifdef HAVE_NET_IF_VAR_H
#include <net/if_var.h>
#endif
#ifdef HAVE_NET_IF_ETHER_H
#include <net/if_ether.h>
#else
#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>
#endif
#endif

#if defined(HAVE_DEV_PCMCIA_IF_WI_IEEE_H)
#include <dev/pcmcia/if_wi_ieee.h>
#elif defined(HAVE_MACHINE_IF_WAVELAN_IEEE_H)
#include <machine/if_wavelan_ieee.h>      
#elif defined(HAVE_DEV_IC_WI_IEEE_H)
#include <dev/ic/wi_ieee.h>
#endif
 
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "wiinfo.h"
#include "wm.h"

extern char *IF_NAME;
extern struct WIINFO wiinfo;
extern int dock;

void
usage (char *prog)
{
  fprintf (stderr, "%s [-i ifname]\n", prog);
  exit (1);
}

int
main (int argc, char *argv[])
{
  GtkWidget *window1;
  int i;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  /* */

  while ((i = getopt (argc, argv, "adhi:")) != -1) {
    switch (i) {
    case 'i':
      IF_NAME = optarg;
      break;
    case 'a':
      wiinfo.mode = 1;
      break;
    case 'd':
      dock = 1;
      break;
    case 'h':
      usage (argv[0]);
    default:
      exit (1);
    }
  }

  window1 = create_window1 ();
  gtk_widget_show (window1);

  wiinfo_new ();
  drawarea1_init (lookup_widget (window1, "drawingarea1"));

  if(dock){
    docking_init(window1);
  }

  gtk_timeout_add (1000, (GtkFunction) update_graph, window1);


  gtk_main ();
  return 0;
}
