/* greylisting-spp - A qmail-spp plugin implementing greylisting
 *
 * db-api.h
 *
 *  Copyright (C) 2004 Peter Conrad <conrad@tivano.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License (version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GL_DBAPI_H_
#define _GL_DBAPI_H_

/* Open files and allocate resources required for accessing the database */
extern void opendb(char *name);

/* Close all files and free other resources related to API functions, including
 * any static variables.
 */
extern void closedb();

/* Look up an entry in the database matching the given ip, sender and recipient.
 * Return -1 if no such entry exists (or an entry exists but has expired),
 * 0 if an entry exists but it is not yet confirmed and has not yet reached
 * min_wait,
 * 1 otherwise (i. e. the message is to be accepted).
 */
extern int find_entry(char *ip, char *sender, char *recipient);

/* Adds a new entry to the database with the given ip, sender and recipient,
 * the current time and the "not confirmed" flag.
 */
extern void add_entry(char *ip, char *sender, char *recipient);

/* Update the entry found by the previous call to find_entry() to contain the
 * current timestamp and the "confirmed" flag.
 */
extern void update_entry();

/* Delete the entry found by the previous call to find_entry() from the
 * database.
 */
extern void delete_entry();

/* Will be set to argv[0], should be used in error messages */
extern char *progname;

/* Entries with the "not confirmed" flag set will not be accepted before at
 * least min_reject seconds have gone by after their creation (find_entry must
 * return 0 for such entries).
 */
extern int min_reject;

/* Entries with the "not confirmed" flag set will expire no earlier than
 * max_wait seconds after their timestamp (set at the time when the entry was
 * added).
 */
extern int max_wait;

/* Entries with the "confirmed" flag set will expire no earlier than accept_good
 * seconds after their timestamp (set by an earlier call to update()).
 */
extern int accept_good;

#endif /* _GL_DBAPI_H_ */

/* Do not change the following line:
 * arch-tag: 52236dc3-76e3-4b5a-ab9b-bc2570f53520
 */
