%define QMAIL_DIR /var/qmail

Summary: "Greylisting" plugin for qmail-smtp
Name: greylisting-spp
Version: 1.1
Release: 1
License: GPLv2
Group: Productivity/Networking/Email/Servers
URL: http://www.unix-ag.uni-kl.de/~conrad/greylisting/
Source: http://www.unix-ag.uni-kl.de/~conrad/greylisting/greylisting-spp-%{version}.tar.gz
Requires: qmail
BuildRoot: %{_tmppath}/%{name}-%{version}-build
%description
"Greylisting" is a technique to filter certain malware (SPAM and email worms)
at the SMTP level. See http://greylisting.org/ for a better description..
This package implements Greylisting for D. J. Bernstein's "qmail" MTA 
(http://qmail.org/ ). It requires qmail to be compiled with the 
smtp-plugin-patch (http://qmail-spp.sourceforge.net/ ), version 0.4 or later,
hence the name.

%prep
%setup

%build
make CFLAGS="%{optflags}" LDFLAGS="%{optflags}" %{?_smp_mflags}

%install
mkdir -p "%{buildroot}%{QMAIL_DIR}/plugins"
mkdir -p "%{buildroot}%{QMAIL_DIR}/greylisting"
install -m 0755 ,,build/src/greylisting-spp "%{buildroot}%{QMAIL_DIR}/plugins"

%post
cd "%{QMAIL_DIR}/control"
if [ "$1" -ge 1 -a `grep -c plugins/greylisting-spp smtpplugins` -eq 0 ]; then
    echo "Trying to insert plugin into %{QMAIL_DIR}/control/smtpplugins..."
    if grep '^\[mail\]$' smtpplugins >/dev/null; then
	i=1
	while [ `head -$i smtpplugins | grep -c '^\[mail\]$'` -lt 1 ]; do
	    i=$(($i + 1))
	done
	head -$i smtpplugins >smtpplugins.new
	tail +$(($i + 1)) smtpplugins >>smtpplugins.new && \
	  mv smtpplugins.new smtpplugins
    else
	echo "[mail]" >>smtpplugins
    fi
    if grep '^\[rcpt\]$' smtpplugins >/dev/null; then
	i=1
	while [ `head -$i smtpplugins | grep -c '^\[rcpt\]$'` -lt 1 ]; do
	    i=$(($i + 1))
	done
	head -$i smtpplugins >smtpplugins.new
	echo "plugins/greylisting-spp" >>smtpplugins.new
	tail +$(($i + 1)) smtpplugins >>smtpplugins.new && \
	  mv smtpplugins.new smtpplugins
    else
	echo "[rcpt]" >>smtpplugins
	echo "plugins/greylisting-spp" >>smtpplugins
    fi
    echo "Don't forget to set the required environment variables"
    echo "when invoking qmail-smtpd."
    echo "And think about whitelisting some addresses, see %{_docdir}/%{name}."
fi

%preun
if [ "$1" = 0 ]; then
    cd "%{QMAIL_DIR}/control"
    if [ -r smtpplugins ]; then
	echo "Trying to remove greylisting-spp from %{QMAIL_DIR}/control/smtpplugins..."
	grep -vE '^#*plugins/greylisting-spp$' smtpplugins >smtpplugins.new && \
	  mv smtpplugins.new smtpplugins
    fi
fi

%clean
[ "%{buildroot}" = "/" ] || rm -rf "%{buildroot}"

%files
%defattr(-,root,qmail,-)
%doc doc/* ,,build/doc/whitelist.tcpserver
%{QMAIL_DIR}/plugins/greylisting-spp
%dir %attr(0700,qmaild,qmail) %{QMAIL_DIR}/greylisting

%changelog
* Sat Jun 18 2011 - Peter Conrad <conrad@quisquis.de>
- Upgrade to version 1.1
* Sun Apr 27 2008 - Peter Conrad <conrad@quisquis.de>
- Upgrade to bugfix version 1.0.1
* Sun Dec  2 2007 - Peter Conrad <conrad@quisquis.de>
- Added URL header
- Added source URL
* Thu Nov 15 2007 - Peter Conrad <conrad@quisquis.de>
- Turned Copyright header into License
- Improved %preun-script
* Thu Feb 03 2005 - conrad@tivano.de
- Documented requirement qmail-spp version 0.40 or later
- Bumped version number
* Wed Sep 29 2004 - conrad@tivano.de
- Really fixed %post
* Mon Sep 27 2004 - conrad@tivano.de
- Fixed %post and %preun scripts
* Wed Sep 08 2004 - conrad@tivano.de
- Bumped version number
- Added database directory
* Tue Aug 24 2004 - conrad@tivano.de
- Created spec file

# Do not change the following line:
# arch-tag: 26dd308a-26de-416a-ab01-c813f67a42e6

