/* Signal Processing Main - Header

 * Copyright (C) 1998 J.A. Bezemer
 *
 * Licensed under the terms of the GNU General Public License.
 * ABSOLUTELY NO WARRANTY.
 * See the file `COPYING' in this directory.
 */

#ifndef HAVE_SIGNPROC_MAIN_H
#define HAVE_SIGNPROC_MAIN_H

#ifndef SWIG
#include "scrollmenu.h"
#endif

#define SIGNPR_PROCESSING_HEADERTEXT "Signal Processing"

typedef struct
  {
    long begin;
    long end;
  }
beginendsample_t;

#ifndef SWIG
int signproc_get_options (char *startdir, char *infilename, char *outfilename,
			  scrollmenu_t * filtlist, int *filtnumbers,
			  char **helptexts, scrollmenu_t * selectedfilts,
			  int *usetracktimes, int *usebeginendtime,
			  double *begintime, double *endtime);
#endif

int load_track_times (char *filename, beginendsample_t * tracktimes,
		      int *number_of_tracks);

#ifndef SWIG
void signproc_main (char *startdir);
#else
void signproc_main (char *infilename, char *outfilename, int number_of_filters, int *filter_type);
#endif


#endif /* HAVE_SIGNPROC_MAIN_H */
