// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by lister-gen. DO NOT EDIT.

package v0alpha1

import (
	v0alpha1 "github.com/grafana/grafana/pkg/apis/service/v0alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ExternalNameLister helps list ExternalNames.
// All objects returned here must be treated as read-only.
type ExternalNameLister interface {
	// List lists all ExternalNames in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v0alpha1.ExternalName, err error)
	// ExternalNames returns an object that can list and get ExternalNames.
	ExternalNames(namespace string) ExternalNameNamespaceLister
	ExternalNameListerExpansion
}

// externalNameLister implements the ExternalNameLister interface.
type externalNameLister struct {
	indexer cache.Indexer
}

// NewExternalNameLister returns a new ExternalNameLister.
func NewExternalNameLister(indexer cache.Indexer) ExternalNameLister {
	return &externalNameLister{indexer: indexer}
}

// List lists all ExternalNames in the indexer.
func (s *externalNameLister) List(selector labels.Selector) (ret []*v0alpha1.ExternalName, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v0alpha1.ExternalName))
	})
	return ret, err
}

// ExternalNames returns an object that can list and get ExternalNames.
func (s *externalNameLister) ExternalNames(namespace string) ExternalNameNamespaceLister {
	return externalNameNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ExternalNameNamespaceLister helps list and get ExternalNames.
// All objects returned here must be treated as read-only.
type ExternalNameNamespaceLister interface {
	// List lists all ExternalNames in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v0alpha1.ExternalName, err error)
	// Get retrieves the ExternalName from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v0alpha1.ExternalName, error)
	ExternalNameNamespaceListerExpansion
}

// externalNameNamespaceLister implements the ExternalNameNamespaceLister
// interface.
type externalNameNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ExternalNames in the indexer for a given namespace.
func (s externalNameNamespaceLister) List(selector labels.Selector) (ret []*v0alpha1.ExternalName, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v0alpha1.ExternalName))
	})
	return ret, err
}

// Get retrieves the ExternalName from the indexer for a given namespace and name.
func (s externalNameNamespaceLister) Get(name string) (*v0alpha1.ExternalName, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v0alpha1.Resource("externalname"), name)
	}
	return obj.(*v0alpha1.ExternalName), nil
}
