---
keywords:
  - grafana
  - plugins
  - plugin
  - angular
  - deprecation
  - migration
labels:
  products:
    - enterprise
    - oss
title: Plugins using AngularJS
description: An annotated list of Grafana plugins using AngularJS.
---

# Plugins using AngularJS

The use of AngularJS in Grafana has been [deprecated]({{< relref "../angular_deprecation" >}}) in favor of React. Support for AngularJS will be turned off by default in Grafana 11.

This page explains how Grafana users might be impacted by the removal of Angular support based on plugins dependent on this legacy framework. You will also see if there is a migration option available for a given plugin.

{{% admonition type="note" %}}
We are greatly appreciative of the developers who have contributed plugins to the Grafana ecosystem. Guidance on migrating a plugin to React can be found in our [migration guide](/developers/plugin-tools/migration-guides/migrate-angularjs-to-react).
{{% /admonition %}}

## What should I do with the list of AngularJS plugins?

Refer to the [table below](#angularjs-based-plugins) and take the appropriate action for you.

- Consider the advice on whether to update, migrate to a listed alternative, or explore the Grafana plugins [catalog](/grafana/plugins) to find the most suitable option for your use case.
- Use our [detect-angular-dashboards](https://github.com/grafana/detect-angular-dashboards) open source tooling to list dashboards which have a dependency on Angular plugins.
- Check your Grafana instances for usage of these plugins. Refer to the documentation on [browsing installed plugins]({{< relref "../../administration/plugin-management/#browse-plugins" >}}).
- Customers of Grafana Enterprise and users of Grafana Cloud can also leverage [usage insights]({{< relref "../../dashboards/assess-dashboard-usage/" >}}) to prioritize any migration efforts.
- Review the plugin source repositories to add your support to any migration issues or consider forking the repo.

{{% admonition type="note" %}}
If you want to add any specific migration guidance for your plugin here or update our assessment, please open a PR by clicking **Suggest an edit** at the bottom of this page.
{{% /admonition %}}

## Private plugins

Grafana OSS and Grafana Enterprise support the creation of private plugins for use on local instances. These plugins may have a dependency on AngularJS and require an update.

The `detect-angular-dashboards` tool listed above will include private plugins in its report **if the Grafana version is v10.1.0 or later**.

Additionally, warning icons and messages will be displayed when browsing the catalog via **Administration** > **Plugins and Data** > **Plugins** in your local instance.

## Automatic migration of plugins

Certain legacy Grafana panel plugins automatically update to their React-based replacements when Angular support is disabled. This migration is usually available within the panel options, as shown in the screenshot below for World Map. Automatic migration can be triggered by setting the feature toggle `autoMigrateOldPanels` to `true`.

Automatic migration is supported for the plugins shown in the following table. Each of the target plugins are included in Grafana as Core plugins which don't require installation.

| Plugin      | Migration target |
| ----------- | ---------------- |
| Graph (old) | Time Series      |
| Singlestat  | Stat             |
| Stat (old)  | Stat             |
| Table (old) | Table            |
| Worldmap    | Geomap           |

A dashboard must still be saved with the new plugin ID to persist the change.

# AngularJS-based plugins

This table lists plugins which we have detected as having a dependency on AngularJS. For alternatives, consider included [Visualizations]({{< relref "../../panels-visualizations/visualizations" >}}) and [Data sources]({{< relref "../../datasources" >}}), as well as external plugins from the [catalog](/grafana/plugins).

| Plugin ID                                       | Name                                | Action                                                                                                                                                                                                                                            |
| ----------------------------------------------- | ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| grafana-worldmap-panel                          | Worldmap Panel                      | Migrate - [Geomap]({{< relref "../../panels-visualizations/visualizations/geomap" >}}) (core) replaced Worldmap - Note this should migrate when Angular is disabled.                                                                              |
| natel-discrete-panel                            | Discrete                            | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| vonage-status-panel                             | Status Panel                        | Migrate - Consider [Stat]({{< relref "../../panels-visualizations/visualizations/stat" >}}) (core) or [Polystat](https://grafana.com/grafana/plugins/grafana-polystat-panel/) as potential alternatives.                                          |
| grafana-simple-json-datasource                  | SimpleJson                          | Migrate - Consider [Infinity](https://grafana.com/grafana/plugins/yesoreyeram-infinity-datasource/) as a potential alternative.                                                                                                                   |
| natel-plotly-panel                              | Plotly                              | Migrate - Consider alternative [nline-plotlyjs-panel](https://grafana.com/grafana/plugins/nline-plotlyjs-panel/) plugin.                                                                                                                          |
| agenty-flowcharting-panel                       | FlowCharting                        | Migrate - Consider [Canvas]({{< relref "../../panels-visualizations/visualizations/canvas" >}}) (core) or [Diagram](https://grafana.com/grafana/plugins/jdbranham-diagram-panel/) as potential alternatives.                                      |
| camptocamp-prometheus-alertmanager-datasource   | Prometheus AlertManager             | Update - Note the minimum version for React is 2.0.0.                                                                                                                                                                                             |
| briangann-gauge-panel                           | D3 Gauge                            | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| yesoreyeram-boomtable-panel                     | Boom Table                          | Migrate - Consider [Table]({{< relref "../../panels-visualizations/visualizations/table" >}}) (core) and [transformations]({{< relref "../../panels-visualizations/query-transform-data/transform-data/" >}}) as appropriate.                     |
| briangann-datatable-panel                       | Datatable Panel                     | Wait - New version with React migration is planned.                                                                                                                                                                                               |
| flant-statusmap-panel                           | Statusmap                           | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| michaeldmoore-multistat-panel                   | Multistat                           | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| pr0ps-trackmap-panel                            | TrackMap                            | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| snuids-trafficlights-panel                      | Traffic Lights                      | Migrate - Consider [Traffic Light](https://grafana.com/grafana/plugins/heywesty-trafficlight-panel/) as a potential alternative.                                                                                                                  |
| vertamedia-clickhouse-datasource                | Altinity plugin for ClickHouse      | Update - Note the minimum version for React is 3.0.0.                                                                                                                                                                                             |
| petrslavotinek-carpetplot-panel                 | Carpet plot                         | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| ryantxu-ajax-panel                              | AJAX                                | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| michaeldmoore-annunciator-panel                 | Annunciator                         | Migrate - Consider [Stat]({{< relref "../../panels-visualizations/visualizations/stat" >}}) (core).                                                                                                                                               |
| marcuscalidus-svg-panel                         | SVG                                 | Migrate - Consider alternatives such as [Canvas]({{< relref "../../panels-visualizations/visualizations/canvas" >}}) (core), [Colored SVG](https://grafana.com/grafana/plugins/snuids-svg-panel/), or others.                                     |
| neocat-cal-heatmap-panel                        | Cal-HeatMap                         | Migrate - Consider [Heatmap]({{< relref "../../panels-visualizations/visualizations/heatmap" >}}) (core) visualization.                                                                                                                           |
| blackmirror1-singlestat-math-panel              | Singlestat Math                     | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| scadavis-synoptic-panel                         | SCADAvis Synoptic Panel             | Update - Note the minimum version for React is 2.0.                                                                                                                                                                                               |
| farski-blendstat-panel                          | Blendstat                           | Migrate - Consider [Stat]({{< relref "../../panels-visualizations/visualizations/stat" >}}) (core) and [transformations]({{< relref "../../panels-visualizations/query-transform-data/transform-data/" >}}) as appropriate.                       |
| savantly-heatmap-panel                          | Heatmap                             | Migrate - Consider [Heatmap]({{< relref "../../panels-visualizations/visualizations/heatmap" >}}) (core) visualization.                                                                                                                           |
| mtanda-histogram-panel                          | Histogram                           | Migrate - Consider included [Histogram]({{< relref "../../panels-visualizations/visualizations/histogram" >}}) visualization.                                                                                                                     |
| snuids-radar-panel                              | Radar Graph                         | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| fatcloud-windrose-panel                         | WindRose                            | Migrate - Consider alternative [Operator Windrose](https://grafana.com/grafana/plugins/operato-windrose-panel/) plugin.                                                                                                                           |
| bessler-pictureit-panel                         | PictureIt                           | Migrate - Consider alternative [ePict](https://grafana.com/grafana/plugins/larona-epict-panel/) plugin.                                                                                                                                           |
| digrich-bubblechart-panel                       | Bubble Chart                        | Update - Note the minimum version for React is 2.0.1. We recommend the latest.                                                                                                                                                                    |
| corpglory-progresslist-panel                    | Progress List                       | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| aidanmountford-html-panel                       | HTML                                | Migrate - Consider alternatives such as [Text]({{< relref "../../panels-visualizations/visualizations/text" >}}) (core), [HTML](https://grafana.com/grafana/plugins/gapit-htmlgraphics-panel), or others.                                         |
| fifemon-graphql-datasource                      | GraphQL Data Source                 | Wait - Removal of AngularJS is planned. Consider [Infinity](https://grafana.com/grafana/plugins/yesoreyeram-infinity-datasource/) plugin as alternative.                                                                                          |
| goshposh-metaqueries-datasource                 | MetaQueries                         | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| mxswat-separator-panel                          | Separator                           | Migrate - Consider alternative [Text]({{< relref "../../panels-visualizations/visualizations/text" >}}) panel (core) which can be empty and used as a separator.                                                                                  |
| natel-influx-admin-panel                        | Influx Admin                        | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| doitintl-bigquery-datasource                    | Google BigQuery                     | Migrate - Consider [Grafana Big Query](https://grafana.com/grafana/plugins/grafana-bigquery-datasource/) plugin.                                                                                                                                  |
| satellogic-3d-globe-panel                       | 3D Globe Panel                      | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| foursquare-clouderamanager-datasource           | Cloudera Manager                    | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| grafana-splunk-datasource                       | Splunk                              | Update - Note the minimum version for React is 4.1.0. We recommend the latest.                                                                                                                                                                    |
| grafana-singlestat-panel                        | Singlestat                          | Migrate - Consider [Stat]({{< relref "../../panels-visualizations/visualizations/stat" >}}) panel (core).                                                                                                                                         |
| blackmirror1-statusbygroup-panel                | Status By Group Panel               | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| novalabs-annotations-panel                      | Annotation Panel                    | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| jasonlashua-prtg-datasource                     | PRTG                                | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| ryantxu-annolist-panel                          | Annotation List                     | Migrate - Consider [annotations list]({{< relref "../../panels-visualizations/visualizations/annotations" >}}) (core).                                                                                                                            |
| cloudflare-app                                  | Cloudflare Grafana App              | Migrate - Consider using the [Cloudflare Dashboard](https://dash.cloudflare.com/?to=/:account/:zone/analytics/dns) or [DNS Analytics API](https://developers.cloudflare.com/api/operations/dns-analytics-table).                                  |
| smartmakers-trafficlight-panel                  | TrafficLight                        | Migrate - Consider [Traffic Light](https://grafana.com/grafana/plugins/heywesty-trafficlight-panel/) as a potential alternative.                                                                                                                  |
| zuburqan-parity-report-panel                    | Parity Report                       | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| citilogics-geoloop-panel                        | GeoLoop                             | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| xginn8-pagerduty-datasource                     | Pagerduty                           | Wait - We are developing an Enterprise plugin for Pagerduty targeted for availability in Q1 2024. Note that all roadmap items are subject to change.                                                                                              |
| gretamosa-topology-panel                        | Topology Panel                      | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| fzakaria-simple-annotations-datasource          | Simple Annotations                  | Migrate - Check for annotations support within your data sources to remove dependency on this plugin.                                                                                                                                             |
| oci-metrics-datasource                          | Oracle Cloud Infrastructure Metrics | Update - Note the minimum version for React is 5.0.0.                                                                                                                                                                                             |
| abhisant-druid-datasource                       | Druid                               | Migrate - Migrate to replacement [Druid](https://grafana.com/grafana/plugins/grafadruid-druid-datasource/) plugin.                                                                                                                                |
| devopsprodigy-kubegraf-app                      | DevOpsProdigy KubeGraf              | Migrate - Consider [Grafana Kubernetes Monitoring](https://grafana.com/solutions/kubernetes/) (Grafana Cloud only).                                                                                                                               |
| mtanda-heatmap-epoch-panel                      | HeatmapEpoch                        | Migrate - Consider [Heatmap]({{< relref "../../panels-visualizations/visualizations/heatmap" >}}) (core) visualization.                                                                                                                           |
| alexandra-trackmap-panel                        | Track Map                           | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| gnocchixyz-gnocchi-datasource                   | Gnocchi                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| tencentcloud-monitor-app                        | Tencent Cloud Monitor               | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| andig-darksky-datasource                        | DarkSky                             | Remove - Note that support for the DarkSky API was ended by Apple in March 2023.                                                                                                                                                                  |
| mtanda-google-calendar-datasource               | GoogleCalendar                      | Wait - Migration to React is planned.                                                                                                                                                                                                             |
| ntop-ntopng-datasource                          | ntopng                              | Migrate - Consider [InfluxDB]({{< relref "../../datasources/influxdb/" >}}) (core), with additional guidance available [here](https://www.ntop.org/guides/ntopng/basic_concepts/timeseries.html#influxdb-driver).                                 |
| ayoungprogrammer-finance-datasource             | Finance                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| grafana-kairosdb-datasource                     | KairosDB                            | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| fastweb-openfalcon-datasource                   | Open-Falcon                         | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| praj-ams-datasource                             | Ambari Metrics                      | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| monasca-datasource                              | Monasca                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| grafana-strava-datasource                       | Strava                              | Update - Note the minimum version for React is 1.6.0. We recommend the latest.                                                                                                                                                                    |
| gridprotectionalliance-osisoftpi-datasource     | OSIsoft-PI                          | Update - Note the minimum version for React is 4.0.0. We recommend the latest.                                                                                                                                                                    |
| monitoringartist-monitoringart-datasource       | Monitoring Art                      | Migrate - Browse included visualizations and plugins catalog for potential alternatives.                                                                                                                                                          |
| hawkular-datasource                             | Hawkular                            | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| ovh-warp10-datasource                           | Warp 10                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| natel-usgs-datasource                           | USGS Water Services                 | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| radensolutions-netxms-datasource                | NetXMS                              | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| ibm-apm-datasource                              | IBM APM                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| cognitedata-datasource                          | Cognite Data Fusion                 | Update - Note the minimum version for React is 4.0.0. We recommend the latest.                                                                                                                                                                    |
| linksmart-sensorthings-datasource               | LinkSmart SensorThings              | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| pue-solr-datasource                             | Solr                                | Migrate - Consider this [guidance](https://solr.apache.org/guide/solr/latest/deployment-guide/monitoring-with-prometheus-and-grafana.html) on using solr-exporter for prometheus.                                                                 |
| paytm-kapacitor-datasource                      | KapacitorSimpleJson                 | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| oci-logs-datasource                             | Oracle Cloud Infrastructure Logs    | Update - Note the minimum version for React is 4.0.0.                                                                                                                                                                                             |
| gridprotectionalliance-openhistorian-datasource | openHistorian                       | Wait - Note that new version with React migration is planned.                                                                                                                                                                                     |
| devicehive-devicehive-datasource                | DeviceHive                          | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| rackerlabs-blueflood-datasource                 | Blueflood                           | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| udoprog-heroic-datasource                       | Heroic                              | Migrate - Note that Heroic DB has been discontinued.                                                                                                                                                                                              |
| akumuli-datasource                              | Akumuli                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| bmchelix-ade-datasource                         | BMC Helix                           | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| sidewinder-datasource                           | Sidewinder                          | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| linksmart-hds-datasource                        | LinkSmart HDS Datasource            | Migrate - browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| skydive-datasource                              | Skydive                             | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| quasardb-datasource                             | QuasarDB                            | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| spotify-heroic-datasource                       | Heroic                              | Migrate - Note that Heroic DB has been discontinued.                                                                                                                                                                                              |
| grafana-es-open-distro-datasource               | Open Distro for Elasticsearch       | Migrate - Note that [OpenSearch](https://grafana.com/grafana/plugins/grafana-opensearch-datasource/) replaced Open Distro for Elasticseach.                                                                                                       |
| humio-datasource                                | Humio                               | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| yeya24-chaosmesh-datasource                     | Chaos Mesh                          | Migrate - Note that plugin was replaced by [chaosmeshorg-datasource](https://grafana.com/grafana/plugins/chaosmeshorg-datasource/).                                                                                                               |
| kentik-connect-app                              | Kentik Connect Pro                  | Update - Note the minimum version for React is 1.7.0.                                                                                                                                                                                             |
| chaosmeshorg-datasource                         | Chaos Mesh                          | Update - Note the minimum version for React is 3.0.0.                                                                                                                                                                                             |
| aquaqanalytics-kdbadaptor-datasource            | kdb+                                | Migrate - Note that [kdb+ backend](https://grafana.com/grafana/plugins/aquaqanalytics-kdbbackend-datasource) replaced kdb.+.                                                                                                                      |
| alexanderzobnin-zabbix-app                      | Zabbix                              | Update - Note the minimum version for React is 4.3.0. We recommend the latest. Recently brought under Grafana signature.                                                                                                                          |
| bosun-app                                       | Bosun                               | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| belugacdn-app                                   | BelugaCDN                           | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| grafana-azure-data-explorer-datasource          | Azure Data Explorer Datasource      | Update - The minimum supported version is 3.5.1. We recommend the latest.                                                                                                                                                                         |
| ddurieux-glpi-app                               | glpi                                | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| fetzerch-sunandmoon-datasource                  | Sun and Moon                        | Update - Note the minimum version for React is 0.3.0.                                                                                                                                                                                             |
| grafana-clock-panel                             | Clock                               | Update - Note the minimum version for React is 1.1.0. We recommend the latest.                                                                                                                                                                    |
| grafana-github-datasource                       | GitHub                              | Update - Note the minimum version for React is 1.3.3. We recommend the latest.                                                                                                                                                                    |
| grafana-datadog-datasource                      | Datadog                             | Update - Note the minimum version for React is 3.0.0. We recommend the latest.                                                                                                                                                                    |
| grafana-gitlab-datasource                       | Gitlab                              | Update - Note the minimum version for React is 1.1.0. We recommend the latest.                                                                                                                                                                    |
| grafana-iot-twinmaker-app                       | AWS IoT TwinMaker App               | Update - Note the minimum version for React is 1.6.3. We recommend the latest.                                                                                                                                                                    |
| grafana-newrelic-datasource                     | New Relic                           | Update - Note the minimum version for React is 3.0.0. We recommend the latest.                                                                                                                                                                    |
| grafana-opensearch-datasource                   | Opensearch                          | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| grafana-oracle-datasource                       | Oracle                              | Update - Note the minimum version for React is 2.0.6. We recommend the latest.                                                                                                                                                                    |
| grafana-piechart-panel                          | Pie Chart                           | Migrate - Note that [Pie Chart]({{< relref "../../panels-visualizations/visualizations/pie-chart" >}}) (core) replaced Pie Chart.                                                                                                                 |
| grafana-polystat-panel                          | Polystat                            | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| grafana-servicenow-datasource                   | ServiceNow                          | Update - Note the minimum version for React is 2.0.2. We recommend the latest.                                                                                                                                                                    |
| grafana-synthetic-monitoring-app                | Synthetic Monitoring                | Update - Note the minimum version for React is 0.7.3. We recommend the latest.                                                                                                                                                                    |
| grafana-wavefront-datasource                    | Wavefront                           | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| hadesarchitect-cassandra-datasource             | Apache Cassandra                    | Update - Note the minimum version for React is 2.1.1. We recommend the latest.                                                                                                                                                                    |
| instana-datasource                              | Instana                             | Update - Note the minimum version for React is 3.0.0. We recommend the latest.                                                                                                                                                                    |
| jdbranham-diagram-panel                         | Diagram                             | Update - Note the minimum version for React is 1.7.1. We recommend the latest.                                                                                                                                                                    |
| larona-epict-panel                              | ePict                               | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| moogsoft-aiops-app                              | Moogsoft AIOps                      | Update - Note the minimum version for React is 9.0.0.                                                                                                                                                                                             |
| opennms-helm-app                                | OpenNMS Helm                        | Migrate - Note that [OpenNMS Plugin for Grafana](https://grafana.com/grafana/plugins/opennms-opennms-app/) replaced OpenNMS Helm.                                                                                                                 |
| percona-percona-app                             | Percona                             | Migrate - Consider use of [Percona dashboards](https://github.com/percona/grafana-dashboards/).                                                                                                                                                   |
| novatec-sdg-panel                               | Service Dependency Graph            | Update - Note the minimum version for React is 4.0.3.                                                                                                                                                                                             |
| pierosavi-imageit-panel                         | ImageIt                             | Migrate - Consider [ePict](https://grafana.com/grafana/plugins/larona-epict-panel/) or browse plugins catalog for potential alternatives.                                                                                                         |
| redis-app                                       | Redis Application                   | Update - Note the minimum version for React is 1.2.0. We recommend the latest.                                                                                                                                                                    |
| sbueringer-consul-datasource                    | Consul                              | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| simpod-json-datasource                          | JSON                                | Update - Note the minimum version for React is 0.3.0. We recommend the latest.                                                                                                                                                                    |
| singlestat                                      | Singlestat                          | Migrate - Note that [Stat]({{< relref "../../panels-visualizations/visualizations/stat" >}}) (core) replaced Singlestat.                                                                                                                          |
| sni-pnp-datasource                              | PNP                                 | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| sni-thruk-datasource                            | Thruk                               | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| stagemonitor-elasticsearch-app                  | stagemonitor Elasticsearch          | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| tdengine-datasource                             | TDengine Datasource                 | Update - Note the minimum version for React is 3.3.0. We recommend the latest.                                                                                                                                                                    |
| vertica-grafana-datasource                      | Vertica                             | Update - Note the minimum version for React is 2.0.0. We recommend the latest.                                                                                                                                                                    |
| voxter-app                                      | Voxter VoIP Platform Metrics        | Migrate - Browse included data sources and plugins catalog for potential alternatives.                                                                                                                                                            |
| graph                                           | Graph (old)                         | Migrate - Note that this is replaced by [Time Series]({{< relref "../../panels-visualizations/visualizations/time-series" >}}) (core) - This plugin should migrate when Angular is disabled. Also consider Bar Chart or Histogram if appropriate. |
| table-old                                       | Table (old)                         | Migrate - Note that this is replaced by [Table]({{< relref "../../panels-visualizations/visualizations/table" >}}) (core) - This plugin should migrate when AngularJS is disabled.                                                                |
| shorelinesoftware-shoreline-datasource          | Shoreline Data Source               | Update - Note the minimum version for React is 1.2.1. We recommend the latest.                                                                                                                                                                    |
