import { uniqueId } from 'lodash';
import React__default, { PureComponent } from 'react';
import { Icon } from '../../../Icon/Icon.js';
import { Tooltip } from '../../../Tooltip/Tooltip.js';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class Switch extends PureComponent {
  constructor() {
    super(...arguments);
    __publicField(this, "state", {
      id: uniqueId()
    });
    __publicField(this, "internalOnChange", (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    });
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      tooltip,
      tooltipPlacement
    } = this.props;
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = `gf-form-switch ${switchClass} ${transparent ? "gf-form-switch--transparent" : ""}`;
    return /* @__PURE__ */ React__default.createElement("div", { className: "gf-form-switch-container-react" }, /* @__PURE__ */ React__default.createElement("label", { htmlFor: labelId, className: `gf-form gf-form-switch-container ${className || ""}` }, label && /* @__PURE__ */ React__default.createElement("div", { className: labelClassName }, label, tooltip && /* @__PURE__ */ React__default.createElement(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default.createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }))), /* @__PURE__ */ React__default.createElement("div", { className: switchClassName }, /* @__PURE__ */ React__default.createElement(
      "input",
      {
        disabled,
        id: labelId,
        type: "checkbox",
        checked,
        onChange: this.internalOnChange
      }
    ), /* @__PURE__ */ React__default.createElement("span", { className: "gf-form-switch__slider" }))));
  }
}

export { Switch };
//# sourceMappingURL=Switch.js.map
