/*
 * Capture data from a GPS35.
 * 
 * Sending a HUP signal will cause a send ephemeris command to be
 * sent to the GPS35.
 * 
 * TODO: get ephemeris every x seconds. output only if iod new
 */

#include <stdlib.h>
#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <signal.h>

#include "siolib.h"
#include "libgps.h"
#include "garmin.h"

#define DEFAULT_GETEPH_INTERVAL 300

#define RECV_BUF_SIZE 64

void usage ();

/* Signal handlers */
void sig_hup_handler (int);
void sig_term_handler (int);
void sig_alrm_handler (int);

/* Other functions */
void geteph (void);

int close_flag=0;
int fd;
int geteph_interval=DEFAULT_GETEPH_INTERVAL;

int main (int argc, char **argv) 
{
    int i,c,status;
    char buf[RECV_BUF_SIZE],*port_name=NULL;

    signal (SIGHUP, sig_hup_handler);
    signal (SIGALRM, sig_alrm_handler);
    signal (SIGINT, sig_term_handler);
    signal (SIGTERM, sig_term_handler);
    
    /* Parse switches. Will move to getopt some day. */
    for (i=0; i<argc; i++) 
    {
	if (*argv[i] == '-') 
	{
	    switch (*(argv[i]+1)) {
	     case 'p':
		port_name = argv[++i];
		break;
		
	     case 't':
		geteph_interval = atoi(argv[++i]);
		break;
		
	     case 'h':
		usage();
		exit(0);
	    }
	}
    }
    
    
    if (port_name!=NULL &&  strcmp(port_name,"-")!=0 ) 
    {
	fd = sio_open (port_name);
    } 
    else 
    {
	fd = STDIN_FILENO;
    }
    if (fd < 0) 
    {
	fprintf (stderr,"Error opening serial device %s\n",port_name);
	exit(1);
    }
    
    
    status = sio_setspeed (fd, B9600);
    if (status != 0) {
	fprintf (stderr,"Error setting serial port speed \n");
	exit(1);
    }
    
    sio_rawmode  (fd);

    geteph();
    
    alarm (geteph_interval);

    while (1) {
	c=sio_recv_buf (fd,RECV_BUF_SIZE,buf);
	fwrite (buf,1,c,stdout);
	fflush (stdout);
    }
    
}

void sig_hup_handler (int i)
{
    fprintf (stderr,"Got SIGHUP\n");
    geteph();
    signal (SIGHUP,sig_hup_handler);
}
void sig_alrm_handler (int i)
{
    fprintf (stderr,"Got SIGALRM\n");
    geteph();
    signal (SIGALRM,sig_alrm_handler);
    alarm (geteph_interval);
}

void geteph ()
{
    FILE *fp;
    char buf[32];
    int n;
    fprintf (stderr,"requesting ephemeris records\n");

    fp = fopen ("dleph.txt","r");
    if (fp==NULL)
    {
	fprintf (stderr,"error opening dleph.txt\n");
    }
    n = fread (buf, 1, 32, fp);
    fclose (fp);
    
    write (fd,buf,n);

}

void sig_term_handler (int i)
{
    fprintf (stderr,"Terminating gracefully...\n");
    sio_close (fd);
    exit(0);
}

void usage ()
{
    fprintf (stderr,"Usage: capture [-p port] \n\n");
}
