# 请求限流

GoToSocial 使用请求限流来限制与你的实例 API 的开放连接数。这是为了防止在一个账户含有成千上万粉丝的情况下，贴文被转发或回复时，避免你的实例意外被 DDOS 攻击（即所谓的[死亡之拥](https://en.wikipedia.org/wiki/Slashdot_effect)）。

限流意味着只有有限数量的 HTTP 请求可同时处理，以便为每个请求提供快速响应，迅速完成。其原理是，快速处理较少的请求比同时尝试处理所有传入请求并每个用时多秒要好。

限流应用于不同的路由组，类似于[速率限制](./ratelimiting.md)的组织方式，因此，如果 API 的某个部分正处于限流状态，并不意味着所有部分都如此。

限流限制基于 GoToSocial 可用的 CPU 数量和配置值 `advanced-throttling-multiplier` 来计算。其计算方式如下：

- 处理中的队列限制 = CPU 数量 * CPU 乘数。
- 待处理队列限制 = 处理中的队列限制 * CPU 乘数。

对于默认乘数（8），得出以下值：

```text
1 个 CPU = 08 处理中，064 待处理
2 个 CPU = 16 处理中，128 待处理
4 个 CPU = 32 处理中，256 待处理
8 个 CPU = 64 处理中，512 待处理
```

新请求如果超过处理中的限制将被放入待处理队列，并在有空位时进行处理（即当前处理中的请求完成时）。无法处理且无法放入待处理队列的请求将收到 HTTP 代码 [503 - 服务不可用](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/503)，并设置 `Retry-After` 头为 `30`（秒），以表示调用者稍后重试。

请求不会无限期地保留在待处理队列中：如果待处理中的请求无法在 30 秒内处理，它们也将收到 503 代码和 30 秒的重试等待。

## 限流常见问题

### 我可以调节请求限流吗？

可以。只需根据你的 CPU 性能更改 `advanced-throttling-multiplier` 的值，CPU 性能强可调高，性能相对较弱可调低。

### 我可以禁用请求限流吗？

可以。只需将 `advanced-throttling-multiplier` 设置为 `0` 或更小。这样将完全禁用 HTTP 请求限流，并尝试同时处理所有传入请求。如果你想使用外部服务或反向代理进行请求限流，并且不希望 GoToSocial 干扰你的设置，这是很有用的。
