// Code generated by "esc -include=.*\.tmpl -o=tmpl.go -pkg=templates ./"; DO NOT EDIT.

package templates

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	"path"
	"sync"
	"time"
)

type _escLocalFS struct{}

var _escLocal _escLocalFS

type _escStaticFS struct{}

var _escStatic _escStaticFS

type _escDirectory struct {
	fs   http.FileSystem
	name string
}

type _escFile struct {
	compressed string
	size       int64
	modtime    int64
	local      string
	isDir      bool

	once sync.Once
	data []byte
	name string
}

func (_escLocalFS) Open(name string) (http.File, error) {
	f, present := _escData[path.Clean(name)]
	if !present {
		return nil, os.ErrNotExist
	}
	return os.Open(f.local)
}

func (_escStaticFS) prepare(name string) (*_escFile, error) {
	f, present := _escData[path.Clean(name)]
	if !present {
		return nil, os.ErrNotExist
	}
	var err error
	f.once.Do(func() {
		f.name = path.Base(name)
		if f.size == 0 {
			return
		}
		var gr *gzip.Reader
		b64 := base64.NewDecoder(base64.StdEncoding, bytes.NewBufferString(f.compressed))
		gr, err = gzip.NewReader(b64)
		if err != nil {
			return
		}
		f.data, err = ioutil.ReadAll(gr)
	})
	if err != nil {
		return nil, err
	}
	return f, nil
}

func (fs _escStaticFS) Open(name string) (http.File, error) {
	f, err := fs.prepare(name)
	if err != nil {
		return nil, err
	}
	return f.File()
}

func (dir _escDirectory) Open(name string) (http.File, error) {
	return dir.fs.Open(dir.name + name)
}

func (f *_escFile) File() (http.File, error) {
	type httpFile struct {
		*bytes.Reader
		*_escFile
	}
	return &httpFile{
		Reader:   bytes.NewReader(f.data),
		_escFile: f,
	}, nil
}

func (f *_escFile) Close() error {
	return nil
}

func (f *_escFile) Readdir(count int) ([]os.FileInfo, error) {
	if !f.isDir {
		return nil, fmt.Errorf(" escFile.Readdir: '%s' is not directory", f.name)
	}

	fis, ok := _escDirs[f.local]
	if !ok {
		return nil, fmt.Errorf(" escFile.Readdir: '%s' is directory, but we have no info about content of this dir, local=%s", f.name, f.local)
	}
	limit := count
	if count <= 0 || limit > len(fis) {
		limit = len(fis)
	}

	if len(fis) == 0 && count > 0 {
		return nil, io.EOF
	}

	return fis[0:limit], nil
}

func (f *_escFile) Stat() (os.FileInfo, error) {
	return f, nil
}

func (f *_escFile) Name() string {
	return f.name
}

func (f *_escFile) Size() int64 {
	return f.size
}

func (f *_escFile) Mode() os.FileMode {
	return 0
}

func (f *_escFile) ModTime() time.Time {
	return time.Unix(f.modtime, 0)
}

func (f *_escFile) IsDir() bool {
	return f.isDir
}

func (f *_escFile) Sys() interface{} {
	return f
}

// FS returns a http.Filesystem for the embedded assets. If useLocal is true,
// the filesystem's contents are instead used.
func FS(useLocal bool) http.FileSystem {
	if useLocal {
		return _escLocal
	}
	return _escStatic
}

// Dir returns a http.Filesystem for the embedded assets on a given prefix dir.
// If useLocal is true, the filesystem's contents are instead used.
func Dir(useLocal bool, name string) http.FileSystem {
	if useLocal {
		return _escDirectory{fs: _escLocal, name: name}
	}
	return _escDirectory{fs: _escStatic, name: name}
}

// FSByte returns the named file from the embedded assets. If useLocal is
// true, the filesystem's contents are instead used.
func FSByte(useLocal bool, name string) ([]byte, error) {
	if useLocal {
		f, err := _escLocal.Open(name)
		if err != nil {
			return nil, err
		}
		b, err := ioutil.ReadAll(f)
		_ = f.Close()
		return b, err
	}
	f, err := _escStatic.prepare(name)
	if err != nil {
		return nil, err
	}
	return f.data, nil
}

// FSMustByte is the same as FSByte, but panics if name is not present.
func FSMustByte(useLocal bool, name string) []byte {
	b, err := FSByte(useLocal, name)
	if err != nil {
		panic(err)
	}
	return b
}

// FSString is the string version of FSByte.
func FSString(useLocal bool, name string) (string, error) {
	b, err := FSByte(useLocal, name)
	return string(b), err
}

// FSMustString is the string version of FSMustByte.
func FSMustString(useLocal bool, name string) string {
	return string(FSMustByte(useLocal, name))
}

var _escData = map[string]*_escFile{

	"/test/call.tmpl": {
		name:    "call.tmpl",
		local:   "test/call.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/test/function.tmpl": {
		name:    "function.tmpl",
		local:   "test/function.tmpl",
		size:    19,
		modtime: 1573266938,
		compressed: `
H4sIAAAAAAAC/6qu1tdSSFRIzs/NTc0rUdDSr+UCBAAA//+6o7WcEwAAAA==
`,
	},

	"/test/header.tmpl": {
		name:    "header.tmpl",
		local:   "test/header.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/test/inline.tmpl": {
		name:    "inline.tmpl",
		local:   "test/inline.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/test/inputs.tmpl": {
		name:    "inputs.tmpl",
		local:   "test/inputs.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/test/message.tmpl": {
		name:    "message.tmpl",
		local:   "test/message.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/test/results.tmpl": {
		name:    "results.tmpl",
		local:   "test/results.tmpl",
		size:    0,
		modtime: 1573266911,
		compressed: `
H4sIAAAAAAAC/wEAAP//AAAAAAAAAAA=
`,
	},

	"/testify/call.tmpl": {
		name:    "call.tmpl",
		local:   "testify/call.tmpl",
		size:    241,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/0SOQWrDQAxFryKMFy0YHaDQA3hTSlvatRjLrsCeFo2SEITuHsY4mdWHP2/el/vEs2SG
LtG6dhHuF7FfwA9OLGfW2sgM+c8Ax/JpekoWYYbunKf6eicBI1qLb7RxxJO7Ul4Yehmg5xVeXgHfSWlj
Yy2HvZeIAR5/296PitUbzJB0KU2/K+riTuPX9Z9xLN+kQpOkCMTG7vF85C0AAP//ZQi8iPEAAAA=
`,
	},

	"/testify/function.tmpl": {
		name:    "function.tmpl",
		local:   "testify/function.tmpl",
		size:    2534,
		modtime: 1572158668,
		compressed: `
H4sIAAAAAAAC/5xWTW/jNhA9S79iIASBVTjM3UAOKZoUucSBHTSHoigYa+QKlWmXHHVhEPzvCw71bSmb
rA675pCc92aGbybWZpgXCiGRxqCm4qgSuHEuJhKtZUFLsLbIQaxVed4gVVqZB62P2jlrCQ+nUhJCspNl
mYDwRiwNOodaW4sqcy629gaKHI4aFupIILbVO6Ehk4J40YWiJ3WqyDA0AMAS8gOJ7clv5Yukj3JAY+Qe
GSjxxLqtgp3wTsqIqDJ22a6ci+O4Cxr/q2SZOBdCFQ9+yZH+gKdzeR1YE1/f68HsE7/zGT+whJ+IbggO
A/S8UjuuY531qxxWd/5SHPstsFa8oqFneUDnFgS/eF6F2ovXFGwc+SvfCvoHxAZ3WPyP2rk4iur6iSez
JV3tiI2t9bHAMjPBFtH5hJCzBQwf9n7r01qqPY4uRNby2pNkeucT1ltd2fyqxWxMvd+jn56VD/NFanlA
Qs1gTE3q/YBYj9blDQZk0wW7HuIQnwvtk/7nXz0YJQ/oYQu1ry9PpLnhLlXW5XqUrjq14b82Iyy4mm/j
8jKhM8n7IGVRxPny/0zc6eVtg6YqyTQ4b1LRRylrIYf9hAGbxgONLv3efWN9rNRulH6f39tbeF3/tl7B
fZaBLwHspEEjuDr5UYcWtjjqToy1Np/Ms/wXszR1Dv5eApGvXaOtEGE4brk3+a8h33pyjsSmUgsi4Qu9
BK+1sbqg35Oi+Ucwo7aL0jJNLtv5hHxYaueu2+4Q7H/IskLnbONiRoSRtSI0hRUQifC8RE+ay85BJ8lo
QqcXixpvQllNmG+6oDb6geJWd3D9fiY04tcqz1HbzwDWCgrlHQ+t9NK+VshZSqFl1vVdHR52Alc5P+fx
wPPmORbj1w2jr++tN4FnXc7pbSqVMPH18cLwYyw/4YlEp1o/edoaiC13rUU6GFRmH+6mXT1CD5rGZXpX
+VTWZ+58lW9/UpaFwnB0hvMcyQ9i+Cqf348UZvXXCLTSmn3iE80HXDpsLi52/o+CcOV7AAAA//+jWbgI
5gkAAA==
`,
	},

	"/testify/header.tmpl": {
		name:    "header.tmpl",
		local:   "testify/header.tmpl",
		size:    142,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/0TMMQ7CMAyF4d2nsDrBQC7BxIK4gkUebYXiViGb9e6OlAi6/bL1voiM1+rQaYFl1ImU
iGo+Q9N1KwXePmRE6g941gspuz3fNkMj0mMkKbKWfatNT4dw65cB3K2AHJO2/DhSzv/6BgAA///GzMM9
jgAAAA==
`,
	},

	"/testify/inline.tmpl": {
		name:    "inline.tmpl",
		local:   "testify/inline.tmpl",
		size:    49,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/6quTklNy8xLVVDKzMvJzEtVqq1VqK4uSc0tyEksSVVQSk7MyVFS0AOLpual1NYCAgAA
//+q60H/MQAAAA==
`,
	},

	"/testify/inputs.tmpl": {
		name:    "inputs.tmpl",
		local:   "testify/inputs.tmpl",
		size:    152,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/0yNMQoCQQxFrxKWLSUHEDyAneAJIptZptgomWz1yd1lRoupEh7/vw9sWqopLdU+Z7Ql
E1gLXW/E/a2F7B3Ez/MV2qJlRrDJoRcC1LZ/Zi388GpxH5IOXWzXwcXl0FD/dcX3xsCgfWLyzOcbAAD/
/468z9qYAAAA
`,
	},

	"/testify/message.tmpl": {
		name:    "message.tmpl",
		local:   "testify/message.tmpl",
		size:    201,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/zyN4WqDQBCE//sUiyi0oPsAhT5A/xRpS/9f4mgW9GLuTkNY9t2DB/HXDDPDN6o9BvGg
ckaMbkRJrVmhKgP5ayL+XU8JMUWz+sakCt+bqd4lXYh/cIZsCHvCf48F/O+mFWZ8DPnbzTB7y0Tugvj0
5Zd1B6oG50dQJQ1VmOjjk7hzwc1ICLmXgSoxa16/9XZws7wXqi1l+wwAAP//kC65UskAAAA=
`,
	},

	"/testify/results.tmpl": {
		name:    "results.tmpl",
		local:   "testify/results.tmpl",
		size:    168,
		modtime: 1571318606,
		compressed: `
H4sIAAAAAAAC/1yNTQrCQAyFr/Iosyw9gOBS3HsDoRkJlAy8ma5C7i6pRcFVfr4vee6rVDXBROn7NvoU
AXc+7SUoOqPIhssVy+ODI9y1omjEDHexNTf3NrBkc85a82DstH4jG1MW8uQ4hMbv0385A3/uUd8BAAD/
/7BPz2GoAAAA
`,
	},

	"/": {
		name:  "/",
		local: `./`,
		isDir: true,
	},

	"/test": {
		name:  "test",
		local: `test`,
		isDir: true,
	},

	"/test_empty": {
		name:  "test_empty",
		local: `test_empty`,
		isDir: true,
	},

	"/testify": {
		name:  "testify",
		local: `testify`,
		isDir: true,
	},
}

var _escDirs = map[string][]os.FileInfo{

	"./": {},

	"test": {
		_escData["/test/call.tmpl"],
		_escData["/test/function.tmpl"],
		_escData["/test/header.tmpl"],
		_escData["/test/inline.tmpl"],
		_escData["/test/inputs.tmpl"],
		_escData["/test/message.tmpl"],
		_escData["/test/results.tmpl"],
	},

	"test_empty": {},

	"testify": {
		_escData["/testify/call.tmpl"],
		_escData["/testify/function.tmpl"],
		_escData["/testify/header.tmpl"],
		_escData["/testify/inline.tmpl"],
		_escData["/testify/inputs.tmpl"],
		_escData["/testify/message.tmpl"],
		_escData["/testify/results.tmpl"],
	},
}
