// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/kubernetes/security/containersecurity_logging/logging.proto

package containersecurity_logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// FindingType is an enumeration of all possible finding types in GKE Security
// Posture.
type FindingType int32

const (
	// Default value, unspecified.
	FindingType_FINDING_TYPE_UNSPECIFIED FindingType = 0
	// Workload misconfiguration policy audit.
	FindingType_FINDING_TYPE_MISCONFIG FindingType = 1
	// Workload vulnerabilities scanning.
	FindingType_FINDING_TYPE_VULNERABILITY FindingType = 2
)

// Enum value maps for FindingType.
var (
	FindingType_name = map[int32]string{
		0: "FINDING_TYPE_UNSPECIFIED",
		1: "FINDING_TYPE_MISCONFIG",
		2: "FINDING_TYPE_VULNERABILITY",
	}
	FindingType_value = map[string]int32{
		"FINDING_TYPE_UNSPECIFIED":   0,
		"FINDING_TYPE_MISCONFIG":     1,
		"FINDING_TYPE_VULNERABILITY": 2,
	}
)

func (x FindingType) Enum() *FindingType {
	p := new(FindingType)
	*p = x
	return p
}

func (x FindingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FindingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[0].Descriptor()
}

func (FindingType) Type() protoreflect.EnumType {
	return &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[0]
}

func (x FindingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FindingType.Descriptor instead.
func (FindingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP(), []int{0}
}

// Severity is an enumeration of all the possible severities of a violation.
type Severity int32

const (
	// Default value, only used to determine that nothing was specified.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// SEVERITY_CRITICAL recommends taking action immediately.
	Severity_SEVERITY_CRITICAL Severity = 1
	// SEVERITY_HIGH recommends taking action if possible.
	Severity_SEVERITY_HIGH Severity = 2
	// SEVERITY_MEDIUM recommends investigation.
	Severity_SEVERITY_MEDIUM Severity = 3
	// SEVERITY_LOW recommends being aware of the problem.
	Severity_SEVERITY_LOW Severity = 4
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "SEVERITY_CRITICAL",
		2: "SEVERITY_HIGH",
		3: "SEVERITY_MEDIUM",
		4: "SEVERITY_LOW",
	}
	Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"SEVERITY_CRITICAL":    1,
		"SEVERITY_HIGH":        2,
		"SEVERITY_MEDIUM":      3,
		"SEVERITY_LOW":         4,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[1].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[1]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Severity.Descriptor instead.
func (Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP(), []int{1}
}

// The current state of the finding(e.g still active, has been fixed etc).
type Finding_State int32

const (
	// Default value, only used to determine that nothing was specified.
	Finding_STATE_UNSPECIFIED Finding_State = 0
	// Active state means that the finding exists on the asset.
	Finding_ACTIVE Finding_State = 1
	// Remediated means that the finding has been fixed on the asset.
	Finding_REMEDIATED Finding_State = 2
)

// Enum value maps for Finding_State.
var (
	Finding_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "REMEDIATED",
	}
	Finding_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"REMEDIATED":        2,
	}
)

func (x Finding_State) Enum() *Finding_State {
	p := new(Finding_State)
	*p = x
	return p
}

func (x Finding_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Finding_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[2].Descriptor()
}

func (Finding_State) Type() protoreflect.EnumType {
	return &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes[2]
}

func (x Finding_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Finding_State.Descriptor instead.
func (Finding_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP(), []int{1, 0}
}

// Identifies a package vulnerability found within a workload.
type Vulnerability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// package name where vulnerability detected
	PackageName string `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// affected package version
	AffectedPackageVersion string `protobuf:"bytes,2,opt,name=affected_package_version,json=affectedPackageVersion,proto3" json:"affected_package_version,omitempty"`
	// title of vulnerability assigned by CVE
	CveId string `protobuf:"bytes,3,opt,name=cve_id,json=cveId,proto3" json:"cve_id,omitempty"`
	// cpe_uri where vulnerability detected
	CpeUri string `protobuf:"bytes,4,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// assigned severity for vulnerability
	Severity Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=cloud.kubernetes.security.containersecurity_logging.Severity" json:"severity,omitempty"`
	// overall CVSS score
	CvssScore float32 `protobuf:"fixed32,6,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// detailed CVSS score, format `CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N`
	CvssVector string `protobuf:"bytes,7,opt,name=cvss_vector,json=cvssVector,proto3" json:"cvss_vector,omitempty"`
	// cpe_uri where vulnerability is fixed
	FixedCpeUri string `protobuf:"bytes,8,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// type of package (os, maven, go)
	PackageType string `protobuf:"bytes,9,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// package name where vulnerability is fixed
	FixedPackage string `protobuf:"bytes,10,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// fixed package version
	FixedPackageVersion string `protobuf:"bytes,11,opt,name=fixed_package_version,json=fixedPackageVersion,proto3" json:"fixed_package_version,omitempty"`
	// detailed description
	Description string `protobuf:"bytes,12,opt,name=description,proto3" json:"description,omitempty"`
	// reference URL for source CVE database
	RelatedUrls []string `protobuf:"bytes,13,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	// affected images
	AffectedImages []string `protobuf:"bytes,14,rep,name=affected_images,json=affectedImages,proto3" json:"affected_images,omitempty"`
}

func (x *Vulnerability) Reset() {
	*x = Vulnerability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability) ProtoMessage() {}

func (x *Vulnerability) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability.ProtoReflect.Descriptor instead.
func (*Vulnerability) Descriptor() ([]byte, []int) {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP(), []int{0}
}

func (x *Vulnerability) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *Vulnerability) GetAffectedPackageVersion() string {
	if x != nil {
		return x.AffectedPackageVersion
	}
	return ""
}

func (x *Vulnerability) GetCveId() string {
	if x != nil {
		return x.CveId
	}
	return ""
}

func (x *Vulnerability) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *Vulnerability) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *Vulnerability) GetCvssScore() float32 {
	if x != nil {
		return x.CvssScore
	}
	return 0
}

func (x *Vulnerability) GetCvssVector() string {
	if x != nil {
		return x.CvssVector
	}
	return ""
}

func (x *Vulnerability) GetFixedCpeUri() string {
	if x != nil {
		return x.FixedCpeUri
	}
	return ""
}

func (x *Vulnerability) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *Vulnerability) GetFixedPackage() string {
	if x != nil {
		return x.FixedPackage
	}
	return ""
}

func (x *Vulnerability) GetFixedPackageVersion() string {
	if x != nil {
		return x.FixedPackageVersion
	}
	return ""
}

func (x *Vulnerability) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Vulnerability) GetRelatedUrls() []string {
	if x != nil {
		return x.RelatedUrls
	}
	return nil
}

func (x *Vulnerability) GetAffectedImages() []string {
	if x != nil {
		return x.AffectedImages
	}
	return nil
}

// A security concern for an asset(i.e cluster, workload, etc). Each finding
// corresponds to a type of security concern. A finding is created during the
// scan of an asset by any one of the GKE Security Posture features that are
// enabled.
type Finding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fully qualified resource name of the k8s resource, e.g.:
	// {api}/{version}/namespaces/{namespace}/{kind}/{workload name}
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of security finding this is.
	Type FindingType `protobuf:"varint,2,opt,name=type,proto3,enum=cloud.kubernetes.security.containersecurity_logging.FindingType" json:"type,omitempty"`
	// State determines whether the finding still exists or has been resolved.
	State Finding_State `protobuf:"varint,3,opt,name=state,proto3,enum=cloud.kubernetes.security.containersecurity_logging.Finding_State" json:"state,omitempty"`
	// The human readable representation of the specific security finding.
	// e.g. RUN_AS_NONROOT, CVE_ID_0 etc depending on the type.
	Finding string `protobuf:"bytes,4,opt,name=finding,proto3" json:"finding,omitempty"`
	// Severity determines the recommended actions for this finding.
	Severity Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=cloud.kubernetes.security.containersecurity_logging.Severity" json:"severity,omitempty"`
	// The time this finding was found/remediated.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Specific details about the security finding if there are any.
	//
	// Types that are assignable to Details:
	//
	//	*Finding_Vulnerability
	Details isFinding_Details `protobuf_oneof:"details"`
}

func (x *Finding) Reset() {
	*x = Finding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Finding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding) ProtoMessage() {}

func (x *Finding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding.ProtoReflect.Descriptor instead.
func (*Finding) Descriptor() ([]byte, []int) {
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP(), []int{1}
}

func (x *Finding) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Finding) GetType() FindingType {
	if x != nil {
		return x.Type
	}
	return FindingType_FINDING_TYPE_UNSPECIFIED
}

func (x *Finding) GetState() Finding_State {
	if x != nil {
		return x.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (x *Finding) GetFinding() string {
	if x != nil {
		return x.Finding
	}
	return ""
}

func (x *Finding) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *Finding) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (m *Finding) GetDetails() isFinding_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Finding) GetVulnerability() *Vulnerability {
	if x, ok := x.GetDetails().(*Finding_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

type isFinding_Details interface {
	isFinding_Details()
}

type Finding_Vulnerability struct {
	Vulnerability *Vulnerability `protobuf:"bytes,7,opt,name=vulnerability,proto3,oneof"`
}

func (*Finding_Vulnerability) isFinding_Details() {}

var File_google_cloud_kubernetes_security_containersecurity_logging_logging_proto protoreflect.FileDescriptor

var file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDesc = []byte{
	0x0a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xc5, 0x04, 0x0a, 0x0d, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x15, 0x0a, 0x06, 0x63, 0x76, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x63, 0x76, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12,
	0x59, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3d, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x76,
	0x73, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09,
	0x63, 0x76, 0x73, 0x73, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x76, 0x73,
	0x73, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x76, 0x73, 0x73, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0d, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x43, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12, 0x21,
	0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x66, 0x69, 0x78, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x22, 0xc1, 0x04, 0x0a, 0x07, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x58, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x59, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x39,
	0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x0d, 0x76, 0x75, 0x6c,
	0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x3a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x02, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2a, 0x67, 0x0a, 0x0b,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x46,
	0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x59, 0x10, 0x02, 0x2a, 0x75, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45,
	0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x42, 0x92, 0x03, 0x0a,
	0x3e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x42,
	0x1d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x73, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0xca, 0x02, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5c, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xea,
	0x02, 0x3f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x3a, 0x3a, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescOnce sync.Once
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescData = file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDesc
)

func file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescGZIP() []byte {
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescOnce.Do(func() {
		file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescData)
	})
	return file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDescData
}

var file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_goTypes = []interface{}{
	(FindingType)(0),              // 0: cloud.kubernetes.security.containersecurity_logging.FindingType
	(Severity)(0),                 // 1: cloud.kubernetes.security.containersecurity_logging.Severity
	(Finding_State)(0),            // 2: cloud.kubernetes.security.containersecurity_logging.Finding.State
	(*Vulnerability)(nil),         // 3: cloud.kubernetes.security.containersecurity_logging.Vulnerability
	(*Finding)(nil),               // 4: cloud.kubernetes.security.containersecurity_logging.Finding
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_depIdxs = []int32{
	1, // 0: cloud.kubernetes.security.containersecurity_logging.Vulnerability.severity:type_name -> cloud.kubernetes.security.containersecurity_logging.Severity
	0, // 1: cloud.kubernetes.security.containersecurity_logging.Finding.type:type_name -> cloud.kubernetes.security.containersecurity_logging.FindingType
	2, // 2: cloud.kubernetes.security.containersecurity_logging.Finding.state:type_name -> cloud.kubernetes.security.containersecurity_logging.Finding.State
	1, // 3: cloud.kubernetes.security.containersecurity_logging.Finding.severity:type_name -> cloud.kubernetes.security.containersecurity_logging.Severity
	5, // 4: cloud.kubernetes.security.containersecurity_logging.Finding.event_time:type_name -> google.protobuf.Timestamp
	3, // 5: cloud.kubernetes.security.containersecurity_logging.Finding.vulnerability:type_name -> cloud.kubernetes.security.containersecurity_logging.Vulnerability
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_init() }
func file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_init() {
	if File_google_cloud_kubernetes_security_containersecurity_logging_logging_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Finding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Finding_Vulnerability)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_goTypes,
		DependencyIndexes: file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_depIdxs,
		EnumInfos:         file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_enumTypes,
		MessageInfos:      file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_msgTypes,
	}.Build()
	File_google_cloud_kubernetes_security_containersecurity_logging_logging_proto = out.File
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_rawDesc = nil
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_goTypes = nil
	file_google_cloud_kubernetes_security_containersecurity_logging_logging_proto_depIdxs = nil
}
