// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/assistant/embedded/v1alpha2/embedded_assistant.proto

package embedded

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the type of event.
type AssistResponse_EventType int32

const (
	// No event specified.
	AssistResponse_EVENT_TYPE_UNSPECIFIED AssistResponse_EventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection.
	AssistResponse_END_OF_UTTERANCE AssistResponse_EventType = 1
)

// Enum value maps for AssistResponse_EventType.
var (
	AssistResponse_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "END_OF_UTTERANCE",
	}
	AssistResponse_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"END_OF_UTTERANCE":       1,
	}
)

func (x AssistResponse_EventType) Enum() *AssistResponse_EventType {
	p := new(AssistResponse_EventType)
	*p = x
	return p
}

func (x AssistResponse_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AssistResponse_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[0].Descriptor()
}

func (AssistResponse_EventType) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[0]
}

func (x AssistResponse_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AssistResponse_EventType.Descriptor instead.
func (AssistResponse_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{1, 0}
}

// Audio encoding of the data sent in the audio message.
// Audio must be one-channel (mono).
type AudioInConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioInConfig_ENCODING_UNSPECIFIED AudioInConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// This encoding includes no header, only the raw audio bytes.
	AudioInConfig_LINEAR16 AudioInConfig_Encoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. This encoding
	// includes the `FLAC` stream header followed by audio data. It supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO` are
	// supported.
	AudioInConfig_FLAC AudioInConfig_Encoding = 2
)

// Enum value maps for AudioInConfig_Encoding.
var (
	AudioInConfig_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "FLAC",
	}
	AudioInConfig_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"LINEAR16":             1,
		"FLAC":                 2,
	}
)

func (x AudioInConfig_Encoding) Enum() *AudioInConfig_Encoding {
	p := new(AudioInConfig_Encoding)
	*p = x
	return p
}

func (x AudioInConfig_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioInConfig_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[1].Descriptor()
}

func (AudioInConfig_Encoding) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[1]
}

func (x AudioInConfig_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioInConfig_Encoding.Descriptor instead.
func (AudioInConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{4, 0}
}

// Audio encoding of the data returned in the audio message. All encodings are
// raw audio bytes with no header, except as indicated below.
type AudioOutConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioOutConfig_ENCODING_UNSPECIFIED AudioOutConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioOutConfig_LINEAR16 AudioOutConfig_Encoding = 1
	// MP3 audio encoding. The sample rate is encoded in the payload.
	AudioOutConfig_MP3 AudioOutConfig_Encoding = 2
	// Opus-encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android and in some browsers (such
	// as Chrome). The quality of the encoding is considerably higher than MP3
	// while using the same bitrate. The sample rate is encoded in the payload.
	AudioOutConfig_OPUS_IN_OGG AudioOutConfig_Encoding = 3
)

// Enum value maps for AudioOutConfig_Encoding.
var (
	AudioOutConfig_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "MP3",
		3: "OPUS_IN_OGG",
	}
	AudioOutConfig_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"LINEAR16":             1,
		"MP3":                  2,
		"OPUS_IN_OGG":          3,
	}
)

func (x AudioOutConfig_Encoding) Enum() *AudioOutConfig_Encoding {
	p := new(AudioOutConfig_Encoding)
	*p = x
	return p
}

func (x AudioOutConfig_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioOutConfig_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[2].Descriptor()
}

func (AudioOutConfig_Encoding) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[2]
}

func (x AudioOutConfig_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioOutConfig_Encoding.Descriptor instead.
func (AudioOutConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{5, 0}
}

// Possible modes for visual screen-output on the device.
type ScreenOutConfig_ScreenMode int32

const (
	// No video mode specified.
	// The Assistant may respond as if in `OFF` mode.
	ScreenOutConfig_SCREEN_MODE_UNSPECIFIED ScreenOutConfig_ScreenMode = 0
	// Screen is off (or has brightness or other settings set so low it is
	// not visible). The Assistant will typically not return a screen response
	// in this mode.
	ScreenOutConfig_OFF ScreenOutConfig_ScreenMode = 1
	// The Assistant will typically return a partial-screen response in this
	// mode.
	ScreenOutConfig_PLAYING ScreenOutConfig_ScreenMode = 3
)

// Enum value maps for ScreenOutConfig_ScreenMode.
var (
	ScreenOutConfig_ScreenMode_name = map[int32]string{
		0: "SCREEN_MODE_UNSPECIFIED",
		1: "OFF",
		3: "PLAYING",
	}
	ScreenOutConfig_ScreenMode_value = map[string]int32{
		"SCREEN_MODE_UNSPECIFIED": 0,
		"OFF":                     1,
		"PLAYING":                 3,
	}
)

func (x ScreenOutConfig_ScreenMode) Enum() *ScreenOutConfig_ScreenMode {
	p := new(ScreenOutConfig_ScreenMode)
	*p = x
	return p
}

func (x ScreenOutConfig_ScreenMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScreenOutConfig_ScreenMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[3].Descriptor()
}

func (ScreenOutConfig_ScreenMode) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[3]
}

func (x ScreenOutConfig_ScreenMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScreenOutConfig_ScreenMode.Descriptor instead.
func (ScreenOutConfig_ScreenMode) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{6, 0}
}

// Possible formats of the screen data.
type ScreenOut_Format int32

const (
	// No format specified.
	ScreenOut_FORMAT_UNSPECIFIED ScreenOut_Format = 0
	// Data will contain a fully-formed HTML5 layout encoded in UTF-8, e.g.
	// `<html><body><div>...</div></body></html>`. It is intended to be rendered
	// along with the audio response. Note that HTML5 doctype should be included
	// in the actual HTML data.
	ScreenOut_HTML ScreenOut_Format = 1
)

// Enum value maps for ScreenOut_Format.
var (
	ScreenOut_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "HTML",
	}
	ScreenOut_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"HTML":               1,
	}
)

func (x ScreenOut_Format) Enum() *ScreenOut_Format {
	p := new(ScreenOut_Format)
	*p = x
	return p
}

func (x ScreenOut_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScreenOut_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[4].Descriptor()
}

func (ScreenOut_Format) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[4]
}

func (x ScreenOut_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScreenOut_Format.Descriptor instead.
func (ScreenOut_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{10, 0}
}

// Possible states of the microphone after a `Assist` RPC completes.
type DialogStateOut_MicrophoneMode int32

const (
	// No mode specified.
	DialogStateOut_MICROPHONE_MODE_UNSPECIFIED DialogStateOut_MicrophoneMode = 0
	// The service is not expecting a follow-on question from the user.
	// The microphone should remain off until the user re-activates it.
	DialogStateOut_CLOSE_MICROPHONE DialogStateOut_MicrophoneMode = 1
	// The service is expecting a follow-on question from the user. The
	// microphone should be re-opened when the `AudioOut` playback completes
	// (by starting a new `Assist` RPC call to send the new audio).
	DialogStateOut_DIALOG_FOLLOW_ON DialogStateOut_MicrophoneMode = 2
)

// Enum value maps for DialogStateOut_MicrophoneMode.
var (
	DialogStateOut_MicrophoneMode_name = map[int32]string{
		0: "MICROPHONE_MODE_UNSPECIFIED",
		1: "CLOSE_MICROPHONE",
		2: "DIALOG_FOLLOW_ON",
	}
	DialogStateOut_MicrophoneMode_value = map[string]int32{
		"MICROPHONE_MODE_UNSPECIFIED": 0,
		"CLOSE_MICROPHONE":            1,
		"DIALOG_FOLLOW_ON":            2,
	}
)

func (x DialogStateOut_MicrophoneMode) Enum() *DialogStateOut_MicrophoneMode {
	p := new(DialogStateOut_MicrophoneMode)
	*p = x
	return p
}

func (x DialogStateOut_MicrophoneMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DialogStateOut_MicrophoneMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[5].Descriptor()
}

func (DialogStateOut_MicrophoneMode) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes[5]
}

func (x DialogStateOut_MicrophoneMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DialogStateOut_MicrophoneMode.Descriptor instead.
func (DialogStateOut_MicrophoneMode) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{13, 0}
}

// The top-level message sent by the client. Clients must send at least two, and
// typically numerous `AssistRequest` messages. The first message must
// contain a `config` message and must not contain `audio_in` data. All
// subsequent messages must contain `audio_in` data and must not contain a
// `config` message.
type AssistRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of these fields must be specified in each `AssistRequest`.
	//
	// Types that are assignable to Type:
	//
	//	*AssistRequest_Config
	//	*AssistRequest_AudioIn
	Type isAssistRequest_Type `protobuf_oneof:"type"`
}

func (x *AssistRequest) Reset() {
	*x = AssistRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssistRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssistRequest) ProtoMessage() {}

func (x *AssistRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssistRequest.ProtoReflect.Descriptor instead.
func (*AssistRequest) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{0}
}

func (m *AssistRequest) GetType() isAssistRequest_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AssistRequest) GetConfig() *AssistConfig {
	if x, ok := x.GetType().(*AssistRequest_Config); ok {
		return x.Config
	}
	return nil
}

func (x *AssistRequest) GetAudioIn() []byte {
	if x, ok := x.GetType().(*AssistRequest_AudioIn); ok {
		return x.AudioIn
	}
	return nil
}

type isAssistRequest_Type interface {
	isAssistRequest_Type()
}

type AssistRequest_Config struct {
	// The `config` message provides information to the recognizer that
	// specifies how to process the request.
	// The first `AssistRequest` message must contain a `config` message.
	Config *AssistConfig `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type AssistRequest_AudioIn struct {
	// The audio data to be recognized. Sequential chunks of audio data are sent
	// in sequential `AssistRequest` messages. The first `AssistRequest`
	// message must not contain `audio_in` data and all subsequent
	// `AssistRequest` messages must contain `audio_in` data. The audio bytes
	// must be encoded as specified in `AudioInConfig`.
	// Audio must be sent at approximately real-time (16000 samples per second).
	// An error will be returned if audio is sent significantly faster or
	// slower.
	AudioIn []byte `protobuf:"bytes,2,opt,name=audio_in,json=audioIn,proto3,oneof"`
}

func (*AssistRequest_Config) isAssistRequest_Type() {}

func (*AssistRequest_AudioIn) isAssistRequest_Type() {}

// The top-level message received by the client. A series of one or more
// `AssistResponse` messages are streamed back to the client.
type AssistResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* Indicates the type of event.
	EventType AssistResponse_EventType `protobuf:"varint,1,opt,name=event_type,json=eventType,proto3,enum=google.assistant.embedded.v1alpha2.AssistResponse_EventType" json:"event_type,omitempty"`
	// *Output-only* The audio containing the Assistant's response to the query.
	AudioOut *AudioOut `protobuf:"bytes,3,opt,name=audio_out,json=audioOut,proto3" json:"audio_out,omitempty"`
	// *Output-only* Contains the Assistant's visual response to the query.
	ScreenOut *ScreenOut `protobuf:"bytes,4,opt,name=screen_out,json=screenOut,proto3" json:"screen_out,omitempty"`
	// *Output-only* Contains the action triggered by the query with the
	// appropriate payloads and semantic parsing.
	DeviceAction *DeviceAction `protobuf:"bytes,6,opt,name=device_action,json=deviceAction,proto3" json:"device_action,omitempty"`
	// *Output-only* This repeated list contains zero or more speech recognition
	// results that correspond to consecutive portions of the audio currently
	// being processed, starting with the portion corresponding to the earliest
	// audio (and most stable portion) to the portion corresponding to the most
	// recent audio. The strings can be concatenated to view the full
	// in-progress response. When the speech recognition completes, this list
	// will contain one item with `stability` of `1.0`.
	SpeechResults []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=speech_results,json=speechResults,proto3" json:"speech_results,omitempty"`
	// *Output-only* Contains output related to the user's query.
	DialogStateOut *DialogStateOut `protobuf:"bytes,5,opt,name=dialog_state_out,json=dialogStateOut,proto3" json:"dialog_state_out,omitempty"`
	// *Output-only* Debugging info for developer. Only returned if request set
	// `return_debug_info` to true.
	DebugInfo *DebugInfo `protobuf:"bytes,8,opt,name=debug_info,json=debugInfo,proto3" json:"debug_info,omitempty"`
}

func (x *AssistResponse) Reset() {
	*x = AssistResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssistResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssistResponse) ProtoMessage() {}

func (x *AssistResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssistResponse.ProtoReflect.Descriptor instead.
func (*AssistResponse) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{1}
}

func (x *AssistResponse) GetEventType() AssistResponse_EventType {
	if x != nil {
		return x.EventType
	}
	return AssistResponse_EVENT_TYPE_UNSPECIFIED
}

func (x *AssistResponse) GetAudioOut() *AudioOut {
	if x != nil {
		return x.AudioOut
	}
	return nil
}

func (x *AssistResponse) GetScreenOut() *ScreenOut {
	if x != nil {
		return x.ScreenOut
	}
	return nil
}

func (x *AssistResponse) GetDeviceAction() *DeviceAction {
	if x != nil {
		return x.DeviceAction
	}
	return nil
}

func (x *AssistResponse) GetSpeechResults() []*SpeechRecognitionResult {
	if x != nil {
		return x.SpeechResults
	}
	return nil
}

func (x *AssistResponse) GetDialogStateOut() *DialogStateOut {
	if x != nil {
		return x.DialogStateOut
	}
	return nil
}

func (x *AssistResponse) GetDebugInfo() *DebugInfo {
	if x != nil {
		return x.DebugInfo
	}
	return nil
}

// Debug info for developer. Only returned if request set `return_debug_info`
// to true.
type DebugInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original JSON response from an Action-on-Google agent to Google server.
	// See
	// https://developers.google.com/actions/reference/rest/Shared.Types/AppResponse.
	// It will only be populated if the request maker owns the AoG project and the
	// AoG project is in preview mode.
	AogAgentToAssistantJson string `protobuf:"bytes,1,opt,name=aog_agent_to_assistant_json,json=aogAgentToAssistantJson,proto3" json:"aog_agent_to_assistant_json,omitempty"`
}

func (x *DebugInfo) Reset() {
	*x = DebugInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugInfo) ProtoMessage() {}

func (x *DebugInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugInfo.ProtoReflect.Descriptor instead.
func (*DebugInfo) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{2}
}

func (x *DebugInfo) GetAogAgentToAssistantJson() string {
	if x != nil {
		return x.AogAgentToAssistantJson
	}
	return ""
}

// Specifies how to process the `AssistRequest` messages.
type AssistConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*AssistConfig_AudioInConfig
	//	*AssistConfig_TextQuery
	Type isAssistConfig_Type `protobuf_oneof:"type"`
	// *Required* Specifies how to format the audio that will be returned.
	AudioOutConfig *AudioOutConfig `protobuf:"bytes,2,opt,name=audio_out_config,json=audioOutConfig,proto3" json:"audio_out_config,omitempty"`
	// *Optional* Specifies the desired format to use when server returns a
	// visual screen response.
	ScreenOutConfig *ScreenOutConfig `protobuf:"bytes,8,opt,name=screen_out_config,json=screenOutConfig,proto3" json:"screen_out_config,omitempty"`
	// *Required* Represents the current dialog state.
	DialogStateIn *DialogStateIn `protobuf:"bytes,3,opt,name=dialog_state_in,json=dialogStateIn,proto3" json:"dialog_state_in,omitempty"`
	// Device configuration that uniquely identifies a specific device.
	DeviceConfig *DeviceConfig `protobuf:"bytes,4,opt,name=device_config,json=deviceConfig,proto3" json:"device_config,omitempty"`
	// *Optional* Debugging parameters for the whole `Assist` RPC.
	DebugConfig *DebugConfig `protobuf:"bytes,5,opt,name=debug_config,json=debugConfig,proto3" json:"debug_config,omitempty"`
}

func (x *AssistConfig) Reset() {
	*x = AssistConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssistConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssistConfig) ProtoMessage() {}

func (x *AssistConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssistConfig.ProtoReflect.Descriptor instead.
func (*AssistConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{3}
}

func (m *AssistConfig) GetType() isAssistConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AssistConfig) GetAudioInConfig() *AudioInConfig {
	if x, ok := x.GetType().(*AssistConfig_AudioInConfig); ok {
		return x.AudioInConfig
	}
	return nil
}

func (x *AssistConfig) GetTextQuery() string {
	if x, ok := x.GetType().(*AssistConfig_TextQuery); ok {
		return x.TextQuery
	}
	return ""
}

func (x *AssistConfig) GetAudioOutConfig() *AudioOutConfig {
	if x != nil {
		return x.AudioOutConfig
	}
	return nil
}

func (x *AssistConfig) GetScreenOutConfig() *ScreenOutConfig {
	if x != nil {
		return x.ScreenOutConfig
	}
	return nil
}

func (x *AssistConfig) GetDialogStateIn() *DialogStateIn {
	if x != nil {
		return x.DialogStateIn
	}
	return nil
}

func (x *AssistConfig) GetDeviceConfig() *DeviceConfig {
	if x != nil {
		return x.DeviceConfig
	}
	return nil
}

func (x *AssistConfig) GetDebugConfig() *DebugConfig {
	if x != nil {
		return x.DebugConfig
	}
	return nil
}

type isAssistConfig_Type interface {
	isAssistConfig_Type()
}

type AssistConfig_AudioInConfig struct {
	// Specifies how to process the subsequent incoming audio. Required if
	// [AssistRequest.audio_in][google.assistant.embedded.v1alpha2.AssistRequest.audio_in]
	// bytes will be provided in subsequent requests.
	AudioInConfig *AudioInConfig `protobuf:"bytes,1,opt,name=audio_in_config,json=audioInConfig,proto3,oneof"`
}

type AssistConfig_TextQuery struct {
	// The text input to be sent to the Assistant. This can be populated from a
	// text interface if audio input is not available.
	TextQuery string `protobuf:"bytes,6,opt,name=text_query,json=textQuery,proto3,oneof"`
}

func (*AssistConfig_AudioInConfig) isAssistConfig_Type() {}

func (*AssistConfig_TextQuery) isAssistConfig_Type() {}

// Specifies how to process the `audio_in` data that will be provided in
// subsequent requests. For recommended settings, see the Google Assistant SDK
// [best
// practices](https://developers.google.com/assistant/sdk/guides/service/python/best-practices/audio).
type AudioInConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* Encoding of audio data sent in all `audio_in` messages.
	Encoding AudioInConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha2.AudioInConfig_Encoding" json:"encoding,omitempty"`
	// *Required* Sample rate (in Hertz) of the audio data sent in all `audio_in`
	// messages. Valid values are from 16000-24000, but 16000 is optimal.
	// For best results, set the sampling rate of the audio source to 16000 Hz.
	// If that's not possible, use the native sample rate of the audio source
	// (instead of re-sampling).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
}

func (x *AudioInConfig) Reset() {
	*x = AudioInConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioInConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioInConfig) ProtoMessage() {}

func (x *AudioInConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioInConfig.ProtoReflect.Descriptor instead.
func (*AudioInConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{4}
}

func (x *AudioInConfig) GetEncoding() AudioInConfig_Encoding {
	if x != nil {
		return x.Encoding
	}
	return AudioInConfig_ENCODING_UNSPECIFIED
}

func (x *AudioInConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `audio_out` messages.
type AudioOutConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* The encoding of audio data to be returned in all `audio_out`
	// messages.
	Encoding AudioOutConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha2.AudioOutConfig_Encoding" json:"encoding,omitempty"`
	// *Required* The sample rate in Hertz of the audio data returned in
	// `audio_out` messages. Valid values are: 16000-24000.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// *Required* Current volume setting of the device's audio output.
	// Valid values are 1 to 100 (corresponding to 1% to 100%).
	VolumePercentage int32 `protobuf:"varint,3,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
}

func (x *AudioOutConfig) Reset() {
	*x = AudioOutConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioOutConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioOutConfig) ProtoMessage() {}

func (x *AudioOutConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioOutConfig.ProtoReflect.Descriptor instead.
func (*AudioOutConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{5}
}

func (x *AudioOutConfig) GetEncoding() AudioOutConfig_Encoding {
	if x != nil {
		return x.Encoding
	}
	return AudioOutConfig_ENCODING_UNSPECIFIED
}

func (x *AudioOutConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *AudioOutConfig) GetVolumePercentage() int32 {
	if x != nil {
		return x.VolumePercentage
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `screen_out` response.
type ScreenOutConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current visual screen-mode for the device while issuing the query.
	ScreenMode ScreenOutConfig_ScreenMode `protobuf:"varint,1,opt,name=screen_mode,json=screenMode,proto3,enum=google.assistant.embedded.v1alpha2.ScreenOutConfig_ScreenMode" json:"screen_mode,omitempty"`
}

func (x *ScreenOutConfig) Reset() {
	*x = ScreenOutConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScreenOutConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScreenOutConfig) ProtoMessage() {}

func (x *ScreenOutConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScreenOutConfig.ProtoReflect.Descriptor instead.
func (*ScreenOutConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{6}
}

func (x *ScreenOutConfig) GetScreenMode() ScreenOutConfig_ScreenMode {
	if x != nil {
		return x.ScreenMode
	}
	return ScreenOutConfig_SCREEN_MODE_UNSPECIFIED
}

// Provides information about the current dialog state.
type DialogStateIn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* This field must always be set to the
	// [DialogStateOut.conversation_state][google.assistant.embedded.v1alpha2.DialogStateOut.conversation_state]
	// value that was returned in the prior `Assist` RPC. It should only be
	// omitted (field not set) if there was no prior `Assist` RPC because this is
	// the first `Assist` RPC made by this device after it was first setup and/or
	// a factory-default reset.
	ConversationState []byte `protobuf:"bytes,1,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Required* Language of the request in
	// [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47) (for example,
	// "en-US"). See [Language
	// Support](https://developers.google.com/assistant/sdk/reference/rpc/languages)
	// for more information. If you have selected a language for this `device_id`
	// using the
	// [Settings](https://developers.google.com/assistant/sdk/reference/assistant-app/assistant-settings)
	// menu in your phone's Google Assistant app, that selection will override
	// this value.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Location of the device where the query originated.
	DeviceLocation *DeviceLocation `protobuf:"bytes,5,opt,name=device_location,json=deviceLocation,proto3" json:"device_location,omitempty"`
	// *Optional* If true, the server will treat the request as a new conversation
	// and not use state from the prior request. Set this field to true when the
	// conversation should be restarted, such as after a device reboot, or after a
	// significant lapse of time since the prior query.
	IsNewConversation bool `protobuf:"varint,7,opt,name=is_new_conversation,json=isNewConversation,proto3" json:"is_new_conversation,omitempty"`
}

func (x *DialogStateIn) Reset() {
	*x = DialogStateIn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogStateIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogStateIn) ProtoMessage() {}

func (x *DialogStateIn) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogStateIn.ProtoReflect.Descriptor instead.
func (*DialogStateIn) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{7}
}

func (x *DialogStateIn) GetConversationState() []byte {
	if x != nil {
		return x.ConversationState
	}
	return nil
}

func (x *DialogStateIn) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *DialogStateIn) GetDeviceLocation() *DeviceLocation {
	if x != nil {
		return x.DeviceLocation
	}
	return nil
}

func (x *DialogStateIn) GetIsNewConversation() bool {
	if x != nil {
		return x.IsNewConversation
	}
	return false
}

// *Required* Fields that identify the device to the Assistant.
//
// See also:
//
// *   [Register a Device - REST
// API](https://developers.google.com/assistant/sdk/reference/device-registration/register-device-manual)
// *   [Device Model and Instance
// Schemas](https://developers.google.com/assistant/sdk/reference/device-registration/model-and-instance-schemas)
// *   [Device
// Proto](https://developers.google.com/assistant/sdk/reference/rpc/google.assistant.devices.v1alpha2#device)
type DeviceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* Unique identifier for the device. The id length must be 128
	// characters or less. Example: DBCDW098234. This MUST match the device_id
	// returned from device registration. This device_id is used to match against
	// the user's registered devices to lookup the supported traits and
	// capabilities of this device. This information should not change across
	// device reboots. However, it should not be saved across
	// factory-default resets.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// *Required* Unique identifier for the device model. The combination of
	// device_model_id and device_id must have been previously associated through
	// device registration.
	DeviceModelId string `protobuf:"bytes,3,opt,name=device_model_id,json=deviceModelId,proto3" json:"device_model_id,omitempty"`
}

func (x *DeviceConfig) Reset() {
	*x = DeviceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceConfig) ProtoMessage() {}

func (x *DeviceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceConfig.ProtoReflect.Descriptor instead.
func (*DeviceConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{8}
}

func (x *DeviceConfig) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

func (x *DeviceConfig) GetDeviceModelId() string {
	if x != nil {
		return x.DeviceModelId
	}
	return ""
}

// The audio containing the Assistant's response to the query. Sequential chunks
// of audio data are received in sequential `AssistResponse` messages.
type AudioOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* The audio data containing the Assistant's response to the
	// query. Sequential chunks of audio data are received in sequential
	// `AssistResponse` messages.
	AudioData []byte `protobuf:"bytes,1,opt,name=audio_data,json=audioData,proto3" json:"audio_data,omitempty"`
}

func (x *AudioOut) Reset() {
	*x = AudioOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioOut) ProtoMessage() {}

func (x *AudioOut) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioOut.ProtoReflect.Descriptor instead.
func (*AudioOut) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{9}
}

func (x *AudioOut) GetAudioData() []byte {
	if x != nil {
		return x.AudioData
	}
	return nil
}

// The Assistant's visual output response to query. Enabled by
// `screen_out_config`.
type ScreenOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* The format of the provided screen data.
	Format ScreenOut_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.assistant.embedded.v1alpha2.ScreenOut_Format" json:"format,omitempty"`
	// *Output-only* The raw screen data to be displayed as the result of the
	// Assistant query.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ScreenOut) Reset() {
	*x = ScreenOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScreenOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScreenOut) ProtoMessage() {}

func (x *ScreenOut) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScreenOut.ProtoReflect.Descriptor instead.
func (*ScreenOut) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{10}
}

func (x *ScreenOut) GetFormat() ScreenOut_Format {
	if x != nil {
		return x.Format
	}
	return ScreenOut_FORMAT_UNSPECIFIED
}

func (x *ScreenOut) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// The response returned to the device if the user has triggered a Device
// Action. For example, a device which supports the query *Turn on the light*
// would receive a `DeviceAction` with a JSON payload containing the semantics
// of the request.
type DeviceAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// JSON containing the device command response generated from the triggered
	// Device Action grammar. The format is given by the
	// `action.devices.EXECUTE` intent for a given
	// [trait](https://developers.google.com/assistant/sdk/reference/traits/).
	DeviceRequestJson string `protobuf:"bytes,1,opt,name=device_request_json,json=deviceRequestJson,proto3" json:"device_request_json,omitempty"`
}

func (x *DeviceAction) Reset() {
	*x = DeviceAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceAction) ProtoMessage() {}

func (x *DeviceAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceAction.ProtoReflect.Descriptor instead.
func (*DeviceAction) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{11}
}

func (x *DeviceAction) GetDeviceRequestJson() string {
	if x != nil {
		return x.DeviceRequestJson
	}
	return ""
}

// The estimated transcription of a phrase the user has spoken. This could be
// a single segment or the full guess of the user's spoken query.
type SpeechRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// *Output-only* An estimate of the likelihood that the Assistant will not
	// change its guess about this result. Values range from 0.0 (completely
	// unstable) to 1.0 (completely stable and final). The default of 0.0 is a
	// sentinel value indicating `stability` was not set.
	Stability float32 `protobuf:"fixed32,2,opt,name=stability,proto3" json:"stability,omitempty"`
}

func (x *SpeechRecognitionResult) Reset() {
	*x = SpeechRecognitionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionResult) ProtoMessage() {}

func (x *SpeechRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionResult.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{12}
}

func (x *SpeechRecognitionResult) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *SpeechRecognitionResult) GetStability() float32 {
	if x != nil {
		return x.Stability
	}
	return 0
}

// The dialog state resulting from the user's query. Multiple of these messages
// may be received.
type DialogStateOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* Supplemental display text from the Assistant. This could be
	// the same as the speech spoken in `AssistResponse.audio_out` or it could
	// be some additional information which aids the user's understanding.
	SupplementalDisplayText string `protobuf:"bytes,1,opt,name=supplemental_display_text,json=supplementalDisplayText,proto3" json:"supplemental_display_text,omitempty"`
	// *Output-only* State information for the subsequent `Assist` RPC. This
	// value should be saved in the client and returned in the
	// [`DialogStateIn.conversation_state`](#dialogstatein) field with the next
	// `Assist` RPC. (The client does not need to interpret or otherwise use this
	// value.) This information should be saved across device reboots. However,
	// this value should be cleared (not saved in the client) during a
	// factory-default reset.
	ConversationState []byte `protobuf:"bytes,2,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Output-only* Specifies the mode of the microphone after this `Assist`
	// RPC is processed.
	MicrophoneMode DialogStateOut_MicrophoneMode `protobuf:"varint,3,opt,name=microphone_mode,json=microphoneMode,proto3,enum=google.assistant.embedded.v1alpha2.DialogStateOut_MicrophoneMode" json:"microphone_mode,omitempty"`
	// *Output-only* Updated volume level. The value will be 0 or omitted
	// (indicating no change) unless a voice command such as *Increase the volume*
	// or *Set volume level 4* was recognized, in which case the value will be
	// between 1 and 100 (corresponding to the new volume level of 1% to 100%).
	// Typically, a client should use this volume level when playing the
	// `audio_out` data, and retain this value as the current volume level and
	// supply it in the `AudioOutConfig` of the next `AssistRequest`. (Some
	// clients may also implement other ways to allow the current volume level to
	// be changed, for example, by providing a knob that the user can turn.)
	VolumePercentage int32 `protobuf:"varint,4,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
}

func (x *DialogStateOut) Reset() {
	*x = DialogStateOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogStateOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogStateOut) ProtoMessage() {}

func (x *DialogStateOut) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogStateOut.ProtoReflect.Descriptor instead.
func (*DialogStateOut) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{13}
}

func (x *DialogStateOut) GetSupplementalDisplayText() string {
	if x != nil {
		return x.SupplementalDisplayText
	}
	return ""
}

func (x *DialogStateOut) GetConversationState() []byte {
	if x != nil {
		return x.ConversationState
	}
	return nil
}

func (x *DialogStateOut) GetMicrophoneMode() DialogStateOut_MicrophoneMode {
	if x != nil {
		return x.MicrophoneMode
	}
	return DialogStateOut_MICROPHONE_MODE_UNSPECIFIED
}

func (x *DialogStateOut) GetVolumePercentage() int32 {
	if x != nil {
		return x.VolumePercentage
	}
	return 0
}

// Debugging parameters for the current request.
type DebugConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When this field is set to true, the `debug_info` field in `AssistResponse`
	// may be populated. However it will significantly increase latency of
	// responses. Do not set this field true in production code.
	ReturnDebugInfo bool `protobuf:"varint,6,opt,name=return_debug_info,json=returnDebugInfo,proto3" json:"return_debug_info,omitempty"`
}

func (x *DebugConfig) Reset() {
	*x = DebugConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugConfig) ProtoMessage() {}

func (x *DebugConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugConfig.ProtoReflect.Descriptor instead.
func (*DebugConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{14}
}

func (x *DebugConfig) GetReturnDebugInfo() bool {
	if x != nil {
		return x.ReturnDebugInfo
	}
	return false
}

// There are three sources of locations. They are used with this precedence:
//
//  1. This `DeviceLocation`, which is primarily used for mobile devices with
//     GPS .
//  2. Location specified by the user during device setup; this is per-user, per
//     device. This location is used if `DeviceLocation` is not specified.
//  3. Inferred location based on IP address. This is used only if neither of the
//     above are specified.
type DeviceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*DeviceLocation_Coordinates
	Type isDeviceLocation_Type `protobuf_oneof:"type"`
}

func (x *DeviceLocation) Reset() {
	*x = DeviceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceLocation) ProtoMessage() {}

func (x *DeviceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceLocation.ProtoReflect.Descriptor instead.
func (*DeviceLocation) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP(), []int{15}
}

func (m *DeviceLocation) GetType() isDeviceLocation_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *DeviceLocation) GetCoordinates() *latlng.LatLng {
	if x, ok := x.GetType().(*DeviceLocation_Coordinates); ok {
		return x.Coordinates
	}
	return nil
}

type isDeviceLocation_Type interface {
	isDeviceLocation_Type()
}

type DeviceLocation_Coordinates struct {
	// Latitude and longitude of device.
	Coordinates *latlng.LatLng `protobuf:"bytes,1,opt,name=coordinates,proto3,oneof"`
}

func (*DeviceLocation_Coordinates) isDeviceLocation_Type() {}

var File_google_assistant_embedded_v1alpha2_embedded_assistant_proto protoreflect.FileDescriptor

var file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x2f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74,
	0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x80, 0x01, 0x0a, 0x0d, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x49, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xac, 0x05, 0x0a,
	0x0e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5b, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x09,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x52, 0x08, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x73, 0x63, 0x72, 0x65, 0x65,
	0x6e, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74, 0x52, 0x09, 0x73, 0x63, 0x72, 0x65,
	0x65, 0x6e, 0x4f, 0x75, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x0d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x5c, 0x0a, 0x10, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x75, 0x74, 0x52, 0x0e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x75, 0x74, 0x12, 0x4c,
	0x0a, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x09, 0x64, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x3d, 0x0a, 0x09,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f,
	0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x22, 0x49, 0x0a, 0x09, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3c, 0x0a, 0x1b, 0x61, 0x6f, 0x67, 0x5f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x61,
	0x6f, 0x67, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x4a, 0x73, 0x6f, 0x6e, 0x22, 0xd9, 0x04, 0x0a, 0x0c, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0f, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x5c, 0x0a, 0x10, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x6f,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x11, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x6f, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0f, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x0f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x52, 0x0d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x12,
	0x55, 0x0a, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0c, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x49, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74,
	0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52,
	0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x22, 0x3c, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x46, 0x4c, 0x41, 0x43, 0x10, 0x02, 0x22, 0x90, 0x02, 0x0a, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x08, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x2b,
	0x0a, 0x11, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x22, 0x4c, 0x0a, 0x08, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12,
	0x07, 0x0a, 0x03, 0x4d, 0x50, 0x33, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x50, 0x55, 0x53,
	0x5f, 0x49, 0x4e, 0x5f, 0x4f, 0x47, 0x47, 0x10, 0x03, 0x22, 0xb3, 0x01, 0x0a, 0x0f, 0x53, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a,
	0x0b, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x0a, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x3f,
	0x0a, 0x0a, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x53, 0x43, 0x52, 0x45, 0x45, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4c, 0x41, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22,
	0xf0, 0x01, 0x0a, 0x0d, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x5b, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x73, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x11, 0x69, 0x73, 0x4e, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x53, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x26, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0x29, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x4f, 0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x44, 0x61,
	0x74, 0x61, 0x22, 0x99, 0x01, 0x0a, 0x09, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74,
	0x12, 0x4c, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x4f, 0x75, 0x74, 0x2e,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x2a, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x54, 0x4d, 0x4c, 0x10, 0x01, 0x22, 0x3e,
	0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e,
	0x0a, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4a, 0x73, 0x6f, 0x6e, 0x22, 0x57,
	0x0a, 0x17, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xf3, 0x02, 0x0a, 0x0e, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x75, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x75,
	0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x73,
	0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6a, 0x0a, 0x0f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68,
	0x6f, 0x6e, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f,
	0x75, 0x74, 0x2e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x0e, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x2b, 0x0a, 0x11, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x22, 0x5d,
	0x0a, 0x0e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x4d, 0x49, 0x43, 0x52, 0x4f,
	0x50, 0x48, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x49, 0x41, 0x4c, 0x4f,
	0x47, 0x5f, 0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x39, 0x0a,
	0x0b, 0x44, 0x65, 0x62, 0x75, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x51, 0x0a, 0x0e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x0b, 0x63, 0x6f,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61,
	0x74, 0x4c, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x32, 0x88, 0x01, 0x0a, 0x11,
	0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x12, 0x73, 0x0a, 0x06, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x42, 0x8f, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x42, 0x0e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x2f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0xa2,
	0x02, 0x06, 0x41, 0x53, 0x54, 0x53, 0x44, 0x4b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescOnce sync.Once
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescData = file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDesc
)

func file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescGZIP() []byte {
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescOnce.Do(func() {
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescData)
	})
	return file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDescData
}

var file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_goTypes = []interface{}{
	(AssistResponse_EventType)(0),      // 0: google.assistant.embedded.v1alpha2.AssistResponse.EventType
	(AudioInConfig_Encoding)(0),        // 1: google.assistant.embedded.v1alpha2.AudioInConfig.Encoding
	(AudioOutConfig_Encoding)(0),       // 2: google.assistant.embedded.v1alpha2.AudioOutConfig.Encoding
	(ScreenOutConfig_ScreenMode)(0),    // 3: google.assistant.embedded.v1alpha2.ScreenOutConfig.ScreenMode
	(ScreenOut_Format)(0),              // 4: google.assistant.embedded.v1alpha2.ScreenOut.Format
	(DialogStateOut_MicrophoneMode)(0), // 5: google.assistant.embedded.v1alpha2.DialogStateOut.MicrophoneMode
	(*AssistRequest)(nil),              // 6: google.assistant.embedded.v1alpha2.AssistRequest
	(*AssistResponse)(nil),             // 7: google.assistant.embedded.v1alpha2.AssistResponse
	(*DebugInfo)(nil),                  // 8: google.assistant.embedded.v1alpha2.DebugInfo
	(*AssistConfig)(nil),               // 9: google.assistant.embedded.v1alpha2.AssistConfig
	(*AudioInConfig)(nil),              // 10: google.assistant.embedded.v1alpha2.AudioInConfig
	(*AudioOutConfig)(nil),             // 11: google.assistant.embedded.v1alpha2.AudioOutConfig
	(*ScreenOutConfig)(nil),            // 12: google.assistant.embedded.v1alpha2.ScreenOutConfig
	(*DialogStateIn)(nil),              // 13: google.assistant.embedded.v1alpha2.DialogStateIn
	(*DeviceConfig)(nil),               // 14: google.assistant.embedded.v1alpha2.DeviceConfig
	(*AudioOut)(nil),                   // 15: google.assistant.embedded.v1alpha2.AudioOut
	(*ScreenOut)(nil),                  // 16: google.assistant.embedded.v1alpha2.ScreenOut
	(*DeviceAction)(nil),               // 17: google.assistant.embedded.v1alpha2.DeviceAction
	(*SpeechRecognitionResult)(nil),    // 18: google.assistant.embedded.v1alpha2.SpeechRecognitionResult
	(*DialogStateOut)(nil),             // 19: google.assistant.embedded.v1alpha2.DialogStateOut
	(*DebugConfig)(nil),                // 20: google.assistant.embedded.v1alpha2.DebugConfig
	(*DeviceLocation)(nil),             // 21: google.assistant.embedded.v1alpha2.DeviceLocation
	(*latlng.LatLng)(nil),              // 22: google.type.LatLng
}
var file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_depIdxs = []int32{
	9,  // 0: google.assistant.embedded.v1alpha2.AssistRequest.config:type_name -> google.assistant.embedded.v1alpha2.AssistConfig
	0,  // 1: google.assistant.embedded.v1alpha2.AssistResponse.event_type:type_name -> google.assistant.embedded.v1alpha2.AssistResponse.EventType
	15, // 2: google.assistant.embedded.v1alpha2.AssistResponse.audio_out:type_name -> google.assistant.embedded.v1alpha2.AudioOut
	16, // 3: google.assistant.embedded.v1alpha2.AssistResponse.screen_out:type_name -> google.assistant.embedded.v1alpha2.ScreenOut
	17, // 4: google.assistant.embedded.v1alpha2.AssistResponse.device_action:type_name -> google.assistant.embedded.v1alpha2.DeviceAction
	18, // 5: google.assistant.embedded.v1alpha2.AssistResponse.speech_results:type_name -> google.assistant.embedded.v1alpha2.SpeechRecognitionResult
	19, // 6: google.assistant.embedded.v1alpha2.AssistResponse.dialog_state_out:type_name -> google.assistant.embedded.v1alpha2.DialogStateOut
	8,  // 7: google.assistant.embedded.v1alpha2.AssistResponse.debug_info:type_name -> google.assistant.embedded.v1alpha2.DebugInfo
	10, // 8: google.assistant.embedded.v1alpha2.AssistConfig.audio_in_config:type_name -> google.assistant.embedded.v1alpha2.AudioInConfig
	11, // 9: google.assistant.embedded.v1alpha2.AssistConfig.audio_out_config:type_name -> google.assistant.embedded.v1alpha2.AudioOutConfig
	12, // 10: google.assistant.embedded.v1alpha2.AssistConfig.screen_out_config:type_name -> google.assistant.embedded.v1alpha2.ScreenOutConfig
	13, // 11: google.assistant.embedded.v1alpha2.AssistConfig.dialog_state_in:type_name -> google.assistant.embedded.v1alpha2.DialogStateIn
	14, // 12: google.assistant.embedded.v1alpha2.AssistConfig.device_config:type_name -> google.assistant.embedded.v1alpha2.DeviceConfig
	20, // 13: google.assistant.embedded.v1alpha2.AssistConfig.debug_config:type_name -> google.assistant.embedded.v1alpha2.DebugConfig
	1,  // 14: google.assistant.embedded.v1alpha2.AudioInConfig.encoding:type_name -> google.assistant.embedded.v1alpha2.AudioInConfig.Encoding
	2,  // 15: google.assistant.embedded.v1alpha2.AudioOutConfig.encoding:type_name -> google.assistant.embedded.v1alpha2.AudioOutConfig.Encoding
	3,  // 16: google.assistant.embedded.v1alpha2.ScreenOutConfig.screen_mode:type_name -> google.assistant.embedded.v1alpha2.ScreenOutConfig.ScreenMode
	21, // 17: google.assistant.embedded.v1alpha2.DialogStateIn.device_location:type_name -> google.assistant.embedded.v1alpha2.DeviceLocation
	4,  // 18: google.assistant.embedded.v1alpha2.ScreenOut.format:type_name -> google.assistant.embedded.v1alpha2.ScreenOut.Format
	5,  // 19: google.assistant.embedded.v1alpha2.DialogStateOut.microphone_mode:type_name -> google.assistant.embedded.v1alpha2.DialogStateOut.MicrophoneMode
	22, // 20: google.assistant.embedded.v1alpha2.DeviceLocation.coordinates:type_name -> google.type.LatLng
	6,  // 21: google.assistant.embedded.v1alpha2.EmbeddedAssistant.Assist:input_type -> google.assistant.embedded.v1alpha2.AssistRequest
	7,  // 22: google.assistant.embedded.v1alpha2.EmbeddedAssistant.Assist:output_type -> google.assistant.embedded.v1alpha2.AssistResponse
	22, // [22:23] is the sub-list for method output_type
	21, // [21:22] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_init() }
func file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_init() {
	if File_google_assistant_embedded_v1alpha2_embedded_assistant_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssistRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssistResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssistConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioInConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioOutConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScreenOutConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogStateIn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScreenOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechRecognitionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogStateOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AssistRequest_Config)(nil),
		(*AssistRequest_AudioIn)(nil),
	}
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*AssistConfig_AudioInConfig)(nil),
		(*AssistConfig_TextQuery)(nil),
	}
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*DeviceLocation_Coordinates)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_goTypes,
		DependencyIndexes: file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_depIdxs,
		EnumInfos:         file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_enumTypes,
		MessageInfos:      file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_msgTypes,
	}.Build()
	File_google_assistant_embedded_v1alpha2_embedded_assistant_proto = out.File
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_rawDesc = nil
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_goTypes = nil
	file_google_assistant_embedded_v1alpha2_embedded_assistant_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EmbeddedAssistantClient is the client API for EmbeddedAssistant service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EmbeddedAssistantClient interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error)
}

type embeddedAssistantClient struct {
	cc grpc.ClientConnInterface
}

func NewEmbeddedAssistantClient(cc grpc.ClientConnInterface) EmbeddedAssistantClient {
	return &embeddedAssistantClient{cc}
}

func (c *embeddedAssistantClient) Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error) {
	stream, err := c.cc.NewStream(ctx, &_EmbeddedAssistant_serviceDesc.Streams[0], "/google.assistant.embedded.v1alpha2.EmbeddedAssistant/Assist", opts...)
	if err != nil {
		return nil, err
	}
	x := &embeddedAssistantAssistClient{stream}
	return x, nil
}

type EmbeddedAssistant_AssistClient interface {
	Send(*AssistRequest) error
	Recv() (*AssistResponse, error)
	grpc.ClientStream
}

type embeddedAssistantAssistClient struct {
	grpc.ClientStream
}

func (x *embeddedAssistantAssistClient) Send(m *AssistRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *embeddedAssistantAssistClient) Recv() (*AssistResponse, error) {
	m := new(AssistResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// EmbeddedAssistantServer is the server API for EmbeddedAssistant service.
type EmbeddedAssistantServer interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(EmbeddedAssistant_AssistServer) error
}

// UnimplementedEmbeddedAssistantServer can be embedded to have forward compatible implementations.
type UnimplementedEmbeddedAssistantServer struct {
}

func (*UnimplementedEmbeddedAssistantServer) Assist(EmbeddedAssistant_AssistServer) error {
	return status.Errorf(codes.Unimplemented, "method Assist not implemented")
}

func RegisterEmbeddedAssistantServer(s *grpc.Server, srv EmbeddedAssistantServer) {
	s.RegisterService(&_EmbeddedAssistant_serviceDesc, srv)
}

func _EmbeddedAssistant_Assist_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(EmbeddedAssistantServer).Assist(&embeddedAssistantAssistServer{stream})
}

type EmbeddedAssistant_AssistServer interface {
	Send(*AssistResponse) error
	Recv() (*AssistRequest, error)
	grpc.ServerStream
}

type embeddedAssistantAssistServer struct {
	grpc.ServerStream
}

func (x *embeddedAssistantAssistServer) Send(m *AssistResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *embeddedAssistantAssistServer) Recv() (*AssistRequest, error) {
	m := new(AssistRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _EmbeddedAssistant_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.assistant.embedded.v1alpha2.EmbeddedAssistant",
	HandlerType: (*EmbeddedAssistantServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Assist",
			Handler:       _EmbeddedAssistant_Assist_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/assistant/embedded/v1alpha2/embedded_assistant.proto",
}
