// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/ruleset_service_request.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for RuleSetService.CreateRuleSet.
type CreateRuleSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent name.
	// Format: projects/{project_number}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The rule set to create.
	RuleSet *RuleSet `protobuf:"bytes,2,opt,name=rule_set,json=ruleSet,proto3" json:"rule_set,omitempty"`
}

func (x *CreateRuleSetRequest) Reset() {
	*x = CreateRuleSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRuleSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRuleSetRequest) ProtoMessage() {}

func (x *CreateRuleSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRuleSetRequest.ProtoReflect.Descriptor instead.
func (*CreateRuleSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRuleSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRuleSetRequest) GetRuleSet() *RuleSet {
	if x != nil {
		return x.RuleSet
	}
	return nil
}

// Request message for RuleSetService.GetRuleSet.
type GetRuleSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the rule set to retrieve.
	// Format:
	// projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRuleSetRequest) Reset() {
	*x = GetRuleSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRuleSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRuleSetRequest) ProtoMessage() {}

func (x *GetRuleSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRuleSetRequest.ProtoReflect.Descriptor instead.
func (*GetRuleSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{1}
}

func (x *GetRuleSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for RuleSetService.UpdateRuleSet.
type UpdateRuleSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the rule set to update.
	// Format:
	// projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The rule set to update.
	RuleSet *RuleSet `protobuf:"bytes,2,opt,name=rule_set,json=ruleSet,proto3" json:"rule_set,omitempty"`
}

func (x *UpdateRuleSetRequest) Reset() {
	*x = UpdateRuleSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRuleSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRuleSetRequest) ProtoMessage() {}

func (x *UpdateRuleSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRuleSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateRuleSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateRuleSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateRuleSetRequest) GetRuleSet() *RuleSet {
	if x != nil {
		return x.RuleSet
	}
	return nil
}

// Request message for RuleSetService.DeleteRuleSet.
type DeleteRuleSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the rule set to delete.
	// Format:
	// projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRuleSetRequest) Reset() {
	*x = DeleteRuleSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRuleSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRuleSetRequest) ProtoMessage() {}

func (x *DeleteRuleSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRuleSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteRuleSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteRuleSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for RuleSetService.ListRuleSets.
type ListRuleSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of document.
	// Format: projects/{project_number}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of rule sets to return. The service may return
	// fewer than this value.
	// If unspecified, at most 50 rule sets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListRuleSets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListRuleSets`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRuleSetsRequest) Reset() {
	*x = ListRuleSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleSetsRequest) ProtoMessage() {}

func (x *ListRuleSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleSetsRequest.ProtoReflect.Descriptor instead.
func (*ListRuleSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{4}
}

func (x *ListRuleSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuleSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuleSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for RuleSetService.ListRuleSets.
type ListRuleSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule sets from the specified parent.
	RuleSets []*RuleSet `protobuf:"bytes,1,rep,name=rule_sets,json=ruleSets,proto3" json:"rule_sets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRuleSetsResponse) Reset() {
	*x = ListRuleSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuleSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuleSetsResponse) ProtoMessage() {}

func (x *ListRuleSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuleSetsResponse.ProtoReflect.Descriptor instead.
func (*ListRuleSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{5}
}

func (x *ListRuleSetsResponse) GetRuleSets() []*RuleSet {
	if x != nil {
		return x.RuleSets
	}
	return nil
}

func (x *ListRuleSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for RuleSetService.ProcessAsyncRuleSets.
type ProcessAsyncRuleSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Location under which all async rules are stored.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. The frequency category of async rules to process.
	Schedule Schedule `protobuf:"varint,2,opt,name=schedule,proto3,enum=google.cloud.contentwarehouse.v1.Schedule" json:"schedule,omitempty"`
	// Optional. Timestamp to override inferred execution time.
	ExecutionTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=execution_time,json=executionTime,proto3" json:"execution_time,omitempty"`
	// Optional. Document name filter to process only a subset of Documents.
	DocumentNames []string `protobuf:"bytes,4,rep,name=document_names,json=documentNames,proto3" json:"document_names,omitempty"`
}

func (x *ProcessAsyncRuleSetsRequest) Reset() {
	*x = ProcessAsyncRuleSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessAsyncRuleSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessAsyncRuleSetsRequest) ProtoMessage() {}

func (x *ProcessAsyncRuleSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessAsyncRuleSetsRequest.ProtoReflect.Descriptor instead.
func (*ProcessAsyncRuleSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{6}
}

func (x *ProcessAsyncRuleSetsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ProcessAsyncRuleSetsRequest) GetSchedule() Schedule {
	if x != nil {
		return x.Schedule
	}
	return Schedule_SCHEDULE_UNSPECIFIED
}

func (x *ProcessAsyncRuleSetsRequest) GetExecutionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExecutionTime
	}
	return nil
}

func (x *ProcessAsyncRuleSetsRequest) GetDocumentNames() []string {
	if x != nil {
		return x.DocumentNames
	}
	return nil
}

// Response message for RuleSetService.ProcessAsyncRuleSets.
type ProcessAsyncRuleSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the processing of asynchronous policies was entirely
	// successful.
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// Contains the errors encountered during the processing of asynchronous
	// policies.
	Errors []*RuleEngineOutput `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ProcessAsyncRuleSetsResponse) Reset() {
	*x = ProcessAsyncRuleSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessAsyncRuleSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessAsyncRuleSetsResponse) ProtoMessage() {}

func (x *ProcessAsyncRuleSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessAsyncRuleSetsResponse.ProtoReflect.Descriptor instead.
func (*ProcessAsyncRuleSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP(), []int{7}
}

func (x *ProcessAsyncRuleSetsResponse) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

func (x *ProcessAsyncRuleSetsResponse) GetErrors() []*RuleEngineOutput {
	if x != nil {
		return x.Errors
	}
	return nil
}

var File_google_cloud_contentwarehouse_v1_ruleset_service_request_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xab, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x22, 0x58, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x14,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x75, 0x6c,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x75, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x22, 0x5b, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x29, 0x0a, 0x27, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x86, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd9, 0x02, 0x0a, 0x1b, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x1c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x4a, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x42, 0x96, 0x01, 0x0a, 0x24,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescData = file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_goTypes = []interface{}{
	(*CreateRuleSetRequest)(nil),         // 0: google.cloud.contentwarehouse.v1.CreateRuleSetRequest
	(*GetRuleSetRequest)(nil),            // 1: google.cloud.contentwarehouse.v1.GetRuleSetRequest
	(*UpdateRuleSetRequest)(nil),         // 2: google.cloud.contentwarehouse.v1.UpdateRuleSetRequest
	(*DeleteRuleSetRequest)(nil),         // 3: google.cloud.contentwarehouse.v1.DeleteRuleSetRequest
	(*ListRuleSetsRequest)(nil),          // 4: google.cloud.contentwarehouse.v1.ListRuleSetsRequest
	(*ListRuleSetsResponse)(nil),         // 5: google.cloud.contentwarehouse.v1.ListRuleSetsResponse
	(*ProcessAsyncRuleSetsRequest)(nil),  // 6: google.cloud.contentwarehouse.v1.ProcessAsyncRuleSetsRequest
	(*ProcessAsyncRuleSetsResponse)(nil), // 7: google.cloud.contentwarehouse.v1.ProcessAsyncRuleSetsResponse
	(*RuleSet)(nil),                      // 8: google.cloud.contentwarehouse.v1.RuleSet
	(Schedule)(0),                        // 9: google.cloud.contentwarehouse.v1.Schedule
	(*timestamppb.Timestamp)(nil),        // 10: google.protobuf.Timestamp
	(*RuleEngineOutput)(nil),             // 11: google.cloud.contentwarehouse.v1.RuleEngineOutput
}
var file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_depIdxs = []int32{
	8,  // 0: google.cloud.contentwarehouse.v1.CreateRuleSetRequest.rule_set:type_name -> google.cloud.contentwarehouse.v1.RuleSet
	8,  // 1: google.cloud.contentwarehouse.v1.UpdateRuleSetRequest.rule_set:type_name -> google.cloud.contentwarehouse.v1.RuleSet
	8,  // 2: google.cloud.contentwarehouse.v1.ListRuleSetsResponse.rule_sets:type_name -> google.cloud.contentwarehouse.v1.RuleSet
	9,  // 3: google.cloud.contentwarehouse.v1.ProcessAsyncRuleSetsRequest.schedule:type_name -> google.cloud.contentwarehouse.v1.Schedule
	10, // 4: google.cloud.contentwarehouse.v1.ProcessAsyncRuleSetsRequest.execution_time:type_name -> google.protobuf.Timestamp
	11, // 5: google.cloud.contentwarehouse.v1.ProcessAsyncRuleSetsResponse.errors:type_name -> google.cloud.contentwarehouse.v1.RuleEngineOutput
	6,  // [6:6] is the sub-list for method output_type
	6,  // [6:6] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_init() }
func file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_init() {
	if File_google_cloud_contentwarehouse_v1_ruleset_service_request_proto != nil {
		return
	}
	file_google_cloud_contentwarehouse_v1_rule_engine_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRuleSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRuleSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRuleSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRuleSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuleSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessAsyncRuleSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessAsyncRuleSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_depIdxs,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_ruleset_service_request_proto = out.File
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_ruleset_service_request_proto_depIdxs = nil
}
