// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/document_schema.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A document schema used to define document structure.
type DocumentSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the document schema.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
	//
	// The name is ignored when creating a document schema.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Name of the schema given by the user. Must be unique per customer.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Document details.
	PropertyDefinitions []*PropertyDefinition `protobuf:"bytes,3,rep,name=property_definitions,json=propertyDefinitions,proto3" json:"property_definitions,omitempty"`
	// Document Type, true refers the document is a folder, otherwise it is
	// a typical document.
	DocumentIsFolder bool `protobuf:"varint,4,opt,name=document_is_folder,json=documentIsFolder,proto3" json:"document_is_folder,omitempty"`
	// Output only. The time when the document schema is last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time when the document schema is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Schema description.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *DocumentSchema) Reset() {
	*x = DocumentSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentSchema) ProtoMessage() {}

func (x *DocumentSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentSchema.ProtoReflect.Descriptor instead.
func (*DocumentSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{0}
}

func (x *DocumentSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DocumentSchema) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DocumentSchema) GetPropertyDefinitions() []*PropertyDefinition {
	if x != nil {
		return x.PropertyDefinitions
	}
	return nil
}

func (x *DocumentSchema) GetDocumentIsFolder() bool {
	if x != nil {
		return x.DocumentIsFolder
	}
	return false
}

func (x *DocumentSchema) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DocumentSchema) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DocumentSchema) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Defines the metadata for a schema property.
//
// Next ID: 18
type PropertyDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the metadata property.
	// Must be unique within a document schema and is case insensitive.
	// Names must be non-blank, start with a letter, and can contain alphanumeric
	// characters and: /, :, -, _, and .
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display-name for the property, used for front-end.
	DisplayName string `protobuf:"bytes,12,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Whether the property can have multiple values.
	IsRepeatable bool `protobuf:"varint,2,opt,name=is_repeatable,json=isRepeatable,proto3" json:"is_repeatable,omitempty"`
	// Whether the property can be filtered. If this is a sub-property, all the
	// parent properties must be marked filterable.
	IsFilterable bool `protobuf:"varint,3,opt,name=is_filterable,json=isFilterable,proto3" json:"is_filterable,omitempty"`
	// Indicates that the property should be included in a global search.
	IsSearchable bool `protobuf:"varint,4,opt,name=is_searchable,json=isSearchable,proto3" json:"is_searchable,omitempty"`
	// Whether the property is user supplied metadata.
	IsMetadata bool `protobuf:"varint,5,opt,name=is_metadata,json=isMetadata,proto3" json:"is_metadata,omitempty"`
	// Whether the property is mandatory.
	// Default is 'false', i.e. populating property value can be skipped.
	// If 'true' then user must populate the value for this property.
	IsRequired bool `protobuf:"varint,14,opt,name=is_required,json=isRequired,proto3" json:"is_required,omitempty"`
	// Type of the property.
	//
	// Types that are assignable to ValueTypeOptions:
	//
	//	*PropertyDefinition_IntegerTypeOptions
	//	*PropertyDefinition_FloatTypeOptions
	//	*PropertyDefinition_TextTypeOptions
	//	*PropertyDefinition_PropertyTypeOptions
	//	*PropertyDefinition_EnumTypeOptions
	//	*PropertyDefinition_DateTimeTypeOptions
	//	*PropertyDefinition_MapTypeOptions
	//	*PropertyDefinition_TimestampTypeOptions
	//	*PropertyDefinition_BooleanTypeOptions
	ValueTypeOptions isPropertyDefinition_ValueTypeOptions `protobuf_oneof:"value_type_options"`
}

func (x *PropertyDefinition) Reset() {
	*x = PropertyDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyDefinition) ProtoMessage() {}

func (x *PropertyDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyDefinition.ProtoReflect.Descriptor instead.
func (*PropertyDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{1}
}

func (x *PropertyDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PropertyDefinition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PropertyDefinition) GetIsRepeatable() bool {
	if x != nil {
		return x.IsRepeatable
	}
	return false
}

func (x *PropertyDefinition) GetIsFilterable() bool {
	if x != nil {
		return x.IsFilterable
	}
	return false
}

func (x *PropertyDefinition) GetIsSearchable() bool {
	if x != nil {
		return x.IsSearchable
	}
	return false
}

func (x *PropertyDefinition) GetIsMetadata() bool {
	if x != nil {
		return x.IsMetadata
	}
	return false
}

func (x *PropertyDefinition) GetIsRequired() bool {
	if x != nil {
		return x.IsRequired
	}
	return false
}

func (m *PropertyDefinition) GetValueTypeOptions() isPropertyDefinition_ValueTypeOptions {
	if m != nil {
		return m.ValueTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetIntegerTypeOptions() *IntegerTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_IntegerTypeOptions); ok {
		return x.IntegerTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetFloatTypeOptions() *FloatTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_FloatTypeOptions); ok {
		return x.FloatTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetTextTypeOptions() *TextTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_TextTypeOptions); ok {
		return x.TextTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetPropertyTypeOptions() *PropertyTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_PropertyTypeOptions); ok {
		return x.PropertyTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetEnumTypeOptions() *EnumTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_EnumTypeOptions); ok {
		return x.EnumTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetDateTimeTypeOptions() *DateTimeTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_DateTimeTypeOptions); ok {
		return x.DateTimeTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetMapTypeOptions() *MapTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_MapTypeOptions); ok {
		return x.MapTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetTimestampTypeOptions() *TimestampTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_TimestampTypeOptions); ok {
		return x.TimestampTypeOptions
	}
	return nil
}

func (x *PropertyDefinition) GetBooleanTypeOptions() *BooleanTypeOptions {
	if x, ok := x.GetValueTypeOptions().(*PropertyDefinition_BooleanTypeOptions); ok {
		return x.BooleanTypeOptions
	}
	return nil
}

type isPropertyDefinition_ValueTypeOptions interface {
	isPropertyDefinition_ValueTypeOptions()
}

type PropertyDefinition_IntegerTypeOptions struct {
	// Integer property.
	IntegerTypeOptions *IntegerTypeOptions `protobuf:"bytes,7,opt,name=integer_type_options,json=integerTypeOptions,proto3,oneof"`
}

type PropertyDefinition_FloatTypeOptions struct {
	// Float property.
	FloatTypeOptions *FloatTypeOptions `protobuf:"bytes,8,opt,name=float_type_options,json=floatTypeOptions,proto3,oneof"`
}

type PropertyDefinition_TextTypeOptions struct {
	// Text/string property.
	TextTypeOptions *TextTypeOptions `protobuf:"bytes,9,opt,name=text_type_options,json=textTypeOptions,proto3,oneof"`
}

type PropertyDefinition_PropertyTypeOptions struct {
	// Nested structured data property.
	PropertyTypeOptions *PropertyTypeOptions `protobuf:"bytes,10,opt,name=property_type_options,json=propertyTypeOptions,proto3,oneof"`
}

type PropertyDefinition_EnumTypeOptions struct {
	// Enum/categorical property.
	EnumTypeOptions *EnumTypeOptions `protobuf:"bytes,11,opt,name=enum_type_options,json=enumTypeOptions,proto3,oneof"`
}

type PropertyDefinition_DateTimeTypeOptions struct {
	// Date time property.
	// It is not supported by CMEK compliant deployment.
	DateTimeTypeOptions *DateTimeTypeOptions `protobuf:"bytes,13,opt,name=date_time_type_options,json=dateTimeTypeOptions,proto3,oneof"`
}

type PropertyDefinition_MapTypeOptions struct {
	// Map property.
	MapTypeOptions *MapTypeOptions `protobuf:"bytes,15,opt,name=map_type_options,json=mapTypeOptions,proto3,oneof"`
}

type PropertyDefinition_TimestampTypeOptions struct {
	// Timestamp property.
	// It is not supported by CMEK compliant deployment.
	TimestampTypeOptions *TimestampTypeOptions `protobuf:"bytes,16,opt,name=timestamp_type_options,json=timestampTypeOptions,proto3,oneof"`
}

type PropertyDefinition_BooleanTypeOptions struct {
	// Boolean property.
	// It is not supported by CMEK compliant deployment.
	BooleanTypeOptions *BooleanTypeOptions `protobuf:"bytes,17,opt,name=boolean_type_options,json=booleanTypeOptions,proto3,oneof"`
}

func (*PropertyDefinition_IntegerTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_FloatTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_TextTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_PropertyTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_EnumTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_DateTimeTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_MapTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_TimestampTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

func (*PropertyDefinition_BooleanTypeOptions) isPropertyDefinition_ValueTypeOptions() {}

// Configurations for an integer property.
type IntegerTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IntegerTypeOptions) Reset() {
	*x = IntegerTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntegerTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntegerTypeOptions) ProtoMessage() {}

func (x *IntegerTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntegerTypeOptions.ProtoReflect.Descriptor instead.
func (*IntegerTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{2}
}

// Configurations for a float property.
type FloatTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FloatTypeOptions) Reset() {
	*x = FloatTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatTypeOptions) ProtoMessage() {}

func (x *FloatTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatTypeOptions.ProtoReflect.Descriptor instead.
func (*FloatTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{3}
}

// Configurations for a text property.
type TextTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TextTypeOptions) Reset() {
	*x = TextTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextTypeOptions) ProtoMessage() {}

func (x *TextTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextTypeOptions.ProtoReflect.Descriptor instead.
func (*TextTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{4}
}

// Configurations for a date time property.
type DateTimeTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DateTimeTypeOptions) Reset() {
	*x = DateTimeTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeTypeOptions) ProtoMessage() {}

func (x *DateTimeTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeTypeOptions.ProtoReflect.Descriptor instead.
func (*DateTimeTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{5}
}

// Configurations for a Map property.
type MapTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MapTypeOptions) Reset() {
	*x = MapTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapTypeOptions) ProtoMessage() {}

func (x *MapTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapTypeOptions.ProtoReflect.Descriptor instead.
func (*MapTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{6}
}

// Configurations for a timestamp property.
type TimestampTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TimestampTypeOptions) Reset() {
	*x = TimestampTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampTypeOptions) ProtoMessage() {}

func (x *TimestampTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampTypeOptions.ProtoReflect.Descriptor instead.
func (*TimestampTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{7}
}

// Configurations for a boolean property.
type BooleanTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BooleanTypeOptions) Reset() {
	*x = BooleanTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BooleanTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BooleanTypeOptions) ProtoMessage() {}

func (x *BooleanTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BooleanTypeOptions.ProtoReflect.Descriptor instead.
func (*BooleanTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{8}
}

// Configurations for a nested structured data property.
type PropertyTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of property definitions.
	PropertyDefinitions []*PropertyDefinition `protobuf:"bytes,1,rep,name=property_definitions,json=propertyDefinitions,proto3" json:"property_definitions,omitempty"`
}

func (x *PropertyTypeOptions) Reset() {
	*x = PropertyTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyTypeOptions) ProtoMessage() {}

func (x *PropertyTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyTypeOptions.ProtoReflect.Descriptor instead.
func (*PropertyTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{9}
}

func (x *PropertyTypeOptions) GetPropertyDefinitions() []*PropertyDefinition {
	if x != nil {
		return x.PropertyDefinitions
	}
	return nil
}

// Configurations for an enum/categorical property.
type EnumTypeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of possible enum values.
	PossibleValues []string `protobuf:"bytes,1,rep,name=possible_values,json=possibleValues,proto3" json:"possible_values,omitempty"`
}

func (x *EnumTypeOptions) Reset() {
	*x = EnumTypeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumTypeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumTypeOptions) ProtoMessage() {}

func (x *EnumTypeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumTypeOptions.ProtoReflect.Descriptor instead.
func (*EnumTypeOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP(), []int{10}
}

func (x *EnumTypeOptions) GetPossibleValues() []string {
	if x != nil {
		return x.PossibleValues
	}
	return nil
}

var File_google_cloud_contentwarehouse_v1_document_schema_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x89, 0x04, 0x0a, 0x0e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x2c, 0x0a, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x73, 0x5f, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x7d, 0x22, 0xba, 0x09, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x70,
	0x65, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69,
	0x73, 0x52, 0x65, 0x70, 0x65, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69,
	0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x68, 0x0a, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x62, 0x0a, 0x12, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x10, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x65, 0x78, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6b, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6c, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x61, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00,
	0x52, 0x0e, 0x6d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x6e, 0x0a, 0x16, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x14, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x68, 0x0a, 0x14, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x14, 0x0a, 0x12, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x12, 0x0a, 0x10, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x11, 0x0a, 0x0f, 0x54, 0x65,
	0x78, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x15, 0x0a,
	0x13, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x10, 0x0a, 0x0e, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x16, 0x0a, 0x14, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x14,
	0x0a, 0x12, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6c, 0x0a, 0x14,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x3f, 0x0a, 0x0f, 0x45, 0x6e,
	0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a,
	0x0f, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x70, 0x6f, 0x73,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x8f, 0x01, 0x0a, 0x24,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescData = file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_contentwarehouse_v1_document_schema_proto_goTypes = []interface{}{
	(*DocumentSchema)(nil),        // 0: google.cloud.contentwarehouse.v1.DocumentSchema
	(*PropertyDefinition)(nil),    // 1: google.cloud.contentwarehouse.v1.PropertyDefinition
	(*IntegerTypeOptions)(nil),    // 2: google.cloud.contentwarehouse.v1.IntegerTypeOptions
	(*FloatTypeOptions)(nil),      // 3: google.cloud.contentwarehouse.v1.FloatTypeOptions
	(*TextTypeOptions)(nil),       // 4: google.cloud.contentwarehouse.v1.TextTypeOptions
	(*DateTimeTypeOptions)(nil),   // 5: google.cloud.contentwarehouse.v1.DateTimeTypeOptions
	(*MapTypeOptions)(nil),        // 6: google.cloud.contentwarehouse.v1.MapTypeOptions
	(*TimestampTypeOptions)(nil),  // 7: google.cloud.contentwarehouse.v1.TimestampTypeOptions
	(*BooleanTypeOptions)(nil),    // 8: google.cloud.contentwarehouse.v1.BooleanTypeOptions
	(*PropertyTypeOptions)(nil),   // 9: google.cloud.contentwarehouse.v1.PropertyTypeOptions
	(*EnumTypeOptions)(nil),       // 10: google.cloud.contentwarehouse.v1.EnumTypeOptions
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
}
var file_google_cloud_contentwarehouse_v1_document_schema_proto_depIdxs = []int32{
	1,  // 0: google.cloud.contentwarehouse.v1.DocumentSchema.property_definitions:type_name -> google.cloud.contentwarehouse.v1.PropertyDefinition
	11, // 1: google.cloud.contentwarehouse.v1.DocumentSchema.update_time:type_name -> google.protobuf.Timestamp
	11, // 2: google.cloud.contentwarehouse.v1.DocumentSchema.create_time:type_name -> google.protobuf.Timestamp
	2,  // 3: google.cloud.contentwarehouse.v1.PropertyDefinition.integer_type_options:type_name -> google.cloud.contentwarehouse.v1.IntegerTypeOptions
	3,  // 4: google.cloud.contentwarehouse.v1.PropertyDefinition.float_type_options:type_name -> google.cloud.contentwarehouse.v1.FloatTypeOptions
	4,  // 5: google.cloud.contentwarehouse.v1.PropertyDefinition.text_type_options:type_name -> google.cloud.contentwarehouse.v1.TextTypeOptions
	9,  // 6: google.cloud.contentwarehouse.v1.PropertyDefinition.property_type_options:type_name -> google.cloud.contentwarehouse.v1.PropertyTypeOptions
	10, // 7: google.cloud.contentwarehouse.v1.PropertyDefinition.enum_type_options:type_name -> google.cloud.contentwarehouse.v1.EnumTypeOptions
	5,  // 8: google.cloud.contentwarehouse.v1.PropertyDefinition.date_time_type_options:type_name -> google.cloud.contentwarehouse.v1.DateTimeTypeOptions
	6,  // 9: google.cloud.contentwarehouse.v1.PropertyDefinition.map_type_options:type_name -> google.cloud.contentwarehouse.v1.MapTypeOptions
	7,  // 10: google.cloud.contentwarehouse.v1.PropertyDefinition.timestamp_type_options:type_name -> google.cloud.contentwarehouse.v1.TimestampTypeOptions
	8,  // 11: google.cloud.contentwarehouse.v1.PropertyDefinition.boolean_type_options:type_name -> google.cloud.contentwarehouse.v1.BooleanTypeOptions
	1,  // 12: google.cloud.contentwarehouse.v1.PropertyTypeOptions.property_definitions:type_name -> google.cloud.contentwarehouse.v1.PropertyDefinition
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_document_schema_proto_init() }
func file_google_cloud_contentwarehouse_v1_document_schema_proto_init() {
	if File_google_cloud_contentwarehouse_v1_document_schema_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntegerTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BooleanTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnumTypeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*PropertyDefinition_IntegerTypeOptions)(nil),
		(*PropertyDefinition_FloatTypeOptions)(nil),
		(*PropertyDefinition_TextTypeOptions)(nil),
		(*PropertyDefinition_PropertyTypeOptions)(nil),
		(*PropertyDefinition_EnumTypeOptions)(nil),
		(*PropertyDefinition_DateTimeTypeOptions)(nil),
		(*PropertyDefinition_MapTypeOptions)(nil),
		(*PropertyDefinition_TimestampTypeOptions)(nil),
		(*PropertyDefinition_BooleanTypeOptions)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_document_schema_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_document_schema_proto_depIdxs,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_document_schema_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_document_schema_proto = out.File
	file_google_cloud_contentwarehouse_v1_document_schema_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_document_schema_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_document_schema_proto_depIdxs = nil
}
