// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/appengine/v1beta/version.proto

package appengine

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Available inbound services.
type InboundServiceType int32

const (
	// Not specified.
	InboundServiceType_INBOUND_SERVICE_UNSPECIFIED InboundServiceType = 0
	// Allows an application to receive mail.
	InboundServiceType_INBOUND_SERVICE_MAIL InboundServiceType = 1
	// Allows an application to receive email-bound notifications.
	InboundServiceType_INBOUND_SERVICE_MAIL_BOUNCE InboundServiceType = 2
	// Allows an application to receive error stanzas.
	InboundServiceType_INBOUND_SERVICE_XMPP_ERROR InboundServiceType = 3
	// Allows an application to receive instant messages.
	InboundServiceType_INBOUND_SERVICE_XMPP_MESSAGE InboundServiceType = 4
	// Allows an application to receive user subscription POSTs.
	InboundServiceType_INBOUND_SERVICE_XMPP_SUBSCRIBE InboundServiceType = 5
	// Allows an application to receive a user's chat presence.
	InboundServiceType_INBOUND_SERVICE_XMPP_PRESENCE InboundServiceType = 6
	// Registers an application for notifications when a client connects or
	// disconnects from a channel.
	InboundServiceType_INBOUND_SERVICE_CHANNEL_PRESENCE InboundServiceType = 7
	// Enables warmup requests.
	InboundServiceType_INBOUND_SERVICE_WARMUP InboundServiceType = 9
)

// Enum value maps for InboundServiceType.
var (
	InboundServiceType_name = map[int32]string{
		0: "INBOUND_SERVICE_UNSPECIFIED",
		1: "INBOUND_SERVICE_MAIL",
		2: "INBOUND_SERVICE_MAIL_BOUNCE",
		3: "INBOUND_SERVICE_XMPP_ERROR",
		4: "INBOUND_SERVICE_XMPP_MESSAGE",
		5: "INBOUND_SERVICE_XMPP_SUBSCRIBE",
		6: "INBOUND_SERVICE_XMPP_PRESENCE",
		7: "INBOUND_SERVICE_CHANNEL_PRESENCE",
		9: "INBOUND_SERVICE_WARMUP",
	}
	InboundServiceType_value = map[string]int32{
		"INBOUND_SERVICE_UNSPECIFIED":      0,
		"INBOUND_SERVICE_MAIL":             1,
		"INBOUND_SERVICE_MAIL_BOUNCE":      2,
		"INBOUND_SERVICE_XMPP_ERROR":       3,
		"INBOUND_SERVICE_XMPP_MESSAGE":     4,
		"INBOUND_SERVICE_XMPP_SUBSCRIBE":   5,
		"INBOUND_SERVICE_XMPP_PRESENCE":    6,
		"INBOUND_SERVICE_CHANNEL_PRESENCE": 7,
		"INBOUND_SERVICE_WARMUP":           9,
	}
)

func (x InboundServiceType) Enum() *InboundServiceType {
	p := new(InboundServiceType)
	*p = x
	return p
}

func (x InboundServiceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InboundServiceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_version_proto_enumTypes[0].Descriptor()
}

func (InboundServiceType) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_version_proto_enumTypes[0]
}

func (x InboundServiceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InboundServiceType.Descriptor instead.
func (InboundServiceType) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{0}
}

// Run states of a version.
type ServingStatus int32

const (
	// Not specified.
	ServingStatus_SERVING_STATUS_UNSPECIFIED ServingStatus = 0
	// Currently serving. Instances are created according to the
	// scaling settings of the version.
	ServingStatus_SERVING ServingStatus = 1
	// Disabled. No instances will be created and the scaling
	// settings are ignored until the state of the version changes
	// to `SERVING`.
	ServingStatus_STOPPED ServingStatus = 2
)

// Enum value maps for ServingStatus.
var (
	ServingStatus_name = map[int32]string{
		0: "SERVING_STATUS_UNSPECIFIED",
		1: "SERVING",
		2: "STOPPED",
	}
	ServingStatus_value = map[string]int32{
		"SERVING_STATUS_UNSPECIFIED": 0,
		"SERVING":                    1,
		"STOPPED":                    2,
	}
)

func (x ServingStatus) Enum() *ServingStatus {
	p := new(ServingStatus)
	*p = x
	return p
}

func (x ServingStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServingStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_version_proto_enumTypes[1].Descriptor()
}

func (ServingStatus) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_version_proto_enumTypes[1]
}

func (x ServingStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServingStatus.Descriptor instead.
func (ServingStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{1}
}

// Available rollout strategies.
type EndpointsApiService_RolloutStrategy int32

const (
	// Not specified. Defaults to `FIXED`.
	EndpointsApiService_UNSPECIFIED_ROLLOUT_STRATEGY EndpointsApiService_RolloutStrategy = 0
	// Endpoints service configuration ID will be fixed to the configuration ID
	// specified by `config_id`.
	EndpointsApiService_FIXED EndpointsApiService_RolloutStrategy = 1
	// Endpoints service configuration ID will be updated with each rollout.
	EndpointsApiService_MANAGED EndpointsApiService_RolloutStrategy = 2
)

// Enum value maps for EndpointsApiService_RolloutStrategy.
var (
	EndpointsApiService_RolloutStrategy_name = map[int32]string{
		0: "UNSPECIFIED_ROLLOUT_STRATEGY",
		1: "FIXED",
		2: "MANAGED",
	}
	EndpointsApiService_RolloutStrategy_value = map[string]int32{
		"UNSPECIFIED_ROLLOUT_STRATEGY": 0,
		"FIXED":                        1,
		"MANAGED":                      2,
	}
)

func (x EndpointsApiService_RolloutStrategy) Enum() *EndpointsApiService_RolloutStrategy {
	p := new(EndpointsApiService_RolloutStrategy)
	*p = x
	return p
}

func (x EndpointsApiService_RolloutStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EndpointsApiService_RolloutStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_version_proto_enumTypes[2].Descriptor()
}

func (EndpointsApiService_RolloutStrategy) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_version_proto_enumTypes[2]
}

func (x EndpointsApiService_RolloutStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EndpointsApiService_RolloutStrategy.Descriptor instead.
func (EndpointsApiService_RolloutStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{1, 0}
}

// A Version resource is a specific set of source code and configuration files
// that are deployed into a service.
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full path to the Version resource in the API.  Example:
	// `apps/myapp/services/default/versions/v1`.
	//
	// @OutputOnly
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Relative name of the version within the service.  Example: `v1`.
	// Version names can contain only lowercase letters, numbers, or hyphens.
	// Reserved names: "default", "latest", and any name with the prefix "ah-".
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Controls how instances are created, scaled, and reaped.
	//
	// Defaults to `AutomaticScaling`.
	//
	// Types that are assignable to Scaling:
	//	*Version_AutomaticScaling
	//	*Version_BasicScaling
	//	*Version_ManualScaling
	Scaling isVersion_Scaling `protobuf_oneof:"scaling"`
	// Before an application can receive email or XMPP messages, the application
	// must be configured to enable the service.
	InboundServices []InboundServiceType `protobuf:"varint,6,rep,packed,name=inbound_services,json=inboundServices,proto3,enum=google.appengine.v1beta.InboundServiceType" json:"inbound_services,omitempty"`
	// Instance class that is used to run this version. Valid values are:
	//
	// * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
	// * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
	//
	// Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
	// BasicScaling.
	InstanceClass string `protobuf:"bytes,7,opt,name=instance_class,json=instanceClass,proto3" json:"instance_class,omitempty"`
	// Extra network settings.
	// Only applicable in the App Engine flexible environment.
	Network *Network `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// The Google Compute Engine zones that are supported by this version in the
	// App Engine flexible environment. Deprecated.
	Zones []string `protobuf:"bytes,118,rep,name=zones,proto3" json:"zones,omitempty"`
	// Machine resources for this version.
	// Only applicable in the App Engine flexible environment.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Desired runtime. Example: `python27`.
	Runtime string `protobuf:"bytes,10,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The channel of the runtime to use. Only available for some
	// runtimes. Defaults to the `default` channel.
	RuntimeChannel string `protobuf:"bytes,117,opt,name=runtime_channel,json=runtimeChannel,proto3" json:"runtime_channel,omitempty"`
	// Whether multiple requests can be dispatched to this version at once.
	Threadsafe bool `protobuf:"varint,11,opt,name=threadsafe,proto3" json:"threadsafe,omitempty"`
	// Whether to deploy this version in a container on a virtual machine.
	Vm bool `protobuf:"varint,12,opt,name=vm,proto3" json:"vm,omitempty"`
	// app_engine_apis allows second generation runtimes to access the
	// App Engine APIs.
	AppEngineApis bool `protobuf:"varint,128,opt,name=app_engine_apis,json=appEngineApis,proto3" json:"app_engine_apis,omitempty"`
	// Metadata settings that are supplied to this version to enable
	// beta runtime features.
	BetaSettings map[string]string `protobuf:"bytes,13,rep,name=beta_settings,json=betaSettings,proto3" json:"beta_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// App Engine execution environment for this version.
	//
	// Defaults to `standard`.
	Env string `protobuf:"bytes,14,opt,name=env,proto3" json:"env,omitempty"`
	// Current serving status of this version. Only the versions with a
	// `SERVING` status create instances and can be billed.
	//
	// `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
	ServingStatus ServingStatus `protobuf:"varint,15,opt,name=serving_status,json=servingStatus,proto3,enum=google.appengine.v1beta.ServingStatus" json:"serving_status,omitempty"`
	// Email address of the user who created this version.
	//
	// @OutputOnly
	CreatedBy string `protobuf:"bytes,16,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// Time that this version was created.
	//
	// @OutputOnly
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Total size in bytes of all the files that are included in this version
	// and currently hosted on the App Engine disk.
	//
	// @OutputOnly
	DiskUsageBytes int64 `protobuf:"varint,18,opt,name=disk_usage_bytes,json=diskUsageBytes,proto3" json:"disk_usage_bytes,omitempty"`
	// The version of the API in the given runtime environment. Please see the
	// app.yaml reference for valid values at
	// https://cloud.google.com/appengine/docs/standard/<language>/config/appref
	RuntimeApiVersion string `protobuf:"bytes,21,opt,name=runtime_api_version,json=runtimeApiVersion,proto3" json:"runtime_api_version,omitempty"`
	// The path or name of the app's main executable.
	RuntimeMainExecutablePath string `protobuf:"bytes,22,opt,name=runtime_main_executable_path,json=runtimeMainExecutablePath,proto3" json:"runtime_main_executable_path,omitempty"`
	// The identity that the deployed version will run as.
	// Admin API will use the App Engine Appspot service account as default if
	// this field is neither provided in app.yaml file nor through CLI flag.
	ServiceAccount string `protobuf:"bytes,127,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// An ordered list of URL-matching patterns that should be applied to incoming
	// requests. The first matching URL handles the request and other request
	// handlers are not attempted.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Handlers []*UrlMap `protobuf:"bytes,100,rep,name=handlers,proto3" json:"handlers,omitempty"`
	// Custom static error pages. Limited to 10KB per page.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ErrorHandlers []*ErrorHandler `protobuf:"bytes,101,rep,name=error_handlers,json=errorHandlers,proto3" json:"error_handlers,omitempty"`
	// Configuration for third-party Python runtime libraries that are required
	// by the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Libraries []*Library `protobuf:"bytes,102,rep,name=libraries,proto3" json:"libraries,omitempty"`
	// Serving configuration for
	// [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ApiConfig *ApiConfigHandler `protobuf:"bytes,103,opt,name=api_config,json=apiConfig,proto3" json:"api_config,omitempty"`
	// Environment variables available to the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	EnvVariables map[string]string `protobuf:"bytes,104,rep,name=env_variables,json=envVariables,proto3" json:"env_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Environment variables available to the build environment.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	BuildEnvVariables map[string]string `protobuf:"bytes,125,rep,name=build_env_variables,json=buildEnvVariables,proto3" json:"build_env_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Duration that static files should be cached by web proxies and browsers.
	// Only applicable if the corresponding
	// [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1beta/apps.services.versions#StaticFilesHandler)
	// does not specify its own expiration time.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	DefaultExpiration *durationpb.Duration `protobuf:"bytes,105,opt,name=default_expiration,json=defaultExpiration,proto3" json:"default_expiration,omitempty"`
	// Configures health checking for instances. Unhealthy instances are
	// stopped and replaced with new instances.
	// Only applicable in the App Engine flexible environment.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	HealthCheck *HealthCheck `protobuf:"bytes,106,opt,name=health_check,json=healthCheck,proto3" json:"health_check,omitempty"`
	// Configures readiness health checking for instances.
	// Unhealthy instances are not put into the backend traffic rotation.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ReadinessCheck *ReadinessCheck `protobuf:"bytes,112,opt,name=readiness_check,json=readinessCheck,proto3" json:"readiness_check,omitempty"`
	// Configures liveness health checking for instances.
	// Unhealthy instances are stopped and replaced with new instances
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	LivenessCheck *LivenessCheck `protobuf:"bytes,113,opt,name=liveness_check,json=livenessCheck,proto3" json:"liveness_check,omitempty"`
	// Files that match this pattern will not be built into this version.
	// Only applicable for Go runtimes.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	NobuildFilesRegex string `protobuf:"bytes,107,opt,name=nobuild_files_regex,json=nobuildFilesRegex,proto3" json:"nobuild_files_regex,omitempty"`
	// Code and application artifacts that make up this version.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Deployment *Deployment `protobuf:"bytes,108,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Serving URL for this version. Example:
	// "https://myversion-dot-myservice-dot-myapp.appspot.com"
	//
	// @OutputOnly
	VersionUrl string `protobuf:"bytes,109,opt,name=version_url,json=versionUrl,proto3" json:"version_url,omitempty"`
	// Cloud Endpoints configuration.
	//
	// If endpoints_api_service is set, the Cloud Endpoints Extensible Service
	// Proxy will be provided to serve the API implemented by the app.
	EndpointsApiService *EndpointsApiService `protobuf:"bytes,110,opt,name=endpoints_api_service,json=endpointsApiService,proto3" json:"endpoints_api_service,omitempty"`
	// The entrypoint for the application.
	Entrypoint *Entrypoint `protobuf:"bytes,122,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// Enables VPC connectivity for standard apps.
	VpcAccessConnector *VpcAccessConnector `protobuf:"bytes,121,opt,name=vpc_access_connector,json=vpcAccessConnector,proto3" json:"vpc_access_connector,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{0}
}

func (x *Version) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Version) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *Version) GetScaling() isVersion_Scaling {
	if m != nil {
		return m.Scaling
	}
	return nil
}

func (x *Version) GetAutomaticScaling() *AutomaticScaling {
	if x, ok := x.GetScaling().(*Version_AutomaticScaling); ok {
		return x.AutomaticScaling
	}
	return nil
}

func (x *Version) GetBasicScaling() *BasicScaling {
	if x, ok := x.GetScaling().(*Version_BasicScaling); ok {
		return x.BasicScaling
	}
	return nil
}

func (x *Version) GetManualScaling() *ManualScaling {
	if x, ok := x.GetScaling().(*Version_ManualScaling); ok {
		return x.ManualScaling
	}
	return nil
}

func (x *Version) GetInboundServices() []InboundServiceType {
	if x != nil {
		return x.InboundServices
	}
	return nil
}

func (x *Version) GetInstanceClass() string {
	if x != nil {
		return x.InstanceClass
	}
	return ""
}

func (x *Version) GetNetwork() *Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Version) GetZones() []string {
	if x != nil {
		return x.Zones
	}
	return nil
}

func (x *Version) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Version) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *Version) GetRuntimeChannel() string {
	if x != nil {
		return x.RuntimeChannel
	}
	return ""
}

func (x *Version) GetThreadsafe() bool {
	if x != nil {
		return x.Threadsafe
	}
	return false
}

func (x *Version) GetVm() bool {
	if x != nil {
		return x.Vm
	}
	return false
}

func (x *Version) GetAppEngineApis() bool {
	if x != nil {
		return x.AppEngineApis
	}
	return false
}

func (x *Version) GetBetaSettings() map[string]string {
	if x != nil {
		return x.BetaSettings
	}
	return nil
}

func (x *Version) GetEnv() string {
	if x != nil {
		return x.Env
	}
	return ""
}

func (x *Version) GetServingStatus() ServingStatus {
	if x != nil {
		return x.ServingStatus
	}
	return ServingStatus_SERVING_STATUS_UNSPECIFIED
}

func (x *Version) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

func (x *Version) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Version) GetDiskUsageBytes() int64 {
	if x != nil {
		return x.DiskUsageBytes
	}
	return 0
}

func (x *Version) GetRuntimeApiVersion() string {
	if x != nil {
		return x.RuntimeApiVersion
	}
	return ""
}

func (x *Version) GetRuntimeMainExecutablePath() string {
	if x != nil {
		return x.RuntimeMainExecutablePath
	}
	return ""
}

func (x *Version) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Version) GetHandlers() []*UrlMap {
	if x != nil {
		return x.Handlers
	}
	return nil
}

func (x *Version) GetErrorHandlers() []*ErrorHandler {
	if x != nil {
		return x.ErrorHandlers
	}
	return nil
}

func (x *Version) GetLibraries() []*Library {
	if x != nil {
		return x.Libraries
	}
	return nil
}

func (x *Version) GetApiConfig() *ApiConfigHandler {
	if x != nil {
		return x.ApiConfig
	}
	return nil
}

func (x *Version) GetEnvVariables() map[string]string {
	if x != nil {
		return x.EnvVariables
	}
	return nil
}

func (x *Version) GetBuildEnvVariables() map[string]string {
	if x != nil {
		return x.BuildEnvVariables
	}
	return nil
}

func (x *Version) GetDefaultExpiration() *durationpb.Duration {
	if x != nil {
		return x.DefaultExpiration
	}
	return nil
}

func (x *Version) GetHealthCheck() *HealthCheck {
	if x != nil {
		return x.HealthCheck
	}
	return nil
}

func (x *Version) GetReadinessCheck() *ReadinessCheck {
	if x != nil {
		return x.ReadinessCheck
	}
	return nil
}

func (x *Version) GetLivenessCheck() *LivenessCheck {
	if x != nil {
		return x.LivenessCheck
	}
	return nil
}

func (x *Version) GetNobuildFilesRegex() string {
	if x != nil {
		return x.NobuildFilesRegex
	}
	return ""
}

func (x *Version) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *Version) GetVersionUrl() string {
	if x != nil {
		return x.VersionUrl
	}
	return ""
}

func (x *Version) GetEndpointsApiService() *EndpointsApiService {
	if x != nil {
		return x.EndpointsApiService
	}
	return nil
}

func (x *Version) GetEntrypoint() *Entrypoint {
	if x != nil {
		return x.Entrypoint
	}
	return nil
}

func (x *Version) GetVpcAccessConnector() *VpcAccessConnector {
	if x != nil {
		return x.VpcAccessConnector
	}
	return nil
}

type isVersion_Scaling interface {
	isVersion_Scaling()
}

type Version_AutomaticScaling struct {
	// Automatic scaling is based on request rate, response latencies, and other
	// application metrics. Instances are dynamically created and destroyed as
	// needed in order to handle traffic.
	AutomaticScaling *AutomaticScaling `protobuf:"bytes,3,opt,name=automatic_scaling,json=automaticScaling,proto3,oneof"`
}

type Version_BasicScaling struct {
	// A service with basic scaling will create an instance when the application
	// receives a request. The instance will be turned down when the app becomes
	// idle. Basic scaling is ideal for work that is intermittent or driven by
	// user activity.
	BasicScaling *BasicScaling `protobuf:"bytes,4,opt,name=basic_scaling,json=basicScaling,proto3,oneof"`
}

type Version_ManualScaling struct {
	// A service with manual scaling runs continuously, allowing you to perform
	// complex initialization and rely on the state of its memory over time.
	// Manually scaled versions are sometimes referred to as "backends".
	ManualScaling *ManualScaling `protobuf:"bytes,5,opt,name=manual_scaling,json=manualScaling,proto3,oneof"`
}

func (*Version_AutomaticScaling) isVersion_Scaling() {}

func (*Version_BasicScaling) isVersion_Scaling() {}

func (*Version_ManualScaling) isVersion_Scaling() {}

// [Cloud Endpoints](https://cloud.google.com/endpoints) configuration.
// The Endpoints API Service provides tooling for serving Open API and gRPC
// endpoints via an NGINX proxy. Only valid for App Engine Flexible environment
// deployments.
//
// The fields here refer to the name and configuration ID of a "service"
// resource in the [Service Management API](https://cloud.google.com/service-management/overview).
type EndpointsApiService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoints service name which is the name of the "service" resource in the
	// Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Endpoints service configuration ID as specified by the Service Management
	// API. For example "2016-09-19r1".
	//
	// By default, the rollout strategy for Endpoints is `RolloutStrategy.FIXED`.
	// This means that Endpoints starts up with a particular configuration ID.
	// When a new configuration is rolled out, Endpoints must be given the new
	// configuration ID. The `config_id` field is used to give the configuration
	// ID and is required in this case.
	//
	// Endpoints also has a rollout strategy called `RolloutStrategy.MANAGED`.
	// When using this, Endpoints fetches the latest configuration and does not
	// need the configuration ID. In this case, `config_id` must be omitted.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// Endpoints rollout strategy. If `FIXED`, `config_id` must be specified. If
	// `MANAGED`, `config_id` must be omitted.
	RolloutStrategy EndpointsApiService_RolloutStrategy `protobuf:"varint,3,opt,name=rollout_strategy,json=rolloutStrategy,proto3,enum=google.appengine.v1beta.EndpointsApiService_RolloutStrategy" json:"rollout_strategy,omitempty"`
	// Enable or disable trace sampling. By default, this is set to false for
	// enabled.
	DisableTraceSampling bool `protobuf:"varint,4,opt,name=disable_trace_sampling,json=disableTraceSampling,proto3" json:"disable_trace_sampling,omitempty"`
}

func (x *EndpointsApiService) Reset() {
	*x = EndpointsApiService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndpointsApiService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointsApiService) ProtoMessage() {}

func (x *EndpointsApiService) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointsApiService.ProtoReflect.Descriptor instead.
func (*EndpointsApiService) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{1}
}

func (x *EndpointsApiService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EndpointsApiService) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *EndpointsApiService) GetRolloutStrategy() EndpointsApiService_RolloutStrategy {
	if x != nil {
		return x.RolloutStrategy
	}
	return EndpointsApiService_UNSPECIFIED_ROLLOUT_STRATEGY
}

func (x *EndpointsApiService) GetDisableTraceSampling() bool {
	if x != nil {
		return x.DisableTraceSampling
	}
	return false
}

// Automatic scaling is based on request rate, response latencies, and other
// application metrics.
type AutomaticScaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time period that the
	// [Autoscaler](https://cloud.google.com/compute/docs/autoscaler/)
	// should wait before it starts collecting information from a new instance.
	// This prevents the autoscaler from collecting information when the instance
	// is initializing, during which the collected usage would not be reliable.
	// Only applicable in the App Engine flexible environment.
	CoolDownPeriod *durationpb.Duration `protobuf:"bytes,1,opt,name=cool_down_period,json=coolDownPeriod,proto3" json:"cool_down_period,omitempty"`
	// Target scaling by CPU usage.
	CpuUtilization *CpuUtilization `protobuf:"bytes,2,opt,name=cpu_utilization,json=cpuUtilization,proto3" json:"cpu_utilization,omitempty"`
	// Number of concurrent requests an automatic scaling instance can accept
	// before the scheduler spawns a new instance.
	//
	// Defaults to a runtime-specific value.
	MaxConcurrentRequests int32 `protobuf:"varint,3,opt,name=max_concurrent_requests,json=maxConcurrentRequests,proto3" json:"max_concurrent_requests,omitempty"`
	// Maximum number of idle instances that should be maintained for this
	// version.
	MaxIdleInstances int32 `protobuf:"varint,4,opt,name=max_idle_instances,json=maxIdleInstances,proto3" json:"max_idle_instances,omitempty"`
	// Maximum number of instances that should be started to handle requests for
	// this version.
	MaxTotalInstances int32 `protobuf:"varint,5,opt,name=max_total_instances,json=maxTotalInstances,proto3" json:"max_total_instances,omitempty"`
	// Maximum amount of time that a request should wait in the pending queue
	// before starting a new instance to handle it.
	MaxPendingLatency *durationpb.Duration `protobuf:"bytes,6,opt,name=max_pending_latency,json=maxPendingLatency,proto3" json:"max_pending_latency,omitempty"`
	// Minimum number of idle instances that should be maintained for
	// this version. Only applicable for the default version of a service.
	MinIdleInstances int32 `protobuf:"varint,7,opt,name=min_idle_instances,json=minIdleInstances,proto3" json:"min_idle_instances,omitempty"`
	// Minimum number of running instances that should be maintained for this
	// version.
	MinTotalInstances int32 `protobuf:"varint,8,opt,name=min_total_instances,json=minTotalInstances,proto3" json:"min_total_instances,omitempty"`
	// Minimum amount of time a request should wait in the pending queue before
	// starting a new instance to handle it.
	MinPendingLatency *durationpb.Duration `protobuf:"bytes,9,opt,name=min_pending_latency,json=minPendingLatency,proto3" json:"min_pending_latency,omitempty"`
	// Target scaling by request utilization.
	RequestUtilization *RequestUtilization `protobuf:"bytes,10,opt,name=request_utilization,json=requestUtilization,proto3" json:"request_utilization,omitempty"`
	// Target scaling by disk usage.
	DiskUtilization *DiskUtilization `protobuf:"bytes,11,opt,name=disk_utilization,json=diskUtilization,proto3" json:"disk_utilization,omitempty"`
	// Target scaling by network usage.
	NetworkUtilization *NetworkUtilization `protobuf:"bytes,12,opt,name=network_utilization,json=networkUtilization,proto3" json:"network_utilization,omitempty"`
	// Target scaling by user-provided metrics.
	// Only applicable in the App Engine flexible environment.
	CustomMetrics []*CustomMetric `protobuf:"bytes,21,rep,name=custom_metrics,json=customMetrics,proto3" json:"custom_metrics,omitempty"`
	// Scheduler settings for standard environment.
	StandardSchedulerSettings *StandardSchedulerSettings `protobuf:"bytes,20,opt,name=standard_scheduler_settings,json=standardSchedulerSettings,proto3" json:"standard_scheduler_settings,omitempty"`
}

func (x *AutomaticScaling) Reset() {
	*x = AutomaticScaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomaticScaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticScaling) ProtoMessage() {}

func (x *AutomaticScaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticScaling.ProtoReflect.Descriptor instead.
func (*AutomaticScaling) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{2}
}

func (x *AutomaticScaling) GetCoolDownPeriod() *durationpb.Duration {
	if x != nil {
		return x.CoolDownPeriod
	}
	return nil
}

func (x *AutomaticScaling) GetCpuUtilization() *CpuUtilization {
	if x != nil {
		return x.CpuUtilization
	}
	return nil
}

func (x *AutomaticScaling) GetMaxConcurrentRequests() int32 {
	if x != nil {
		return x.MaxConcurrentRequests
	}
	return 0
}

func (x *AutomaticScaling) GetMaxIdleInstances() int32 {
	if x != nil {
		return x.MaxIdleInstances
	}
	return 0
}

func (x *AutomaticScaling) GetMaxTotalInstances() int32 {
	if x != nil {
		return x.MaxTotalInstances
	}
	return 0
}

func (x *AutomaticScaling) GetMaxPendingLatency() *durationpb.Duration {
	if x != nil {
		return x.MaxPendingLatency
	}
	return nil
}

func (x *AutomaticScaling) GetMinIdleInstances() int32 {
	if x != nil {
		return x.MinIdleInstances
	}
	return 0
}

func (x *AutomaticScaling) GetMinTotalInstances() int32 {
	if x != nil {
		return x.MinTotalInstances
	}
	return 0
}

func (x *AutomaticScaling) GetMinPendingLatency() *durationpb.Duration {
	if x != nil {
		return x.MinPendingLatency
	}
	return nil
}

func (x *AutomaticScaling) GetRequestUtilization() *RequestUtilization {
	if x != nil {
		return x.RequestUtilization
	}
	return nil
}

func (x *AutomaticScaling) GetDiskUtilization() *DiskUtilization {
	if x != nil {
		return x.DiskUtilization
	}
	return nil
}

func (x *AutomaticScaling) GetNetworkUtilization() *NetworkUtilization {
	if x != nil {
		return x.NetworkUtilization
	}
	return nil
}

func (x *AutomaticScaling) GetCustomMetrics() []*CustomMetric {
	if x != nil {
		return x.CustomMetrics
	}
	return nil
}

func (x *AutomaticScaling) GetStandardSchedulerSettings() *StandardSchedulerSettings {
	if x != nil {
		return x.StandardSchedulerSettings
	}
	return nil
}

// A service with basic scaling will create an instance when the application
// receives a request. The instance will be turned down when the app becomes
// idle. Basic scaling is ideal for work that is intermittent or driven by
// user activity.
type BasicScaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of time after the last request that an instance must wait before
	// the instance is shut down.
	IdleTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// Maximum number of instances to create for this version.
	MaxInstances int32 `protobuf:"varint,2,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
}

func (x *BasicScaling) Reset() {
	*x = BasicScaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicScaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicScaling) ProtoMessage() {}

func (x *BasicScaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicScaling.ProtoReflect.Descriptor instead.
func (*BasicScaling) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{3}
}

func (x *BasicScaling) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *BasicScaling) GetMaxInstances() int32 {
	if x != nil {
		return x.MaxInstances
	}
	return 0
}

// A service with manual scaling runs continuously, allowing you to perform
// complex initialization and rely on the state of its memory over time.
type ManualScaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of instances to assign to the service at the start. This number
	// can later be altered by using the
	// [Modules API](https://cloud.google.com/appengine/docs/python/modules/functions)
	// `set_num_instances()` function.
	Instances int32 `protobuf:"varint,1,opt,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ManualScaling) Reset() {
	*x = ManualScaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManualScaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManualScaling) ProtoMessage() {}

func (x *ManualScaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManualScaling.ProtoReflect.Descriptor instead.
func (*ManualScaling) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{4}
}

func (x *ManualScaling) GetInstances() int32 {
	if x != nil {
		return x.Instances
	}
	return 0
}

// Target scaling by CPU usage.
type CpuUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Period of time over which CPU utilization is calculated.
	AggregationWindowLength *durationpb.Duration `protobuf:"bytes,1,opt,name=aggregation_window_length,json=aggregationWindowLength,proto3" json:"aggregation_window_length,omitempty"`
	// Target CPU utilization ratio to maintain when scaling. Must be between 0
	// and 1.
	TargetUtilization float64 `protobuf:"fixed64,2,opt,name=target_utilization,json=targetUtilization,proto3" json:"target_utilization,omitempty"`
}

func (x *CpuUtilization) Reset() {
	*x = CpuUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpuUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpuUtilization) ProtoMessage() {}

func (x *CpuUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpuUtilization.ProtoReflect.Descriptor instead.
func (*CpuUtilization) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{5}
}

func (x *CpuUtilization) GetAggregationWindowLength() *durationpb.Duration {
	if x != nil {
		return x.AggregationWindowLength
	}
	return nil
}

func (x *CpuUtilization) GetTargetUtilization() float64 {
	if x != nil {
		return x.TargetUtilization
	}
	return 0
}

// Target scaling by request utilization.
// Only applicable in the App Engine flexible environment.
type RequestUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target requests per second.
	TargetRequestCountPerSecond int32 `protobuf:"varint,1,opt,name=target_request_count_per_second,json=targetRequestCountPerSecond,proto3" json:"target_request_count_per_second,omitempty"`
	// Target number of concurrent requests.
	TargetConcurrentRequests int32 `protobuf:"varint,2,opt,name=target_concurrent_requests,json=targetConcurrentRequests,proto3" json:"target_concurrent_requests,omitempty"`
}

func (x *RequestUtilization) Reset() {
	*x = RequestUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestUtilization) ProtoMessage() {}

func (x *RequestUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestUtilization.ProtoReflect.Descriptor instead.
func (*RequestUtilization) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{6}
}

func (x *RequestUtilization) GetTargetRequestCountPerSecond() int32 {
	if x != nil {
		return x.TargetRequestCountPerSecond
	}
	return 0
}

func (x *RequestUtilization) GetTargetConcurrentRequests() int32 {
	if x != nil {
		return x.TargetConcurrentRequests
	}
	return 0
}

// Target scaling by disk usage.
// Only applicable in the App Engine flexible environment.
type DiskUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target bytes written per second.
	TargetWriteBytesPerSecond int32 `protobuf:"varint,14,opt,name=target_write_bytes_per_second,json=targetWriteBytesPerSecond,proto3" json:"target_write_bytes_per_second,omitempty"`
	// Target ops written per second.
	TargetWriteOpsPerSecond int32 `protobuf:"varint,15,opt,name=target_write_ops_per_second,json=targetWriteOpsPerSecond,proto3" json:"target_write_ops_per_second,omitempty"`
	// Target bytes read per second.
	TargetReadBytesPerSecond int32 `protobuf:"varint,16,opt,name=target_read_bytes_per_second,json=targetReadBytesPerSecond,proto3" json:"target_read_bytes_per_second,omitempty"`
	// Target ops read per seconds.
	TargetReadOpsPerSecond int32 `protobuf:"varint,17,opt,name=target_read_ops_per_second,json=targetReadOpsPerSecond,proto3" json:"target_read_ops_per_second,omitempty"`
}

func (x *DiskUtilization) Reset() {
	*x = DiskUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskUtilization) ProtoMessage() {}

func (x *DiskUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskUtilization.ProtoReflect.Descriptor instead.
func (*DiskUtilization) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{7}
}

func (x *DiskUtilization) GetTargetWriteBytesPerSecond() int32 {
	if x != nil {
		return x.TargetWriteBytesPerSecond
	}
	return 0
}

func (x *DiskUtilization) GetTargetWriteOpsPerSecond() int32 {
	if x != nil {
		return x.TargetWriteOpsPerSecond
	}
	return 0
}

func (x *DiskUtilization) GetTargetReadBytesPerSecond() int32 {
	if x != nil {
		return x.TargetReadBytesPerSecond
	}
	return 0
}

func (x *DiskUtilization) GetTargetReadOpsPerSecond() int32 {
	if x != nil {
		return x.TargetReadOpsPerSecond
	}
	return 0
}

// Target scaling by network usage.
// Only applicable in the App Engine flexible environment.
type NetworkUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target bytes sent per second.
	TargetSentBytesPerSecond int32 `protobuf:"varint,1,opt,name=target_sent_bytes_per_second,json=targetSentBytesPerSecond,proto3" json:"target_sent_bytes_per_second,omitempty"`
	// Target packets sent per second.
	TargetSentPacketsPerSecond int32 `protobuf:"varint,11,opt,name=target_sent_packets_per_second,json=targetSentPacketsPerSecond,proto3" json:"target_sent_packets_per_second,omitempty"`
	// Target bytes received per second.
	TargetReceivedBytesPerSecond int32 `protobuf:"varint,12,opt,name=target_received_bytes_per_second,json=targetReceivedBytesPerSecond,proto3" json:"target_received_bytes_per_second,omitempty"`
	// Target packets received per second.
	TargetReceivedPacketsPerSecond int32 `protobuf:"varint,13,opt,name=target_received_packets_per_second,json=targetReceivedPacketsPerSecond,proto3" json:"target_received_packets_per_second,omitempty"`
}

func (x *NetworkUtilization) Reset() {
	*x = NetworkUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkUtilization) ProtoMessage() {}

func (x *NetworkUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkUtilization.ProtoReflect.Descriptor instead.
func (*NetworkUtilization) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{8}
}

func (x *NetworkUtilization) GetTargetSentBytesPerSecond() int32 {
	if x != nil {
		return x.TargetSentBytesPerSecond
	}
	return 0
}

func (x *NetworkUtilization) GetTargetSentPacketsPerSecond() int32 {
	if x != nil {
		return x.TargetSentPacketsPerSecond
	}
	return 0
}

func (x *NetworkUtilization) GetTargetReceivedBytesPerSecond() int32 {
	if x != nil {
		return x.TargetReceivedBytesPerSecond
	}
	return 0
}

func (x *NetworkUtilization) GetTargetReceivedPacketsPerSecond() int32 {
	if x != nil {
		return x.TargetReceivedPacketsPerSecond
	}
	return 0
}

// Allows autoscaling based on Stackdriver metrics.
type CustomMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the metric.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// The type of the metric. Must be a string representing a Stackdriver
	// metric type e.g. GAGUE, DELTA_PER_SECOND, etc.
	TargetType string `protobuf:"bytes,2,opt,name=target_type,json=targetType,proto3" json:"target_type,omitempty"`
	// The target spec.
	//
	// Types that are assignable to TargetSpec:
	//	*CustomMetric_TargetUtilization
	//	*CustomMetric_SingleInstanceAssignment
	TargetSpec isCustomMetric_TargetSpec `protobuf_oneof:"target_spec"`
	// Allows filtering on the metric's fields.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *CustomMetric) Reset() {
	*x = CustomMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomMetric) ProtoMessage() {}

func (x *CustomMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomMetric.ProtoReflect.Descriptor instead.
func (*CustomMetric) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{9}
}

func (x *CustomMetric) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *CustomMetric) GetTargetType() string {
	if x != nil {
		return x.TargetType
	}
	return ""
}

func (m *CustomMetric) GetTargetSpec() isCustomMetric_TargetSpec {
	if m != nil {
		return m.TargetSpec
	}
	return nil
}

func (x *CustomMetric) GetTargetUtilization() float64 {
	if x, ok := x.GetTargetSpec().(*CustomMetric_TargetUtilization); ok {
		return x.TargetUtilization
	}
	return 0
}

func (x *CustomMetric) GetSingleInstanceAssignment() float64 {
	if x, ok := x.GetTargetSpec().(*CustomMetric_SingleInstanceAssignment); ok {
		return x.SingleInstanceAssignment
	}
	return 0
}

func (x *CustomMetric) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isCustomMetric_TargetSpec interface {
	isCustomMetric_TargetSpec()
}

type CustomMetric_TargetUtilization struct {
	// The target value for the metric.
	TargetUtilization float64 `protobuf:"fixed64,3,opt,name=target_utilization,json=targetUtilization,proto3,oneof"`
}

type CustomMetric_SingleInstanceAssignment struct {
	// May be used instead of `target_utilization` when an instance can handle a
	// specific amount of work/resources and the metric value is equal to the
	// current amount of work remaining. The autoscaler will try to keep the
	// number of instances equal to the metric value divided by
	// `single_instance_assignment`.
	SingleInstanceAssignment float64 `protobuf:"fixed64,4,opt,name=single_instance_assignment,json=singleInstanceAssignment,proto3,oneof"`
}

func (*CustomMetric_TargetUtilization) isCustomMetric_TargetSpec() {}

func (*CustomMetric_SingleInstanceAssignment) isCustomMetric_TargetSpec() {}

// Scheduler settings for standard environment.
type StandardSchedulerSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target CPU utilization ratio to maintain when scaling.
	TargetCpuUtilization float64 `protobuf:"fixed64,1,opt,name=target_cpu_utilization,json=targetCpuUtilization,proto3" json:"target_cpu_utilization,omitempty"`
	// Target throughput utilization ratio to maintain when scaling
	TargetThroughputUtilization float64 `protobuf:"fixed64,2,opt,name=target_throughput_utilization,json=targetThroughputUtilization,proto3" json:"target_throughput_utilization,omitempty"`
	// Minimum number of instances to run for this version. Set to zero to disable
	// `min_instances` configuration.
	MinInstances int32 `protobuf:"varint,3,opt,name=min_instances,json=minInstances,proto3" json:"min_instances,omitempty"`
	// Maximum number of instances to run for this version. Set to zero to disable
	// `max_instances` configuration.
	MaxInstances int32 `protobuf:"varint,4,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
}

func (x *StandardSchedulerSettings) Reset() {
	*x = StandardSchedulerSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardSchedulerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardSchedulerSettings) ProtoMessage() {}

func (x *StandardSchedulerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardSchedulerSettings.ProtoReflect.Descriptor instead.
func (*StandardSchedulerSettings) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{10}
}

func (x *StandardSchedulerSettings) GetTargetCpuUtilization() float64 {
	if x != nil {
		return x.TargetCpuUtilization
	}
	return 0
}

func (x *StandardSchedulerSettings) GetTargetThroughputUtilization() float64 {
	if x != nil {
		return x.TargetThroughputUtilization
	}
	return 0
}

func (x *StandardSchedulerSettings) GetMinInstances() int32 {
	if x != nil {
		return x.MinInstances
	}
	return 0
}

func (x *StandardSchedulerSettings) GetMaxInstances() int32 {
	if x != nil {
		return x.MaxInstances
	}
	return 0
}

// Extra network settings.
// Only applicable in the App Engine flexible environment.
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ports, or port pairs, to forward from the virtual machine to the
	// application container.
	// Only applicable in the App Engine flexible environment.
	ForwardedPorts []string `protobuf:"bytes,1,rep,name=forwarded_ports,json=forwardedPorts,proto3" json:"forwarded_ports,omitempty"`
	// Tag to apply to the instance during creation.
	// Only applicable in the App Engine flexible environment.
	InstanceTag string `protobuf:"bytes,2,opt,name=instance_tag,json=instanceTag,proto3" json:"instance_tag,omitempty"`
	// Google Compute Engine network where the virtual machines are created.
	// Specify the short name, not the resource path.
	//
	// Defaults to `default`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Google Cloud Platform sub-network where the virtual machines are created.
	// Specify the short name, not the resource path.
	//
	// If a subnetwork name is specified, a network name will also be required
	// unless it is for the default network.
	//
	// * If the network that the instance is being created in is a Legacy network,
	// then the IP address is allocated from the IPv4Range.
	// * If the network that the instance is being created in is an auto Subnet
	// Mode Network, then only network name should be specified (not the
	// subnetwork_name) and the IP address is created from the IPCidrRange of the
	// subnetwork that exists in that zone for that network.
	// * If the network that the instance is being created in is a custom Subnet
	// Mode Network, then the subnetwork_name must be specified and the
	// IP address is created from the IPCidrRange of the subnetwork.
	//
	// If specified, the subnetwork must exist in the same region as the
	// App Engine flexible environment application.
	SubnetworkName string `protobuf:"bytes,4,opt,name=subnetwork_name,json=subnetworkName,proto3" json:"subnetwork_name,omitempty"`
	// Enable session affinity.
	// Only applicable in the App Engine flexible environment.
	SessionAffinity bool `protobuf:"varint,5,opt,name=session_affinity,json=sessionAffinity,proto3" json:"session_affinity,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{11}
}

func (x *Network) GetForwardedPorts() []string {
	if x != nil {
		return x.ForwardedPorts
	}
	return nil
}

func (x *Network) GetInstanceTag() string {
	if x != nil {
		return x.InstanceTag
	}
	return ""
}

func (x *Network) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Network) GetSubnetworkName() string {
	if x != nil {
		return x.SubnetworkName
	}
	return ""
}

func (x *Network) GetSessionAffinity() bool {
	if x != nil {
		return x.SessionAffinity
	}
	return false
}

// Volumes mounted within the app container.
// Only applicable in the App Engine flexible environment.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique name for the volume.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Underlying volume type, e.g. 'tmpfs'.
	VolumeType string `protobuf:"bytes,2,opt,name=volume_type,json=volumeType,proto3" json:"volume_type,omitempty"`
	// Volume size in gigabytes.
	SizeGb float64 `protobuf:"fixed64,3,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{12}
}

func (x *Volume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Volume) GetVolumeType() string {
	if x != nil {
		return x.VolumeType
	}
	return ""
}

func (x *Volume) GetSizeGb() float64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// Machine resources for a version.
type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of CPU cores needed.
	Cpu float64 `protobuf:"fixed64,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Disk size (GB) needed.
	DiskGb float64 `protobuf:"fixed64,2,opt,name=disk_gb,json=diskGb,proto3" json:"disk_gb,omitempty"`
	// Memory (GB) needed.
	MemoryGb float64 `protobuf:"fixed64,3,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// User specified volumes.
	Volumes []*Volume `protobuf:"bytes,4,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// The name of the encryption key that is stored in Google Cloud KMS.
	// Only should be used by Cloud Composer to encrypt the vm disk
	KmsKeyReference string `protobuf:"bytes,5,opt,name=kms_key_reference,json=kmsKeyReference,proto3" json:"kms_key_reference,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{13}
}

func (x *Resources) GetCpu() float64 {
	if x != nil {
		return x.Cpu
	}
	return 0
}

func (x *Resources) GetDiskGb() float64 {
	if x != nil {
		return x.DiskGb
	}
	return 0
}

func (x *Resources) GetMemoryGb() float64 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *Resources) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *Resources) GetKmsKeyReference() string {
	if x != nil {
		return x.KmsKeyReference
	}
	return ""
}

// VPC access connector specification.
type VpcAccessConnector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full Serverless VPC Access Connector name e.g.
	// /projects/my-project/locations/us-central1/connectors/c1.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *VpcAccessConnector) Reset() {
	*x = VpcAccessConnector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpcAccessConnector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcAccessConnector) ProtoMessage() {}

func (x *VpcAccessConnector) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcAccessConnector.ProtoReflect.Descriptor instead.
func (*VpcAccessConnector) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{14}
}

func (x *VpcAccessConnector) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The entrypoint for the application.
type Entrypoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The command to run.
	//
	// Types that are assignable to Command:
	//	*Entrypoint_Shell
	Command isEntrypoint_Command `protobuf_oneof:"command"`
}

func (x *Entrypoint) Reset() {
	*x = Entrypoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_version_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entrypoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entrypoint) ProtoMessage() {}

func (x *Entrypoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_version_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entrypoint.ProtoReflect.Descriptor instead.
func (*Entrypoint) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_version_proto_rawDescGZIP(), []int{15}
}

func (m *Entrypoint) GetCommand() isEntrypoint_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (x *Entrypoint) GetShell() string {
	if x, ok := x.GetCommand().(*Entrypoint_Shell); ok {
		return x.Shell
	}
	return ""
}

type isEntrypoint_Command interface {
	isEntrypoint_Command()
}

type Entrypoint_Shell struct {
	// The format should be a shell command that can be fed to `bash -c`.
	Shell string `protobuf:"bytes,1,opt,name=shell,proto3,oneof"`
}

func (*Entrypoint_Shell) isEntrypoint_Command() {}

var File_google_appengine_v1beta_version_proto protoreflect.FileDescriptor

var file_google_appengine_v1beta_version_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x79, 0x61,
	0x6d, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa9, 0x14,
	0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x58, 0x0a,
	0x11, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x53, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4c, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x69, 0x63,
	0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x53, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x53, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x0e, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0d, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x56, 0x0a, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x69,
	0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x3a, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x14, 0x0a, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x76, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x75, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x1e, 0x0a, 0x0a,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x61, 0x66, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x61, 0x66, 0x65, 0x12, 0x0e, 0x0a, 0x02,
	0x76, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x02, 0x76, 0x6d, 0x12, 0x27, 0x0a, 0x0f,
	0x61, 0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18,
	0x80, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x41, 0x70, 0x69, 0x73, 0x12, 0x57, 0x0a, 0x0d, 0x62, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x42,
	0x65, 0x74, 0x61, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0c, 0x62, 0x65, 0x74, 0x61, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x76,
	0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x70, 0x69, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x1c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x7f, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x3b, 0x0a, 0x08, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x72, 0x6c, 0x4d,
	0x61, 0x70, 0x52, 0x08, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x0e,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x65,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x12, 0x3e, 0x0a, 0x09, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x66, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52,
	0x09, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x61, 0x70,
	0x69, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x70, 0x69, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x09, 0x61, 0x70, 0x69, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0d, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x68, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e,
	0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0c, 0x65, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x67, 0x0a,
	0x13, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x18, 0x7d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x11, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x69, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x47, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0b, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x50, 0x0a, 0x0f, 0x72, 0x65, 0x61,
	0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x70, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61,
	0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0e, 0x72, 0x65, 0x61,
	0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x4d, 0x0a, 0x0e, 0x6c,
	0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x71, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0d, 0x6c, 0x69, 0x76,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x6f,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x6f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x43, 0x0a, 0x0a, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x6d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x6c,
	0x12, 0x60, 0x0a, 0x15, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x61, 0x70,
	0x69, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x13, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x43, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x7a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x14, 0x76, 0x70, 0x63, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x79, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x12, 0x76, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x3f, 0x0a, 0x11, 0x42, 0x65, 0x74, 0x61, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x45, 0x6e, 0x76, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x44, 0x0a, 0x16, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x09,
	0x0a, 0x07, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xb2, 0x02, 0x0a, 0x13, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x49, 0x64, 0x12, 0x67, 0x0a, 0x10, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x63, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e,
	0x67, 0x22, 0x4b, 0x0a, 0x0f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49, 0x58, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x02, 0x22, 0x86,
	0x08, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x53, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x43, 0x0a, 0x10, 0x63, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x6f, 0x77, 0x6e,
	0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6f, 0x6c, 0x44, 0x6f,
	0x77, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x50, 0x0a, 0x0f, 0x63, 0x70, 0x75, 0x5f,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x70, 0x75, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x70, 0x75, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x6d, 0x61,
	0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x6d, 0x61, 0x78,
	0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10,
	0x6d, 0x61, 0x78, 0x49, 0x64, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d,
	0x61, 0x78, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x49, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x6d,
	0x69, 0x6e, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x49, 0x64, 0x6c, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x69, 0x6e,
	0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x69, 0x6e, 0x54, 0x6f, 0x74, 0x61, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x13, 0x6d, 0x69, 0x6e,
	0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x6d, 0x69, 0x6e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x55, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x13, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x72, 0x0a, 0x1b, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x19, 0x73, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x71, 0x0a, 0x0c, 0x42, 0x61, 0x73, 0x69, 0x63,
	0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x3c, 0x0a, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61,
	0x78, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x2d, 0x0a, 0x0d, 0x4d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x96, 0x01, 0x0a, 0x0e, 0x43, 0x70,
	0x75, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x19,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x2d, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x1f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x1b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12,
	0x3c, 0x0a, 0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x18, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x8d, 0x02,
	0x0a, 0x0f, 0x44, 0x69, 0x73, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x12, 0x3c, 0x0a, 0x1b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x70, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x12, 0x3e, 0x0a, 0x1c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x61, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x12, 0x3a, 0x0a, 0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6f, 0x70, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x61,
	0x64, 0x4f, 0x70, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x22, 0xac, 0x02,
	0x0a, 0x12, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x1c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x65, 0x6e, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x1e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1a, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x46, 0x0a, 0x20, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x1c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x12, 0x4a, 0x0a, 0x22, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1e, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x22, 0xe8, 0x01, 0x0a,
	0x0c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2f, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x11, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3e, 0x0a, 0x1a, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x18, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xdf, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x75,
	0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1d, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74,
	0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x1b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67,
	0x68, 0x70, 0x75, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x07, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x65, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e,
	0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x22, 0x56, 0x0a, 0x06, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x22, 0xba, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x10, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x63, 0x70,
	0x75, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x06, 0x64, 0x69, 0x73, 0x6b, 0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x39, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x28,
	0x0a, 0x12, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x42, 0x09,
	0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2a, 0xbb, 0x02, 0x0a, 0x12, 0x49, 0x6e,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x49,
	0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x4d,
	0x41, 0x49, 0x4c, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a,
	0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x58, 0x4d, 0x50, 0x50, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c,
	0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x58, 0x4d, 0x50, 0x50, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0x04, 0x12, 0x22,
	0x0a, 0x1e, 0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x58, 0x4d, 0x50, 0x50, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45,
	0x10, 0x05, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x58, 0x4d, 0x50, 0x50, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45,
	0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x49,
	0x4e, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x57,
	0x41, 0x52, 0x4d, 0x55, 0x50, 0x10, 0x09, 0x2a, 0x49, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x02, 0x42, 0xd2, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x42, 0x0c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_appengine_v1beta_version_proto_rawDescOnce sync.Once
	file_google_appengine_v1beta_version_proto_rawDescData = file_google_appengine_v1beta_version_proto_rawDesc
)

func file_google_appengine_v1beta_version_proto_rawDescGZIP() []byte {
	file_google_appengine_v1beta_version_proto_rawDescOnce.Do(func() {
		file_google_appengine_v1beta_version_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_appengine_v1beta_version_proto_rawDescData)
	})
	return file_google_appengine_v1beta_version_proto_rawDescData
}

var file_google_appengine_v1beta_version_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_appengine_v1beta_version_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_appengine_v1beta_version_proto_goTypes = []interface{}{
	(InboundServiceType)(0),                  // 0: google.appengine.v1beta.InboundServiceType
	(ServingStatus)(0),                       // 1: google.appengine.v1beta.ServingStatus
	(EndpointsApiService_RolloutStrategy)(0), // 2: google.appengine.v1beta.EndpointsApiService.RolloutStrategy
	(*Version)(nil),                          // 3: google.appengine.v1beta.Version
	(*EndpointsApiService)(nil),              // 4: google.appengine.v1beta.EndpointsApiService
	(*AutomaticScaling)(nil),                 // 5: google.appengine.v1beta.AutomaticScaling
	(*BasicScaling)(nil),                     // 6: google.appengine.v1beta.BasicScaling
	(*ManualScaling)(nil),                    // 7: google.appengine.v1beta.ManualScaling
	(*CpuUtilization)(nil),                   // 8: google.appengine.v1beta.CpuUtilization
	(*RequestUtilization)(nil),               // 9: google.appengine.v1beta.RequestUtilization
	(*DiskUtilization)(nil),                  // 10: google.appengine.v1beta.DiskUtilization
	(*NetworkUtilization)(nil),               // 11: google.appengine.v1beta.NetworkUtilization
	(*CustomMetric)(nil),                     // 12: google.appengine.v1beta.CustomMetric
	(*StandardSchedulerSettings)(nil),        // 13: google.appengine.v1beta.StandardSchedulerSettings
	(*Network)(nil),                          // 14: google.appengine.v1beta.Network
	(*Volume)(nil),                           // 15: google.appengine.v1beta.Volume
	(*Resources)(nil),                        // 16: google.appengine.v1beta.Resources
	(*VpcAccessConnector)(nil),               // 17: google.appengine.v1beta.VpcAccessConnector
	(*Entrypoint)(nil),                       // 18: google.appengine.v1beta.Entrypoint
	nil,                                      // 19: google.appengine.v1beta.Version.BetaSettingsEntry
	nil,                                      // 20: google.appengine.v1beta.Version.EnvVariablesEntry
	nil,                                      // 21: google.appengine.v1beta.Version.BuildEnvVariablesEntry
	(*timestamppb.Timestamp)(nil),            // 22: google.protobuf.Timestamp
	(*UrlMap)(nil),                           // 23: google.appengine.v1beta.UrlMap
	(*ErrorHandler)(nil),                     // 24: google.appengine.v1beta.ErrorHandler
	(*Library)(nil),                          // 25: google.appengine.v1beta.Library
	(*ApiConfigHandler)(nil),                 // 26: google.appengine.v1beta.ApiConfigHandler
	(*durationpb.Duration)(nil),              // 27: google.protobuf.Duration
	(*HealthCheck)(nil),                      // 28: google.appengine.v1beta.HealthCheck
	(*ReadinessCheck)(nil),                   // 29: google.appengine.v1beta.ReadinessCheck
	(*LivenessCheck)(nil),                    // 30: google.appengine.v1beta.LivenessCheck
	(*Deployment)(nil),                       // 31: google.appengine.v1beta.Deployment
}
var file_google_appengine_v1beta_version_proto_depIdxs = []int32{
	5,  // 0: google.appengine.v1beta.Version.automatic_scaling:type_name -> google.appengine.v1beta.AutomaticScaling
	6,  // 1: google.appengine.v1beta.Version.basic_scaling:type_name -> google.appengine.v1beta.BasicScaling
	7,  // 2: google.appengine.v1beta.Version.manual_scaling:type_name -> google.appengine.v1beta.ManualScaling
	0,  // 3: google.appengine.v1beta.Version.inbound_services:type_name -> google.appengine.v1beta.InboundServiceType
	14, // 4: google.appengine.v1beta.Version.network:type_name -> google.appengine.v1beta.Network
	16, // 5: google.appengine.v1beta.Version.resources:type_name -> google.appengine.v1beta.Resources
	19, // 6: google.appengine.v1beta.Version.beta_settings:type_name -> google.appengine.v1beta.Version.BetaSettingsEntry
	1,  // 7: google.appengine.v1beta.Version.serving_status:type_name -> google.appengine.v1beta.ServingStatus
	22, // 8: google.appengine.v1beta.Version.create_time:type_name -> google.protobuf.Timestamp
	23, // 9: google.appengine.v1beta.Version.handlers:type_name -> google.appengine.v1beta.UrlMap
	24, // 10: google.appengine.v1beta.Version.error_handlers:type_name -> google.appengine.v1beta.ErrorHandler
	25, // 11: google.appengine.v1beta.Version.libraries:type_name -> google.appengine.v1beta.Library
	26, // 12: google.appengine.v1beta.Version.api_config:type_name -> google.appengine.v1beta.ApiConfigHandler
	20, // 13: google.appengine.v1beta.Version.env_variables:type_name -> google.appengine.v1beta.Version.EnvVariablesEntry
	21, // 14: google.appengine.v1beta.Version.build_env_variables:type_name -> google.appengine.v1beta.Version.BuildEnvVariablesEntry
	27, // 15: google.appengine.v1beta.Version.default_expiration:type_name -> google.protobuf.Duration
	28, // 16: google.appengine.v1beta.Version.health_check:type_name -> google.appengine.v1beta.HealthCheck
	29, // 17: google.appengine.v1beta.Version.readiness_check:type_name -> google.appengine.v1beta.ReadinessCheck
	30, // 18: google.appengine.v1beta.Version.liveness_check:type_name -> google.appengine.v1beta.LivenessCheck
	31, // 19: google.appengine.v1beta.Version.deployment:type_name -> google.appengine.v1beta.Deployment
	4,  // 20: google.appengine.v1beta.Version.endpoints_api_service:type_name -> google.appengine.v1beta.EndpointsApiService
	18, // 21: google.appengine.v1beta.Version.entrypoint:type_name -> google.appengine.v1beta.Entrypoint
	17, // 22: google.appengine.v1beta.Version.vpc_access_connector:type_name -> google.appengine.v1beta.VpcAccessConnector
	2,  // 23: google.appengine.v1beta.EndpointsApiService.rollout_strategy:type_name -> google.appengine.v1beta.EndpointsApiService.RolloutStrategy
	27, // 24: google.appengine.v1beta.AutomaticScaling.cool_down_period:type_name -> google.protobuf.Duration
	8,  // 25: google.appengine.v1beta.AutomaticScaling.cpu_utilization:type_name -> google.appengine.v1beta.CpuUtilization
	27, // 26: google.appengine.v1beta.AutomaticScaling.max_pending_latency:type_name -> google.protobuf.Duration
	27, // 27: google.appengine.v1beta.AutomaticScaling.min_pending_latency:type_name -> google.protobuf.Duration
	9,  // 28: google.appengine.v1beta.AutomaticScaling.request_utilization:type_name -> google.appengine.v1beta.RequestUtilization
	10, // 29: google.appengine.v1beta.AutomaticScaling.disk_utilization:type_name -> google.appengine.v1beta.DiskUtilization
	11, // 30: google.appengine.v1beta.AutomaticScaling.network_utilization:type_name -> google.appengine.v1beta.NetworkUtilization
	12, // 31: google.appengine.v1beta.AutomaticScaling.custom_metrics:type_name -> google.appengine.v1beta.CustomMetric
	13, // 32: google.appengine.v1beta.AutomaticScaling.standard_scheduler_settings:type_name -> google.appengine.v1beta.StandardSchedulerSettings
	27, // 33: google.appengine.v1beta.BasicScaling.idle_timeout:type_name -> google.protobuf.Duration
	27, // 34: google.appengine.v1beta.CpuUtilization.aggregation_window_length:type_name -> google.protobuf.Duration
	15, // 35: google.appengine.v1beta.Resources.volumes:type_name -> google.appengine.v1beta.Volume
	36, // [36:36] is the sub-list for method output_type
	36, // [36:36] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_appengine_v1beta_version_proto_init() }
func file_google_appengine_v1beta_version_proto_init() {
	if File_google_appengine_v1beta_version_proto != nil {
		return
	}
	file_google_appengine_v1beta_app_yaml_proto_init()
	file_google_appengine_v1beta_deploy_proto_init()
	file_google_appengine_v1beta_network_settings_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_appengine_v1beta_version_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndpointsApiService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomaticScaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicScaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManualScaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpuUtilization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestUtilization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskUtilization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkUtilization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardSchedulerSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpcAccessConnector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_version_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entrypoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_appengine_v1beta_version_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Version_AutomaticScaling)(nil),
		(*Version_BasicScaling)(nil),
		(*Version_ManualScaling)(nil),
	}
	file_google_appengine_v1beta_version_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*CustomMetric_TargetUtilization)(nil),
		(*CustomMetric_SingleInstanceAssignment)(nil),
	}
	file_google_appengine_v1beta_version_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*Entrypoint_Shell)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_appengine_v1beta_version_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_appengine_v1beta_version_proto_goTypes,
		DependencyIndexes: file_google_appengine_v1beta_version_proto_depIdxs,
		EnumInfos:         file_google_appengine_v1beta_version_proto_enumTypes,
		MessageInfos:      file_google_appengine_v1beta_version_proto_msgTypes,
	}.Build()
	File_google_appengine_v1beta_version_proto = out.File
	file_google_appengine_v1beta_version_proto_rawDesc = nil
	file_google_appengine_v1beta_version_proto_goTypes = nil
	file_google_appengine_v1beta_version_proto_depIdxs = nil
}
