// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/channel/v1/service.proto

package channel

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Change Type enum.
type ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType int32

const (
	// Not used.
	ListPurchasableSkusRequest_ChangeOfferPurchase_CHANGE_TYPE_UNSPECIFIED ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 0
	// SKU is an upgrade on the current entitlement.
	ListPurchasableSkusRequest_ChangeOfferPurchase_UPGRADE ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 1
	// SKU is a downgrade on the current entitlement.
	ListPurchasableSkusRequest_ChangeOfferPurchase_DOWNGRADE ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType = 2
)

// Enum value maps for ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType.
var (
	ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType_name = map[int32]string{
		0: "CHANGE_TYPE_UNSPECIFIED",
		1: "UPGRADE",
		2: "DOWNGRADE",
	}
	ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType_value = map[string]int32{
		"CHANGE_TYPE_UNSPECIFIED": 0,
		"UPGRADE":                 1,
		"DOWNGRADE":               2,
	}
)

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Enum() *ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType {
	p := new(ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType)
	*p = x
	return p
}

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_service_proto_enumTypes[0].Descriptor()
}

func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_service_proto_enumTypes[0]
}

func (x ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType.Descriptor instead.
func (ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{40, 1, 0}
}

// Request message for [CloudChannelService.CheckCloudIdentityAccountsExist][google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist].
type CheckCloudIdentityAccountsExistRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account.
	// The parent takes the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Domain for which the Cloud Identity account customer is fetched.
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *CheckCloudIdentityAccountsExistRequest) Reset() {
	*x = CheckCloudIdentityAccountsExistRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckCloudIdentityAccountsExistRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckCloudIdentityAccountsExistRequest) ProtoMessage() {}

func (x *CheckCloudIdentityAccountsExistRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckCloudIdentityAccountsExistRequest.ProtoReflect.Descriptor instead.
func (*CheckCloudIdentityAccountsExistRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *CheckCloudIdentityAccountsExistRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CheckCloudIdentityAccountsExistRequest) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// Entity representing a Cloud Identity account which may or may not be
// associated with a Channel Services API partner.
type CloudIdentityCustomerAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if a Cloud Identity account exists for a specific domain.
	Existing bool `protobuf:"varint,1,opt,name=existing,proto3" json:"existing,omitempty"`
	// True if the Cloud Identity account is associated with a customer
	// belonging to the Channel Services partner making the API call.
	Owned bool `protobuf:"varint,2,opt,name=owned,proto3" json:"owned,omitempty"`
	// Name of the customer that owns the Cloud Identity account. This field is
	// populated ONLY if owned = true.
	// The customer_name takes the format:
	// accounts/{account_id}/customers/{customer_id}
	CustomerName string `protobuf:"bytes,3,opt,name=customer_name,json=customerName,proto3" json:"customer_name,omitempty"`
	// Cloud Identity ID of the customer. This field is populated ONLY if
	// existing = true.
	CustomerCloudIdentityId string `protobuf:"bytes,4,opt,name=customer_cloud_identity_id,json=customerCloudIdentityId,proto3" json:"customer_cloud_identity_id,omitempty"`
}

func (x *CloudIdentityCustomerAccount) Reset() {
	*x = CloudIdentityCustomerAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudIdentityCustomerAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudIdentityCustomerAccount) ProtoMessage() {}

func (x *CloudIdentityCustomerAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudIdentityCustomerAccount.ProtoReflect.Descriptor instead.
func (*CloudIdentityCustomerAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *CloudIdentityCustomerAccount) GetExisting() bool {
	if x != nil {
		return x.Existing
	}
	return false
}

func (x *CloudIdentityCustomerAccount) GetOwned() bool {
	if x != nil {
		return x.Owned
	}
	return false
}

func (x *CloudIdentityCustomerAccount) GetCustomerName() string {
	if x != nil {
		return x.CustomerName
	}
	return ""
}

func (x *CloudIdentityCustomerAccount) GetCustomerCloudIdentityId() string {
	if x != nil {
		return x.CustomerCloudIdentityId
	}
	return ""
}

// Response message for
// [CloudChannelService.CheckCloudIdentityAccountsExist][google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist].
type CheckCloudIdentityAccountsExistResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Identity accounts associated with the domain.
	CloudIdentityAccounts []*CloudIdentityCustomerAccount `protobuf:"bytes,1,rep,name=cloud_identity_accounts,json=cloudIdentityAccounts,proto3" json:"cloud_identity_accounts,omitempty"`
}

func (x *CheckCloudIdentityAccountsExistResponse) Reset() {
	*x = CheckCloudIdentityAccountsExistResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckCloudIdentityAccountsExistResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckCloudIdentityAccountsExistResponse) ProtoMessage() {}

func (x *CheckCloudIdentityAccountsExistResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckCloudIdentityAccountsExistResponse.ProtoReflect.Descriptor instead.
func (*CheckCloudIdentityAccountsExistResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *CheckCloudIdentityAccountsExistResponse) GetCloudIdentityAccounts() []*CloudIdentityCustomerAccount {
	if x != nil {
		return x.CloudIdentityAccounts
	}
	return nil
}

// Request message for [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers]
type ListCustomersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account from which to list customers.
	// The parent takes the format: accounts/{account_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of customers to return. The service may return fewer
	// than this value. If unspecified, at most 10 customers will be returned. The
	// maximum value is 50; values about 50 will be coerced to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	// Typically obtained via
	// [ListCustomersResponse.next_page_token][google.cloud.channel.v1.ListCustomersResponse.next_page_token] of the previous
	// [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomersRequest) Reset() {
	*x = ListCustomersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomersRequest) ProtoMessage() {}

func (x *ListCustomersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomersRequest.ProtoReflect.Descriptor instead.
func (*ListCustomersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListCustomersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [CloudChannelService.ListCustomers][google.cloud.channel.v1.CloudChannelService.ListCustomers].
type ListCustomersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The customers belonging to the reseller or distributor.
	Customers []*Customer `protobuf:"bytes,1,rep,name=customers,proto3" json:"customers,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListCustomersRequest.page_token][google.cloud.channel.v1.ListCustomersRequest.page_token] to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomersResponse) Reset() {
	*x = ListCustomersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomersResponse) ProtoMessage() {}

func (x *ListCustomersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomersResponse.ProtoReflect.Descriptor instead.
func (*ListCustomersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListCustomersResponse) GetCustomers() []*Customer {
	if x != nil {
		return x.Customers
	}
	return nil
}

func (x *ListCustomersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [CloudChannelService.GetCustomer][google.cloud.channel.v1.CloudChannelService.GetCustomer].
type GetCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer to retrieve.
	// The name takes the format: accounts/{account_id}/customers/{customer_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomerRequest) Reset() {
	*x = GetCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomerRequest) ProtoMessage() {}

func (x *GetCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomerRequest.ProtoReflect.Descriptor instead.
func (*GetCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetCustomerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [CloudChannelService.CreateCustomer][google.cloud.channel.v1.CloudChannelService.CreateCustomer]
type CreateCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller account in which to create the customer.
	// The parent takes the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The customer to create.
	Customer *Customer `protobuf:"bytes,2,opt,name=customer,proto3" json:"customer,omitempty"`
}

func (x *CreateCustomerRequest) Reset() {
	*x = CreateCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomerRequest) ProtoMessage() {}

func (x *CreateCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomerRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateCustomerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomerRequest) GetCustomer() *Customer {
	if x != nil {
		return x.Customer
	}
	return nil
}

// Request message for [CloudChannelService.UpdateCustomer][google.cloud.channel.v1.CloudChannelService.UpdateCustomer].
type UpdateCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. New contents of the customer.
	Customer *Customer `protobuf:"bytes,2,opt,name=customer,proto3" json:"customer,omitempty"`
	// The update mask that applies to the resource.
	// Optional.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomerRequest) Reset() {
	*x = UpdateCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomerRequest) ProtoMessage() {}

func (x *UpdateCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomerRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCustomerRequest) GetCustomer() *Customer {
	if x != nil {
		return x.Customer
	}
	return nil
}

func (x *UpdateCustomerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for [CloudChannelService.DeleteCustomer][google.cloud.channel.v1.CloudChannelService.DeleteCustomer].
type DeleteCustomerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the customer to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCustomerRequest) Reset() {
	*x = DeleteCustomerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCustomerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomerRequest) ProtoMessage() {}

func (x *DeleteCustomerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomerRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteCustomerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [CloudChannelService.ProvisionCloudIdentity][google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity]
type ProvisionCloudIdentityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the customer.
	// Format: accounts/{account_id}/customers/{customer_id}
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// CloudIdentity-specific customer information.
	CloudIdentityInfo *CloudIdentityInfo `protobuf:"bytes,2,opt,name=cloud_identity_info,json=cloudIdentityInfo,proto3" json:"cloud_identity_info,omitempty"`
	// Admin user information.
	User *AdminUser `protobuf:"bytes,3,opt,name=user,proto3" json:"user,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *ProvisionCloudIdentityRequest) Reset() {
	*x = ProvisionCloudIdentityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionCloudIdentityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionCloudIdentityRequest) ProtoMessage() {}

func (x *ProvisionCloudIdentityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionCloudIdentityRequest.ProtoReflect.Descriptor instead.
func (*ProvisionCloudIdentityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *ProvisionCloudIdentityRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ProvisionCloudIdentityRequest) GetCloudIdentityInfo() *CloudIdentityInfo {
	if x != nil {
		return x.CloudIdentityInfo
	}
	return nil
}

func (x *ProvisionCloudIdentityRequest) GetUser() *AdminUser {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ProvisionCloudIdentityRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements]
type ListEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller's customer account for which to list
	// entitlements.
	// The parent takes the format: accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 50 entitlements will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	// Typically obtained via
	// [ListEntitlementsResponse.next_page_token][google.cloud.channel.v1.ListEntitlementsResponse.next_page_token] of the previous
	// [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntitlementsRequest) Reset() {
	*x = ListEntitlementsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsRequest) ProtoMessage() {}

func (x *ListEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*ListEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitlementsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitlementsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [CloudChannelService.ListEntitlements][google.cloud.channel.v1.CloudChannelService.ListEntitlements].
type ListEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entitlements belonging to the reseller's customer.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// A token to List next page of results.
	// Pass to [ListEntitlementsRequest.page_token][google.cloud.channel.v1.ListEntitlementsRequest.page_token] to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntitlementsResponse) Reset() {
	*x = ListEntitlementsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsResponse) ProtoMessage() {}

func (x *ListEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*ListEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *ListEntitlementsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus]
type ListTransferableSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identity of transferred customer.
	// Either a cloud_identity_id of the customer OR the customer name is
	// required to look up transferable SKUs.
	//
	// Types that are assignable to TransferredCustomerIdentity:
	//	*ListTransferableSkusRequest_CloudIdentityId
	//	*ListTransferableSkusRequest_CustomerName
	TransferredCustomerIdentity isListTransferableSkusRequest_TransferredCustomerIdentity `protobuf_oneof:"transferred_customer_identity"`
	// Required. The resource name of the reseller's account.
	// The parent takes the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 SKUs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	// Optional.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results, if other than the first one.
	// Typically obtained via
	// [ListTransferableSkusResponse.next_page_token][google.cloud.channel.v1.ListTransferableSkusResponse.next_page_token] of the previous
	// [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus] call.
	// Optional.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// This token is generated by the Super Admin of the resold customer to
	// authorize a reseller to access their Cloud Identity and purchase
	// entitlements on their behalf. This token can be omitted once the
	// authorization is generated. See https://support.google.com/a/answer/7643790
	// for more details.
	AuthToken string `protobuf:"bytes,5,opt,name=auth_token,json=authToken,proto3" json:"auth_token,omitempty"`
	// The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	// Optional.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListTransferableSkusRequest) Reset() {
	*x = ListTransferableSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableSkusRequest) ProtoMessage() {}

func (x *ListTransferableSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableSkusRequest.ProtoReflect.Descriptor instead.
func (*ListTransferableSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{12}
}

func (m *ListTransferableSkusRequest) GetTransferredCustomerIdentity() isListTransferableSkusRequest_TransferredCustomerIdentity {
	if m != nil {
		return m.TransferredCustomerIdentity
	}
	return nil
}

func (x *ListTransferableSkusRequest) GetCloudIdentityId() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableSkusRequest_CloudIdentityId); ok {
		return x.CloudIdentityId
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetCustomerName() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableSkusRequest_CustomerName); ok {
		return x.CustomerName
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferableSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetAuthToken() string {
	if x != nil {
		return x.AuthToken
	}
	return ""
}

func (x *ListTransferableSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListTransferableSkusRequest_TransferredCustomerIdentity interface {
	isListTransferableSkusRequest_TransferredCustomerIdentity()
}

type ListTransferableSkusRequest_CloudIdentityId struct {
	// Customer's Cloud Identity ID
	CloudIdentityId string `protobuf:"bytes,4,opt,name=cloud_identity_id,json=cloudIdentityId,proto3,oneof"`
}

type ListTransferableSkusRequest_CustomerName struct {
	// A reseller is required to create a customer and use the resource name of
	// the created customer here.
	// The customer_name takes the format:
	// accounts/{account_id}/customers/{customer_id}
	CustomerName string `protobuf:"bytes,7,opt,name=customer_name,json=customerName,proto3,oneof"`
}

func (*ListTransferableSkusRequest_CloudIdentityId) isListTransferableSkusRequest_TransferredCustomerIdentity() {
}

func (*ListTransferableSkusRequest_CustomerName) isListTransferableSkusRequest_TransferredCustomerIdentity() {
}

// Response message for [CloudChannelService.ListTransferableSkus][google.cloud.channel.v1.CloudChannelService.ListTransferableSkus].
type ListTransferableSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about existing SKUs for a customer that would need to be
	// transferred.
	TransferableSkus []*TransferableSku `protobuf:"bytes,1,rep,name=transferable_skus,json=transferableSkus,proto3" json:"transferable_skus,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListTransferableSkusRequest.page_token][google.cloud.channel.v1.ListTransferableSkusRequest.page_token] to obtain
	// that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferableSkusResponse) Reset() {
	*x = ListTransferableSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableSkusResponse) ProtoMessage() {}

func (x *ListTransferableSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableSkusResponse.ProtoReflect.Descriptor instead.
func (*ListTransferableSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListTransferableSkusResponse) GetTransferableSkus() []*TransferableSku {
	if x != nil {
		return x.TransferableSkus
	}
	return nil
}

func (x *ListTransferableSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers]
type ListTransferableOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identity of transferred customer.
	// Either a cloud_identity_id of the customer OR the customer name is
	// required to look up transferrable Offers.
	//
	// Types that are assignable to TransferredCustomerIdentity:
	//	*ListTransferableOffersRequest_CloudIdentityId
	//	*ListTransferableOffersRequest_CustomerName
	TransferredCustomerIdentity isListTransferableOffersRequest_TransferredCustomerIdentity `protobuf_oneof:"transferred_customer_identity"`
	// Required. The resource name of the reseller's account.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 Offers will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results, if other than the first one.
	// Typically obtained via
	// [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
	// [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. SKU for which the Offers are being looked up.
	Sku string `protobuf:"bytes,6,opt,name=sku,proto3" json:"sku,omitempty"`
	// The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListTransferableOffersRequest) Reset() {
	*x = ListTransferableOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableOffersRequest) ProtoMessage() {}

func (x *ListTransferableOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableOffersRequest.ProtoReflect.Descriptor instead.
func (*ListTransferableOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{14}
}

func (m *ListTransferableOffersRequest) GetTransferredCustomerIdentity() isListTransferableOffersRequest_TransferredCustomerIdentity {
	if m != nil {
		return m.TransferredCustomerIdentity
	}
	return nil
}

func (x *ListTransferableOffersRequest) GetCloudIdentityId() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableOffersRequest_CloudIdentityId); ok {
		return x.CloudIdentityId
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetCustomerName() string {
	if x, ok := x.GetTransferredCustomerIdentity().(*ListTransferableOffersRequest_CustomerName); ok {
		return x.CustomerName
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferableOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetSku() string {
	if x != nil {
		return x.Sku
	}
	return ""
}

func (x *ListTransferableOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListTransferableOffersRequest_TransferredCustomerIdentity interface {
	isListTransferableOffersRequest_TransferredCustomerIdentity()
}

type ListTransferableOffersRequest_CloudIdentityId struct {
	// Customer's Cloud Identity ID
	CloudIdentityId string `protobuf:"bytes,4,opt,name=cloud_identity_id,json=cloudIdentityId,proto3,oneof"`
}

type ListTransferableOffersRequest_CustomerName struct {
	// A reseller should create a customer and use the resource name of
	// the created customer here.
	CustomerName string `protobuf:"bytes,5,opt,name=customer_name,json=customerName,proto3,oneof"`
}

func (*ListTransferableOffersRequest_CloudIdentityId) isListTransferableOffersRequest_TransferredCustomerIdentity() {
}

func (*ListTransferableOffersRequest_CustomerName) isListTransferableOffersRequest_TransferredCustomerIdentity() {
}

// Response message for [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers].
type ListTransferableOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about Offers for a customer that can be used for
	// transfer.
	TransferableOffers []*TransferableOffer `protobuf:"bytes,1,rep,name=transferable_offers,json=transferableOffers,proto3" json:"transferable_offers,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListTransferableOffersRequest.page_token][google.cloud.channel.v1.ListTransferableOffersRequest.page_token] to obtain
	// that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferableOffersResponse) Reset() {
	*x = ListTransferableOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferableOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferableOffersResponse) ProtoMessage() {}

func (x *ListTransferableOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferableOffersResponse.ProtoReflect.Descriptor instead.
func (*ListTransferableOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListTransferableOffersResponse) GetTransferableOffers() []*TransferableOffer {
	if x != nil {
		return x.TransferableOffers
	}
	return nil
}

func (x *ListTransferableOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// TransferableOffer represents an Offer that can be used in Transfer.
// Read-only.
type TransferableOffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offer with parameter constraints updated to allow the Transfer.
	Offer *Offer `protobuf:"bytes,1,opt,name=offer,proto3" json:"offer,omitempty"`
}

func (x *TransferableOffer) Reset() {
	*x = TransferableOffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferableOffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferableOffer) ProtoMessage() {}

func (x *TransferableOffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferableOffer.ProtoReflect.Descriptor instead.
func (*TransferableOffer) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{16}
}

func (x *TransferableOffer) GetOffer() *Offer {
	if x != nil {
		return x.Offer
	}
	return nil
}

// Request message for [CloudChannelService.GetEntitlement][google.cloud.channel.v1.CloudChannelService.GetEntitlement].
type GetEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to retrieve.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntitlementRequest) Reset() {
	*x = GetEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntitlementRequest) ProtoMessage() {}

func (x *GetEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntitlementRequest.ProtoReflect.Descriptor instead.
func (*GetEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks]
type ListChannelPartnerLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account for listing channel partner
	// links.
	// The parent takes the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, server will pick a default size (25).
	// The maximum value is 200, values above 200 will be coerced to 200.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	// Typically obtained via
	// [ListChannelPartnerLinksResponse.next_page_token][google.cloud.channel.v1.ListChannelPartnerLinksResponse.next_page_token] of the previous
	// [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The level of granularity the ChannelPartnerLink will display.
	View ChannelPartnerLinkView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.channel.v1.ChannelPartnerLinkView" json:"view,omitempty"`
}

func (x *ListChannelPartnerLinksRequest) Reset() {
	*x = ListChannelPartnerLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerLinksRequest) ProtoMessage() {}

func (x *ListChannelPartnerLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerLinksRequest.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListChannelPartnerLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChannelPartnerLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChannelPartnerLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListChannelPartnerLinksRequest) GetView() ChannelPartnerLinkView {
	if x != nil {
		return x.View
	}
	return ChannelPartnerLinkView_UNSPECIFIED
}

// Response message for [CloudChannelService.ListChannelPartnerLinks][google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks].
type ListChannelPartnerLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Channel partner links for a reseller.
	ChannelPartnerLinks []*ChannelPartnerLink `protobuf:"bytes,1,rep,name=channel_partner_links,json=channelPartnerLinks,proto3" json:"channel_partner_links,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to [ListChannelPartnerLinksRequest.page_token][google.cloud.channel.v1.ListChannelPartnerLinksRequest.page_token] to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChannelPartnerLinksResponse) Reset() {
	*x = ListChannelPartnerLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelPartnerLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelPartnerLinksResponse) ProtoMessage() {}

func (x *ListChannelPartnerLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelPartnerLinksResponse.ProtoReflect.Descriptor instead.
func (*ListChannelPartnerLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListChannelPartnerLinksResponse) GetChannelPartnerLinks() []*ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLinks
	}
	return nil
}

func (x *ListChannelPartnerLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [CloudChannelService.GetChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink].
type GetChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the channel partner link to retrieve.
	// The name takes the format: accounts/{account_id}/channelPartnerLinks/{id}
	// where {id} is the Cloud Identity ID of the partner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of granularity the ChannelPartnerLink will display.
	View ChannelPartnerLinkView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.channel.v1.ChannelPartnerLinkView" json:"view,omitempty"`
}

func (x *GetChannelPartnerLinkRequest) Reset() {
	*x = GetChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChannelPartnerLinkRequest) ProtoMessage() {}

func (x *GetChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*GetChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{20}
}

func (x *GetChannelPartnerLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetChannelPartnerLinkRequest) GetView() ChannelPartnerLinkView {
	if x != nil {
		return x.View
	}
	return ChannelPartnerLinkView_UNSPECIFIED
}

// Request message for [CloudChannelService.CreateChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink]
type CreateChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller's account for which to create a channel
	// partner link.
	// The parent takes the format: accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The channel partner link to create.
	// Either channel_partner_link.reseller_cloud_identity_id or domain can be
	// used to create a link.
	ChannelPartnerLink *ChannelPartnerLink `protobuf:"bytes,2,opt,name=channel_partner_link,json=channelPartnerLink,proto3" json:"channel_partner_link,omitempty"`
	// Optional. The invited partner's domain. Either domain or
	// channel_partner_link.reseller_cloud_identity_id can be used to create a
	// link.
	Domain string `protobuf:"bytes,3,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *CreateChannelPartnerLinkRequest) Reset() {
	*x = CreateChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChannelPartnerLinkRequest) ProtoMessage() {}

func (x *CreateChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{21}
}

func (x *CreateChannelPartnerLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChannelPartnerLinkRequest) GetChannelPartnerLink() *ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLink
	}
	return nil
}

func (x *CreateChannelPartnerLinkRequest) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// Request message for [CloudChannelService.UpdateChannelPartnerLink][google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink]
type UpdateChannelPartnerLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the channel partner link to cancel.
	// The name takes the format: accounts/{account_id}/channelPartnerLinks/{id}
	// where {id} is the Cloud Identity ID of the partner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The channel partner link to update. Only field
	// channel_partner_link.link_state is allowed to be updated.
	ChannelPartnerLink *ChannelPartnerLink `protobuf:"bytes,2,opt,name=channel_partner_link,json=channelPartnerLink,proto3" json:"channel_partner_link,omitempty"`
	// Required. The update mask that applies to the resource.
	// The only allowable value for update mask is
	// channel_partner_link.link_state.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateChannelPartnerLinkRequest) Reset() {
	*x = UpdateChannelPartnerLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateChannelPartnerLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChannelPartnerLinkRequest) ProtoMessage() {}

func (x *UpdateChannelPartnerLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChannelPartnerLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateChannelPartnerLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateChannelPartnerLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateChannelPartnerLinkRequest) GetChannelPartnerLink() *ChannelPartnerLink {
	if x != nil {
		return x.ChannelPartnerLink
	}
	return nil
}

func (x *UpdateChannelPartnerLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement]
type CreateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller's customer account in which to create the
	// entitlement.
	// The parent takes the format: accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entitlement to create.
	Entitlement *Entitlement `protobuf:"bytes,2,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateEntitlementRequest) Reset() {
	*x = CreateEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntitlementRequest) ProtoMessage() {}

func (x *CreateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*CreateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{23}
}

func (x *CreateEntitlementRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntitlementRequest) GetEntitlement() *Entitlement {
	if x != nil {
		return x.Entitlement
	}
	return nil
}

func (x *CreateEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.TransferEntitlements][google.cloud.channel.v1.CloudChannelService.TransferEntitlements].
type TransferEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller's customer account where the entitlements
	// transfer to.
	// The parent takes the format: accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The new entitlements to be created or transferred.
	Entitlements []*Entitlement `protobuf:"bytes,2,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// This token is generated by the Super Admin of the resold customer to
	// authorize a reseller to access their Cloud Identity and purchase
	// entitlements on their behalf. This token can be omitted once the
	// authorization is generated. See https://support.google.com/a/answer/7643790
	// for more details.
	AuthToken string `protobuf:"bytes,4,opt,name=auth_token,json=authToken,proto3" json:"auth_token,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *TransferEntitlementsRequest) Reset() {
	*x = TransferEntitlementsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsRequest) ProtoMessage() {}

func (x *TransferEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{24}
}

func (x *TransferEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TransferEntitlementsRequest) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *TransferEntitlementsRequest) GetAuthToken() string {
	if x != nil {
		return x.AuthToken
	}
	return ""
}

func (x *TransferEntitlementsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for [CloudChannelService.TransferEntitlements][google.cloud.channel.v1.CloudChannelService.TransferEntitlements].
// This will be put into the response field of google.longrunning.Operation.
type TransferEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entitlements that have been transferred.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
}

func (x *TransferEntitlementsResponse) Reset() {
	*x = TransferEntitlementsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsResponse) ProtoMessage() {}

func (x *TransferEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{25}
}

func (x *TransferEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

// Request message for [CloudChannelService.TransferEntitlementsToGoogle][google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle].
type TransferEntitlementsToGoogleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of reseller's customer account where the entitlements
	// transfer from.
	// The parent takes the format: accounts/{account_id}/customers/{customer_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entitlements to be transferred to Google.
	Entitlements []*Entitlement `protobuf:"bytes,2,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *TransferEntitlementsToGoogleRequest) Reset() {
	*x = TransferEntitlementsToGoogleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEntitlementsToGoogleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEntitlementsToGoogleRequest) ProtoMessage() {}

func (x *TransferEntitlementsToGoogleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEntitlementsToGoogleRequest.ProtoReflect.Descriptor instead.
func (*TransferEntitlementsToGoogleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{26}
}

func (x *TransferEntitlementsToGoogleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TransferEntitlementsToGoogleRequest) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *TransferEntitlementsToGoogleRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.ChangeParametersRequest][].
type ChangeParametersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to update.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Entitlement parameters to update. Only editable parameters are allowed to
	// be changed.
	Parameters []*Parameter `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be
	// a valid [UUID](https://tools.ietf.org/html/rfc4122) with the exception that
	// zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Purchase order ID provided by the reseller.
	PurchaseOrderId string `protobuf:"bytes,5,opt,name=purchase_order_id,json=purchaseOrderId,proto3" json:"purchase_order_id,omitempty"`
}

func (x *ChangeParametersRequest) Reset() {
	*x = ChangeParametersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeParametersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeParametersRequest) ProtoMessage() {}

func (x *ChangeParametersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeParametersRequest.ProtoReflect.Descriptor instead.
func (*ChangeParametersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{27}
}

func (x *ChangeParametersRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeParametersRequest) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ChangeParametersRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ChangeParametersRequest) GetPurchaseOrderId() string {
	if x != nil {
		return x.PurchaseOrderId
	}
	return ""
}

// Request message for [CloudChannelService.ChangeRenewalSettings][google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings].
type ChangeRenewalSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to update.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New renewal settings.
	RenewalSettings *RenewalSettings `protobuf:"bytes,4,opt,name=renewal_settings,json=renewalSettings,proto3" json:"renewal_settings,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ChangeRenewalSettingsRequest) Reset() {
	*x = ChangeRenewalSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeRenewalSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeRenewalSettingsRequest) ProtoMessage() {}

func (x *ChangeRenewalSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeRenewalSettingsRequest.ProtoReflect.Descriptor instead.
func (*ChangeRenewalSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{28}
}

func (x *ChangeRenewalSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeRenewalSettingsRequest) GetRenewalSettings() *RenewalSettings {
	if x != nil {
		return x.RenewalSettings
	}
	return nil
}

func (x *ChangeRenewalSettingsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
type ChangeOfferRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement to update.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New Offer.
	// Format: accounts/{account_id}/offers/{offer_id}.
	Offer string `protobuf:"bytes,2,opt,name=offer,proto3" json:"offer,omitempty"`
	// Optional. Parameters needed to purchase the Offer.
	Parameters []*Parameter `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. Purchase order id provided by the reseller.
	PurchaseOrderId string `protobuf:"bytes,5,opt,name=purchase_order_id,json=purchaseOrderId,proto3" json:"purchase_order_id,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ChangeOfferRequest) Reset() {
	*x = ChangeOfferRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeOfferRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeOfferRequest) ProtoMessage() {}

func (x *ChangeOfferRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeOfferRequest.ProtoReflect.Descriptor instead.
func (*ChangeOfferRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{29}
}

func (x *ChangeOfferRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeOfferRequest) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

func (x *ChangeOfferRequest) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ChangeOfferRequest) GetPurchaseOrderId() string {
	if x != nil {
		return x.PurchaseOrderId
	}
	return ""
}

func (x *ChangeOfferRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.StartPaidService][google.cloud.channel.v1.CloudChannelService.StartPaidService].
type StartPaidServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entitlement for which paid service is being started.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StartPaidServiceRequest) Reset() {
	*x = StartPaidServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartPaidServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartPaidServiceRequest) ProtoMessage() {}

func (x *StartPaidServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartPaidServiceRequest.ProtoReflect.Descriptor instead.
func (*StartPaidServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{30}
}

func (x *StartPaidServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartPaidServiceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.CancelEntitlement][google.cloud.channel.v1.CloudChannelService.CancelEntitlement].
type CancelEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to cancel.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CancelEntitlementRequest) Reset() {
	*x = CancelEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelEntitlementRequest) ProtoMessage() {}

func (x *CancelEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelEntitlementRequest.ProtoReflect.Descriptor instead.
func (*CancelEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{31}
}

func (x *CancelEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CancelEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.SuspendEntitlement][google.cloud.channel.v1.CloudChannelService.SuspendEntitlement].
type SuspendEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to suspend.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *SuspendEntitlementRequest) Reset() {
	*x = SuspendEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuspendEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuspendEntitlementRequest) ProtoMessage() {}

func (x *SuspendEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuspendEntitlementRequest.ProtoReflect.Descriptor instead.
func (*SuspendEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{32}
}

func (x *SuspendEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SuspendEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [CloudChannelService.ActivateEntitlement][google.cloud.channel.v1.CloudChannelService.ActivateEntitlement].
type ActivateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entitlement to activate.
	// The name takes the format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique request ID so
	// that if you must retry your request, the server will know to ignore the
	// request if it has already been completed.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same
	// request ID, the server can check if the original operation with the same
	// request ID was received, and if so, will ignore the second request.
	//
	// The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
	// with the exception that zero UUID is not supported
	// (`00000000-0000-0000-0000-000000000000`).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ActivateEntitlementRequest) Reset() {
	*x = ActivateEntitlementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateEntitlementRequest) ProtoMessage() {}

func (x *ActivateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*ActivateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{33}
}

func (x *ActivateEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ActivateEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for ListProducts.
type ListProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account.
	// Format: accounts/{account_id}.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 Products will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListProductsRequest) Reset() {
	*x = ListProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsRequest) ProtoMessage() {}

func (x *ListProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsRequest.ProtoReflect.Descriptor instead.
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{34}
}

func (x *ListProductsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProductsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for ListProducts.
type ListProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Products requested.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductsResponse) Reset() {
	*x = ListProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsResponse) ProtoMessage() {}

func (x *ListProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsResponse.ProtoReflect.Descriptor instead.
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListProductsResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *ListProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListSkus.
type ListSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Product for which to list SKUs.
	// The parent takes the format: products/{product_id}.
	// Supports products/- to retrieve SKUs for all products.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Resource name of the reseller.
	// Format: accounts/{account_id}.
	Account string `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 SKUs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	// Optional.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListSkusRequest) Reset() {
	*x = ListSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusRequest) ProtoMessage() {}

func (x *ListSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusRequest.ProtoReflect.Descriptor instead.
func (*ListSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSkusRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *ListSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for ListSkus.
type ListSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SKUs requested.
	Skus []*Sku `protobuf:"bytes,1,rep,name=skus,proto3" json:"skus,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSkusResponse) Reset() {
	*x = ListSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusResponse) ProtoMessage() {}

func (x *ListSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusResponse.ProtoReflect.Descriptor instead.
func (*ListSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{37}
}

func (x *ListSkusResponse) GetSkus() []*Sku {
	if x != nil {
		return x.Skus
	}
	return nil
}

func (x *ListSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListOffers.
type ListOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reseller account from which to list Offers.
	// The parent takes the format: accounts/{account_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 500 Offers will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The expression to filter results by name (name of
	// the Offer), sku.name (name of the SKU) or sku.product.name (name of the
	// Product).
	// Example 1: sku.product.name=products/p1 AND sku.name!=products/p1/skus/s1
	// Example 2: name=accounts/a1/offers/o1
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListOffersRequest) Reset() {
	*x = ListOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOffersRequest) ProtoMessage() {}

func (x *ListOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOffersRequest.ProtoReflect.Descriptor instead.
func (*ListOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{38}
}

func (x *ListOffersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOffersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for ListOffers.
type ListOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Offers requested.
	Offers []*Offer `protobuf:"bytes,1,rep,name=offers,proto3" json:"offers,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOffersResponse) Reset() {
	*x = ListOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOffersResponse) ProtoMessage() {}

func (x *ListOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOffersResponse.ProtoReflect.Descriptor instead.
func (*ListOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{39}
}

func (x *ListOffersResponse) GetOffers() []*Offer {
	if x != nil {
		return x.Offers
	}
	return nil
}

func (x *ListOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ListPurchasableSkus.
type ListPurchasableSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Purchase option for the request. Defines the purchase for which the SKUs
	// are being listed.
	//
	// Types that are assignable to PurchaseOption:
	//	*ListPurchasableSkusRequest_CreateEntitlementPurchase_
	//	*ListPurchasableSkusRequest_ChangeOfferPurchase_
	PurchaseOption isListPurchasableSkusRequest_PurchaseOption `protobuf_oneof:"purchase_option"`
	// Required. The resource name of the customer for which to list SKUs.
	// Format: accounts/{account_id}/customers/{customer_id}.
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 SKUs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListPurchasableSkusRequest) Reset() {
	*x = ListPurchasableSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest) ProtoMessage() {}

func (x *ListPurchasableSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{40}
}

func (m *ListPurchasableSkusRequest) GetPurchaseOption() isListPurchasableSkusRequest_PurchaseOption {
	if m != nil {
		return m.PurchaseOption
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetCreateEntitlementPurchase() *ListPurchasableSkusRequest_CreateEntitlementPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableSkusRequest_CreateEntitlementPurchase_); ok {
		return x.CreateEntitlementPurchase
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetChangeOfferPurchase() *ListPurchasableSkusRequest_ChangeOfferPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableSkusRequest_ChangeOfferPurchase_); ok {
		return x.ChangeOfferPurchase
	}
	return nil
}

func (x *ListPurchasableSkusRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ListPurchasableSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPurchasableSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPurchasableSkusRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListPurchasableSkusRequest_PurchaseOption interface {
	isListPurchasableSkusRequest_PurchaseOption()
}

type ListPurchasableSkusRequest_CreateEntitlementPurchase_ struct {
	// List SKUs for CreateEntitlement purchase.
	CreateEntitlementPurchase *ListPurchasableSkusRequest_CreateEntitlementPurchase `protobuf:"bytes,2,opt,name=create_entitlement_purchase,json=createEntitlementPurchase,proto3,oneof"`
}

type ListPurchasableSkusRequest_ChangeOfferPurchase_ struct {
	// List SKUs for ChangeOffer purchase with a new SKU.
	ChangeOfferPurchase *ListPurchasableSkusRequest_ChangeOfferPurchase `protobuf:"bytes,3,opt,name=change_offer_purchase,json=changeOfferPurchase,proto3,oneof"`
}

func (*ListPurchasableSkusRequest_CreateEntitlementPurchase_) isListPurchasableSkusRequest_PurchaseOption() {
}

func (*ListPurchasableSkusRequest_ChangeOfferPurchase_) isListPurchasableSkusRequest_PurchaseOption() {
}

// Response message for ListPurchasableSkus.
type ListPurchasableSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SKUs requested.
	PurchasableSkus []*PurchasableSku `protobuf:"bytes,1,rep,name=purchasable_skus,json=purchasableSkus,proto3" json:"purchasable_skus,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPurchasableSkusResponse) Reset() {
	*x = ListPurchasableSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusResponse) ProtoMessage() {}

func (x *ListPurchasableSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusResponse.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{41}
}

func (x *ListPurchasableSkusResponse) GetPurchasableSkus() []*PurchasableSku {
	if x != nil {
		return x.PurchasableSkus
	}
	return nil
}

func (x *ListPurchasableSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// SKU that can be used for a puchase. This is used in ListPurchasableSku API
// response.
type PurchasableSku struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SKU
	Sku *Sku `protobuf:"bytes,1,opt,name=sku,proto3" json:"sku,omitempty"`
}

func (x *PurchasableSku) Reset() {
	*x = PurchasableSku{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurchasableSku) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurchasableSku) ProtoMessage() {}

func (x *PurchasableSku) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurchasableSku.ProtoReflect.Descriptor instead.
func (*PurchasableSku) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{42}
}

func (x *PurchasableSku) GetSku() *Sku {
	if x != nil {
		return x.Sku
	}
	return nil
}

// Request message for ListPurchasableOffers.
type ListPurchasableOffersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Purchase option for the request. Defines the purchase for which the Offers
	// are being listed.
	//
	// Types that are assignable to PurchaseOption:
	//	*ListPurchasableOffersRequest_CreateEntitlementPurchase_
	//	*ListPurchasableOffersRequest_ChangeOfferPurchase_
	PurchaseOption isListPurchasableOffersRequest_PurchaseOption `protobuf_oneof:"purchase_option"`
	// Required. The resource name of the customer for which to list Offers.
	// Format: accounts/{account_id}/customers/{customer_id}.
	Customer string `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// Optional. Requested page size. Server might return fewer results than requested.
	// If unspecified, at most 100 Offers will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results, if other than the first one.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response will be localized to the corresponding language code. Default is
	// "en-US".
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListPurchasableOffersRequest) Reset() {
	*x = ListPurchasableOffersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest) ProtoMessage() {}

func (x *ListPurchasableOffersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{43}
}

func (m *ListPurchasableOffersRequest) GetPurchaseOption() isListPurchasableOffersRequest_PurchaseOption {
	if m != nil {
		return m.PurchaseOption
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetCreateEntitlementPurchase() *ListPurchasableOffersRequest_CreateEntitlementPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableOffersRequest_CreateEntitlementPurchase_); ok {
		return x.CreateEntitlementPurchase
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetChangeOfferPurchase() *ListPurchasableOffersRequest_ChangeOfferPurchase {
	if x, ok := x.GetPurchaseOption().(*ListPurchasableOffersRequest_ChangeOfferPurchase_); ok {
		return x.ChangeOfferPurchase
	}
	return nil
}

func (x *ListPurchasableOffersRequest) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *ListPurchasableOffersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPurchasableOffersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPurchasableOffersRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isListPurchasableOffersRequest_PurchaseOption interface {
	isListPurchasableOffersRequest_PurchaseOption()
}

type ListPurchasableOffersRequest_CreateEntitlementPurchase_ struct {
	// List Offers for CreateEntitlement purchase.
	CreateEntitlementPurchase *ListPurchasableOffersRequest_CreateEntitlementPurchase `protobuf:"bytes,2,opt,name=create_entitlement_purchase,json=createEntitlementPurchase,proto3,oneof"`
}

type ListPurchasableOffersRequest_ChangeOfferPurchase_ struct {
	// List Offers for ChangeOffer purchase.
	ChangeOfferPurchase *ListPurchasableOffersRequest_ChangeOfferPurchase `protobuf:"bytes,3,opt,name=change_offer_purchase,json=changeOfferPurchase,proto3,oneof"`
}

func (*ListPurchasableOffersRequest_CreateEntitlementPurchase_) isListPurchasableOffersRequest_PurchaseOption() {
}

func (*ListPurchasableOffersRequest_ChangeOfferPurchase_) isListPurchasableOffersRequest_PurchaseOption() {
}

// Response message for ListPurchasableOffers.
type ListPurchasableOffersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Offers requested.
	PurchasableOffers []*PurchasableOffer `protobuf:"bytes,1,rep,name=purchasable_offers,json=purchasableOffers,proto3" json:"purchasable_offers,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPurchasableOffersResponse) Reset() {
	*x = ListPurchasableOffersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersResponse) ProtoMessage() {}

func (x *ListPurchasableOffersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersResponse.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{44}
}

func (x *ListPurchasableOffersResponse) GetPurchasableOffers() []*PurchasableOffer {
	if x != nil {
		return x.PurchasableOffers
	}
	return nil
}

func (x *ListPurchasableOffersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Offer that can be puchased for a customer. This is used in
// ListPurchasableOffer API response.
type PurchasableOffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offer.
	Offer *Offer `protobuf:"bytes,1,opt,name=offer,proto3" json:"offer,omitempty"`
}

func (x *PurchasableOffer) Reset() {
	*x = PurchasableOffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurchasableOffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurchasableOffer) ProtoMessage() {}

func (x *PurchasableOffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurchasableOffer.ProtoReflect.Descriptor instead.
func (*PurchasableOffer) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{45}
}

func (x *PurchasableOffer) GetOffer() *Offer {
	if x != nil {
		return x.Offer
	}
	return nil
}

// List SKUs for a new entitlement. Make the purchase using
// [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement].
type ListPurchasableSkusRequest_CreateEntitlementPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List SKUs belonging to this Product.
	// Format: products/{product_id}.
	// Supports products/- to retrieve SKUs for all products.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) Reset() {
	*x = ListPurchasableSkusRequest_CreateEntitlementPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest_CreateEntitlementPurchase) ProtoMessage() {}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest_CreateEntitlementPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest_CreateEntitlementPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{40, 0}
}

func (x *ListPurchasableSkusRequest_CreateEntitlementPurchase) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

// List SKUs for upgrading or downgrading an entitlement. Make the purchase
// using [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
type ListPurchasableSkusRequest_ChangeOfferPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Required. Change Type for the entitlement.
	ChangeType ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.channel.v1.ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType" json:"change_type,omitempty"`
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) Reset() {
	*x = ListPurchasableSkusRequest_ChangeOfferPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableSkusRequest_ChangeOfferPurchase) ProtoMessage() {}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableSkusRequest_ChangeOfferPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableSkusRequest_ChangeOfferPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{40, 1}
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

func (x *ListPurchasableSkusRequest_ChangeOfferPurchase) GetChangeType() ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ListPurchasableSkusRequest_ChangeOfferPurchase_CHANGE_TYPE_UNSPECIFIED
}

// List Offers for CreateEntitlement purchase.
type ListPurchasableOffersRequest_CreateEntitlementPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SKU that the result should be restricted to.
	// Format: products/{product_id}/skus/{sku_id}.
	Sku string `protobuf:"bytes,1,opt,name=sku,proto3" json:"sku,omitempty"`
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) Reset() {
	*x = ListPurchasableOffersRequest_CreateEntitlementPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest_CreateEntitlementPurchase) ProtoMessage() {}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest_CreateEntitlementPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest_CreateEntitlementPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{43, 0}
}

func (x *ListPurchasableOffersRequest_CreateEntitlementPurchase) GetSku() string {
	if x != nil {
		return x.Sku
	}
	return ""
}

// List Offers for ChangeOffer purchase.
type ListPurchasableOffersRequest_ChangeOfferPurchase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Optional. Resource name of the SKU that is being changed to. Should be provided if
	// upgrading or downgrading an entitlement. Format:
	// products/{product_id}/skus/{sku_id}
	NewSku string `protobuf:"bytes,2,opt,name=new_sku,json=newSku,proto3" json:"new_sku,omitempty"`
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) Reset() {
	*x = ListPurchasableOffersRequest_ChangeOfferPurchase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPurchasableOffersRequest_ChangeOfferPurchase) ProtoMessage() {}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPurchasableOffersRequest_ChangeOfferPurchase.ProtoReflect.Descriptor instead.
func (*ListPurchasableOffersRequest_ChangeOfferPurchase) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_service_proto_rawDescGZIP(), []int{43, 1}
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

func (x *ListPurchasableOffersRequest_ChangeOfferPurchase) GetNewSku() string {
	if x != nil {
		return x.NewSku
	}
	return ""
}

var File_google_cloud_channel_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_service_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x62, 0x0a, 0x26, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22, 0xb2, 0x01, 0x0a, 0x1c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x65, 0x78,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x22, 0x98,
	0x01, 0x0a, 0x27, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6d, 0x0a, 0x17, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x22, 0x79, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f,
	0x0a, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x78, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x98, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa2, 0x02, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x13, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12,
	0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xa5, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x02, 0x0a, 0x1b,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61,
	0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x1f, 0x0a,
	0x1d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x9d,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x55, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x6b, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa,
	0x02, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x2c, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x25,
	0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x15,
	0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x03, 0x73, 0x6b, 0x75, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x1f, 0x0a, 0x1d, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xa5, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b,
	0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x49, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x22, 0x5c,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd, 0x01, 0x0a,
	0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x56, 0x69, 0x65,
	0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xaa, 0x01, 0x0a,
	0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5f, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x13, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x1c, 0x47, 0x65,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x56, 0x69,
	0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xbf, 0x01,
	0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x62,
	0x0a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22,
	0xe0, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x14,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xd1, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xcc, 0x01, 0x0a, 0x1b, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x68, 0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22,
	0xb5, 0x01, 0x0a, 0x23, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd0, 0x01, 0x0a, 0x17, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0xb5, 0x01, 0x0a, 0x1c, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72,
	0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x8c, 0x02, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66,
	0x66, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2f, 0x0a, 0x11,
	0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x56, 0x0a, 0x17, 0x53, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x57, 0x0a, 0x18, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x58, 0x0a, 0x19, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x59, 0x0a, 0x1a,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x7c,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe5, 0x01, 0x0a,
	0x0f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x22, 0x6c, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x6b, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6b, 0x75, 0x52, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x66, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x22, 0x74, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb6, 0x06, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x1b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x48, 0x00, 0x52, 0x19,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x15, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x65, 0x48, 0x00, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72,
	0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x1a, 0x3a, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x1a, 0xfd,
	0x01, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x78, 0x0a,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66,
	0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x45, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x4f, 0x57, 0x4e, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x02, 0x42, 0x11,
	0x0a, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x99, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x52, 0x0a, 0x10, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x52, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x40, 0x0a,
	0x0e, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x12,
	0x2e, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x52, 0x03, 0x73, 0x6b, 0x75, 0x22,
	0x90, 0x05, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x91, 0x01, 0x0a, 0x1b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x65, 0x12, 0x7f, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x48, 0x00,
	0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a,
	0x32, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x73, 0x6b, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x73, 0x6b, 0x75, 0x1a, 0x5a, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x1c, 0x0a, 0x07, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6b, 0x75, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6e, 0x65, 0x77, 0x53, 0x6b, 0x75, 0x42,
	0x11, 0x0a, 0x0f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x12, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x11, 0x70, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x48, 0x0a, 0x10, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x05, 0x6f, 0x66,
	0x66, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72,
	0x32, 0xb4, 0x2d, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x99, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe8, 0x01, 0x0a, 0x1f, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45,
	0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x45, 0x78, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x78, 0x69, 0x73, 0x74, 0x3a, 0x01,
	0x2a, 0x12, 0x98, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22,
	0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x3a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0xa1, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x32, 0x2a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x12, 0x8a, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd8, 0x01,
	0x0a, 0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb1, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xbc, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xc4, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22,
	0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x3a,
	0x01, 0x2a, 0x12, 0xa0, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x38, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd4, 0x01,
	0x0a, 0x10, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x41, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x01,
	0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xe3, 0x01, 0x0a, 0x15, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xca,
	0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46,
	0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x69, 0x64, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcf, 0x01, 0x0a, 0x12, 0x53, 0x75,
	0x73, 0x70, 0x65, 0x6e, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x73, 0x70, 0x65,
	0x6e, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x66, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x75,
	0x73, 0x70, 0x65, 0x6e, 0x64, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd6, 0x01, 0x0a, 0x11,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xd2, 0x01, 0x0a, 0x13, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe4, 0x01, 0x0a, 0x14, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22,
	0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x31, 0x0a,
	0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xf5, 0x01, 0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x54, 0x6f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc1, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xb0, 0x01, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xcc, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x2b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x14, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0xb9,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x32, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x12, 0x81, 0x01, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x14, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0e,
	0x12, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x85,
	0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72,
	0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6b, 0x75, 0x73, 0x12, 0xcb, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x1a, 0x4b, 0xca, 0x41, 0x1b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2a, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x6d, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_service_proto_rawDescData = file_google_cloud_channel_v1_service_proto_rawDesc
)

func file_google_cloud_channel_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_service_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_service_proto_rawDescData
}

var file_google_cloud_channel_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_channel_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_cloud_channel_v1_service_proto_goTypes = []interface{}{
	(ListPurchasableSkusRequest_ChangeOfferPurchase_ChangeType)(0), // 0: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
	(*CheckCloudIdentityAccountsExistRequest)(nil),                 // 1: google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest
	(*CloudIdentityCustomerAccount)(nil),                           // 2: google.cloud.channel.v1.CloudIdentityCustomerAccount
	(*CheckCloudIdentityAccountsExistResponse)(nil),                // 3: google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse
	(*ListCustomersRequest)(nil),                                   // 4: google.cloud.channel.v1.ListCustomersRequest
	(*ListCustomersResponse)(nil),                                  // 5: google.cloud.channel.v1.ListCustomersResponse
	(*GetCustomerRequest)(nil),                                     // 6: google.cloud.channel.v1.GetCustomerRequest
	(*CreateCustomerRequest)(nil),                                  // 7: google.cloud.channel.v1.CreateCustomerRequest
	(*UpdateCustomerRequest)(nil),                                  // 8: google.cloud.channel.v1.UpdateCustomerRequest
	(*DeleteCustomerRequest)(nil),                                  // 9: google.cloud.channel.v1.DeleteCustomerRequest
	(*ProvisionCloudIdentityRequest)(nil),                          // 10: google.cloud.channel.v1.ProvisionCloudIdentityRequest
	(*ListEntitlementsRequest)(nil),                                // 11: google.cloud.channel.v1.ListEntitlementsRequest
	(*ListEntitlementsResponse)(nil),                               // 12: google.cloud.channel.v1.ListEntitlementsResponse
	(*ListTransferableSkusRequest)(nil),                            // 13: google.cloud.channel.v1.ListTransferableSkusRequest
	(*ListTransferableSkusResponse)(nil),                           // 14: google.cloud.channel.v1.ListTransferableSkusResponse
	(*ListTransferableOffersRequest)(nil),                          // 15: google.cloud.channel.v1.ListTransferableOffersRequest
	(*ListTransferableOffersResponse)(nil),                         // 16: google.cloud.channel.v1.ListTransferableOffersResponse
	(*TransferableOffer)(nil),                                      // 17: google.cloud.channel.v1.TransferableOffer
	(*GetEntitlementRequest)(nil),                                  // 18: google.cloud.channel.v1.GetEntitlementRequest
	(*ListChannelPartnerLinksRequest)(nil),                         // 19: google.cloud.channel.v1.ListChannelPartnerLinksRequest
	(*ListChannelPartnerLinksResponse)(nil),                        // 20: google.cloud.channel.v1.ListChannelPartnerLinksResponse
	(*GetChannelPartnerLinkRequest)(nil),                           // 21: google.cloud.channel.v1.GetChannelPartnerLinkRequest
	(*CreateChannelPartnerLinkRequest)(nil),                        // 22: google.cloud.channel.v1.CreateChannelPartnerLinkRequest
	(*UpdateChannelPartnerLinkRequest)(nil),                        // 23: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest
	(*CreateEntitlementRequest)(nil),                               // 24: google.cloud.channel.v1.CreateEntitlementRequest
	(*TransferEntitlementsRequest)(nil),                            // 25: google.cloud.channel.v1.TransferEntitlementsRequest
	(*TransferEntitlementsResponse)(nil),                           // 26: google.cloud.channel.v1.TransferEntitlementsResponse
	(*TransferEntitlementsToGoogleRequest)(nil),                    // 27: google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
	(*ChangeParametersRequest)(nil),                                // 28: google.cloud.channel.v1.ChangeParametersRequest
	(*ChangeRenewalSettingsRequest)(nil),                           // 29: google.cloud.channel.v1.ChangeRenewalSettingsRequest
	(*ChangeOfferRequest)(nil),                                     // 30: google.cloud.channel.v1.ChangeOfferRequest
	(*StartPaidServiceRequest)(nil),                                // 31: google.cloud.channel.v1.StartPaidServiceRequest
	(*CancelEntitlementRequest)(nil),                               // 32: google.cloud.channel.v1.CancelEntitlementRequest
	(*SuspendEntitlementRequest)(nil),                              // 33: google.cloud.channel.v1.SuspendEntitlementRequest
	(*ActivateEntitlementRequest)(nil),                             // 34: google.cloud.channel.v1.ActivateEntitlementRequest
	(*ListProductsRequest)(nil),                                    // 35: google.cloud.channel.v1.ListProductsRequest
	(*ListProductsResponse)(nil),                                   // 36: google.cloud.channel.v1.ListProductsResponse
	(*ListSkusRequest)(nil),                                        // 37: google.cloud.channel.v1.ListSkusRequest
	(*ListSkusResponse)(nil),                                       // 38: google.cloud.channel.v1.ListSkusResponse
	(*ListOffersRequest)(nil),                                      // 39: google.cloud.channel.v1.ListOffersRequest
	(*ListOffersResponse)(nil),                                     // 40: google.cloud.channel.v1.ListOffersResponse
	(*ListPurchasableSkusRequest)(nil),                             // 41: google.cloud.channel.v1.ListPurchasableSkusRequest
	(*ListPurchasableSkusResponse)(nil),                            // 42: google.cloud.channel.v1.ListPurchasableSkusResponse
	(*PurchasableSku)(nil),                                         // 43: google.cloud.channel.v1.PurchasableSku
	(*ListPurchasableOffersRequest)(nil),                           // 44: google.cloud.channel.v1.ListPurchasableOffersRequest
	(*ListPurchasableOffersResponse)(nil),                          // 45: google.cloud.channel.v1.ListPurchasableOffersResponse
	(*PurchasableOffer)(nil),                                       // 46: google.cloud.channel.v1.PurchasableOffer
	(*ListPurchasableSkusRequest_CreateEntitlementPurchase)(nil),   // 47: google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
	(*ListPurchasableSkusRequest_ChangeOfferPurchase)(nil),         // 48: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
	(*ListPurchasableOffersRequest_CreateEntitlementPurchase)(nil), // 49: google.cloud.channel.v1.ListPurchasableOffersRequest.CreateEntitlementPurchase
	(*ListPurchasableOffersRequest_ChangeOfferPurchase)(nil),       // 50: google.cloud.channel.v1.ListPurchasableOffersRequest.ChangeOfferPurchase
	(*Customer)(nil),                                               // 51: google.cloud.channel.v1.Customer
	(*fieldmaskpb.FieldMask)(nil),                                  // 52: google.protobuf.FieldMask
	(*CloudIdentityInfo)(nil),                                      // 53: google.cloud.channel.v1.CloudIdentityInfo
	(*AdminUser)(nil),                                              // 54: google.cloud.channel.v1.AdminUser
	(*Entitlement)(nil),                                            // 55: google.cloud.channel.v1.Entitlement
	(*TransferableSku)(nil),                                        // 56: google.cloud.channel.v1.TransferableSku
	(*Offer)(nil),                                                  // 57: google.cloud.channel.v1.Offer
	(ChannelPartnerLinkView)(0),                                    // 58: google.cloud.channel.v1.ChannelPartnerLinkView
	(*ChannelPartnerLink)(nil),                                     // 59: google.cloud.channel.v1.ChannelPartnerLink
	(*Parameter)(nil),                                              // 60: google.cloud.channel.v1.Parameter
	(*RenewalSettings)(nil),                                        // 61: google.cloud.channel.v1.RenewalSettings
	(*Product)(nil),                                                // 62: google.cloud.channel.v1.Product
	(*Sku)(nil),                                                    // 63: google.cloud.channel.v1.Sku
	(*emptypb.Empty)(nil),                                          // 64: google.protobuf.Empty
	(*longrunning.Operation)(nil),                                  // 65: google.longrunning.Operation
}
var file_google_cloud_channel_v1_service_proto_depIdxs = []int32{
	2,  // 0: google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse.cloud_identity_accounts:type_name -> google.cloud.channel.v1.CloudIdentityCustomerAccount
	51, // 1: google.cloud.channel.v1.ListCustomersResponse.customers:type_name -> google.cloud.channel.v1.Customer
	51, // 2: google.cloud.channel.v1.CreateCustomerRequest.customer:type_name -> google.cloud.channel.v1.Customer
	51, // 3: google.cloud.channel.v1.UpdateCustomerRequest.customer:type_name -> google.cloud.channel.v1.Customer
	52, // 4: google.cloud.channel.v1.UpdateCustomerRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 5: google.cloud.channel.v1.ProvisionCloudIdentityRequest.cloud_identity_info:type_name -> google.cloud.channel.v1.CloudIdentityInfo
	54, // 6: google.cloud.channel.v1.ProvisionCloudIdentityRequest.user:type_name -> google.cloud.channel.v1.AdminUser
	55, // 7: google.cloud.channel.v1.ListEntitlementsResponse.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	56, // 8: google.cloud.channel.v1.ListTransferableSkusResponse.transferable_skus:type_name -> google.cloud.channel.v1.TransferableSku
	17, // 9: google.cloud.channel.v1.ListTransferableOffersResponse.transferable_offers:type_name -> google.cloud.channel.v1.TransferableOffer
	57, // 10: google.cloud.channel.v1.TransferableOffer.offer:type_name -> google.cloud.channel.v1.Offer
	58, // 11: google.cloud.channel.v1.ListChannelPartnerLinksRequest.view:type_name -> google.cloud.channel.v1.ChannelPartnerLinkView
	59, // 12: google.cloud.channel.v1.ListChannelPartnerLinksResponse.channel_partner_links:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	58, // 13: google.cloud.channel.v1.GetChannelPartnerLinkRequest.view:type_name -> google.cloud.channel.v1.ChannelPartnerLinkView
	59, // 14: google.cloud.channel.v1.CreateChannelPartnerLinkRequest.channel_partner_link:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	59, // 15: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest.channel_partner_link:type_name -> google.cloud.channel.v1.ChannelPartnerLink
	52, // 16: google.cloud.channel.v1.UpdateChannelPartnerLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	55, // 17: google.cloud.channel.v1.CreateEntitlementRequest.entitlement:type_name -> google.cloud.channel.v1.Entitlement
	55, // 18: google.cloud.channel.v1.TransferEntitlementsRequest.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	55, // 19: google.cloud.channel.v1.TransferEntitlementsResponse.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	55, // 20: google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.entitlements:type_name -> google.cloud.channel.v1.Entitlement
	60, // 21: google.cloud.channel.v1.ChangeParametersRequest.parameters:type_name -> google.cloud.channel.v1.Parameter
	61, // 22: google.cloud.channel.v1.ChangeRenewalSettingsRequest.renewal_settings:type_name -> google.cloud.channel.v1.RenewalSettings
	60, // 23: google.cloud.channel.v1.ChangeOfferRequest.parameters:type_name -> google.cloud.channel.v1.Parameter
	62, // 24: google.cloud.channel.v1.ListProductsResponse.products:type_name -> google.cloud.channel.v1.Product
	63, // 25: google.cloud.channel.v1.ListSkusResponse.skus:type_name -> google.cloud.channel.v1.Sku
	57, // 26: google.cloud.channel.v1.ListOffersResponse.offers:type_name -> google.cloud.channel.v1.Offer
	47, // 27: google.cloud.channel.v1.ListPurchasableSkusRequest.create_entitlement_purchase:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
	48, // 28: google.cloud.channel.v1.ListPurchasableSkusRequest.change_offer_purchase:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
	43, // 29: google.cloud.channel.v1.ListPurchasableSkusResponse.purchasable_skus:type_name -> google.cloud.channel.v1.PurchasableSku
	63, // 30: google.cloud.channel.v1.PurchasableSku.sku:type_name -> google.cloud.channel.v1.Sku
	49, // 31: google.cloud.channel.v1.ListPurchasableOffersRequest.create_entitlement_purchase:type_name -> google.cloud.channel.v1.ListPurchasableOffersRequest.CreateEntitlementPurchase
	50, // 32: google.cloud.channel.v1.ListPurchasableOffersRequest.change_offer_purchase:type_name -> google.cloud.channel.v1.ListPurchasableOffersRequest.ChangeOfferPurchase
	46, // 33: google.cloud.channel.v1.ListPurchasableOffersResponse.purchasable_offers:type_name -> google.cloud.channel.v1.PurchasableOffer
	57, // 34: google.cloud.channel.v1.PurchasableOffer.offer:type_name -> google.cloud.channel.v1.Offer
	0,  // 35: google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.change_type:type_name -> google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
	4,  // 36: google.cloud.channel.v1.CloudChannelService.ListCustomers:input_type -> google.cloud.channel.v1.ListCustomersRequest
	6,  // 37: google.cloud.channel.v1.CloudChannelService.GetCustomer:input_type -> google.cloud.channel.v1.GetCustomerRequest
	1,  // 38: google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist:input_type -> google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest
	7,  // 39: google.cloud.channel.v1.CloudChannelService.CreateCustomer:input_type -> google.cloud.channel.v1.CreateCustomerRequest
	8,  // 40: google.cloud.channel.v1.CloudChannelService.UpdateCustomer:input_type -> google.cloud.channel.v1.UpdateCustomerRequest
	9,  // 41: google.cloud.channel.v1.CloudChannelService.DeleteCustomer:input_type -> google.cloud.channel.v1.DeleteCustomerRequest
	10, // 42: google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity:input_type -> google.cloud.channel.v1.ProvisionCloudIdentityRequest
	11, // 43: google.cloud.channel.v1.CloudChannelService.ListEntitlements:input_type -> google.cloud.channel.v1.ListEntitlementsRequest
	13, // 44: google.cloud.channel.v1.CloudChannelService.ListTransferableSkus:input_type -> google.cloud.channel.v1.ListTransferableSkusRequest
	15, // 45: google.cloud.channel.v1.CloudChannelService.ListTransferableOffers:input_type -> google.cloud.channel.v1.ListTransferableOffersRequest
	18, // 46: google.cloud.channel.v1.CloudChannelService.GetEntitlement:input_type -> google.cloud.channel.v1.GetEntitlementRequest
	24, // 47: google.cloud.channel.v1.CloudChannelService.CreateEntitlement:input_type -> google.cloud.channel.v1.CreateEntitlementRequest
	28, // 48: google.cloud.channel.v1.CloudChannelService.ChangeParameters:input_type -> google.cloud.channel.v1.ChangeParametersRequest
	29, // 49: google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings:input_type -> google.cloud.channel.v1.ChangeRenewalSettingsRequest
	30, // 50: google.cloud.channel.v1.CloudChannelService.ChangeOffer:input_type -> google.cloud.channel.v1.ChangeOfferRequest
	31, // 51: google.cloud.channel.v1.CloudChannelService.StartPaidService:input_type -> google.cloud.channel.v1.StartPaidServiceRequest
	33, // 52: google.cloud.channel.v1.CloudChannelService.SuspendEntitlement:input_type -> google.cloud.channel.v1.SuspendEntitlementRequest
	32, // 53: google.cloud.channel.v1.CloudChannelService.CancelEntitlement:input_type -> google.cloud.channel.v1.CancelEntitlementRequest
	34, // 54: google.cloud.channel.v1.CloudChannelService.ActivateEntitlement:input_type -> google.cloud.channel.v1.ActivateEntitlementRequest
	25, // 55: google.cloud.channel.v1.CloudChannelService.TransferEntitlements:input_type -> google.cloud.channel.v1.TransferEntitlementsRequest
	27, // 56: google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle:input_type -> google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
	19, // 57: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks:input_type -> google.cloud.channel.v1.ListChannelPartnerLinksRequest
	21, // 58: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink:input_type -> google.cloud.channel.v1.GetChannelPartnerLinkRequest
	22, // 59: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink:input_type -> google.cloud.channel.v1.CreateChannelPartnerLinkRequest
	23, // 60: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink:input_type -> google.cloud.channel.v1.UpdateChannelPartnerLinkRequest
	35, // 61: google.cloud.channel.v1.CloudChannelService.ListProducts:input_type -> google.cloud.channel.v1.ListProductsRequest
	37, // 62: google.cloud.channel.v1.CloudChannelService.ListSkus:input_type -> google.cloud.channel.v1.ListSkusRequest
	39, // 63: google.cloud.channel.v1.CloudChannelService.ListOffers:input_type -> google.cloud.channel.v1.ListOffersRequest
	41, // 64: google.cloud.channel.v1.CloudChannelService.ListPurchasableSkus:input_type -> google.cloud.channel.v1.ListPurchasableSkusRequest
	44, // 65: google.cloud.channel.v1.CloudChannelService.ListPurchasableOffers:input_type -> google.cloud.channel.v1.ListPurchasableOffersRequest
	5,  // 66: google.cloud.channel.v1.CloudChannelService.ListCustomers:output_type -> google.cloud.channel.v1.ListCustomersResponse
	51, // 67: google.cloud.channel.v1.CloudChannelService.GetCustomer:output_type -> google.cloud.channel.v1.Customer
	3,  // 68: google.cloud.channel.v1.CloudChannelService.CheckCloudIdentityAccountsExist:output_type -> google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse
	51, // 69: google.cloud.channel.v1.CloudChannelService.CreateCustomer:output_type -> google.cloud.channel.v1.Customer
	51, // 70: google.cloud.channel.v1.CloudChannelService.UpdateCustomer:output_type -> google.cloud.channel.v1.Customer
	64, // 71: google.cloud.channel.v1.CloudChannelService.DeleteCustomer:output_type -> google.protobuf.Empty
	65, // 72: google.cloud.channel.v1.CloudChannelService.ProvisionCloudIdentity:output_type -> google.longrunning.Operation
	12, // 73: google.cloud.channel.v1.CloudChannelService.ListEntitlements:output_type -> google.cloud.channel.v1.ListEntitlementsResponse
	14, // 74: google.cloud.channel.v1.CloudChannelService.ListTransferableSkus:output_type -> google.cloud.channel.v1.ListTransferableSkusResponse
	16, // 75: google.cloud.channel.v1.CloudChannelService.ListTransferableOffers:output_type -> google.cloud.channel.v1.ListTransferableOffersResponse
	55, // 76: google.cloud.channel.v1.CloudChannelService.GetEntitlement:output_type -> google.cloud.channel.v1.Entitlement
	65, // 77: google.cloud.channel.v1.CloudChannelService.CreateEntitlement:output_type -> google.longrunning.Operation
	65, // 78: google.cloud.channel.v1.CloudChannelService.ChangeParameters:output_type -> google.longrunning.Operation
	65, // 79: google.cloud.channel.v1.CloudChannelService.ChangeRenewalSettings:output_type -> google.longrunning.Operation
	65, // 80: google.cloud.channel.v1.CloudChannelService.ChangeOffer:output_type -> google.longrunning.Operation
	65, // 81: google.cloud.channel.v1.CloudChannelService.StartPaidService:output_type -> google.longrunning.Operation
	65, // 82: google.cloud.channel.v1.CloudChannelService.SuspendEntitlement:output_type -> google.longrunning.Operation
	65, // 83: google.cloud.channel.v1.CloudChannelService.CancelEntitlement:output_type -> google.longrunning.Operation
	65, // 84: google.cloud.channel.v1.CloudChannelService.ActivateEntitlement:output_type -> google.longrunning.Operation
	65, // 85: google.cloud.channel.v1.CloudChannelService.TransferEntitlements:output_type -> google.longrunning.Operation
	65, // 86: google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle:output_type -> google.longrunning.Operation
	20, // 87: google.cloud.channel.v1.CloudChannelService.ListChannelPartnerLinks:output_type -> google.cloud.channel.v1.ListChannelPartnerLinksResponse
	59, // 88: google.cloud.channel.v1.CloudChannelService.GetChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	59, // 89: google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	59, // 90: google.cloud.channel.v1.CloudChannelService.UpdateChannelPartnerLink:output_type -> google.cloud.channel.v1.ChannelPartnerLink
	36, // 91: google.cloud.channel.v1.CloudChannelService.ListProducts:output_type -> google.cloud.channel.v1.ListProductsResponse
	38, // 92: google.cloud.channel.v1.CloudChannelService.ListSkus:output_type -> google.cloud.channel.v1.ListSkusResponse
	40, // 93: google.cloud.channel.v1.CloudChannelService.ListOffers:output_type -> google.cloud.channel.v1.ListOffersResponse
	42, // 94: google.cloud.channel.v1.CloudChannelService.ListPurchasableSkus:output_type -> google.cloud.channel.v1.ListPurchasableSkusResponse
	45, // 95: google.cloud.channel.v1.CloudChannelService.ListPurchasableOffers:output_type -> google.cloud.channel.v1.ListPurchasableOffersResponse
	66, // [66:96] is the sub-list for method output_type
	36, // [36:66] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_service_proto_init() }
func file_google_cloud_channel_v1_service_proto_init() {
	if File_google_cloud_channel_v1_service_proto != nil {
		return
	}
	file_google_cloud_channel_v1_channel_partner_links_proto_init()
	file_google_cloud_channel_v1_common_proto_init()
	file_google_cloud_channel_v1_customers_proto_init()
	file_google_cloud_channel_v1_entitlements_proto_init()
	file_google_cloud_channel_v1_offers_proto_init()
	file_google_cloud_channel_v1_products_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckCloudIdentityAccountsExistRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudIdentityCustomerAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckCloudIdentityAccountsExistResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCustomerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionCloudIdentityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntitlementsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferableOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferableOffer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelPartnerLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateChannelPartnerLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEntitlementsToGoogleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeParametersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeRenewalSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeOfferRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartPaidServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuspendEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateEntitlementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurchasableSku); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurchasableOffer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest_CreateEntitlementPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableSkusRequest_ChangeOfferPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest_CreateEntitlementPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPurchasableOffersRequest_ChangeOfferPurchase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ListTransferableSkusRequest_CloudIdentityId)(nil),
		(*ListTransferableSkusRequest_CustomerName)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*ListTransferableOffersRequest_CloudIdentityId)(nil),
		(*ListTransferableOffersRequest_CustomerName)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*ListPurchasableSkusRequest_CreateEntitlementPurchase_)(nil),
		(*ListPurchasableSkusRequest_ChangeOfferPurchase_)(nil),
	}
	file_google_cloud_channel_v1_service_proto_msgTypes[43].OneofWrappers = []interface{}{
		(*ListPurchasableOffersRequest_CreateEntitlementPurchase_)(nil),
		(*ListPurchasableOffersRequest_ChangeOfferPurchase_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_channel_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_service_proto = out.File
	file_google_cloud_channel_v1_service_proto_rawDesc = nil
	file_google_cloud_channel_v1_service_proto_goTypes = nil
	file_google_cloud_channel_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudChannelServiceClient is the client API for CloudChannelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudChannelServiceClient interface {
	// List downstream [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// <br/> List of [Customer][google.cloud.channel.v1.Customer]s pertaining to the reseller or empty list if
	// there are none.
	ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error)
	// Returns a requested [Customer][google.cloud.channel.v1.Customer] resource.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: If the customer resource doesn't exist. Usually
	// the result of an invalid name parameter.
	//
	// Return Value:
	// <br/> [Customer][google.cloud.channel.v1.Customer] resource if found, error otherwise.
	GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts, based on the domain and
	// whether the Cloud Identity accounts are owned by the reseller.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * INVALID_VALUE: Invalid domain value in the request.
	// * NOT_FOUND: If there is no [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount] customer
	// for the domain specified in the request.
	//
	// Return Value:
	// <br/> List of [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount] resources if any exist for
	// the domain, otherwise an error is returned.
	CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under the reseller or distributor
	// account.
	//
	// Possible Error Codes:
	// <ul>
	// <li>PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.</li>
	// <li> INVALID_ARGUMENT:
	// <ul>
	//  <li> Missing or invalid required parameters in the request. </li>
	//  <li> Domain field value doesn't match the domain specified in primary
	//  email.</li>
	// </ul>
	// </li>
	// </ul>
	//
	// Return Value:
	// <br/> If successful, the newly created [Customer][google.cloud.channel.v1.Customer] resource, otherwise
	// returns an error.
	CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource belonging to the reseller or
	// distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found for the name
	// specified in the request.
	//
	// Return Value:
	// <br/> If successful, the updated [Customer][google.cloud.channel.v1.Customer] resource, otherwise returns
	// an error.
	UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently and irreversibly.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * FAILED_PRECONDITION: If the customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found for the name
	// specified in the request.
	DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information or the information provided here, if present.
	//
	// Possible Error Codes:
	//
	// *  PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// *  INVALID_ARGUMENT: Missing or invalid required parameters in the request.
	// *  NOT_FOUND: If the customer is not found for the reseller.
	// *  ALREADY_EXISTS: If the customer's primary email already exists. In this
	//    case, retry after changing the customer's primary contact email.
	// *  INTERNAL: Any non-user error related to a technical issue in the
	//    backend. Contact Cloud Channel support in this case.
	// *  UNKNOWN: Any non-user error related to a technical issue in the backend.
	//    Contact Cloud Channel support in this case.
	//
	// Return Value:
	// <br/>  Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// List [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the request.
	//
	// Return Value:
	// <br/> List of [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to the customer, or empty list if
	// there are none.
	ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a customer based on Cloud Identity ID or
	// Customer Name in the request.
	//
	// This method is used when a reseller lists the entitlements
	// information of a customer that is not owned. The reseller should provide
	// the customer's Cloud Identity ID or Customer Name.
	//
	// Possible Error Codes:
	// <ul>
	// <li>PERMISSION_DENIED, due to one of the following reasons:
	// <ul>
	//    <li> If the customer doesn't belong to the reseller and no auth token,
	//    or an invalid auth token is supplied. </li> <li> If the reseller account
	//    making the request and the reseller account being queried for are
	//    different. </li>
	// </ul>
	// </li>
	// <li> INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.</li>
	// </ul>
	//
	// Return Value:
	// <br/> List of [TransferableSku][google.cloud.channel.v1.TransferableSku] for the given customer.
	ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a customer based on Cloud Identity ID or
	// Customer Name in the request.
	//
	// This method is used when a reseller gets the entitlement
	// information of a customer that is not owned. The reseller should provide
	// the customer's Cloud Identity ID or Customer Name.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED, due to one of the following reasons: (a) If the
	// customer doesn't belong to the reseller and no auth token or invalid auth
	// token is supplied. (b) If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for the given customer and SKU.
	ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error)
	// Returns a requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: If the entitlement is not found for the customer.
	//
	// Return Value:
	// <br/> If found, the requested [Entitlement][google.cloud.channel.v1.Entitlement] resource, otherwise returns
	// an error.
	GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// </li> <li> INVALID_ARGUMENT: <ul>
	//   <li> Missing or invalid required parameters in the request. </li>
	//   <li> Cannot purchase an entitlement if there is already an
	//    entitlement for customer, for a SKU from the same product family. </li>
	//   <li> INVALID_VALUE: Offer passed in isn't valid. Make sure OfferId is
	// valid. If it is valid, then contact Google Channel support for further
	// troubleshooting. </li>
	// </ul>
	// </li>
	// <li> NOT_FOUND: If the customer or offer resource is not found for the
	// reseller. </li>
	// <li> ALREADY_EXISTS: This failure can happen in the following cases:
	//   <ul>
	//     <li>If the SKU has been already purchased for the customer.</li>
	//     <li>If the customer's primary email already exists. In this case retry
	//         after changing the customer's primary contact email.
	//     </li>
	//   </ul>
	// </li>
	// <li> CONDITION_NOT_MET or FAILED_PRECONDITION: This
	// failure can happen in the following cases:
	// <ul>
	//    <li> Purchasing a SKU that requires domain verification and the
	//    domain has not been verified. </li>
	//    <li> Purchasing an Add-On SKU like Vault or Drive without purchasing
	//    the pre-requisite SKU, such as Google Workspace Business Starter. </li>
	//    <li> Applicable only for developer accounts: reseller and resold
	//    domain. Must meet the following domain naming requirements:
	//     <ul>
	//       <li> Domain names must start with goog-test. </li>
	//       <li> Resold domain names must include the reseller domain. </li>
	//     </ul>
	//    </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel Support in this case. </li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Change parameters of the entitlement
	//
	// An entitlement parameters update is a long-running operation and results in
	// updates to the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. For example, if the number of seats being changed to is greater
	// than the allowed number of max seats for the resource. Or decreasing seats
	// for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and results in updates to
	// the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewal for non-commitment plans.
	// * INTERNAL: Any non user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and results in updates to
	// the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan has already been set up for a trial entitlement
	// but has some trial days remaining.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Suspends a previously fulfilled entitlement.
	// An entitlement suspension is a long-running operation.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Cancels a previously fulfilled entitlement.
	// An entitlement cancellation is a long-running operation.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller or
	// if the reseller account making the request and reseller account being
	// queried for are different.
	// * FAILED_PRECONDITION: If there are any Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Activates a previously suspended entitlement. The entitlement must be in a
	// suspended state for it to be activated. Entitlements suspended for pending
	// ToS acceptance can't be activated using this method. An entitlement
	// activation is a long-running operation and can result in updates to
	// the state of the customer entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller or
	// if the reseller account making the request and reseller account being
	// queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can't activate an
	// entitlement that is pending TOS acceptance. Only reseller initiated
	// suspensions can be activated.
	// * NOT_SUSPENDED: Can't activate entitlements that are already in ACTIVE
	// state. Can only activate suspended entitlements.
	// * INTERNAL: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the
	// reseller.</li> <li> INVALID_ARGUMENT: Missing or invalid required
	// parameters in the request. </li> <li> NOT_FOUND: If the customer or offer
	// resource is not found for the reseller. </li> <li> ALREADY_EXISTS: If the
	// SKU has been already transferred for the customer. </li> <li>
	// CONDITION_NOT_MET or FAILED_PRECONDITION: This failure can happen in the
	// following cases: <ul>
	//    <li> Transferring a SKU that requires domain verification and the
	// domain has not been verified. </li>
	//    <li> Transferring an Add-On SKU like Vault or Drive without transferring
	// the pre-requisite SKU, such as G Suite Basic </li> <li> Applicable only for
	// developer accounts: reseller and resold domain must follow the domain
	// naming convention as follows:
	//      <ul>
	//         <li> Domain names must start with goog-test. </li>
	//         <li> Resold domain names must include the reseller domain. </li>
	//      </ul>
	//   </li>
	//   <li> All transferring entitlements must be specified. </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Transfers customer entitlements from current reseller to Google.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// </li> <li> INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. </li>
	// <li> NOT_FOUND: If the customer or offer resource is not found
	// for the reseller. </li>
	// <li> ALREADY_EXISTS: If the SKU has been already
	// transferred for the customer. </li>
	// <li> CONDITION_NOT_MET or FAILED_PRECONDITION: This failure can happen in
	// the following cases:
	// <ul>
	//    <li> Transferring a SKU that requires domain verification and the
	// domain has not been verified. </li>
	//    <li> Transferring an Add-On SKU like Vault or Drive without purchasing
	// the pre-requisite SKU, such as G Suite Basic </li> <li> Applicable only for
	// developer accounts: reseller and resold domain must follow the domain
	// naming convention as follows:
	//      <ul>
	//         <li> Domain names must start with goog-test. </li>
	//         <li> Resold domain names must include the reseller domain. </li>
	//      </ul>
	//    </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case.</li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s belonging to a distributor.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// <br/> If successful, returns the list of [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources
	// for the distributor account, otherwise returns an error.
	ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error)
	// Returns a requested [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: ChannelPartnerLink resource not found. Results
	// due invalid channel partner link name.
	//
	// Return Value:
	// <br/> [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource if found, otherwise returns an error.
	GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller or
	// between resellers in an n-tier reseller channel.
	// To accept the invite, the invited partner should follow the invite_link_uri
	// provided in the response. If the link creation is accepted, a valid link is
	// set up between the two involved parties.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * ALREADY_EXISTS: If the ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: If no Cloud Identity customer exists for domain provided.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in
	// the backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Newly created [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource if successful,
	// otherwise error is returned.
	CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Updates a channel partner link. A distributor calls this method to change a
	// link's status. For example, suspend a partner link.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different. </li>
	// <li> INVALID_ARGUMENT:
	// <ul>
	//   <li> Missing or invalid required parameters in the request. </li>
	//   <li> Updating link state from invited to active or suspended. </li>
	//   <li> Sending reseller_cloud_identity_id, invite_url or name in update
	//   mask. </li>
	// </ul>
	// </li>
	// <li> NOT_FOUND: ChannelPartnerLink resource not found.</li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.</li>
	// </ul>
	//
	// Return Value:
	// <br/> If successful, the updated [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource, otherwise
	// returns an error.
	UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error)
	// Lists the Purchasable SKUs for following cases:
	//
	// * SKUs that can be newly purchased for a customer
	// * SKUs that can be upgraded/downgraded to, for an entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error)
	// Lists the Purchasable Offers for the following cases:
	//
	// * Offers that can be newly purchased for a customer
	// * Offers that can be changed to, for an entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error)
}

type cloudChannelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudChannelServiceClient(cc grpc.ClientConnInterface) CloudChannelServiceClient {
	return &cloudChannelServiceClient{cc}
}

func (c *cloudChannelServiceClient) ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error) {
	out := new(ListCustomersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListCustomers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error) {
	out := new(CheckCloudIdentityAccountsExistResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CheckCloudIdentityAccountsExist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/DeleteCustomer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ProvisionCloudIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error) {
	out := new(ListEntitlementsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error) {
	out := new(ListTransferableSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListTransferableSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error) {
	out := new(ListTransferableOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListTransferableOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error) {
	out := new(Entitlement)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeRenewalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ChangeOffer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/StartPaidService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/SuspendEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CancelEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ActivateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/TransferEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/TransferEntitlementsToGoogle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error) {
	out := new(ListChannelPartnerLinksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error) {
	out := new(ListSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error) {
	out := new(ListOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error) {
	out := new(ListPurchasableSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListPurchasableSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error) {
	out := new(ListPurchasableOffersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelService/ListPurchasableOffers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudChannelServiceServer is the server API for CloudChannelService service.
type CloudChannelServiceServer interface {
	// List downstream [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// <br/> List of [Customer][google.cloud.channel.v1.Customer]s pertaining to the reseller or empty list if
	// there are none.
	ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error)
	// Returns a requested [Customer][google.cloud.channel.v1.Customer] resource.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: If the customer resource doesn't exist. Usually
	// the result of an invalid name parameter.
	//
	// Return Value:
	// <br/> [Customer][google.cloud.channel.v1.Customer] resource if found, error otherwise.
	GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts, based on the domain and
	// whether the Cloud Identity accounts are owned by the reseller.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * INVALID_VALUE: Invalid domain value in the request.
	// * NOT_FOUND: If there is no [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount] customer
	// for the domain specified in the request.
	//
	// Return Value:
	// <br/> List of [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount] resources if any exist for
	// the domain, otherwise an error is returned.
	CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under the reseller or distributor
	// account.
	//
	// Possible Error Codes:
	// <ul>
	// <li>PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.</li>
	// <li> INVALID_ARGUMENT:
	// <ul>
	//  <li> Missing or invalid required parameters in the request. </li>
	//  <li> Domain field value doesn't match the domain specified in primary
	//  email.</li>
	// </ul>
	// </li>
	// </ul>
	//
	// Return Value:
	// <br/> If successful, the newly created [Customer][google.cloud.channel.v1.Customer] resource, otherwise
	// returns an error.
	CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource belonging to the reseller or
	// distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found for the name
	// specified in the request.
	//
	// Return Value:
	// <br/> If successful, the updated [Customer][google.cloud.channel.v1.Customer] resource, otherwise returns
	// an error.
	UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently and irreversibly.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * FAILED_PRECONDITION: If the customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found for the name
	// specified in the request.
	DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information or the information provided here, if present.
	//
	// Possible Error Codes:
	//
	// *  PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// *  INVALID_ARGUMENT: Missing or invalid required parameters in the request.
	// *  NOT_FOUND: If the customer is not found for the reseller.
	// *  ALREADY_EXISTS: If the customer's primary email already exists. In this
	//    case, retry after changing the customer's primary contact email.
	// *  INTERNAL: Any non-user error related to a technical issue in the
	//    backend. Contact Cloud Channel support in this case.
	// *  UNKNOWN: Any non-user error related to a technical issue in the backend.
	//    Contact Cloud Channel support in this case.
	//
	// Return Value:
	// <br/>  Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunning.Operation, error)
	// List [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the request.
	//
	// Return Value:
	// <br/> List of [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to the customer, or empty list if
	// there are none.
	ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a customer based on Cloud Identity ID or
	// Customer Name in the request.
	//
	// This method is used when a reseller lists the entitlements
	// information of a customer that is not owned. The reseller should provide
	// the customer's Cloud Identity ID or Customer Name.
	//
	// Possible Error Codes:
	// <ul>
	// <li>PERMISSION_DENIED, due to one of the following reasons:
	// <ul>
	//    <li> If the customer doesn't belong to the reseller and no auth token,
	//    or an invalid auth token is supplied. </li> <li> If the reseller account
	//    making the request and the reseller account being queried for are
	//    different. </li>
	// </ul>
	// </li>
	// <li> INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.</li>
	// </ul>
	//
	// Return Value:
	// <br/> List of [TransferableSku][google.cloud.channel.v1.TransferableSku] for the given customer.
	ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a customer based on Cloud Identity ID or
	// Customer Name in the request.
	//
	// This method is used when a reseller gets the entitlement
	// information of a customer that is not owned. The reseller should provide
	// the customer's Cloud Identity ID or Customer Name.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED, due to one of the following reasons: (a) If the
	// customer doesn't belong to the reseller and no auth token or invalid auth
	// token is supplied. (b) If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for the given customer and SKU.
	ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error)
	// Returns a requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: If the entitlement is not found for the customer.
	//
	// Return Value:
	// <br/> If found, the requested [Entitlement][google.cloud.channel.v1.Entitlement] resource, otherwise returns
	// an error.
	GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// </li> <li> INVALID_ARGUMENT: <ul>
	//   <li> Missing or invalid required parameters in the request. </li>
	//   <li> Cannot purchase an entitlement if there is already an
	//    entitlement for customer, for a SKU from the same product family. </li>
	//   <li> INVALID_VALUE: Offer passed in isn't valid. Make sure OfferId is
	// valid. If it is valid, then contact Google Channel support for further
	// troubleshooting. </li>
	// </ul>
	// </li>
	// <li> NOT_FOUND: If the customer or offer resource is not found for the
	// reseller. </li>
	// <li> ALREADY_EXISTS: This failure can happen in the following cases:
	//   <ul>
	//     <li>If the SKU has been already purchased for the customer.</li>
	//     <li>If the customer's primary email already exists. In this case retry
	//         after changing the customer's primary contact email.
	//     </li>
	//   </ul>
	// </li>
	// <li> CONDITION_NOT_MET or FAILED_PRECONDITION: This
	// failure can happen in the following cases:
	// <ul>
	//    <li> Purchasing a SKU that requires domain verification and the
	//    domain has not been verified. </li>
	//    <li> Purchasing an Add-On SKU like Vault or Drive without purchasing
	//    the pre-requisite SKU, such as Google Workspace Business Starter. </li>
	//    <li> Applicable only for developer accounts: reseller and resold
	//    domain. Must meet the following domain naming requirements:
	//     <ul>
	//       <li> Domain names must start with goog-test. </li>
	//       <li> Resold domain names must include the reseller domain. </li>
	//     </ul>
	//    </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel Support in this case. </li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunning.Operation, error)
	// Change parameters of the entitlement
	//
	// An entitlement parameters update is a long-running operation and results in
	// updates to the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. For example, if the number of seats being changed to is greater
	// than the allowed number of max seats for the resource. Or decreasing seats
	// for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunning.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and results in updates to
	// the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewal for non-commitment plans.
	// * INTERNAL: Any non user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunning.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and results in updates to
	// the entitlement as a result of fulfillment.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunning.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan has already been set up for a trial entitlement
	// but has some trial days remaining.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunning.Operation, error)
	// Suspends a previously fulfilled entitlement.
	// An entitlement suspension is a long-running operation.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunning.Operation, error)
	// Cancels a previously fulfilled entitlement.
	// An entitlement cancellation is a long-running operation.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller or
	// if the reseller account making the request and reseller account being
	// queried for are different.
	// * FAILED_PRECONDITION: If there are any Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunning.Operation, error)
	// Activates a previously suspended entitlement. The entitlement must be in a
	// suspended state for it to be activated. Entitlements suspended for pending
	// ToS acceptance can't be activated using this method. An entitlement
	// activation is a long-running operation and can result in updates to
	// the state of the customer entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller or
	// if the reseller account making the request and reseller account being
	// queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can't activate an
	// entitlement that is pending TOS acceptance. Only reseller initiated
	// suspensions can be activated.
	// * NOT_SUSPENDED: Can't activate entitlements that are already in ACTIVE
	// state. Can only activate suspended entitlements.
	// * INTERNAL: Any non-user error related to a technical issue
	// in the backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunning.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the
	// reseller.</li> <li> INVALID_ARGUMENT: Missing or invalid required
	// parameters in the request. </li> <li> NOT_FOUND: If the customer or offer
	// resource is not found for the reseller. </li> <li> ALREADY_EXISTS: If the
	// SKU has been already transferred for the customer. </li> <li>
	// CONDITION_NOT_MET or FAILED_PRECONDITION: This failure can happen in the
	// following cases: <ul>
	//    <li> Transferring a SKU that requires domain verification and the
	// domain has not been verified. </li>
	//    <li> Transferring an Add-On SKU like Vault or Drive without transferring
	// the pre-requisite SKU, such as G Suite Basic </li> <li> Applicable only for
	// developer accounts: reseller and resold domain must follow the domain
	// naming convention as follows:
	//      <ul>
	//         <li> Domain names must start with goog-test. </li>
	//         <li> Resold domain names must include the reseller domain. </li>
	//      </ul>
	//   </li>
	//   <li> All transferring entitlements must be specified. </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunning.Operation, error)
	// Transfers customer entitlements from current reseller to Google.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the customer doesn't belong to the reseller.
	// </li> <li> INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. </li>
	// <li> NOT_FOUND: If the customer or offer resource is not found
	// for the reseller. </li>
	// <li> ALREADY_EXISTS: If the SKU has been already
	// transferred for the customer. </li>
	// <li> CONDITION_NOT_MET or FAILED_PRECONDITION: This failure can happen in
	// the following cases:
	// <ul>
	//    <li> Transferring a SKU that requires domain verification and the
	// domain has not been verified. </li>
	//    <li> Transferring an Add-On SKU like Vault or Drive without purchasing
	// the pre-requisite SKU, such as G Suite Basic </li> <li> Applicable only for
	// developer accounts: reseller and resold domain must follow the domain
	// naming convention as follows:
	//      <ul>
	//         <li> Domain names must start with goog-test. </li>
	//         <li> Resold domain names must include the reseller domain. </li>
	//      </ul>
	//    </li>
	// </ul>
	// </li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. Please contact Cloud Channel Support in this case.</li>
	// </ul>
	//
	// Return Value:
	// <br/> Long Running Operation ID.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunning.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s belonging to a distributor.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	//
	// Return Value:
	// <br/> If successful, returns the list of [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources
	// for the distributor account, otherwise returns an error.
	ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error)
	// Returns a requested [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * NOT_FOUND: ChannelPartnerLink resource not found. Results
	// due invalid channel partner link name.
	//
	// Return Value:
	// <br/> [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource if found, otherwise returns an error.
	GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller or
	// between resellers in an n-tier reseller channel.
	// To accept the invite, the invited partner should follow the invite_link_uri
	// provided in the response. If the link creation is accepted, a valid link is
	// set up between the two involved parties.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// * ALREADY_EXISTS: If the ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: If no Cloud Identity customer exists for domain provided.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in
	// the backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// <br/> Newly created [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource if successful,
	// otherwise error is returned.
	CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Updates a channel partner link. A distributor calls this method to change a
	// link's status. For example, suspend a partner link.
	// To call this method, you must be a distributor.
	//
	// Possible Error Codes:
	// <ul>
	// <li> PERMISSION_DENIED: If the reseller account making the request and the
	// reseller account being queried for are different. </li>
	// <li> INVALID_ARGUMENT:
	// <ul>
	//   <li> Missing or invalid required parameters in the request. </li>
	//   <li> Updating link state from invited to active or suspended. </li>
	//   <li> Sending reseller_cloud_identity_id, invite_url or name in update
	//   mask. </li>
	// </ul>
	// </li>
	// <li> NOT_FOUND: ChannelPartnerLink resource not found.</li>
	// <li> INTERNAL: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support. </li>
	// <li> UNKNOWN: Any non-user error related to a technical issue in the
	// backend. In this case, contact Cloud Channel support.</li>
	// </ul>
	//
	// Return Value:
	// <br/> If successful, the updated [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource, otherwise
	// returns an error.
	UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible Error Codes:
	//
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error)
	// Lists the Purchasable SKUs for following cases:
	//
	// * SKUs that can be newly purchased for a customer
	// * SKUs that can be upgraded/downgraded to, for an entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error)
	// Lists the Purchasable Offers for the following cases:
	//
	// * Offers that can be newly purchased for a customer
	// * Offers that can be changed to, for an entitlement.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the customer doesn't belong to the reseller
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error)
}

// UnimplementedCloudChannelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudChannelServiceServer struct {
}

func (*UnimplementedCloudChannelServiceServer) ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckCloudIdentityAccountsExist not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionCloudIdentity not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlements not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableOffers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeParameters not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeRenewalSettings not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeOffer not implemented")
}
func (*UnimplementedCloudChannelServiceServer) StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartPaidService not implemented")
}
func (*UnimplementedCloudChannelServiceServer) SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuspendEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateEntitlement not implemented")
}
func (*UnimplementedCloudChannelServiceServer) TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlements not implemented")
}
func (*UnimplementedCloudChannelServiceServer) TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlementsToGoogle not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelPartnerLinks not implemented")
}
func (*UnimplementedCloudChannelServiceServer) GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPartnerLink not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOffers not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableSkus not implemented")
}
func (*UnimplementedCloudChannelServiceServer) ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableOffers not implemented")
}

func RegisterCloudChannelServiceServer(s *grpc.Server, srv CloudChannelServiceServer) {
	s.RegisterService(&_CloudChannelService_serviceDesc, srv)
}

func _CloudChannelService_ListCustomers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListCustomers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, req.(*ListCustomersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, req.(*GetCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CheckCloudIdentityAccountsExist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckCloudIdentityAccountsExistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CheckCloudIdentityAccountsExist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, req.(*CheckCloudIdentityAccountsExistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, req.(*CreateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, req.(*UpdateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/DeleteCustomer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, req.(*DeleteCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ProvisionCloudIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionCloudIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ProvisionCloudIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, req.(*ProvisionCloudIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, req.(*ListEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListTransferableSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, req.(*ListTransferableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListTransferableOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, req.(*ListTransferableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, req.(*GetEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, req.(*CreateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, req.(*ChangeParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeRenewalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeRenewalSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeRenewalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, req.(*ChangeRenewalSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeOffer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeOfferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ChangeOffer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, req.(*ChangeOfferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_StartPaidService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartPaidServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/StartPaidService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, req.(*StartPaidServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_SuspendEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/SuspendEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, req.(*SuspendEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CancelEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CancelEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, req.(*CancelEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ActivateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ActivateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, req.(*ActivateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/TransferEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, req.(*TransferEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlementsToGoogle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsToGoogleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/TransferEntitlementsToGoogle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, req.(*TransferEntitlementsToGoogleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListChannelPartnerLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelPartnerLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, req.(*ListChannelPartnerLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, req.(*GetChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, req.(*CreateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, req.(*UpdateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, req.(*ListSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, req.(*ListOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListPurchasableSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, req.(*ListPurchasableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelService/ListPurchasableOffers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, req.(*ListPurchasableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudChannelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.channel.v1.CloudChannelService",
	HandlerType: (*CloudChannelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCustomers",
			Handler:    _CloudChannelService_ListCustomers_Handler,
		},
		{
			MethodName: "GetCustomer",
			Handler:    _CloudChannelService_GetCustomer_Handler,
		},
		{
			MethodName: "CheckCloudIdentityAccountsExist",
			Handler:    _CloudChannelService_CheckCloudIdentityAccountsExist_Handler,
		},
		{
			MethodName: "CreateCustomer",
			Handler:    _CloudChannelService_CreateCustomer_Handler,
		},
		{
			MethodName: "UpdateCustomer",
			Handler:    _CloudChannelService_UpdateCustomer_Handler,
		},
		{
			MethodName: "DeleteCustomer",
			Handler:    _CloudChannelService_DeleteCustomer_Handler,
		},
		{
			MethodName: "ProvisionCloudIdentity",
			Handler:    _CloudChannelService_ProvisionCloudIdentity_Handler,
		},
		{
			MethodName: "ListEntitlements",
			Handler:    _CloudChannelService_ListEntitlements_Handler,
		},
		{
			MethodName: "ListTransferableSkus",
			Handler:    _CloudChannelService_ListTransferableSkus_Handler,
		},
		{
			MethodName: "ListTransferableOffers",
			Handler:    _CloudChannelService_ListTransferableOffers_Handler,
		},
		{
			MethodName: "GetEntitlement",
			Handler:    _CloudChannelService_GetEntitlement_Handler,
		},
		{
			MethodName: "CreateEntitlement",
			Handler:    _CloudChannelService_CreateEntitlement_Handler,
		},
		{
			MethodName: "ChangeParameters",
			Handler:    _CloudChannelService_ChangeParameters_Handler,
		},
		{
			MethodName: "ChangeRenewalSettings",
			Handler:    _CloudChannelService_ChangeRenewalSettings_Handler,
		},
		{
			MethodName: "ChangeOffer",
			Handler:    _CloudChannelService_ChangeOffer_Handler,
		},
		{
			MethodName: "StartPaidService",
			Handler:    _CloudChannelService_StartPaidService_Handler,
		},
		{
			MethodName: "SuspendEntitlement",
			Handler:    _CloudChannelService_SuspendEntitlement_Handler,
		},
		{
			MethodName: "CancelEntitlement",
			Handler:    _CloudChannelService_CancelEntitlement_Handler,
		},
		{
			MethodName: "ActivateEntitlement",
			Handler:    _CloudChannelService_ActivateEntitlement_Handler,
		},
		{
			MethodName: "TransferEntitlements",
			Handler:    _CloudChannelService_TransferEntitlements_Handler,
		},
		{
			MethodName: "TransferEntitlementsToGoogle",
			Handler:    _CloudChannelService_TransferEntitlementsToGoogle_Handler,
		},
		{
			MethodName: "ListChannelPartnerLinks",
			Handler:    _CloudChannelService_ListChannelPartnerLinks_Handler,
		},
		{
			MethodName: "GetChannelPartnerLink",
			Handler:    _CloudChannelService_GetChannelPartnerLink_Handler,
		},
		{
			MethodName: "CreateChannelPartnerLink",
			Handler:    _CloudChannelService_CreateChannelPartnerLink_Handler,
		},
		{
			MethodName: "UpdateChannelPartnerLink",
			Handler:    _CloudChannelService_UpdateChannelPartnerLink_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _CloudChannelService_ListProducts_Handler,
		},
		{
			MethodName: "ListSkus",
			Handler:    _CloudChannelService_ListSkus_Handler,
		},
		{
			MethodName: "ListOffers",
			Handler:    _CloudChannelService_ListOffers_Handler,
		},
		{
			MethodName: "ListPurchasableSkus",
			Handler:    _CloudChannelService_ListPurchasableSkus_Handler,
		},
		{
			MethodName: "ListPurchasableOffers",
			Handler:    _CloudChannelService_ListPurchasableOffers_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/channel/v1/service.proto",
}
