// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/schema/io_format.proto

package schema

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Prediction input format for Image Classification.
type ImageClassificationPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image bytes or GCS URI to make the prediction on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the image. Only the images in below listed
	// MIME types are supported.
	// - image/jpeg
	// - image/gif
	// - image/png
	// - image/webp
	// - image/bmp
	// - image/tiff
	// - image/vnd.microsoft.icon
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *ImageClassificationPredictionInstance) Reset() {
	*x = ImageClassificationPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageClassificationPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageClassificationPredictionInstance) ProtoMessage() {}

func (x *ImageClassificationPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageClassificationPredictionInstance.ProtoReflect.Descriptor instead.
func (*ImageClassificationPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{0}
}

func (x *ImageClassificationPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *ImageClassificationPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Prediction input format for Image Object Detection.
type ImageObjectDetectionPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image bytes or GCS URI to make the prediction on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the image. Only the images in below listed
	// MIME types are supported.
	// - image/jpeg
	// - image/gif
	// - image/png
	// - image/webp
	// - image/bmp
	// - image/tiff
	// - image/vnd.microsoft.icon
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *ImageObjectDetectionPredictionInstance) Reset() {
	*x = ImageObjectDetectionPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageObjectDetectionPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageObjectDetectionPredictionInstance) ProtoMessage() {}

func (x *ImageObjectDetectionPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageObjectDetectionPredictionInstance.ProtoReflect.Descriptor instead.
func (*ImageObjectDetectionPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{1}
}

func (x *ImageObjectDetectionPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *ImageObjectDetectionPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Prediction input format for Image Segmentation.
type ImageSegmentationPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image bytes to make the predictions on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the image. Only the images in below listed
	// MIME types are supported.
	// - image/jpeg
	// - image/png
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *ImageSegmentationPredictionInstance) Reset() {
	*x = ImageSegmentationPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationPredictionInstance) ProtoMessage() {}

func (x *ImageSegmentationPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationPredictionInstance.ProtoReflect.Descriptor instead.
func (*ImageSegmentationPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{2}
}

func (x *ImageSegmentationPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *ImageSegmentationPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Prediction input format for Video Classification.
type VideoClassificationPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage location of the video on which to perform the
	// prediction.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the video. Only the following are
	// supported: video/mp4 video/avi video/quicktime
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// The beginning, inclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision.
	TimeSegmentStart string `protobuf:"bytes,3,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, exclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision, and "Infinity" is allowed, which means the
	// end of the video.
	TimeSegmentEnd string `protobuf:"bytes,4,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
}

func (x *VideoClassificationPredictionInstance) Reset() {
	*x = VideoClassificationPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionInstance) ProtoMessage() {}

func (x *VideoClassificationPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionInstance.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{3}
}

func (x *VideoClassificationPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *VideoClassificationPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *VideoClassificationPredictionInstance) GetTimeSegmentStart() string {
	if x != nil {
		return x.TimeSegmentStart
	}
	return ""
}

func (x *VideoClassificationPredictionInstance) GetTimeSegmentEnd() string {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return ""
}

// Prediction input format for Video Classification.
type VideoObjectTrackingPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage location of the video on which to perform the
	// prediction.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the video. Only the following are
	// supported: video/mp4 video/avi video/quicktime
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// The beginning, inclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision.
	TimeSegmentStart string `protobuf:"bytes,3,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, exclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision, and "Infinity" is allowed, which means the
	// end of the video.
	TimeSegmentEnd string `protobuf:"bytes,4,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
}

func (x *VideoObjectTrackingPredictionInstance) Reset() {
	*x = VideoObjectTrackingPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionInstance) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionInstance.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{4}
}

func (x *VideoObjectTrackingPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *VideoObjectTrackingPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *VideoObjectTrackingPredictionInstance) GetTimeSegmentStart() string {
	if x != nil {
		return x.TimeSegmentStart
	}
	return ""
}

func (x *VideoObjectTrackingPredictionInstance) GetTimeSegmentEnd() string {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return ""
}

// Prediction input format for Video Action Recognition.
type VideoActionRecognitionPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage location of the video on which to perform the
	// prediction.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the content of the video. Only the following are
	// supported: video/mp4 video/avi video/quicktime
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// The beginning, inclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision.
	TimeSegmentStart string `protobuf:"bytes,3,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, exclusive, of the video's time segment on which to perform
	// the prediction. Expressed as a number of seconds as measured from the
	// start of the video, with "s" appended at the end. Fractions are allowed,
	// up to a microsecond precision, and "Infinity" is allowed, which means the
	// end of the video.
	TimeSegmentEnd string `protobuf:"bytes,4,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
}

func (x *VideoActionRecognitionPredictionInstance) Reset() {
	*x = VideoActionRecognitionPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoActionRecognitionPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoActionRecognitionPredictionInstance) ProtoMessage() {}

func (x *VideoActionRecognitionPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoActionRecognitionPredictionInstance.ProtoReflect.Descriptor instead.
func (*VideoActionRecognitionPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{5}
}

func (x *VideoActionRecognitionPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *VideoActionRecognitionPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *VideoActionRecognitionPredictionInstance) GetTimeSegmentStart() string {
	if x != nil {
		return x.TimeSegmentStart
	}
	return ""
}

func (x *VideoActionRecognitionPredictionInstance) GetTimeSegmentEnd() string {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return ""
}

// Prediction input format for Text Classification.
type TextClassificationPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text snippet to make the predictions on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the text snippet. The supported MIME types are listed
	// below.
	// - text/plain
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *TextClassificationPredictionInstance) Reset() {
	*x = TextClassificationPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextClassificationPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextClassificationPredictionInstance) ProtoMessage() {}

func (x *TextClassificationPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextClassificationPredictionInstance.ProtoReflect.Descriptor instead.
func (*TextClassificationPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{6}
}

func (x *TextClassificationPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *TextClassificationPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Prediction input format for Text Sentiment.
type TextSentimentPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text snippet to make the predictions on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the text snippet. The supported MIME types are listed
	// below.
	// - text/plain
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *TextSentimentPredictionInstance) Reset() {
	*x = TextSentimentPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSentimentPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSentimentPredictionInstance) ProtoMessage() {}

func (x *TextSentimentPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSentimentPredictionInstance.ProtoReflect.Descriptor instead.
func (*TextSentimentPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{7}
}

func (x *TextSentimentPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *TextSentimentPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Prediction input format for Text Extraction.
type TextExtractionPredictionInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text snippet to make the predictions on.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The MIME type of the text snippet. The supported MIME types are listed
	// below.
	// - text/plain
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// This field is only used for batch prediction. If a key is provided, the
	// batch prediction result will by mapped to this key. If omitted, then the
	// batch prediction result will contain the entire input instance. AI Platform
	// will not check if keys in the request are duplicates, so it is up to the
	// caller to ensure the keys are unique.
	Key string `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *TextExtractionPredictionInstance) Reset() {
	*x = TextExtractionPredictionInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextExtractionPredictionInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextExtractionPredictionInstance) ProtoMessage() {}

func (x *TextExtractionPredictionInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextExtractionPredictionInstance.ProtoReflect.Descriptor instead.
func (*TextExtractionPredictionInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{8}
}

func (x *TextExtractionPredictionInstance) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *TextExtractionPredictionInstance) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *TextExtractionPredictionInstance) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Prediction model parameters for Image Classification.
type ImageClassificationPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model only returns predictions with at least this confidence score.
	// Default value is 0.0
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// The Model only returns up to that many top, by confidence score,
	// predictions per instance. If this number is very high, the Model may return
	// fewer predictions. Default value is 10.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
}

func (x *ImageClassificationPredictionParams) Reset() {
	*x = ImageClassificationPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageClassificationPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageClassificationPredictionParams) ProtoMessage() {}

func (x *ImageClassificationPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageClassificationPredictionParams.ProtoReflect.Descriptor instead.
func (*ImageClassificationPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{9}
}

func (x *ImageClassificationPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *ImageClassificationPredictionParams) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

// Prediction model parameters for Image Object Detection.
type ImageObjectDetectionPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model only returns predictions with at least this confidence score.
	// Default value is 0.0
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// The Model only returns up to that many top, by confidence score,
	// predictions per instance. Note that number of returned predictions is also
	// limited by metadata's predictionsLimit. Default value is 10.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
}

func (x *ImageObjectDetectionPredictionParams) Reset() {
	*x = ImageObjectDetectionPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageObjectDetectionPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageObjectDetectionPredictionParams) ProtoMessage() {}

func (x *ImageObjectDetectionPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageObjectDetectionPredictionParams.ProtoReflect.Descriptor instead.
func (*ImageObjectDetectionPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{10}
}

func (x *ImageObjectDetectionPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *ImageObjectDetectionPredictionParams) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

// Prediction model parameters for Image Segmentation.
type ImageSegmentationPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When the model predicts category of pixels of the image, it will only
	// provide predictions for pixels that it is at least this much confident
	// about. All other pixels will be classified as background. Default value is
	// 0.5.
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
}

func (x *ImageSegmentationPredictionParams) Reset() {
	*x = ImageSegmentationPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageSegmentationPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSegmentationPredictionParams) ProtoMessage() {}

func (x *ImageSegmentationPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSegmentationPredictionParams.ProtoReflect.Descriptor instead.
func (*ImageSegmentationPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{11}
}

func (x *ImageSegmentationPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

// Prediction model parameters for Video Classification.
type VideoClassificationPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model only returns predictions with at least this confidence score.
	// Default value is 0.0
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// The Model only returns up to that many top, by confidence score,
	// predictions per instance. If this number is very high, the Model may return
	// fewer predictions. Default value is 10,000.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
	// Set to true to request segment-level classification. AI Platform returns
	// labels and their confidence scores for the entire time segment of the
	// video that user specified in the input instance.
	// Default value is true
	SegmentClassification bool `protobuf:"varint,3,opt,name=segment_classification,json=segmentClassification,proto3" json:"segment_classification,omitempty"`
	// Set to true to request shot-level classification. AI Platform determines
	// the boundaries for each camera shot in the entire time segment of the
	// video that user specified in the input instance. AI Platform then
	// returns labels and their confidence scores for each detected shot, along
	// with the start and end time of the shot.
	// WARNING: Model evaluation is not done for this classification type,
	// the quality of it depends on the training data, but there are no metrics
	// provided to describe that quality.
	// Default value is false
	ShotClassification bool `protobuf:"varint,4,opt,name=shot_classification,json=shotClassification,proto3" json:"shot_classification,omitempty"`
	// Set to true to request classification for a video at one-second intervals.
	// AI Platform returns labels and their confidence scores for each second of
	// the entire time segment of the video that user specified in the input
	// WARNING: Model evaluation is not done for this classification type, the
	// quality of it depends on the training data, but there are no metrics
	// provided to describe that quality. Default value is false
	OneSecIntervalClassification bool `protobuf:"varint,5,opt,name=one_sec_interval_classification,json=oneSecIntervalClassification,proto3" json:"one_sec_interval_classification,omitempty"`
}

func (x *VideoClassificationPredictionParams) Reset() {
	*x = VideoClassificationPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionParams) ProtoMessage() {}

func (x *VideoClassificationPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionParams.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{12}
}

func (x *VideoClassificationPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *VideoClassificationPredictionParams) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

func (x *VideoClassificationPredictionParams) GetSegmentClassification() bool {
	if x != nil {
		return x.SegmentClassification
	}
	return false
}

func (x *VideoClassificationPredictionParams) GetShotClassification() bool {
	if x != nil {
		return x.ShotClassification
	}
	return false
}

func (x *VideoClassificationPredictionParams) GetOneSecIntervalClassification() bool {
	if x != nil {
		return x.OneSecIntervalClassification
	}
	return false
}

// Prediction model parameters for Video Object Tracking.
type VideoObjectTrackingPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model only returns predictions with at least this confidence score.
	// Default value is 0.0
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// The model only returns up to that many top, by confidence score,
	// predictions per frame of the video. If this number is very high, the
	// Model may return fewer predictions per frame. Default value is 50.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
	// Only bounding boxes with shortest edge at least that long as a relative
	// value of video frame size are returned. Default value is 0.0.
	MinBoundingBoxSize float32 `protobuf:"fixed32,3,opt,name=min_bounding_box_size,json=minBoundingBoxSize,proto3" json:"min_bounding_box_size,omitempty"`
}

func (x *VideoObjectTrackingPredictionParams) Reset() {
	*x = VideoObjectTrackingPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionParams) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionParams.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{13}
}

func (x *VideoObjectTrackingPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *VideoObjectTrackingPredictionParams) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

func (x *VideoObjectTrackingPredictionParams) GetMinBoundingBoxSize() float32 {
	if x != nil {
		return x.MinBoundingBoxSize
	}
	return 0
}

// Prediction model parameters for Video Action Recognition.
type VideoActionRecognitionPredictionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model only returns predictions with at least this confidence score.
	// Default value is 0.0
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// The model only returns up to that many top, by confidence score,
	// predictions per frame of the video. If this number is very high, the
	// Model may return fewer predictions per frame. Default value is 50.
	MaxPredictions int32 `protobuf:"varint,2,opt,name=max_predictions,json=maxPredictions,proto3" json:"max_predictions,omitempty"`
}

func (x *VideoActionRecognitionPredictionParams) Reset() {
	*x = VideoActionRecognitionPredictionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoActionRecognitionPredictionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoActionRecognitionPredictionParams) ProtoMessage() {}

func (x *VideoActionRecognitionPredictionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoActionRecognitionPredictionParams.ProtoReflect.Descriptor instead.
func (*VideoActionRecognitionPredictionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{14}
}

func (x *VideoActionRecognitionPredictionParams) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *VideoActionRecognitionPredictionParams) GetMaxPredictions() int32 {
	if x != nil {
		return x.MaxPredictions
	}
	return 0
}

// Represents a line of JSONL in the batch prediction output file.
type PredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Some identifier from the input so that the prediction can be mapped back to
	// the input instance.
	//
	// Types that are assignable to Input:
	//	*PredictionResult_Instance
	//	*PredictionResult_Key
	Input isPredictionResult_Input `protobuf_oneof:"input"`
	// The prediction result.
	// Value is used here instead of Any so that JsonFormat does not append an
	// extra "@type" field when we convert the proto to JSON and so we can
	// represent array of objects.
	Prediction *structpb.Value `protobuf:"bytes,3,opt,name=prediction,proto3" json:"prediction,omitempty"`
}

func (x *PredictionResult) Reset() {
	*x = PredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictionResult) ProtoMessage() {}

func (x *PredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictionResult.ProtoReflect.Descriptor instead.
func (*PredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{15}
}

func (m *PredictionResult) GetInput() isPredictionResult_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *PredictionResult) GetInstance() *structpb.Struct {
	if x, ok := x.GetInput().(*PredictionResult_Instance); ok {
		return x.Instance
	}
	return nil
}

func (x *PredictionResult) GetKey() string {
	if x, ok := x.GetInput().(*PredictionResult_Key); ok {
		return x.Key
	}
	return ""
}

func (x *PredictionResult) GetPrediction() *structpb.Value {
	if x != nil {
		return x.Prediction
	}
	return nil
}

type isPredictionResult_Input interface {
	isPredictionResult_Input()
}

type PredictionResult_Instance struct {
	// User's input instance.
	// Struct is used here instead of Any so that JsonFormat does not append an
	// extra "@type" field when we convert the proto to JSON.
	Instance *structpb.Struct `protobuf:"bytes,1,opt,name=instance,proto3,oneof"`
}

type PredictionResult_Key struct {
	// Optional user-provided key from the input instance.
	Key string `protobuf:"bytes,2,opt,name=key,proto3,oneof"`
}

func (*PredictionResult_Instance) isPredictionResult_Input() {}

func (*PredictionResult_Key) isPredictionResult_Input() {}

// Represents a line of JSONL in the text sentiment batch prediction output
// file. This is a hack to allow printing of integer values.
type TextSentimentPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User's input instance.
	Instance *TextSentimentPredictionInstance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The prediction result.
	Prediction *TextSentimentPredictionResult_Prediction `protobuf:"bytes,2,opt,name=prediction,proto3" json:"prediction,omitempty"`
}

func (x *TextSentimentPredictionResult) Reset() {
	*x = TextSentimentPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSentimentPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSentimentPredictionResult) ProtoMessage() {}

func (x *TextSentimentPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSentimentPredictionResult.ProtoReflect.Descriptor instead.
func (*TextSentimentPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{16}
}

func (x *TextSentimentPredictionResult) GetInstance() *TextSentimentPredictionInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *TextSentimentPredictionResult) GetPrediction() *TextSentimentPredictionResult_Prediction {
	if x != nil {
		return x.Prediction
	}
	return nil
}

// Prediction output format for Image Classification.
type ClassificationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource IDs of the AnnotationSpecs that had been identified, ordered
	// by the confidence score descendingly.
	Ids []int64 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// The display names of the AnnotationSpecs that had been identified, order
	// matches the IDs.
	DisplayNames []string `protobuf:"bytes,2,rep,name=display_names,json=displayNames,proto3" json:"display_names,omitempty"`
	// The Model's confidences in correctness of the predicted IDs, higher value
	// means higher confidence. Order matches the Ids.
	Confidences []float32 `protobuf:"fixed32,3,rep,packed,name=confidences,proto3" json:"confidences,omitempty"`
}

func (x *ClassificationPredictionResult) Reset() {
	*x = ClassificationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationPredictionResult) ProtoMessage() {}

func (x *ClassificationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationPredictionResult.ProtoReflect.Descriptor instead.
func (*ClassificationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{17}
}

func (x *ClassificationPredictionResult) GetIds() []int64 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ClassificationPredictionResult) GetDisplayNames() []string {
	if x != nil {
		return x.DisplayNames
	}
	return nil
}

func (x *ClassificationPredictionResult) GetConfidences() []float32 {
	if x != nil {
		return x.Confidences
	}
	return nil
}

// Prediction output format for Image Object Detection.
type ImageObjectDetectionPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource IDs of the AnnotationSpecs that had been identified, ordered
	// by the confidence score descendingly.
	Ids []int64 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// The display names of the AnnotationSpecs that had been identified, order
	// matches the IDs.
	DisplayNames []string `protobuf:"bytes,2,rep,name=display_names,json=displayNames,proto3" json:"display_names,omitempty"`
	// The Model's confidences in correctness of the predicted IDs, higher value
	// means higher confidence. Order matches the Ids.
	Confidences []float32 `protobuf:"fixed32,3,rep,packed,name=confidences,proto3" json:"confidences,omitempty"`
	// Bounding boxes, i.e. the rectangles over the image, that pinpoint
	// the found AnnotationSpecs. Given in order that matches the IDs. Each
	// bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
	// `yMax`, which represent the extremal coordinates of the box. They are
	// relative to the image size, and the point 0,0 is in the top left
	// of the image.
	Bboxes []*structpb.ListValue `protobuf:"bytes,4,rep,name=bboxes,proto3" json:"bboxes,omitempty"`
}

func (x *ImageObjectDetectionPredictionResult) Reset() {
	*x = ImageObjectDetectionPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageObjectDetectionPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageObjectDetectionPredictionResult) ProtoMessage() {}

func (x *ImageObjectDetectionPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageObjectDetectionPredictionResult.ProtoReflect.Descriptor instead.
func (*ImageObjectDetectionPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{18}
}

func (x *ImageObjectDetectionPredictionResult) GetIds() []int64 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetDisplayNames() []string {
	if x != nil {
		return x.DisplayNames
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetConfidences() []float32 {
	if x != nil {
		return x.Confidences
	}
	return nil
}

func (x *ImageObjectDetectionPredictionResult) GetBboxes() []*structpb.ListValue {
	if x != nil {
		return x.Bboxes
	}
	return nil
}

// Prediction output format for Video Classification.
type VideoClassificationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of the prediction. The requested types can be configured
	// via parameters. This will be one of
	// - segment-classification
	// - shot-classification
	// - one-sec-interval-classification
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// The beginning, inclusive, of the video's time segment in which the
	// AnnotationSpec has been identified. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end. Note that for
	// 'segment-classification' prediction type, this equals the original
	// 'timeSegmentStart' from the input instance, for other types it is the
	// start of a shot or a 1 second interval respectively.
	TimeSegmentStart *durationpb.Duration `protobuf:"bytes,4,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, exclusive, of the video's time segment in which the
	// AnnotationSpec has been identified. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end. Note that for
	// 'segment-classification' prediction type, this equals the original
	// 'timeSegmentEnd' from the input instance, for other types it is the end
	// of a shot or a 1 second interval respectively.
	TimeSegmentEnd *durationpb.Duration `protobuf:"bytes,5,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
	// The Model's confidence in correction of this prediction, higher
	// value means higher confidence.
	Confidence *wrapperspb.FloatValue `protobuf:"bytes,6,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *VideoClassificationPredictionResult) Reset() {
	*x = VideoClassificationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionResult) ProtoMessage() {}

func (x *VideoClassificationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{19}
}

func (x *VideoClassificationPredictionResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetTimeSegmentStart() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentStart
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetTimeSegmentEnd() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetConfidence() *wrapperspb.FloatValue {
	if x != nil {
		return x.Confidence
	}
	return nil
}

// Prediction output format for Video Object Tracking.
type VideoObjectTrackingPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The beginning, inclusive, of the video's time segment in which the
	// object instance has been detected. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end.
	TimeSegmentStart *durationpb.Duration `protobuf:"bytes,3,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, inclusive, of the video's time segment in which the
	// object instance has been detected. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end.
	TimeSegmentEnd *durationpb.Duration `protobuf:"bytes,4,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
	// The Model's confidence in correction of this prediction, higher
	// value means higher confidence.
	Confidence *wrapperspb.FloatValue `protobuf:"bytes,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// All of the frames of the video in which a single object instance has been
	// detected. The bounding boxes in the frames identify the same object.
	Frames []*VideoObjectTrackingPredictionResult_Frame `protobuf:"bytes,6,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *VideoObjectTrackingPredictionResult) Reset() {
	*x = VideoObjectTrackingPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionResult) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{20}
}

func (x *VideoObjectTrackingPredictionResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoObjectTrackingPredictionResult) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoObjectTrackingPredictionResult) GetTimeSegmentStart() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentStart
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult) GetTimeSegmentEnd() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult) GetConfidence() *wrapperspb.FloatValue {
	if x != nil {
		return x.Confidence
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult) GetFrames() []*VideoObjectTrackingPredictionResult_Frame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Prediction output format for Text Extraction.
type TextExtractionPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource IDs of the AnnotationSpecs that had been identified,
	// ordered by the confidence score descendingly.
	Ids []int64 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// The display names of the AnnotationSpecs that had been identified,
	// order matches the IDs.
	DisplayNames []string `protobuf:"bytes,2,rep,name=display_names,json=displayNames,proto3" json:"display_names,omitempty"`
	// The start offsets, inclusive, of the text segment in which the
	// AnnotationSpec has been identified. Expressed as a zero-based number
	// of characters as measured from the start of the text snippet.
	TextSegmentStartOffsets []int64 `protobuf:"varint,3,rep,packed,name=text_segment_start_offsets,json=textSegmentStartOffsets,proto3" json:"text_segment_start_offsets,omitempty"`
	// The end offsets, inclusive, of the text segment in which the
	// AnnotationSpec has been identified. Expressed as a zero-based number
	// of characters as measured from the start of the text snippet.
	TextSegmentEndOffsets []int64 `protobuf:"varint,4,rep,packed,name=text_segment_end_offsets,json=textSegmentEndOffsets,proto3" json:"text_segment_end_offsets,omitempty"`
	// The Model's confidences in correctness of the predicted IDs, higher
	// value means higher confidence. Order matches the Ids.
	Confidences []float32 `protobuf:"fixed32,5,rep,packed,name=confidences,proto3" json:"confidences,omitempty"`
}

func (x *TextExtractionPredictionResult) Reset() {
	*x = TextExtractionPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextExtractionPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextExtractionPredictionResult) ProtoMessage() {}

func (x *TextExtractionPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextExtractionPredictionResult.ProtoReflect.Descriptor instead.
func (*TextExtractionPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{21}
}

func (x *TextExtractionPredictionResult) GetIds() []int64 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *TextExtractionPredictionResult) GetDisplayNames() []string {
	if x != nil {
		return x.DisplayNames
	}
	return nil
}

func (x *TextExtractionPredictionResult) GetTextSegmentStartOffsets() []int64 {
	if x != nil {
		return x.TextSegmentStartOffsets
	}
	return nil
}

func (x *TextExtractionPredictionResult) GetTextSegmentEndOffsets() []int64 {
	if x != nil {
		return x.TextSegmentEndOffsets
	}
	return nil
}

func (x *TextExtractionPredictionResult) GetConfidences() []float32 {
	if x != nil {
		return x.Confidences
	}
	return nil
}

// Prediction output format for Text Sentiment.
type TextSentimentPredictionResult_Prediction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The integer sentiment labels between 0 (inclusive) and sentimentMax label
	// (inclusive), while 0 maps to the least positive sentiment and
	// sentimentMax maps to the most positive one. The higher the score is, the
	// more positive the sentiment in the text snippet is. Note: sentimentMax is
	// an integer value between 1 (inclusive) and 10 (inclusive).
	Sentiment int32 `protobuf:"varint,1,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *TextSentimentPredictionResult_Prediction) Reset() {
	*x = TextSentimentPredictionResult_Prediction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSentimentPredictionResult_Prediction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSentimentPredictionResult_Prediction) ProtoMessage() {}

func (x *TextSentimentPredictionResult_Prediction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSentimentPredictionResult_Prediction.ProtoReflect.Descriptor instead.
func (*TextSentimentPredictionResult_Prediction) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{16, 0}
}

func (x *TextSentimentPredictionResult_Prediction) GetSentiment() int32 {
	if x != nil {
		return x.Sentiment
	}
	return 0
}

// The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
// i.e. the rectangle over the video frame pinpointing the found
// AnnotationSpec. The coordinates are relative to the frame size, and the
// point 0,0 is in the top left of the frame.
type VideoObjectTrackingPredictionResult_Frame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A time (frame) of a video in which the object has been detected.
	// Expressed as a number of seconds as measured from the
	// start of the video, with fractions up to a microsecond precision, and
	// with "s" appended at the end.
	TimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// The leftmost coordinate of the bounding box.
	XMin *wrapperspb.FloatValue `protobuf:"bytes,2,opt,name=x_min,json=xMin,proto3" json:"x_min,omitempty"`
	// The rightmost coordinate of the bounding box.
	XMax *wrapperspb.FloatValue `protobuf:"bytes,3,opt,name=x_max,json=xMax,proto3" json:"x_max,omitempty"`
	// The topmost coordinate of the bounding box.
	YMin *wrapperspb.FloatValue `protobuf:"bytes,4,opt,name=y_min,json=yMin,proto3" json:"y_min,omitempty"`
	// The bottommost coordinate of the bounding box.
	YMax *wrapperspb.FloatValue `protobuf:"bytes,5,opt,name=y_max,json=yMax,proto3" json:"y_max,omitempty"`
}

func (x *VideoObjectTrackingPredictionResult_Frame) Reset() {
	*x = VideoObjectTrackingPredictionResult_Frame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoObjectTrackingPredictionResult_Frame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoObjectTrackingPredictionResult_Frame) ProtoMessage() {}

func (x *VideoObjectTrackingPredictionResult_Frame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoObjectTrackingPredictionResult_Frame.ProtoReflect.Descriptor instead.
func (*VideoObjectTrackingPredictionResult_Frame) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP(), []int{20, 0}
}

func (x *VideoObjectTrackingPredictionResult_Frame) GetTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult_Frame) GetXMin() *wrapperspb.FloatValue {
	if x != nil {
		return x.XMin
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult_Frame) GetXMax() *wrapperspb.FloatValue {
	if x != nil {
		return x.XMax
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult_Frame) GetYMin() *wrapperspb.FloatValue {
	if x != nil {
		return x.YMin
	}
	return nil
}

func (x *VideoObjectTrackingPredictionResult_Frame) GetYMax() *wrapperspb.FloatValue {
	if x != nil {
		return x.YMax
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_schema_io_format_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x69, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x67, 0x65, 0x6f,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5e, 0x0a, 0x25, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5f, 0x0a, 0x26, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5c, 0x0a, 0x23, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69,
	0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x25, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x22,
	0xb6, 0x01, 0x0a, 0x25, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2c, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x28,
	0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65,
	0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x28, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x45, 0x6e, 0x64, 0x22, 0x5d, 0x0a, 0x24, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x22, 0x58, 0x0a, 0x1f, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x6b, 0x0a,
	0x20, 0x54, 0x65, 0x78, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x81, 0x01, 0x0a, 0x23, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e,
	0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x82,
	0x01, 0x0a, 0x24, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x56, 0x0a, 0x21, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xb0, 0x02, 0x0a, 0x23,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x35, 0x0a, 0x16, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x12, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x1f, 0x6f, 0x6e, 0x65, 0x5f, 0x73,
	0x65, 0x63, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x1c, 0x6f, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4,
	0x01, 0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f,
	0x78, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x26, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61,
	0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9e, 0x01, 0x0a,
	0x10, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x35, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x0a,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xa2, 0x02,
	0x0a, 0x1d, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x63, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x70, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x2a, 0x0a, 0x0a, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x79, 0x0a, 0x1e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x03, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x02,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xb3, 0x01,
	0x0a, 0x24, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x03, 0x69, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x02, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x32, 0x0a, 0x06, 0x62, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x62, 0x62, 0x6f,
	0x78, 0x65, 0x73, 0x22, 0xb7, 0x02, 0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x47, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x43, 0x0a, 0x10, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64,
	0x12, 0x3b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x9c, 0x05,
	0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x43, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x12, 0x3b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f,
	0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x69, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x1a, 0x8b,
	0x02, 0x0a, 0x05, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x04, 0x78, 0x4d, 0x69, 0x6e, 0x12, 0x30, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x04, 0x78, 0x4d, 0x61, 0x78, 0x12, 0x30, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x79, 0x4d, 0x69, 0x6e, 0x12, 0x30, 0x0a, 0x05, 0x79, 0x5f,
	0x6d, 0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x79, 0x4d, 0x61, 0x78, 0x22, 0xef, 0x01, 0x0a,
	0x1e, 0x54, 0x65, 0x78, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x03, 0x69, 0x64,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x17, 0x74, 0x65, 0x78, 0x74,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x03, 0x52, 0x15, 0x74, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x02, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x8b,
	0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0d, 0x49,
	0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x3b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes = []interface{}{
	(*ImageClassificationPredictionInstance)(nil),     // 0: google.cloud.aiplatform.v1beta1.schema.ImageClassificationPredictionInstance
	(*ImageObjectDetectionPredictionInstance)(nil),    // 1: google.cloud.aiplatform.v1beta1.schema.ImageObjectDetectionPredictionInstance
	(*ImageSegmentationPredictionInstance)(nil),       // 2: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationPredictionInstance
	(*VideoClassificationPredictionInstance)(nil),     // 3: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionInstance
	(*VideoObjectTrackingPredictionInstance)(nil),     // 4: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionInstance
	(*VideoActionRecognitionPredictionInstance)(nil),  // 5: google.cloud.aiplatform.v1beta1.schema.VideoActionRecognitionPredictionInstance
	(*TextClassificationPredictionInstance)(nil),      // 6: google.cloud.aiplatform.v1beta1.schema.TextClassificationPredictionInstance
	(*TextSentimentPredictionInstance)(nil),           // 7: google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionInstance
	(*TextExtractionPredictionInstance)(nil),          // 8: google.cloud.aiplatform.v1beta1.schema.TextExtractionPredictionInstance
	(*ImageClassificationPredictionParams)(nil),       // 9: google.cloud.aiplatform.v1beta1.schema.ImageClassificationPredictionParams
	(*ImageObjectDetectionPredictionParams)(nil),      // 10: google.cloud.aiplatform.v1beta1.schema.ImageObjectDetectionPredictionParams
	(*ImageSegmentationPredictionParams)(nil),         // 11: google.cloud.aiplatform.v1beta1.schema.ImageSegmentationPredictionParams
	(*VideoClassificationPredictionParams)(nil),       // 12: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionParams
	(*VideoObjectTrackingPredictionParams)(nil),       // 13: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionParams
	(*VideoActionRecognitionPredictionParams)(nil),    // 14: google.cloud.aiplatform.v1beta1.schema.VideoActionRecognitionPredictionParams
	(*PredictionResult)(nil),                          // 15: google.cloud.aiplatform.v1beta1.schema.PredictionResult
	(*TextSentimentPredictionResult)(nil),             // 16: google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionResult
	(*ClassificationPredictionResult)(nil),            // 17: google.cloud.aiplatform.v1beta1.schema.ClassificationPredictionResult
	(*ImageObjectDetectionPredictionResult)(nil),      // 18: google.cloud.aiplatform.v1beta1.schema.ImageObjectDetectionPredictionResult
	(*VideoClassificationPredictionResult)(nil),       // 19: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionResult
	(*VideoObjectTrackingPredictionResult)(nil),       // 20: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult
	(*TextExtractionPredictionResult)(nil),            // 21: google.cloud.aiplatform.v1beta1.schema.TextExtractionPredictionResult
	(*TextSentimentPredictionResult_Prediction)(nil),  // 22: google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionResult.Prediction
	(*VideoObjectTrackingPredictionResult_Frame)(nil), // 23: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame
	(*structpb.Struct)(nil),                           // 24: google.protobuf.Struct
	(*structpb.Value)(nil),                            // 25: google.protobuf.Value
	(*structpb.ListValue)(nil),                        // 26: google.protobuf.ListValue
	(*durationpb.Duration)(nil),                       // 27: google.protobuf.Duration
	(*wrapperspb.FloatValue)(nil),                     // 28: google.protobuf.FloatValue
}
var file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs = []int32{
	24, // 0: google.cloud.aiplatform.v1beta1.schema.PredictionResult.instance:type_name -> google.protobuf.Struct
	25, // 1: google.cloud.aiplatform.v1beta1.schema.PredictionResult.prediction:type_name -> google.protobuf.Value
	7,  // 2: google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionResult.instance:type_name -> google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionInstance
	22, // 3: google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionResult.prediction:type_name -> google.cloud.aiplatform.v1beta1.schema.TextSentimentPredictionResult.Prediction
	26, // 4: google.cloud.aiplatform.v1beta1.schema.ImageObjectDetectionPredictionResult.bboxes:type_name -> google.protobuf.ListValue
	27, // 5: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionResult.time_segment_start:type_name -> google.protobuf.Duration
	27, // 6: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionResult.time_segment_end:type_name -> google.protobuf.Duration
	28, // 7: google.cloud.aiplatform.v1beta1.schema.VideoClassificationPredictionResult.confidence:type_name -> google.protobuf.FloatValue
	27, // 8: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.time_segment_start:type_name -> google.protobuf.Duration
	27, // 9: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.time_segment_end:type_name -> google.protobuf.Duration
	28, // 10: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.confidence:type_name -> google.protobuf.FloatValue
	23, // 11: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.frames:type_name -> google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame
	27, // 12: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame.time_offset:type_name -> google.protobuf.Duration
	28, // 13: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame.x_min:type_name -> google.protobuf.FloatValue
	28, // 14: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame.x_max:type_name -> google.protobuf.FloatValue
	28, // 15: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame.y_min:type_name -> google.protobuf.FloatValue
	28, // 16: google.cloud.aiplatform.v1beta1.schema.VideoObjectTrackingPredictionResult.Frame.y_max:type_name -> google.protobuf.FloatValue
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_init() }
func file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_io_format_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_annotation_spec_color_proto_init()
	file_google_cloud_aiplatform_v1beta1_schema_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageClassificationPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageObjectDetectionPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoActionRecognitionPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextClassificationPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSentimentPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextExtractionPredictionInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageClassificationPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageObjectDetectionPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageSegmentationPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoActionRecognitionPredictionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSentimentPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageObjectDetectionPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextExtractionPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSentimentPredictionResult_Prediction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoObjectTrackingPredictionResult_Frame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*PredictionResult_Instance)(nil),
		(*PredictionResult_Key)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_io_format_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_io_format_proto_depIdxs = nil
}
