// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/dialogflow/v2beta1/agent.proto

package dialogflow

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Match mode determines how intents are detected from user queries.
type Agent_MatchMode int32

const (
	// Not specified.
	Agent_MATCH_MODE_UNSPECIFIED Agent_MatchMode = 0
	// Best for agents with a small number of examples in intents and/or wide
	// use of templates syntax and composite entities.
	Agent_MATCH_MODE_HYBRID Agent_MatchMode = 1
	// Can be used for agents with a large number of examples in intents,
	// especially the ones using @sys.any or very large custom entities.
	Agent_MATCH_MODE_ML_ONLY Agent_MatchMode = 2
)

// Enum value maps for Agent_MatchMode.
var (
	Agent_MatchMode_name = map[int32]string{
		0: "MATCH_MODE_UNSPECIFIED",
		1: "MATCH_MODE_HYBRID",
		2: "MATCH_MODE_ML_ONLY",
	}
	Agent_MatchMode_value = map[string]int32{
		"MATCH_MODE_UNSPECIFIED": 0,
		"MATCH_MODE_HYBRID":      1,
		"MATCH_MODE_ML_ONLY":     2,
	}
)

func (x Agent_MatchMode) Enum() *Agent_MatchMode {
	p := new(Agent_MatchMode)
	*p = x
	return p
}

func (x Agent_MatchMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Agent_MatchMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[0].Descriptor()
}

func (Agent_MatchMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[0]
}

func (x Agent_MatchMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Agent_MatchMode.Descriptor instead.
func (Agent_MatchMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{0, 0}
}

// API version for the agent.
type Agent_ApiVersion int32

const (
	// Not specified.
	Agent_API_VERSION_UNSPECIFIED Agent_ApiVersion = 0
	// Legacy V1 API.
	Agent_API_VERSION_V1 Agent_ApiVersion = 1
	// V2 API.
	Agent_API_VERSION_V2 Agent_ApiVersion = 2
	// V2beta1 API.
	Agent_API_VERSION_V2_BETA_1 Agent_ApiVersion = 3
)

// Enum value maps for Agent_ApiVersion.
var (
	Agent_ApiVersion_name = map[int32]string{
		0: "API_VERSION_UNSPECIFIED",
		1: "API_VERSION_V1",
		2: "API_VERSION_V2",
		3: "API_VERSION_V2_BETA_1",
	}
	Agent_ApiVersion_value = map[string]int32{
		"API_VERSION_UNSPECIFIED": 0,
		"API_VERSION_V1":          1,
		"API_VERSION_V2":          2,
		"API_VERSION_V2_BETA_1":   3,
	}
)

func (x Agent_ApiVersion) Enum() *Agent_ApiVersion {
	p := new(Agent_ApiVersion)
	*p = x
	return p
}

func (x Agent_ApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Agent_ApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[1].Descriptor()
}

func (Agent_ApiVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[1]
}

func (x Agent_ApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Agent_ApiVersion.Descriptor instead.
func (Agent_ApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{0, 1}
}

// Represents the agent tier.
type Agent_Tier int32

const (
	// Not specified. This value should never be used.
	Agent_TIER_UNSPECIFIED Agent_Tier = 0
	// Standard tier.
	Agent_TIER_STANDARD Agent_Tier = 1
	// Enterprise tier (Essentials).
	Agent_TIER_ENTERPRISE Agent_Tier = 2
	// Enterprise tier (Plus).
	Agent_TIER_ENTERPRISE_PLUS Agent_Tier = 3
)

// Enum value maps for Agent_Tier.
var (
	Agent_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "TIER_STANDARD",
		2: "TIER_ENTERPRISE",
		3: "TIER_ENTERPRISE_PLUS",
	}
	Agent_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED":     0,
		"TIER_STANDARD":        1,
		"TIER_ENTERPRISE":      2,
		"TIER_ENTERPRISE_PLUS": 3,
	}
)

func (x Agent_Tier) Enum() *Agent_Tier {
	p := new(Agent_Tier)
	*p = x
	return p
}

func (x Agent_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Agent_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[2].Descriptor()
}

func (Agent_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes[2]
}

func (x Agent_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Agent_Tier.Descriptor instead.
func (Agent_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{0, 2}
}

// Represents a conversational agent.
type Agent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project of this agent.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of this agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The default language of the agent as a language tag. See
	// [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. This field cannot be
	// set by the `Update` method.
	DefaultLanguageCode string `protobuf:"bytes,3,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// Optional. The list of all languages supported by this agent (except for the
	// `default_language_code`).
	SupportedLanguageCodes []string `protobuf:"bytes,4,rep,name=supported_language_codes,json=supportedLanguageCodes,proto3" json:"supported_language_codes,omitempty"`
	// Required. The time zone of this agent from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The description of this agent.
	// The maximum length is 500 characters. If exceeded, the request is rejected.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The URI of the agent's avatar.
	// Avatars are used throughout the Dialogflow console and in the self-hosted
	// [Web
	// Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `protobuf:"bytes,7,opt,name=avatar_uri,json=avatarUri,proto3" json:"avatar_uri,omitempty"`
	// Optional. Determines whether this agent should log conversation queries.
	EnableLogging bool `protobuf:"varint,8,opt,name=enable_logging,json=enableLogging,proto3" json:"enable_logging,omitempty"`
	// Optional. Determines how intents are detected from user queries.
	MatchMode Agent_MatchMode `protobuf:"varint,9,opt,name=match_mode,json=matchMode,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_MatchMode" json:"match_mode,omitempty"`
	// Optional. To filter out false positive results and still get variety in
	// matched natural language inputs for your agent, you can tune the machine
	// learning classification threshold. If the returned score value is less than
	// the threshold value, then a fallback intent will be triggered or, if there
	// are no fallback intents defined, no intent will be triggered. The score
	// values range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// If set to 0.0, the default of 0.3 is used.
	ClassificationThreshold float32 `protobuf:"fixed32,10,opt,name=classification_threshold,json=classificationThreshold,proto3" json:"classification_threshold,omitempty"`
	// Optional. API version displayed in Dialogflow console. If not specified,
	// V2 API is assumed. Clients are free to query different service endpoints
	// for different API versions. However, bots connectors and webhook calls will
	// follow the specified API version.
	ApiVersion Agent_ApiVersion `protobuf:"varint,14,opt,name=api_version,json=apiVersion,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_ApiVersion" json:"api_version,omitempty"`
	// Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
	Tier Agent_Tier `protobuf:"varint,15,opt,name=tier,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_Tier" json:"tier,omitempty"`
}

func (x *Agent) Reset() {
	*x = Agent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Agent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent) ProtoMessage() {}

func (x *Agent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent.ProtoReflect.Descriptor instead.
func (*Agent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{0}
}

func (x *Agent) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Agent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Agent) GetDefaultLanguageCode() string {
	if x != nil {
		return x.DefaultLanguageCode
	}
	return ""
}

func (x *Agent) GetSupportedLanguageCodes() []string {
	if x != nil {
		return x.SupportedLanguageCodes
	}
	return nil
}

func (x *Agent) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Agent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Agent) GetAvatarUri() string {
	if x != nil {
		return x.AvatarUri
	}
	return ""
}

func (x *Agent) GetEnableLogging() bool {
	if x != nil {
		return x.EnableLogging
	}
	return false
}

func (x *Agent) GetMatchMode() Agent_MatchMode {
	if x != nil {
		return x.MatchMode
	}
	return Agent_MATCH_MODE_UNSPECIFIED
}

func (x *Agent) GetClassificationThreshold() float32 {
	if x != nil {
		return x.ClassificationThreshold
	}
	return 0
}

func (x *Agent) GetApiVersion() Agent_ApiVersion {
	if x != nil {
		return x.ApiVersion
	}
	return Agent_API_VERSION_UNSPECIFIED
}

func (x *Agent) GetTier() Agent_Tier {
	if x != nil {
		return x.Tier
	}
	return Agent_TIER_UNSPECIFIED
}

// The request message for [Agents.GetAgent][google.cloud.dialogflow.v2beta1.Agents.GetAgent].
type GetAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to fetch is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GetAgentRequest) Reset() {
	*x = GetAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentRequest) ProtoMessage() {}

func (x *GetAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentRequest.ProtoReflect.Descriptor instead.
func (*GetAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{1}
}

func (x *GetAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The request message for [Agents.SetAgent][google.cloud.dialogflow.v2beta1.Agents.SetAgent].
type SetAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to update.
	Agent *Agent `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *SetAgentRequest) Reset() {
	*x = SetAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAgentRequest) ProtoMessage() {}

func (x *SetAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAgentRequest.ProtoReflect.Descriptor instead.
func (*SetAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{2}
}

func (x *SetAgentRequest) GetAgent() *Agent {
	if x != nil {
		return x.Agent
	}
	return nil
}

func (x *SetAgentRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for [Agents.DeleteAgent][google.cloud.dialogflow.v2beta1.Agents.DeleteAgent].
type DeleteAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to delete is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *DeleteAgentRequest) Reset() {
	*x = DeleteAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAgentRequest) ProtoMessage() {}

func (x *DeleteAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAgentRequest.ProtoReflect.Descriptor instead.
func (*DeleteAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Contains basic configuration for a sub-agent.
type SubAgent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project of this agent.
	// Format: `projects/<Project ID>`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. The unique identifier (`environment name` in dialogflow console)
	// of this sub-agent environment. Assumes draft environment if `environment`
	// is not set.
	Environment string `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *SubAgent) Reset() {
	*x = SubAgent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubAgent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubAgent) ProtoMessage() {}

func (x *SubAgent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubAgent.ProtoReflect.Descriptor instead.
func (*SubAgent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{4}
}

func (x *SubAgent) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SubAgent) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

// The request message for [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
type SearchAgentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list agents from.
	// Format: `projects/<Project ID or '-'>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchAgentsRequest) Reset() {
	*x = SearchAgentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAgentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAgentsRequest) ProtoMessage() {}

func (x *SearchAgentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAgentsRequest.ProtoReflect.Descriptor instead.
func (*SearchAgentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{5}
}

func (x *SearchAgentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchAgentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAgentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
type SearchAgentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of agents. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Agents []*Agent `protobuf:"bytes,1,rep,name=agents,proto3" json:"agents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAgentsResponse) Reset() {
	*x = SearchAgentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAgentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAgentsResponse) ProtoMessage() {}

func (x *SearchAgentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAgentsResponse.ProtoReflect.Descriptor instead.
func (*SearchAgentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{6}
}

func (x *SearchAgentsResponse) GetAgents() []*Agent {
	if x != nil {
		return x.Agents
	}
	return nil
}

func (x *SearchAgentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for [Agents.TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent].
type TrainAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to train is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *TrainAgentRequest) Reset() {
	*x = TrainAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainAgentRequest) ProtoMessage() {}

func (x *TrainAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainAgentRequest.ProtoReflect.Descriptor instead.
func (*TrainAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{7}
}

func (x *TrainAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The request message for [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
type ExportAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to export is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The
	// [Google Cloud Storage](https://cloud.google.com/storage/docs/)
	// URI to export the agent to.
	// The format of this URI must be `gs://<bucket-name>/<object-name>`.
	// If left unspecified, the serialized agent is returned inline.
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3" json:"agent_uri,omitempty"`
}

func (x *ExportAgentRequest) Reset() {
	*x = ExportAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAgentRequest) ProtoMessage() {}

func (x *ExportAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAgentRequest.ProtoReflect.Descriptor instead.
func (*ExportAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{8}
}

func (x *ExportAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportAgentRequest) GetAgentUri() string {
	if x != nil {
		return x.AgentUri
	}
	return ""
}

// The response message for [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
type ExportAgentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported agent.
	//
	// Types that are assignable to Agent:
	//	*ExportAgentResponse_AgentUri
	//	*ExportAgentResponse_AgentContent
	Agent isExportAgentResponse_Agent `protobuf_oneof:"agent"`
}

func (x *ExportAgentResponse) Reset() {
	*x = ExportAgentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAgentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAgentResponse) ProtoMessage() {}

func (x *ExportAgentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAgentResponse.ProtoReflect.Descriptor instead.
func (*ExportAgentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{9}
}

func (m *ExportAgentResponse) GetAgent() isExportAgentResponse_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (x *ExportAgentResponse) GetAgentUri() string {
	if x, ok := x.GetAgent().(*ExportAgentResponse_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (x *ExportAgentResponse) GetAgentContent() []byte {
	if x, ok := x.GetAgent().(*ExportAgentResponse_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

type isExportAgentResponse_Agent interface {
	isExportAgentResponse_Agent()
}

type ExportAgentResponse_AgentUri struct {
	// The URI to a file containing the exported agent. This field is populated
	// only if `agent_uri` is specified in `ExportAgentRequest`.
	AgentUri string `protobuf:"bytes,1,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ExportAgentResponse_AgentContent struct {
	// Zip compressed raw byte content for agent.
	AgentContent []byte `protobuf:"bytes,2,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ExportAgentResponse_AgentUri) isExportAgentResponse_Agent() {}

func (*ExportAgentResponse_AgentContent) isExportAgentResponse_Agent() {}

// The request message for [Agents.ImportAgent][google.cloud.dialogflow.v2beta1.Agents.ImportAgent].
type ImportAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to import is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to import.
	//
	// Types that are assignable to Agent:
	//	*ImportAgentRequest_AgentUri
	//	*ImportAgentRequest_AgentContent
	Agent isImportAgentRequest_Agent `protobuf_oneof:"agent"`
}

func (x *ImportAgentRequest) Reset() {
	*x = ImportAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAgentRequest) ProtoMessage() {}

func (x *ImportAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAgentRequest.ProtoReflect.Descriptor instead.
func (*ImportAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{10}
}

func (x *ImportAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportAgentRequest) GetAgent() isImportAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (x *ImportAgentRequest) GetAgentUri() string {
	if x, ok := x.GetAgent().(*ImportAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (x *ImportAgentRequest) GetAgentContent() []byte {
	if x, ok := x.GetAgent().(*ImportAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

type isImportAgentRequest_Agent interface {
	isImportAgentRequest_Agent()
}

type ImportAgentRequest_AgentUri struct {
	// The URI to a Google Cloud Storage file containing the agent to import.
	// Note: The URI must start with "gs://".
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ImportAgentRequest_AgentContent struct {
	// Zip compressed raw byte content for agent.
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ImportAgentRequest_AgentUri) isImportAgentRequest_Agent() {}

func (*ImportAgentRequest_AgentContent) isImportAgentRequest_Agent() {}

// The request message for [Agents.RestoreAgent][google.cloud.dialogflow.v2beta1.Agents.RestoreAgent].
type RestoreAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent to restore is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to restore.
	//
	// Types that are assignable to Agent:
	//	*RestoreAgentRequest_AgentUri
	//	*RestoreAgentRequest_AgentContent
	Agent isRestoreAgentRequest_Agent `protobuf_oneof:"agent"`
}

func (x *RestoreAgentRequest) Reset() {
	*x = RestoreAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreAgentRequest) ProtoMessage() {}

func (x *RestoreAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreAgentRequest.ProtoReflect.Descriptor instead.
func (*RestoreAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{11}
}

func (x *RestoreAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *RestoreAgentRequest) GetAgent() isRestoreAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (x *RestoreAgentRequest) GetAgentUri() string {
	if x, ok := x.GetAgent().(*RestoreAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (x *RestoreAgentRequest) GetAgentContent() []byte {
	if x, ok := x.GetAgent().(*RestoreAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

type isRestoreAgentRequest_Agent interface {
	isRestoreAgentRequest_Agent()
}

type RestoreAgentRequest_AgentUri struct {
	// The URI to a Google Cloud Storage file containing the agent to restore.
	// Note: The URI must start with "gs://".
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type RestoreAgentRequest_AgentContent struct {
	// Zip compressed raw byte content for agent.
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*RestoreAgentRequest_AgentUri) isRestoreAgentRequest_Agent() {}

func (*RestoreAgentRequest_AgentContent) isRestoreAgentRequest_Agent() {}

// The request message for [Agents.GetValidationResult][google.cloud.dialogflow.v2beta1.Agents.GetValidationResult].
type GetValidationResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the agent is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language for which you want a validation result. If not
	// specified, the agent's default language is used. [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetValidationResultRequest) Reset() {
	*x = GetValidationResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetValidationResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValidationResultRequest) ProtoMessage() {}

func (x *GetValidationResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValidationResultRequest.ProtoReflect.Descriptor instead.
func (*GetValidationResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP(), []int{12}
}

func (x *GetValidationResultRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GetValidationResultRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

var File_google_cloud_dialogflow_v2beta1_agent_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_agent_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xeb, 0x07, 0x0a, 0x05, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x55,
	0x72, 0x69, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x0a, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x39, 0x0a, 0x18, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x52, 0x17, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61,
	0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x04, 0x74, 0x69, 0x65,
	0x72, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x54, 0x69, 0x65, 0x72, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x22, 0x56, 0x0a, 0x09, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x48, 0x59, 0x42, 0x52, 0x49, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x4c, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x02, 0x22, 0x6c, 0x0a, 0x0a, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x17, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x31, 0x10,
	0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x56, 0x32, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x32, 0x5f, 0x42, 0x45, 0x54, 0x41, 0x5f, 0x31, 0x10, 0x03,
	0x22, 0x5e, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10,
	0x01, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50,
	0x52, 0x49, 0x53, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x10, 0x03,
	0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x12, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22,
	0x52, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x22, 0x8c, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x05,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x55, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x08, 0x53, 0x75, 0x62,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x92, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x21, 0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7e, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e,
	0x0a, 0x06, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x49, 0x0a, 0x12,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x22, 0x64, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d,
	0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a,
	0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0xa4, 0x01,
	0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x22, 0xa5, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a,
	0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0d,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x87, 0x01, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x32, 0x87, 0x12, 0x0a, 0x06, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xcb, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56,
	0x12, 0x22, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5a, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xe4, 0x01, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x7e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x70, 0x22, 0x28,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5a,
	0x3d, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0xda, 0x41,
	0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0xc1, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x2a, 0x22, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5a,
	0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf0, 0x01, 0x0a, 0x0c, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64,
	0x12, 0x29, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a, 0x37, 0x12, 0x35, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x8b, 0x02,
	0x0a, 0x0a, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x69, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0xad, 0x02, 0x0a, 0x0b,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x22, 0x29, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x4d, 0x0a, 0x33,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x86, 0x02, 0x0a, 0x0b,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x22, 0x29, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a,
	0x01, 0x2a, 0xca, 0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x12, 0x8a, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x6c, 0x22, 0x2a, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a,
	0x01, 0x2a, 0x5a, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x01, 0x2a, 0xca,
	0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x12, 0xc2, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x35, 0x12, 0x33, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x42, 0xa8, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0a, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_agent_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_agent_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_dialogflow_v2beta1_agent_proto_goTypes = []interface{}{
	(Agent_MatchMode)(0),               // 0: google.cloud.dialogflow.v2beta1.Agent.MatchMode
	(Agent_ApiVersion)(0),              // 1: google.cloud.dialogflow.v2beta1.Agent.ApiVersion
	(Agent_Tier)(0),                    // 2: google.cloud.dialogflow.v2beta1.Agent.Tier
	(*Agent)(nil),                      // 3: google.cloud.dialogflow.v2beta1.Agent
	(*GetAgentRequest)(nil),            // 4: google.cloud.dialogflow.v2beta1.GetAgentRequest
	(*SetAgentRequest)(nil),            // 5: google.cloud.dialogflow.v2beta1.SetAgentRequest
	(*DeleteAgentRequest)(nil),         // 6: google.cloud.dialogflow.v2beta1.DeleteAgentRequest
	(*SubAgent)(nil),                   // 7: google.cloud.dialogflow.v2beta1.SubAgent
	(*SearchAgentsRequest)(nil),        // 8: google.cloud.dialogflow.v2beta1.SearchAgentsRequest
	(*SearchAgentsResponse)(nil),       // 9: google.cloud.dialogflow.v2beta1.SearchAgentsResponse
	(*TrainAgentRequest)(nil),          // 10: google.cloud.dialogflow.v2beta1.TrainAgentRequest
	(*ExportAgentRequest)(nil),         // 11: google.cloud.dialogflow.v2beta1.ExportAgentRequest
	(*ExportAgentResponse)(nil),        // 12: google.cloud.dialogflow.v2beta1.ExportAgentResponse
	(*ImportAgentRequest)(nil),         // 13: google.cloud.dialogflow.v2beta1.ImportAgentRequest
	(*RestoreAgentRequest)(nil),        // 14: google.cloud.dialogflow.v2beta1.RestoreAgentRequest
	(*GetValidationResultRequest)(nil), // 15: google.cloud.dialogflow.v2beta1.GetValidationResultRequest
	(*field_mask.FieldMask)(nil),       // 16: google.protobuf.FieldMask
	(*empty.Empty)(nil),                // 17: google.protobuf.Empty
	(*longrunning.Operation)(nil),      // 18: google.longrunning.Operation
	(*ValidationResult)(nil),           // 19: google.cloud.dialogflow.v2beta1.ValidationResult
}
var file_google_cloud_dialogflow_v2beta1_agent_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.v2beta1.Agent.match_mode:type_name -> google.cloud.dialogflow.v2beta1.Agent.MatchMode
	1,  // 1: google.cloud.dialogflow.v2beta1.Agent.api_version:type_name -> google.cloud.dialogflow.v2beta1.Agent.ApiVersion
	2,  // 2: google.cloud.dialogflow.v2beta1.Agent.tier:type_name -> google.cloud.dialogflow.v2beta1.Agent.Tier
	3,  // 3: google.cloud.dialogflow.v2beta1.SetAgentRequest.agent:type_name -> google.cloud.dialogflow.v2beta1.Agent
	16, // 4: google.cloud.dialogflow.v2beta1.SetAgentRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 5: google.cloud.dialogflow.v2beta1.SearchAgentsResponse.agents:type_name -> google.cloud.dialogflow.v2beta1.Agent
	4,  // 6: google.cloud.dialogflow.v2beta1.Agents.GetAgent:input_type -> google.cloud.dialogflow.v2beta1.GetAgentRequest
	5,  // 7: google.cloud.dialogflow.v2beta1.Agents.SetAgent:input_type -> google.cloud.dialogflow.v2beta1.SetAgentRequest
	6,  // 8: google.cloud.dialogflow.v2beta1.Agents.DeleteAgent:input_type -> google.cloud.dialogflow.v2beta1.DeleteAgentRequest
	8,  // 9: google.cloud.dialogflow.v2beta1.Agents.SearchAgents:input_type -> google.cloud.dialogflow.v2beta1.SearchAgentsRequest
	10, // 10: google.cloud.dialogflow.v2beta1.Agents.TrainAgent:input_type -> google.cloud.dialogflow.v2beta1.TrainAgentRequest
	11, // 11: google.cloud.dialogflow.v2beta1.Agents.ExportAgent:input_type -> google.cloud.dialogflow.v2beta1.ExportAgentRequest
	13, // 12: google.cloud.dialogflow.v2beta1.Agents.ImportAgent:input_type -> google.cloud.dialogflow.v2beta1.ImportAgentRequest
	14, // 13: google.cloud.dialogflow.v2beta1.Agents.RestoreAgent:input_type -> google.cloud.dialogflow.v2beta1.RestoreAgentRequest
	15, // 14: google.cloud.dialogflow.v2beta1.Agents.GetValidationResult:input_type -> google.cloud.dialogflow.v2beta1.GetValidationResultRequest
	3,  // 15: google.cloud.dialogflow.v2beta1.Agents.GetAgent:output_type -> google.cloud.dialogflow.v2beta1.Agent
	3,  // 16: google.cloud.dialogflow.v2beta1.Agents.SetAgent:output_type -> google.cloud.dialogflow.v2beta1.Agent
	17, // 17: google.cloud.dialogflow.v2beta1.Agents.DeleteAgent:output_type -> google.protobuf.Empty
	9,  // 18: google.cloud.dialogflow.v2beta1.Agents.SearchAgents:output_type -> google.cloud.dialogflow.v2beta1.SearchAgentsResponse
	18, // 19: google.cloud.dialogflow.v2beta1.Agents.TrainAgent:output_type -> google.longrunning.Operation
	18, // 20: google.cloud.dialogflow.v2beta1.Agents.ExportAgent:output_type -> google.longrunning.Operation
	18, // 21: google.cloud.dialogflow.v2beta1.Agents.ImportAgent:output_type -> google.longrunning.Operation
	18, // 22: google.cloud.dialogflow.v2beta1.Agents.RestoreAgent:output_type -> google.longrunning.Operation
	19, // 23: google.cloud.dialogflow.v2beta1.Agents.GetValidationResult:output_type -> google.cloud.dialogflow.v2beta1.ValidationResult
	15, // [15:24] is the sub-list for method output_type
	6,  // [6:15] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_agent_proto_init() }
func file_google_cloud_dialogflow_v2beta1_agent_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_agent_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_environment_proto_init()
	file_google_cloud_dialogflow_v2beta1_validation_result_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Agent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubAgent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAgentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAgentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAgentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetValidationResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ExportAgentResponse_AgentUri)(nil),
		(*ExportAgentResponse_AgentContent)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ImportAgentRequest_AgentUri)(nil),
		(*ImportAgentRequest_AgentContent)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*RestoreAgentRequest_AgentUri)(nil),
		(*RestoreAgentRequest_AgentContent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_agent_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_agent_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_agent_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_agent_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_agent_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_agent_proto = out.File
	file_google_cloud_dialogflow_v2beta1_agent_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_agent_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_agent_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentsClient is the client API for Agents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentsClient interface {
	// Retrieves the specified agent.
	GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the list of agents.
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]>
	ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from [ImportAgentRequest][google.cloud.dialogflow.v2beta1.ImportAgentRequest]. After the import, the imported draft
	// agent will be trained automatically (unless disabled in agent settings).
	// However, once the import is done, training may not be completed yet. Please
	// call [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait for the operation it returns in order to train
	// explicitly.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	// An operation which tracks when importing is complete. It only tracks
	// when the draft agent is updated not when it is done training.
	ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted. After the restore, the
	// restored draft agent will be trained automatically (unless disabled in
	// agent settings). However, once the restore is done, training may not be
	// completed yet. Please call [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait for the operation it
	// returns in order to train explicitly.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	// An operation which tracks when restoring is complete. It only tracks
	// when the draft agent is updated not when it is done training.
	RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error)
}

type agentsClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentsClient(cc grpc.ClientConnInterface) AgentsClient {
	return &agentsClient{cc}
}

func (c *agentsClient) GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/GetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/SetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/DeleteAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error) {
	out := new(SearchAgentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/SearchAgents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/TrainAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/ExportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/ImportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/RestoreAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error) {
	out := new(ValidationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/GetValidationResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentsServer is the server API for Agents service.
type AgentsServer interface {
	// Retrieves the specified agent.
	GetAgent(context.Context, *GetAgentRequest) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(context.Context, *SetAgentRequest) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(context.Context, *DeleteAgentRequest) (*empty.Empty, error)
	// Returns the list of agents.
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(context.Context, *TrainAgentRequest) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]>
	ExportAgent(context.Context, *ExportAgentRequest) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from [ImportAgentRequest][google.cloud.dialogflow.v2beta1.ImportAgentRequest]. After the import, the imported draft
	// agent will be trained automatically (unless disabled in agent settings).
	// However, once the import is done, training may not be completed yet. Please
	// call [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait for the operation it returns in order to train
	// explicitly.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	// An operation which tracks when importing is complete. It only tracks
	// when the draft agent is updated not when it is done training.
	ImportAgent(context.Context, *ImportAgentRequest) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted. After the restore, the
	// restored draft agent will be trained automatically (unless disabled in
	// agent settings). However, once the restore is done, training may not be
	// completed yet. Please call [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait for the operation it
	// returns in order to train explicitly.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	// An operation which tracks when restoring is complete. It only tracks
	// when the draft agent is updated not when it is done training.
	RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunning.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(context.Context, *GetValidationResultRequest) (*ValidationResult, error)
}

// UnimplementedAgentsServer can be embedded to have forward compatible implementations.
type UnimplementedAgentsServer struct {
}

func (*UnimplementedAgentsServer) GetAgent(context.Context, *GetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgent not implemented")
}
func (*UnimplementedAgentsServer) SetAgent(context.Context, *SetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAgent not implemented")
}
func (*UnimplementedAgentsServer) DeleteAgent(context.Context, *DeleteAgentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgent not implemented")
}
func (*UnimplementedAgentsServer) SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAgents not implemented")
}
func (*UnimplementedAgentsServer) TrainAgent(context.Context, *TrainAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainAgent not implemented")
}
func (*UnimplementedAgentsServer) ExportAgent(context.Context, *ExportAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAgent not implemented")
}
func (*UnimplementedAgentsServer) ImportAgent(context.Context, *ImportAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAgent not implemented")
}
func (*UnimplementedAgentsServer) RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreAgent not implemented")
}
func (*UnimplementedAgentsServer) GetValidationResult(context.Context, *GetValidationResultRequest) (*ValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidationResult not implemented")
}

func RegisterAgentsServer(s *grpc.Server, srv AgentsServer) {
	s.RegisterService(&_Agents_serviceDesc, srv)
}

func _Agents_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/GetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgent(ctx, req.(*GetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/SetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SetAgent(ctx, req.(*SetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_DeleteAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).DeleteAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/DeleteAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).DeleteAgent(ctx, req.(*DeleteAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SearchAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAgentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SearchAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/SearchAgents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SearchAgents(ctx, req.(*SearchAgentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_TrainAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).TrainAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/TrainAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).TrainAgent(ctx, req.(*TrainAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ExportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ExportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/ExportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ExportAgent(ctx, req.(*ExportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ImportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ImportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/ImportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ImportAgent(ctx, req.(*ImportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_RestoreAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).RestoreAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/RestoreAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).RestoreAgent(ctx, req.(*RestoreAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/GetValidationResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetValidationResult(ctx, req.(*GetValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Agents",
	HandlerType: (*AgentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAgent",
			Handler:    _Agents_GetAgent_Handler,
		},
		{
			MethodName: "SetAgent",
			Handler:    _Agents_SetAgent_Handler,
		},
		{
			MethodName: "DeleteAgent",
			Handler:    _Agents_DeleteAgent_Handler,
		},
		{
			MethodName: "SearchAgents",
			Handler:    _Agents_SearchAgents_Handler,
		},
		{
			MethodName: "TrainAgent",
			Handler:    _Agents_TrainAgent_Handler,
		},
		{
			MethodName: "ExportAgent",
			Handler:    _Agents_ExportAgent_Handler,
		},
		{
			MethodName: "ImportAgent",
			Handler:    _Agents_ImportAgent_Handler,
		},
		{
			MethodName: "RestoreAgent",
			Handler:    _Agents_RestoreAgent_Handler,
		},
		{
			MethodName: "GetValidationResult",
			Handler:    _Agents_GetValidationResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/agent.proto",
}
