// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package analyticsadmin provides access to the Google Analytics Admin API.
//
// For product documentation, see: http://code.google.com/apis/analytics/docs/mgmt/home.html
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/analyticsadmin/v1beta"
//	...
//	ctx := context.Background()
//	analyticsadminService, err := analyticsadmin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithScopes(analyticsadmin.AnalyticsReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package analyticsadmin // import "google.golang.org/api/analyticsadmin/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "analyticsadmin:v1beta"
const apiName = "analyticsadmin"
const apiVersion = "v1beta"
const basePath = "https://analyticsadmin.googleapis.com/"
const basePathTemplate = "https://analyticsadmin.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://analyticsadmin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Edit Google Analytics management entities
	AnalyticsEditScope = "https://www.googleapis.com/auth/analytics.edit"

	// See and download your Google Analytics data
	AnalyticsReadonlyScope = "https://www.googleapis.com/auth/analytics.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/analytics.edit",
		"https://www.googleapis.com/auth/analytics.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.AccountSummaries = NewAccountSummariesService(s)
	s.Accounts = NewAccountsService(s)
	s.Properties = NewPropertiesService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AccountSummaries *AccountSummariesService

	Accounts *AccountsService

	Properties *PropertiesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountSummariesService(s *Service) *AccountSummariesService {
	rs := &AccountSummariesService{s: s}
	return rs
}

type AccountSummariesService struct {
	s *Service
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	return rs
}

type AccountsService struct {
	s *Service
}

func NewPropertiesService(s *Service) *PropertiesService {
	rs := &PropertiesService{s: s}
	rs.ConversionEvents = NewPropertiesConversionEventsService(s)
	rs.CustomDimensions = NewPropertiesCustomDimensionsService(s)
	rs.CustomMetrics = NewPropertiesCustomMetricsService(s)
	rs.DataStreams = NewPropertiesDataStreamsService(s)
	rs.FirebaseLinks = NewPropertiesFirebaseLinksService(s)
	rs.GoogleAdsLinks = NewPropertiesGoogleAdsLinksService(s)
	rs.KeyEvents = NewPropertiesKeyEventsService(s)
	return rs
}

type PropertiesService struct {
	s *Service

	ConversionEvents *PropertiesConversionEventsService

	CustomDimensions *PropertiesCustomDimensionsService

	CustomMetrics *PropertiesCustomMetricsService

	DataStreams *PropertiesDataStreamsService

	FirebaseLinks *PropertiesFirebaseLinksService

	GoogleAdsLinks *PropertiesGoogleAdsLinksService

	KeyEvents *PropertiesKeyEventsService
}

func NewPropertiesConversionEventsService(s *Service) *PropertiesConversionEventsService {
	rs := &PropertiesConversionEventsService{s: s}
	return rs
}

type PropertiesConversionEventsService struct {
	s *Service
}

func NewPropertiesCustomDimensionsService(s *Service) *PropertiesCustomDimensionsService {
	rs := &PropertiesCustomDimensionsService{s: s}
	return rs
}

type PropertiesCustomDimensionsService struct {
	s *Service
}

func NewPropertiesCustomMetricsService(s *Service) *PropertiesCustomMetricsService {
	rs := &PropertiesCustomMetricsService{s: s}
	return rs
}

type PropertiesCustomMetricsService struct {
	s *Service
}

func NewPropertiesDataStreamsService(s *Service) *PropertiesDataStreamsService {
	rs := &PropertiesDataStreamsService{s: s}
	rs.MeasurementProtocolSecrets = NewPropertiesDataStreamsMeasurementProtocolSecretsService(s)
	return rs
}

type PropertiesDataStreamsService struct {
	s *Service

	MeasurementProtocolSecrets *PropertiesDataStreamsMeasurementProtocolSecretsService
}

func NewPropertiesDataStreamsMeasurementProtocolSecretsService(s *Service) *PropertiesDataStreamsMeasurementProtocolSecretsService {
	rs := &PropertiesDataStreamsMeasurementProtocolSecretsService{s: s}
	return rs
}

type PropertiesDataStreamsMeasurementProtocolSecretsService struct {
	s *Service
}

func NewPropertiesFirebaseLinksService(s *Service) *PropertiesFirebaseLinksService {
	rs := &PropertiesFirebaseLinksService{s: s}
	return rs
}

type PropertiesFirebaseLinksService struct {
	s *Service
}

func NewPropertiesGoogleAdsLinksService(s *Service) *PropertiesGoogleAdsLinksService {
	rs := &PropertiesGoogleAdsLinksService{s: s}
	return rs
}

type PropertiesGoogleAdsLinksService struct {
	s *Service
}

func NewPropertiesKeyEventsService(s *Service) *PropertiesKeyEventsService {
	rs := &PropertiesKeyEventsService{s: s}
	return rs
}

type PropertiesKeyEventsService struct {
	s *Service
}

// GoogleAnalyticsAdminV1betaAccessBetweenFilter: To express that the result
// needs to be between two numbers (inclusive).
type GoogleAnalyticsAdminV1betaAccessBetweenFilter struct {
	// FromValue: Begins with this number.
	FromValue *GoogleAnalyticsAdminV1betaNumericValue `json:"fromValue,omitempty"`
	// ToValue: Ends with this number.
	ToValue *GoogleAnalyticsAdminV1betaNumericValue `json:"toValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FromValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FromValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessBetweenFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessBetweenFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessDateRange: A contiguous range of days:
// startDate, startDate + 1, ..., endDate.
type GoogleAnalyticsAdminV1betaAccessDateRange struct {
	// EndDate: The inclusive end date for the query in the format `YYYY-MM-DD`.
	// Cannot be before `startDate`. The format `NdaysAgo`, `yesterday`, or `today`
	// is also accepted, and in that case, the date is inferred based on the
	// current time in the request's time zone.
	EndDate string `json:"endDate,omitempty"`
	// StartDate: The inclusive start date for the query in the format
	// `YYYY-MM-DD`. Cannot be after `endDate`. The format `NdaysAgo`, `yesterday`,
	// or `today` is also accepted, and in that case, the date is inferred based on
	// the current time in the request's time zone.
	StartDate string `json:"startDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessDateRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessDateRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessDimension: Dimensions are attributes of your
// data. For example, the dimension `userEmail` indicates the email of the user
// that accessed reporting data. Dimension values in report responses are
// strings.
type GoogleAnalyticsAdminV1betaAccessDimension struct {
	// DimensionName: The API name of the dimension. See Data Access Schema
	// (https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of dimensions supported in this API. Dimensions are referenced
	// by name in `dimensionFilter` and `orderBys`.
	DimensionName string `json:"dimensionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessDimensionHeader: Describes a dimension
// column in the report. Dimensions requested in a report produce column
// entries within rows and DimensionHeaders. However, dimensions used
// exclusively within filters or expressions do not produce columns in a
// report; correspondingly, those dimensions do not produce headers.
type GoogleAnalyticsAdminV1betaAccessDimensionHeader struct {
	// DimensionName: The dimension's name; for example 'userEmail'.
	DimensionName string `json:"dimensionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessDimensionHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessDimensionHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessDimensionValue: The value of a dimension.
type GoogleAnalyticsAdminV1betaAccessDimensionValue struct {
	// Value: The dimension value. For example, this value may be 'France' for the
	// 'country' dimension.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessDimensionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessDimensionValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessFilter: An expression to filter dimension or
// metric values.
type GoogleAnalyticsAdminV1betaAccessFilter struct {
	// BetweenFilter: A filter for two values.
	BetweenFilter *GoogleAnalyticsAdminV1betaAccessBetweenFilter `json:"betweenFilter,omitempty"`
	// FieldName: The dimension name or metric name.
	FieldName string `json:"fieldName,omitempty"`
	// InListFilter: A filter for in list values.
	InListFilter *GoogleAnalyticsAdminV1betaAccessInListFilter `json:"inListFilter,omitempty"`
	// NumericFilter: A filter for numeric or date values.
	NumericFilter *GoogleAnalyticsAdminV1betaAccessNumericFilter `json:"numericFilter,omitempty"`
	// StringFilter: Strings related filter.
	StringFilter *GoogleAnalyticsAdminV1betaAccessStringFilter `json:"stringFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BetweenFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BetweenFilter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessFilterExpression: Expresses dimension or
// metric filters. The fields in the same expression need to be either all
// dimensions or all metrics.
type GoogleAnalyticsAdminV1betaAccessFilterExpression struct {
	// AccessFilter: A primitive filter. In the same FilterExpression, all of the
	// filter's field names need to be either all dimensions or all metrics.
	AccessFilter *GoogleAnalyticsAdminV1betaAccessFilter `json:"accessFilter,omitempty"`
	// AndGroup: Each of the FilterExpressions in the and_group has an AND
	// relationship.
	AndGroup *GoogleAnalyticsAdminV1betaAccessFilterExpressionList `json:"andGroup,omitempty"`
	// NotExpression: The FilterExpression is NOT of not_expression.
	NotExpression *GoogleAnalyticsAdminV1betaAccessFilterExpression `json:"notExpression,omitempty"`
	// OrGroup: Each of the FilterExpressions in the or_group has an OR
	// relationship.
	OrGroup *GoogleAnalyticsAdminV1betaAccessFilterExpressionList `json:"orGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessFilter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessFilterExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessFilterExpression
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessFilterExpressionList: A list of filter
// expressions.
type GoogleAnalyticsAdminV1betaAccessFilterExpressionList struct {
	// Expressions: A list of filter expressions.
	Expressions []*GoogleAnalyticsAdminV1betaAccessFilterExpression `json:"expressions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Expressions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Expressions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessFilterExpressionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessFilterExpressionList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessInListFilter: The result needs to be in a
// list of string values.
type GoogleAnalyticsAdminV1betaAccessInListFilter struct {
	// CaseSensitive: If true, the string value is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// Values: The list of string values. Must be non-empty.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessInListFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessInListFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessMetric: The quantitative measurements of a
// report. For example, the metric `accessCount` is the total number of data
// access records.
type GoogleAnalyticsAdminV1betaAccessMetric struct {
	// MetricName: The API name of the metric. See Data Access Schema
	// (https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of metrics supported in this API. Metrics are referenced by
	// name in `metricFilter` & `orderBys`.
	MetricName string `json:"metricName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessMetricHeader: Describes a metric column in
// the report. Visible metrics requested in a report produce column entries
// within rows and MetricHeaders. However, metrics used exclusively within
// filters or expressions do not produce columns in a report; correspondingly,
// those metrics do not produce headers.
type GoogleAnalyticsAdminV1betaAccessMetricHeader struct {
	// MetricName: The metric's name; for example 'accessCount'.
	MetricName string `json:"metricName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessMetricHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessMetricHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessMetricValue: The value of a metric.
type GoogleAnalyticsAdminV1betaAccessMetricValue struct {
	// Value: The measurement value. For example, this value may be '13'.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessMetricValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessNumericFilter: Filters for numeric or date
// values.
type GoogleAnalyticsAdminV1betaAccessNumericFilter struct {
	// Operation: The operation type for this filter.
	//
	// Possible values:
	//   "OPERATION_UNSPECIFIED" - Unspecified.
	//   "EQUAL" - Equal
	//   "LESS_THAN" - Less than
	//   "LESS_THAN_OR_EQUAL" - Less than or equal
	//   "GREATER_THAN" - Greater than
	//   "GREATER_THAN_OR_EQUAL" - Greater than or equal
	Operation string `json:"operation,omitempty"`
	// Value: A numeric value or a date value.
	Value *GoogleAnalyticsAdminV1betaNumericValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Operation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Operation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessNumericFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessNumericFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessOrderBy: Order bys define how rows will be
// sorted in the response. For example, ordering rows by descending access
// count is one ordering, and ordering rows by the country string is a
// different ordering.
type GoogleAnalyticsAdminV1betaAccessOrderBy struct {
	// Desc: If true, sorts by descending order. If false or unspecified, sorts in
	// ascending order.
	Desc bool `json:"desc,omitempty"`
	// Dimension: Sorts results by a dimension's values.
	Dimension *GoogleAnalyticsAdminV1betaAccessOrderByDimensionOrderBy `json:"dimension,omitempty"`
	// Metric: Sorts results by a metric's values.
	Metric *GoogleAnalyticsAdminV1betaAccessOrderByMetricOrderBy `json:"metric,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Desc") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Desc") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessOrderBy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessOrderByDimensionOrderBy: Sorts by dimension
// values.
type GoogleAnalyticsAdminV1betaAccessOrderByDimensionOrderBy struct {
	// DimensionName: A dimension name in the request to order by.
	DimensionName string `json:"dimensionName,omitempty"`
	// OrderType: Controls the rule for dimension value ordering.
	//
	// Possible values:
	//   "ORDER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALPHANUMERIC" - Alphanumeric sort by Unicode code point. For example, "2"
	// < "A" < "X" < "b" < "z".
	//   "CASE_INSENSITIVE_ALPHANUMERIC" - Case insensitive alphanumeric sort by
	// lower case Unicode code point. For example, "2" < "A" < "b" < "X" < "z".
	//   "NUMERIC" - Dimension values are converted to numbers before sorting. For
	// example in NUMERIC sort, "25" < "100", and in `ALPHANUMERIC` sort, "100" <
	// "25". Non-numeric dimension values all have equal ordering value below all
	// numeric values.
	OrderType string `json:"orderType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessOrderByDimensionOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessOrderByDimensionOrderBy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessOrderByMetricOrderBy: Sorts by metric
// values.
type GoogleAnalyticsAdminV1betaAccessOrderByMetricOrderBy struct {
	// MetricName: A metric name in the request to order by.
	MetricName string `json:"metricName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessOrderByMetricOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessOrderByMetricOrderBy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessQuota: Current state of all quotas for this
// Analytics property. If any quota for a property is exhausted, all requests
// to that property will return Resource Exhausted errors.
type GoogleAnalyticsAdminV1betaAccessQuota struct {
	// ConcurrentRequests: Properties can use up to 50 concurrent requests.
	ConcurrentRequests *GoogleAnalyticsAdminV1betaAccessQuotaStatus `json:"concurrentRequests,omitempty"`
	// ServerErrorsPerProjectPerHour: Properties and cloud project pairs can have
	// up to 50 server errors per hour.
	ServerErrorsPerProjectPerHour *GoogleAnalyticsAdminV1betaAccessQuotaStatus `json:"serverErrorsPerProjectPerHour,omitempty"`
	// TokensPerDay: Properties can use 250,000 tokens per day. Most requests
	// consume fewer than 10 tokens.
	TokensPerDay *GoogleAnalyticsAdminV1betaAccessQuotaStatus `json:"tokensPerDay,omitempty"`
	// TokensPerHour: Properties can use 50,000 tokens per hour. An API request
	// consumes a single number of tokens, and that number is deducted from all of
	// the hourly, daily, and per project hourly quotas.
	TokensPerHour *GoogleAnalyticsAdminV1betaAccessQuotaStatus `json:"tokensPerHour,omitempty"`
	// TokensPerProjectPerHour: Properties can use up to 25% of their tokens per
	// project per hour. This amounts to Analytics 360 Properties can use 12,500
	// tokens per project per hour. An API request consumes a single number of
	// tokens, and that number is deducted from all of the hourly, daily, and per
	// project hourly quotas.
	TokensPerProjectPerHour *GoogleAnalyticsAdminV1betaAccessQuotaStatus `json:"tokensPerProjectPerHour,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConcurrentRequests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConcurrentRequests") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessQuota) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessQuota
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessQuotaStatus: Current state for a particular
// quota group.
type GoogleAnalyticsAdminV1betaAccessQuotaStatus struct {
	// Consumed: Quota consumed by this request.
	Consumed int64 `json:"consumed,omitempty"`
	// Remaining: Quota remaining after this request.
	Remaining int64 `json:"remaining,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Consumed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consumed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessQuotaStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessQuotaStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessRow: Access report data for each row.
type GoogleAnalyticsAdminV1betaAccessRow struct {
	// DimensionValues: List of dimension values. These values are in the same
	// order as specified in the request.
	DimensionValues []*GoogleAnalyticsAdminV1betaAccessDimensionValue `json:"dimensionValues,omitempty"`
	// MetricValues: List of metric values. These values are in the same order as
	// specified in the request.
	MetricValues []*GoogleAnalyticsAdminV1betaAccessMetricValue `json:"metricValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DimensionValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccessStringFilter: The filter for strings.
type GoogleAnalyticsAdminV1betaAccessStringFilter struct {
	// CaseSensitive: If true, the string value is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// MatchType: The match type for this filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Unspecified
	//   "EXACT" - Exact match of the string value.
	//   "BEGINS_WITH" - Begins with the string value.
	//   "ENDS_WITH" - Ends with the string value.
	//   "CONTAINS" - Contains the string value.
	//   "FULL_REGEXP" - Full match for the regular expression with the string
	// value.
	//   "PARTIAL_REGEXP" - Partial match for the regular expression with the
	// string value.
	MatchType string `json:"matchType,omitempty"`
	// Value: The string value used for the matching.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccessStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccessStringFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccount: A resource message representing a Google
// Analytics account.
type GoogleAnalyticsAdminV1betaAccount struct {
	// CreateTime: Output only. Time when this account was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// Deleted: Output only. Indicates whether this Account is soft-deleted or not.
	// Deleted accounts are excluded from List results unless specifically
	// requested.
	Deleted bool `json:"deleted,omitempty"`
	// DisplayName: Required. Human-readable display name for this account.
	DisplayName string `json:"displayName,omitempty"`
	// GmpOrganization: Output only. The URI for a Google Marketing Platform
	// organization resource. Only set when this account is connected to a GMP
	// organization. Format:
	// marketingplatformadmin.googleapis.com/organizations/{org_id}
	GmpOrganization string `json:"gmpOrganization,omitempty"`
	// Name: Output only. Resource name of this account. Format: accounts/{account}
	// Example: "accounts/100"
	Name string `json:"name,omitempty"`
	// RegionCode: Country of business. Must be a Unicode CLDR region code.
	RegionCode string `json:"regionCode,omitempty"`
	// UpdateTime: Output only. Time when account payload fields were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAccountSummary: A virtual resource representing an
// overview of an account and all its child Google Analytics properties.
type GoogleAnalyticsAdminV1betaAccountSummary struct {
	// Account: Resource name of account referred to by this account summary
	// Format: accounts/{account_id} Example: "accounts/1000"
	Account string `json:"account,omitempty"`
	// DisplayName: Display name for the account referred to in this account
	// summary.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Resource name for this account summary. Format:
	// accountSummaries/{account_id} Example: "accountSummaries/1000"
	Name string `json:"name,omitempty"`
	// PropertySummaries: List of summaries for child accounts of this account.
	PropertySummaries []*GoogleAnalyticsAdminV1betaPropertySummary `json:"propertySummaries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAccountSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAccountSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest: Request
// message for AcknowledgeUserDataCollection RPC.
type GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest struct {
	// Acknowledgement: Required. An acknowledgement that the caller of this method
	// understands the terms of user data collection. This field must contain the
	// exact value: "I acknowledge that I have the necessary privacy disclosures
	// and rights from my end users for the collection and processing of their
	// data, including the association of such data with the visitation information
	// Google Analytics collects from my site and/or app property."
	Acknowledgement string `json:"acknowledgement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Acknowledgement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Acknowledgement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse: Response
// message for AcknowledgeUserDataCollection RPC.
type GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest: Request message for
// ArchiveCustomDimension RPC.
type GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest struct {
}

// GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest: Request message for
// ArchiveCustomMetric RPC.
type GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest struct {
}

// GoogleAnalyticsAdminV1betaChangeHistoryChange: A description of a change to
// a single Google Analytics resource.
type GoogleAnalyticsAdminV1betaChangeHistoryChange struct {
	// Action: The type of action that changed this resource.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action string `json:"action,omitempty"`
	// Resource: Resource name of the resource whose changes are described by this
	// entry.
	Resource string `json:"resource,omitempty"`
	// ResourceAfterChange: Resource contents from after the change was made. If
	// this resource was deleted in this change, this field will be missing.
	ResourceAfterChange *GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource `json:"resourceAfterChange,omitempty"`
	// ResourceBeforeChange: Resource contents from before the change was made. If
	// this resource was created in this change, this field will be missing.
	ResourceBeforeChange *GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource `json:"resourceBeforeChange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaChangeHistoryChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaChangeHistoryChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource: A
// snapshot of a resource as before or after the result of a change in change
// history.
type GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource struct {
	// Account: A snapshot of an Account resource in change history.
	Account *GoogleAnalyticsAdminV1betaAccount `json:"account,omitempty"`
	// ConversionEvent: A snapshot of a ConversionEvent resource in change history.
	ConversionEvent *GoogleAnalyticsAdminV1betaConversionEvent `json:"conversionEvent,omitempty"`
	// DataRetentionSettings: A snapshot of a data retention settings resource in
	// change history.
	DataRetentionSettings *GoogleAnalyticsAdminV1betaDataRetentionSettings `json:"dataRetentionSettings,omitempty"`
	// DataStream: A snapshot of a DataStream resource in change history.
	DataStream *GoogleAnalyticsAdminV1betaDataStream `json:"dataStream,omitempty"`
	// FirebaseLink: A snapshot of a FirebaseLink resource in change history.
	FirebaseLink *GoogleAnalyticsAdminV1betaFirebaseLink `json:"firebaseLink,omitempty"`
	// GoogleAdsLink: A snapshot of a GoogleAdsLink resource in change history.
	GoogleAdsLink *GoogleAnalyticsAdminV1betaGoogleAdsLink `json:"googleAdsLink,omitempty"`
	// MeasurementProtocolSecret: A snapshot of a MeasurementProtocolSecret
	// resource in change history.
	MeasurementProtocolSecret *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret `json:"measurementProtocolSecret,omitempty"`
	// Property: A snapshot of a Property resource in change history.
	Property *GoogleAnalyticsAdminV1betaProperty `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaChangeHistoryEvent: A set of changes within a
// Google Analytics account or its child properties that resulted from the same
// cause. Common causes would be updates made in the Google Analytics UI,
// changes from customer support, or automatic Google Analytics system changes.
type GoogleAnalyticsAdminV1betaChangeHistoryEvent struct {
	// ActorType: The type of actor that made this change.
	//
	// Possible values:
	//   "ACTOR_TYPE_UNSPECIFIED" - Unknown or unspecified actor type.
	//   "USER" - Changes made by the user specified in actor_email.
	//   "SYSTEM" - Changes made by the Google Analytics system.
	//   "SUPPORT" - Changes made by Google Analytics support team staff.
	ActorType string `json:"actorType,omitempty"`
	// ChangeTime: Time when change was made.
	ChangeTime string `json:"changeTime,omitempty"`
	// Changes: A list of changes made in this change history event that fit the
	// filters specified in SearchChangeHistoryEventsRequest.
	Changes []*GoogleAnalyticsAdminV1betaChangeHistoryChange `json:"changes,omitempty"`
	// ChangesFiltered: If true, then the list of changes returned was filtered,
	// and does not represent all changes that occurred in this event.
	ChangesFiltered bool `json:"changesFiltered,omitempty"`
	// Id: ID of this change history event. This ID is unique across Google
	// Analytics.
	Id string `json:"id,omitempty"`
	// UserActorEmail: Email address of the Google account that made the change.
	// This will be a valid email address if the actor field is set to USER, and
	// empty otherwise. Google accounts that have been deleted will cause an error.
	UserActorEmail string `json:"userActorEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActorType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActorType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaChangeHistoryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaChangeHistoryEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaConversionEvent: A conversion event in a Google
// Analytics property.
type GoogleAnalyticsAdminV1betaConversionEvent struct {
	// CountingMethod: Optional. The method by which conversions will be counted
	// across multiple events within a session. If this value is not provided, it
	// will be set to `ONCE_PER_EVENT`.
	//
	// Possible values:
	//   "CONVERSION_COUNTING_METHOD_UNSPECIFIED" - Counting method not specified.
	//   "ONCE_PER_EVENT" - Each Event instance is considered a Conversion.
	//   "ONCE_PER_SESSION" - An Event instance is considered a Conversion at most
	// once per session per user.
	CountingMethod string `json:"countingMethod,omitempty"`
	// CreateTime: Output only. Time when this conversion event was created in the
	// property.
	CreateTime string `json:"createTime,omitempty"`
	// Custom: Output only. If set to true, this conversion event refers to a
	// custom event. If set to false, this conversion event refers to a default
	// event in GA. Default events typically have special meaning in GA. Default
	// events are usually created for you by the GA system, but in some cases can
	// be created by property admins. Custom events count towards the maximum
	// number of custom conversion events that may be created per property.
	Custom bool `json:"custom,omitempty"`
	// DefaultConversionValue: Optional. Defines a default value/currency for a
	// conversion event.
	DefaultConversionValue *GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue `json:"defaultConversionValue,omitempty"`
	// Deletable: Output only. If set, this event can currently be deleted with
	// DeleteConversionEvent.
	Deletable bool `json:"deletable,omitempty"`
	// EventName: Immutable. The event name for this conversion event. Examples:
	// 'click', 'purchase'
	EventName string `json:"eventName,omitempty"`
	// Name: Output only. Resource name of this conversion event. Format:
	// properties/{property}/conversionEvents/{conversion_event}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CountingMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountingMethod") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaConversionEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaConversionEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue: Defines a
// default value/currency for a conversion event. Both value and currency must
// be provided.
type GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue struct {
	// CurrencyCode: When a conversion event for this event_name has no set
	// currency, this currency will be applied as the default. Must be in ISO 4217
	// currency code format. See https://en.wikipedia.org/wiki/ISO_4217 for more
	// information.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Value: This value will be used to populate the value for all conversions of
	// the specified event_name where the event "value" parameter is unset.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAnalyticsAdminV1betaConversionEventDefaultConversionValue
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleAnalyticsAdminV1betaCustomDimension: A definition for a
// CustomDimension.
type GoogleAnalyticsAdminV1betaCustomDimension struct {
	// Description: Optional. Description for this custom dimension. Max length of
	// 150 characters.
	Description string `json:"description,omitempty"`
	// DisallowAdsPersonalization: Optional. If set to true, sets this dimension as
	// NPA and excludes it from ads personalization. This is currently only
	// supported by user-scoped custom dimensions.
	DisallowAdsPersonalization bool `json:"disallowAdsPersonalization,omitempty"`
	// DisplayName: Required. Display name for this custom dimension as shown in
	// the Analytics UI. Max length of 82 characters, alphanumeric plus space and
	// underscore starting with a letter. Legacy system-generated display names may
	// contain square brackets, but updates to this field will never permit square
	// brackets.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Resource name for this CustomDimension resource. Format:
	// properties/{property}/customDimensions/{customDimension}
	Name string `json:"name,omitempty"`
	// ParameterName: Required. Immutable. Tagging parameter name for this custom
	// dimension. If this is a user-scoped dimension, then this is the user
	// property name. If this is an event-scoped dimension, then this is the event
	// parameter name. If this is an item-scoped dimension, then this is the
	// parameter name found in the eCommerce items array. May only contain
	// alphanumeric and underscore characters, starting with a letter. Max length
	// of 24 characters for user-scoped dimensions, 40 characters for event-scoped
	// dimensions.
	ParameterName string `json:"parameterName,omitempty"`
	// Scope: Required. Immutable. The scope of this dimension.
	//
	// Possible values:
	//   "DIMENSION_SCOPE_UNSPECIFIED" - Scope unknown or not specified.
	//   "EVENT" - Dimension scoped to an event.
	//   "USER" - Dimension scoped to a user.
	//   "ITEM" - Dimension scoped to eCommerce items
	Scope string `json:"scope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaCustomDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaCustomDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaCustomMetric: A definition for a custom metric.
type GoogleAnalyticsAdminV1betaCustomMetric struct {
	// Description: Optional. Description for this custom dimension. Max length of
	// 150 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name for this custom metric as shown in the
	// Analytics UI. Max length of 82 characters, alphanumeric plus space and
	// underscore starting with a letter. Legacy system-generated display names may
	// contain square brackets, but updates to this field will never permit square
	// brackets.
	DisplayName string `json:"displayName,omitempty"`
	// MeasurementUnit: Required. The type for the custom metric's value.
	//
	// Possible values:
	//   "MEASUREMENT_UNIT_UNSPECIFIED" - MeasurementUnit unspecified or missing.
	//   "STANDARD" - This metric uses default units.
	//   "CURRENCY" - This metric measures a currency.
	//   "FEET" - This metric measures feet.
	//   "METERS" - This metric measures meters.
	//   "KILOMETERS" - This metric measures kilometers.
	//   "MILES" - This metric measures miles.
	//   "MILLISECONDS" - This metric measures milliseconds.
	//   "SECONDS" - This metric measures seconds.
	//   "MINUTES" - This metric measures minutes.
	//   "HOURS" - This metric measures hours.
	MeasurementUnit string `json:"measurementUnit,omitempty"`
	// Name: Output only. Resource name for this CustomMetric resource. Format:
	// properties/{property}/customMetrics/{customMetric}
	Name string `json:"name,omitempty"`
	// ParameterName: Required. Immutable. Tagging name for this custom metric. If
	// this is an event-scoped metric, then this is the event parameter name. May
	// only contain alphanumeric and underscore charactes, starting with a letter.
	// Max length of 40 characters for event-scoped metrics.
	ParameterName string `json:"parameterName,omitempty"`
	// RestrictedMetricType: Optional. Types of restricted data that this metric
	// may contain. Required for metrics with CURRENCY measurement unit. Must be
	// empty for metrics with a non-CURRENCY measurement unit.
	//
	// Possible values:
	//   "RESTRICTED_METRIC_TYPE_UNSPECIFIED" - Type unknown or unspecified.
	//   "COST_DATA" - Metric reports cost data.
	//   "REVENUE_DATA" - Metric reports revenue data.
	RestrictedMetricType []string `json:"restrictedMetricType,omitempty"`
	// Scope: Required. Immutable. The scope of this custom metric.
	//
	// Possible values:
	//   "METRIC_SCOPE_UNSPECIFIED" - Scope unknown or not specified.
	//   "EVENT" - Metric scoped to an event.
	Scope string `json:"scope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaCustomMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaCustomMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataRetentionSettings: Settings values for data
// retention. This is a singleton resource.
type GoogleAnalyticsAdminV1betaDataRetentionSettings struct {
	// EventDataRetention: The length of time that event-level data is retained.
	//
	// Possible values:
	//   "RETENTION_DURATION_UNSPECIFIED" - Data retention time duration is not
	// specified.
	//   "TWO_MONTHS" - The data retention time duration is 2 months.
	//   "FOURTEEN_MONTHS" - The data retention time duration is 14 months.
	//   "TWENTY_SIX_MONTHS" - The data retention time duration is 26 months.
	// Available to 360 properties only.
	//   "THIRTY_EIGHT_MONTHS" - The data retention time duration is 38 months.
	// Available to 360 properties only.
	//   "FIFTY_MONTHS" - The data retention time duration is 50 months. Available
	// to 360 properties only.
	EventDataRetention string `json:"eventDataRetention,omitempty"`
	// Name: Output only. Resource name for this DataRetentionSetting resource.
	// Format: properties/{property}/dataRetentionSettings
	Name string `json:"name,omitempty"`
	// ResetUserDataOnNewActivity: If true, reset the retention period for the user
	// identifier with every event from that user.
	ResetUserDataOnNewActivity bool `json:"resetUserDataOnNewActivity,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EventDataRetention") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventDataRetention") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataRetentionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataRetentionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataSharingSettings: A resource message
// representing data sharing settings of a Google Analytics account.
type GoogleAnalyticsAdminV1betaDataSharingSettings struct {
	// Name: Output only. Resource name. Format:
	// accounts/{account}/dataSharingSettings Example:
	// "accounts/1000/dataSharingSettings"
	Name string `json:"name,omitempty"`
	// SharingWithGoogleAnySalesEnabled: Allows any of Google sales to access the
	// data in order to suggest configuration changes to improve results.
	SharingWithGoogleAnySalesEnabled bool `json:"sharingWithGoogleAnySalesEnabled,omitempty"`
	// SharingWithGoogleAssignedSalesEnabled: Allows Google sales teams that are
	// assigned to the customer to access the data in order to suggest
	// configuration changes to improve results. Sales team restrictions still
	// apply when enabled.
	SharingWithGoogleAssignedSalesEnabled bool `json:"sharingWithGoogleAssignedSalesEnabled,omitempty"`
	// SharingWithGoogleProductsEnabled: Allows Google to use the data to improve
	// other Google products or services.
	SharingWithGoogleProductsEnabled bool `json:"sharingWithGoogleProductsEnabled,omitempty"`
	// SharingWithGoogleSupportEnabled: Allows Google support to access the data in
	// order to help troubleshoot issues.
	SharingWithGoogleSupportEnabled bool `json:"sharingWithGoogleSupportEnabled,omitempty"`
	// SharingWithOthersEnabled: Allows Google to share the data anonymously in
	// aggregate form with others.
	SharingWithOthersEnabled bool `json:"sharingWithOthersEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataSharingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataSharingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataStream: A resource message representing a data
// stream.
type GoogleAnalyticsAdminV1betaDataStream struct {
	// AndroidAppStreamData: Data specific to Android app streams. Must be
	// populated if type is ANDROID_APP_DATA_STREAM.
	AndroidAppStreamData *GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData `json:"androidAppStreamData,omitempty"`
	// CreateTime: Output only. Time when this stream was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Human-readable display name for the Data Stream. Required for
	// web data streams. The max allowed display name length is 255 UTF-16 code
	// units.
	DisplayName string `json:"displayName,omitempty"`
	// IosAppStreamData: Data specific to iOS app streams. Must be populated if
	// type is IOS_APP_DATA_STREAM.
	IosAppStreamData *GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData `json:"iosAppStreamData,omitempty"`
	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/dataStreams/{stream_id} Example:
	// "properties/1000/dataStreams/2000"
	Name string `json:"name,omitempty"`
	// Type: Required. Immutable. The type of this DataStream resource.
	//
	// Possible values:
	//   "DATA_STREAM_TYPE_UNSPECIFIED" - Type unknown or not specified.
	//   "WEB_DATA_STREAM" - Web data stream.
	//   "ANDROID_APP_DATA_STREAM" - Android app data stream.
	//   "IOS_APP_DATA_STREAM" - iOS app data stream.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Time when stream payload fields were last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WebStreamData: Data specific to web streams. Must be populated if type is
	// WEB_DATA_STREAM.
	WebStreamData *GoogleAnalyticsAdminV1betaDataStreamWebStreamData `json:"webStreamData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AndroidAppStreamData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidAppStreamData") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataStream) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataStream
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData: Data specific to
// Android app streams.
type GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData struct {
	// FirebaseAppId: Output only. ID of the corresponding Android app in Firebase,
	// if any. This ID can change if the Android app is deleted and recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`
	// PackageName: Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `json:"packageName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirebaseAppId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirebaseAppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataStreamAndroidAppStreamData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData: Data specific to iOS
// app streams.
type GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData struct {
	// BundleId: Required. Immutable. The Apple App Store Bundle ID for the app
	// Example: "com.example.myiosapp"
	BundleId string `json:"bundleId,omitempty"`
	// FirebaseAppId: Output only. ID of the corresponding iOS app in Firebase, if
	// any. This ID can change if the iOS app is deleted and recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BundleId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BundleId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataStreamIosAppStreamData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaDataStreamWebStreamData: Data specific to web
// streams.
type GoogleAnalyticsAdminV1betaDataStreamWebStreamData struct {
	// DefaultUri: Domain name of the web app being measured, or empty. Example:
	// "http://www.google.com", "https://www.google.com"
	DefaultUri string `json:"defaultUri,omitempty"`
	// FirebaseAppId: Output only. ID of the corresponding web app in Firebase, if
	// any. This ID can change if the web app is deleted and recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`
	// MeasurementId: Output only. Analytics Measurement ID. Example:
	// "G-1A2BCD345E"
	MeasurementId string `json:"measurementId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaDataStreamWebStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaDataStreamWebStreamData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaFirebaseLink: A link between a Google Analytics
// property and a Firebase project.
type GoogleAnalyticsAdminV1betaFirebaseLink struct {
	// CreateTime: Output only. Time when this FirebaseLink was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `json:"name,omitempty"`
	// Project: Immutable. Firebase project resource name. When creating a
	// FirebaseLink, you may provide this resource name using either a project
	// number or project ID. Once this resource has been created, returned
	// FirebaseLinks will always have a project_name that contains a project
	// number. Format: 'projects/{project number}' Example: 'projects/1234'
	Project string `json:"project,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaFirebaseLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaFirebaseLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaGoogleAdsLink: A link between a Google Analytics
// property and a Google Ads account.
type GoogleAnalyticsAdminV1betaGoogleAdsLink struct {
	// AdsPersonalizationEnabled: Enable personalized advertising features with
	// this integration. Automatically publish my Google Analytics audience lists
	// and Google Analytics remarketing events/parameters to the linked Google Ads
	// account. If this field is not set on create/update, it will be defaulted to
	// true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`
	// CanManageClients: Output only. If true, this link is for a Google Ads
	// manager account.
	CanManageClients bool `json:"canManageClients,omitempty"`
	// CreateTime: Output only. Time when this link was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// CreatorEmailAddress: Output only. Email address of the user that created the
	// link. An empty string will be returned if the email address can't be
	// retrieved.
	CreatorEmailAddress string `json:"creatorEmailAddress,omitempty"`
	// CustomerId: Immutable. Google Ads customer ID.
	CustomerId string `json:"customerId,omitempty"`
	// Name: Output only. Format:
	// properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
	// googleAdsLinkId is not the Google Ads customer ID.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Time when this link was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdsPersonalizationEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdsPersonalizationEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaGoogleAdsLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaGoogleAdsLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaKeyEvent: A key event in a Google Analytics
// property.
type GoogleAnalyticsAdminV1betaKeyEvent struct {
	// CountingMethod: Required. The method by which Key Events will be counted
	// across multiple events within a session.
	//
	// Possible values:
	//   "COUNTING_METHOD_UNSPECIFIED" - Counting method not specified.
	//   "ONCE_PER_EVENT" - Each Event instance is considered a Key Event.
	//   "ONCE_PER_SESSION" - An Event instance is considered a Key Event at most
	// once per session per user.
	CountingMethod string `json:"countingMethod,omitempty"`
	// CreateTime: Output only. Time when this key event was created in the
	// property.
	CreateTime string `json:"createTime,omitempty"`
	// Custom: Output only. If set to true, this key event refers to a custom
	// event. If set to false, this key event refers to a default event in GA.
	// Default events typically have special meaning in GA. Default events are
	// usually created for you by the GA system, but in some cases can be created
	// by property admins. Custom events count towards the maximum number of custom
	// key events that may be created per property.
	Custom bool `json:"custom,omitempty"`
	// DefaultValue: Optional. Defines a default value/currency for a key event.
	DefaultValue *GoogleAnalyticsAdminV1betaKeyEventDefaultValue `json:"defaultValue,omitempty"`
	// Deletable: Output only. If set to true, this event can be deleted.
	Deletable bool `json:"deletable,omitempty"`
	// EventName: Immutable. The event name for this key event. Examples: 'click',
	// 'purchase'
	EventName string `json:"eventName,omitempty"`
	// Name: Output only. Resource name of this key event. Format:
	// properties/{property}/keyEvents/{key_event}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CountingMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountingMethod") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaKeyEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaKeyEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaKeyEventDefaultValue: Defines a default
// value/currency for a key event.
type GoogleAnalyticsAdminV1betaKeyEventDefaultValue struct {
	// CurrencyCode: Required. When an occurrence of this Key Event (specified by
	// event_name) has no set currency this currency will be applied as the
	// default. Must be in ISO 4217 currency code format. See
	// https://en.wikipedia.org/wiki/ISO_4217 for more information.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// NumericValue: Required. This will be used to populate the "value" parameter
	// for all occurrences of this Key Event (specified by event_name) where that
	// parameter is unset.
	NumericValue float64 `json:"numericValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaKeyEventDefaultValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaKeyEventDefaultValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleAnalyticsAdminV1betaKeyEventDefaultValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAnalyticsAdminV1betaKeyEventDefaultValue
	var s1 struct {
		NumericValue gensupport.JSONFloat64 `json:"numericValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumericValue = float64(s1.NumericValue)
	return nil
}

// GoogleAnalyticsAdminV1betaListAccountSummariesResponse: Response message for
// ListAccountSummaries RPC.
type GoogleAnalyticsAdminV1betaListAccountSummariesResponse struct {
	// AccountSummaries: Account summaries of all accounts the caller has access
	// to.
	AccountSummaries []*GoogleAnalyticsAdminV1betaAccountSummary `json:"accountSummaries,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountSummaries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountSummaries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListAccountSummariesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListAccountSummariesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListAccountsResponse: Request message for
// ListAccounts RPC.
type GoogleAnalyticsAdminV1betaListAccountsResponse struct {
	// Accounts: Results that were accessible to the caller.
	Accounts []*GoogleAnalyticsAdminV1betaAccount `json:"accounts,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accounts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListAccountsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListConversionEventsResponse: Response message for
// ListConversionEvents RPC.
type GoogleAnalyticsAdminV1betaListConversionEventsResponse struct {
	// ConversionEvents: The requested conversion events
	ConversionEvents []*GoogleAnalyticsAdminV1betaConversionEvent `json:"conversionEvents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversionEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionEvents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListConversionEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListConversionEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListCustomDimensionsResponse: Response message for
// ListCustomDimensions RPC.
type GoogleAnalyticsAdminV1betaListCustomDimensionsResponse struct {
	// CustomDimensions: List of CustomDimensions.
	CustomDimensions []*GoogleAnalyticsAdminV1betaCustomDimension `json:"customDimensions,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomDimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomDimensions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListCustomDimensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListCustomDimensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListCustomMetricsResponse: Response message for
// ListCustomMetrics RPC.
type GoogleAnalyticsAdminV1betaListCustomMetricsResponse struct {
	// CustomMetrics: List of CustomMetrics.
	CustomMetrics []*GoogleAnalyticsAdminV1betaCustomMetric `json:"customMetrics,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomMetrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListCustomMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListCustomMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListDataStreamsResponse: Response message for
// ListDataStreams RPC.
type GoogleAnalyticsAdminV1betaListDataStreamsResponse struct {
	// DataStreams: List of DataStreams.
	DataStreams []*GoogleAnalyticsAdminV1betaDataStream `json:"dataStreams,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataStreams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStreams") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListDataStreamsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListDataStreamsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListFirebaseLinksResponse: Response message for
// ListFirebaseLinks RPC
type GoogleAnalyticsAdminV1betaListFirebaseLinksResponse struct {
	// FirebaseLinks: List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*GoogleAnalyticsAdminV1betaFirebaseLink `json:"firebaseLinks,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one FirebaseLink per property, so
	// this will never be populated.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FirebaseLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirebaseLinks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListFirebaseLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListFirebaseLinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse: Response message for
// ListGoogleAdsLinks RPC.
type GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse struct {
	// GoogleAdsLinks: List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAnalyticsAdminV1betaGoogleAdsLink `json:"googleAdsLinks,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GoogleAdsLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleAdsLinks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListKeyEventsResponse: Response message for
// ListKeyEvents RPC.
type GoogleAnalyticsAdminV1betaListKeyEventsResponse struct {
	// KeyEvents: The requested Key Events
	KeyEvents []*GoogleAnalyticsAdminV1betaKeyEvent `json:"keyEvents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KeyEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeyEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListKeyEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListKeyEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse: Response
// message for ListMeasurementProtocolSecret RPC
type GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse struct {
	// MeasurementProtocolSecrets: A list of secrets for the parent stream
	// specified in the request.
	MeasurementProtocolSecrets []*GoogleAnalyticsAdminV1betaMeasurementProtocolSecret `json:"measurementProtocolSecrets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MeasurementProtocolSecrets")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MeasurementProtocolSecrets") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaListPropertiesResponse: Response message for
// ListProperties RPC.
type GoogleAnalyticsAdminV1betaListPropertiesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Properties: Results that matched the filter criteria and were accessible to
	// the caller.
	Properties []*GoogleAnalyticsAdminV1betaProperty `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaListPropertiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaListPropertiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaMeasurementProtocolSecret: A secret value used for
// sending hits to Measurement Protocol.
type GoogleAnalyticsAdminV1betaMeasurementProtocolSecret struct {
	// DisplayName: Required. Human-readable display name for this secret.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Resource name of this secret. This secret may be a child
	// of any type of stream. Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{me
	// asurementProtocolSecret}
	Name string `json:"name,omitempty"`
	// SecretValue: Output only. The measurement protocol secret value. Pass this
	// value to the api_secret field of the Measurement Protocol API when sending
	// hits to this secret's parent property.
	SecretValue string `json:"secretValue,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaMeasurementProtocolSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaMeasurementProtocolSecret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaNumericValue: To represent a number.
type GoogleAnalyticsAdminV1betaNumericValue struct {
	// DoubleValue: Double value
	DoubleValue float64 `json:"doubleValue,omitempty"`
	// Int64Value: Integer value
	Int64Value int64 `json:"int64Value,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DoubleValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoubleValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaNumericValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaNumericValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleAnalyticsAdminV1betaNumericValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAnalyticsAdminV1betaNumericValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleAnalyticsAdminV1betaProperty: A resource message representing a Google
// Analytics property.
type GoogleAnalyticsAdminV1betaProperty struct {
	// Account: Immutable. The resource name of the parent account Format:
	// accounts/{account_id} Example: "accounts/123"
	Account string `json:"account,omitempty"`
	// CreateTime: Output only. Time when the entity was originally created.
	CreateTime string `json:"createTime,omitempty"`
	// CurrencyCode: The currency type used in reports involving monetary values.
	// Format: https://en.wikipedia.org/wiki/ISO_4217 Examples: "USD", "EUR", "JPY"
	CurrencyCode string `json:"currencyCode,omitempty"`
	// DeleteTime: Output only. If set, the time at which this property was
	// trashed. If not set, then this property is not currently in the trash can.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: Required. Human-readable display name for this property. The
	// max allowed display name length is 100 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`
	// ExpireTime: Output only. If set, the time at which this trashed property
	// will be permanently deleted. If not set, then this property is not currently
	// in the trash can and is not slated to be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// IndustryCategory: Industry associated with this property Example:
	// AUTOMOTIVE, FOOD_AND_DRINK
	//
	// Possible values:
	//   "INDUSTRY_CATEGORY_UNSPECIFIED" - Industry category unspecified
	//   "AUTOMOTIVE" - Automotive
	//   "BUSINESS_AND_INDUSTRIAL_MARKETS" - Business and industrial markets
	//   "FINANCE" - Finance
	//   "HEALTHCARE" - Healthcare
	//   "TECHNOLOGY" - Technology
	//   "TRAVEL" - Travel
	//   "OTHER" - Other
	//   "ARTS_AND_ENTERTAINMENT" - Arts and entertainment
	//   "BEAUTY_AND_FITNESS" - Beauty and fitness
	//   "BOOKS_AND_LITERATURE" - Books and literature
	//   "FOOD_AND_DRINK" - Food and drink
	//   "GAMES" - Games
	//   "HOBBIES_AND_LEISURE" - Hobbies and leisure
	//   "HOME_AND_GARDEN" - Home and garden
	//   "INTERNET_AND_TELECOM" - Internet and telecom
	//   "LAW_AND_GOVERNMENT" - Law and government
	//   "NEWS" - News
	//   "ONLINE_COMMUNITIES" - Online communities
	//   "PEOPLE_AND_SOCIETY" - People and society
	//   "PETS_AND_ANIMALS" - Pets and animals
	//   "REAL_ESTATE" - Real estate
	//   "REFERENCE" - Reference
	//   "SCIENCE" - Science
	//   "SPORTS" - Sports
	//   "JOBS_AND_EDUCATION" - Jobs and education
	//   "SHOPPING" - Shopping
	IndustryCategory string `json:"industryCategory,omitempty"`
	// Name: Output only. Resource name of this property. Format:
	// properties/{property_id} Example: "properties/1000"
	Name string `json:"name,omitempty"`
	// Parent: Immutable. Resource name of this property's logical parent. Note:
	// The Property-Moving UI can be used to change the parent. Format:
	// accounts/{account}, properties/{property} Example: "accounts/100",
	// "properties/101"
	Parent string `json:"parent,omitempty"`
	// PropertyType: Immutable. The property type for this Property resource. When
	// creating a property, if the type is "PROPERTY_TYPE_UNSPECIFIED", then
	// "ORDINARY_PROPERTY" will be implied.
	//
	// Possible values:
	//   "PROPERTY_TYPE_UNSPECIFIED" - Unknown or unspecified property type
	//   "PROPERTY_TYPE_ORDINARY" - Ordinary Google Analytics property
	//   "PROPERTY_TYPE_SUBPROPERTY" - Google Analytics subproperty
	//   "PROPERTY_TYPE_ROLLUP" - Google Analytics rollup property
	PropertyType string `json:"propertyType,omitempty"`
	// ServiceLevel: Output only. The Google Analytics service level that applies
	// to this property.
	//
	// Possible values:
	//   "SERVICE_LEVEL_UNSPECIFIED" - Service level not specified or invalid.
	//   "GOOGLE_ANALYTICS_STANDARD" - The standard version of Google Analytics.
	//   "GOOGLE_ANALYTICS_360" - The paid, premium version of Google Analytics.
	ServiceLevel string `json:"serviceLevel,omitempty"`
	// TimeZone: Required. Reporting Time Zone, used as the day boundary for
	// reports, regardless of where the data originates. If the time zone honors
	// DST, Analytics will automatically adjust for the changes. NOTE: Changing the
	// time zone only affects data going forward, and is not applied retroactively.
	// Format: https://www.iana.org/time-zones Example: "America/Los_Angeles"
	TimeZone string `json:"timeZone,omitempty"`
	// UpdateTime: Output only. Time when entity payload fields were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaPropertySummary: A virtual resource representing
// metadata for a Google Analytics property.
type GoogleAnalyticsAdminV1betaPropertySummary struct {
	// DisplayName: Display name for the property referred to in this property
	// summary.
	DisplayName string `json:"displayName,omitempty"`
	// Parent: Resource name of this property's logical parent. Note: The
	// Property-Moving UI can be used to change the parent. Format:
	// accounts/{account}, properties/{property} Example: "accounts/100",
	// "properties/200"
	Parent string `json:"parent,omitempty"`
	// Property: Resource name of property referred to by this property summary
	// Format: properties/{property_id} Example: "properties/1000"
	Property string `json:"property,omitempty"`
	// PropertyType: The property's property type.
	//
	// Possible values:
	//   "PROPERTY_TYPE_UNSPECIFIED" - Unknown or unspecified property type
	//   "PROPERTY_TYPE_ORDINARY" - Ordinary Google Analytics property
	//   "PROPERTY_TYPE_SUBPROPERTY" - Google Analytics subproperty
	//   "PROPERTY_TYPE_ROLLUP" - Google Analytics rollup property
	PropertyType string `json:"propertyType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaPropertySummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaPropertySummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest: Request message for
// ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest struct {
	// Account: The account to create.
	Account *GoogleAnalyticsAdminV1betaAccount `json:"account,omitempty"`
	// RedirectUri: Redirect URI where the user will be sent after accepting Terms
	// of Service. Must be configured in Cloud Console as a Redirect URI.
	RedirectUri string `json:"redirectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse: Response message
// for ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse struct {
	// AccountTicketId: The param to be passed in the ToS link.
	AccountTicketId string `json:"accountTicketId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountTicketId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountTicketId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaRunAccessReportRequest: The request for a Data
// Access Record Report.
type GoogleAnalyticsAdminV1betaRunAccessReportRequest struct {
	// DateRanges: Date ranges of access records to read. If multiple date ranges
	// are requested, each response row will contain a zero based date range index.
	// If two date ranges overlap, the access records for the overlapping days is
	// included in the response rows for both date ranges. Requests are allowed up
	// to 2 date ranges.
	DateRanges []*GoogleAnalyticsAdminV1betaAccessDateRange `json:"dateRanges,omitempty"`
	// DimensionFilter: Dimension filters let you restrict report response to
	// specific dimension values which match the filter. For example, filtering on
	// access records of a single user. To learn more, see Fundamentals of
	// Dimension Filters
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
	// for examples. Metrics cannot be used in this filter.
	DimensionFilter *GoogleAnalyticsAdminV1betaAccessFilterExpression `json:"dimensionFilter,omitempty"`
	// Dimensions: The dimensions requested and displayed in the response. Requests
	// are allowed up to 9 dimensions.
	Dimensions []*GoogleAnalyticsAdminV1betaAccessDimension `json:"dimensions,omitempty"`
	// ExpandGroups: Optional. Decides whether to return the users within user
	// groups. This field works only when include_all_users is set to true. If
	// true, it will return all users with access to the specified property or
	// account. If false, only the users with direct access will be returned.
	ExpandGroups bool `json:"expandGroups,omitempty"`
	// IncludeAllUsers: Optional. Determines whether to include users who have
	// never made an API call in the response. If true, all users with access to
	// the specified property or account are included in the response, regardless
	// of whether they have made an API call or not. If false, only the users who
	// have made an API call will be included.
	IncludeAllUsers bool `json:"includeAllUsers,omitempty"`
	// Limit: The number of rows to return. If unspecified, 10,000 rows are
	// returned. The API returns a maximum of 100,000 rows per request, no matter
	// how many you ask for. `limit` must be positive. The API may return fewer
	// rows than the requested `limit`, if there aren't as many remaining rows as
	// the `limit`. For instance, there are fewer than 300 possible values for the
	// dimension `country`, so when reporting on only `country`, you can't get more
	// than 300 rows, even if you set `limit` to a higher value. To learn more
	// about this pagination parameter, see Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Limit int64 `json:"limit,omitempty,string"`
	// MetricFilter: Metric filters allow you to restrict report response to
	// specific metric values which match the filter. Metric filters are applied
	// after aggregating the report's rows, similar to SQL having-clause.
	// Dimensions cannot be used in this filter.
	MetricFilter *GoogleAnalyticsAdminV1betaAccessFilterExpression `json:"metricFilter,omitempty"`
	// Metrics: The metrics requested and displayed in the response. Requests are
	// allowed up to 10 metrics.
	Metrics []*GoogleAnalyticsAdminV1betaAccessMetric `json:"metrics,omitempty"`
	// Offset: The row count of the start row. The first row is counted as row 0.
	// If offset is unspecified, it is treated as 0. If offset is zero, then this
	// method will return the first page of results with `limit` entries. To learn
	// more about this pagination parameter, see Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Offset int64 `json:"offset,omitempty,string"`
	// OrderBys: Specifies how rows are ordered in the response.
	OrderBys []*GoogleAnalyticsAdminV1betaAccessOrderBy `json:"orderBys,omitempty"`
	// ReturnEntityQuota: Toggles whether to return the current state of this
	// Analytics Property's quota. Quota is returned in AccessQuota (#AccessQuota).
	// For account-level requests, this field must be false.
	ReturnEntityQuota bool `json:"returnEntityQuota,omitempty"`
	// TimeZone: This request's time zone if specified. If unspecified, the
	// property's time zone is used. The request's time zone is used to interpret
	// the start & end dates of the report. Formatted as strings from the IANA Time
	// Zone database (https://www.iana.org/time-zones); for example
	// "America/New_York" or "Asia/Tokyo".
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateRanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateRanges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaRunAccessReportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaRunAccessReportRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaRunAccessReportResponse: The customized Data
// Access Record Report response.
type GoogleAnalyticsAdminV1betaRunAccessReportResponse struct {
	// DimensionHeaders: The header for a column in the report that corresponds to
	// a specific dimension. The number of DimensionHeaders and ordering of
	// DimensionHeaders matches the dimensions present in rows.
	DimensionHeaders []*GoogleAnalyticsAdminV1betaAccessDimensionHeader `json:"dimensionHeaders,omitempty"`
	// MetricHeaders: The header for a column in the report that corresponds to a
	// specific metric. The number of MetricHeaders and ordering of MetricHeaders
	// matches the metrics present in rows.
	MetricHeaders []*GoogleAnalyticsAdminV1betaAccessMetricHeader `json:"metricHeaders,omitempty"`
	// Quota: The quota state for this Analytics property including this request.
	// This field doesn't work with account-level requests.
	Quota *GoogleAnalyticsAdminV1betaAccessQuota `json:"quota,omitempty"`
	// RowCount: The total number of rows in the query result. `rowCount` is
	// independent of the number of rows returned in the response, the `limit`
	// request parameter, and the `offset` request parameter. For example if a
	// query returns 175 rows and includes `limit` of 50 in the API request, the
	// response will contain `rowCount` of 175 but only 50 rows. To learn more
	// about this pagination parameter, see Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	RowCount int64 `json:"rowCount,omitempty"`
	// Rows: Rows of dimension value combinations and metric values in the report.
	Rows []*GoogleAnalyticsAdminV1betaAccessRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DimensionHeaders") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionHeaders") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaRunAccessReportResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaRunAccessReportResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest: Request message
// for SearchChangeHistoryEvents RPC.
type GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest struct {
	// Action: Optional. If set, only return changes that match one or more of
	// these types of actions.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action []string `json:"action,omitempty"`
	// ActorEmail: Optional. If set, only return changes if they are made by a user
	// in this list.
	ActorEmail []string `json:"actorEmail,omitempty"`
	// EarliestChangeTime: Optional. If set, only return changes made after this
	// time (inclusive).
	EarliestChangeTime string `json:"earliestChangeTime,omitempty"`
	// LatestChangeTime: Optional. If set, only return changes made before this
	// time (inclusive).
	LatestChangeTime string `json:"latestChangeTime,omitempty"`
	// PageSize: Optional. The maximum number of ChangeHistoryEvent items to
	// return. The service may return fewer than this value, even if there are
	// additional pages. If unspecified, at most 50 items will be returned. The
	// maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. A page token, received from a previous
	// `SearchChangeHistoryEvents` call. Provide this to retrieve the subsequent
	// page. When paginating, all other parameters provided to
	// `SearchChangeHistoryEvents` must match the call that provided the page
	// token.
	PageToken string `json:"pageToken,omitempty"`
	// Property: Optional. Resource name for a child property. If set, only return
	// changes made to this property or its child resources. Format:
	// properties/{propertyId} Example: `properties/100`
	Property string `json:"property,omitempty"`
	// ResourceType: Optional. If set, only return changes if they are for a
	// resource that matches at least one of these types.
	//
	// Possible values:
	//   "CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED" - Resource type unknown or not
	// specified.
	//   "ACCOUNT" - Account resource
	//   "PROPERTY" - Property resource
	//   "FIREBASE_LINK" - FirebaseLink resource
	//   "GOOGLE_ADS_LINK" - GoogleAdsLink resource
	//   "GOOGLE_SIGNALS_SETTINGS" - GoogleSignalsSettings resource
	//   "CONVERSION_EVENT" - ConversionEvent resource
	//   "MEASUREMENT_PROTOCOL_SECRET" - MeasurementProtocolSecret resource
	//   "CUSTOM_DIMENSION" - CustomDimension resource
	//   "CUSTOM_METRIC" - CustomMetric resource
	//   "DATA_RETENTION_SETTINGS" - DataRetentionSettings resource
	//   "DISPLAY_VIDEO_360_ADVERTISER_LINK" - DisplayVideo360AdvertiserLink
	// resource
	//   "DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL" -
	// DisplayVideo360AdvertiserLinkProposal resource
	//   "DATA_STREAM" - DataStream resource
	//   "ATTRIBUTION_SETTINGS" - AttributionSettings resource
	ResourceType []string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse: Response
// message for SearchAccounts RPC.
type GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse struct {
	// ChangeHistoryEvents: Results that were accessible to the caller.
	ChangeHistoryEvents []*GoogleAnalyticsAdminV1betaChangeHistoryEvent `json:"changeHistoryEvents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChangeHistoryEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangeHistoryEvents") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type AccountSummariesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns summaries of all accounts accessible by the caller.
func (r *AccountSummariesService) List() *AccountSummariesListCall {
	c := &AccountSummariesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// AccountSummary resources to return. The service may return fewer than this
// value, even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values will be
// coerced to the maximum)
func (c *AccountSummariesListCall) PageSize(pageSize int64) *AccountSummariesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAccountSummaries` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAccountSummaries` must match the call that provided the page token.
func (c *AccountSummariesListCall) PageToken(pageToken string) *AccountSummariesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountSummariesListCall) Fields(s ...googleapi.Field) *AccountSummariesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountSummariesListCall) IfNoneMatch(entityTag string) *AccountSummariesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountSummariesListCall) Context(ctx context.Context) *AccountSummariesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountSummariesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountSummariesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/accountSummaries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accountSummaries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accountSummaries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListAccountSummariesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountSummariesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListAccountSummariesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListAccountSummariesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accountSummaries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountSummariesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListAccountSummariesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Account as soft-deleted (ie: "trashed") and returns it.
// This API does not have a method to restore soft-deleted accounts. However,
// they can be restored using the Trash Can UI. If the accounts are not
// restored before the expiration time, the account and all child resources
// (eg: Properties, GoogleAdsLinks, Streams, AccessBindings) will be
// permanently purged. https://support.google.com/analytics/answer/6154772
// Returns an error if the target is not found.
//
//   - name: The name of the Account to soft-delete. Format: accounts/{account}
//     Example: "accounts/100".
func (r *AccountsService) Delete(name string) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single Account.
//
//   - name: The name of the account to lookup. Format: accounts/{account}
//     Example: "accounts/100".
func (r *AccountsService) Get(name string) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaAccount.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsGetDataSharingSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDataSharingSettings: Get data sharing settings on an account. Data
// sharing settings are singletons.
//
//   - name: The name of the settings to lookup. Format:
//     accounts/{account}/dataSharingSettings Example:
//     `accounts/1000/dataSharingSettings`.
func (r *AccountsService) GetDataSharingSettings(name string) *AccountsGetDataSharingSettingsCall {
	c := &AccountsGetDataSharingSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsGetDataSharingSettingsCall) Fields(s ...googleapi.Field) *AccountsGetDataSharingSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsGetDataSharingSettingsCall) IfNoneMatch(entityTag string) *AccountsGetDataSharingSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsGetDataSharingSettingsCall) Context(ctx context.Context) *AccountsGetDataSharingSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsGetDataSharingSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetDataSharingSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.getDataSharingSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.getDataSharingSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataSharingSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsGetDataSharingSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataSharingSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataSharingSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.getDataSharingSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all accounts accessible by the caller. Note that these
// accounts might not currently have GA properties. Soft-deleted (ie:
// "trashed") accounts are excluded by default. Returns an empty list if no
// relevant accounts are found.
func (r *AccountsService) List() *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. The service may return fewer than this value, even if
// there are additional pages. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to the
// maximum)
func (c *AccountsListCall) PageSize(pageSize int64) *AccountsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAccounts` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListAccounts` must
// match the call that provided the page token.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to include
// soft-deleted (ie: "trashed") Accounts in the results. Accounts can be
// inspected to determine whether they are deleted or not.
func (c *AccountsListCall) ShowDeleted(showDeleted bool) *AccountsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListAccountsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsPatchCall struct {
	s                                 *Service
	name                              string
	googleanalyticsadminv1betaaccount *GoogleAnalyticsAdminV1betaAccount
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch: Updates an account.
//
//   - name: Output only. Resource name of this account. Format:
//     accounts/{account} Example: "accounts/100".
func (r *AccountsService) Patch(name string, googleanalyticsadminv1betaaccount *GoogleAnalyticsAdminV1betaAccount) *AccountsPatchCall {
	c := &AccountsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betaaccount = googleanalyticsadminv1betaaccount
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (for example,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *AccountsPatchCall) UpdateMask(updateMask string) *AccountsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsPatchCall) Fields(s ...googleapi.Field) *AccountsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsPatchCall) Context(ctx context.Context) *AccountsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaaccount)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaAccount.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsProvisionAccountTicketCall struct {
	s                                                       *Service
	googleanalyticsadminv1betaprovisionaccountticketrequest *GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// ProvisionAccountTicket: Requests a ticket for creating an account.
func (r *AccountsService) ProvisionAccountTicket(googleanalyticsadminv1betaprovisionaccountticketrequest *GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest) *AccountsProvisionAccountTicketCall {
	c := &AccountsProvisionAccountTicketCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1betaprovisionaccountticketrequest = googleanalyticsadminv1betaprovisionaccountticketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsProvisionAccountTicketCall) Fields(s ...googleapi.Field) *AccountsProvisionAccountTicketCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsProvisionAccountTicketCall) Context(ctx context.Context) *AccountsProvisionAccountTicketCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsProvisionAccountTicketCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProvisionAccountTicketCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaprovisionaccountticketrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/accounts:provisionAccountTicket")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.provisionAccountTicket", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.provisionAccountTicket" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsProvisionAccountTicketCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.provisionAccountTicket", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsRunAccessReportCall struct {
	s                                                *Service
	entity                                           string
	googleanalyticsadminv1betarunaccessreportrequest *GoogleAnalyticsAdminV1betaRunAccessReportRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// RunAccessReport: Returns a customized report of data access records. The
// report provides records of each time a user reads Google Analytics reporting
// data. Access records are retained for up to 2 years. Data Access Reports can
// be requested for a property. Reports may be requested for any property, but
// dimensions that aren't related to quota can only be requested on Google
// Analytics 360 properties. This method is only available to Administrators.
// These data access records include GA UI Reporting, GA UI Explorations, GA
// Data API, and other products like Firebase & Admob that can retrieve data
// from Google Analytics through a linkage. These records don't include
// property configuration changes like adding a stream or changing a property's
// time zone. For configuration change history, see searchChangeHistoryEvents
// (https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
// To give your feedback on this API, complete the Google Analytics Access
// Reports feedback
// (https://docs.google.com/forms/d/e/1FAIpQLSdmEBUrMzAEdiEKk5TV5dEHvDUZDRlgWYdQdAeSdtR4hVjEhw/viewform)
// form.
//
//   - entity: The Data Access Report supports requesting at the property level
//     or account level. If requested at the account level, Data Access Reports
//     include all access for all properties under that account. To request at
//     the property level, entity should be for example 'properties/123' if "123"
//     is your Google Analytics property ID. To request at the account level,
//     entity should be for example 'accounts/1234' if "1234" is your Google
//     Analytics Account ID.
func (r *AccountsService) RunAccessReport(entity string, googleanalyticsadminv1betarunaccessreportrequest *GoogleAnalyticsAdminV1betaRunAccessReportRequest) *AccountsRunAccessReportCall {
	c := &AccountsRunAccessReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entity = entity
	c.googleanalyticsadminv1betarunaccessreportrequest = googleanalyticsadminv1betarunaccessreportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsRunAccessReportCall) Fields(s ...googleapi.Field) *AccountsRunAccessReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsRunAccessReportCall) Context(ctx context.Context) *AccountsRunAccessReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsRunAccessReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsRunAccessReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betarunaccessreportrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+entity}:runAccessReport")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entity": c.entity,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.runAccessReport", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.runAccessReport" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaRunAccessReportResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsRunAccessReportCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaRunAccessReportResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaRunAccessReportResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.runAccessReport", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSearchChangeHistoryEventsCall struct {
	s                                                          *Service
	account                                                    string
	googleanalyticsadminv1betasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// SearchChangeHistoryEvents: Searches through all changes to an account or its
// children given the specified set of filters.
//
//   - account: The account resource for which to return change history
//     resources. Format: accounts/{account} Example: `accounts/100`.
func (r *AccountsService) SearchChangeHistoryEvents(account string, googleanalyticsadminv1betasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest) *AccountsSearchChangeHistoryEventsCall {
	c := &AccountsSearchChangeHistoryEventsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.account = account
	c.googleanalyticsadminv1betasearchchangehistoryeventsrequest = googleanalyticsadminv1betasearchchangehistoryeventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSearchChangeHistoryEventsCall) Fields(s ...googleapi.Field) *AccountsSearchChangeHistoryEventsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSearchChangeHistoryEventsCall) Context(ctx context.Context) *AccountsSearchChangeHistoryEventsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSearchChangeHistoryEventsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSearchChangeHistoryEventsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betasearchchangehistoryeventsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+account}:searchChangeHistoryEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"account": c.account,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.searchChangeHistoryEvents", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.searchChangeHistoryEvents" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsSearchChangeHistoryEventsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.accounts.searchChangeHistoryEvents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsSearchChangeHistoryEventsCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1betasearchchangehistoryeventsrequest.PageToken = pt }(c.googleanalyticsadminv1betasearchchangehistoryeventsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1betasearchchangehistoryeventsrequest.PageToken = x.NextPageToken
	}
}

type PropertiesAcknowledgeUserDataCollectionCall struct {
	s                                                              *Service
	property                                                       string
	googleanalyticsadminv1betaacknowledgeuserdatacollectionrequest *GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// AcknowledgeUserDataCollection: Acknowledges the terms of user data
// collection for the specified property. This acknowledgement must be
// completed (either in the Google Analytics UI or through this API) before
// MeasurementProtocolSecret resources may be created.
//
// - property: The property for which to acknowledge user data collection.
func (r *PropertiesService) AcknowledgeUserDataCollection(property string, googleanalyticsadminv1betaacknowledgeuserdatacollectionrequest *GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest) *PropertiesAcknowledgeUserDataCollectionCall {
	c := &PropertiesAcknowledgeUserDataCollectionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.property = property
	c.googleanalyticsadminv1betaacknowledgeuserdatacollectionrequest = googleanalyticsadminv1betaacknowledgeuserdatacollectionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Fields(s ...googleapi.Field) *PropertiesAcknowledgeUserDataCollectionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Context(ctx context.Context) *PropertiesAcknowledgeUserDataCollectionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAcknowledgeUserDataCollectionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaacknowledgeuserdatacollectionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+property}:acknowledgeUserDataCollection")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"property": c.property,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.acknowledgeUserDataCollection", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.acknowledgeUserDataCollection" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.acknowledgeUserDataCollection", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCreateCall struct {
	s                                  *Service
	googleanalyticsadminv1betaproperty *GoogleAnalyticsAdminV1betaProperty
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates a Google Analytics property with the specified location and
// attributes.
func (r *PropertiesService) Create(googleanalyticsadminv1betaproperty *GoogleAnalyticsAdminV1betaProperty) *PropertiesCreateCall {
	c := &PropertiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1betaproperty = googleanalyticsadminv1betaproperty
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCreateCall) Fields(s ...googleapi.Field) *PropertiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCreateCall) Context(ctx context.Context) *PropertiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaproperty)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaProperty.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Property as soft-deleted (ie: "trashed") and returns
// it. This API does not have a method to restore soft-deleted properties.
// However, they can be restored using the Trash Can UI. If the properties are
// not restored before the expiration time, the Property and all child
// resources (eg: GoogleAdsLinks, Streams, AccessBindings) will be permanently
// purged. https://support.google.com/analytics/answer/6154772 Returns an error
// if the target is not found.
//
//   - name: The name of the Property to soft-delete. Format:
//     properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Delete(name string) *PropertiesDeleteCall {
	c := &PropertiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDeleteCall) Fields(s ...googleapi.Field) *PropertiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDeleteCall) Context(ctx context.Context) *PropertiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaProperty.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single GA Property.
//
//   - name: The name of the property to lookup. Format: properties/{property_id}
//     Example: "properties/1000".
func (r *PropertiesService) Get(name string) *PropertiesGetCall {
	c := &PropertiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGetCall) Fields(s ...googleapi.Field) *PropertiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesGetCall) IfNoneMatch(entityTag string) *PropertiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGetCall) Context(ctx context.Context) *PropertiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaProperty.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesGetDataRetentionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDataRetentionSettings: Returns the singleton data retention settings for
// this property.
//
//   - name: The name of the settings to lookup. Format:
//     properties/{property}/dataRetentionSettings Example:
//     "properties/1000/dataRetentionSettings".
func (r *PropertiesService) GetDataRetentionSettings(name string) *PropertiesGetDataRetentionSettingsCall {
	c := &PropertiesGetDataRetentionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGetDataRetentionSettingsCall) Fields(s ...googleapi.Field) *PropertiesGetDataRetentionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesGetDataRetentionSettingsCall) IfNoneMatch(entityTag string) *PropertiesGetDataRetentionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGetDataRetentionSettingsCall) Context(ctx context.Context) *PropertiesGetDataRetentionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGetDataRetentionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetDataRetentionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.getDataRetentionSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.getDataRetentionSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataRetentionSettings.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesGetDataRetentionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataRetentionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataRetentionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.getDataRetentionSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child Properties under the specified parent Account.
// Properties will be excluded if the caller does not have access. Soft-deleted
// (ie: "trashed") properties are excluded by default. Returns an empty list if
// no relevant properties are found.
func (r *PropertiesService) List() *PropertiesListCall {
	c := &PropertiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": Required. An expression for
// filtering the results of the request. Fields eligible for filtering are:
// `parent:`(The resource name of the parent account/property) or
// `ancestor:`(The resource name of the parent account) or
// `firebase_project:`(The id or number of the linked firebase project). Some
// examples of filters: ``` | Filter | Description |
// |-----------------------------|-------------------------------------------|
// | parent:accounts/123 | The account with account id: 123. | |
// parent:properties/123 | The property with property id: 123. | |
// ancestor:accounts/123 | The account with account id: 123. | |
// firebase_project:project-id | The firebase project with id: project-id. | |
// firebase_project:123 | The firebase project with number: 123. | ```
func (c *PropertiesListCall) Filter(filter string) *PropertiesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. The service may return fewer than this value, even if
// there are additional pages. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to the
// maximum)
func (c *PropertiesListCall) PageSize(pageSize int64) *PropertiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListProperties` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListProperties` must match the call that provided the page token.
func (c *PropertiesListCall) PageToken(pageToken string) *PropertiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to include
// soft-deleted (ie: "trashed") Properties in the results. Properties can be
// inspected to determine whether they are deleted or not.
func (c *PropertiesListCall) ShowDeleted(showDeleted bool) *PropertiesListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesListCall) Fields(s ...googleapi.Field) *PropertiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesListCall) IfNoneMatch(entityTag string) *PropertiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesListCall) Context(ctx context.Context) *PropertiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListPropertiesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListPropertiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListPropertiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListPropertiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesPatchCall struct {
	s                                  *Service
	name                               string
	googleanalyticsadminv1betaproperty *GoogleAnalyticsAdminV1betaProperty
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates a property.
//
//   - name: Output only. Resource name of this property. Format:
//     properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Patch(name string, googleanalyticsadminv1betaproperty *GoogleAnalyticsAdminV1betaProperty) *PropertiesPatchCall {
	c := &PropertiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betaproperty = googleanalyticsadminv1betaproperty
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (e.g.,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesPatchCall) UpdateMask(updateMask string) *PropertiesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesPatchCall) Fields(s ...googleapi.Field) *PropertiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesPatchCall) Context(ctx context.Context) *PropertiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaproperty)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaProperty.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesRunAccessReportCall struct {
	s                                                *Service
	entity                                           string
	googleanalyticsadminv1betarunaccessreportrequest *GoogleAnalyticsAdminV1betaRunAccessReportRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// RunAccessReport: Returns a customized report of data access records. The
// report provides records of each time a user reads Google Analytics reporting
// data. Access records are retained for up to 2 years. Data Access Reports can
// be requested for a property. Reports may be requested for any property, but
// dimensions that aren't related to quota can only be requested on Google
// Analytics 360 properties. This method is only available to Administrators.
// These data access records include GA UI Reporting, GA UI Explorations, GA
// Data API, and other products like Firebase & Admob that can retrieve data
// from Google Analytics through a linkage. These records don't include
// property configuration changes like adding a stream or changing a property's
// time zone. For configuration change history, see searchChangeHistoryEvents
// (https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
// To give your feedback on this API, complete the Google Analytics Access
// Reports feedback
// (https://docs.google.com/forms/d/e/1FAIpQLSdmEBUrMzAEdiEKk5TV5dEHvDUZDRlgWYdQdAeSdtR4hVjEhw/viewform)
// form.
//
//   - entity: The Data Access Report supports requesting at the property level
//     or account level. If requested at the account level, Data Access Reports
//     include all access for all properties under that account. To request at
//     the property level, entity should be for example 'properties/123' if "123"
//     is your Google Analytics property ID. To request at the account level,
//     entity should be for example 'accounts/1234' if "1234" is your Google
//     Analytics Account ID.
func (r *PropertiesService) RunAccessReport(entity string, googleanalyticsadminv1betarunaccessreportrequest *GoogleAnalyticsAdminV1betaRunAccessReportRequest) *PropertiesRunAccessReportCall {
	c := &PropertiesRunAccessReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entity = entity
	c.googleanalyticsadminv1betarunaccessreportrequest = googleanalyticsadminv1betarunaccessreportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesRunAccessReportCall) Fields(s ...googleapi.Field) *PropertiesRunAccessReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesRunAccessReportCall) Context(ctx context.Context) *PropertiesRunAccessReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesRunAccessReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesRunAccessReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betarunaccessreportrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+entity}:runAccessReport")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entity": c.entity,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.runAccessReport", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.runAccessReport" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaRunAccessReportResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesRunAccessReportCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaRunAccessReportResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaRunAccessReportResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.runAccessReport", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesUpdateDataRetentionSettingsCall struct {
	s                                               *Service
	name                                            string
	googleanalyticsadminv1betadataretentionsettings *GoogleAnalyticsAdminV1betaDataRetentionSettings
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// UpdateDataRetentionSettings: Updates the singleton data retention settings
// for this property.
//
//   - name: Output only. Resource name for this DataRetentionSetting resource.
//     Format: properties/{property}/dataRetentionSettings.
func (r *PropertiesService) UpdateDataRetentionSettings(name string, googleanalyticsadminv1betadataretentionsettings *GoogleAnalyticsAdminV1betaDataRetentionSettings) *PropertiesUpdateDataRetentionSettingsCall {
	c := &PropertiesUpdateDataRetentionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betadataretentionsettings = googleanalyticsadminv1betadataretentionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (e.g.,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesUpdateDataRetentionSettingsCall) UpdateMask(updateMask string) *PropertiesUpdateDataRetentionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesUpdateDataRetentionSettingsCall) Fields(s ...googleapi.Field) *PropertiesUpdateDataRetentionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesUpdateDataRetentionSettingsCall) Context(ctx context.Context) *PropertiesUpdateDataRetentionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesUpdateDataRetentionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUpdateDataRetentionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betadataretentionsettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.updateDataRetentionSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.updateDataRetentionSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataRetentionSettings.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesUpdateDataRetentionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataRetentionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataRetentionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.updateDataRetentionSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesConversionEventsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleanalyticsadminv1betaconversionevent *GoogleAnalyticsAdminV1betaConversionEvent
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Deprecated: Use `CreateKeyEvent` instead. Creates a conversion event
// with the specified attributes.
//
//   - parent: The resource name of the parent property where this conversion
//     event will be created. Format: properties/123.
func (r *PropertiesConversionEventsService) Create(parent string, googleanalyticsadminv1betaconversionevent *GoogleAnalyticsAdminV1betaConversionEvent) *PropertiesConversionEventsCreateCall {
	c := &PropertiesConversionEventsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betaconversionevent = googleanalyticsadminv1betaconversionevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesConversionEventsCreateCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesConversionEventsCreateCall) Context(ctx context.Context) *PropertiesConversionEventsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesConversionEventsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaconversionevent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/conversionEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaConversionEvent.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesConversionEventsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaConversionEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaConversionEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesConversionEventsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deprecated: Use `DeleteKeyEvent` instead. Deletes a conversion event
// in a property.
//
//   - name: The resource name of the conversion event to delete. Format:
//     properties/{property}/conversionEvents/{conversion_event} Example:
//     "properties/123/conversionEvents/456".
func (r *PropertiesConversionEventsService) Delete(name string) *PropertiesConversionEventsDeleteCall {
	c := &PropertiesConversionEventsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesConversionEventsDeleteCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesConversionEventsDeleteCall) Context(ctx context.Context) *PropertiesConversionEventsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesConversionEventsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesConversionEventsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesConversionEventsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Deprecated: Use `GetKeyEvent` instead. Retrieve a single conversion
// event.
//
//   - name: The resource name of the conversion event to retrieve. Format:
//     properties/{property}/conversionEvents/{conversion_event} Example:
//     "properties/123/conversionEvents/456".
func (r *PropertiesConversionEventsService) Get(name string) *PropertiesConversionEventsGetCall {
	c := &PropertiesConversionEventsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesConversionEventsGetCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesConversionEventsGetCall) IfNoneMatch(entityTag string) *PropertiesConversionEventsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesConversionEventsGetCall) Context(ctx context.Context) *PropertiesConversionEventsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesConversionEventsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaConversionEvent.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesConversionEventsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaConversionEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaConversionEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesConversionEventsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Deprecated: Use `ListKeyEvents` instead. Returns a list of conversion
// events in the specified parent property. Returns an empty list if no
// conversion events are found.
//
//   - parent: The resource name of the parent property. Example:
//     'properties/123'.
func (r *PropertiesConversionEventsService) List(parent string) *PropertiesConversionEventsListCall {
	c := &PropertiesConversionEventsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200; (higher values will be coerced to the maximum)
func (c *PropertiesConversionEventsListCall) PageSize(pageSize int64) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListConversionEvents` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListConversionEvents` must match the call that provided the page token.
func (c *PropertiesConversionEventsListCall) PageToken(pageToken string) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesConversionEventsListCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesConversionEventsListCall) IfNoneMatch(entityTag string) *PropertiesConversionEventsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesConversionEventsListCall) Context(ctx context.Context) *PropertiesConversionEventsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesConversionEventsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/conversionEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListConversionEventsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesConversionEventsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListConversionEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListConversionEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesConversionEventsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListConversionEventsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesConversionEventsPatchCall struct {
	s                                         *Service
	name                                      string
	googleanalyticsadminv1betaconversionevent *GoogleAnalyticsAdminV1betaConversionEvent
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Deprecated: Use `UpdateKeyEvent` instead. Updates a conversion event
// with the specified attributes.
//
//   - name: Output only. Resource name of this conversion event. Format:
//     properties/{property}/conversionEvents/{conversion_event}.
func (r *PropertiesConversionEventsService) Patch(name string, googleanalyticsadminv1betaconversionevent *GoogleAnalyticsAdminV1betaConversionEvent) *PropertiesConversionEventsPatchCall {
	c := &PropertiesConversionEventsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betaconversionevent = googleanalyticsadminv1betaconversionevent
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (e.g.,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesConversionEventsPatchCall) UpdateMask(updateMask string) *PropertiesConversionEventsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesConversionEventsPatchCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesConversionEventsPatchCall) Context(ctx context.Context) *PropertiesConversionEventsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesConversionEventsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaconversionevent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaConversionEvent.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesConversionEventsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaConversionEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaConversionEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.conversionEvents.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomDimensionsArchiveCall struct {
	s                                                       *Service
	name                                                    string
	googleanalyticsadminv1betaarchivecustomdimensionrequest *GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Archive: Archives a CustomDimension on a property.
//
//   - name: The name of the CustomDimension to archive. Example format:
//     properties/1234/customDimensions/5678.
func (r *PropertiesCustomDimensionsService) Archive(name string, googleanalyticsadminv1betaarchivecustomdimensionrequest *GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest) *PropertiesCustomDimensionsArchiveCall {
	c := &PropertiesCustomDimensionsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betaarchivecustomdimensionrequest = googleanalyticsadminv1betaarchivecustomdimensionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomDimensionsArchiveCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomDimensionsArchiveCall) Context(ctx context.Context) *PropertiesCustomDimensionsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomDimensionsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaarchivecustomdimensionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.archive", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.archive" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomDimensionsArchiveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.archive", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomDimensionsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleanalyticsadminv1betacustomdimension *GoogleAnalyticsAdminV1betaCustomDimension
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates a CustomDimension.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomDimensionsService) Create(parent string, googleanalyticsadminv1betacustomdimension *GoogleAnalyticsAdminV1betaCustomDimension) *PropertiesCustomDimensionsCreateCall {
	c := &PropertiesCustomDimensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betacustomdimension = googleanalyticsadminv1betacustomdimension
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomDimensionsCreateCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomDimensionsCreateCall) Context(ctx context.Context) *PropertiesCustomDimensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomDimensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betacustomdimension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/customDimensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomDimension.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomDimensionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomDimensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single CustomDimension.
//
//   - name: The name of the CustomDimension to get. Example format:
//     properties/1234/customDimensions/5678.
func (r *PropertiesCustomDimensionsService) Get(name string) *PropertiesCustomDimensionsGetCall {
	c := &PropertiesCustomDimensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomDimensionsGetCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesCustomDimensionsGetCall) IfNoneMatch(entityTag string) *PropertiesCustomDimensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomDimensionsGetCall) Context(ctx context.Context) *PropertiesCustomDimensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomDimensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomDimension.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomDimensionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomDimensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CustomDimensions on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomDimensionsService) List(parent string) *PropertiesCustomDimensionsListCall {
	c := &PropertiesCustomDimensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200 (higher values will be coerced to the maximum).
func (c *PropertiesCustomDimensionsListCall) PageSize(pageSize int64) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCustomDimensions` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListCustomDimensions` must match the call that provided the page token.
func (c *PropertiesCustomDimensionsListCall) PageToken(pageToken string) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomDimensionsListCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesCustomDimensionsListCall) IfNoneMatch(entityTag string) *PropertiesCustomDimensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomDimensionsListCall) Context(ctx context.Context) *PropertiesCustomDimensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomDimensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/customDimensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListCustomDimensionsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomDimensionsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListCustomDimensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListCustomDimensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesCustomDimensionsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListCustomDimensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesCustomDimensionsPatchCall struct {
	s                                         *Service
	name                                      string
	googleanalyticsadminv1betacustomdimension *GoogleAnalyticsAdminV1betaCustomDimension
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a CustomDimension on a property.
//
//   - name: Output only. Resource name for this CustomDimension resource.
//     Format: properties/{property}/customDimensions/{customDimension}.
func (r *PropertiesCustomDimensionsService) Patch(name string, googleanalyticsadminv1betacustomdimension *GoogleAnalyticsAdminV1betaCustomDimension) *PropertiesCustomDimensionsPatchCall {
	c := &PropertiesCustomDimensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betacustomdimension = googleanalyticsadminv1betacustomdimension
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesCustomDimensionsPatchCall) UpdateMask(updateMask string) *PropertiesCustomDimensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomDimensionsPatchCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomDimensionsPatchCall) Context(ctx context.Context) *PropertiesCustomDimensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomDimensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betacustomdimension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomDimension.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomDimensionsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customDimensions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomMetricsArchiveCall struct {
	s                                                    *Service
	name                                                 string
	googleanalyticsadminv1betaarchivecustommetricrequest *GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// Archive: Archives a CustomMetric on a property.
//
//   - name: The name of the CustomMetric to archive. Example format:
//     properties/1234/customMetrics/5678.
func (r *PropertiesCustomMetricsService) Archive(name string, googleanalyticsadminv1betaarchivecustommetricrequest *GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest) *PropertiesCustomMetricsArchiveCall {
	c := &PropertiesCustomMetricsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betaarchivecustommetricrequest = googleanalyticsadminv1betaarchivecustommetricrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomMetricsArchiveCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomMetricsArchiveCall) Context(ctx context.Context) *PropertiesCustomMetricsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomMetricsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betaarchivecustommetricrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.archive", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.archive" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomMetricsArchiveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.archive", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomMetricsCreateCall struct {
	s                                      *Service
	parent                                 string
	googleanalyticsadminv1betacustommetric *GoogleAnalyticsAdminV1betaCustomMetric
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a CustomMetric.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomMetricsService) Create(parent string, googleanalyticsadminv1betacustommetric *GoogleAnalyticsAdminV1betaCustomMetric) *PropertiesCustomMetricsCreateCall {
	c := &PropertiesCustomMetricsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betacustommetric = googleanalyticsadminv1betacustommetric
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomMetricsCreateCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomMetricsCreateCall) Context(ctx context.Context) *PropertiesCustomMetricsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomMetricsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betacustommetric)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/customMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomMetric.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomMetricsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single CustomMetric.
//
//   - name: The name of the CustomMetric to get. Example format:
//     properties/1234/customMetrics/5678.
func (r *PropertiesCustomMetricsService) Get(name string) *PropertiesCustomMetricsGetCall {
	c := &PropertiesCustomMetricsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomMetricsGetCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesCustomMetricsGetCall) IfNoneMatch(entityTag string) *PropertiesCustomMetricsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomMetricsGetCall) Context(ctx context.Context) *PropertiesCustomMetricsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomMetricsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomMetric.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesCustomMetricsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CustomMetrics on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomMetricsService) List(parent string) *PropertiesCustomMetricsListCall {
	c := &PropertiesCustomMetricsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200 (higher values will be coerced to the maximum).
func (c *PropertiesCustomMetricsListCall) PageSize(pageSize int64) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCustomMetrics` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListCustomMetrics` must match the call that provided the page token.
func (c *PropertiesCustomMetricsListCall) PageToken(pageToken string) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomMetricsListCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesCustomMetricsListCall) IfNoneMatch(entityTag string) *PropertiesCustomMetricsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomMetricsListCall) Context(ctx context.Context) *PropertiesCustomMetricsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomMetricsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/customMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListCustomMetricsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListCustomMetricsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListCustomMetricsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesCustomMetricsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListCustomMetricsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesCustomMetricsPatchCall struct {
	s                                      *Service
	name                                   string
	googleanalyticsadminv1betacustommetric *GoogleAnalyticsAdminV1betaCustomMetric
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates a CustomMetric on a property.
//
//   - name: Output only. Resource name for this CustomMetric resource. Format:
//     properties/{property}/customMetrics/{customMetric}.
func (r *PropertiesCustomMetricsService) Patch(name string, googleanalyticsadminv1betacustommetric *GoogleAnalyticsAdminV1betaCustomMetric) *PropertiesCustomMetricsPatchCall {
	c := &PropertiesCustomMetricsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betacustommetric = googleanalyticsadminv1betacustommetric
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesCustomMetricsPatchCall) UpdateMask(updateMask string) *PropertiesCustomMetricsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesCustomMetricsPatchCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesCustomMetricsPatchCall) Context(ctx context.Context) *PropertiesCustomMetricsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesCustomMetricsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betacustommetric)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaCustomMetric.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.customMetrics.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsCreateCall struct {
	s                                    *Service
	parent                               string
	googleanalyticsadminv1betadatastream *GoogleAnalyticsAdminV1betaDataStream
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Create: Creates a DataStream.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDataStreamsService) Create(parent string, googleanalyticsadminv1betadatastream *GoogleAnalyticsAdminV1betaDataStream) *PropertiesDataStreamsCreateCall {
	c := &PropertiesDataStreamsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betadatastream = googleanalyticsadminv1betadatastream
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsCreateCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsCreateCall) Context(ctx context.Context) *PropertiesDataStreamsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betadatastream)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/dataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataStream on a property.
//
//   - name: The name of the DataStream to delete. Example format:
//     properties/1234/dataStreams/5678.
func (r *PropertiesDataStreamsService) Delete(name string) *PropertiesDataStreamsDeleteCall {
	c := &PropertiesDataStreamsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsDeleteCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsDeleteCall) Context(ctx context.Context) *PropertiesDataStreamsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single DataStream.
//
//   - name: The name of the DataStream to get. Example format:
//     properties/1234/dataStreams/5678.
func (r *PropertiesDataStreamsService) Get(name string) *PropertiesDataStreamsGetCall {
	c := &PropertiesDataStreamsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsGetCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesDataStreamsGetCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsGetCall) Context(ctx context.Context) *PropertiesDataStreamsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataStreams on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDataStreamsService) List(parent string) *PropertiesDataStreamsListCall {
	c := &PropertiesDataStreamsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200 (higher values will be coerced to the maximum).
func (c *PropertiesDataStreamsListCall) PageSize(pageSize int64) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDataStreams` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListDataStreams` must match the call that provided the page token.
func (c *PropertiesDataStreamsListCall) PageToken(pageToken string) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsListCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesDataStreamsListCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsListCall) Context(ctx context.Context) *PropertiesDataStreamsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/dataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListDataStreamsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListDataStreamsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListDataStreamsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDataStreamsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListDataStreamsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesDataStreamsPatchCall struct {
	s                                    *Service
	name                                 string
	googleanalyticsadminv1betadatastream *GoogleAnalyticsAdminV1betaDataStream
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch: Updates a DataStream on a property.
//
//   - name: Output only. Resource name of this Data Stream. Format:
//     properties/{property_id}/dataStreams/{stream_id} Example:
//     "properties/1000/dataStreams/2000".
func (r *PropertiesDataStreamsService) Patch(name string, googleanalyticsadminv1betadatastream *GoogleAnalyticsAdminV1betaDataStream) *PropertiesDataStreamsPatchCall {
	c := &PropertiesDataStreamsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betadatastream = googleanalyticsadminv1betadatastream
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesDataStreamsPatchCall) UpdateMask(updateMask string) *PropertiesDataStreamsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsPatchCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsPatchCall) Context(ctx context.Context) *PropertiesDataStreamsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betadatastream)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsMeasurementProtocolSecretsCreateCall struct {
	s                                                   *Service
	parent                                              string
	googleanalyticsadminv1betameasurementprotocolsecret *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Create: Creates a measurement protocol secret.
//
//   - parent: The parent resource where this secret will be created. Format:
//     properties/{property}/dataStreams/{dataStream}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Create(parent string, googleanalyticsadminv1betameasurementprotocolsecret *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betameasurementprotocolsecret = googleanalyticsadminv1betameasurementprotocolsecret
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betameasurementprotocolsecret)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/measurementProtocolSecrets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes target MeasurementProtocolSecret.
//
//   - name: The name of the MeasurementProtocolSecret to delete. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{
//     measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Delete(name string) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsMeasurementProtocolSecretsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single MeasurementProtocolSecret.
//
//   - name: The name of the measurement protocol secret to lookup. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{
//     measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Get(name string) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesDataStreamsMeasurementProtocolSecretsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child MeasurementProtocolSecrets under the specified parent
// Property.
//
//   - parent: The resource name of the parent stream. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) List(parent string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 10 resources will be returned.
// The maximum value is 10. Higher values will be coerced to the maximum.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) PageSize(pageSize int64) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListMeasurementProtocolSecrets` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListMeasurementProtocolSecrets` must match the call that provided the
// page token.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) PageToken(pageToken string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/measurementProtocolSecrets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesDataStreamsMeasurementProtocolSecretsPatchCall struct {
	s                                                   *Service
	name                                                string
	googleanalyticsadminv1betameasurementprotocolsecret *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Patch: Updates a measurement protocol secret.
//
//   - name: Output only. Resource name of this secret. This secret may be a
//     child of any type of stream. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{
//     measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Patch(name string, googleanalyticsadminv1betameasurementprotocolsecret *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betameasurementprotocolsecret = googleanalyticsadminv1betameasurementprotocolsecret
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Omitted fields will not be updated.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) UpdateMask(updateMask string) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betameasurementprotocolsecret)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesFirebaseLinksCreateCall struct {
	s                                      *Service
	parent                                 string
	googleanalyticsadminv1betafirebaselink *GoogleAnalyticsAdminV1betaFirebaseLink
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a FirebaseLink. Properties can have at most one
// FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: `properties/1234`.
func (r *PropertiesFirebaseLinksService) Create(parent string, googleanalyticsadminv1betafirebaselink *GoogleAnalyticsAdminV1betaFirebaseLink) *PropertiesFirebaseLinksCreateCall {
	c := &PropertiesFirebaseLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betafirebaselink = googleanalyticsadminv1betafirebaselink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesFirebaseLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesFirebaseLinksCreateCall) Context(ctx context.Context) *PropertiesFirebaseLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesFirebaseLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betafirebaselink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaFirebaseLink.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaFirebaseLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaFirebaseLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesFirebaseLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a FirebaseLink on a property
//
//   - name: Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
//     Example: `properties/1234/firebaseLinks/5678`.
func (r *PropertiesFirebaseLinksService) Delete(name string) *PropertiesFirebaseLinksDeleteCall {
	c := &PropertiesFirebaseLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesFirebaseLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesFirebaseLinksDeleteCall) Context(ctx context.Context) *PropertiesFirebaseLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesFirebaseLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesFirebaseLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesFirebaseLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists FirebaseLinks on a property. Properties can have at most one
// FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: `properties/1234`.
func (r *PropertiesFirebaseLinksService) List(parent string) *PropertiesFirebaseLinksListCall {
	c := &PropertiesFirebaseLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. The service may return fewer than this value, even if
// there are additional pages. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to the
// maximum)
func (c *PropertiesFirebaseLinksListCall) PageSize(pageSize int64) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListFirebaseLinks` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListFirebaseLinks` must match the call that provided the page token.
func (c *PropertiesFirebaseLinksListCall) PageToken(pageToken string) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesFirebaseLinksListCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesFirebaseLinksListCall) IfNoneMatch(entityTag string) *PropertiesFirebaseLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesFirebaseLinksListCall) Context(ctx context.Context) *PropertiesFirebaseLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesFirebaseLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListFirebaseLinksResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListFirebaseLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListFirebaseLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.firebaseLinks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesFirebaseLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListFirebaseLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesGoogleAdsLinksCreateCall struct {
	s                                       *Service
	parent                                  string
	googleanalyticsadminv1betagoogleadslink *GoogleAnalyticsAdminV1betaGoogleAdsLink
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a GoogleAdsLink.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) Create(parent string, googleanalyticsadminv1betagoogleadslink *GoogleAnalyticsAdminV1betaGoogleAdsLink) *PropertiesGoogleAdsLinksCreateCall {
	c := &PropertiesGoogleAdsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betagoogleadslink = googleanalyticsadminv1betagoogleadslink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGoogleAdsLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGoogleAdsLinksCreateCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGoogleAdsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betagoogleadslink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaGoogleAdsLink.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesGoogleAdsLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesGoogleAdsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a GoogleAdsLink on a property
//
// - name: Example format: properties/1234/googleAdsLinks/5678.
func (r *PropertiesGoogleAdsLinksService) Delete(name string) *PropertiesGoogleAdsLinksDeleteCall {
	c := &PropertiesGoogleAdsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGoogleAdsLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGoogleAdsLinksDeleteCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGoogleAdsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesGoogleAdsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GoogleAdsLinks on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) List(parent string) *PropertiesGoogleAdsLinksListCall {
	c := &PropertiesGoogleAdsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200 (higher values will be coerced to the maximum).
func (c *PropertiesGoogleAdsLinksListCall) PageSize(pageSize int64) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListGoogleAdsLinks` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListGoogleAdsLinks` must match the call that provided the page token.
func (c *PropertiesGoogleAdsLinksListCall) PageToken(pageToken string) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGoogleAdsLinksListCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesGoogleAdsLinksListCall) IfNoneMatch(entityTag string) *PropertiesGoogleAdsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGoogleAdsLinksListCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGoogleAdsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesGoogleAdsLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesGoogleAdsLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesGoogleAdsLinksPatchCall struct {
	s                                       *Service
	name                                    string
	googleanalyticsadminv1betagoogleadslink *GoogleAnalyticsAdminV1betaGoogleAdsLink
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates a GoogleAdsLink on a property
//
//   - name: Output only. Format:
//     properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
//     googleAdsLinkId is not the Google Ads customer ID.
func (r *PropertiesGoogleAdsLinksService) Patch(name string, googleanalyticsadminv1betagoogleadslink *GoogleAnalyticsAdminV1betaGoogleAdsLink) *PropertiesGoogleAdsLinksPatchCall {
	c := &PropertiesGoogleAdsLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betagoogleadslink = googleanalyticsadminv1betagoogleadslink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (e.g.,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesGoogleAdsLinksPatchCall) UpdateMask(updateMask string) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesGoogleAdsLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesGoogleAdsLinksPatchCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesGoogleAdsLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betagoogleadslink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaGoogleAdsLink.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesGoogleAdsLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.googleAdsLinks.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesKeyEventsCreateCall struct {
	s                                  *Service
	parent                             string
	googleanalyticsadminv1betakeyevent *GoogleAnalyticsAdminV1betaKeyEvent
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates a Key Event.
//
//   - parent: The resource name of the parent property where this Key Event will
//     be created. Format: properties/123.
func (r *PropertiesKeyEventsService) Create(parent string, googleanalyticsadminv1betakeyevent *GoogleAnalyticsAdminV1betaKeyEvent) *PropertiesKeyEventsCreateCall {
	c := &PropertiesKeyEventsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1betakeyevent = googleanalyticsadminv1betakeyevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesKeyEventsCreateCall) Fields(s ...googleapi.Field) *PropertiesKeyEventsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesKeyEventsCreateCall) Context(ctx context.Context) *PropertiesKeyEventsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesKeyEventsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesKeyEventsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betakeyevent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/keyEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.keyEvents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaKeyEvent.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesKeyEventsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaKeyEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaKeyEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesKeyEventsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Key Event.
//
//   - name: The resource name of the Key Event to delete. Format:
//     properties/{property}/keyEvents/{key_event} Example:
//     "properties/123/keyEvents/456".
func (r *PropertiesKeyEventsService) Delete(name string) *PropertiesKeyEventsDeleteCall {
	c := &PropertiesKeyEventsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesKeyEventsDeleteCall) Fields(s ...googleapi.Field) *PropertiesKeyEventsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesKeyEventsDeleteCall) Context(ctx context.Context) *PropertiesKeyEventsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesKeyEventsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesKeyEventsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.keyEvents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesKeyEventsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesKeyEventsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single Key Event.
//
//   - name: The resource name of the Key Event to retrieve. Format:
//     properties/{property}/keyEvents/{key_event} Example:
//     "properties/123/keyEvents/456".
func (r *PropertiesKeyEventsService) Get(name string) *PropertiesKeyEventsGetCall {
	c := &PropertiesKeyEventsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesKeyEventsGetCall) Fields(s ...googleapi.Field) *PropertiesKeyEventsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesKeyEventsGetCall) IfNoneMatch(entityTag string) *PropertiesKeyEventsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesKeyEventsGetCall) Context(ctx context.Context) *PropertiesKeyEventsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesKeyEventsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesKeyEventsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.keyEvents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaKeyEvent.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesKeyEventsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaKeyEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaKeyEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PropertiesKeyEventsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of Key Events in the specified parent property. Returns
// an empty list if no Key Events are found.
//
//   - parent: The resource name of the parent property. Example:
//     'properties/123'.
func (r *PropertiesKeyEventsService) List(parent string) *PropertiesKeyEventsListCall {
	c := &PropertiesKeyEventsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. If unspecified, at most 50 resources will be returned.
// The maximum value is 200; (higher values will be coerced to the maximum)
func (c *PropertiesKeyEventsListCall) PageSize(pageSize int64) *PropertiesKeyEventsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListKeyEvents` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListKeyEvents` must match the call that provided the page token.
func (c *PropertiesKeyEventsListCall) PageToken(pageToken string) *PropertiesKeyEventsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesKeyEventsListCall) Fields(s ...googleapi.Field) *PropertiesKeyEventsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PropertiesKeyEventsListCall) IfNoneMatch(entityTag string) *PropertiesKeyEventsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesKeyEventsListCall) Context(ctx context.Context) *PropertiesKeyEventsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesKeyEventsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesKeyEventsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/keyEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.keyEvents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaListKeyEventsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesKeyEventsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaListKeyEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaListKeyEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesKeyEventsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1betaListKeyEventsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type PropertiesKeyEventsPatchCall struct {
	s                                  *Service
	name                               string
	googleanalyticsadminv1betakeyevent *GoogleAnalyticsAdminV1betaKeyEvent
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates a Key Event.
//
//   - name: Output only. Resource name of this key event. Format:
//     properties/{property}/keyEvents/{key_event}.
func (r *PropertiesKeyEventsService) Patch(name string, googleanalyticsadminv1betakeyevent *GoogleAnalyticsAdminV1betaKeyEvent) *PropertiesKeyEventsPatchCall {
	c := &PropertiesKeyEventsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1betakeyevent = googleanalyticsadminv1betakeyevent
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. Field names must be in snake case (e.g.,
// "field_to_update"). Omitted fields will not be updated. To replace the
// entire entity, use one path with the string "*" to match all fields.
func (c *PropertiesKeyEventsPatchCall) UpdateMask(updateMask string) *PropertiesKeyEventsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PropertiesKeyEventsPatchCall) Fields(s ...googleapi.Field) *PropertiesKeyEventsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PropertiesKeyEventsPatchCall) Context(ctx context.Context) *PropertiesKeyEventsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PropertiesKeyEventsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesKeyEventsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleanalyticsadminv1betakeyevent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.keyEvents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleAnalyticsAdminV1betaKeyEvent.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesKeyEventsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1betaKeyEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1betaKeyEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "analyticsadmin.properties.keyEvents.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
