/*-
 * Copyright (c) 2001 Dan Potter
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "animations.h"

/*
 * XXX: tmp, until I add options from rcfile
 */
#define BREAK_STEPS	20
#define BREAK_MOV_INC	5

/*
 * An animation intended for when windows are departing:  Lines along the
 * four edges of the window fall forward.
 *	This was written by Dan Potter <bard@allusion.net>
 */
void fall_break(client_t *client, int event) {
	XSegment segs[4];
	XSegment velocities[4];
	int x, y, width, height;
	int nsegs = 4;
	int i, j;

	/* grab the server */
	XGrabServer(display);

	/* fill in locals */
	x = client->x;
	y = client->y;
	width = client->width + 1;
	height = client->height + 1;

	segs[0].x1 = x;				/* left */
	segs[0].y1 = y;
	segs[0].x2 = x;
	segs[0].y2 = y + height;
	
	segs[1].x1 = x;				/* top */
	segs[1].y1 = y;
	segs[1].x2 = x + width;
	segs[1].y2 = y;

	segs[2].x1 = x + width;			/* right */
	segs[2].y1 = y;
	segs[2].x2 = x + width;
	segs[2].y2 = y + height;

	segs[3].x1 = x;				/* bottom */
	segs[3].y1 = y + height;
	segs[3].x2 = x + width;
	segs[3].y2 = y + height;

	velocities[0].x1 = -(BREAK_MOV_INC + 2);/* left */
	velocities[0].y1 = 0;
	velocities[0].x2 = -BREAK_MOV_INC;
	velocities[0].y2 = 0;

	velocities[1].x1 = 0;			/* top */
	velocities[1].y1 = +BREAK_MOV_INC;
	velocities[1].x2 = 0;
	velocities[1].y2 = +BREAK_MOV_INC;

	velocities[2].x1 = +BREAK_MOV_INC + 2;	/* right */
	velocities[2].y1 = 0;
	velocities[2].x2 = +BREAK_MOV_INC;
	velocities[2].y2 = 0;
	
	velocities[3].x1 = 0;			/* bottom */
	velocities[3].y1 = +BREAK_MOV_INC;
	velocities[3].x2 = 0;
	velocities[3].y2 = +BREAK_MOV_INC;

	for (i = 0; i < BREAK_STEPS; i++) {
		XDrawSegments(display, client->screen->root, client->screen->xorgc, segs, nsegs);
		XSync(display, 0);
		usleep(options.anim_delay / 2);
		XDrawSegments(display, client->screen->root, client->screen->xorgc, segs, nsegs);

		for (j = 0; j < nsegs; j++) {
			segs[j].x1 += velocities[j].x1;
			segs[j].y1 += velocities[j].y1;
			segs[j].x2 += velocities[j].x2;
			segs[j].y2 += velocities[j].y2;

			velocities[j].y1 += 2;
			velocities[j].y2 += 2;
		}
	}

	/* release the server */
	XUngrabServer(display);
}

ANIMATION_DECLARE("fall_break", fall_break)
