/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved              *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: main.cpp,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <ctype.h>
#include <fx.h>
#include <FXThread.h>
#include <FXGUISignal.h>

extern "C" {
#include <ogle/dvd.h>
#include <ogle/dvdcontrol.h>
}

#include "dvdapp.h"
#include "dvdnav.h"
#include "dvdwindow.h"

FXGUISignal * dvdguiobject;

extern int zoommode;


int main(int argc,char *argv[]){

  if (fxversion[0]==1 && (fxversion[1]==6) ) { /// Test for Stable Version of FOX 1.6
    if (FOX_MAJOR!=fxversion[0] || FOX_MINOR!=fxversion[1]){
      fxwarning("FOX Header (v%d.%d.%d) / Library (v%d.%d.%d) mismatch!  -\n",FOX_MAJOR,FOX_MINOR,FOX_LEVEL,fxversion[0],fxversion[1],fxversion[2]);
      return 1;
      }
    }   
  else if (fxversion[0]==1 && ( fxversion[1]==7)) { /// Test for Development version of FOX 1.7 
    if (FOX_MAJOR!=fxversion[0] || FOX_MINOR!=fxversion[1] || FOX_LEVEL!=fxversion[2]) {
      fxwarning("FOX Header (v%d.%d.%d) / Library (v%d.%d.%d) mismatch!  -\n",FOX_MAJOR,FOX_MINOR,FOX_LEVEL,fxversion[0],fxversion[1],fxversion[2]);
      return 1;
      }
    }
  else {
    fxwarning("Goggles linked to a unknown/unsupported version of the FOX Library (v%d.%d.%d)",fxversion[0],fxversion[1],fxversion[2]);
    }

  if (argc==1){
    fxwarning("Do not start goggles_gui directly. Use goggles instead.\n");
    return 0;
    }

  // Make application
  DVDApp application;

  //Init application... get rid of fox specific flags
  application.init(argc,argv);

#ifdef HAVE_NEWOGLEAPI
  FXchar * msgqid = argv[2];
#else  
  FXuint msgqid = atoi(argv[2]);
#endif

  DVDNav_t * navigator=NULL;

  if(DVDOpenNav(&navigator,msgqid)!=DVD_E_Ok){
    fxwarning("Unable to open OGLE!\n");
    return 0;
    }
  // Make window
  DVDWindow* window=new DVDWindow(&application);

  FXGUISignal guisignal(&application,window);
  dvdguiobject=&guisignal;

  // Handle interrupt to save stuff nicely
  application.addSignal(SIGINT,window,DVDWindow::ID_QUIT);

  window->setNavigator(navigator);

  // Create it
  application.create();

  DVDNavigator dvdnavthread;
  if (!dvdnavthread.init(msgqid)) return 0;


  // Run
  return application.run();
  }




