/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvddxr3.h,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/
#ifdef HAVE_DXR3

#ifndef DVDDXR3_H
#define DVDDXR3_H

class FXDXR3 : public FXObject{
FXDECLARE(FXDXR3)
private:
  int      fd;
  FXString device;
  int      device_audio_mode;
public:
  long onCmdSwitchDevice(FXObject*,FXSelector,void*);
  long onCmdAudioModeAnalog(FXObject*,FXSelector,void*);
  long onCmdAudioModeDigital(FXObject*,FXSelector,void*);
  long onCmdAudioModeAC3(FXObject*,FXSelector,void*);
  long onUpdAudioModeAnalog(FXObject*,FXSelector,void*);
  long onUpdAudioModeDigital(FXObject*,FXSelector,void*);
  long onUpdAudioModeAC3(FXObject*,FXSelector,void*);
public:
  enum{
    ID_DEVICESELECT,
    ID_AUDIOMODE_AC3,
    ID_AUDIOMODE_DIGITALPCM,
    ID_AUDIOMODE_ANALOG,
    };
public:
  FXDXR3();
  FXDXR3(const FXString & device);
  ~FXDXR3();

  void setDevice(const FXString & device);


  FXbool  init();
  FXbool  isInitialized();

  FXbool  setAudioMode(FXint mode);
  FXint   getAudioMode();
/*  FXbool  setVideoMode(FXint mode);
  FXint   getVideoMode();
  FXbool  setVideoBCS(FXint & b,FXint & c,FXint & s);
  FXbool  getVideoBCS(FXint & b,FXint & c,FXint & s);
*/
  };


#endif


#endif
