# Change Log

## [v0.20.0](https://github.com/go-swagger/go-swagger/tree/v0.20.0) (2019-08-18)
[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.19.0...v0.20.0)

**Implemented enhancements:**

- How To mark route deprecated? [\#2042](https://github.com/go-swagger/go-swagger/issues/2042)
- Pass OAuth2 scheme name to handler and add it on the request context [\#2041](https://github.com/go-swagger/go-swagger/issues/2041)
- Add `Payload\(\) \*models.TheError` to error types [\#2018](https://github.com/go-swagger/go-swagger/issues/2018)
- Use first tag for client package [\#1950](https://github.com/go-swagger/go-swagger/issues/1950)
- Add support for types of the new mongo-go-driver [\#1854](https://github.com/go-swagger/go-swagger/issues/1854)
- Bug or new logic to generate code with --with-flatten=minimal - by default ? [\#1704](https://github.com/go-swagger/go-swagger/issues/1704)
- Support for integer enums in go-swagger [\#1672](https://github.com/go-swagger/go-swagger/issues/1672)
- File parameter generated incorrectly in client code [\#1020](https://github.com/go-swagger/go-swagger/issues/1020)
- Add a diff command [\#151](https://github.com/go-swagger/go-swagger/issues/151)
- Keep object's parameters order as specified in swagger spec definition [\#125](https://github.com/go-swagger/go-swagger/issues/125)

**Fixed bugs:**

- unknown type for field interface{}: \*types.Interface [\#2011](https://github.com/go-swagger/go-swagger/issues/2011)
- Unknown type for field: \*types.Map [\#2007](https://github.com/go-swagger/go-swagger/issues/2007)
- New scanner \(go module aware\) may randomly fail [\#1997](https://github.com/go-swagger/go-swagger/issues/1997)
- Server crashes when polymorphic value is absent in post body [\#1993](https://github.com/go-swagger/go-swagger/issues/1993)
- Mixin host issue [\#1965](https://github.com/go-swagger/go-swagger/issues/1965)
- Two different parameter names derived from specification [\#1952](https://github.com/go-swagger/go-swagger/issues/1952)
- Swagger generates and uses different models in case of definition name starts with Digit [\#1937](https://github.com/go-swagger/go-swagger/issues/1937)
- Generating uncompilable code when response code \>= 512 [\#1893](https://github.com/go-swagger/go-swagger/issues/1893)
- swagger mixin bug [\#1886](https://github.com/go-swagger/go-swagger/issues/1886)
- swagger mixin sends all output to stderr [\#1878](https://github.com/go-swagger/go-swagger/issues/1878)
- Why is docker image "latest" NOT aligned with the latest tag? [\#1873](https://github.com/go-swagger/go-swagger/issues/1873)
- Duplicate constants when referencing definitions with enums in another files [\#1851](https://github.com/go-swagger/go-swagger/issues/1851)
- swagger generate spec throws a lot of errors with golang 1.11 [\#1671](https://github.com/go-swagger/go-swagger/issues/1671)
- panic: interface conversion: interface {} is \*mypackage.PostActionsDefault, not \*mypackage.PostActionsCreated [\#1518](https://github.com/go-swagger/go-swagger/issues/1518)
- Client parameters don't set body when model is an interface [\#1490](https://github.com/go-swagger/go-swagger/issues/1490)
- Generated client parameter does not set request body for schema type string format binary [\#1339](https://github.com/go-swagger/go-swagger/issues/1339)
- Client Request Parameters - lint error [\#973](https://github.com/go-swagger/go-swagger/issues/973)

**Closed issues:**

- swagger failed to validate type: file in formData parameters. [\#2039](https://github.com/go-swagger/go-swagger/issues/2039)
- stratoscale client template breaks on multiline descriptions [\#2036](https://github.com/go-swagger/go-swagger/issues/2036)
- No useful documentation exists for spec generation [\#2032](https://github.com/go-swagger/go-swagger/issues/2032)
- swagger:strfmt annotation incompatible with slice type [\#2030](https://github.com/go-swagger/go-swagger/issues/2030)
- Can go-swagger support this json tag? Id int64 "json:id,string"? [\#2029](https://github.com/go-swagger/go-swagger/issues/2029)
- int64  "json:id,string" [\#2028](https://github.com/go-swagger/go-swagger/issues/2028)
- go1.11 generate spec doesn't respect exclude [\#2023](https://github.com/go-swagger/go-swagger/issues/2023)
- Cannot use dynamic certificate selection on servers [\#2016](https://github.com/go-swagger/go-swagger/issues/2016)
- unknown flag `b' swagger generate [\#2005](https://github.com/go-swagger/go-swagger/issues/2005)
- Swagger generate spec has broken on Gitea [\#2001](https://github.com/go-swagger/go-swagger/issues/2001)
- swagger:ignore not working [\#1994](https://github.com/go-swagger/go-swagger/issues/1994)
- Getting started guide [\#1989](https://github.com/go-swagger/go-swagger/issues/1989)
- Working with `type: object` in handlers [\#1967](https://github.com/go-swagger/go-swagger/issues/1967)
- Generated and customized go-swagger server compiles, executes and initializes correctly, but does not handle any requests [\#1953](https://github.com/go-swagger/go-swagger/issues/1953)
- Query parameter can't be named 'append' when enum appearing also [\#1948](https://github.com/go-swagger/go-swagger/issues/1948)
- generate spec  with ordered keys [\#1946](https://github.com/go-swagger/go-swagger/issues/1946)
- Generate property with empty string \(''\) [\#1945](https://github.com/go-swagger/go-swagger/issues/1945)
- Unable to deserialize array int  json: cannot unmarshal string into Go struct. Failed due to array having integer and string. Fix in comments [\#1932](https://github.com/go-swagger/go-swagger/issues/1932)
- How do I access the response headers? [\#1918](https://github.com/go-swagger/go-swagger/issues/1918)
- POSTing to API that returns a 201 with a location header produces: \(\*interface {}\) is not supported by the TextConsumer, can be resolved by supporting TextUnmarshaler interface" [\#1917](https://github.com/go-swagger/go-swagger/issues/1917)
- Response struct goes under headers [\#1908](https://github.com/go-swagger/go-swagger/issues/1908)
- dep ensure -v report models is missing [\#1835](https://github.com/go-swagger/go-swagger/issues/1835)
- Installing with go get and go modules = on [\#1786](https://github.com/go-swagger/go-swagger/issues/1786)
- Swagger generate: can not import package [\#1784](https://github.com/go-swagger/go-swagger/issues/1784)
- It can not stop with recursive struct [\#1773](https://github.com/go-swagger/go-swagger/issues/1773)
- Basic auth in stratoscale templates  [\#1765](https://github.com/go-swagger/go-swagger/issues/1765)
- Generate spec does not work with Go Modules [\#1681](https://github.com/go-swagger/go-swagger/issues/1681)

**Merged pull requests:**

- update examples [\#2049](https://github.com/go-swagger/go-swagger/pull/2049) ([casualjim](https://github.com/casualjim))
- update builder template to pass along oauth2 scheme name [\#2048](https://github.com/go-swagger/go-swagger/pull/2048) ([casualjim](https://github.com/casualjim))
- Add docs and test coverage for route deprecated property [\#2047](https://github.com/go-swagger/go-swagger/pull/2047) ([MetalRex101](https://github.com/MetalRex101))
- spec generation: added support for deprecated tag in route annotations [\#2045](https://github.com/go-swagger/go-swagger/pull/2045) ([fredbi](https://github.com/fredbi))
- Add support for --strict-additional-properties [\#2040](https://github.com/go-swagger/go-swagger/pull/2040) ([connesc](https://github.com/connesc))
- Fix multi-line comments in stratoscale client template [\#2037](https://github.com/go-swagger/go-swagger/pull/2037) ([avorima](https://github.com/avorima))
- fix:walkImports should recursively traverse the imported package [\#2034](https://github.com/go-swagger/go-swagger/pull/2034) ([d0ngw](https://github.com/d0ngw))
- Fixed template\_layout type-o [\#2033](https://github.com/go-swagger/go-swagger/pull/2033) ([delaman](https://github.com/delaman))
- fixes detecting base64 for \[\]byte [\#2031](https://github.com/go-swagger/go-swagger/pull/2031) ([casualjim](https://github.com/casualjim))
- fix typo and add more parser tests [\#2025](https://github.com/go-swagger/go-swagger/pull/2025) ([gregdhill](https://github.com/gregdhill))
- enable explicit gen spec inclusion / exclusion or for all deps [\#2024](https://github.com/go-swagger/go-swagger/pull/2024) ([gregdhill](https://github.com/gregdhill))
- Add method `Payload\(\)` to error types [\#2019](https://github.com/go-swagger/go-swagger/pull/2019) ([aeneasr](https://github.com/aeneasr))
- 2016 - Allow dynamic TLS configurations in servers [\#2017](https://github.com/go-swagger/go-swagger/pull/2017) ([mmussomele](https://github.com/mmussomele))
- also consider interface as valid body for response and request [\#2012](https://github.com/go-swagger/go-swagger/pull/2012) ([casualjim](https://github.com/casualjim))
- consider maps as valid body for response and parameter [\#2010](https://github.com/go-swagger/go-swagger/pull/2010) ([casualjim](https://github.com/casualjim))
- disable -race for testing phase, but allow for PR \#1944 to use -race [\#2008](https://github.com/go-swagger/go-swagger/pull/2008) ([casualjim](https://github.com/casualjim))
- skip fields when they are not exported [\#2006](https://github.com/go-swagger/go-swagger/pull/2006) ([casualjim](https://github.com/casualjim))
- refactor circleci build [\#2004](https://github.com/go-swagger/go-swagger/pull/2004) ([casualjim](https://github.com/casualjim))
- use slices for collecting parameters to retain ordering [\#2003](https://github.com/go-swagger/go-swagger/pull/2003) ([casualjim](https://github.com/casualjim))
- updated dependencies [\#1999](https://github.com/go-swagger/go-swagger/pull/1999) ([fredbi](https://github.com/fredbi))
- Codegen edges cases [\#1998](https://github.com/go-swagger/go-swagger/pull/1998) ([fredbi](https://github.com/fredbi))
- Model validation/polymorphism: added required / non required check [\#1996](https://github.com/go-swagger/go-swagger/pull/1996) ([fredbi](https://github.com/fredbi))
- Set govet again [\#1995](https://github.com/go-swagger/go-swagger/pull/1995) ([fredbi](https://github.com/fredbi))
- Go module aware scan [\#1991](https://github.com/go-swagger/go-swagger/pull/1991) ([casualjim](https://github.com/casualjim))
- feat: Add getting started section to docs/use/spec.md [\#1990](https://github.com/go-swagger/go-swagger/pull/1990) ([pdrum](https://github.com/pdrum))
- Integrates flatten fixes [\#1986](https://github.com/go-swagger/go-swagger/pull/1986) ([fredbi](https://github.com/fredbi))
- Honour JSON ,string directive of ptr field when generating spec [\#1985](https://github.com/go-swagger/go-swagger/pull/1985) ([wych42](https://github.com/wych42))
- ci: made codegen-nonreg.sh script less sensitive to merge conflicts [\#1983](https://github.com/go-swagger/go-swagger/pull/1983) ([fredbi](https://github.com/fredbi))
- fixed push latest tag on releases [\#1982](https://github.com/go-swagger/go-swagger/pull/1982) ([fredbi](https://github.com/fredbi))
- Added support for non-standard http codes [\#1980](https://github.com/go-swagger/go-swagger/pull/1980) ([fredbi](https://github.com/fredbi))
- Fix 1878 [\#1979](https://github.com/go-swagger/go-swagger/pull/1979) ([fredbi](https://github.com/fredbi))
- Generated client: handles unexpected successful responses [\#1978](https://github.com/go-swagger/go-swagger/pull/1978) ([fredbi](https://github.com/fredbi))
- acknowledge various fixes for client [\#1977](https://github.com/go-swagger/go-swagger/pull/1977) ([fredbi](https://github.com/fredbi))
- chore\(ci\): set codecov patch expectation to a fixed level [\#1976](https://github.com/go-swagger/go-swagger/pull/1976) ([fredbi](https://github.com/fredbi))
- fix\(server\): generates server to enable http/2 [\#1975](https://github.com/go-swagger/go-swagger/pull/1975) ([fredbi](https://github.com/fredbi))
- Fix basic auth for stratoscale template [\#1969](https://github.com/go-swagger/go-swagger/pull/1969) ([JoakimSoderberg](https://github.com/JoakimSoderberg))
- keep spec order on nested objects [\#1968](https://github.com/go-swagger/go-swagger/pull/1968) ([efi-tectonic](https://github.com/efi-tectonic))
- Multiple tags operations: deduce package from first tag [\#1964](https://github.com/go-swagger/go-swagger/pull/1964) ([maxatome](https://github.com/maxatome))
- Add CodeTriage badge to go-swagger/go-swagger [\#1963](https://github.com/go-swagger/go-swagger/pull/1963) ([codetriage-readme-bot](https://github.com/codetriage-readme-bot))
- do not force set the api logger to log.Printf [\#1962](https://github.com/go-swagger/go-swagger/pull/1962) ([djgilcrease](https://github.com/djgilcrease))
- 151 add a diff sub command [\#1961](https://github.com/go-swagger/go-swagger/pull/1961) ([wjase](https://github.com/wjase))
- scan: proper parse for numeric elements \(future validation pass\) [\#1959](https://github.com/go-swagger/go-swagger/pull/1959) ([d7561985](https://github.com/d7561985))
- urlbuilder template fixed to support query params named 'append' [\#1949](https://github.com/go-swagger/go-swagger/pull/1949) ([jimturnquist](https://github.com/jimturnquist))
- support keep spec properties order [\#1939](https://github.com/go-swagger/go-swagger/pull/1939) ([efi-tectonic](https://github.com/efi-tectonic))
- x-go-type: if no imports are specified, assume that the referred type is inside the same package [\#1935](https://github.com/go-swagger/go-swagger/pull/1935) ([e-nikolov](https://github.com/e-nikolov))
- Fix access\_token typo [\#1926](https://github.com/go-swagger/go-swagger/pull/1926) ([bithavoc](https://github.com/bithavoc))

\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
