/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(pdu.h)                                                     */
/* BINDTOOL_HEADER_FILE_HASH(a347d61f9dff47c4bfcc26d89ad69a0c)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/pdu.h>
// pydoc.h is automatically generated in the build directory
#include <pdu_pydoc.h>

void bind_pdu(py::module& m)
{

    py::module m_types = m.def_submodule("types");

    py::enum_<::gr::types::vector_type>(m_types, "vector_type")
        .value("byte_t", ::gr::types::byte_t)       // 0
        .value("short_t", ::gr::types::short_t)     // 1
        .value("int_t", ::gr::types::int_t)         // 2
        .value("float_t", ::gr::types::float_t)     // 3
        .value("complex_t", ::gr::types::complex_t) // 4
        .export_values();

    py::implicitly_convertible<int, ::gr::types::vector_type>();


    py::module m_metadata_keys = m.def_submodule("metadata_keys");

    m_metadata_keys.def(
        "pdu_num", &::gr::metadata_keys::pdu_num, D(metadata_keys, pdu_num));

    m_metadata_keys.def(
        "rx_time", &::gr::metadata_keys::rx_time, D(metadata_keys, rx_time));

    m_metadata_keys.def(
        "sample_rate", &::gr::metadata_keys::sample_rate, D(metadata_keys, sample_rate));

    m_metadata_keys.def(
        "sys_time", &::gr::metadata_keys::sys_time, D(metadata_keys, sys_time));

    m_metadata_keys.def("tx_eob", &::gr::metadata_keys::tx_eob, D(metadata_keys, tx_eob));

    m_metadata_keys.def(
        "tx_time", &::gr::metadata_keys::tx_time, D(metadata_keys, tx_time));

    m_metadata_keys.def("tx_sob", &::gr::metadata_keys::tx_sob, D(metadata_keys, tx_sob));


    py::module m_msgport_names = m.def_submodule("msgport_names");

    m_msgport_names.def("bpdu", &::gr::msgport_names::bpdu, D(msgport_names, bpdu));


    m_msgport_names.def("conf", &::gr::msgport_names::conf, D(msgport_names, conf));


    m_msgport_names.def("cpdu", &::gr::msgport_names::cpdu, D(msgport_names, cpdu));


    m_msgport_names.def(
        "detects", &::gr::msgport_names::detects, D(msgport_names, detects));


    m_msgport_names.def("dict", &::gr::msgport_names::dict, D(msgport_names, dict));


    m_msgport_names.def("fpdu", &::gr::msgport_names::fpdu, D(msgport_names, fpdu));


    m_msgport_names.def("msg", &::gr::msgport_names::msg, D(msgport_names, msg));


    m_msgport_names.def("pdu", &::gr::msgport_names::pdu, D(msgport_names, pdu));


    m_msgport_names.def("pdus", &::gr::msgport_names::pdus, D(msgport_names, pdus));


    m_msgport_names.def("vec", &::gr::msgport_names::vec, D(msgport_names, vec));


    py::module m_pdu = m.def_submodule("pdu");

    m_pdu.def("itemsize", &::gr::pdu::itemsize, py::arg("type"), D(pdu, itemsize));


    m_pdu.def("type_matches",
              &::gr::pdu::type_matches,
              py::arg("type"),
              py::arg("v"),
              D(pdu, type_matches));


    m_pdu.def("make_pdu_vector",
              &::gr::pdu::make_pdu_vector,
              py::arg("type"),
              py::arg("buf"),
              py::arg("items"),
              D(pdu, make_pdu_vector));


    m_pdu.def("type_from_pmt",
              &::gr::pdu::type_from_pmt,
              py::arg("vector"),
              D(pdu, type_from_pmt));
}
