/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse vrparse
#define yylex   vrlex
#define yyerror vrerror
#define yylval  vrlval
#define yychar  vrchar
#define yydebug vrdebug
#define yynerrs vrnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENT = 258,
     INTEGER = 259,
     DOUBLE = 260,
     CONSTANT = 261,
     STRING = 262,
     KWMODULE = 263,
     KWENDMODULE = 264,
     KWINPUT = 265,
     KWOUTPUT = 266,
     KWWIRE = 267,
     KWINOUT = 268,
     KWASSIGN = 269,
     KWPARAMETER = 270,
     KWDEFPARAM = 271
   };
#endif
#define IDENT 258
#define INTEGER 259
#define DOUBLE 260
#define CONSTANT 261
#define STRING 262
#define KWMODULE 263
#define KWENDMODULE 264
#define KWINPUT 265
#define KWOUTPUT 266
#define KWWIRE 267
#define KWINOUT 268
#define KWASSIGN 269
#define KWPARAMETER 270
#define KWDEFPARAM 271




/* Copy the first part of user declarations.  */
#line 19 "../verilog/vrparse.y"


#include "stdlib.h"
#include "vr.h"

static dbNetlist vrCurrentNetlist;
static bool vrIsBus;
static U32 vrLeftRange, vrRightRange;
static dbDirection vrMportType;
static vrIdec vrCurrentIdec;
static vrParam vrCurrentParam;
static vrDefparam vrCurrentDefparam;

/*--------------------------------------------------------------------------------------------------
  Build a simple assignment to a single net.
--------------------------------------------------------------------------------------------------*/
static void buildJoin(
    dbNet dest,
    dbNet source)
{
    if(source == dest) {
        vrerror("assignment of signal to itself on signal %s", dbNetGetName(source));
    }
    dbJoinNets(source, dest);
}

/*--------------------------------------------------------------------------------------------------
  Just look-up the net, and give an error if not found.
--------------------------------------------------------------------------------------------------*/
static dbNet findNet(
    utSym sym)
{
    dbNet net = dbNetlistFindNet(vrCurrentNetlist, sym);

    if(net == dbNetNull) {
        vrerror("Net %s not defined", utSymGetName(sym));
    }
    return net;
}

/*--------------------------------------------------------------------------------------------------
  Build a simple assignment from a net to a net.
--------------------------------------------------------------------------------------------------*/
static dbNet findConstantNet(
    U32 value)
{
    if(value == 0) {
        return dbNetlistGetZeroNet(vrCurrentNetlist);
    } else if(value == 1) {
        return dbNetlistGetOneNet(vrCurrentNetlist);
    } else {
        vrerror("Only 0 and 1 integer values currently supported");
    }
    return dbNetNull; /* Dummy return */
}

/*--------------------------------------------------------------------------------------------------
  Declare a signal
--------------------------------------------------------------------------------------------------*/
static void declareSignal(
    dbNetlist netlist,
    utSym sym,
    bool isBus,
    U32 left,
    U32 right,
    dbMportType type)
{
    dbMport mport = dbNetlistFindMport(netlist, sym);
    dbBus bus;
    dbMbus mbus;
    dbNet net;
    dbInst flag;

    if(!isBus) {
        if(type != DB_NODIR || dbNetlistFindNet(netlist, sym) == dbNetNull) {
            net = dbNetCreate(netlist, sym);
            if(mport != dbMportNull) {
                dbMportSetType(mport, type);
                flag = dbFlagInstCreate(mport);
                dbNetAppendPort(net, dbInstGetfirstPort(flag));
            }
            if(mport == dbMportNull && type != DB_NODIR) {
                vrerror("Net %s not declared in I/O list for module %s",
                        utSymGetName(sym), dbNetlistGetName(netlist));
            } else if(mport != dbMportNull && type == DB_NODIR) {
                vrerror("I/O net %s declared as wire in module %s",
                        utSymGetName(sym), dbNetlistGetName(netlist));
            }
        }
    } else {
        if(type != DB_NODIR || dbNetlistFindBus(netlist, sym) == dbBusNull) {
            bus = dbBusCreate(netlist, sym, left, right);
            if(mport != dbMportNull) {
                mbus = dbMbusCreate(netlist, sym, type, left, right);
                dbMportDestroy(mport);
                flag = dbBusFlagInstCreate(mbus);
                dbBusHookup(bus, dbInstGetfirstPort(flag));
            }
        }
    }
}

/*--------------------------------------------------------------------------------------------------
  Build a connection.
--------------------------------------------------------------------------------------------------*/
static vrConn vrConnCreate(
    vrParam oParam,
    utSym sym, 
    bool hasRange,
    U32 left,
    U32 right,
    bool isConst,
    U32 length,
    U32 mask)
{
    dbBus bus;
    dbNet net;
    vrConn conn = vrConnAlloc();

    if(sym != utSymNull) {
        bus = dbNetlistFindBus(vrCurrentNetlist, sym);
        vrConnSetBus(conn, bus);
        if(bus == dbBusNull) {
            if(hasRange) {
                vrerror("Indexed scalar signal %s", utSymGetName(sym));
            }
            net = dbNetlistFindNet(vrCurrentNetlist, sym);
            if(net == dbNetNull) {
                declareSignal(vrCurrentNetlist, sym, false, 0, 0, DB_NODIR);
                net = dbNetlistFindNet(vrCurrentNetlist, sym);
                utAssert(net != dbNetNull);
            }
            vrConnSetNet(conn, net);
        }
    } else {
        utAssert(isConst);
    }
    vrParamAppendConn(oParam, conn);
    vrConnSetRange(conn, hasRange);
    vrConnSetLeft(conn, left);
    vrConnSetRight(conn, right);
    vrConnSetConst(conn, isConst);
    vrConnSetLength(conn, length);
    vrConnSetMask(conn, mask);
    return conn;
}

/*--------------------------------------------------------------------------------------------------
  Provide yyerror function capability.
--------------------------------------------------------------------------------------------------*/
void vrerror(
    char *message,
    ...)
{
    char *buff;
    va_list ap;

    va_start(ap, message);
    buff = utVsprintf(message, ap);
    va_end(ap);
    utError("Line %d, token \"%s\": %s", vrLineNum, vrtext, buff);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 184 "../verilog/vrparse.y"
typedef union YYSTYPE {
    utSym symVal, stringVal;
    U32 intVal;
    double doubleVal;
    struct {
        U32 mask;
        U8 length;
    } constVal;
    dbNet netVal;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 293 "../verilog/vrparse.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 305 "../verilog/vrparse.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   80

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  28
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  36
/* YYNRULES -- Number of rules. */
#define YYNRULES  67
/* YYNRULES -- Number of states. */
#define YYNSTATES  113

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   271

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      17,    18,     2,     2,    20,     2,    25,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    23,    19,
       2,    21,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    22,     2,    24,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    26,     2,    27,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    18,    21,    22,    24,
      26,    30,    31,    34,    38,    42,    44,    48,    50,    54,
      56,    58,    60,    62,    65,    68,    71,    74,    75,    77,
      83,    85,    89,    91,    92,    95,    97,    99,   101,   105,
     107,   111,   118,   119,   121,   125,   131,   134,   135,   137,
     139,   143,   148,   151,   152,   154,   158,   160,   164,   166,
     169,   174,   176,   182,   184,   186,   188,   190
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      29,     0,    -1,    30,    -1,    -1,    30,    31,    -1,    32,
      17,    33,    18,    19,    35,    45,     9,    -1,     8,     3,
      -1,    -1,    34,    -1,     3,    -1,    34,    20,     3,    -1,
      -1,    35,    36,    -1,    40,    43,    19,    -1,    15,    37,
      19,    -1,    38,    -1,    37,    20,    38,    -1,     3,    -1,
       3,    21,    39,    -1,     3,    -1,     4,    -1,     5,    -1,
       7,    -1,    10,    41,    -1,    11,    41,    -1,    13,    41,
      -1,    12,    41,    -1,    -1,    42,    -1,    22,     4,    23,
       4,    24,    -1,    44,    -1,    43,    20,    44,    -1,     3,
      -1,    -1,    45,    46,    -1,    52,    -1,    61,    -1,    47,
      -1,    16,    48,    19,    -1,    49,    -1,    48,    20,    49,
      -1,    50,    51,    25,     3,    21,    39,    -1,    -1,     3,
      -1,    51,    25,     3,    -1,    53,    17,    54,    18,    19,
      -1,     3,     3,    -1,    -1,    55,    -1,    56,    -1,    54,
      20,    56,    -1,    57,    17,    58,    18,    -1,    25,     3,
      -1,    -1,    60,    -1,    26,    59,    27,    -1,    60,    -1,
      59,    20,    60,    -1,     3,    -1,     3,    42,    -1,     3,
      22,     4,    24,    -1,     6,    -1,    14,    63,    21,    62,
      19,    -1,    63,    -1,     4,    -1,     6,    -1,     3,    -1,
       3,    22,     4,    24,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   209,   209,   213,   214,   217,   220,   225,   226,   229,
     231,   235,   236,   239,   240,   243,   244,   247,   249,   253,
     255,   257,   259,   263,   265,   267,   269,   274,   275,   279,
     284,   285,   288,   292,   293,   296,   297,   298,   301,   304,
     305,   308,   314,   318,   322,   328,   331,   339,   340,   343,
     344,   347,   350,   356,   357,   358,   361,   362,   365,   367,
     369,   371,   375,   379,   380,   382,   386,   388
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENT", "INTEGER", "DOUBLE", "CONSTANT",
  "STRING", "KWMODULE", "KWENDMODULE", "KWINPUT", "KWOUTPUT", "KWWIRE",
  "KWINOUT", "KWASSIGN", "KWPARAMETER", "KWDEFPARAM", "'('", "')'", "';'",
  "','", "'='", "'['", "':'", "']'", "'.'", "'{'", "'}'", "$accept",
  "goal", "modules", "module", "moduleHeader", "ioList", "ioList2",
  "declarations", "declaration", "parameters", "parameter", "value",
  "type", "optRange", "range", "signalList", "signalDef", "statements",
  "statement", "defparamStatement", "defparams", "defparam", "startParam",
  "paramPath", "instance", "instanceHeader", "instParams", "instParams2",
  "instParam", "instParamHeader", "paramConnection", "connectionList",
  "connection", "assignment", "signal", "lSignal", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,    40,    41,    59,
      44,    61,    91,    58,    93,    46,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    28,    29,    30,    30,    31,    32,    33,    33,    34,
      34,    35,    35,    36,    36,    37,    37,    38,    38,    39,
      39,    39,    39,    40,    40,    40,    40,    41,    41,    42,
      43,    43,    44,    45,    45,    46,    46,    46,    47,    48,
      48,    49,    50,    51,    51,    52,    53,    54,    54,    55,
      55,    56,    57,    58,    58,    58,    59,    59,    60,    60,
      60,    60,    61,    62,    62,    62,    63,    63
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     8,     2,     0,     1,     1,
       3,     0,     2,     3,     3,     1,     3,     1,     3,     1,
       1,     1,     1,     2,     2,     2,     2,     0,     1,     5,
       1,     3,     1,     0,     2,     1,     1,     1,     3,     1,
       3,     6,     0,     1,     3,     5,     2,     0,     1,     1,
       3,     4,     2,     0,     1,     3,     1,     3,     1,     2,
       4,     1,     5,     1,     1,     1,     1,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       3,     0,     2,     1,     0,     4,     0,     6,     7,     9,
       0,     8,     0,     0,    11,    10,    33,    27,    27,    27,
      27,     0,    12,     0,     0,     0,    23,    28,    24,    26,
      25,    17,     0,    15,    32,     0,    30,     0,     5,     0,
      42,    34,    37,    35,     0,    36,     0,     0,    14,     0,
      13,     0,    46,    66,     0,     0,    39,     0,    47,     0,
      19,    20,    21,    22,    18,    16,    31,     0,     0,    38,
      42,    43,     0,     0,     0,    48,    49,     0,     0,     0,
      64,    65,     0,    63,    40,     0,    52,     0,     0,    53,
      29,    67,    62,    44,    45,    50,    58,    61,     0,     0,
      54,     0,     0,    59,     0,    56,    51,    41,     0,     0,
      55,    60,    57
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     1,     2,     5,     6,    10,    11,    16,    22,    32,
      33,    64,    23,    26,    27,    35,    36,    24,    41,    42,
      55,    56,    57,    72,    43,    44,    74,    75,    76,    77,
      99,   104,   100,    45,    82,    54
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -97
static const yysigned_char yypact[] =
{
     -97,    27,    13,   -97,    30,   -97,    23,   -97,    32,   -97,
      25,    24,    26,    43,   -97,   -97,     5,    28,    28,    28,
      28,    44,   -97,    45,    -2,    47,   -97,   -97,   -97,   -97,
     -97,    31,   -10,   -97,   -97,    17,   -97,    46,   -97,    50,
     -97,   -97,   -97,   -97,    37,   -97,    33,    21,   -97,    44,
     -97,    45,   -97,    35,    34,    19,   -97,    55,    36,    56,
     -97,   -97,   -97,   -97,   -97,   -97,   -97,    58,     2,   -97,
     -97,   -97,    38,    61,    14,   -97,   -97,    42,    41,    48,
     -97,   -97,    49,   -97,   -97,    63,   -97,    51,    36,    -3,
     -97,   -97,   -97,    52,   -97,   -97,    53,   -97,    16,    59,
     -97,    21,    65,   -97,   -16,   -97,   -97,   -97,    18,    16,
     -97,   -97,   -97
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,
      22,   -34,   -97,    11,   -22,   -97,    29,   -97,   -97,   -97,
     -97,     6,   -97,   -97,   -97,   -97,   -97,   -97,    -9,   -97,
     -97,   -97,   -96,   -97,   -97,    10
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      96,    37,   105,    97,   109,    53,    80,    38,    81,    48,
      49,   110,    39,   112,    40,    17,    18,    19,    20,    96,
      21,     4,    97,    98,    60,    61,    62,     3,    63,    28,
      29,    30,    87,     7,    88,     9,    50,    51,    69,    70,
       8,    59,   111,    12,    13,    14,    15,    31,    34,    52,
      25,    46,    47,    53,    58,    68,    59,    67,    71,    89,
      78,    73,    79,    85,    86,    90,    93,   107,    92,   108,
      94,    65,    91,   101,   103,   102,    84,   106,    83,    95,
      66
};

static const unsigned char yycheck[] =
{
       3,     3,    98,     6,    20,     3,     4,     9,     6,    19,
      20,    27,    14,   109,    16,    10,    11,    12,    13,     3,
      15,     8,     6,    26,     3,     4,     5,     0,     7,    18,
      19,    20,    18,     3,    20,     3,    19,    20,    19,    20,
      17,    23,    24,    18,    20,    19,     3,     3,     3,     3,
      22,     4,    21,     3,    17,    21,    23,    22,     3,    17,
       4,    25,     4,    25,     3,    24,     3,   101,    19,     4,
      19,    49,    24,    21,    96,    22,    70,    18,    68,    88,
      51
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    29,    30,     0,     8,    31,    32,     3,    17,     3,
      33,    34,    18,    20,    19,     3,    35,    10,    11,    12,
      13,    15,    36,    40,    45,    22,    41,    42,    41,    41,
      41,     3,    37,    38,     3,    43,    44,     3,     9,    14,
      16,    46,    47,    52,    53,    61,     4,    21,    19,    20,
      19,    20,     3,     3,    63,    48,    49,    50,    17,    23,
       3,     4,     5,     7,    39,    38,    44,    22,    21,    19,
      20,     3,    51,    25,    54,    55,    56,    57,     4,     4,
       4,     6,    62,    63,    49,    25,     3,    18,    20,    17,
      24,    24,    19,     3,    19,    56,     3,     6,    26,    58,
      60,    21,    22,    42,    59,    60,    18,    39,     4,    20,
      27,    24,    60
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 210 "../verilog/vrparse.y"
    { dbDesignSetRootNetlist(vrCurrentDesign, vrCurrentNetlist); ;}
    break;

  case 6:
#line 221 "../verilog/vrparse.y"
    { vrNetlist netlist = vrNetlistCreate(vrCurrentDesign, yyvsp[0].symVal);
  vrCurrentNetlist = vrNetlistSuper(netlist); ;}
    break;

  case 9:
#line 230 "../verilog/vrparse.y"
    { dbMportCreate(vrCurrentNetlist, yyvsp[0].symVal, DB_IN); ;}
    break;

  case 10:
#line 232 "../verilog/vrparse.y"
    { dbMportCreate(vrCurrentNetlist, yyvsp[0].symVal, DB_IN); ;}
    break;

  case 17:
#line 248 "../verilog/vrparse.y"
    { ; ;}
    break;

  case 18:
#line 250 "../verilog/vrparse.y"
    { dbNetlistSetValue(vrCurrentNetlist, yyvsp[-2].symVal, yyvsp[0].symVal); ;}
    break;

  case 19:
#line 254 "../verilog/vrparse.y"
    { yyval.symVal = yyvsp[0].symVal; ;}
    break;

  case 20:
#line 256 "../verilog/vrparse.y"
    { yyval.symVal = utSymCreateFormatted("%d", yyvsp[0].intVal); ;}
    break;

  case 21:
#line 258 "../verilog/vrparse.y"
    { yyval.symVal = utSymCreateFormatted("%f", yyvsp[0].doubleVal); ;}
    break;

  case 22:
#line 260 "../verilog/vrparse.y"
    { yyval.symVal = yyvsp[0].stringVal; ;}
    break;

  case 23:
#line 264 "../verilog/vrparse.y"
    { vrMportType = DB_IN; ;}
    break;

  case 24:
#line 266 "../verilog/vrparse.y"
    { vrMportType = DB_OUT; ;}
    break;

  case 25:
#line 268 "../verilog/vrparse.y"
    { vrMportType = DB_IO; ;}
    break;

  case 26:
#line 270 "../verilog/vrparse.y"
    { vrMportType = DB_NODIR; ;}
    break;

  case 27:
#line 274 "../verilog/vrparse.y"
    { vrIsBus = false; ;}
    break;

  case 28:
#line 276 "../verilog/vrparse.y"
    { vrIsBus = true; ;}
    break;

  case 29:
#line 280 "../verilog/vrparse.y"
    { vrLeftRange = yyvsp[-3].intVal;
 vrRightRange = yyvsp[-1].intVal; ;}
    break;

  case 32:
#line 289 "../verilog/vrparse.y"
    { declareSignal(vrCurrentNetlist, yyvsp[0].symVal, vrIsBus, vrLeftRange, vrRightRange, vrMportType); ;}
    break;

  case 41:
#line 309 "../verilog/vrparse.y"
    { vrDefparamSetSym(vrCurrentDefparam, yyvsp[-2].symVal);
  vrDefparamSetValue(vrCurrentDefparam, yyvsp[0].symVal); ;}
    break;

  case 42:
#line 314 "../verilog/vrparse.y"
    { vrCurrentDefparam = vrDefparamAlloc();
  vrNetlistInsertDefparam(vrNetlistSub(vrCurrentNetlist), vrCurrentDefparam); ;}
    break;

  case 43:
#line 319 "../verilog/vrparse.y"
    { vrPath path = vrPathAlloc();
  vrPathSetSym(path, yyvsp[0].symVal);
  vrDefparamAppendPath(vrCurrentDefparam, path); ;}
    break;

  case 44:
#line 323 "../verilog/vrparse.y"
    { vrPath path = vrPathAlloc();
  vrPathSetSym(path, yyvsp[0].symVal);
  vrDefparamAppendPath(vrCurrentDefparam, path); ;}
    break;

  case 46:
#line 332 "../verilog/vrparse.y"
    { vrCurrentIdec = vrIdecAlloc();
  vrNetlistAppendIdec(vrNetlistSub(vrCurrentNetlist), vrCurrentIdec);
  vrIdecSetInternalNetlistSym(vrCurrentIdec, yyvsp[-1].symVal);
  vrIdecSetSym(vrCurrentIdec, yyvsp[0].symVal);
  vrIdecSetLineNum(vrCurrentIdec, vrLineNum); ;}
    break;

  case 52:
#line 351 "../verilog/vrparse.y"
    { vrCurrentParam = vrParamAlloc();
  vrParamSetSym(vrCurrentParam, yyvsp[0].symVal);
  vrIdecAppendParam(vrCurrentIdec, vrCurrentParam); ;}
    break;

  case 58:
#line 366 "../verilog/vrparse.y"
    { vrConnCreate(vrCurrentParam, yyvsp[0].symVal, false, 0, 0, false, 0, 0); ;}
    break;

  case 59:
#line 368 "../verilog/vrparse.y"
    { vrConnCreate(vrCurrentParam, yyvsp[-1].symVal, true, vrLeftRange, vrRightRange, false, 0, 0); ;}
    break;

  case 60:
#line 370 "../verilog/vrparse.y"
    { vrConnCreate(vrCurrentParam, yyvsp[-3].symVal, true, yyvsp[-1].intVal, yyvsp[-1].intVal, false, 0, 0); ;}
    break;

  case 61:
#line 372 "../verilog/vrparse.y"
    { vrConnCreate(vrCurrentParam, utSymNull, false, 0, 0, true, yyvsp[0].constVal.length, yyvsp[0].constVal.mask); ;}
    break;

  case 62:
#line 376 "../verilog/vrparse.y"
    { buildJoin(yyvsp[-3].netVal, yyvsp[-1].netVal); ;}
    break;

  case 64:
#line 381 "../verilog/vrparse.y"
    { yyval.netVal = findConstantNet(yyvsp[0].intVal); ;}
    break;

  case 65:
#line 383 "../verilog/vrparse.y"
    { yyval.netVal = findConstantNet(yyvsp[0].constVal.mask); ;}
    break;

  case 66:
#line 387 "../verilog/vrparse.y"
    { yyval.netVal = findNet(yyvsp[0].symVal); ;}
    break;

  case 67:
#line 389 "../verilog/vrparse.y"
    { yyval.netVal = findNet(utSymCreateFormatted("%s[%d]", utSymGetName(yyvsp[-3].symVal), yyvsp[-1].intVal)); ;}
    break;


    }

/* Line 1000 of yacc.c.  */
#line 1463 "../verilog/vrparse.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 392 "../verilog/vrparse.y"


