/*-----------------------------------------------------------------------------
  Module header file for: cir module
-----------------------------------------------------------------------------*/

#ifndef cirddr_H
#define cirddr_H

#ifndef UTIL_H
#include "util.h"
#endif

#ifndef cir_TYPEDEF_H
#include "cirtypedef.h"
#endif

#ifndef dbddr_H
#include "dbddr.h"
#endif

/*-----------------------------------------------------------------------------
    Typedefs, constants, and enums here.
-----------------------------------------------------------------------------*/
typedef struct _cirDevice *cirDevice;
typedef struct _cirPin *cirPin;
typedef struct _cirRoot *cirRoot;
typedef struct _cirAttr *cirAttr;
typedef struct _cirNetlist *cirNetlist;
typedef struct _cirParam *cirParam;

/*----------------------------------------------------------------------------
  Device methods.
----------------------------------------------------------------------------*/
#define cirDeviceNull ((cirDevice)(NULL))
extern cirDevice cirDeviceAlloc(void);
#define _cirDeviceNextFree(Device) (*(cirDevice *)(void *)(Device))
extern void cirDeviceFree(cirDevice Device);
#define cirDeviceGetDestructorHook() (cirDeviceDestructorHook)
#define cirDeviceSetDestructorHook(func) (cirDeviceDestructorHook = (func))
extern void cirDeviceDestroy(cirDevice Device);
#define cirDeviceGetDescription(Device) ((Device)->Description)
#define cirDeviceSetDescription(_Device, value) ((_Device)->Description = (value))
#define cirDeviceInsertPin(Device, _Pin) utInsertHtblEntry(&(Device)->Pins, &(_Pin)->h)
#define cirDeviceRemovePin(Device, _Pin) utDeleteHtblEntry(&(Device)->Pins, &(_Pin)->h)
#define cirDeviceAppendPin(Device, _Pin) utAppendHtblEntry(&(Device)->Pins, &(_Pin)->h)
#define cirDeviceFindPin(Device, name) (cirPin)utqEntryHtblSym(&(Device)->Pins, name)
#define cirDeviceGetnumPins(Device) ((Device)->Pins.count)
#define cirDeviceGetPins(Device) (&(Device)->Pins)
#define cirDeviceGetfirstPin(Device) ((cirPin)(utfHtblEntry(cirDeviceGetPins(Device))))
#define cirDeviceGetlastPin(Device) ((cirPin)(utlHtblEntry(cirDeviceGetPins(Device))))
#define cirForeachDevicePin(Device, _Pin) for(_Pin = cirDeviceGetfirstPin(Device); \
_Pin != cirPinNull; _Pin = cirPinGetnextDevicePin(_Pin))
#define cirEndForeachDevicePin
#define cirSafeForeachDevicePin(Device, _Pin) {\
    cirPin _nextPin;\
    for(_Pin = cirDeviceGetfirstPin(Device); \
        _Pin != cirPinNull; _Pin = _nextPin) {\
        _nextPin = cirPinGetnextDevicePin(_Pin);
#define cirEndSafeForeachDevicePin }}
#define cirDeviceGetfirstAttr(Device) ((Device)->firstAttr)
#define cirDeviceSetfirstAttr(Device, _Attr) ((Device)->firstAttr = (_Attr))
extern void cirDeviceInsertAttr(cirDevice Device, cirAttr _Attr);
extern void cirDeviceRemoveAttr(cirDevice Device, cirAttr _Attr);
#define cirForeachDeviceAttr(Device, _Attr) \
    for(_Attr = cirDeviceGetfirstAttr(Device); _Attr != cirAttrNull; \
        _Attr = cirAttrGetnextDeviceAttr(_Attr))
#define cirEndForeachDeviceAttr
#define cirSafeForeachDeviceAttr(Device, _Attr) {\
    cirAttr _nextAttr;\
    for(_Attr = cirDeviceGetfirstAttr(Device); _Attr != cirAttrNull; \
        _Attr = _nextAttr) {\
        _nextAttr = cirAttrGetnextDeviceAttr(_Attr);
#define cirEndSafeForeachDeviceAttr }}
#define cirDeviceGetlastAttr(Device) ((Device)->lastAttr)
#define cirDeviceSetlastAttr(Device, _Attr) ((Device)->lastAttr = (_Attr))
extern void cirDeviceAppendAttr(cirDevice Device, cirAttr _Attr);
#define cirDeviceGetInternalNetlist(_Device) ((_Device)->InternalNetlist)
#define cirDeviceSetInternalNetlist(_Device, value) ((_Device)->InternalNetlist = (value))
#define cirDeviceGetRoot(_Device) ((_Device)->Root)
#define cirDeviceSetRoot(_Device, value) ((_Device)->Root = (value))
#define cirDeviceGetSym(Device) ((Device)->h.Sym)
#define cirDeviceSetSym(Device, _sym) ((Device)->h.Sym = (_sym))
#define cirDeviceGetnextRootDevice(Device) ((cirDevice)((Device)->h.nEntry))

/*----------------------------------------------------------------------------
  Pin methods.
----------------------------------------------------------------------------*/
#define cirPinNull ((cirPin)(NULL))
extern cirPin _cirPinAlloc(void);
#define _cirPinNextFree(Pin) (*(cirPin *)(void *)(Pin))
#define cirPinAlloc() (_cirFirstFreePin == cirPinNull? _cirPinAlloc() : (\
    _cirTempPin = _cirFirstFreePin,\
    _cirFirstFreePin = _cirPinNextFree(_cirFirstFreePin),\
    memset((void *)_cirTempPin, 0, sizeof(struct _cirPin)),\
    _cirTempPin))
#define cirPinFree(Pin) (_cirPinNextFree(Pin) = _cirFirstFreePin, _cirFirstFreePin = (Pin))
#define cirPinGetDestructorHook() (cirPinDestructorHook)
#define cirPinSetDestructorHook(func) (cirPinDestructorHook = (func))
extern void cirPinDestroy(cirPin Pin);
#define cirPinGetSym(Pin) ((Pin)->h.Sym)
#define cirPinSetSym(Pin, _sym) ((Pin)->h.Sym = (_sym))
#define cirPinGetnextDevicePin(Pin) ((cirPin)((Pin)->h.nEntry))

/*----------------------------------------------------------------------------
  Root methods.
----------------------------------------------------------------------------*/
#define cirRootNull ((cirRoot)(NULL))
extern cirRoot cirRootAlloc(void);
#define _cirRootNextFree(Root) (*(cirRoot *)(void *)(Root))
extern void cirRootFree(cirRoot Root);
#define cirRootGetDestructorHook() (cirRootDestructorHook)
#define cirRootSetDestructorHook(func) (cirRootDestructorHook = (func))
extern void cirRootDestroy(cirRoot Root);
extern void cirRootInsertDevice(cirRoot Root, cirDevice _Device);
extern void cirRootRemoveDevice(cirRoot Root, cirDevice _Device);
extern void cirRootAppendDevice(cirRoot Root, cirDevice _Device);
#define cirRootFindDevice(Root, name) (cirDevice)utqEntryHtblSym(&(Root)->Devices, name)
#define cirRootGetnumDevices(Root) ((Root)->Devices.count)
#define cirRootGetDevices(Root) (&(Root)->Devices)
#define cirRootGetfirstDevice(Root) ((cirDevice)(utfHtblEntry(cirRootGetDevices(Root))))
#define cirRootGetlastDevice(Root) ((cirDevice)(utlHtblEntry(cirRootGetDevices(Root))))
#define cirForeachRootDevice(Root, _Device) for(_Device = cirRootGetfirstDevice(Root); \
_Device != cirDeviceNull; _Device = cirDeviceGetnextRootDevice(_Device))
#define cirEndForeachRootDevice
#define cirSafeForeachRootDevice(Root, _Device) {\
    cirDevice _nextDevice;\
    for(_Device = cirRootGetfirstDevice(Root); \
        _Device != cirDeviceNull; _Device = _nextDevice) {\
        _nextDevice = cirDeviceGetnextRootDevice(_Device);
#define cirEndSafeForeachRootDevice }}
#define cirRootGetfirstNetlist(Root) ((Root)->firstNetlist)
#define cirRootSetfirstNetlist(Root, _Netlist) ((Root)->firstNetlist = (_Netlist))
extern void cirRootInsertNetlist(cirRoot Root, cirNetlist _Netlist);
extern void cirRootRemoveNetlist(cirRoot Root, cirNetlist _Netlist);
#define cirForeachRootNetlist(Root, _Netlist) \
    for(_Netlist = cirRootGetfirstNetlist(Root); _Netlist != cirNetlistNull; \
        _Netlist = cirNetlistGetnextRootNetlist(_Netlist))
#define cirEndForeachRootNetlist
#define cirSafeForeachRootNetlist(Root, _Netlist) {\
    cirNetlist _nextNetlist;\
    for(_Netlist = cirRootGetfirstNetlist(Root); _Netlist != cirNetlistNull; \
        _Netlist = _nextNetlist) {\
        _nextNetlist = cirNetlistGetnextRootNetlist(_Netlist);
#define cirEndSafeForeachRootNetlist }}

/*----------------------------------------------------------------------------
  Attr methods.
----------------------------------------------------------------------------*/
#define cirAttrNull ((cirAttr)(NULL))
extern cirAttr _cirAttrAlloc(void);
#define _cirAttrNextFree(Attr) (*(cirAttr *)(void *)(Attr))
#define cirAttrAlloc() (_cirFirstFreeAttr == cirAttrNull? _cirAttrAlloc() : (\
    _cirTempAttr = _cirFirstFreeAttr,\
    _cirFirstFreeAttr = _cirAttrNextFree(_cirFirstFreeAttr),\
    memset((void *)_cirTempAttr, 0, sizeof(struct _cirAttr)),\
    _cirTempAttr))
#define cirAttrFree(Attr) (_cirAttrNextFree(Attr) = _cirFirstFreeAttr, _cirFirstFreeAttr = (Attr))
#define cirAttrGetDestructorHook() (cirAttrDestructorHook)
#define cirAttrSetDestructorHook(func) (cirAttrDestructorHook = (func))
extern void cirAttrDestroy(cirAttr Attr);
#define cirAttrGetSym(Attr) ((Attr)->Sym)
#define cirAttrSetSym(_Attr, value) ((_Attr)->Sym = (value))
#define cirAttrNameVisible(Attr) ((Attr)->NameVisible)
#define cirAttrSetNameVisible(_Attr, value) ((_Attr)->NameVisible = (value))
#define cirAttrValueVisible(Attr) ((Attr)->ValueVisible)
#define cirAttrSetValueVisible(_Attr, value) ((_Attr)->ValueVisible = (value))
#define cirAttrOptional(Attr) ((Attr)->Optional)
#define cirAttrSetOptional(_Attr, value) ((_Attr)->Optional = (value))
#define cirAttrGetnextDeviceAttr(Attr) ((Attr)->nextDeviceAttr)
#define cirAttrSetnextDeviceAttr(Attr, nextAttr) ((Attr)->nextDeviceAttr = (nextAttr))

/*----------------------------------------------------------------------------
  Netlist methods.
----------------------------------------------------------------------------*/
#define cirNetlistNull ((cirNetlist)(NULL))
extern cirNetlist cirNetlistAlloc(dbNetlist super);
#define _cirNetlistNextFree(Netlist) (*(cirNetlist *)(void *)(Netlist))
extern void cirNetlistFree(cirNetlist Netlist);
extern void cirNetlistDestroy(cirNetlist Netlist);
#define cirNetlistSub(baseClass) (dbNetlistNull==(baseClass)?cirNetlistNull:(cirNetlist)((long)dbNetlistGetfirstExtension(baseClass) - _utOffset(struct _cirNetlist, _extension)))
#define cirNetlistSuper(Netlist) ((Netlist)->_super)
#define cirNetlistExtended(Netlist) (dbNetlistGetfirstExtension(Netlist) != utExtensionNull &&\
dbNetlistGetfirstExtension(Netlist)->functionTable->className == \
 cirNetlistClassName)
#define cirNetlistUsed(Netlist) ((Netlist)->Used)
#define cirNetlistSetUsed(_Netlist, value) ((_Netlist)->Used = (value))
#define cirNetlistInsertParam(Netlist, _Param) utInsertHtblEntry(&(Netlist)->Params, &(_Param)->h)
#define cirNetlistRemoveParam(Netlist, _Param) utDeleteHtblEntry(&(Netlist)->Params, &(_Param)->h)
#define cirNetlistAppendParam(Netlist, _Param) utAppendHtblEntry(&(Netlist)->Params, &(_Param)->h)
#define cirNetlistFindParam(Netlist, name) (cirParam)utqEntryHtblSym(&(Netlist)->Params, name)
#define cirNetlistGetnumParams(Netlist) ((Netlist)->Params.count)
#define cirNetlistGetParams(Netlist) (&(Netlist)->Params)
#define cirNetlistGetfirstParam(Netlist) ((cirParam)(utfHtblEntry(cirNetlistGetParams(Netlist))))
#define cirNetlistGetlastParam(Netlist) ((cirParam)(utlHtblEntry(cirNetlistGetParams(Netlist))))
#define cirForeachNetlistParam(Netlist, _Param) for(_Param = cirNetlistGetfirstParam(Netlist); \
_Param != cirParamNull; _Param = cirParamGetnextNetlistParam(_Param))
#define cirEndForeachNetlistParam
#define cirSafeForeachNetlistParam(Netlist, _Param) {\
    cirParam _nextParam;\
    for(_Param = cirNetlistGetfirstParam(Netlist); \
        _Param != cirParamNull; _Param = _nextParam) {\
        _nextParam = cirParamGetnextNetlistParam(_Param);
#define cirEndSafeForeachNetlistParam }}
#define cirNetlistGetRoot(_Netlist) ((_Netlist)->Root)
#define cirNetlistSetRoot(_Netlist, value) ((_Netlist)->Root = (value))
#define cirNetlistGetnextRootNetlist(Netlist) ((Netlist)->nextRootNetlist)
#define cirNetlistSetnextRootNetlist(Netlist, nextNetlist) ((Netlist)->nextRootNetlist = (nextNetlist))

/*----------------------------------------------------------------------------
  Param methods.
----------------------------------------------------------------------------*/
#define cirParamNull ((cirParam)(NULL))
extern cirParam _cirParamAlloc(void);
#define _cirParamNextFree(Param) (*(cirParam *)(void *)(Param))
#define cirParamAlloc() (_cirFirstFreeParam == cirParamNull? _cirParamAlloc() : (\
    _cirTempParam = _cirFirstFreeParam,\
    _cirFirstFreeParam = _cirParamNextFree(_cirFirstFreeParam),\
    memset((void *)_cirTempParam, 0, sizeof(struct _cirParam)),\
    _cirTempParam))
#define cirParamFree(Param) (_cirParamNextFree(Param) = _cirFirstFreeParam, _cirFirstFreeParam = (Param))
#define cirParamGetDestructorHook() (cirParamDestructorHook)
#define cirParamSetDestructorHook(func) (cirParamDestructorHook = (func))
extern void cirParamDestroy(cirParam Param);
#define cirParamGetSym(Param) ((Param)->h.Sym)
#define cirParamSetSym(Param, _sym) ((Param)->h.Sym = (_sym))
#define cirParamGetnextNetlistParam(Param) ((cirParam)((Param)->h.nEntry))

/*----------------------------------------------------------------------------
  Package level routines.
----------------------------------------------------------------------------*/
extern void cirDDRStart(void);
extern void cirDDRStop(void);

/*----------------------------------------------------------------------------
  Structure definitions.
----------------------------------------------------------------------------*/
struct _cirDevice {
    struct _utEntry h;
    utSym Description;
    struct _utHtbl Pins;
    cirAttr firstAttr;
    cirAttr lastAttr;
    cirNetlist InternalNetlist;
    cirRoot Root;
};

struct _cirPin {
    struct _utEntry h;
};

struct _cirRoot {
    struct _utHtbl Devices;
    cirNetlist firstNetlist;
};

struct _cirAttr {
    utSym Sym;
    cirAttr nextDeviceAttr;
    bool NameVisible:2;
    bool ValueVisible:2;
    bool Optional:2;
};

struct _cirNetlist {
    struct _utExtension _extension;
    dbNetlist _super;
    struct _utHtbl Params;
    cirRoot Root;
    cirNetlist nextRootNetlist;
    bool Used:2;
};

struct _cirParam {
    struct _utEntry h;
};

extern void (*cirDeviceDestructorHook)(cirDevice);
extern cirDevice _cirFirstFreeDevice, _cirTempDevice;
extern void (*cirPinDestructorHook)(cirPin);
extern cirPin _cirFirstFreePin, _cirTempPin;
extern void (*cirRootDestructorHook)(cirRoot);
extern cirRoot _cirFirstFreeRoot, _cirTempRoot;
extern void (*cirAttrDestructorHook)(cirAttr);
extern cirAttr _cirFirstFreeAttr, _cirTempAttr;
extern struct _utFunctionTable cirNetlistFunctionTable;
extern utSym cirNetlistClassName;
extern cirNetlist _cirFirstFreeNetlist, _cirTempNetlist;
extern void (*cirParamDestructorHook)(cirParam);
extern cirParam _cirFirstFreeParam, _cirTempParam;

#endif
