/*
 * Copyright (C) 2003 ViASIC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */

#include "schddr.h"
#include "schext.h"
#include "schtypes.h"
#include "schcolors.h"

/* Top level functions */
schSchem schReadSchem(char *fileName, bool loadSubSchems);
schSymbol schReadSymbol(char *fileName, bool loadSubSchems);
void schStartReader(void);
void schStopReader(void);
void schStartSchem(void);
void schStopSchem(void);
bool schSchemPostProcess(schSchem schem, bool loadSubSchems);
bool schSymbolPostProcess(schSymbol symbol, bool loadSubSchems);
bool schBuildNetlists(dbDesign design, schSchem rootSchem);
void schSchemCreateDefaultSymbol(schSchem schem);
bool schWriteSymbol(char *fileName, schSymbol symbol);
void schGensymStart(void);
void schGensymStop(void);
void schStart(void);
void schStop(void);

/* Constructors */
schAttr schAttrCreate(S32 x, S32 y, utSym name, utSym value,
    bool visible, bool nameVisible, bool valueVisible, U8 color, U8 size, U8 angle, U8 alignment);
schWire schWireCreate(schSchem schem, S32 x1, S32 y1, S32 x2, S32 y2, bool isBus);
schComp schCompCreate(schSchem schem, utSym name, utSym symbolName, S32 x, S32 y, bool selectable,
    U16 angle, bool mirror);
schMpin schMpinCreate(schSymbol symbol, utSym name, schComp flagComp, dbMportType type, U32 sequence,
    S32 x, S32 y, bool isBus, U32 left, U32 right);
schPin schPinCreate(schComp comp, schMpin mpin);
schSchem schSchemCreate(utSym name, utSym path);
schSymbol schSymbolCreate(utSym name, dbNetlistType type, utSym path);
schNet schNetCreate(schSchem schem, utSym netName, bool isBus);
schConn schConnCreate(schWire wire1, schWire wire2, S32 x, S32 y);
schRect schRectCreate(schGraphic graphic, utBox box, U8 color);
schSignal schSignalCreate(schNet net, schBus bus, utSym sym);
schBus schBusCreate(schSchem schem, utSym name, U32 left, U32 right);

/* Short-cuts and misc. routines */
utSym schFindAttrValue(schAttr attr, utSym name);
utSym schSchemCreateUniqueNetName(schSchem schem, char *name);
utSym schSchemCreateUniqueCompName(schSchem schem, char *name);
void schNetRename(schNet net, utSym newName);
utBox schWireFindBox(schWire wire);
dbMportType schFindFlagType(schComp comp);
char *schNetGetName(schNet net);
char *schBusGetName(schBus bus);
char *schCompGetName(schComp comp);
char *schSchemGetName(schSchem schem);
char *schSymbolGetName(schSymbol symbol);
char *schMpinGetName(schMpin mpin);
bool schPinTypeOnRight(dbMportType type);
U32 schFindTextSpace(utSym name);
void schSymbolInsertAttr(schSymbol symbol, schAttr attr);
void schMpinInsertAttr(schMpin mpin, schAttr attr);
bool schNameHasRange(char *name, U32 *left, U32 *right);
dbNetlistType schSymbolFindType(schSymbol symbol);
bool schPinIsBus(schPin pin);
#define schConnFindOtherWire(conn, wire) (schConnGetLWire(conn) == (wire)? schConnGetRWire(conn) : \
    schConnGetLWire(conn))

/* Wire --> conn iterator */
#define schWireGetfirstConn(wire) (schWireGetfirstLConn(wire) != schConnNull? \
    schWireGetfirstLConn(wire) : schWireGetfirstRConn(wire))
#define schConnGetnextWireConn(wire, conn) (schConnGetLWire(conn) == (wire)? \
    (schConnGetnextWireLConn(conn) != schConnNull? \
    schConnGetnextWireLConn(conn) : schWireGetfirstRConn(wire)) : \
    schConnGetnextWireRConn(conn))
#define schForeachWireConn(wire, conn) \
    for(conn = schWireGetfirstConn(wire); (conn) != schConnNull; \
    conn = schConnGetnextWireConn(wire, conn))
#define schEndForeachWireConn

/* for text alignment */
/*   2 -- 5 -- 8  */
/*   |    |    |  */
/*   1 -- 4 -- 7  */
/*   |    |    |  */
/*   0 -- 3 -- 6  */
#define LOWER_LEFT      0
#define MIDDLE_LEFT     1
#define UPPER_LEFT      2
#define LOWER_MIDDLE    3
#define MIDDLE_MIDDLE   4
#define UPPER_MIDDLE    5
#define LOWER_RIGHT     6
#define MIDDLE_RIGHT    7
#define UPPER_RIGHT     8

#define SCH_CHAR_WIDTH 100
#define SCH_PIN_LENGTH 300
#define SCH_PIN_SPACE 400
#define SCH_PINLABEL_INSET 100

/* This is a dynamic array of mpins class.  When DataDraw is enhanced to generate this
   automatically, this can be deleted */
typedef struct {char val;} *schMpinArray;
#define schDynarray2MpinArray(dynarray) ((schMpinArray)(void *)(dynarray))
#define schMpinArray2Dynarray(array) ((utDynarrayRef)(void *)(array))
#define schMpinArrayNull NULL
#define schMpinArrayGetmaxMpins(array) utgDynarraySize(schMpinArray2Dynarray(array))
#define schMpinArrayGetMpins(array) utgDynarrayValues(schMpinArray2Dynarray(array), schMpin)
#define schMpinArrayGetnumMpins(array) utgDynarrayNumUsed(schMpinArray2Dynarray(array))
#define schMpinArraySetnumMpins(array, _NumUsed) utrDynarrayNumUsed(schMpinArray2Dynarray(array), (_NumUsed))
#define schMpinArrayGetiMpin(array, x) utxDynarrayValue(schMpinArray2Dynarray(array), schMpin, (x))
#define schMpinArraySetiMpin(array, x, Mpin) utrxDynarrayValue(schMpinArray2Dynarray(array), schMpin, (x), Mpin)
#define schMpinArrayCreate() schDynarray2MpinArray(utBuildDynarray(schMpin))
#define schMpinArrayDestroy(array) utdDynarray(schMpinArray2Dynarray(array))
#define schMpinArrayResizeMpins(array, newSize) utResizeDynarray(schMpinArray2Dynarray(array), (newSize))
#define schMpinArrayAppendMpin(array, Mpin) utaDynarrayValue(schMpinArray2Dynarray(array), schMpin, Mpin)
#define schForeachMpinArrayMpin(array, Mpin) utForEachDynarrayValue(schMpinArray2Dynarray(array), schMpin, Mpin)
#define schEndForeachMpinArrayMpin utEndDynarrayValue
#define schMpinArrayCopy(Dest, Source) utCopyDynarray(schMpinArray2Dynarray(Dest), schMpinArray2Dynarray(Source), schMpin)

/* The root object */
extern schRoot schTheRoot;

/* utSym values */
extern utSym schRefdesSym, schPinlabelSym, schPinnumberSym, schPinseqSym, schPintypeSym;
extern utSym schSourceSym, schNetnameSym, schDeviceSym, schFlagSym;
extern utSym schPowerSym, schNetSym, schValueSym, schCommentSym;
