/*-----------------------------------------------------------------------------
  Module header file for: ht module
-----------------------------------------------------------------------------*/

#ifndef htddr_H
#define htddr_H

#ifndef UTIL_H
#include "util.h"
#endif

/*-----------------------------------------------------------------------------
    Typedefs, constants, and enums here.
-----------------------------------------------------------------------------*/
typedef struct _htHtbl *htHtbl;
typedef struct _htEntry *htEntry;

/*----------------------------------------------------------------------------
  Htbl methods.
----------------------------------------------------------------------------*/
#define htHtblNull ((htHtbl)(NULL))
extern htHtbl htHtblAlloc(void);
#define _htHtblNextFree(Htbl) (*(htHtbl *)(void *)(Htbl))
extern void htHtblFree(htHtbl Htbl);
#define htHtblGetDestructorHook() (htHtblDestructorHook)
#define htHtblSetDestructorHook(func) (htHtblDestructorHook = (func))
extern void htHtblDestroy(htHtbl Htbl);
#define htHtblGetSizeExp(Htbl) ((Htbl)->SizeExp)
#define htHtblSetSizeExp(_Htbl, value) ((_Htbl)->SizeExp = (value))
#define htHtblGetNumEntries(Htbl) ((Htbl)->NumEntries)
#define htHtblSetNumEntries(_Htbl, value) ((_Htbl)->NumEntries = (value))
#define htHtblGetiEntry(Htbl, x) ((Htbl)->Entrys[x])
#define htHtblSetiEntry(Htbl, x, _Entry) ((Htbl)->Entrys[x] = (_Entry))
#define htHtblGetnumEntrys(Htbl) ((Htbl)->numEntrys)
#define htHtblSetusedEntrys(Htbl, numEntrys) ((Htbl)->usedEntrys = (numEntrys))
#define htHtblGetusedEntrys(Htbl) ((Htbl)->usedEntrys)
#define htHtblGetEntrys(Htbl) ((Htbl)->Entrys)
#define htHtblAllocEntrys(Htbl, num) ((Htbl)->usedEntrys = (num), \
(Htbl)->numEntrys = (num), (Htbl)->Entrys = mtNewA(htEntry, (num)))
#define htHtblReallocEntrys(Htbl, num) ((Htbl)->numEntrys = (num), (Htbl)->Entrys = mtResizeArray((Htbl)->Entrys, (num)*sizeof(htEntry)))
#define htHtblFreeEntrys(Htbl) (mtDelete((Htbl)->Entrys), (Htbl)->Entrys = NULL, \
    (Htbl)->numEntrys = 0, (Htbl)->usedEntrys = 0)
extern void htHtblInsertEntry(htHtbl Htbl, htEntry _Entry);
extern void htHtblRemoveEntry(htHtbl Htbl, htEntry _Entry);
#define htForeachHtblEntry(Htbl, _Entry) { \
    U32 _xEntry; \
    for(_xEntry = 0; _xEntry < htHtblGetusedEntrys(Htbl); \
        _xEntry++) { \
        _Entry = htHtblGetiEntry(Htbl, _xEntry);
#define htEndForeachHtblEntry }}
#define htSafeForeachHtblEntry(Htbl, _Entry) { \
    U32 _xEntry; \
    for(_xEntry = 0; _xEntry < htHtblGetusedEntrys(Htbl); \
        htHtblGetiEntry(Htbl, _xEntry) == _Entry &&_xEntry++) { \
        _Entry = htHtblGetiEntry(Htbl, _xEntry); \
        if(_Entry != htEntryNull) {
#define htEndSafeForeachHtblEntry }}}

/*----------------------------------------------------------------------------
  Entry methods.
----------------------------------------------------------------------------*/
#define htEntryNull ((htEntry)(NULL))
extern htEntry _htEntryAlloc(void);
#define _htEntryNextFree(Entry) (*(htEntry *)(void *)(Entry))
#define htEntryAlloc() (_htFirstFreeEntry == htEntryNull? _htEntryAlloc() : (\
    _htTempEntry = _htFirstFreeEntry,\
    _htFirstFreeEntry = _htEntryNextFree(_htFirstFreeEntry),\
    memset((void *)_htTempEntry, 0, sizeof(struct _htEntry)),\
    _htTempEntry))
#define htEntryFree(Entry) (_htEntryNextFree(Entry) = _htFirstFreeEntry, _htFirstFreeEntry = (Entry))
#define htEntryGetDestructorHook() (htEntryDestructorHook)
#define htEntrySetDestructorHook(func) (htEntryDestructorHook = (func))
extern void htEntryDestroy(htEntry Entry);
#define htEntryUsed(Entry) ((Entry)->Used)
#define htEntrySetUsed(_Entry, value) ((_Entry)->Used = (value))
#define htEntryGetScore(Entry) ((Entry)->Score)
#define htEntrySetScore(_Entry, value) ((_Entry)->Score = (value))
#define htEntryGetHashValue(Entry) ((Entry)->HashValue)
#define htEntrySetHashValue(_Entry, value) ((_Entry)->HashValue = (value))
#define htEntryGetData(Entry) ((Entry)->Data)
#define htEntrySetData(_Entry, value) ((_Entry)->Data = (value))
#define htEntryGetEntry(_Entry) ((_Entry)->Entry)
#define htEntrySetEntry(_Entry, value) ((_Entry)->Entry = (value))
#define htEntryGetHtblIndex(Entry) ((Entry)->HtblIndex)
#define htEntrySetHtblIndex(Entry, value) ((Entry)->HtblIndex = (value))

/*----------------------------------------------------------------------------
  Package level routines.
----------------------------------------------------------------------------*/
extern void htDDRStart(void);
extern void htDDRStop(void);

/*----------------------------------------------------------------------------
  Structure definitions.
----------------------------------------------------------------------------*/
struct _htHtbl {
    U16 SizeExp;
    U32 NumEntries;
    htEntry *Entrys;
    U32 numEntrys, usedEntrys;
};

struct _htEntry {
    float Score;
    U32 HashValue;
    U32 Data;
    htEntry Entry;
    U32 HtblIndex;
    bool Used:2;
};

extern void (*htHtblDestructorHook)(htHtbl);
extern htHtbl _htFirstFreeHtbl, _htTempHtbl;
extern void (*htEntryDestructorHook)(htEntry);
extern htEntry _htFirstFreeEntry, _htTempEntry;

#endif
