/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
    
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef __GLAXIUM_VARIABLES__
#define __GLAXIUM_VARIABLES__


#include <stdio.h>

#ifndef WIN32
#include "conf.h"
#else
#define random rand
#endif


#include <GL/gl.h>   
#include <GL/glext.h>   
#include "SDL.h"

#ifdef HAVE_LIBSDL_MIXER
#include "SDL_mixer.h"
#endif
#ifdef HAVE_LIBMIKMOD
#include "mikmod.h"
#endif


#define SCALE .12

#if !defined(PI)
#define PI 3.141592653589793
#endif


enum type_samples {
    SAMPLE_WELCOME=0,
    SAMPLE_TIR,
    SAMPLE_EXPLODE1,
    SAMPLE_EXPLODE2,
    SAMPLE_TACHEFIRE,
    SAMPLE_GLUPS,
    SAMPLE_POWERUP,
    SAMPLE_DETECTION,
    SAMPLE_GAMEOVER,
    SAMPLE_UNDEF
} ;




// Main class
class MyShip;
class ListSprite;

class GlaxiumVariables {
public:
  static GlaxiumVariables* getGlaxiumVariables();
  static bool isExtensionSupported(const char *extension);
  void initOptionsFile(bool bShad);
  // public method
  char* getFullPath(char *name);
  char *getFullOptionsPath();
  // Must be called after GLvar initialisation
  void initAllLists();
  bool myRandom(int i);

  // global variables
  float           global_timeadjustment;
  int             global_pause;
  MyShip*         mySpaceShip;
  int             camera;
  SDL_Joystick*   joy;
  char*           installDir;
  int             height, width;
  float           rotateMyShip;
  float           delay;
  bool            bShadows;
  bool		   	  bNVExtension;
  bool            bEXTEnvDot3;
  bool			  bARBCubeMap ;
  float           fMaxAnis;
  bool            bSeparateSpecularColor;
  int             details;
  

  // Texture
  GLuint texture_letters;
  GLuint texture_title[6];
  GLuint texture_fumee[3];
  GLuint texture_building;
  GLuint texture_floor[5];
  GLuint texture_floorMap[5];
  GLuint texture_bandit1;
  GLuint texture_bandit2;
  GLuint texture_myship;
  GLuint texture_piege;
  GLuint texture_chaine;
  GLuint texture_camouflage;
  GLuint texture_tache;
  GLuint texture_deadtache;
  GLuint texture_sphere;
  GLuint texture_gameover;
  GLuint texture_board;   
  GLuint texture_galaxy;   
  GLuint texture_border;   
  GLuint texture_mark;   
  GLuint texture_thunder;   
  GLuint texture_specialeffect1;   
  GLuint texture_fire3;   
  GLuint texture_fighter2;   
  GLuint texture_capsule[4];   


  // color
  GLfloat *mat_ambient;
  GLfloat *mat_specular;
  GLfloat *light_position;
  GLfloat *lm_ambient ;
  GLfloat *lm_diffuse;
  GLfloat *lm_specular;
  GLfloat *blanc_diffuse;
  GLfloat *nothing ;
  GLfloat *jaune_diffuse;
  GLfloat *jaune_diffuse_trans;
  GLfloat *rouge_diffuse_trans;
  GLfloat *jaune_diffuse_tres_trans;
  GLfloat *bleu_diffuse_trans ;
  GLfloat *rouge_diffuse ;
  GLfloat *jaune_emission;
  GLfloat *vert_diffuse;
  GLfloat *bleu_diffuse;
  GLfloat *bleu_clair_diffuse;
  GLfloat *gris_diffuse ;
  GLfloat *gris2_diffuse ;
  GLfloat *marron_diffuse;
  GLfloat *noir_diffuse;
  GLfloat *shadowMatrix;


  // Nvidia Hardware Dependent
  // Number of teture unit
  int m_nTextureUnits;
  // Number of register combiners
  int m_nRegisterCombiners;

  // Modules and samples
#ifdef HAVE_LIBMIKMOD
  MODULE *module1,*module2;
  SAMPLE *samples[SAMPLE_UNDEF];
#endif
#ifdef HAVE_LIBSDL_MIXER
  Mix_Music *module1, *module2;
  Mix_Chunk *samples[SAMPLE_UNDEF];
#endif

    
  char  **fileSample;

  // Stars
#define SPACE 4
  char *space_name[SPACE];
  GLfloat *pos_space ;
  GLuint texture_space[SPACE];

private:
  GlaxiumVariables();
  void initTextures();
  void initSound();
  void initTexture(GLuint &textureToBind, char* path);
  void initJoystick();
  void initVariables();
  void initInstallDir();

  // private variables

};

extern GlaxiumVariables* GLvar;

#endif
