/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TANK__
#define __TANK__


#include <stdlib.h>
#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"

class Tank : public Sprite {
public:
    enum enum_state {
        NORMAL,
            MOVING,
            TURNING,
            TURNING_TOURELLE,
            SHOOTING,
            PREPARE_SHOOT,
            UNDEF
    } ;
    
    Tank(List *list, int x, int shield);
    ~Tank();
    void draw();
	void drawShadowable();
    void move();
    void collision(Sprite *);
    static int numberOfTanks_;
    static void  initList();    
protected:
    int state_;
    float tetay1_,tetay2_;
    int shield_;
    Sprite *toShot;
    float tetay2_goal ;
    float dtetay2_;
    float cpt_;
    float chaine1_, chaine2_;
    static int m_nBigCubeList ;
    static int m_nLittleCubeList ;
};


class TankFire : public Sprite {
public:
    TankFire::TankFire(List *list, Tank *tank, float x, float y, float z,float dx, float dz,float rotated);
    void draw();
	void drawShadowable();
    void move();
    void collision(Sprite *);
    
protected:
    float tetay_,rotated_;
    
};


#endif



