/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __SCENE__
#define __SCENE__


#include <stdlib.h>

#include "listsprite.hpp"

#define STARS 300


class Scene {
public:
    static Scene* getScene();
    void drawFloor();
    void drawSolidFloor();
    void drawSky();
    void drawPlayers();
    void drawFPS();
    void drawPresentation();
    void drawGame();
    void initOpenGl();
    void presentationIdle();
    void gameIdle() ;

    void toggleDisplayFPS();
    void toggleFog();
    void toggleSpecular();
	// create and return a list number
    int createCube(float size);
	// return nothing
  	 void createCube(float sizex,float sizey,float sizez);
    // public variable 
    int globalScore ;
    ListSprite *    globalList;
	int nStars;
	int benchState;
	float benchPeriod;


	// Benchmark
	void drawFPSBench();
    void drawBench();
    void benchIdle() ;
	// Benchmark
    void drawMenu();
    void menuIdle() ;
protected:
    float stars[STARS][6];
    void initVariables();

    void timediff() ;
    Scene();
    int dt,lasttime; // milliseconds since last frame
    int displayFPS;
	int nFog;
	bool bSpecular;
    int floorOffset;
    float floorScrollOffset;

    int* aFloor;
    int* aFloorMap;
    GLfloat* m_fFloorY;

};

extern Scene* scene;

#endif

