/*
  Copyright (C) 2000/2002 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
	
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#include <GL/glut.h>
#include <GL/glext.h>

#include "sprite.hpp"
#include "explosion.hpp"
#include "myship.hpp"
#include "fire.hpp"
#include "diamond.hpp"

#include "SDL.h"


#include "modeles/myship.c"
#include "modeles/protection.c"


extern PFNGLCOMBINERPARAMETERINVPROC glCombinerParameteriNV;
extern PFNGLCOMBINERINPUTNVPROC glCombinerInputNV;
extern PFNGLCOMBINEROUTPUTNVPROC glCombinerOutputNV;
extern PFNGLFINALCOMBINERINPUTNVPROC glFinalCombinerInputNV;
#ifdef WIN32
extern PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
#endif
int MyShip::list_;


#define ABS(x) ((x>0)?(x):(-x))


void drawCpt(int cpt, float size) {
	int digit;
	int div=1000;
	glBindTexture(GL_TEXTURE_2D,GLvar->texture_letters);
	while (div!=0) {
		digit = cpt/div;
		cpt = cpt - digit*div;
		div/=10;
		glBegin(GL_QUADS);
			{
				glColor4f(1,1,1,1);
				glTexCoord2f(.03125*(digit), .1875);
				glVertex3f(size/700,0,0);
				glTexCoord2f(.03125*(digit+1),  .1875);
				glVertex3f(0,0,0);
//				glColor4f(.9,0,0,1);
				glTexCoord2f(.03125*(digit+1), 0.125);			
				glVertex3f(0,size/300,0);
				glTexCoord2f(.03125*(digit), 0.125);
				glVertex3f(size/700,size/300,0);
			}
		glEnd();
		glTranslatef(-size/700,0,0) ;
	} ;
}


MyShip::MyShip(List *list, int shieldMax) 
: Sprite(list,TYPE_MY_SPACE_SHIP,0,.5,-3)
{
	int i;
    shieldMax_ = shieldMax;
    shield_ = shieldMax_;
    state_ = NOT_STARTED;
    ddx_=ddz_=0;
    sizex_=1.7;
    sizey_ = .8;
    sizez_=.5;
    score_= 0;
    bomb_=5;
    PlaySample(SAMPLE_WELCOME);
    rotate_=0;
    powerUp_=0;
    cptFire_=0;
	delay_=0;
	invulBegin = glutGet((GLenum)GLUT_ELAPSED_TIME);  
	invulEnd = invulBegin + 1000*15;
/*
	fThX = new float[20];
	fThY = new float[20];
	fThS = new float[20];
	for (i=0; i<19; i++) {
		fThX[i] = (float)(random()%100-50.0f)/400.0f;
		fThY[i] = (float)(random()%100-50.0f)/400.0f;
//		fThY[i] = (float)0.0f;
		fThS[i] = (float).01;
	}
	fThX[19] = 0;
	fThY[19] = 0;
	*/
}

void MyShip::score(int toAdd) {
	score_+=toAdd;
}


void MyShip::initList()
{
    int i, j;
	// average normal.....
	int nbVertex = 392*3;
	int *bTested = new int[nbVertex];
	for (i=0;i<nbVertex;i++) {
		bTested[i] = 0;
	}
	int nb;
	GLfloat aNormal[3];
	for (i=0;i<nbVertex;i++) {
		if (bTested[i]==0) {
			bTested[i] = 2;
			nb=1;
			aNormal[0] = myship_meshes[i*8+3];
			aNormal[1] = myship_meshes[i*8+4];
			aNormal[2] = myship_meshes[i*8+5];
			//			 printf("\n===========================================\n\n");
			//			 printf("i= %d, x,y,z = %f,%f,%f\n",i,myship_meshes[i*8+0],myship_meshes[i*8+1],myship_meshes[i*8+2]);
			//			 printf("- - - - - - -\n");
			for (j=i+1;j<nbVertex;j++) {
				if ((bTested[j]==0) && ((myship_meshes[i*8+0]-myship_meshes[j*8+0])<.01)  && ((myship_meshes[i*8+1]-myship_meshes[j*8+1])<.01) && ((myship_meshes[i*8+2]-myship_meshes[j*8+2])<.01) && ((myship_meshes[i*8+0]-myship_meshes[j*8+0])>-.01)  && ((myship_meshes[i*8+1]-myship_meshes[j*8+1])>-.01) && ((myship_meshes[i*8+2]-myship_meshes[j*8+2])>-.01) ) {
					bTested[j]=2;
					nb++;
					aNormal[0]+= myship_meshes[j*8+3];
					aNormal[1]+= myship_meshes[j*8+4];
					aNormal[2]+= myship_meshes[j*8+5];
					//					 printf("j= %d, x,y,z = %f,%f,%f\n",j,myship_meshes[j*8+0],myship_meshes[j*8+1],myship_meshes[j*8+2]);
					//					 printf("    diff  %f,%f,%f\n",(myship_meshes[i*8+0]-myship_meshes[j*8+0]), (myship_meshes[i*8+1]-myship_meshes[j*8+1]),(myship_meshes[i*8+2]-myship_meshes[j*8+2]));
				}
			}
			aNormal[0] /= nb;
			aNormal[1] /= nb;
			aNormal[2] /= nb;
			for (j=i;j<nbVertex;j++) {
				if (bTested[j]==2)  {
					myship_meshes[j*8+3] = aNormal[0];
					myship_meshes[j*8+4] = aNormal[1];
					myship_meshes[j*8+5] = aNormal[2];
					bTested[j]=1;
				}
			}	 
		}
	}
	// average normal.....
	nbVertex = 162*3;
	for (i=0;i<nbVertex;i++) {
		bTested[i] = 0;
	}
	for (i=0;i<nbVertex;i++) {
		if (bTested[i]==0) {
			bTested[i] = 2;
			nb=1;
			aNormal[0] = protection_meshes[i*8+3];
			aNormal[1] = protection_meshes[i*8+4];
			aNormal[2] = protection_meshes[i*8+5];
			//			 printf("\n===========================================\n\n");
			//			 printf("i= %d, x,y,z = %f,%f,%f\n",i,myship_meshes[i*8+0],myship_meshes[i*8+1],myship_meshes[i*8+2]);
			//			 printf("- - - - - - -\n");
			for (j=i+1;j<nbVertex;j++) {
				if ((bTested[j]==0) && ((protection_meshes[i*8+0]-protection_meshes[j*8+0])<.01)  && ((protection_meshes[i*8+1]-protection_meshes[j*8+1])<.01) && ((protection_meshes[i*8+2]-protection_meshes[j*8+2])<.01) && ((protection_meshes[i*8+0]-protection_meshes[j*8+0])>-.01)  && ((protection_meshes[i*8+1]-protection_meshes[j*8+1])>-.01) && ((protection_meshes[i*8+2]-protection_meshes[j*8+2])>-.01) ) {
					bTested[j]=2;
					nb++;
					aNormal[0]+= protection_meshes[j*8+3];
					aNormal[1]+= protection_meshes[j*8+4];
					aNormal[2]+= protection_meshes[j*8+5];
					//					 printf("j= %d, x,y,z = %f,%f,%f\n",j,protection_meshes[j*8+0],protection_meshes[j*8+1],protection_meshes[j*8+2]);
					//					 printf("    diff  %f,%f,%f\n",(protection_meshes[i*8+0]-protection_meshes[j*8+0]), (protection_meshes[i*8+1]-protection_meshes[j*8+1]),(protection_meshes[i*8+2]-protection_meshes[j*8+2]));
				}
			}
			aNormal[0] /= nb;
			aNormal[1] /= nb;
			aNormal[2] /= nb;
			for (j=i;j<nbVertex;j++) {
				if (bTested[j]==2)  {
					protection_meshes[j*8+3] = aNormal[0];
					protection_meshes[j*8+4] = aNormal[1];
					protection_meshes[j*8+5] = aNormal[2];
					bTested[j]=1;
				}
			}	 
		}
	}
    
    for (i=0;i<392;i++) {
        myship_meshes[i*24]/=120;
        myship_meshes[i*24+1]/=120;
        myship_meshes[i*24+2]/=120;
        
        myship_meshes[i*24+8]/=120;
        myship_meshes[i*24+1+8]/=120;
        myship_meshes[i*24+2+8]/=120;
        
        myship_meshes[i*24+16]/=120;
        myship_meshes[i*24+1+16]/=120;
        myship_meshes[i*24+2+16]/=120;
    }
	
	
	if (GLvar->bNVExtension) {
		list_ = glGenLists(3);
		glNewList(list_,GL_COMPILE);
		{	
			glCombinerParameteriNV(GL_NUM_GENERAL_COMBINERS_NV,2);
			
			glCombinerInputNV(GL_COMBINER0_NV, GL_RGB, GL_VARIABLE_A_NV, GL_PRIMARY_COLOR_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerInputNV(GL_COMBINER0_NV, GL_RGB, GL_VARIABLE_B_NV, GL_TEXTURE0_ARB, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerOutputNV(GL_COMBINER0_NV, GL_RGB, GL_SPARE0_NV, GL_DISCARD_NV, GL_DISCARD_NV, GL_NONE, GL_NONE, GL_FALSE, GL_FALSE, GL_TRUE);
			
			glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_A_NV, GL_SECONDARY_COLOR_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_B_NV, GL_TEXTURE1_ARB, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerOutputNV(GL_COMBINER1_NV, GL_RGB, GL_SPARE1_NV, GL_DISCARD_NV, GL_DISCARD_NV, GL_SCALE_BY_TWO_NV, GL_NONE, GL_FALSE, GL_FALSE, GL_TRUE);
			
			glFinalCombinerInputNV(GL_VARIABLE_A_NV, GL_ZERO, GL_UNSIGNED_INVERT_NV, GL_RGB);
			glFinalCombinerInputNV(GL_VARIABLE_B_NV, GL_SPARE0_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glFinalCombinerInputNV(GL_VARIABLE_C_NV, GL_ZERO, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glFinalCombinerInputNV(GL_VARIABLE_D_NV, GL_SPARE1_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			
			glFinalCombinerInputNV(GL_VARIABLE_G_NV, GL_ZERO, GL_UNSIGNED_INVERT_NV, GL_ALPHA);

			glActiveTextureARB(GL_TEXTURE0_ARB);					
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_myship);	
			
			glEnableClientState(GL_VERTEX_ARRAY);
			glEnableClientState(GL_NORMAL_ARRAY);
			glEnableClientState(GL_TEXTURE_COORD_ARRAY);
			glTranslatef(.13,0,0);    
			glEnable(GL_REGISTER_COMBINERS_NV);
			
			glActiveTextureARB(GL_TEXTURE1_ARB); 
			glEnable(GL_TEXTURE_2D); 

			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_galaxy);
			glEnable(GL_TEXTURE_GEN_S);
			glEnable(GL_TEXTURE_GEN_T);
			glVertexPointer(3,GL_FLOAT,32,myship_meshes); 
			glNormalPointer(GL_FLOAT,32,myship_meshes+3); 
			glTexCoordPointer(2,GL_FLOAT,32,myship_meshes+6);       
			glDrawArrays(GL_TRIANGLES,0,391*3+2);
			
			glDisable(GL_REGISTER_COMBINERS_NV);
			
			glDisableClientState(GL_VERTEX_ARRAY);
			glDisableClientState(GL_NORMAL_ARRAY);
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
			
			glActiveTextureARB(GL_TEXTURE1_ARB); 
			glDisable(GL_TEXTURE_2D); 
			glDisable(GL_TEXTURE_GEN_S);
			glDisable(GL_TEXTURE_GEN_T);

			glActiveTextureARB(GL_TEXTURE0_ARB); 			
		}	
		glEndList();
	} else {	
		list_ = glGenLists(4);
		glNewList(list_,GL_COMPILE);
		{	
		
			glEnableClientState(GL_VERTEX_ARRAY);
			glEnableClientState(GL_NORMAL_ARRAY);
			glEnableClientState(GL_TEXTURE_COORD_ARRAY);
			glTranslatef(.13,0,0);    
			
			glVertexPointer(3,GL_FLOAT,32,myship_meshes); 
			glNormalPointer(GL_FLOAT,32,myship_meshes+3); 
			glTexCoordPointer(2,GL_FLOAT,32,myship_meshes+6);       
			
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_myship);
			glDrawArrays(GL_TRIANGLES,0,391*3+2);
			
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
			glDisableClientState(GL_VERTEX_ARRAY);
			glDisableClientState(GL_NORMAL_ARRAY);		
		}
		glEndList();
		
		glNewList(list_+3,GL_COMPILE);
		{					
			glEnableClientState(GL_VERTEX_ARRAY);
			glEnableClientState(GL_NORMAL_ARRAY);
			glEnableClientState(GL_TEXTURE_COORD_ARRAY);
			glTranslatef(.13,0,0);    
			
			glVertexPointer(3,GL_FLOAT,32,myship_meshes); 
			glNormalPointer(GL_FLOAT,32,myship_meshes+3); 
			glTexCoordPointer(2,GL_FLOAT,32,myship_meshes+6);       
			glMaterialfv(GL_FRONT, GL_SPECULAR, GLvar->nothing);
			
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_myship);
			glDrawArrays(GL_TRIANGLES,0,391*3+2);
			
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_ONE, GL_ONE);
			
			glDepthFunc(GL_ALWAYS);
		    		    
			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			
			glEnable(GL_TEXTURE_GEN_S);
			glEnable(GL_TEXTURE_GEN_T);
			
			glMaterialfv(GL_FRONT, GL_AMBIENT, GLvar->nothing);
			glMaterialfv(GL_FRONT, GL_SPECULAR, GLvar->blanc_diffuse);
			glMaterialfv(GL_FRONT, GL_DIFFUSE, GLvar->nothing);
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_galaxy);
			glDisable(GL_TEXTURE_2D);
			
			glDrawArrays(GL_TRIANGLES,0,391*3+2);
			
			glMaterialfv(GL_FRONT, GL_AMBIENT, GLvar->lm_ambient);
			glMaterialfv(GL_FRONT, GL_DIFFUSE, GLvar->blanc_diffuse);
			
			glDisable(GL_TEXTURE_GEN_S);
			glDisable(GL_TEXTURE_GEN_T);
			
			glDisableClientState(GL_VERTEX_ARRAY);
			glDisableClientState(GL_NORMAL_ARRAY);
			
			glDisable(GL_BLEND);
			glDepthFunc(GL_LEQUAL);			
		}
		glEndList();
		
	}
	
	
    glNewList(list_+1,GL_COMPILE);
    {
		glTranslatef(.13,0,0);    
		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(3,GL_FLOAT,32,myship_meshes); 
		glDrawArrays(GL_TRIANGLES,0,391*3+2);
		glDisableClientState(GL_VERTEX_ARRAY);
    }
    glEndList();
	
    glNewList(list_+2,GL_COMPILE);
    {
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_floor[1]);
//		glBindTexture(GL_TEXTURE_2D, GLvar->texture_letters);
		if (GLvar->bARBCubeMap) {
			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_REFLECTION_MAP_ARB);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_REFLECTION_MAP_ARB);
		} else {
			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
		}
		
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);

		glEnableClientState(GL_NORMAL_ARRAY);
		glEnableClientState(GL_VERTEX_ARRAY);
		glNormalPointer(GL_FLOAT,32,protection_meshes+3); 
		glVertexPointer(3,GL_FLOAT,32,protection_meshes); 
		glRotatef(-90,1,0,0);
		glDrawArrays(GL_TRIANGLES,0,162*3);
		glDisableClientState(GL_VERTEX_ARRAY);
		glDisable(GL_TEXTURE_GEN_S);
		glDisable(GL_TEXTURE_GEN_T);

    }
    glEndList();

	delete[]bTested;
}

void MyShip::drawShadowable() {


	glPushMatrix();
		
	glTranslatef(x_,y_,z_);
    if (state_ == ROTATING ) {
        glRotatef(rotate_ , 0 , 0 , 1);
    }  
    if (state_ == DEAD ) {
		  glRotatef(rotate_ *2, 1,0,0);
        glRotatef(rotate_ , 0 , 0 , 1);
    }  
    glRotatef(-dx_*60 , 0 , 0 , 1);  
	
    glCallList(list_+1);
	
    glPopMatrix();
}

void MyShip::draw()
{
	int i;


    glPushMatrix();
    glTranslatef(x_,y_,z_);


    glBindTexture(GL_TEXTURE_2D, GLvar->texture_myship);
	

    if (state_ == ROTATING ) {
        glRotatef(rotate_ , 0 , 0 , 1);
    }
    if (state_ == DEAD ) {
		  glRotatef(rotate_ *2, 1,0,0);
        glRotatef(rotate_ , 0 , 0 , 1);
    }  
    
    glRotatef(-dx_*60 , 0 , 0 , 1);
    
#ifdef GL_SINGLE_COLOR
	if (!GLvar->bNVExtension && GLvar->bSeparateSpecularColor) {
		glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SINGLE_COLOR);
	}
#endif
	if (state_==DEAD) {
		float fSc = (float)(random()%100-50.0f)/400.0f+1;
		glScalef(fSc,fSc,fSc);
	}
    
	glCallList(list_);
#ifdef GL_SEPARATE_SPECULAR_COLOR
	if (!GLvar->bNVExtension && GLvar->bSeparateSpecularColor) {
		glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SEPARATE_SPECULAR_COLOR);
	}
#endif

	
	
	glDisable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);   
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glDepthMask(GL_FALSE);

    glTranslatef(.3 , .1, -.15);
      	
    glBegin(GL_TRIANGLE_FAN);
    glColor4f(1 , 1 , 0 , 1); 
    glVertex3f(0 ,0,0); 
    glColor4f(1 , 0 , 0 , 0.0);  
    glVertex3f(.3+((float)(random() % 10)/30-.15)   , -.1 ,0.0);
    glVertex3f(.15  , 0 ,-.8); 
    glVertex3f(0   , 0 ,-1.2-((float)(random() % 10)/10));
    glVertex3f(-.15 , 0 ,-.8);
    glVertex3f(-.3+((float)(random() % 10)/30-.15)  , -.1 ,0.0);
    glEnd();
    
    glTranslatef(-.8,0,0);
    
    glBegin(GL_TRIANGLE_FAN);
    glColor4f(1 , 1 , 0 , 1); 
    glVertex3f(0 ,0,0); 
    glColor4f(1 , 0 , 0 , 0.0);  
    glVertex3f(.3+((float)(random() % 10)/30-.15)   , -.1 ,0.0);
    glVertex3f(.15  , 0 ,-.8); 
    glVertex3f(0   , 0 ,-1.2-((float)(random() % 10)/10));
    glVertex3f(-.15 , 0 ,-.8);
    glVertex3f(-.3+((float)(random() % 10)/30-.15)  , -.1 ,0.0);
    glEnd();
    
    glColor4f(1 , 1 , 1 , 1); 


    glDepthMask(GL_TRUE);
    glPopMatrix();


	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	if (invulBegin!=0) {	
		static float toto[]= {.4,.7,.7,.4};
		int left = invulEnd-glutGet((GLenum)GLUT_ELAPSED_TIME);

		if (left<5000) {
			toto[3] = .4- .4*((float)(left%500)/500.0f);
		} else {
			toto[3] = .4;
		}

		glMaterialfv(GL_FRONT, GL_DIFFUSE, toto);

		glPushMatrix();

		glTranslatef(x_,y_,z_);

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDepthMask(GL_FALSE);
		glCallList(list_+2);
		glDepthMask(GL_TRUE);
		glPopMatrix();

		glMaterialfv(GL_FRONT, GL_DIFFUSE, GLvar->blanc_diffuse);

		glPushMatrix();

		// 
		glDisable(GL_LIGHTING);
		glDepthFunc(GL_ALWAYS);
//		glDisable(GL_CULL_FACE);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER, .3);

		glTranslatef(x_+.1,y_-.4,z_-.5);
		drawCpt(left/1000 , 120);
//		glEnable(GL_CULL_FACE);
		glDisable(GL_ALPHA_TEST);

		glPopMatrix();
		glDepthFunc(GL_LEQUAL);			
		glEnable(GL_LIGHTING);
	}
	glDisable(GL_BLEND);
}

void MyShip::explode()
{
}

void MyShip::move()
{
    static int newElapsedTime =0;
    static int newElapsedTime2 =0;
    static int newElapsedTime3 =0;
    static int global_gauche , global_droite , global_haut , global_bas;
    static Sint16 x_move, y_move;
    static Uint8 button1, button2;
    static Uint8 *keys;
    
	if (shield_<0) {
		state_=DEAD;
	}
	if (state_==DEAD) {
		delay_ +=  GLvar->global_timeadjustment;
		// printf("DELAY %f\n", delay_);
		if (delay_>100) {
			Sprite *explode;		
	        PlaySample(SAMPLE_GAMEOVER);
			dead_=1;
			shield_=0;
			explode= new Explosion(this,20);
			return;
		}
	}
	
    keys = SDL_GetKeyState(NULL);
    global_gauche = global_droite = global_haut = global_bas = 0;
    
    if ( keys[SDLK_UP] ) {
        global_haut=1;
    }
    if ( keys[SDLK_DOWN] ) {
        global_bas=1;
    }
    if ( keys[SDLK_LEFT] ) {
        global_gauche=1;
    } 
    if ( keys[SDLK_RIGHT] ) {
        global_droite=1;
    }
    button2 = button1 = 0;
    if ( keys[SDLK_w] || keys[SDLK_z] ||  keys[SDLK_LCTRL] ) {
        button1=1;
    }
    if ( keys[SDLK_x] || keys[SDLK_SPACE]) {
        button2=1;
    }
    
    if (GLvar->joy!=NULL) {
        SDL_JoystickUpdate();
        x_move=SDL_JoystickGetAxis(GLvar->joy,0);
        y_move=SDL_JoystickGetAxis(GLvar->joy,1);
        if (!button1)
            button1 = SDL_JoystickGetButton(GLvar->joy,0);
        if (!button2)
            button2 = SDL_JoystickGetButton(GLvar->joy,1);
        //printf("Joytick x_move =%d,  button1= %d, button2 =%d\n", x_move, button1, button2);
        
        if (!global_gauche)
            global_gauche=(x_move<-16384);
        if (!global_droite)
            global_droite=(x_move>16384);
        if (!global_haut)
            global_haut=(y_move<-16384);
        if (!global_bas)
            global_bas=(y_move>16384); 
    }
    
    
    switch (state_)
    {
    case NOT_STARTED:
        dz_=.1;
        Sprite::move();
        if (z_>2.5)
        {
            state_ = NORMAL;
        }
        break;
    case NORMAL:
        {
			int delay = 0 ;
			int nTime = glutGet((GLenum)(GLUT_ELAPSED_TIME));
			
            ddx_ = (global_gauche-global_droite)*.01*GLvar->global_timeadjustment;
            ddz_ = (global_haut-global_bas)*.01*GLvar->global_timeadjustment;
            
            if (state_==NORMAL) {
				if (!button1) {
					newElapsedTime=0;
					newElapsedTime3 = nTime;
				}
				
				if (nTime-newElapsedTime3>850) delay = 250;
				if ((button1) && ((glutGet((GLenum)(GLUT_ELAPSED_TIME))-newElapsedTime)> 120 +delay))
				{
					cptFire_++;
					SpritePlaySample(SAMPLE_TIR);
					MyFire1 *thisfire = new MyFire1(this);
					mlist->Add(thisfire);
					if (powerUp_>=1) {
						thisfire = new MyFire1(this,.02);
						mlist->Add(thisfire);
						thisfire = new MyFire1(this,-.02);
						mlist->Add(thisfire);
						if (powerUp_>=2) {
							if (cptFire_%8==0) {
								MyFire3 *thisfire3 = new MyFire3(this,.5);
								mlist->Add(thisfire3);
								thisfire3 = new MyFire3(this,-.5);
								mlist->Add(thisfire3);
							}
							if (powerUp_>=3) {
								thisfire = new MyFire1(this,.08,-.7);
								mlist->Add(thisfire);
								thisfire = new MyFire1(this,-.08,-.7);
								mlist->Add(thisfire);
								if (powerUp_>=4) {
									MyFire4 *fire4 ;
									if ((cptFire_&1)==0) {
										fire4 = new MyFire4(this,.007, .5);
										mlist->Add(fire4);
										fire4 = new MyFire4(this,-.007,.5);
										mlist->Add(fire4);
									}
									if (powerUp_>=5) {  
										if ((cptFire_+4)%8==0) {
											MyFire3 *thisfire3 = new MyFire3(this,.5);
											mlist->Add(thisfire3);
											thisfire3 = new MyFire3(this,-.5);
											mlist->Add(thisfire3);
										}

										if (powerUp_>=6) {
											thisfire = new MyFire1(this,.06);
											mlist->Add(thisfire);
											thisfire = new MyFire1(this,-.06);
											mlist->Add(thisfire);
											if (powerUp_>=7) {  
												if ((cptFire_+2)%4==0) {
													MyFire3 *thisfire3 = new MyFire3(this,.5);
													mlist->Add(thisfire3);
													thisfire3 = new MyFire3(this,-.5);
													mlist->Add(thisfire3);
												}
												/* MyFire4Smoke must accept negtive dz
												if (powerUp_>=8) {  
													fire4 = new MyFire4(this,0, -.5);
													mlist->Add(fire4);
												}*/
											}
										}
									}
								}
							}
						}
					}
					newElapsedTime = nTime;
				}
				
				if ((button2) && ((nTime-newElapsedTime2)> 1000))
				{
					if (bomb_>0)
					{
						MyFire2 *thisfire = new MyFire2(this);
						mlist->Add(thisfire);
						bomb_--;
						newElapsedTime2 = nTime;
					}
				}
			}
            
            if (dx_>-.4 && dx_<.4)
                dx_+=ddx_;
            
            if (dx_<-.02*GLvar->global_timeadjustment && global_droite==0)
                dx_+=.02*GLvar->global_timeadjustment;
            else if (dx_>.02*GLvar->global_timeadjustment && global_gauche==0)
                dx_-=.02*GLvar->global_timeadjustment;
            else if(dx_!=0 && global_gauche==0 && global_droite==0)
                dx_=0;
            
            
            if (dz_>-.4 && dz_<.4)
                dz_+=ddz_;      
            
            
            if (dz_<-.02*GLvar->global_timeadjustment && global_bas==0) 
                dz_+=.02*GLvar->global_timeadjustment;
            else if (dz_>.02*GLvar->global_timeadjustment && global_haut==0)
                dz_-=.02*GLvar->global_timeadjustment;
            else if(dz_!=0 && global_bas==0 && global_haut==0)
                dz_=0;
            
            Sprite::move();
            //x_+=dx_;
            //z_+=dz_;
            
            
            if (x_<-11.75) {
                x_=-11.75;
                if (dx_<0) 
                {
                    dx_+=.02;
                }
                else
                    dx_=0;
                ddx_=0;
            } else if (x_>11.75) {
                x_=11.75;
                if (dx_>0)
                {
                    dx_-=0.02;
                }
                else
                    dx_=0;
                ddx_=0;
            }
            if (z_>42) {
                z_=42;
                if (dz_>0)
                    dz_-=0.05;
                else
                    dz_=0;
                ddz_=0;
            }
            else if (z_<2.5) {
                z_=2.5;
                if (dz_<0)
                    dz_+=0.05;
                else
                    dz_=0;
                ddz_=0;
            }   
            break;    
        }
    case DEAD:
        rotate_ += 5*GLvar->global_timeadjustment;
		break;
    case ROTATING:
        dx_/=1.1;
        dz_/=1.1;
        rotate_ += 15*GLvar->global_timeadjustment;
        if (rotate_>360)
        {
            //  printf("NORMAL...\n");
            dx_=0;
            dz_=0;
            state_ = NORMAL;
        }
        break;
    }

	if (invulBegin>0 && glutGet((GLenum)GLUT_ELAPSED_TIME)>invulEnd) {
		invulBegin=0;
	}
}



void MyShip::collision(Sprite*contact)
{
	Explosion*explode;
	switch(contact->getType())
		{
		case TYPE_POTO:
			{
				float tx = ((x_-contact->getX()) / ((sizex_ + contact->getSizeX())/2)) ;
				float tz = ((z_-contact->getZ()) / ((sizez_ + contact->getSizeZ())/2)) ;
				dz_ = tz/5;
				dx_ = tx/5;
			}
			break;
            
		case TYPE_SPIRALE:
		case TYPE_CUBE:
		case TYPE_TANK:
		case TYPE_SHIP1:
		case TYPE_BANDIT2:
			{
				float tx = ((x_-contact->getX()) / ((sizex_ + contact->getSizeX())/2)) ;
				float tz = ((z_-contact->getZ()) / ((sizez_ + contact->getSizeZ())/2)) ;
				dz_=tz/5;
				dx_ = tx/5;
				if (state_!=ROTATING && state_!=DEAD && invulBegin==0)
					{
						shield_ -=10;
						if (shield_>0)
							{
								explode= new Explosion(this,5,1,0);
								mlist->Add(explode);
							}
					}
			}
			break;
		case TYPE_SCRATCHER:
			if (state_!=ROTATING && state_!=DEAD && invulBegin==0)
				shield_ -=15;
			break;
		case TYPE_FIRE_TANK:
			if (state_!=ROTATING && state_!=DEAD && invulBegin==0)
				shield_ -=5;
		case TYPE_FIRE_SHIP1:
		case TYPE_FIRE_BANDIT2:
			if (state_!=ROTATING && state_!=DEAD && invulBegin==0) {
				shield_ -=5;
				if (shield_>=0)
					{
						explode= new Explosion(this,5,1,0);
						mlist->Add(explode);
						state_=ROTATING;
						rotate_= 0;
					}
			}
			break;
		case TYPE_DIAMOND: 
			{
				Diamond *diamond = (Diamond*)contact;
				SpritePlaySample(SAMPLE_POWERUP);
				Sprite *specialEffect = new SpecialEffect1(this, diamond->getType());
				mlist->Add(specialEffect);
			
				if (diamond->getType()==Diamond::POWER) {
					shield_+=shieldMax_/6;
					if (shield_>shieldMax_) {
						shield_=shieldMax_;
					}
				} else if (diamond->getType()==Diamond::BOMB){
					bomb_++;            
				} else if (diamond->getType()==Diamond::POWERUP){
					powerUp_++;
				} else {
					if (invulBegin == 0 ) {
						invulBegin = glutGet((GLenum)GLUT_ELAPSED_TIME);  
						invulEnd = invulBegin + 1000*20;
					} else {
						invulEnd += 1000*20;
					}
					
				}
			}
			break;
	
		}
}
