/*
Copyright (C) 2002 Xavier Hosxe <xhosxe@free.fr>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "listsprite.hpp"

#include "fire.hpp"
#include "explosion.hpp"
#include "scene.hpp"

#include "modeles/fire3.c"



MyFire1::MyFire1(MyShip *myShip)
: Sprite(myShip->getList(),
         TYPE_MY_FIRE1,
         myShip->getX(),
         myShip->getY(),
         myShip->getZ()+.8)
{
    dz_=1.2;
    //  dx_=myShip->getDx()*3;
    state_=NORMAL;
    sizex_ = .2;
    sizey_ = .2;
    sizez_ = .5;
    myship_ = myShip;
}

MyFire1::MyFire1(MyShip *myShip, float dx, float dz)
: Sprite(myShip->getList(),
         TYPE_MY_FIRE1,
         myShip->getX(),
         myShip->getY(),
         myShip->getZ()+.8)
{
    dz_=dz;
    dx_=dx;
    x_+=dx*5;
    state_=NORMAL;
    sizex_ = .2;
    sizey_ = .2;
    sizez_ = .2;
    myship_ = myShip;
}

void MyFire1::score(int score) {
//   myship_->score(score);
   if (GLvar->mySpaceShip!=NULL)
      ((MyShip*)GLvar->mySpaceShip)->score(score);
}


void MyFire1::drawShadowable()
{
    glPushMatrix();
          
    glTranslatef(x_ , y_ , z_);
    
    glBegin(GL_QUAD_STRIP);
    
    glVertex3f(-.1 ,0,-.3);
    glVertex3f(-.1 ,0,.3);

    glVertex3f(0 ,0,-.3);
    glVertex3f(0 ,0,.3);
    
    glVertex3f(.1 ,0,-.3);
    glVertex3f(.1 ,0,.3);
    
    glEnd();

    glPopMatrix();
}


void MyFire1::draw()
{
    
    glPushMatrix();
       
    glTranslatef(x_ , y_ , z_);   
   
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBegin(GL_QUAD_STRIP);
    
    glColor4f(1 , 1 , 0 , 0);
    glVertex3f(-.1 ,0,-.3);
    glVertex3f(-.1 ,0,.3);

    glColor4f(1 , 1 , 0 , 1);
    glVertex3f(0 ,0,-.3);
    glVertex3f(0 ,0,.3);
    
    glColor4f(1 , 1 , 0 , 0);
    glVertex3f(.1 ,0,-.3);
    glVertex3f(.1 ,0,.3);
    
    glEnd();
    
    glPopMatrix();   
}

void MyFire1::collision(Sprite*contact) 
{
    switch(contact->getType())
    {
    case TYPE_POTO:
    case TYPE_FIRE_SHIP1:
    case TYPE_FIRE_TANK:
    case TYPE_SHIP1:
    case TYPE_TANK:
    case TYPE_BANDIT2:
    case TYPE_SCRATCHER:
    case TYPE_CUBE:
    case TYPE_DIAMOND:
        Explosion *explode;
        explode= new Explosion(this,1,0,0);
        mlist->Add(explode);
        
        dead_=1;
        break;
      
    }
}

void MyFire1::move(){
    // z_+=dz_;
    // x_+=dx_;
    Sprite::move();
    
    
    if (z_>70 || z_<-5)
    {
        dead_=1;
    }
}


// ============== Fire2 ==============



MyFire2::MyFire2(MyShip *myShip)
: Sprite(myShip->getList(),
         TYPE_MY_FIRE2,
         myShip->getX(),
         myShip->getY(),
         myShip->getZ()+.5)
{
    state_=NORMAL;
    sizex_ = .2;
    sizey_ = 1;
    sizez_ = .2;
    rotate_=0;
    myship_ = myShip;
}
void MyFire2::drawShadowable()
{
}

void MyFire2::score(int score) {
//   myship_->score(score);
   if (GLvar->mySpaceShip!=NULL)
      ((MyShip*)GLvar->mySpaceShip)->score(score);
}

void MyFire2::draw()
{     
    glDisable(GL_TEXTURE_2D);
    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->jaune_diffuse);
    glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,GLvar->jaune_diffuse);
   
//    drawShadowable2();
    float t2 = sizex_/2+1;
    int i;

    for (i=0;i<360;i+=72) {
        glPushMatrix();
        glTranslatef(x_ , y_ , z_);
        glRotatef(rotate_,0,1,0);       
        
        glRotatef(i,0,1,0);
        glTranslatef(t2,.3,0);
        
        glutSolidSphere(.3,4,4);
        glPopMatrix();
    }


    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->lm_diffuse);
    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, GLvar->lm_ambient);
    glEnable(GL_TEXTURE_2D);

    
}

void MyFire2::collision(Sprite*contact) 
{
/*    switch(contact->getType())
    {
    case TYPE_TANK:
        myship_->incScore(400);
    case TYPE_SHIP1:
        myship_->incScore(100);
        break;
    case TYPE_CUBE:
        myship_->incScore(50);
        break;
    }
*/
}

void MyFire2::move()
{
    switch(state_)
    {
    case NORMAL:
        sizex_+=.2*GLvar->global_timeadjustment;
        sizez_+=.2*GLvar->global_timeadjustment;
        
        rotate_+=((10*GLvar->global_timeadjustment)>45?45:10*GLvar->global_timeadjustment);
        if (sizex_>15)
        {
            state_ = UNTOUCHABLE;
        }
        break;
    case UNTOUCHABLE:
        rotate_+=((6*GLvar->global_timeadjustment)>45?45:6*GLvar->global_timeadjustment);
        
        dz_+=.05*GLvar->global_timeadjustment;
        Sprite::move();
        //z_+=dz_;
        if (z_>70)
        {
            dead_=1;
        }
        break;
    }
}



// =============== My fire 3


int MyFire3::m_nCubeList;

MyFire3::MyFire3(MyShip *myShip, float offsetX)
: Sprite(myShip->getList(),
         TYPE_MY_FIRE1,
         myShip->getX()+offsetX,
         myShip->getY(),
         myShip->getZ()+.2)
{
    toShot_=((ListSprite*)mlist)->getAnEnemy();
    if (toShot_!=NULL) {
        if (!toShot_->addListeningSprite(this)) {
            toShot_=NULL;
        }
    }
    if (toShot_==NULL) {
        maxx_=0;
        maxz_=.4;
    }
    state_=NORMAL;
    sizex_ = .2;
    sizey_ = 1;
    sizez_ = .2;
    myship_ = myShip;

}

void MyFire3::initList()
{
    int i,j;
	 // average normal.....
	 int nbVertex = 68*3;
	 int *bTested = new int[nbVertex];
	 for (i=0;i<nbVertex;i++) {
		 bTested[i] = 0;
	 }
	 int nb;
	 GLfloat aNormal[3];
	 for (i=0;i<nbVertex;i++) {
		 if (bTested[i]==0) {
			 bTested[i] = 2;
			 nb=1;
			 aNormal[0] = fire3_meshes[i*8+3];
			 aNormal[1] = fire3_meshes[i*8+4];
			 aNormal[2] = fire3_meshes[i*8+5];
			 for (j=i+1;j<nbVertex;j++) {
				 if ((bTested[j]==0) && ((fire3_meshes[i*8+0]-fire3_meshes[j*8+0])<.01)  && ((fire3_meshes[i*8+1]-fire3_meshes[j*8+1])<.01) && ((fire3_meshes[i*8+2]-fire3_meshes[j*8+2])<.01) && ((fire3_meshes[i*8+0]-fire3_meshes[j*8+0])>-.01)  && ((fire3_meshes[i*8+1]-fire3_meshes[j*8+1])>-.01) && ((fire3_meshes[i*8+2]-fire3_meshes[j*8+2])>-.01) ) {
					 bTested[j]=2;
					 nb++;
					 aNormal[0]+= fire3_meshes[j*8+3];
					 aNormal[1]+= fire3_meshes[j*8+4];
					 aNormal[2]+= fire3_meshes[j*8+5];
				 }
			 }
			 aNormal[0] /= nb;
			 aNormal[1] /= nb;
			 aNormal[2] /= nb;
			 for (j=i;j<nbVertex;j++) {
				 if (bTested[j]==2)  {
					 fire3_meshes[j*8+3] = aNormal[0];
					 fire3_meshes[j*8+4] = aNormal[1];
					 fire3_meshes[j*8+5] = aNormal[2];
					 bTested[j]=1;
				 }
			 }	 
		 }
	 }
   
    

    for (i=0;i<68;i++) {
        fire3_meshes[i*24]/=800;
        fire3_meshes[i*24+1]/=800;
        fire3_meshes[i*24+2]/=800;
        
        fire3_meshes[i*24+8]/=800;
        fire3_meshes[i*24+1+8]/=800;
        fire3_meshes[i*24+2+8]/=800;
        
        fire3_meshes[i*24+16]/=800;
        fire3_meshes[i*24+1+16]/=800;
        fire3_meshes[i*24+2+16]/=800;
    }
    
    m_nCubeList  = glGenLists(2);
    
    glNewList(m_nCubeList,GL_COMPILE);
    {
		glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_NORMAL_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        glVertexPointer(3,GL_FLOAT,32,fire3_meshes); 
        glNormalPointer(GL_FLOAT,32,fire3_meshes+3); 
        glTexCoordPointer(2,GL_FLOAT,32,fire3_meshes+6);
        
        glDrawArrays(GL_TRIANGLES,0,67*3+2);
        
        glDisableClientState(GL_VERTEX_ARRAY);
        glDisableClientState(GL_NORMAL_ARRAY);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
    }
    glEndList();
    glNewList(m_nCubeList+1,GL_COMPILE);
    {
		Scene::getScene()->createCube(.1,.1,.35);
    }
    glEndList();
    delete []bTested;
}

void MyFire3::drawShadowable()
{
	
    float tetay;
    if (dx_==0) {
        if (dz_>=0) tetay=-90;
        else tetay=90;
    } else {
        tetay = (atan(dz_/-dx_))/6.2831852*360;
    }
    if (dx_<0)
    {
        tetay = 180+tetay;
    }

    glPushMatrix();
       
    glTranslatef(x_ , y_ , z_);
    glRotatef(tetay+90, 0,1,0);

	glCallList((GLvar->details<2)?m_nCubeList+1:m_nCubeList);
    glPopMatrix();

}

void MyFire3::draw()
{
    float tetay;
    if (dx_==0) {
        if (dz_>=0) tetay=-90;
        else tetay=90;
    } else {
        tetay = (atan(dz_/-dx_))/6.2831852*360;
    }
    if (dx_<0)
    {
        tetay = 180+tetay;
    }

	if (GLvar->details>0) {
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_fire3);
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, GLvar->blanc_diffuse);
		glDisable(GL_BLEND);
		glEnable(GL_LIGHTING);

		glPushMatrix();
       
		glTranslatef(x_ , y_ , z_);
		glRotatef(tetay+90, 0,1,0);
		glCallList(m_nCubeList);
	    glDisable(GL_TEXTURE_2D);
	    glEnable(GL_BLEND);
	    glDisable(GL_LIGHTING);
		glDisable(GL_CULL_FACE);
	} else {
		glColor4f(1,.7,0,1);
		glPushMatrix();
		glDisable(GL_CULL_FACE);      
		glTranslatef(x_ , y_ , z_);
		glRotatef(tetay+90, 0,1,0);
		glCallList(m_nCubeList+1);
	}
    

    glDepthMask(GL_FALSE);

    glTranslatef(0,0,-.2);
    glBegin(GL_TRIANGLE_FAN);
    glColor4f(1,0,0,1);
    glVertex3f(0,0,0);

    glColor4f(1,1,0,0);
    glVertex3f(-.03,0,0);
    glVertex3f(0,0, -(dx_*dx_+dz_*dz_)*10-.5-((float)(random()&16) /16-.5));
    glVertex3f(.03,0,0);
    glEnd();

	if (GLvar->details>1) {
		glBegin(GL_TRIANGLE_FAN);
		glColor4f(1,0,0,1);
		glVertex3f(0,0,0);

		glColor4f(1,1,0,0);
		glVertex3f(0,-.03,0);
		glVertex3f(0,0, -(dx_*dx_+dz_*dz_)*10-.5-((float)(random()&16) /16-.5));
		glVertex3f(0,0.03,0);
		glEnd();
	}
    glDepthMask(GL_TRUE);


    glPopMatrix();
	glEnable(GL_CULL_FACE);

}

void MyFire3::collision(Sprite*contact) 
{
    switch(contact->getType())
    {
    case TYPE_POTO:
    case TYPE_FIRE_SHIP1:
    case TYPE_FIRE_TANK:
    case TYPE_SHIP1:
    case TYPE_TANK:
    case TYPE_BANDIT2:
    case TYPE_SCRATCHER:
    case TYPE_CUBE:
        Explosion *explode;
        explode= new Explosion(this,2,0);
        mlist->Add(explode);
        
        dead_=1;
        break;
    }
}

void MyFire3::move(){
    Sprite::move();
    
    if (x_<-40 || x_>40 || z_>80 || z_<0) {
        dead_=1;
    }
    
    if (toShot_!=NULL) {
    
        static const float v=.4;
        float deltaX = toShot_->getX()-x_;
        float deltaZ = toShot_->getZ()-z_;
        float square = deltaX*deltaX+deltaZ*deltaZ;
        if (square==0) {
            return;
        }
        float alpha = (float)sqrt(v * v/square);
        maxx_ = alpha * deltaX;
        maxz_ = alpha * deltaZ;
    }
    
    if (dx_<maxx_) dx_+=.005*GLvar->global_timeadjustment;
    if (dx_>maxx_) dx_-=.005*GLvar->global_timeadjustment;
    if (dz_<maxz_) dz_+=.005*GLvar->global_timeadjustment;
    if (dz_>maxz_) dz_-=.005*GLvar->global_timeadjustment;
    
}


void MyFire3::receiveEvent(Sprite*sprite) {
    //  printf("f3 - I'm 0x%x and my target 0x%x is dead...\n", this,sprite);
    //    if (toShot_!=sprite) printf("################## AAARRRGGGHHH !!!##############\n");
    toShot_=((ListSprite*)mlist)->getAnEnemy();
    if (toShot_!=NULL) {
        if (!toShot_->addListeningSprite(this)) {
            toShot_=NULL;
            maxx_=0;
            maxz_=.4;
        }
    }
}

void MyFire3::iJustDied() {
    //  printf("f3 - I'm 0x%x just died and i want 0x%x to remove me\n",this, toShot_);
    if (toShot_!=NULL) {
        toShot_->removeListeningSprite(this);
    } 
}

void MyFire3::score(int score) {
//   myship_->score(score);
   if (GLvar->mySpaceShip!=NULL)
      ((MyShip*)GLvar->mySpaceShip)->score(score);
}



// FIRE 4 =============================



MyFire4::MyFire4(MyShip *myShip, float dx, float dz)
: Sprite(myShip->getList(),
         TYPE_MY_FIRE4,
         myShip->getX(),
         myShip->getY()-.35,
         myShip->getZ()+.8)
{
    dz_= dz;
    dx_=dx;
//  x_+=dx*5;
    state_=NORMAL;
    sizex_ = .2;
    sizey_ = .2;
    sizez_ = .6;
    myship_ = myShip;
	 MyFire4Smoke *smoke= new MyFire4Smoke(this);
	 mlist->Add(smoke);
}

void MyFire4::score(int score) {
//   myship_->score(score);
   if (GLvar->mySpaceShip!=NULL)
      ((MyShip*)GLvar->mySpaceShip)->score(score);
}


void MyFire4::drawShadowable()
{
    glPushMatrix();
          
    glTranslatef(x_ , y_ , z_);
    glRotatef(z_*70*(dx_<0?-1:1),1,1,0);       
    
    glBegin(GL_QUAD_STRIP);
    
    glVertex3f(-.1 ,0,-.15);
    glVertex3f(-.1 ,0,.15);

    glVertex3f(0 ,0,-.15);
    glVertex3f(0 ,0,.15);
    
    glVertex3f(.1 ,0,-.15);
    glVertex3f(.1 ,0,.15);
    glEnd();

    glPopMatrix();
}


void MyFire4::draw()
{
    
    glPushMatrix();
       
    glTranslatef(x_ , y_ , z_);
    glRotatef(z_*70*(dx_<0?-1:1),0,1,0);       
   
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBegin(GL_QUAD_STRIP);
    
    glColor4f(1 , .5 , .2 , 0);
    glVertex3f(-.1 ,0,-.15);
    glVertex3f(-.1 ,0,.15);

    glColor4f(1 , .5 , .2 , 1);
    glVertex3f(0 ,0,-.15);
    glVertex3f(0 ,0,.15);
    
    glColor4f(1 , .5 , .2 , 0);
    glVertex3f(.1 ,0,-.15);
    glVertex3f(.1 ,0,.15);
    
    glEnd();
    
    glPopMatrix();   
}

void MyFire4::collision(Sprite*contact) 
{
    switch(contact->getType())
    {
    case TYPE_POTO:
    case TYPE_TANK:
    case TYPE_SCRATCHER:
    case TYPE_CUBE:
    case TYPE_TACHE:
        Explosion *explode;
        explode= new Explosion(this,1,0,0);
        mlist->Add(explode);
        
        dead_=1;
        break;
       
    }
}

void MyFire4::move(){
    // z_+=dz_;
    // x_+=dx_;
    Sprite::move();
    
    
    if (z_>70 || z_<-5)
    {
        dead_=1;
    }
}




// ================= Fire4Smoke


MyFire4Smoke::MyFire4Smoke(MyFire4 *fire4) :
	Sprite(fire4->getList(), TYPE_SMOKE,
	0,0,0)
{
   fBegin_ = 0;
   nEnd_ = 0;
   nLastPoint_ = 0;
   xPoint_ = new float[40];
   zPoint_ = new float[40];
   dxPoint_ = new float[40];
   fire4_ = fire4;
   for (int i=0; i<40; i++) {
		dxPoint_[i]= ((float)(random()&256))/2560.0f-.05f;
	}
	xPoint_[0]=  fire4->getX();
	zPoint_[0] = fire4->getZ();
   fire4->addListeningSprite(this);
   state_=NORMAL;
}

MyFire4Smoke::~MyFire4Smoke() {
   delete [] xPoint_;
   delete [] zPoint_;
   delete [] dxPoint_;
}

void MyFire4Smoke::drawShadowable() {
	int i;

	if (GLvar->details==0) {
		return;
	}
	glPushMatrix();
	glColor4f(0,0,0, .5);
	glBegin(GL_QUAD_STRIP);

	for (i=(int)fBegin_; i<=nEnd_; i++) {

		glColor4f(0,0,0, .35f-.35f*(float)(nEnd_-i)/(nEnd_-fBegin_)); 
//	    glColor4f(0,0,0, .5);
		glVertex3f(xPoint_[i]+0.06	,.15,zPoint_[i]); 
		glVertex3f(xPoint_[i]-0.06	,.15,zPoint_[i]); 
	}
	if (fire4_!=NULL) {
		glColor4f(0,0,0, .35);
		glVertex3f(fire4_->getX()+0.06	,.15,fire4_->getZ()); 
		glVertex3f(fire4_->getX()-0.06	,.15,fire4_->getZ()); 
	}

	glEnd();
	glColor4f(0,0,0,.35);

	glPopMatrix();

}

void MyFire4Smoke::draw() {
	int i;
	float dx, dy;
    
    glPushMatrix();

    glDisable(GL_LIGHTING);
    glEnable(GL_BLEND);    
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	 
    glBindTexture(GL_TEXTURE_2D, GLvar->texture_thunder);

	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GREATER, .25);
    glBegin(GL_QUAD_STRIP);

	for (i=(int)fBegin_; i<=nEnd_; i++) {
//		printf("0x%x begin : %d: %f\n" ,this,i, xPoint_[i] ); 
		if (i!=1 && i!=nEnd_) {
			dx= ((random()%100)/1000.0f);
			dy= ((random()%100)/1000.0f);
		} else {
			dx= 0;
			dy= 0;
		}

	    glColor4f(1,1,.5 , 1.0f-(float)(nEnd_-i)/(nEnd_-(fBegin_))); 
		if (i%2 == 0) {
			glTexCoord2f(1,0);
		} else {
			glTexCoord2f(1,1);
		}
		glVertex3f(xPoint_[i]+dx+0.06	,.15+dy,zPoint_[i]); 
		if (i%2 == 0) {
			glTexCoord2f(0,0);
		} else {
			glTexCoord2f(0,1);
		}
		glVertex3f(xPoint_[i]+dx-0.06	,.15+dy,zPoint_[i]); 
	}
	if (fire4_!=NULL) {
		if ((nEnd_+1)%2 == 0) {
			glTexCoord2f(1,0);
		} else {
			glTexCoord2f(1,1);
		}
		glVertex3f(fire4_->getX()+0.06	,.15,fire4_->getZ()); 
		glColor4f(1,1,.5 , 1);
		if ((nEnd_+1)%2 == 0) {
			glTexCoord2f(0,0);
		} else {
			glTexCoord2f(0,1);
		}
		glVertex3f(fire4_->getX()-0.06	,.15,fire4_->getZ()); 
	}

    glEnd();

	glDisable(GL_CULL_FACE);


	if (GLvar->details>1) {
	    glBegin(GL_QUAD_STRIP);
		for (i=(int)fBegin_; i<=nEnd_; i++) {
	//		printf("0x%x begin : %d: %f\n" ,this,i, xPoint_[i] ); 
			if (i!=1 && i!=nEnd_) {
				dx= ((random()%100)/1000.0f);
				dy= ((random()%100)/1000.0f);
			} else {
				dx= 0;
				dy= 0;
			}

			glColor4f(1,1,.5 , 1.0f-(float)(nEnd_-i)/(nEnd_-(fBegin_))); 
			if (i%2 == 0) {
				glTexCoord2f(1,0);
			} else {
				glTexCoord2f(1,1);
			}
			glVertex3f(xPoint_[i]+dx	,.15+dy+0.06,zPoint_[i]); 
			if (i%2 == 0) {
				glTexCoord2f(0,0);
			} else {
				glTexCoord2f(0,1);
			}
			glVertex3f(xPoint_[i]+dx	,.15+dy-0.06,zPoint_[i]); 
		}
		if (fire4_!=NULL) {
			if ((nEnd_+1)%2 == 0) {
				glTexCoord2f(1,0);
			} else {
				glTexCoord2f(1,1);
			}
			glVertex3f(fire4_->getX()	,.15+0.06,fire4_->getZ()); 
			glColor4f(1,1,.5 , 1);
			if ((nEnd_+1)%2 == 0) {
				glTexCoord2f(0,0);
			} else {
				glTexCoord2f(0,1);
			}
			glVertex3f(fire4_->getX()	,.15-0.06,fire4_->getZ()); 
		}

		glEnd();
	}
	glDisable(GL_ALPHA_TEST);
	glEnable(GL_CULL_FACE);


    glEnable(GL_LIGHTING);
    glDisable(GL_BLEND);    
    glPopMatrix();

}

void MyFire4Smoke::move() {

//	printf("0x%x Move....", this);

	if (nEnd_>2 || fire4_==NULL) {
		fBegin_ += .1*GLvar->global_timeadjustment;	
//		if (fire4_==NULL)
//			printf("..fBegin : %f, nEnd : %d\n", fBegin_, nEnd_);
	}

	if (fBegin_>nEnd_+1) {
//		printf("fBegin : %f, nEnd : %d\n", fBegin_, nEnd_);
//		printf("DEAD ....\n");
		dead_=1;
		return;
	}

	if (fire4_!=NULL) {
		if ((fire4_->getZ() - zPoint_[0]) / 2 > nEnd_+1) {
			nEnd_++;
			zPoint_[nEnd_] = fire4_->getZ() ; //+ (random()&1024)/341.0f - 1.5f;
			xPoint_[nEnd_] = fire4_->getX();
		}
	}


	if (GLvar->myRandom(4)) {
		int start = fBegin_<1.0f? 1:fBegin_;
		for (int k =start; k<nEnd_; k++) {
			xPoint_[k] += (float)(random()%100-50.0f)/800.0f ;
			if (xPoint_[k]>xPoint_[k-1]+.4) xPoint_[k]=xPoint_[k-1]+.4;
			if (xPoint_[k]<xPoint_[k-1]-.4) xPoint_[k]=xPoint_[k-1]-.4;
			if (xPoint_[k]>xPoint_[k+1]+.4) xPoint_[k]=xPoint_[k+1]+.4;
			if (xPoint_[k]<xPoint_[k+1]-.4) xPoint_[k]=xPoint_[k+1]-.4;
		}
	}

}


void MyFire4Smoke::receiveEvent(Sprite*sprite) {
	fire4_ = NULL;
//	printf("AOUCH !!\n");
}

void MyFire4Smoke::collision(Sprite*contact) {
}


void MyFire4Smoke::iJustDied() {
    //  printf("f3 - I'm 0x%x just died and i want 0x%x to remove me\n",this, toShot_);
    if (fire4_!=NULL) {
        fire4_->removeListeningSprite(this);
    } 
}
