/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __FIGHTER2__
#define __FIGHTER2__


#include <stdlib.h>
#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"

class Fighter2Fire ;

class Fighter2 : public Sprite {
    friend class Fighter2Fire;
public:
    enum state {
        ARRIVING,
            MOVING1,
            MOVING2,
            LEAVING
    };
    Fighter2(List *list, float x,float z,float speed, int shield);
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);
    static void initList();
    static int list_;
protected:
    int state_;
    int shield_;
    float speed_;
    float centerX_,centerZ_;
    float rayX_,rayZ_;
    int turnsLeft_;
    int position_;
    Sprite* toFollo_;
    float rotate_;
};




class Fighter2Fire : public Sprite {
public:
    Fighter2Fire(List *list, Fighter2 *ship1)
        : Sprite(list,TYPE_FIRE_BANDIT2 ,ship1->x_,ship1->y_,ship1->z_)
    {
        sizez_=.2;
        sizey_=.2;
        sizex_=.2;
        dz_=-.5;
    }
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);
    
protected:
    float tetay_;
};

#endif



