/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __EXPLOSION__
#define __EXPLOSION__

#include "sprite.hpp"
#include "myship.hpp"
#include "diamond.hpp"

class Explosion : public Sprite {
public:
    Explosion(Sprite *sprite, int size, int sound = 1,int pieces = 1, float x=99, float y=99, float z=99);
    void draw();
    void collision(Sprite*contact);
    void move();
    type_sprites getFrom() { return from_ ; }
protected:
    int nSmoke;
    float currentSize_;
    float x1_,x2_,x3_,x4_,r1_;
    type_sprites from_;
    int pieces_;
};

class PieceOfShip : public Sprite {
public :
    PieceOfShip(Sprite *sprite, int size);
    ~PieceOfShip();
    void draw();
    void drawShadowable();
    void collision(Sprite*contact);
    void move();
protected:
    float *ax_;
    float *ay_;
    float *az_;
    float *adx_;
    float *ady_;
    float *adz_;
    float *acolor_;
    float *asizex_;
    float *asizey_;
    float *aalpha_;
    float *arotate_;
    int *atexture_;
    int  cptAlive_;
    int*atype_;
    short *alive_;
    int size_;
    type_sprites from_;
	int fumee1;
	float period_ ;
};

class ExplosionJustSmoke : public Sprite {
public:
    ExplosionJustSmoke(Sprite *sprite, float size);
    ExplosionJustSmoke(Sprite *sprite,float x, float y, float z, float size);
    void draw();
    void collision(Sprite*contact);
    void move();
protected:
    int nSmoke;
    float currentSize_;
    float x1_,x2_,x3_,x4_,r1_;
};
class ExplosionMark : public Sprite {
public:
    ExplosionMark(Sprite *sprite, int size);
    void draw();
    void collision(Sprite*contact);
    void move();
protected:
    float size_;
};



class SpecialEffect1 : public Sprite {
public:
	 SpecialEffect1(Sprite *sprite, Diamond::Type type);
    ~SpecialEffect1();
    void draw();
    void collision(Sprite*contact);
    void move();
    void receiveEvent(Sprite*sprite);
    void iJustDied();
protected:
	float maxLife_;
 	 Sprite *toFollow_;
 	 int nPart_;
 	 float currentTime;
	float *pX_, *pY_, *pZ_, *life_;
	Diamond::Type diamondType_ ;

};

#endif 

