/*
  Copyright (C) 2000/2002 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
    
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <GL/glut.h>

#include "bandit2.hpp"
#include "fire.hpp"
#include "modeles/bandit2.c"


#define ABS(x) (x<0?-x:x)
#define SIGN(x) (x<0?-1:1)

int Bandit2::list_;


Bandit2::Bandit2(List *list, float x,float z,float speed, int shield)
: Sprite(list,TYPE_BANDIT2 ,x,.5,z)
{
    int nb=random()%5;
    state_=ARRIVING;
    sizex_ = 1.2;
    sizey_ = 1;
    sizez_ = 1.8;
    rotate_=180;
    position_=1;
    shield_= shield;
    speed_=speed;
    bRealEnemy=true;
}

void Bandit2::initList()
{
    int i,j;
	 // average normal.....
	 int nbVertex = 136*3;
	 int *bTested = new int[nbVertex];
	 for (i=0;i<nbVertex;i++) {
		 bTested[i] = 0;
	 }
	 int nb;
	 GLfloat aNormal[3];
	 for (i=0;i<nbVertex;i++) {
		 if (bTested[i]==0) {
			 bTested[i] = 2;
			 nb=1;
			 aNormal[0] = bandit2_meshes[i*8+3];
			 aNormal[1] = bandit2_meshes[i*8+4];
			 aNormal[2] = bandit2_meshes[i*8+5];
			 for (j=i+1;j<nbVertex;j++) {
				 if ((bTested[j]==0) && ((bandit2_meshes[i*8+0]-bandit2_meshes[j*8+0])<.01)  && ((bandit2_meshes[i*8+1]-bandit2_meshes[j*8+1])<.01) && ((bandit2_meshes[i*8+2]-bandit2_meshes[j*8+2])<.01) && ((bandit2_meshes[i*8+0]-bandit2_meshes[j*8+0])>-.01)  && ((bandit2_meshes[i*8+1]-bandit2_meshes[j*8+1])>-.01) && ((bandit2_meshes[i*8+2]-bandit2_meshes[j*8+2])>-.01) ) {
					 bTested[j]=2;
					 nb++;
					 aNormal[0]+= bandit2_meshes[j*8+3];
					 aNormal[1]+= bandit2_meshes[j*8+4];
					 aNormal[2]+= bandit2_meshes[j*8+5];
				 }
			 }
			 aNormal[0] /= nb;
			 aNormal[1] /= nb;
			 aNormal[2] /= nb;
			 for (j=i;j<nbVertex;j++) {
				 if (bTested[j]==2)  {
					 bandit2_meshes[j*8+3] = aNormal[0];
					 bandit2_meshes[j*8+4] = aNormal[1];
					 bandit2_meshes[j*8+5] = aNormal[2];
					 bTested[j]=1;
				 }
			 }	 
		 }
	 }
   
    

    for (i=0;i<136;i++) {
        bandit2_meshes[i*24]/=100;
        bandit2_meshes[i*24+1]/=100;
        bandit2_meshes[i*24+2]/=100;
        
        bandit2_meshes[i*24+8]/=100;
        bandit2_meshes[i*24+1+8]/=100;
        bandit2_meshes[i*24+2+8]/=100;
        
        bandit2_meshes[i*24+16]/=100;
        bandit2_meshes[i*24+1+16]/=100;
        bandit2_meshes[i*24+2+16]/=100;
    }
    
    list_ = glGenLists(1);
    
    glNewList(list_,GL_COMPILE);
    {
        glTranslatef(0,.2,0);
        glRotatef(90,0,1,0);
        glRotatef(90,1,0,0);
        glRotatef(180,0,1,0);
        
        
        glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_NORMAL_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        glVertexPointer(3,GL_FLOAT,32,bandit2_meshes); 
        glNormalPointer(GL_FLOAT,32,bandit2_meshes+3); 
        glTexCoordPointer(2,GL_FLOAT,32,bandit2_meshes+6);
        
        glDrawArrays(GL_TRIANGLES,0,135*3+2);
        
        glDisableClientState(GL_VERTEX_ARRAY);
        glDisableClientState(GL_NORMAL_ARRAY);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
    }
    glEndList();
	 delete []bTested;
}

void Bandit2::drawShadowable()
{
    glPushMatrix();
    glTranslatef(x_,y_,z_);
    glRotatef(-dx_*100,0,0,1);
    glRotatef(dy_*100,1,0,0);

    glCallList(list_);
    
    glPopMatrix();    
}

void Bandit2::draw()
{
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, GLvar->texture_bandit2);
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, GLvar->blanc_diffuse);
    glDisable(GL_BLEND);
    glEnable(GL_LIGHTING);
    drawShadowable();
}


void Bandit2::move()
{
    Bandit2Fire *fire;
    switch(state_) {
    case ARRIVING:
        dz_-=.012*GLvar->global_timeadjustment;
        if (z_<14) {
            state_=MOVING1;
        }
        goto _moveX;
    case MOVING1:
        dz_+=.012*GLvar->global_timeadjustment;
        if (z_>40) {
            state_=MOVING2;
        }
        goto _moveX;
        
    case MOVING2:
        dz_-=.012;
        if (z_<13) {
            Bandit2Fire *fire;
            state_=LEAVING;
            fire= new Bandit2Fire(mlist, this);
            mlist->Add(fire);
        }
_moveX:
        if (GLvar->mySpaceShip!=NULL) {
            if (GLvar->mySpaceShip->getX()>x_-2.0f*speed_) {
                dx_+=.004*GLvar->global_timeadjustment;
            } 
            if (GLvar->mySpaceShip->getX()<x_+2.0f*speed_) {
                dx_-=.004*GLvar->global_timeadjustment;
            }
        }
        if (GLvar->myRandom(128)) {
            fire= new Bandit2Fire(mlist, this);
            mlist->Add(fire);
        }
        break;
    case LEAVING:
        dy_+=.02*GLvar->global_timeadjustment;
        if (x_<0) {
            dx_-=.02*GLvar->global_timeadjustment;
        } else {
            dx_+=.02*GLvar->global_timeadjustment;
        }
        if (z_<-3) {
            dead_=1;
        }
        break;       
    }
    
    if (dz_<-.5f*speed_) dz_=-.5f*speed_;
    if (dz_>.5f*speed_) dz_=.5f*speed_;
    
    if (dx_<-.2f*speed_) dx_=-.2f*speed_;
    if (dx_>.2f*speed_) dx_=.2f*speed_;
    
    //  printf("dz = %f\n" , dz_);
    
    Sprite::move();
}


void Bandit2::collision(Sprite*contact)
{
    
    switch(contact->getType())
    {
    case TYPE_BANDIT2:
        if (x_-contact->getX()>0) {
            dx_+=.04;
        } else {
            dx_-=.04;
        }
        if (z_-contact->getZ()>0) {
            dz_+=.04;
        } else {
            dz_-=.04;
        }
        break;
    case TYPE_CUBE:
        //        dx_=-dx_;
        break;
    case TYPE_MY_FIRE2:
    case TYPE_MY_SPACE_SHIP:
       shield_=0;
    case TYPE_MY_FIRE1:
    case TYPE_SPIRALE:
        //    case TYPE_CUBE:
        {
            Explosion *explode;
            if ((--shield_<=0) && (dead_==0)) {
                explode= new Explosion(this,7);
                mlist->Add(explode);
                dead_=1;
                contact->score(100);
                
            } 
            
            break;
        }
    }   
}


/* 
+================================+
|           Bandit2Fire            |
+================================+ 
*/

void Bandit2Fire::drawShadowable()
{
    
    glPushMatrix();    
    glTranslatef(x_ , y_ , z_);
    //glRotatef(tetay_   ,0,0,1);
    
    glBegin(GL_TRIANGLE_FAN); 
    
    glVertex3f(0 ,0,0);
    
    glVertex3f(.15 , 0 ,.5); 
    glVertex3f(-.15 , 0 ,.5);
    glVertex3f(0 , .15 ,.5);
    glVertex3f(0,-.15 ,.5);
    
    glEnd();
    
    
    glPopMatrix();    
}


void Bandit2Fire::draw()
{
    
    glPushMatrix();    
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);
    glDepthMask(0);
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    
    glTranslatef(x_ , y_ , z_);
    //glRotatef(tetay_   ,0,0,1);
    
    glBegin(GL_TRIANGLE_FAN); 
    
    glColor4f(1 , 1 , 1 , 1);
    glVertex3f(0 ,0,0);
    
    glColor4f(1 , 1 ,0 , 0.0);
    glVertex3f(.15 , 0 ,.5); 
    glVertex3f(-.15 , 0 ,.5);
    glVertex3f(0 , .15 ,.5);
    glVertex3f(0,-.15 ,.5);
    
    glEnd();
    
    
    glDepthMask(1);
    glDisable(GL_BLEND);
    glEnable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    
    glColor4f(1,1,1,1);
    glPopMatrix();    
}


void Bandit2Fire::move()
{
    Sprite::move();
    // x_+=dx_;
    // z_+=dz_;
    
    tetay_ += (10*GLvar->global_timeadjustment)>20 ? 20:(10*GLvar->global_timeadjustment);
    
    if (tetay_>360)
        tetay_=tetay_-360;
    
    if (z_<0)
    {
        dead_=1;
    }
}


void Bandit2Fire::collision(Sprite*contact)
{  
    switch(contact->getType())
    {
    case TYPE_MY_SPACE_SHIP:
    case TYPE_MY_FIRE2:
    case TYPE_MY_FIRE1:
    case TYPE_CUBE:
        {
            Sprite *explode;
            explode= new Explosion(this,2,1,0);
            mlist->Add(explode);
            
            dead_=1;
            break;
        }
    }
}
